<?php $__env->startSection('site_title', formatTitle([__('Edit'), __('Payment'), config('settings.title')])); ?>

<?php echo $__env->make('shared.breadcrumbs', ['breadcrumbs' => [
    ['url' => request()->is('admin/*') ? route('admin.dashboard') : route('dashboard'), 'title' => request()->is('admin/*') ? __('Admin') : __('Home')],
    ['url' => request()->is('admin/*') ? route('admin.payments') : route('account.payments'), 'title' => __('Payments')],
    ['title' => __('Edit')],
]], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<h1 class="h2 mb-3 d-inline-block"><?php echo e(__('Edit')); ?></h1>

<div class="card border-0 shadow-sm">
    <div class="card-header align-items-center">
        <div class="row">
            <div class="col">
                <div class="font-weight-medium py-1"><?php echo e(__('Payment')); ?></div>
            </div>

            <div class="col-auto">
                <div class="form-row">
                    <div class="col">
                        <?php echo $__env->make('account.payments.partials.menu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="card-body mb-n3">
        <?php echo $__env->make('shared.message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        <form action="<?php echo e(route('admin.payments.edit', $payment->id)); ?>" method="post" enctype="multipart/form-data">
            <?php echo csrf_field(); ?>
            <div class="row">
                <div class="col-12 col-lg-6 mb-3">
                    <div class="text-muted"><?php echo e(__('Plan')); ?></div>
                    <div><?php echo e($payment->product->name); ?></div>
                </div>

                <div class="col-12 col-lg-6 mb-3">
                    <div class="text-muted"><?php echo e(__('Payment ID')); ?></div>
                    <div><?php echo e($payment->payment_id); ?></div>
                </div>

                <div class="col-12 col-lg-6 mb-3">
                    <div class="text-muted"><?php echo e(__('Processor')); ?></div>
                    <div><?php echo e(config('payment.processors.' . $payment->processor)['name']); ?></div>
                </div>

                <div class="col-12 col-lg-6 mb-3">
                    <div class="text-muted"><?php echo e(__('Amount')); ?></div>
                    <div><?php echo e(formatMoney($payment->amount, $payment->plan->currency)); ?> <?php echo e($payment->plan->currency); ?> / <span class="text-lowercase"><?php echo e($payment->interval == 'month' ? __('Month') : __('Year')); ?></span></div>
                </div>

                <div class="col-12 col-lg-6 mb-3">
                    <div class="text-muted"><?php echo e(__('Status')); ?></div>
                    <div>
                        <?php if($payment->status == 'completed'): ?>
                            <?php echo e(__('Completed')); ?>

                        <?php elseif($payment->status == 'pending'): ?>
                            <?php echo e(__('Pending')); ?>

                        <?php else: ?>
                            <?php echo e(__('Cancelled')); ?>

                        <?php endif; ?>
                    </div>
                </div>

                <?php if((request()->is('admin/*') && in_array($payment->status, ['completed', 'cancelled'])) || $payment->status == 'completed'): ?>
                    <div class="col-12 col-lg-6 mb-3">
                        <div class="text-muted"><?php echo e(__('Invoice')); ?></div>
                        <div><a href="<?php echo e((request()->is('admin/*') ? route('admin.invoices.show', $payment->id) : route('account.invoices.show', $payment->id))); ?>"><?php echo e($payment->invoice_id); ?></a></div>
                    </div>
                <?php endif; ?>

                <div class="col-12 col-lg-6 mb-3">
                    <div class="text-muted"><?php echo e(__('Created at')); ?></div>
                    <div><?php echo e($payment->created_at->tz(Auth::user()->timezone ?? config('app.timezone'))->format(__('Y-m-d'))); ?></div>
                </div>
            </div>
        </form>
    </div>
</div>

<?php if(request()->is('admin/*')): ?>
    <?php echo $__env->make('admin.users.partials.card', ['user' => $payment->user], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php endif; ?><?php /**PATH /home/datanito/public_html/analytics.datanito.com/resources/views/account/payments/edit.blade.php ENDPATH**/ ?>