<?php if(isset($report['results'][$name])): ?>
    <div class="border-top">
        <div class="card-body">
            <div class="row">
                <div class="col">
                    <div class="row">
                        <div class="col-12 col-lg-4">
                            <div class="d-flex align-items-center">
                                <?php echo $__env->make('reports.partials.status', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                                <div class="text-truncate font-weight-medium"><?php echo e(__('SEO friendly URL')); ?></div>
                            </div>
                        </div>

                        <div class="col-12 col-lg-8">
                            <?php if($report['results'][$name]['passed']): ?>
                                <div>
                                    <?php echo e(__('The URL is SEO friendly.')); ?>

                                </div>
                            <?php else: ?>
                                <?php $__currentLoopData = $report['results'][$name]['errors']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error => $details): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="<?php echo e((!$loop->first) ? 'mt-3' : ''); ?>">
                                        <?php if($error == 'bad_format'): ?>
                                            <?php echo e(__('The URL is not SEO friendly.')); ?>

                                        <?php endif; ?>

                                        <?php if($error == 'missing'): ?>
                                            <?php echo e(__('The URL does not contain any relevant keywords.')); ?>

                                        <?php endif; ?>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php endif; ?>

                            <div class="small text-muted mt-1 text-break">
                                <?php echo e($report['results'][$name]['value']); ?>

                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-auto">
                    <a href="#collapse<?php echo e($name); ?>" class="text-secondary" data-toggle="collapse" role="button" aria-expanded="false" aria-controls="collapse<?php echo e($name); ?>" data-tooltip="true" title="<?php echo e(__('More')); ?>">
                        <?php echo $__env->make('icons.info', ['class' => 'fill-current width-4 height-4'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>&#8203;
                    </a>
                </div>
            </div>
        </div>
    </div>

    <div class="collapse<?php echo e(Auth::check() && Auth::user()->default_export_detailed ? ' d-print-block' : ''); ?>" id="collapse<?php echo e($name); ?>">
        <div class="card-body pt-0">
            <div class="alert alert-secondary mb-0">
                <?php echo e(__('The SEO friendly URLs are URLs that contain relevant keywords with the webpage\'s topic, and contain no special characters besides slashes and dashes.')); ?>


                <hr>

                <div class="row">
                    <div class="col-12 col-md">
                        <?php echo e(__('Learn more')); ?>

                    </div>
                    <div class="col-12 col-md-auto">
                        <a href="https://developers.google.com/search/docs/advanced/guidelines/url-structure" class="alert-link font-weight-medium d-flex align-items-center" target="_blank" rel="nofollow">Google <?php echo $__env->make('icons.external', ['class' => 'fill-current width-3 height-3 ' . (__('lang_dir') == 'rtl' ? 'mr-1' : 'ml-1')], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?></a>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php endif; ?><?php /**PATH /home/datanito/public_html/analytics.datanito.com/resources/views/reports/partials/seo-friendly-url.blade.php ENDPATH**/ ?>