<?php if(request()->session()->get('toast')): ?>
    <div class="position-relative position-lg-fixed z-1001 width-lg-96 top-0 <?php echo e((__('lang_dir') == 'rtl' ? 'left-0' : 'right-0')); ?>">
        <?php if(count(request()->session()->get('toast')) > 1): ?>
            <div aria-live="polite" aria-atomic="true" class="position-relative">
                <div class="toast backdrop-filter-blur fade show border-0 font-size-base mx-lg-3 shadow-sm mt-3 overflow-hidden max-width-full" role="alert" aria-live="assertive" aria-atomic="true" data-autohide="false">
                    <div class="toast-header px-1 py-2">
                        <div class="d-flex align-items-center <?php echo e((__('lang_dir') == 'rtl' ? 'pr-2 pl-3' : 'pl-2 pr-3')); ?>"><?php echo $__env->make('icons.account-tree', ['class' => 'fill-current width-4 height-4'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?></div>
                        <div class="<?php echo e((__('lang_dir') == 'rtl' ? 'ml-auto' : 'mr-auto')); ?>"><?php echo e(__('Project generated')); ?></div>
                        <button type="button" class="close d-flex align-items-center justify-content-center p-2" data-dismiss="toast" aria-label="Close">
                            <span aria-hidden="true" class="d-flex align-items-center"><?php echo $__env->make('icons.close', ['class' => 'fill-current width-4 height-4'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?></span>
                        </button>
                    </div>
                    <div class="toast-body">
                        <div class="row align-items-center">
                            <div class="col d-flex text-truncate">
                                <div class="d-flex align-items-center text-truncate">
                                    <img src="https://icons.duckduckgo.com/ip3/<?php echo e(request()->session()->get('toast')[0]->project); ?>.ico" rel="noreferrer" class="width-4 height-4 <?php echo e((__('lang_dir') == 'rtl' ? 'ml-3' : 'mr-3')); ?>">

                                    <a href="<?php echo e(route('reports', ['project' => request()->session()->get('toast')[0]->project])); ?>" dir="ltr" class="text-truncate"><?php echo e(request()->session()->get('toast')[0]->project); ?></a>

                                    <div class="badge badge-secondary <?php echo e((__('lang_dir') == 'rtl' ? 'mr-2' : 'ml-2')); ?>"><?php echo e(__(':value reports', ['value' => count(request()->session()->get('toast'))])); ?></div>
                                </div>
                            </div>
                            <div class="col-auto d-flex">
                                <div class="form-row">
                                    <div class="col">
                                        <a href="<?php echo e(route('reports', ['project' => request()->session()->get('toast')[0]->project])); ?>" class="btn btn-sm btn-primary"><?php echo e(__('View')); ?></a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        <?php else: ?>
            <?php $__currentLoopData = request()->session()->get('toast'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $report): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div aria-live="polite" aria-atomic="true" class="position-relative">
                    <div class="toast backdrop-filter-blur fade show border-0 font-size-base mx-lg-3 shadow-sm mt-3 overflow-hidden max-width-full" role="alert" aria-live="assertive" aria-atomic="true" data-autohide="false">
                        <div class="toast-header px-1 py-2">
                            <div class="d-flex align-items-center <?php echo e((__('lang_dir') == 'rtl' ? 'pr-2 pl-3' : 'pl-2 pr-3')); ?>"><?php echo $__env->make('icons.list-alt', ['class' => 'fill-current width-4 height-4'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?></div>
                            <div class="<?php echo e((__('lang_dir') == 'rtl' ? 'ml-auto' : 'mr-auto')); ?>"><?php echo e(__('Report generated')); ?></div>
                            <button type="button" class="close d-flex align-items-center justify-content-center p-2" data-dismiss="toast" aria-label="Close">
                                <span aria-hidden="true" class="d-flex align-items-center"><?php echo $__env->make('icons.close', ['class' => 'fill-current width-4 height-4'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?></span>
                            </button>
                        </div>
                        <div class="toast-body">
                            <div class="row align-items-center">
                                <div class="col d-flex text-truncate">
                                    <div class="text-truncate">
                                        <div class="d-flex align-items-center">
                                            <img src="https://icons.duckduckgo.com/ip3/<?php echo e(parse_url($report->fullUrl, PHP_URL_HOST)); ?>.ico" rel="noreferrer" class="width-4 height-4 <?php echo e((__('lang_dir') == 'rtl' ? 'ml-3' : 'mr-3')); ?>">

                                            <div class="text-truncate <?php echo e((__('lang_dir') == 'rtl' ? 'ml-2' : 'mr-2')); ?>" data-tooltip="true" title="<?php echo e($report->url); ?>">
                                                <a href="<?php echo e(route('reports.show', $report->id)); ?>" class="text-primary" dir="ltr"><?php echo e($report->url); ?></a>
                                            </div>

                                            <span class="d-flex align-items-center"><?php echo $__env->make('reports.partials.badge', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?></span>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-auto d-flex">
                                    <div class="form-row">
                                        <div class="col">
                                            <a href="<?php echo e(route('reports.show', $report->id)); ?>" class="btn btn-sm btn-primary"><?php echo e(__('View')); ?></a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        <?php endif; ?>
    </div>
<?php endif; ?><?php /**PATH /home/datanito/public_html/analytics.datanito.com/resources/views/reports/partials/toast.blade.php ENDPATH**/ ?>