<?php $__env->startSection('site_title', formatTitle([__('Billing information'), __('Settings'), config('settings.title')])); ?>

<?php echo $__env->make('shared.breadcrumbs', ['breadcrumbs' => [
    ['url' => route('admin.dashboard'), 'title' => __('Admin')],
    ['title' => __('Settings')],
]], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<h1 class="h2 mb-3 d-inline-block"><?php echo e(__('Billing information')); ?></h1>

<div class="card border-0 shadow-sm">
    <div class="card-header"><div class="font-weight-medium py-1"><?php echo e(__('Billing information')); ?></div></div>
    <div class="card-body">

        <?php echo $__env->make('shared.message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        <form action="<?php echo e(route('admin.settings', 'billing_information')); ?>" method="post" enctype="multipart/form-data">

            <?php echo csrf_field(); ?>

            <div class="form-group">
                <label for="i-billing-vendor"><?php echo e(__('Vendor')); ?></label>
                <input type="text" name="billing_vendor" id="i-billing-vendor" class="form-control<?php echo e($errors->has('billing_vendor') ? ' is-invalid' : ''); ?>" value="<?php echo e(old('billing_vendor') ?? config('settings.billing_vendor')); ?>">
                <?php if($errors->has('billing_vendor')): ?>
                    <span class="invalid-feedback" role="alert">
                        <strong><?php echo e($errors->first('billing_vendor')); ?></strong>
                    </span>
                <?php endif; ?>
            </div>

            <div class="form-group">
                <label for="i-invoice-prefix"><?php echo e(__('Invoice prefix')); ?></label>
                <input type="text" name="billing_invoice_prefix" id="i-invoice-prefix" class="form-control<?php echo e($errors->has('billing_invoice_prefix') ? ' is-invalid' : ''); ?>" value="<?php echo e(old('billing_invoice_prefix') ?? config('settings.billing_invoice_prefix')); ?>">
                <?php if($errors->has('billing_invoice_prefix')): ?>
                    <span class="invalid-feedback" role="alert">
                        <strong><?php echo e($errors->first('billing_invoice_prefix')); ?></strong>
                    </span>
                <?php endif; ?>
            </div>

            <div class="form-group">
                <label for="i-billing-address"><?php echo e(__('Address')); ?></label>
                <input type="text" name="billing_address" id="i-billing-address" class="form-control<?php echo e($errors->has('billing_address') ? ' is-invalid' : ''); ?>" value="<?php echo e(old('billing_address') ?? config('settings.billing_address')); ?>">
                <?php if($errors->has('billing_address')): ?>
                    <span class="invalid-feedback" role="alert">
                        <strong><?php echo e($errors->first('billing_address')); ?></strong>
                    </span>
                <?php endif; ?>
            </div>

            <div class="row mx-n2">
                <div class="col-12 col-md-6 px-2">
                    <div class="form-group">
                        <label for="i-billing-city"><?php echo e(__('City')); ?></label>
                        <input type="text" name="billing_city" id="i-billing-city" class="form-control<?php echo e($errors->has('billing_city') ? ' is-invalid' : ''); ?>" value="<?php echo e(old('billing_city') ?? config('settings.billing_city')); ?>">
                        <?php if($errors->has('billing_city')): ?>
                            <span class="invalid-feedback" role="alert">
                                <strong><?php echo e($errors->first('billing_city')); ?></strong>
                            </span>
                        <?php endif; ?>
                    </div>
                </div>

                <div class="col-12 col-md-3 px-2">
                    <div class="form-group">
                        <label for="i-billing-state"><?php echo e(__('State')); ?></label>
                        <input type="text" name="billing_state" id="i-billing-state" class="form-control<?php echo e($errors->has('billing_state') ? ' is-invalid' : ''); ?>" value="<?php echo e(old('billing_state') ?? config('settings.billing_state')); ?>">
                        <?php if($errors->has('billing_state')): ?>
                            <span class="invalid-feedback" role="alert">
                                <strong><?php echo e($errors->first('billing_state')); ?></strong>
                            </span>
                        <?php endif; ?>
                    </div>
                </div>

                <div class="col-12 col-md-3 px-2">
                    <div class="form-group">
                        <label for="i-billing-postal-code"><?php echo e(__('Postal code')); ?></label>
                        <input type="tel" name="billing_postal_code" id="i-billing-postal-code" class="form-control<?php echo e($errors->has('billing_postal_code') ? ' is-invalid' : ''); ?>" value="<?php echo e(old('billing_postal_code') ?? config('settings.billing_postal_code')); ?>">
                        <?php if($errors->has('billing_postal_code')): ?>
                            <span class="invalid-feedback" role="alert">
                                <strong><?php echo e($errors->first('billing_postal_code')); ?></strong>
                            </span>
                        <?php endif; ?>
                    </div>
                </div>
            </div>

            <div class="form-group">
                <label for="i-billing-country"><?php echo e(__('Country')); ?></label>
                <select name="billing_country" id="i-billing-country" class="custom-select<?php echo e($errors->has('billing_country') ? ' is-invalid' : ''); ?>">
                    <option value="" hidden disabled selected><?php echo e(__('Country')); ?></option>
                    <?php $__currentLoopData = config('countries'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($key); ?>" <?php if((old('billing_country') !== null && old('billing_country') == $key) || (config('settings.billing_country') == $key && old('billing_country') == null)): ?> selected <?php endif; ?>><?php echo e($value); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
                <?php if($errors->has('billing_country')): ?>
                    <span class="invalid-feedback" role="alert">
                        <strong><?php echo e($errors->first('billing_country')); ?></strong>
                    </span>
                <?php endif; ?>
            </div>

            <div class="form-group">
                <label for="i-billing-phone"><?php echo e(__('Phone')); ?></label>
                <input type="text" name="billing_phone" id="i-billing-phone" class="form-control<?php echo e($errors->has('billing_phone') ? ' is-invalid' : ''); ?>" value="<?php echo e(old('billing_phone') ?? config('settings.billing_phone')); ?>">
                <?php if($errors->has('billing_phone')): ?>
                    <span class="invalid-feedback" role="alert">
                        <strong><?php echo e($errors->first('billing_phone')); ?></strong>
                    </span>
                <?php endif; ?>
            </div>

            <div class="form-group">
                <label for="i-billing-vat-number"><?php echo e(__('VAT number')); ?></label>
                <input type="text" name="billing_vat_number" id="i-billing-vat-number" class="form-control<?php echo e($errors->has('billing_vat_number') ? ' is-invalid' : ''); ?>" value="<?php echo e(old('billing_vat_number') ?? config('settings.billing_vat_number')); ?>">
                <?php if($errors->has('billing_vat_number')): ?>
                    <span class="invalid-feedback" role="alert">
                        <strong><?php echo e($errors->first('billing_vat_number')); ?></strong>
                    </span>
                <?php endif; ?>
            </div>

            <button type="submit" name="submit" class="btn btn-primary"><?php echo e(__('Save')); ?></button>
        </form>

    </div>
</div><?php /**PATH /home/datanito/public_html/analytics.datanito.com/resources/views/admin/settings/billing-information.blade.php ENDPATH**/ ?>