<?php $__env->startSection('site_title', formatTitle([__('License'), __('Settings'), config('settings.title')])); ?>

<?php echo $__env->make('shared.breadcrumbs', ['breadcrumbs' => [
    ['url' => route('admin.dashboard'), 'title' => __('Admin')],
    ['title' => __('Settings')],
]], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<h1 class="h2 mb-3 d-inline-block"><?php echo e(__('License')); ?></h1>

<div class="card border-0 shadow-sm">
    <div class="card-header">
        <div class="font-weight-medium py-1">
            <?php echo e(__('License')); ?> | <a href="https://datanito.com" target="_blank">Datanito</a>
        </div>
    </div>
    <div class="card-body">
        <?php echo $__env->make('shared.message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        <form method="POST" action="<?php echo e(route('admin.settings', 'license')); ?>">
            <?php echo csrf_field(); ?>

            <div class="form-group">
                <label for="i-license-key"><?php echo e(__('License key')); ?></label>
                <input id="i-license-key" type="text" class="form-control<?php echo e($errors->has('license_key') ? ' is-invalid' : ''); ?>" placeholder="Random value" name="license_key" value="<?php echo e(old('license_key')); ?>" autofocus>
                <?php if($errors->has('license_key')): ?>
                    <span class="invalid-feedback" role="alert">
                        <strong><?php echo e($errors->first('license_key')); ?></strong>
                    </span>
                <?php endif; ?>
            </div>

            <div class="row mt-3">
                <div class="col">
                    <button type="submit" class="btn btn-primary">
                        <?php echo e(__('Save')); ?>

                    </button>
                </div>
            </div>
        </form>
    </div>
</div>
<?php /**PATH /home/datanito/public_html/analytics.datanito.com/resources/views/admin/settings/license.blade.php ENDPATH**/ ?>