<?php $__env->startSection('site_title', formatTitle([__('General'), __('Settings'), config('settings.title')])); ?>

<?php echo $__env->make('shared.breadcrumbs', ['breadcrumbs' => [
    ['url' => route('admin.dashboard'), 'title' => __('Admin')],
    ['title' => __('Settings')],
]], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<h1 class="h2 mb-3 d-inline-block"><?php echo e(__('General')); ?></h1>

<div class="card border-0 shadow-sm">
    <div class="card-header"><div class="font-weight-medium py-1"><?php echo e(__('General')); ?></div></div>
    <div class="card-body">

        <?php echo $__env->make('shared.message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        <form action="<?php echo e(route('admin.settings', 'general')); ?>" method="post" enctype="multipart/form-data">

            <?php echo csrf_field(); ?>

            <div class="form-group">
                <label for="i-title"><?php echo e(__('Title')); ?></label>
                <input type="text" name="title" id="i-title" class="form-control<?php echo e($errors->has('title') ? ' is-invalid' : ''); ?>" value="<?php echo e(old('title') ?? config('settings.title')); ?>">
                <?php if($errors->has('title')): ?>
                    <span class="invalid-feedback d-block" role="alert">
                        <strong><?php echo e($errors->first('title')); ?></strong>
                    </span>
                <?php endif; ?>
            </div>

            <div class="form-group">
                <label for="i-tagline"><?php echo e(__('Tagline')); ?></label>
                <input type="text" name="tagline" id="i-tagline" class="form-control<?php echo e($errors->has('tagline') ? ' is-invalid' : ''); ?>" value="<?php echo e(old('tagline') ?? config('settings.tagline')); ?>">
                <?php if($errors->has('tagline')): ?>
                    <span class="invalid-feedback d-block" role="alert">
                        <strong><?php echo e($errors->first('tagline')); ?></strong>
                    </span>
                <?php endif; ?>
            </div>

            <div class="form-group">
                <label for="i-index"><?php echo e(__('Custom index')); ?></label>
                <input type="text" dir="ltr" name="index" id="i-index" class="form-control<?php echo e($errors->has('index') ? ' is-invalid' : ''); ?>" value="<?php echo e(old('index') ?? config('settings.index')); ?>">
                <?php if($errors->has('index')): ?>
                    <span class="invalid-feedback d-block" role="alert">
                        <strong><?php echo e($errors->first('index')); ?></strong>
                    </span>
                <?php endif; ?>
            </div>

            <div class="form-group">
                <label for="i-paginate" class="d-inline-flex flex-wrap align-items-center"><span class="<?php echo e((__('lang_dir') == 'rtl' ? 'ml-2' : 'mr-2')); ?>"><?php echo e(__('Results per page')); ?></span><span class="badge badge-secondary"><?php echo e(__('Default')); ?></span></label>
                <select name="paginate" id="i-paginate" class="custom-select<?php echo e($errors->has('paginate') ? ' is-invalid' : ''); ?>">
                    <?php $__currentLoopData = [10, 25, 50, 100]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($value); ?>" <?php if((old('paginate') !== null && old('paginate') == $value) || (config('settings.paginate') == $value && old('paginate') == null)): ?> selected <?php endif; ?>><?php echo e($value); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
                <?php if($errors->has('paginate')): ?>
                    <span class="invalid-feedback d-block" role="alert">
                        <strong><?php echo e($errors->first('paginate')); ?></strong>
                    </span>
                <?php endif; ?>
            </div>

            <div class="form-group">
                <label for="i-locale" class="d-inline-flex align-items-center"><span class="<?php echo e((__('lang_dir') == 'rtl' ? 'ml-2' : 'mr-2')); ?>"><?php echo e(__('Language')); ?></span><span class="badge badge-secondary"><?php echo e(__('Default')); ?></span></label>
                <select name="locale" id="i-locale" class="custom-select<?php echo e($errors->has('locale') ? ' is-invalid' : ''); ?>">
                    <?php $__currentLoopData = config('app.locales'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $code => $language): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($code); ?>" <?php if((old('locale') !== null && old('locale') == $code) || (config('settings.locale') == $code && old('locale') == null)): ?> selected <?php endif; ?>><?php echo e($language['name']); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
                <?php if($errors->has('locale')): ?>
                    <span class="invalid-feedback d-block" role="alert">
                        <strong><?php echo e($errors->first('locale')); ?></strong>
                    </span>
                <?php endif; ?>
            </div>

            <div class="form-group">
                <label for="i-timezone"><?php echo e(__('Timezone')); ?></label>
                <select name="timezone" id="i-timezone" class="custom-select<?php echo e($errors->has('timezone') ? ' is-invalid' : ''); ?>">
                    <?php $__currentLoopData = timezone_identifiers_list(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($value); ?>" <?php if((old('timezone') !== null && old('timezone') == $value) || (config('settings.timezone') == $value && old('timezone') == null)): ?> selected <?php endif; ?>><?php echo e($value); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
                <?php if($errors->has('timezone')): ?>
                    <span class="invalid-feedback d-block" role="alert">
                        <strong><?php echo e($errors->first('timezone')); ?></strong>
                    </span>
                <?php endif; ?>
            </div>

            <div class="form-group">
                <label for="i-custom-js"><?php echo e(__('Custom JS')); ?></label>
                <textarea name="custom_js" id="i-custom-js" class="form-control<?php echo e($errors->has('custom_js') ? ' is-invalid' : ''); ?>"><?php echo e(old('custom_js') ?? config('settings.custom_js')); ?></textarea>
                <?php if($errors->has('custom_js')): ?>
                    <span class="invalid-feedback d-block" role="alert">
                        <strong><?php echo e($errors->first('custom_js')); ?></strong>
                    </span>
                <?php endif; ?>
            </div>

            <button type="submit" name="submit" class="btn btn-primary"><?php echo e(__('Save')); ?></button>
        </form>

    </div>
</div><?php /**PATH /home/datanito/public_html/analytics.datanito.com/resources/views/admin/settings/general.blade.php ENDPATH**/ ?>