<?php $__env->startSection('site_title', formatTitle([__('Edit'), __('Plan'), config('settings.title')])); ?>

<?php echo $__env->make('shared.breadcrumbs', ['breadcrumbs' => [
    ['url' => route('admin.dashboard'), 'title' => __('Admin')],
    ['url' => route('admin.plans'), 'title' => __('Plans')],
    ['title' => __('Edit')],
]], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<h1 class="h2 mb-3 d-inline-block"><?php echo e(__('Edit')); ?></h1>

<div class="card border-0 shadow-sm">
    <div class="card-header align-items-center">
        <div class="row">
            <div class="col">
                <div class="font-weight-medium py-1">
                    <?php echo e(__('Plan')); ?>

                    <?php if($plan->trashed()): ?>
                        <span class="badge badge-danger"><?php echo e(__('Disabled')); ?></span>
                    <?php endif; ?>
                </div>
            </div>
            <div class="col-auto">
                <div class="form-row">
                    <div class="col">
                        <?php echo $__env->make('admin.plans.partials.menu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="card-body">
        <?php echo $__env->make('shared.message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        <?php if($plan->trashed()): ?>
            <div class="alert alert-danger" role="alert">
                <?php echo e(__(':name is disabled.', ['name' => $plan->name])); ?>

            </div>
        <?php endif; ?>

        <form action="<?php echo e(route('admin.plans.edit', $plan->id)); ?>" method="post" enctype="multipart/form-data">
            <?php echo csrf_field(); ?>

            <div class="form-group">
                <label for="i-name"><?php echo e(__('Name')); ?></label>
                <input type="text" name="name" id="i-name" class="form-control<?php echo e($errors->has('name') ? ' is-invalid' : ''); ?>" value="<?php echo e(old('name') ?? $plan->name); ?>">
                <?php if($errors->has('name')): ?>
                    <span class="invalid-feedback" role="alert">
                        <strong><?php echo e($errors->first('name')); ?></strong>
                    </span>
                <?php endif; ?>
            </div>

            <div class="form-group">
                <label for="i-description"><?php echo e(__('Description')); ?></label>
                <input type="text" name="description" id="i-description" class="form-control<?php echo e($errors->has('description') ? ' is-invalid' : ''); ?>" value="<?php echo e(old('description') ?? $plan->description); ?>">
                <?php if($errors->has('description')): ?>
                    <span class="invalid-feedback" role="alert">
                        <strong><?php echo e($errors->first('description')); ?></strong>
                    </span>
                <?php endif; ?>
            </div>

            <?php if(!$plan->isDefault()): ?>
                <div class="form-group">
                    <label for="i-trial-days"><?php echo e(__('Trial days')); ?></label>
                    <input type="number" name="trial_days" id="i-trial-days" class="form-control<?php echo e($errors->has('trial_days') ? ' is-invalid' : ''); ?>" value="<?php echo e(old('trial_days') ?? $plan->trial_days); ?>">
                    <?php if($errors->has('trial_days')): ?>
                        <span class="invalid-feedback" role="alert">
                            <strong><?php echo e($errors->first('trial_days')); ?></strong>
                        </span>
                    <?php endif; ?>
                </div>

                <div class="form-group">
                    <label for="i-currency"><?php echo e(__('Currency')); ?></label>
                    <select name="currency" id="i-currency" class="custom-select<?php echo e($errors->has('currency') ? ' is-invalid' : ''); ?>">
                        <?php $__currentLoopData = config('currencies.all'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($key); ?>" <?php if((old('currency') !== null && old('currency') == $key) || ($plan->currency == $key && old('currency') == null)): ?> selected <?php endif; ?>><?php echo e($key); ?> - <?php echo e($value); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                    <?php if($errors->has('currency')): ?>
                        <span class="invalid-feedback" role="alert">
                            <strong><?php echo e($errors->first('currency')); ?></strong>
                        </span>
                    <?php endif; ?>
                </div>

                <div class="row mx-n2">
                    <div class="col-12 col-lg-6 px-2">
                        <div class="form-group">
                            <label for="i-amount-month"><?php echo e(__('Monthly amount')); ?></label>
                            <input type="text" name="amount_month" id="i-amount-month" class="form-control<?php echo e($errors->has('amount_month') ? ' is-invalid' : ''); ?>" value="<?php echo e(old('amount_month') ?? $plan->amount_month); ?>">
                            <?php if($errors->has('amount_month')): ?>
                                <span class="invalid-feedback" role="alert">
                                    <strong><?php echo e($errors->first('amount_month')); ?></strong>
                                </span>
                            <?php endif; ?>
                        </div>
                    </div>

                    <div class="col-12 col-lg-6 px-2">
                        <div class="form-group">
                            <label for="i-amount-year"><?php echo e(__('Yearly amount')); ?></label>
                            <input type="text" name="amount_year" id="i-amount-year" class="form-control<?php echo e($errors->has('amount_year') ? ' is-invalid' : ''); ?>" value="<?php echo e(old('amount_year') ?? $plan->amount_year); ?>">
                            <?php if($errors->has('amount_year')): ?>
                                <span class="invalid-feedback" role="alert">
                                    <strong><?php echo e($errors->first('amount_year')); ?></strong>
                                </span>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>

                <div class="row mx-n2">
                    <div class="col-12 col-lg-6 px-2">
                        <div class="form-group">
                            <label for="i-tax-rates"><?php echo e(__('Tax rates')); ?></label>
                            <select name="tax_rates[]" id="i-tax-rates" class="custom-select<?php echo e($errors->has('tax_rates') ? ' is-invalid' : ''); ?>" size="3" multiple>
                                <?php $__currentLoopData = $taxRates; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $taxRate): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($taxRate->id); ?>" <?php if(old('taxRates') !== null && in_array($taxRate->id, old('taxRates')) || old('taxRates') == null && is_array($plan->tax_rates) && in_array($taxRate->id, $plan->tax_rates)): ?> selected <?php endif; ?>><?php echo e($taxRate->name); ?> (<?php echo e(number_format($taxRate->percentage, 2, __('.'), __(','))); ?>% <?php echo e(($taxRate->type ? __('Exclusive') : __('Inclusive'))); ?>)</option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                            <?php if($errors->has('tax_rates')): ?>
                                <span class="invalid-feedback d-block" role="alert">
                                    <strong><?php echo e($errors->first('tax_rates')); ?></strong>
                                </span>
                            <?php endif; ?>
                        </div>
                    </div>

                    <div class="col-12 col-lg-6 px-2">
                        <div class="form-group">
                            <label for="i-coupons"><?php echo e(__('Coupons')); ?></label>
                            <select name="coupons[]" id="i-coupons" class="custom-select<?php echo e($errors->has('coupons') ? ' is-invalid' : ''); ?>" size="3" multiple>
                                <?php $__currentLoopData = $coupons; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $coupon): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($coupon->id); ?>" <?php if(old('coupons') !== null && in_array($coupon->id, old('coupons')) || old('coupons') == null && is_array($plan->coupons) && in_array($coupon->id, $plan->coupons)): ?> selected <?php endif; ?>><?php echo e($coupon->code); ?> (<?php echo e(number_format($coupon->percentage, 2, __('.'), __(','))); ?>% <?php echo e(($coupon->type ? __('Redeemable') : __('Discount'))); ?>)</option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                            <?php if($errors->has('coupons')): ?>
                                <span class="invalid-feedback d-block" role="alert">
                                    <strong><?php echo e($errors->first('coupons')); ?></strong>
                                </span>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            <?php endif; ?>

            <div class="form-group">
                <label for="i-visibility"><?php echo e(__('Visibility')); ?></label>
                <select name="visibility" id="i-visibility" class="custom-select<?php echo e($errors->has('visibility') ? ' is-invalid' : ''); ?>">
                    <?php $__currentLoopData = [1 => __('Public'), 0 => __('Unlisted')]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($key); ?>" <?php if((old('visibility') !== null && old('visibility') == $key) || ($plan->visibility == $key && old('visibility') == null)): ?> selected <?php endif; ?>><?php echo e($value); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
                <?php if($errors->has('visibility')): ?>
                    <span class="invalid-feedback" role="alert">
                        <strong><?php echo e($errors->first('visibility')); ?></strong>
                    </span>
                <?php endif; ?>
            </div>

            <div class="form-group">
                <label for="i-position"><?php echo e(__('Position')); ?></label>
                <input type="number" name="position" id="i-position" class="form-control<?php echo e($errors->has('position') ? ' is-invalid' : ''); ?>" value="<?php echo e(old('position') ?? $plan->position); ?>">
                <?php if($errors->has('position')): ?>
                    <span class="invalid-feedback" role="alert">
                        <strong><?php echo e($errors->first('position')); ?></strong>
                    </span>
                <?php endif; ?>
            </div>

            <div class="hr-text"><span class="font-weight-medium text-body"><?php echo e(__('Features')); ?></span></div>

            <div class="form-group">
                <label for="i-features-reports"><?php echo e(__('Reports')); ?></label>
                <input type="text" name="features[reports]" id="i-features-reports" class="form-control<?php echo e($errors->has('features.reports') ? ' is-invalid' : ''); ?>" value="<?php echo e(old('features.reports') ?? $plan->features->reports); ?>">
                <?php if($errors->has('features.reports')): ?>
                    <span class="invalid-feedback" role="alert">
                        <strong><?php echo e($errors->first('features.reports')); ?></strong>
                    </span>
                <?php endif; ?>
                <small class="form-text text-muted"><?php echo __(':value for unlimited.', ['value' => '<code class="badge badge-secondary">-1</code>']); ?> <?php echo __(':value for none.', ['value' => '<code class="badge badge-secondary">0</code>']); ?> <?php echo __(':value for number.', ['value' => '<code class="badge badge-secondary">N</code>']); ?></small>
            </div>

            <div class="form-group">
                <label for="i-features-branded-reports"><?php echo e(__('Branded reports')); ?></label>
                <select name="features[branded_reports]" id="i-features-branded-reports" class="custom-select<?php echo e($errors->has('features.branded_reports') ? ' is-invalid' : ''); ?>">
                    <?php $__currentLoopData = [1 => __('On'), 0 => __('Off')]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($key); ?>" <?php if((old('features.branded_reports') !== null && old('features.branded_reports') == $key) || ($plan->features->branded_reports == $key && old('features.branded_reports') == null)): ?> selected <?php endif; ?>><?php echo e($value); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
                <?php if($errors->has('features.branded_reports')): ?>
                    <span class="invalid-feedback" role="alert">
                        <strong><?php echo e($errors->first('features.branded_reports')); ?></strong>
                    </span>
                <?php endif; ?>
            </div>

            <div class="form-group">
                <label for="i-features-white-label-reports"><?php echo e(__('White-label reports')); ?></label>
                <select name="features[white_label_reports]" id="i-features-white-label-reports" class="custom-select<?php echo e($errors->has('features.white_label_reports') ? ' is-invalid' : ''); ?>">
                    <?php $__currentLoopData = [1 => __('On'), 0 => __('Off')]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($key); ?>" <?php if((old('features.white_label_reports') !== null && old('features.white_label_reports') == $key) || ($plan->features->white_label_reports == $key && old('features.white_label_reports') == null)): ?> selected <?php endif; ?>><?php echo e($value); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
                <?php if($errors->has('features.white_label_reports')): ?>
                    <span class="invalid-feedback" role="alert">
                        <strong><?php echo e($errors->first('features.white_label_reports')); ?></strong>
                    </span>
                <?php endif; ?>
            </div>

            <div class="form-group">
                <label for="i-features-research-tools"><?php echo e(__('Research tools')); ?></label>
                <select name="features[research_tools]" id="i-features-research-tools" class="custom-select<?php echo e($errors->has('features.research_tools') ? ' is-invalid' : ''); ?>">
                    <?php $__currentLoopData = [1 => __('On'), 0 => __('Off')]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($key); ?>" <?php if((old('features.research_tools') !== null && old('features.research_tools') == $key) || ($plan->features->research_tools == $key && old('features.research_tools') == null)): ?> selected <?php endif; ?>><?php echo e($value); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
                <?php if($errors->has('features.research_tools')): ?>
                    <span class="invalid-feedback" role="alert">
                        <strong><?php echo e($errors->first('features.research_tools')); ?></strong>
                    </span>
                <?php endif; ?>
            </div>

            <div class="form-group">
                <label for="i-features-developer-tools"><?php echo e(__('Developer tools')); ?></label>
                <select name="features[developer_tools]" id="i-features-developer-tools" class="custom-select<?php echo e($errors->has('features.developer_tools') ? ' is-invalid' : ''); ?>">
                    <?php $__currentLoopData = [1 => __('On'), 0 => __('Off')]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($key); ?>" <?php if((old('features.developer_tools') !== null && old('features.developer_tools') == $key) || ($plan->features->developer_tools == $key && old('features.developer_tools') == null)): ?> selected <?php endif; ?>><?php echo e($value); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
                <?php if($errors->has('features.developer_tools')): ?>
                    <span class="invalid-feedback" role="alert">
                        <strong><?php echo e($errors->first('features.developer_tools')); ?></strong>
                    </span>
                <?php endif; ?>
            </div>

            <div class="form-group">
                <label for="i-features-content-tools"><?php echo e(__('Content tools')); ?></label>
                <select name="features[content_tools]" id="i-features-content-tools" class="custom-select<?php echo e($errors->has('features.content_tools') ? ' is-invalid' : ''); ?>">
                    <?php $__currentLoopData = [1 => __('On'), 0 => __('Off')]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($key); ?>" <?php if((old('features.content_tools') !== null && old('features.content_tools') == $key) || ($plan->features->content_tools == $key && old('features.content_tools') == null)): ?> selected <?php endif; ?>><?php echo e($value); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
                <?php if($errors->has('features.content_tools')): ?>
                    <span class="invalid-feedback" role="alert">
                        <strong><?php echo e($errors->first('features.content_tools')); ?></strong>
                    </span>
                <?php endif; ?>
            </div>

            <div class="form-group">
                <label for="i-features-data-export"><?php echo e(__('Data export')); ?></label>
                <select name="features[data_export]" id="i-features-data-export" class="custom-select<?php echo e($errors->has('features.data_export') ? ' is-invalid' : ''); ?>">
                    <?php $__currentLoopData = [1 => __('On'), 0 => __('Off')]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($key); ?>" <?php if((old('features.data_export') !== null && old('features.data_export') == $key) || ($plan->features->data_export == $key && old('features.data_export') == null)): ?> selected <?php endif; ?>><?php echo e($value); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
                <?php if($errors->has('features.data_export')): ?>
                    <span class="invalid-feedback" role="alert">
                        <strong><?php echo e($errors->first('features.data_export')); ?></strong>
                    </span>
                <?php endif; ?>
            </div>

            <div class="form-group">
                <label for="i-features-api"><?php echo e(__('API')); ?></label>
                <select name="features[api]" id="i-features-api" class="custom-select<?php echo e($errors->has('features.api') ? ' is-invalid' : ''); ?>">
                    <?php $__currentLoopData = [1 => __('On'), 0 => __('Off')]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($key); ?>" <?php if((old('features.api') !== null && old('features.api') == $key) || ($plan->features->api == $key && old('features.api') == null)): ?> selected <?php endif; ?>><?php echo e($value); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
                <?php if($errors->has('features.api')): ?>
                    <span class="invalid-feedback" role="alert">
                        <strong><?php echo e($errors->first('features.api')); ?></strong>
                    </span>
                <?php endif; ?>
            </div>

            <button type="submit" name="submit" class="btn btn-primary"><?php echo e(__('Save')); ?></button>
        </form>
    </div>
</div>
<?php /**PATH /home/datanito/public_html/analytics.datanito.com/resources/views/admin/plans/edit.blade.php ENDPATH**/ ?>