<?php $__env->startSection('site_title', formatTitle([__('Payments'), config('settings.title')])); ?>

<?php echo $__env->make('shared.breadcrumbs', ['breadcrumbs' => [
    ['url' => route('admin.dashboard'), 'title' => __('Admin')],
    ['title' => __('Payments')],
]], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<div class="d-flex">
    <div class="flex-grow-1">
        <h1 class="h2 mb-3 d-inline-block"><?php echo e(__('Payments')); ?></h1>
    </div>
</div>

<div class="card border-0 shadow-sm">
    <div class="card-header align-items-center">
        <div class="row">
            <div class="col"><div class="font-weight-medium py-1"><?php echo e(__('Payments')); ?></div></div>
            <div class="col-auto">
                <form method="GET" action="<?php echo e(route('admin.payments')); ?>" class="d-md-flex">
                    <?php echo $__env->make('shared.filter-tags', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    <div class="input-group input-group-sm">
                        <input class="form-control" name="search" placeholder="<?php echo e(__('Search')); ?>" value="<?php echo e(app('request')->input('search')); ?>">
                        <div class="input-group-append">
                            <button type="button" class="btn btn-outline-primary d-flex align-items-center dropdown-toggle dropdown-toggle-split reset-after" data-tooltip="true" title="<?php echo e(__('Filters')); ?>" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"><?php echo $__env->make('icons.filter', ['class' => 'fill-current width-4 height-4'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>&#8203;</button>
                            <div class="dropdown-menu <?php echo e((__('lang_dir') == 'rtl' ? 'dropdown-menu' : 'dropdown-menu-right')); ?> border-0 shadow width-64 p-0" id="search-filters">
                                <div class="dropdown-header py-3">
                                    <div class="row">
                                        <div class="col"><div class="font-weight-medium m-0 text-dark"><?php echo e(__('Filters')); ?></div></div>
                                        <div class="col-auto"><a href="<?php echo e(route('admin.payments')); ?>" class="text-secondary"><?php echo e(__('Reset')); ?></a></div>
                                    </div>
                                </div>

                                <div class="dropdown-divider my-0"></div>

                                <input name="user_id" type="hidden" value="<?php echo e(request()->input('user_id')); ?>">

                                <div class="max-height-96 overflow-auto pt-3">
                                    <div class="form-group px-4">
                                        <label for="i-search-by" class="small"><?php echo e(__('Search by')); ?></label>
                                        <select name="search_by" id="i-search-by" class="custom-select custom-select-sm">
                                            <?php $__currentLoopData = ['payment_id' => __('Payment ID'), 'invoice_id' => __('Invoice ID')]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($key); ?>" <?php if(request()->input('search_by') == $key || !request()->input('search_by') && $key == 'name'): ?> selected <?php endif; ?>><?php echo e($value); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>

                                    <div class="form-group px-4">
                                        <label for="i-plan" class="small"><?php echo e(__('Plan')); ?></label>
                                        <select id="i-plan" name="plan" class="custom-select custom-select-sm">
                                            <option value=""><?php echo e(__('All')); ?></option>
                                            <?php $__currentLoopData = $plans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $plan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($plan->id); ?>" <?php if(request()->input('plan') == $plan->id): ?> selected <?php endif; ?>><?php echo e($plan->name); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>

                                    <div class="form-group px-4">
                                        <label for="i-interval" class="small"><?php echo e(__('Interval')); ?></label>
                                        <select name="interval" id="i-interval" class="custom-select custom-select-sm">
                                            <option value=""><?php echo e(__('All')); ?></option>
                                            <?php $__currentLoopData = ['month' => __('Monthly'), 'year' => __('Yearly')]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($key); ?>" <?php if(request()->input('interval') == $key && request()->input('interval') !== null): ?> selected <?php endif; ?>><?php echo e($value); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>

                                    <div class="form-group px-4">
                                        <label for="i-processor" class="small"><?php echo e(__('Processor')); ?></label>
                                        <select name="processor" id="i-processor" class="custom-select custom-select-sm">
                                            <option value=""><?php echo e(__('All')); ?></option>
                                            <?php $__currentLoopData = config('payment.processors'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($key); ?>" <?php if(request()->input('processor') == $key && request()->input('processor') !== null): ?> selected <?php endif; ?>><?php echo e(__($value['name'])); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>

                                    <div class="form-group px-4">
                                        <label for="i-status" class="small"><?php echo e(__('Status')); ?></label>
                                        <select name="status" id="i-status" class="custom-select custom-select-sm">
                                            <option value=""><?php echo e(__('All')); ?></option>
                                            <?php $__currentLoopData = ['completed' => __('Completed'), 'pending' => __('Pending'), 'cancelled' => __('Cancelled')]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($key); ?>" <?php if(request()->input('status') == $key && request()->input('status') !== null): ?> selected <?php endif; ?>><?php echo e($value); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>

                                    <div class="form-group px-4">
                                        <label for="i-sort-by" class="small"><?php echo e(__('Sort by')); ?></label>
                                        <select name="sort_by" id="i-sort-by" class="custom-select custom-select-sm">
                                            <?php $__currentLoopData = ['id' => __('Date created')]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($key); ?>" <?php if(request()->input('sort_by') == $key): ?> selected <?php endif; ?>><?php echo e($value); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>

                                    <div class="form-group px-4">
                                        <label for="i-sort" class="small"><?php echo e(__('Sort')); ?></label>
                                        <select name="sort" id="i-sort" class="custom-select custom-select-sm">
                                            <?php $__currentLoopData = ['desc' => __('Descending'), 'asc' => __('Ascending')]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($key); ?>" <?php if(request()->input('sort') == $key): ?> selected <?php endif; ?>><?php echo e($value); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>

                                    <div class="form-group px-4">
                                        <label for="i-per-page" class="small"><?php echo e(__('Results per page')); ?></label>
                                        <select name="per_page" id="i-per-page" class="custom-select custom-select-sm">
                                            <?php $__currentLoopData = [10, 25, 50, 100]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($value); ?>" <?php if(request()->input('per_page') == $value || request()->input('per_page') == null && $value == config('settings.paginate')): ?> selected <?php endif; ?>><?php echo e($value); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>
                                </div>

                                <div class="dropdown-divider my-0"></div>

                                <div class="px-4 py-3">
                                    <button type="submit" class="btn btn-primary btn-sm btn-block"><?php echo e(__('Search')); ?></button>
                                </div>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <div class="card-body">
        <?php echo $__env->make('shared.message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        <?php if(count($payments) == 0): ?>
            <?php echo e(__('No results found.')); ?>

        <?php else: ?>
            <div class="list-group list-group-flush my-n3">
                <div class="list-group-item px-0 text-muted">
                    <div class="row align-items-center">
                        <div class="col">
                            <div class="row align-items-center">
                                <div class="col-12 col-lg-5 d-flex">
                                    <?php echo e(__('Amount')); ?>

                                </div>

                                <div class="col-12 col-lg-5 d-flex">
                                    <?php echo e(__('User')); ?>

                                </div>

                                <div class="col-12 col-lg-2 d-flex">
                                    <?php echo e(__('Status')); ?>

                                </div>
                            </div>
                        </div>
                        <div class="col-auto">
                            <div class="form-row">
                                <div class="col">
                                    <div class="invisible btn d-flex align-items-center btn-sm text-primary"><?php echo $__env->make('icons.more-horiz', ['class' => 'fill-current width-4 height-4'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>&#8203;</div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <?php $__currentLoopData = $payments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $payment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="list-group-item px-0">
                        <div class="row align-items-center">
                            <div class="col text-truncate">
                                <div class="row align-items-center">
                                    <div class="col-12 col-lg-5 d-flex">
                                        <div class="text-truncate">
                                            <div class="d-flex align-items-center">
                                                <img src="<?php echo e(url('/')); ?>/images/icons/payments/<?php echo e($payment->processor); ?>.svg" class="width-6 rounded-sm">

                                                <div class="text-truncate <?php echo e((__('lang_dir') == 'rtl' ? 'mr-3 ml-2' : 'ml-3 mr-2')); ?>">
                                                    <a href="<?php echo e(route('admin.payments.edit', $payment->id)); ?>"><?php echo e(formatMoney($payment->amount, $payment->currency)); ?></a> <span class="text-muted"><?php echo e($payment->currency); ?></span>
                                                </div>

                                                <?php if(in_array($payment->status, ['completed', 'cancelled'])): ?>
                                                    <a href="<?php echo e(route('admin.invoices.show', $payment->id)); ?>" class="badge badge-secondary text-truncate" data-tooltip="true" title="<?php echo e(__('Invoice')); ?>"><?php echo e($payment->invoice_id); ?></a>
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="col-12 col-lg-5 d-flex align-items-center">
                                        <?php if(isset($payment->user)): ?>
                                            <div class="d-inline-block <?php echo e((__('lang_dir') == 'rtl' ? 'ml-3' : 'mr-3')); ?> text-truncate">
                                                <img src="<?php echo e(gravatar($payment->user->email, 48)); ?>" class="rounded-circle width-6 height-6">
                                            </div>
                                            <a href="<?php echo e(route('admin.users.edit', $payment->user->id)); ?>"><?php echo e($payment->user->name); ?></a>
                                        <?php else: ?>
                                            <div class="d-inline-block <?php echo e((__('lang_dir') == 'rtl' ? 'ml-3' : 'mr-3')); ?>">
                                                <img src="<?php echo e(gravatar('', 48, 'mp')); ?>" class="rounded-circle width-6 height-6">
                                            </div>
                                            <div class="text-muted"><?php echo e(__('Deleted')); ?></div>
                                        <?php endif; ?>
                                    </div>

                                    <div class="col-12 col-lg-2 d-flex">
                                        <?php if($payment->status == 'completed'): ?>
                                            <span class="badge badge-success text-truncate"><?php echo e(__('Completed')); ?></span>
                                        <?php elseif($payment->status == 'pending'): ?>
                                            <span class="badge badge-secondary text-truncate"><?php echo e(__('Pending')); ?></span>
                                        <?php else: ?>
                                            <span class="badge badge-danger text-truncate"><?php echo e(__('Cancelled')); ?></span>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                            <div class="col-auto">
                                <div class="form-row">
                                    <div class="col">
                                        <?php echo $__env->make('account.payments.partials.menu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                <div class="mt-3 align-items-center">
                    <div class="row">
                        <div class="col">
                            <div class="mt-2 mb-3"><?php echo e(__('Showing :from-:to of :total', ['from' => $payments->firstItem(), 'to' => $payments->lastItem(), 'total' => $payments->total()])); ?>

                            </div>
                        </div>
                        <div class="col-auto">
                            <?php echo e($payments->onEachSide(1)->links()); ?>

                        </div>
                    </div>
                </div>
            </div>
        <?php endif; ?>
    </div>
</div><?php /**PATH /home/datanito/public_html/analytics.datanito.com/resources/views/admin/payments/list.blade.php ENDPATH**/ ?>