<?php if(isset($report['results'][$name])): ?>
    <div class="border-top">
        <div class="card-body">
            <div class="row">
                <div class="col">
                    <div class="row">
                        <div class="col-12 col-lg-4">
                            <div class="d-flex align-items-center">
                                <?php echo $__env->make('reports.partials.status', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                                <div class="text-truncate font-weight-medium"><?php echo e(__('Load time')); ?></div>
                            </div>
                        </div>

                        <div class="col-12 col-lg-8">
                            <?php if($report['results'][$name]['passed']): ?>
                                <div>
                                    <?php echo e(__('The webpage loaded in :value seconds.', ['value' => number_format($report['results'][$name]['value'], 2, __('.'), __(','))])); ?>

                                </div>
                            <?php else: ?>
                                <?php $__currentLoopData = $report['results'][$name]['errors']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error => $details): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="<?php echo e((!$loop->first) ? 'mt-3' : ''); ?>">
                                        <?php if($error == 'too_slow'): ?>
                                            <?php echo e(__('The webpage load should be under :value seconds.', ['value' => number_format($details['max'], 2, __('.'), __(','))])); ?>


                                            <div class="small text-muted mt-1">
                                                <?php echo e(__('The webpage loaded in :value seconds.', ['value' => number_format($report['results'][$name]['value'], 2, __('.'), __(','))])); ?>

                                            </div>
                                        <?php endif; ?>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>

                <div class="col-auto">
                    <a href="#collapse<?php echo e($name); ?>" class="text-secondary" data-toggle="collapse" role="button" aria-expanded="false" aria-controls="collapse<?php echo e($name); ?>" data-tooltip="true" title="<?php echo e(__('More')); ?>">
                        <?php echo $__env->make('icons.info', ['class' => 'fill-current width-4 height-4'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>&#8203;
                    </a>
                </div>
            </div>
        </div>
    </div>

    <div class="collapse<?php echo e(Auth::check() && Auth::user()->default_export_detailed ? ' d-print-block' : ''); ?>" id="collapse<?php echo e($name); ?>">
        <div class="card-body pt-0">
            <div class="alert alert-secondary mb-0">
                <?php echo e(__('The load time indicates the HTML\'s total load time, and does not include the external resources, such as images, scripts, or other resources.')); ?>

            </div>
        </div>
    </div>
<?php endif; ?><?php /**PATH /home/datanito/public_html/analytics.datanito.com/resources/views/reports/partials/load-time.blade.php ENDPATH**/ ?>