<?php $__env->startSection('site_title', formatTitle([__('Plan'), config('settings.title')])); ?>

<?php echo $__env->make('shared.breadcrumbs', ['breadcrumbs' => [
    ['url' => route('dashboard'), 'title' => __('Home')],
    ['url' => route('account'), 'title' => __('Account')],
    ['title' => __('Plan')]
]], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<h1 class="h2 mb-3 d-inline-block"><?php echo e(__('Plan')); ?></h1>

<div class="card border-0 shadow-sm">
    <div class="card-header align-items-center">
        <div class="row">
            <div class="col"><div class="font-weight-medium py-1"><?php echo e(__('Plan')); ?></div></div>
            <?php if(paymentProcessors()): ?>
                <div class="col-auto">
                    <?php if(Auth::user()->planIsDefault()): ?>
                        <a href="<?php echo e(route('pricing')); ?>" class="btn btn-sm btn-outline-primary btn-block d-flex justify-content-center align-items-center"><?php echo $__env->make('icons.unarchive', ['class' => 'width-4 height-4 fill-current '.(__('lang_dir') == 'rtl' ? 'ml-2' : 'mr-2')], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php echo e(__('Upgrade')); ?></a>
                    <?php else: ?>
                        <a href="<?php echo e(route('pricing')); ?>" class="btn btn-sm btn-outline-primary btn-block d-flex justify-content-center align-items-center"><?php echo $__env->make('icons.package', ['class' => 'width-4 height-4 fill-current '.(__('lang_dir') == 'rtl' ? 'ml-2' : 'mr-2')], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php echo e(__('Plans')); ?></a>
                    <?php endif; ?>
                </div>
            <?php endif; ?>
        </div>
    </div>
    <div class="card-body">
        <?php echo $__env->make('shared.message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        <form action="<?php echo e(route('account.plan')); ?>" method="post" enctype="multipart/form-data">
            <?php echo csrf_field(); ?>

            <div class="row">
                <div class="col-12 col-lg-6 mb-3">
                    <div class="text-muted"><?php echo e(__('Plan')); ?></div>
                    <div><?php echo e($user->plan->name); ?></div>
                </div>

                <?php if(!$user->planIsDefault()): ?>
                    <?php if($user->plan_payment_processor): ?>
                        <div class="col-12 col-lg-6 mb-3">
                            <div class="text-muted"><?php echo e(__('Processor')); ?></div>
                            <div><?php echo e(config('payment.processors.' . $user->plan_payment_processor)['name']); ?></div>
                        </div>
                    <?php endif; ?>

                    <?php if($user->plan_amount && $user->plan_currency && $user->plan_interval): ?>
                        <div class="col-12 col-lg-6 mb-3">
                            <div class="text-muted"><?php echo e(__('Amount')); ?></div>
                            <div><?php echo e(formatMoney($user->plan_amount, $user->plan_currency)); ?> <?php echo e($user->plan_currency); ?> / <span class="text-lowercase"><?php echo e($user->plan_interval == 'month' ? __('Month') : __('Year')); ?></span></div>
                        </div>
                    <?php endif; ?>

                    <?php if($user->plan_recurring_at): ?>
                        <div class="col-12 col-lg-6 mb-3">
                            <div class="text-muted"><?php echo e(__('Recurring at')); ?></div>
                            <div><?php echo e($user->plan_recurring_at->tz($user->timezone ?? config('app.timezone'))->format(__('Y-m-d'))); ?></div>
                        </div>
                    <?php endif; ?>

                    <?php if($user->plan_trial_ends_at && $user->plan_trial_ends_at->gt(Carbon\Carbon::now())): ?>
                        <div class="col-12 col-lg-6 mb-3">
                            <div class="text-muted"><?php echo e(__('Trial ends at')); ?></div>
                            <div><?php echo e($user->plan_trial_ends_at->tz($user->timezone ?? config('app.timezone'))->format(__('Y-m-d'))); ?></div>
                        </div>
                    <?php endif; ?>

                    <?php if($user->plan_ends_at): ?>
                        <div class="col-12 col-lg-6 mb-3">
                            <div class="text-muted"><?php echo e(__('Ends at')); ?></div>
                            <div><?php echo e($user->plan_ends_at->tz($user->timezone ?? config('app.timezone'))->format(__('Y-m-d'))); ?></div>
                        </div>
                    <?php endif; ?>
                <?php endif; ?>
            </div>

            <div class="hr-text mt-0"><span class="font-weight-medium text-body"><?php echo e(__('Features')); ?></span></div>

            <div class="row m-n2">
                <div class="col-12 col-md-6 p-2 d-flex align-items-center">
                    <?php if($user->plan->features->reports != 0): ?>
                        <?php echo $__env->make('icons.checkmark', ['class' => 'flex-shrink-0 text-success fill-current width-4 height-4'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    <?php else: ?>
                        <?php echo $__env->make('icons.close', ['class' => 'flex-shrink-0 text-muted fill-current width-4 height-4'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    <?php endif; ?>

                    <div class="<?php echo e(($user->plan->features->reports == 0 ? 'text-muted' : '')); ?> <?php echo e((__('lang_dir') == 'rtl' ? 'mr-2' : 'ml-3')); ?>">
                        <?php if($user->plan->features->reports < 0): ?>
                            <?php echo e(__('Unlimited reports')); ?>

                        <?php else: ?>
                            <span class="text-muted"><?php echo e($reportsCount); ?> /</span> <?php echo e(__(($user->plan->features->reports == 1 ? ':number report' : ':number reports'), ['number' => number_format($user->plan->features->reports, 0, __('.'), __(','))])); ?> <span class="text-muted">/ <?php echo e(mb_strtolower(__('Month'))); ?></span>
                        <?php endif; ?>
                    </div>
                </div>

                <div class="col-12 col-md-6 p-2 d-flex align-items-center">
                    <?php if($user->plan->features->branded_reports): ?>
                        <?php echo $__env->make('icons.checkmark', ['class' => 'flex-shrink-0 text-success fill-current width-4 height-4'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    <?php else: ?>
                        <?php echo $__env->make('icons.close', ['class' => 'flex-shrink-0 text-muted fill-current width-4 height-4'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    <?php endif; ?>

                    <div class="<?php echo e(($user->plan->features->branded_reports == 0 ? 'text-muted' : '')); ?> <?php echo e((__('lang_dir') == 'rtl' ? 'mr-2' : 'ml-3')); ?>">
                        <?php echo e(__('Branded reports')); ?>

                    </div>

                    <div class="d-flex align-content-center <?php echo e((__('lang_dir') == 'rtl' ? 'mr-2' : 'ml-2')); ?>" data-tooltip="true" title="<?php echo e(__('Customizable reports when printing or saving as PDF.')); ?>"><?php echo $__env->make('icons.info', ['class' => 'text-muted width-4 height-4 fill-current'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?></div>
                </div>

                <div class="col-12 col-md-6 p-2 d-flex align-items-center">
                    <?php if($user->plan->features->white_label_reports): ?>
                        <?php echo $__env->make('icons.checkmark', ['class' => 'flex-shrink-0 text-success fill-current width-4 height-4'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    <?php else: ?>
                        <?php echo $__env->make('icons.close', ['class' => 'flex-shrink-0 text-muted fill-current width-4 height-4'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    <?php endif; ?>

                    <div class="<?php echo e(($user->plan->features->white_label_reports == 0 ? 'text-muted' : '')); ?> <?php echo e((__('lang_dir') == 'rtl' ? 'mr-2' : 'ml-3')); ?>">
                        <?php echo e(__('White-label reports')); ?>

                    </div>

                    <div class="d-flex align-content-center <?php echo e((__('lang_dir') == 'rtl' ? 'mr-2' : 'ml-2')); ?>" data-tooltip="true" title="<?php echo e(__('White-label reports when printing or saving as PDF.')); ?>"><?php echo $__env->make('icons.info', ['class' => 'text-muted width-4 height-4 fill-current'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?></div>
                </div>

                <div class="col-12 col-md-6 p-2 d-flex align-items-center">
                    <?php if($user->plan->features->research_tools): ?>
                        <?php echo $__env->make('icons.checkmark', ['class' => 'flex-shrink-0 text-success fill-current width-4 height-4'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    <?php else: ?>
                        <?php echo $__env->make('icons.close', ['class' => 'flex-shrink-0 text-muted fill-current width-4 height-4'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    <?php endif; ?>

                    <div class="<?php echo e(($user->plan->features->research_tools == 0 ? 'text-muted' : '')); ?> <?php echo e((__('lang_dir') == 'rtl' ? 'mr-2' : 'ml-3')); ?>">
                        <?php echo e(__('Research tools')); ?>

                    </div>

                    <div class="d-flex align-content-center <?php echo e((__('lang_dir') == 'rtl' ? 'mr-2' : 'ml-2')); ?>" data-tooltip="true" title="<?php echo e(__('Access to :list tools.', ['list' => implode(', ', array_column(array_filter(config('tools'), function ($item) { return $item['category'] == 'research' ? $item : false; }), 'title'))])); ?>"><?php echo $__env->make('icons.info', ['class' => 'text-muted width-4 height-4 fill-current'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?></div>
                </div>

                <div class="col-12 col-md-6 p-2 d-flex align-items-center">
                    <?php if($user->plan->features->developer_tools): ?>
                        <?php echo $__env->make('icons.checkmark', ['class' => 'flex-shrink-0 text-success fill-current width-4 height-4'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    <?php else: ?>
                        <?php echo $__env->make('icons.close', ['class' => 'flex-shrink-0 text-muted fill-current width-4 height-4'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    <?php endif; ?>

                    <div class="<?php echo e(($user->plan->features->developer_tools == 0 ? 'text-muted' : '')); ?> <?php echo e((__('lang_dir') == 'rtl' ? 'mr-2' : 'ml-3')); ?>">
                        <?php echo e(__('Developer tools')); ?>

                    </div>

                    <div class="d-flex align-content-center <?php echo e((__('lang_dir') == 'rtl' ? 'mr-2' : 'ml-2')); ?>" data-tooltip="true" title="<?php echo e(__('Access to :list tools.', ['list' => implode(', ', array_column(array_filter(config('tools'), function ($item) { return $item['category'] == 'developer' ? $item : false; }), 'title'))])); ?>"><?php echo $__env->make('icons.info', ['class' => 'text-muted width-4 height-4 fill-current'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?></div>
                </div>

                <div class="col-12 col-md-6 p-2 d-flex align-items-center">
                    <?php if($user->plan->features->content_tools): ?>
                        <?php echo $__env->make('icons.checkmark', ['class' => 'flex-shrink-0 text-success fill-current width-4 height-4'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    <?php else: ?>
                        <?php echo $__env->make('icons.close', ['class' => 'flex-shrink-0 text-muted fill-current width-4 height-4'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    <?php endif; ?>

                    <div class="<?php echo e(($user->plan->features->content_tools == 0 ? 'text-muted' : '')); ?> <?php echo e((__('lang_dir') == 'rtl' ? 'mr-2' : 'ml-3')); ?>">
                        <?php echo e(__('Content tools')); ?>

                    </div>

                    <div class="d-flex align-content-center <?php echo e((__('lang_dir') == 'rtl' ? 'mr-2' : 'ml-2')); ?>" data-tooltip="true" title="<?php echo e(__('Access to :list tools.', ['list' => implode(', ', array_column(array_filter(config('tools'), function ($item) { return $item['category'] == 'content' ? $item : false; }), 'title'))])); ?>"><?php echo $__env->make('icons.info', ['class' => 'text-muted width-4 height-4 fill-current'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?></div>
                </div>

                <div class="col-12 col-md-6 p-2 d-flex align-items-center">
                    <?php if($user->plan->features->data_export): ?>
                        <?php echo $__env->make('icons.checkmark', ['class' => 'flex-shrink-0 text-success fill-current width-4 height-4'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    <?php else: ?>
                        <?php echo $__env->make('icons.close', ['class' => 'flex-shrink-0 text-muted fill-current width-4 height-4'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    <?php endif; ?>

                    <div class="<?php echo e(($user->plan->features->data_export == 0 ? 'text-muted' : '')); ?> <?php echo e((__('lang_dir') == 'rtl' ? 'mr-2' : 'ml-3')); ?>">
                        <?php echo e(__('Data export')); ?>

                    </div>
                </div>

                <div class="col-12 col-md-6 p-2 d-flex align-items-center">
                    <?php if($user->plan->features->api): ?>
                        <?php echo $__env->make('icons.checkmark', ['class' => 'flex-shrink-0 text-success fill-current width-4 height-4'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    <?php else: ?>
                        <?php echo $__env->make('icons.close', ['class' => 'flex-shrink-0 text-muted fill-current width-4 height-4'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    <?php endif; ?>

                    <div class="<?php echo e(($user->plan->features->api == 0 ? 'text-muted' : '')); ?> <?php echo e((__('lang_dir') == 'rtl' ? 'mr-2' : 'ml-3')); ?>">
                        <?php echo e(__('API')); ?>

                    </div>
                </div>
            </div>

            <?php if(paymentProcessors()): ?>
                <?php if($user->plan_recurring_at): ?>
                    <button type="button" class="btn btn-outline-danger mt-3" data-toggle="modal" data-target="#modal" data-action="<?php echo e(route('account.plan')); ?>" data-button="btn btn-danger" data-title="<?php echo e(__('Cancel')); ?>" data-text="<?php echo e(__('You\'ll continue to have access to the features you\'ve paid for until the end of your billing cycle.')); ?>" data-sub-text="<?php echo e(__('Are you sure you want to cancel :name?', ['name' => $user->plan->name])); ?>"><?php echo e(__('Cancel')); ?></button>
                <?php endif; ?>
            <?php endif; ?>
        </form>
    </div>
</div>
<?php /**PATH /home/datanito/public_html/analytics.datanito.com/resources/views/account/plan.blade.php ENDPATH**/ ?>