<?php $__env->startSection('site_title', formatTitle([__('New'), __('Tax rate'), config('settings.title')])); ?>

<?php echo $__env->make('shared.breadcrumbs', ['breadcrumbs' => [
    ['url' => route('admin.dashboard'), 'title' => __('Admin')],
    ['url' => route('admin.tax_rates'), 'title' => __('Tax rates')],
    ['title' => __('New')],
]], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<h1 class="h2 mb-3 d-inline-block"><?php echo e(__('New')); ?></h1>

<div class="card border-0 shadow-sm">
    <div class="card-header"><div class="font-weight-medium py-1"><?php echo e(__('Tax rate')); ?></div></div>
    <div class="card-body">
        <?php echo $__env->make('shared.message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        <form action="<?php echo e(route('admin.tax_rates.new')); ?>" method="post" enctype="multipart/form-data">
            <?php echo csrf_field(); ?>

            <div class="form-group">
                <label for="i-name"><?php echo e(__('Name')); ?></label>
                <input type="text" name="name" id="i-name" class="form-control<?php echo e($errors->has('name') ? ' is-invalid' : ''); ?>" value="<?php echo e(old('name')); ?>">
                <?php if($errors->has('name')): ?>
                    <span class="invalid-feedback" role="alert">
                        <strong><?php echo e($errors->first('name')); ?></strong>
                    </span>
                <?php endif; ?>
            </div>

            <div class="form-group">
                <label for="i-regions"><?php echo e(__('Regions')); ?></label>
                <select name="regions[]" id="i-regions" class="custom-select<?php echo e($errors->has('regions') ? ' is-invalid' : ''); ?>" multiple>
                    <?php $__currentLoopData = config('countries'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($key); ?>" <?php if(old('regions') !== null && in_array($key, old('regions'))): ?> selected <?php endif; ?>><?php echo e(__($value)); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
                <?php if($errors->has('regions')): ?>
                    <span class="invalid-feedback" role="alert">
                        <strong><?php echo e($errors->first('regions')); ?></strong>
                    </span>
                <?php endif; ?>
                <small class="form-text text-muted"><?php echo e(__('Leave empty to apply the tax rate on all regions.')); ?></small>
            </div>
            
            <div class="row mx-n2">
                <div class="col-12 col-md-6 px-2">
                    <div class="form-group">
                        <label for="i-percentage"><?php echo e(__('Percentage')); ?></label>
                        <div class="input-group">
                            <input type="text" name="percentage" id="i-percentage" class="form-control<?php echo e($errors->has('percentage') ? ' is-invalid' : ''); ?>" value="<?php echo e(old('percentage')); ?>">
                            <div class="input-group-append">
                                <span class="input-group-text">%</span>
                            </div>
                        </div>
                        <?php if($errors->has('percentage')): ?>
                            <span class="invalid-feedback d-block" role="alert">
                                <strong><?php echo e($errors->first('percentage')); ?></strong>
                            </span>
                        <?php endif; ?>
                    </div>
                </div>
                
                <div class="col-12 col-md-6 px-2">
                    <label for="i-type"><?php echo e(__('Type')); ?></label>
                    <select name="type" id="i-type" class="custom-select<?php echo e($errors->has('type') ? ' is-invalid' : ''); ?>">
                        <?php $__currentLoopData = [0 => __('Inclusive'), 1 => __('Exclusive')]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($key); ?>" <?php if(old('type') == $key): ?> selected <?php endif; ?>><?php echo e($value); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                    <?php if($errors->has('type')): ?>
                        <span class="invalid-feedback d-block" role="alert">
                            <strong><?php echo e($errors->first('type')); ?></strong>
                        </span>
                    <?php endif; ?>
                </div>
            </div>

            <button type="submit" name="submit" class="btn btn-primary"><?php echo e(__('Save')); ?></button>
        </form>
    </div>
</div><?php /**PATH /home/datanito/public_html/analytics.datanito.com/resources/views/admin/tax-rates/new.blade.php ENDPATH**/ ?>