<?php
include_once includes('config.php');
?>
<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>{{headline}}</title>


    <style>
        /* Customize the styles to match your desired design */
        body {
            font-family: Arial, sans-serif;
            margin: 0;
            padding: 0;
            background-color: #f8f8f8;
        }

        .container {
            max-width: 600px;
            margin: 0 auto;
            padding: 20px;
            text-align: center;
        }
        .content {
            max-width: 600px;
            margin: 0 auto;
            padding: 20px;
            text-align: center;
            background-color: #fff;
        }

        h1 {
            font-size: 24px;
            margin-bottom: 20px;
        }

        p {
            margin-bottom: 10px;
        }


        .button {
            display: inline-block;
            background-color: #015084;
            color: #ffffff;
            padding: 10px 20px;
            text-decoration: none;
            border-radius: 4px;
        }

        .button:hover {
            background-color: #217dbb;
        }
        .brand-logo{
            width: 2em;
            height: 2em;
        }
        .footer {
            margin-top: 20px;
            font-size: 14px;
            color: #888888;
        }

        .footer a {
            font-size: 14px;
            color: #888888;
            text-decoration: none;
        }
    </style>
</head>
<body>
<div class="container">
    <div class="content">
        <h1>{{headline}}</h1>
        <p>{{hello}} {{user_name}},</p>
        <p>{{email-p1}}</p>
        <p><a class="button" href="{{cta-link}}">{{cta}}</a></p>
        <p>{{email-p2}}</p>
    </div>

    <div class="footer">
        <a href="https://datanito.com">
            <img class="brand-logo" src="/assets/images/brand/datanito-logo.png" alt="Datanito Logo">
        </a>
        <p>{{email-copyright}}</p>
    </div>
</div>
</body>
</html>
