<?php
$meta = array(
    'us' => array(
        'title' => 'Minimalistic WooCommerce Theme - Storfy',
        'description' => 'Unlock the power of minimalistic design with Storfy - the perfect WooCommerce theme for your online store. Coming soon from Datanito.',
        'og:title' => 'Minimalistic WooCommerce Theme - Storfy',
        'og:description' => 'Unlock the power of minimalistic design with Storfy - the perfect WooCommerce theme for your online store. Coming soon from Datanito.',
        'og:image' => asset('images/brand/storfy_preview.jpg'),
    ),
    'tr' => array(
        'title' => 'Minimalist WooCommerce Teması - Storfy (Türkiye)',
        'description' => 'Minimal tasarımın gücünü Storfy ile keşfedin - online mağazanız için mükemmel WooCommerce teması. Yakında Datanito\'dan geliyor.',
        'og:title' => 'Minimalist WooCommerce Teması - Storfy',
        'og:description' => 'Minimal tasarımın gücünü Storfy ile keşfedin - online mağazanız için mükemmel WooCommerce teması. Yakında Datanito\'dan geliyor.',
        'og:image' => asset('images/brand/storfy_preview.jpg'),
    ),
);
$currentMeta = setCountryAndMeta($meta);
include_once includes('layouts/header.php');
?>

<div id="content" class="container mx-auto lg:mt-5 mt-10">
    <section class="bg-white dark:bg-dark-900 justify-center my-32 sm:my-60">
        <div class="py-8 px-4 mx-auto max-w-screen-xl lg:py-16 lg:px-6">
            <div class="mx-auto max-w-screen-sm text-center">
                <h1 class="mb-4 text-3xl tracking-tight font-bold text-gray-900 md:text-4xl dark:text-white">Minimalistic WooCommerce Theme - Storfy</h1>
                <p class="mb-8 text-lg text-gray-700 dark:text-gray-300">Unlock the power of minimalistic design with Storfy - the perfect WooCommerce theme for your online store. Coming soon from Datanito.</p>
                <a href="https://studio.datanito.com/storfy/" class="inline-flex text-white hover:text-white bg-blue-600 hover:bg-blue-800 focus:ring-4 focus:outline-none focus:ring-blue-300 font-medium rounded-3xl text-sm px-5 py-2.5 text-center dark:focus:ring-blue-900"><?php echo $lang['learn-more']?></a>
            </div>
        </div>
    </section>
</div>

<?php
include_once includes('layouts/footer.php');
?>
