<?php
$meta = array(
    'us' => array(
        'title' => 'Datanito Pay - POS - Datanito',
        'description' => 'Oops! The page you are looking for could not be found. Unlock the power of web design, app development, and SEO with Datanito.',
        'og:title' => '404 Not Found - Datanito',
        'og:description' => 'Oops! The page you are looking for could not be found. Unlock the power of web design, app development, and SEO with Datanito.',
        'og:image' => asset('images/brand/open_graph_logo.png'),
    ),
    'tr' => array(
        'title' => 'Datanito Pay - POS - Datanito (Türkiye)',
        'description' => 'Ups! Aradığınız sayfa bulunamadı. Web tasarımının, uygulama geliştirmenin ve SEO\'nun gücünü Datanito ile keşfedin.',
        'og:title' => '404 Bulunamadı - Datanito',
        'og:description' => 'Ups! Aradığınız sayfa bulunamadı. Web tasarımının, uygulama geliştirmenin ve SEO\'nun gücünü Datanito ile keşfedin.',
        'og:image' => asset('images/brand/open_graph_logo.png'),
    ),
);

$currentMeta = setCountryAndMeta($meta);
include_once includes('layouts/header.php');
?>

<div id="content" class="container flex items-center justify-center min-h-screen mx-auto p-4">
    <div class="bg-white dark:bg-gray-800 border border-gray-200 dark:border-gray-700 rounded-xl my-36 shadow-lg w-full max-w-md">
        <!-- Step 1: Kart Bilgilerini Topla -->
        <div id="pay-step1" class="p-6">
            <h1 class="text-2xl font-bold mb-6 text-center text-gray-900 dark:text-white">Güvenli Ödeme</h1>
            <form id="payment-form" method="POST">
                <!-- Tutar Girişi -->
                <div class="mb-4">
                    <label for="amount" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Tutar (TRY)</label>
                    <input type="number" id="amount" name="amount" step="0.01" min="1" class="mt-1 block w-full px-3 py-2 border border-gray-300 dark:border-gray-600 rounded-md shadow-sm focus:outline-none focus:ring-blue-500 focus:border-blue-500 dark:bg-gray-700 dark:text-white" required>
                </div>

                <!-- Kart Numarası -->
                <div class="mb-4">
                    <label for="card-number" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Kart Numarası</label>
                    <input type="text" id="card-number" name="card-number" class="mt-1 block w-full px-3 py-2 border border-gray-300 dark:border-gray-600 rounded-md shadow-sm focus:outline-none focus:ring-blue-500 focus:border-blue-500 dark:bg-gray-700 dark:text-white" required>
                </div>

                <!-- Son Kullanma Tarihi -->
                <div class="grid grid-cols-2 gap-4 mb-4">
                    <div>
                        <label for="expiration-month" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Son Kullanma Ayı</label>
                        <select id="expiration-month" name="expiration-month" class="mt-1 block w-full px-3 py-2 border border-gray-300 dark:border-gray-600 rounded-md shadow-sm focus:outline-none focus:ring-blue-500 focus:border-blue-500 dark:bg-gray-700 dark:text-white" required>
                            <option value="" disabled selected>Ay</option>
                            <?php for ($i = 1; $i <= 12; $i++): ?>
                                <option value="<?= str_pad($i, 2, '0', STR_PAD_LEFT) ?>"><?= str_pad($i, 2, '0', STR_PAD_LEFT) ?></option>
                            <?php endfor; ?>
                        </select>
                    </div>
                    <div>
                        <label for="expiration-year" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Son Kullanma Yılı</label>
                        <select id="expiration-year" name="expiration-year" class="mt-1 block w-full px-3 py-2 border border-gray-300 dark:border-gray-600 rounded-md shadow-sm focus:outline-none focus:ring-blue-500 focus:border-blue-500 dark:bg-gray-700 dark:text-white" required>
                            <option value="" disabled selected>Yıl</option>
                            <?php for ($i = date('Y'); $i <= date('Y') + 10; $i++): ?>
                                <option value="<?= substr($i, -2) ?>"><?= $i ?></option>
                            <?php endfor; ?>
                        </select>
                    </div>
                </div>

                <!-- CVV -->
                <div class="mb-6">
                    <label for="cvv" class="block text-sm font-medium text-gray-700 dark:text-gray-300">CVV</label>
                    <input type="text" id="cvv" name="cvv" maxlength="4" class="mt-1 block w-full px-3 py-2 border border-gray-300 dark:border-gray-600 rounded-md shadow-sm focus:outline-none focus:ring-blue-500 focus:border-blue-500 dark:bg-gray-700 dark:text-white" required>
                </div>

                <!-- Kart Sahibi -->
                <div class="mb-6">
                    <label for="card-holder" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Kart Sahibi</label>
                    <input type="text" id="card-holder" name="card-holder" class="mt-1 block w-full px-3 py-2 border border-gray-300 dark:border-gray-600 rounded-md shadow-sm focus:outline-none focus:ring-blue-500 focus:border-blue-500 dark:bg-gray-700 dark:text-white" required>
                </div>

                <!-- Auto Auth Status -->
                <div id="auto-auth-status" class="hidden mb-4 p-3 rounded bg-blue-50 dark:bg-blue-900 text-blue-800 dark:text-blue-100">
                    <div class="flex items-center">
                        <svg class="animate-spin -ml-1 mr-2 h-4 w-4 text-blue-500" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24">
                            <circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle>
                            <path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path>
                        </svg>
                        <span>Kart bilgileri kontrol ediliyor...</span>
                    </div>
                </div>

                <!-- Installment Options (Will be populated after Auth) -->
                <div id="installment-options-container" class="hidden mb-4">
                    <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">Taksit Seçenekleri</label>
                    <div id="installment-options" class="grid grid-cols-2 gap-3"></div>
                    <input type="hidden" id="installment-count" name="installment-count" value="1">
                </div>

                <!-- Payment Type Selection -->
                <div id="payment-type-container" class="mb-4">
                    <label for="payment-type" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Ödeme Türü</label>
                    <select id="payment-type" name="payment-type" class="mt-1 block w-full px-3 py-2 border border-gray-300 dark:border-gray-600 rounded-md shadow-sm focus:outline-none focus:ring-blue-500 focus:border-blue-500 dark:bg-gray-700 dark:text-white" required>
                        <option value="Sale">Tek Çekim</option>
                        <option value="Installment">Taksitli Ödeme</option>
                    </select>
                </div>

                <!-- Card Brand Info -->
                <div id="card-brand-info" class="hidden mb-4 p-2 rounded bg-gray-50 dark:bg-gray-700 text-center">
                    <img id="card-brand-logo" src="" alt="Card Brand" class="h-8 mx-auto">
                    <div id="card-brand-name" class="text-sm mt-1"></div>
                </div>

                <!-- Ödeme Butonu -->
                <button type="button" id="pay-button" class="w-full flex items-center justify-center h-10 text-white bg-blue-600 hover:bg-blue-700 focus:ring-4 focus:ring-blue-300 font-medium rounded-lg text-sm px-5 py-2.5 dark:bg-blue-600 dark:hover:bg-blue-700 dark:focus:ring-blue-800" disabled>
                    <span id="payment-spinner" class="spinner-status opacity-0 mr-2">
                        <svg aria-hidden="true" class="w-5 h-5 text-gray-200 animate-spin dark:text-gray-600 fill-blue-600" viewBox="0 0 100 101" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path d="M100 50.5908C100 78.2051 77.6142 100.591 50 100.591C22.3858 100.591 0 78.2051 0 50.5908C0 22.9766 22.3858 0.59082 50 0.59082C77.6142 0.59082 100 22.9766 100 50.5908ZM9.08144 50.5908C9.08144 73.1895 27.4013 91.5094 50 91.5094C72.5987 91.5094 90.9186 73.1895 90.9186 50.5908C90.9186 27.9921 72.5987 9.67226 50 9.67226C27.4013 9.67226 9.08144 27.9921 9.08144 50.5908Z" fill="currentColor"/>
                            <path d="M93.9676 39.0409C96.393 38.4038 97.8624 35.9116 97.0079 33.5539C95.2932 28.8227 92.871 24.3692 89.8167 20.348C85.8452 15.1192 80.8826 10.7238 75.2124 7.41289C69.5422 4.10194 63.2754 1.94025 56.7698 1.05124C51.7666 0.367541 46.6976 0.446843 41.7345 1.27873C39.2613 1.69328 37.813 4.19778 38.4501 6.62326C39.0873 9.04874 41.5694 10.4717 44.0505 10.1071C47.8511 9.54855 51.7191 9.52689 55.5402 10.0491C60.8642 10.7766 65.9928 12.5457 70.6331 15.2552C75.2735 17.9648 79.3347 21.5619 82.5849 25.841C84.9175 28.9121 86.7997 32.2913 88.1811 35.8758C89.083 38.2158 91.5421 39.6781 93.9676 39.0409Z" fill="currentFill"/>
                        </svg>
                    </span>
                    <span id="payment-text">Ödemeyi Tamamla</span>
                </button>
            </form>
        </div>

        <!-- Step 2: 3D Secure Iframe -->
        <div id="pay-step2" class="hidden p-6">
            <h1 class="text-2xl font-bold mb-6 text-center text-gray-900 dark:text-white">Ödemeyi Tamamla</h1>
            <div id="iframe-container" class="w-full h-96 border border-gray-300 dark:border-gray-600 rounded-lg overflow-hidden">
                <!-- Iframe buraya eklenecek -->
            </div>
        </div>

        <!-- Step 3: Ödeme Sonucu -->
        <div id="pay-step3" class="hidden p-6">
            <h1 class="text-2xl font-bold mb-6 text-center text-gray-900 dark:text-white">Ödeme Sonucu</h1>
            <div id="payment-result" class="text-center text-gray-700 dark:text-gray-300">
                <!-- Sonuç mesajı buraya eklenecek -->
            </div>
            <button id="try-again" class="w-full mt-4 text-white bg-blue-600 hover:bg-blue-700 focus:ring-4 focus:ring-blue-300 font-medium rounded-lg text-sm px-5 py-2.5 dark:bg-blue-600 dark:hover:bg-blue-700 dark:focus:ring-blue-800">Tekrar Dene</button>
        </div>

    </div>
</div>

<?php
include_once includes('layouts/footer.php');
?>

<script>
    $(document).ready(function () {
        // Variables to store auth response and card info
        let authResponse = null;
        let cardDetailsValid = false;
        let currentCardBrand = null;

        // Card brand detection patterns
        const cardBrands = {
            visa: {
                pattern: /^4/,
                name: "Visa",
                logo: "<?php echo asset('images/cards/visa.png'); ?>",
                maxInstallment: 12
            },
            mastercard: {
                pattern: /^5[1-5]/,
                name: "Mastercard",
                logo: "<?php echo asset('images/cards/mastercard.png'); ?>",
                maxInstallment: 12
            },
            amex: {
                pattern: /^3[47]/,
                name: "American Express",
                logo: "<?php echo asset('images/cards/amex.png'); ?>",
                maxInstallment: 6
            },
            troy: {
                pattern: /^9792/,
                name: "Troy",
                logo: "<?php echo asset('images/cards/troy.png'); ?>",
                maxInstallment: 9
            },
            default: {
                name: "Banka Kartı",
                logo: "<?php echo asset('images/cards/default.png'); ?>",
                maxInstallment: 3
            }
        };

        // Detect card brand based on number
        function detectCardBrand(cardNumber) {
            cardNumber = cardNumber.replace(/\s/g, '');
            for (const [brand, data] of Object.entries(cardBrands)) {
                if (data.pattern && cardNumber.match(data.pattern)) {
                    return brand;
                }
            }
            return 'default';
        }

        // Update card brand display
        function updateCardBrandDisplay(cardNumber) {
            const brand = detectCardBrand(cardNumber);
            currentCardBrand = brand;

            if (cardNumber.length > 6) {
                $('#card-brand-info').removeClass('hidden');
                $('#card-brand-logo').attr('src', cardBrands[brand].logo);
                $('#card-brand-name').text(cardBrands[brand].name);
            } else {
                $('#card-brand-info').addClass('hidden');
            }
        }

        // Function to perform auto-auth when card details are entered
        function checkCardDetails() {
            const cardNumber = $('#card-number').val().trim().replace(/\s/g, '');
            const expMonth = $('#expiration-month').val();
            const expYear = $('#expiration-year').val();
            const cvv = $('#cvv').val().trim();
            const cardHolder = $('#card-holder').val().trim();
            const amount = parseFloat($('#amount').val());

            // Basic validation
            if (cardNumber.length >= 15 && expMonth && expYear && cvv.length >= 3 && cardHolder && amount > 0) {
                cardDetailsValid = true;
                updateCardBrandDisplay(cardNumber);
                performAutoAuth();
            } else {
                cardDetailsValid = false;
                $('#pay-button').prop('disabled', true);
                $('#auto-auth-status').addClass('hidden');
                $('#installment-options-container').addClass('hidden');
            }
        }

        // Perform auto-auth transaction
        function performAutoAuth() {
            if (!cardDetailsValid) return;

            $('#auto-auth-status').removeClass('hidden').html(`
            <div class="flex items-center">
                <svg class="animate-spin -ml-1 mr-2 h-4 w-4 text-blue-500" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24">
                    <circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle>
                    <path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path>
                </svg>
                <span>Kart bilgileri kontrol ediliyor...</span>
            </div>
        `);

            const authData = {
                transactionType: "Auth",
                cardNumber: $('#card-number').val().trim().replace(/\s/g, ''),
                expirationMonth: $('#expiration-month').val(),
                expirationYear: $('#expiration-year').val(),
                cvv: $('#cvv').val().trim(),
                cardHolder: $('#card-holder').val().trim(),
                clientIp: "<?php echo $_SERVER['REMOTE_ADDR']; ?>",
                amount: $('#amount').val()
            };

            $.ajax({
                type: 'POST',
                url: '/linkpay_auth',
                data: authData,
                success: function (response) {
                    console.log(response);
                    try {
                        const result = JSON.parse(response);
                        console.log('Auth Response:', result);

                        if (result.success) {
                            authResponse = result;
                            showSuccessAuth(result);
                            loadInstallmentOptions(result);
                        } else {
                            showAuthError(result.message || "Kart doğrulama başarısız oldu");
                        }
                    } catch (e) {
                        console.error("Error parsing response:", e);
                        showAuthError("Kart bilgileri kontrol edilirken bir hata oluştu");
                    }
                },
                error: function (xhr, status, error) {
                    console.error(error);
                    showAuthError("Bağlantı hatası oluştu, lütfen tekrar deneyin");
                }
            });
        }

        // Show successful auth response
        function showSuccessAuth(result) {
            $('#auto-auth-status').removeClass('hidden').html(`
            <div class="flex items-center text-green-600 dark:text-green-400">
                <svg class="h-5 w-5 mr-2" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7" />
                </svg>
                <span>Kart bilgileri doğrulandı</span>
            </div>
        `);

            $('#pay-button').prop('disabled', false);
        }

        // Show auth error
        function showAuthError(message) {
            $('#auto-auth-status').removeClass('hidden').html(`
            <div class="flex items-center text-red-600 dark:text-red-400">
                <svg class="h-5 w-5 mr-2" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12" />
                </svg>
                <span>${message}</span>
            </div>
        `);

            $('#installment-options-container').addClass('hidden');
            $('#pay-button').prop('disabled', true);
        }

        // Load installment options based on auth response
        function loadInstallmentOptions(result) {
            const amount = parseFloat($('#amount').val());
            const maxInstallment = currentCardBrand ? cardBrands[currentCardBrand].maxInstallment : 3;

            let optionsHtml = '';
            const baseOptions = [
                { count: 1, text: "Tek Çekim", total: amount, monthly: amount }
            ];

            // Generate installment options based on card brand's max installment
            for (let i = 2; i <= maxInstallment; i++) {
                let monthly = amount / i;
                let total = amount;

                // Apply interest after 3 installments (example logic)
                if (i > 3) {
                    const interestRate = 0.02 * (i - 3); // 2% per additional month
                    total = amount * (1 + interestRate);
                    monthly = total / i;
                }

                baseOptions.push({
                    count: i,
                    text: `${i} Taksit`,
                    total: total.toFixed(2),
                    monthly: monthly.toFixed(2)
                });
            }

            baseOptions.forEach(option => {
                optionsHtml += `
                <div class="border rounded p-3 text-center cursor-pointer hover:bg-blue-50 dark:hover:bg-gray-700 installment-option ${option.count === 1 ? 'border-blue-500 bg-blue-50 dark:bg-blue-900' : ''}"
                     data-count="${option.count}">
                    <div class="font-bold">${option.text}</div>
                    <div class="text-sm mt-1">${option.monthly} TL x ${option.count}</div>
                    <div class="text-sm font-semibold mt-1">Toplam: ${option.total} TL</div>
                </div>
            `;
            });

            $('#installment-options').html(optionsHtml);
            $('#installment-options-container').removeClass('hidden');
            $('#installment-count').val(1); // Default to single payment

            // Handle installment selection
            $('.installment-option').on('click', function() {
                $('.installment-option').removeClass('border-blue-500 bg-blue-50 dark:bg-blue-900');
                $(this).addClass('border-blue-500 bg-blue-50 dark:bg-blue-900');
                $('#installment-count').val($(this).data('count'));
            });
        }

        // Handle payment type change
        $('#payment-type').on('change', function() {
            if ($(this).val() === 'Installment') {
                $('#installment-options-container').removeClass('hidden');
            } else {
                $('#installment-options-container').addClass('hidden');
                $('#installment-count').val(1);
                $('.installment-option').removeClass('border-blue-500 bg-blue-50 dark:bg-blue-900');
                $('.installment-option[data-count="1"]').addClass('border-blue-500 bg-blue-50 dark:bg-blue-900');
            }
        });

        // Event listeners for card details changes
        $('#card-number, #expiration-month, #expiration-year, #cvv, #card-holder, #amount').on('input change', function() {
            if ($(this).attr('id') === 'card-number') {
                updateCardBrandDisplay($(this).val());
            }
            checkCardDetails();
        });

        // Handle payment submission
        $('#pay-button').on('click', function() {
            if (!cardDetailsValid || !authResponse) {
                showAuthError("Lütfen kart bilgilerinizi kontrol edin");
                return;
            }

            const $button = $(this);
            $button.prop('disabled', true);
            $('#payment-spinner').removeClass('opacity-0');
            $('#payment-text').text('İşlem yapılıyor...');

            const formData = {
                amount: $('#amount').val(),
                cardNumber: $('#card-number').val().trim().replace(/\s/g, ''),
                expirationMonth: $('#expiration-month').val(),
                expirationYear: $('#expiration-year').val(),
                cvv: $('#cvv').val().trim(),
                cardHolder: $('#card-holder').val().trim(),
                installmentCount: $('#installment-count').val() || 1,
                paymentType: $('#payment-type').val(),
                authCode: authResponse.authCode,
                authTransactionId: authResponse.transactionId
            };

            $.ajax({
                type: 'POST',
                url: '/linkpay_process',
                data: formData,
                success: function(response) {
                    $('#payment-spinner').addClass('opacity-0');
                    $('#payment-text').text('Ödemeyi Tamamla');
                    $button.prop('disabled', false);

                    try {
                        const result = JSON.parse(response);
                        console.log(result);

                        if (result.success) {
                            $('#pay-step1').addClass('hidden');
                            $('#pay-step2').removeClass('hidden');
                            $('#iframe-container').html(result.iframe);
                        } else {
                            showAuthError(result.message || "Ödeme işlemi başarısız oldu");
                        }
                    } catch (e) {
                        console.error("Error parsing response:", e);
                        showAuthError("Bir hata oluştu, lütfen tekrar deneyin");
                    }
                },
                error: function(xhr, status, error) {
                    $('#payment-spinner').addClass('opacity-0');
                    $('#payment-text').text('Ödemeyi Tamamla');
                    $button.prop('disabled', false);
                    console.error(error);
                    showAuthError("Bağlantı hatası oluştu, lütfen tekrar deneyin");
                }
            });
        });

        // Handle Try Again button
        $('#try-again').on('click', function() {
            $('#pay-step3').addClass('hidden');
            $('#pay-step1').removeClass('hidden');
            checkCardDetails();
        });

        // Initialize with single payment selected
        $('.installment-option[data-count="1"]').addClass('border-blue-500 bg-blue-50 dark:bg-blue-900');
    });
</script>