<?php
$meta = array(
    'us' => array(
        'title' => 'Datanito Pay - POS - Datanito',
        'description' => 'Datanito Pay - POS - Mail Order - Datanito',
        'og:title' => 'Datanito Pay - POS - Datanito',
        'og:description' => 'Datanito Pay - POS - Mail Order - Datanito',
        'og:image' => asset('images/brand/open_graph_logo.png'),
    ),
    'tr' => array(
        'title' => 'Datanito Pay - POS - Datanito (Türkiye)',
        'description' => 'Datanito Pay - POS - Mail Order - Datanito',
        'og:title' => 'Datanito Pay - POS - Datanito (Türkiye)',
        'og:description' => 'Datanito Pay - POS - Mail Order - Datanito',
        'og:image' => asset('images/brand/open_graph_logo.png'),
    ),
);

// Set the current metadata based on the user's country
$currentMeta = setCountryAndMeta($meta);
include_once includes('layouts/header.php');
?>

<style>
    body {
        margin: 0;
        padding: 0;
        font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;
        background-color: #f8fafc;
        color: #1e293b;
    }
    #chat-circle,#bottom-banner{
        display: none!important;
    }
</style>

<div class="min-h-screen bg-gray-50 dark:bg-gray-900 py-12 px-4 lg:pt-20 sm:px-6 lg:px-8">
    <div class="max-w-md w-full mx-auto">
        <!-- Payment Card -->
        <div class="bg-white dark:bg-gray-800 rounded-xl shadow-lg overflow-hidden">
            <!-- Header -->
            <div class="bg-gradient-to-r from-dark-600 to-dark-500 p-6 text-white">
                <div class="flex items-center justify-between">
                    <div>
                        <h1 class="text-2xl font-bold">Güvenli Ödeme</h1>
                        <p class="text-blue-100 text-sm mt-1">Ödeme bilgileriniz 256-bit SSL ile korunmaktadır</p>
                    </div>
                    <div class="flex items-center space-x-2">
                        <svg xmlns="http://www.w3.org/2000/svg" class="h-8 w-8" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 10h18M7 15h1m4 0h1m-7 4h12a3 3 0 003-3V8a3 3 0 00-3-3H6a3 3 0 00-3 3v8a3 3 0 003 3z" />
                        </svg>
                        <span class="font-medium">Datanito Pay</span>
                    </div>
                </div>
            </div>

            <!-- Payment Steps -->
            <div class="p-6">
                <!-- Step Indicators -->
                <div class="flex items-center justify-between mb-8">
                    <div class="flex flex-col items-center">
                        <div id="step-1" class="w-10 h-10 rounded-full bg-gray-200 dark:bg-gray-600 text-gray-600 dark:text-gray-300 flex items-center justify-center font-bold">1</div>
                        <span class="text-xs mt-1 text-gray-600 dark:text-gray-300">Bilgiler</span>
                    </div>
                    <div class="flex-1 h-1 bg-gray-200 mx-2" id="line-1-2"></div>
                    <div class="flex flex-col items-center">
                        <div id="step-2" class="w-10 h-10 rounded-full bg-gray-200 dark:bg-gray-600 text-gray-600 dark:text-gray-300 flex items-center justify-center font-bold">2</div>
                        <span class="text-xs mt-1 text-gray-600 dark:text-gray-300">Doğrulama</span>
                    </div>
                    <div class="flex-1 h-1 bg-gray-200 mx-2" id="line-2-3"></div>
                    <div class="flex flex-col items-center">
                        <div id="step-3" class="w-10 h-10 rounded-full bg-gray-200 dark:bg-gray-600 text-gray-600 dark:text-gray-300 flex items-center justify-center font-bold">3</div>
                        <span class="text-xs mt-1 text-gray-600 dark:text-gray-300">Sonuç</span>
                    </div>
                </div>

                <!-- Step 1: Kart Bilgileri -->
                <div id="pay-step1">
                    <form id="payment-form" method="POST">
                        <!-- Ödeme Türü -->
                        <div class="mb-6">
                            <label for="payment-type" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">Ödeme Türü</label>
                            <div class="relative">
                                <select id="payment-type" name="payment-type" class="appearance-none block w-full px-4 py-3 border border-gray-300 dark:border-gray-600 rounded-lg shadow-sm focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500 dark:bg-gray-700 dark:text-white" required>
                                    <option value="Sale">Tek Çekim</option>
                                    <option value="SaleTaksit">Taksitli Çekim</option>
                                    <option value="VFTSale">Puan Harcama</option>
                                    <option value="VFTSale">Vade Farklı Satış</option>
                                    <option value="Auth">Ön Provizyon</option>
                                </select>
                            </div>
                        </div>

                        <!-- Ön Provizyon Bilgisi -->
                        <div class="mb-6 hidden" id="auth-installment-info">
                            <div class="bg-blue-50 dark:bg-blue-900/20 border border-blue-200 dark:border-blue-800 rounded-lg p-4">
                                <h3 class="font-bold text-blue-800 dark:text-blue-200 mb-2 flex items-center">
                                    <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 mr-2" viewBox="0 0 20 20" fill="currentColor">
                                        <path fill-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7-4a1 1 0 11-2 0 1 1 0 012 0zM9 9a1 1 0 000 2v3a1 1 0 001 1h1a1 1 0 100-2h-1V9z" clip-rule="evenodd" />
                                    </svg>
                                    Ön Provizyon Bilgileri
                                </h3>
                                <p class="text-sm text-blue-700 dark:text-blue-300">
                                    Kartınızla ön provizyon alınacaktır. Taksit seçenekleri provizyon alındıktan sonra gösterilecektir.
                                </p>
                                <div class="grid grid-cols-3 gap-3 mt-3" id="installment-options">
                                    <!-- Taksit seçenekleri buraya gelecek -->
                                </div>
                            </div>
                        </div>

                        <!-- Hata Mesajı -->
                        <div class="showError flex items-center p-4 mb-6 text-sm text-red-800 rounded-lg bg-red-50 dark:bg-gray-800 dark:text-red-400 hidden" role="alert">
                            <svg class="shrink-0 inline w-5 h-5 mr-3" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="currentColor" viewBox="0 0 20 20">
                                <path d="M10 .5a9.5 9.5 0 1 0 9.5 9.5A9.51 9.51 0 0 0 10 .5ZM9.5 4a1.5 1.5 0 1 1 0 3 1.5 1.5 0 0 1 0-3ZM12 15H8a1 1 0 0 1 0-2h1v-3H8a1 1 0 0 1 0-2h2a1 1 0 0 1 1 1v4h1a1 1 0 0 1 0 2Z"/>
                            </svg>
                            <div class="error-message"></div>
                        </div>

                        <!-- Tutar -->
                        <div class="mb-6">
                            <label for="amount" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">Tutar (₺)</label>
                            <div class="relative">
                                <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                    <span class="text-gray-500 dark:text-gray-400">₺</span>
                                </div>
                                <input type="number" id="amount" name="amount" step="0.01" class="block w-full pl-10 pr-4 py-3 border border-gray-300 dark:border-gray-600 rounded-lg shadow-sm focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500 dark:bg-gray-700 dark:text-white" placeholder="0,00" required>
                            </div>
                        </div>

                        <!-- Kart Bilgileri -->
                        <div class="mb-6">
                            <label for="card-number" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">Kart Numarası</label>
                            <div class="relative">
                                <input type="text" id="card-number" name="card-number" class="block w-full px-4 py-3 border border-gray-300 dark:border-gray-600 rounded-lg shadow-sm focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500 dark:bg-gray-700 dark:text-white" placeholder="1234 5678 9012 3456" required>
                                <div class="absolute inset-y-0 right-0 flex items-center pr-3">
                                    <div id="card-type" class="w-8 h-5"></div>
                                </div>
                            </div>
                        </div>

                        <!-- Kart Son Kullanma Tarihi ve CVV -->
                        <div class="grid grid-cols-2 gap-4 mb-6">
                            <div>
                                <label for="expiration-month" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">Son Kullanma Tarihi</label>
                                <div class="grid grid-cols-2 gap-2">
                                    <div class="relative">
                                        <select id="expiration-month" name="expiration-month" class="appearance-none block w-full px-4 py-3 border border-gray-300 dark:border-gray-600 rounded-lg shadow-sm focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500 dark:bg-gray-700 dark:text-white" required>
                                            <option value="" disabled selected>Ay</option>
                                            <?php for ($i = 1; $i <= 12; $i++): ?>
                                                <option value="<?= str_pad($i, 2, '0', STR_PAD_LEFT) ?>"><?= str_pad($i, 2, '0', STR_PAD_LEFT) ?></option>
                                            <?php endfor; ?>
                                        </select>
                                    </div>
                                    <div class="relative">
                                        <select id="expiration-year" name="expiration-year" class="appearance-none block w-full px-4 py-3 border border-gray-300 dark:border-gray-600 rounded-lg shadow-sm focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500 dark:bg-gray-700 dark:text-white" required>
                                            <option value="" disabled selected>Yıl</option>
                                            <?php for ($i = date('Y'); $i <= date('Y') + 10; $i++): ?>
                                                <option value="<?= substr($i, -2) ?>"><?= $i ?></option>
                                            <?php endfor; ?>
                                        </select>
                                    </div>
                                </div>
                            </div>
                            <div>
                                <label for="cvv" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">CVV</label>
                                <div class="relative">
                                    <input type="text" id="cvv" name="cvv" maxlength="3" class="block w-full px-4 py-3 border border-gray-300 dark:border-gray-600 rounded-lg shadow-sm focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500 dark:bg-gray-700 dark:text-white" placeholder="•••" required>
                                    <div class="absolute inset-y-0 right-0 flex items-center pr-3">
                                        <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 text-gray-400" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 15v2m-6 4h12a2 2 0 002-2v-6a2 2 0 00-2-2H6a2 2 0 00-2 2v6a2 2 0 002 2zm10-10V7a4 4 0 00-8 0v4h8z" />
                                        </svg>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Kart Sahibi -->
                        <div class="mb-6">
                            <label for="card-holder" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">Kart Sahibi</label>
                            <input type="text" id="card-holder" name="card-holder" class="block w-full px-4 py-3 border border-gray-300 dark:border-gray-600 rounded-lg shadow-sm focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500 dark:bg-gray-700 dark:text-white" placeholder="Ad Soyad" required>
                        </div>

                        <!-- Taksit Sayısı -->
                        <div class="mb-6 hidden" id="installment-container">
                            <label for="installment-count" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">Taksit Sayısı</label>
                            <input type="number" id="installment-count" name="installment-count" min="2" max="12" class="block w-full px-4 py-3 border border-gray-300 dark:border-gray-600 rounded-lg shadow-sm focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500 dark:bg-gray-700 dark:text-white" placeholder="2-4 arası">
                        </div>

                        <!-- Ödeme Butonları -->
                        <div class="space-y-3">
                            <button type="button" id="process-payment" class="w-full flex justify-center items-center py-3 px-4 border border-transparent rounded-lg shadow-sm text-sm font-medium text-white bg-blue-600 hover:bg-blue-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500 transition-colors duration-200">
                                <span class="spinner-status opacity-0 mr-2">
                                    <svg aria-hidden="true" class="w-5 h-5 text-gray-200 animate-spin dark:text-gray-600 fill-blue-600" viewBox="0 0 100 101" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path d="M100 50.5908C100 78.2051 77.6142 100.591 50 100.591C22.3858 100.591 0 78.2051 0 50.5908C0 22.9766 22.3858 0.59082 50 0.59082C77.6142 0.59082 100 22.9766 100 50.5908ZM9.08144 50.5908C9.08144 73.1895 27.4013 91.5094 50 91.5094C72.5987 91.5094 90.9186 73.1895 90.9186 50.5908C90.9186 27.9921 72.5987 9.67226 50 9.67226C27.4013 9.67226 9.08144 27.9921 9.08144 50.5908Z" fill="currentColor"/>
                                        <path d="M93.9676 39.0409C96.393 38.4038 97.8624 35.9116 97.0079 33.5539C95.2932 28.8227 92.871 24.3692 89.8167 20.348C85.8452 15.1192 80.8826 10.7238 75.2124 7.41289C69.5422 4.10194 63.2754 1.94025 56.7698 1.05124C51.7666 0.367541 46.6976 0.446843 41.7345 1.27873C39.2613 1.69328 37.813 4.19778 38.4501 6.62326C39.0873 9.04874 41.5694 10.4717 44.0505 10.1071C47.8511 9.54855 51.7191 9.52689 55.5402 10.0491C60.8642 10.7766 65.9928 12.5457 70.6331 15.2552C75.2735 17.9648 79.3347 21.5619 82.5849 25.841C84.9175 28.9121 86.7997 32.2913 88.1811 35.8758C89.083 38.2158 91.5421 39.6781 93.9676 39.0409Z" fill="currentFill"/>
                                    </svg>
                                </span>
                                <span id="payment-button-text">Ödemeyi Tamamla</span>
                            </button>

                            <button type="button" id="open-auth-modal" class="w-full flex justify-center items-center py-3 px-4 border border-transparent rounded-lg shadow-sm text-sm font-medium text-white bg-green-600 hover:bg-green-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-green-500 transition-colors duration-200">
                                <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 mr-2" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1M21 12a9 9 0 11-18 0 9 9 0 0118 0z" />
                                </svg>
                                Ön Provizyon Yap
                            </button>
                        </div>
                    </form>
                </div>

                <!-- Step 2: 3D Secure -->
                <div id="pay-step2" class="hidden">
                    <div class="text-center mb-6">
                        <h2 class="text-xl font-bold text-gray-900 dark:text-white mb-2">3D Secure Doğrulama</h2>
                        <p class="text-gray-600 dark:text-gray-300">Lütfen bankanızın doğrulama sayfasına yönlendiriliyorsunuz...</p>
                    </div>
                    <div id="iframe-container" class="w-full h-96 border border-gray-200 dark:border-gray-700 rounded-lg overflow-hidden">
                        <!-- Iframe buraya eklenecek -->
                    </div>
                    <div class="mt-4 text-center text-sm text-gray-500 dark:text-gray-400">
                        <p>Bu işlem birkaç saniye sürebilir. Lütfen sayfayı kapatmayın.</p>
                    </div>
                </div>

                <!-- Step 3: Ödeme Sonucu -->
                <div id="pay-step3" class="hidden">
                    <div class="text-center">
                        <div class="mx-auto flex items-center justify-center h-12 w-12 rounded-full bg-green-100 dark:bg-green-900 mb-4">
                            <svg class="h-6 w-6 text-green-600 dark:text-green-400" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7" />
                            </svg>
                        </div>
                        <h2 class="text-xl font-bold text-gray-900 dark:text-white mb-2">Ödeme Başarılı!</h2>
                        <div id="payment-result" class="text-gray-600 dark:text-gray-300 mb-6">
                            <!-- Sonuç mesajı buraya eklenecek -->
                        </div>
                        <button id="try-again" class="w-full flex justify-center py-3 px-4 border border-transparent rounded-lg shadow-sm text-sm font-medium text-white bg-blue-600 hover:bg-blue-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500">
                            Yeni Ödeme Yap
                        </button>
                    </div>
                </div>
            </div>

            <!-- Footer -->
            <div class="bg-gray-50 dark:bg-gray-700 px-6 py-4 border-t border-gray-200 dark:border-gray-600">
                <div class="flex items-center justify-between">
                    <div class="flex items-center space-x-2">
                        <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 text-green-500" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m5.618-4.016A11.955 11.955 0 0112 2.944a11.955 11.955 0 01-8.618 3.04A12.02 12.02 0 003 9c0 5.591 3.824 10.29 9 11.622 5.176-1.332 9-6.03 9-11.622 0-1.042-.133-2.052-.382-3.016z" />
                        </svg>
                        <span class="text-sm text-gray-600 dark:text-gray-300">Güvenli Ödeme</span>
                    </div>
                    <div class="flex items-center space-x-4">
                        <img src="<?= asset('images/content/logos/visa.png') ?>" alt="Visa" class="h-6">
                        <img src="<?= asset('images/content/logos/mastercard.png') ?>" alt="Mastercard" class="h-6">
                        <img src="<?= asset('images/content/logos/troy.png') ?>" alt="Troy" class="h-6">
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Auth Modal -->
<div id="auth-modal" class="fixed inset-0 z-50 hidden overflow-y-auto">
    <div class="flex items-center justify-center min-h-screen pt-4 px-4 pb-20 text-center sm:block sm:p-0">
        <div class="fixed inset-0 transition-opacity" aria-hidden="true">
            <div class="absolute inset-0 bg-gray-500 opacity-75"></div>
        </div>
        <span class="hidden sm:inline-block sm:align-middle sm:h-screen" aria-hidden="true">&#8203;</span>
        <div class="inline-block align-bottom bg-white dark:bg-gray-800 rounded-lg text-left overflow-hidden shadow-xl transform transition-all sm:my-8 sm:align-middle sm:max-w-lg sm:w-full">
            <div class="bg-white dark:bg-gray-800 px-6 py-5">
                <div class="flex items-start justify-between">
                    <h3 class="text-lg leading-6 font-medium text-gray-900 dark:text-white">Ön Provizyon İşlemi</h3>
                    <button type="button" id="cancel-auth" class="text-gray-400 hover:text-gray-500 focus:outline-none">
                        <svg class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12" />
                        </svg>
                    </button>
                </div>
                <div class="mt-4">
                    <!-- Step 1: Kart Bilgilerini Topla -->
                    <div id="auth-pay-step1">
                        <p class="text-sm text-gray-500 dark:text-gray-300 mb-6">
                            Kart bilgilerinizle ön provizyon işlemi yapılacaktır. Tutar belirtmeden sadece kart bilgileriniz kullanılacaktır.
                        </p>

                        <!-- Tutar -->
                        <div class="mb-6">
                            <label for="auth-amount" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">Tutar (₺)</label>
                            <div class="relative">
                                <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                    <span class="text-gray-500 dark:text-gray-400">₺</span>
                                </div>
                                <input type="number" id="auth-amount" name="auth-amount" step="0.01" class="block w-full pl-10 pr-4 py-3 border border-gray-300 dark:border-gray-600 rounded-lg shadow-sm focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500 dark:bg-gray-700 dark:text-white" placeholder="0,00" required>
                            </div>
                        </div>

                        <!-- Kart Bilgileri -->
                        <div class="mb-6">
                            <label for="auth-card-number" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">Kart Numarası</label>
                            <input type="text" id="auth-card-number" class="block w-full px-4 py-3 border border-gray-300 dark:border-gray-600 rounded-lg shadow-sm focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500 dark:bg-gray-700 dark:text-white" placeholder="1234 5678 9012 3456" required>
                        </div>

                        <div class="grid grid-cols-2 gap-4 mb-6">
                            <div>
                                <label for="auth-expiration-month" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">Son Kullanma Tarihi</label>
                                <div class="grid grid-cols-2 gap-2">
                                    <div class="relative">
                                        <select id="auth-expiration-month" class="appearance-none block w-full px-4 py-3 border border-gray-300 dark:border-gray-600 rounded-lg shadow-sm focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500 dark:bg-gray-700 dark:text-white" required>
                                            <option value="" disabled selected>Ay</option>
                                            <?php for ($i = 1; $i <= 12; $i++): ?>
                                                <option value="<?= str_pad($i, 2, '0', STR_PAD_LEFT) ?>"><?= str_pad($i, 2, '0', STR_PAD_LEFT) ?></option>
                                            <?php endfor; ?>
                                        </select>
                                    </div>
                                    <div class="relative">
                                        <select id="auth-expiration-year" class="appearance-none block w-full px-4 py-3 border border-gray-300 dark:border-gray-600 rounded-lg shadow-sm focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500 dark:bg-gray-700 dark:text-white" required>
                                            <option value="" disabled selected>Yıl</option>
                                            <?php for ($i = date('Y'); $i <= date('Y') + 10; $i++): ?>
                                                <option value="<?= substr($i, -2) ?>"><?= $i ?></option>
                                            <?php endfor; ?>
                                        </select>
                                    </div>
                                </div>
                            </div>
                            <div>
                                <label for="auth-cvv" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">CVV</label>
                                <div class="relative">
                                    <input type="text" id="auth-cvv" maxlength="3" class="block w-full px-4 py-3 border border-gray-300 dark:border-gray-600 rounded-lg shadow-sm focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500 dark:bg-gray-700 dark:text-white" placeholder="•••" required>
                                    <div class="absolute inset-y-0 right-0 flex items-center pr-3">
                                        <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 text-gray-400" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 15v2m-6 4h12a2 2 0 002-2v-6a2 2 0 00-2-2H6a2 2 0 00-2 2v6a2 2 0 002 2zm10-10V7a4 4 0 00-8 0v4h8z" />
                                        </svg>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Kart Sahibi -->
                        <div class="mb-6">
                            <label for="auth-card-holder" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">Kart Sahibi</label>
                            <input type="text" id="auth-card-holder" class="block w-full px-4 py-3 border border-gray-300 dark:border-gray-600 rounded-lg shadow-sm focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500 dark:bg-gray-700 dark:text-white" placeholder="Ad Soyad" required>
                        </div>
                    </div>

                    <!-- Step 2: 3D Secure Iframe -->
                    <div id="auth-pay-step2" class="hidden">
                        <div class="text-center mb-6">
                            <h2 class="text-xl font-bold text-gray-900 dark:text-white mb-2">3D Secure Doğrulama</h2>
                            <p class="text-gray-600 dark:text-gray-300">Lütfen bankanızın doğrulama sayfasına yönlendiriliyorsunuz...</p>
                        </div>
                        <div id="auth-iframe-container" class="w-full h-96 border border-gray-200 dark:border-gray-700 rounded-lg overflow-hidden">
                            <!-- Iframe buraya eklenecek -->
                        </div>
                        <div class="mt-4 text-center text-sm text-gray-500 dark:text-gray-400">
                            <p>Bu işlem birkaç saniye sürebilir. Lütfen sayfayı kapatmayın.</p>
                        </div>
                    </div>

                    <!-- Step 3: Ödeme Sonucu -->
                    <div id="auth-pay-step3" class="hidden">
                        <div class="text-center">
                            <div class="mx-auto flex items-center justify-center h-12 w-12 rounded-full bg-green-100 dark:bg-green-900 mb-4">
                                <svg class="h-6 w-6 text-green-600 dark:text-green-400" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7" />
                                </svg>
                            </div>
                            <h2 class="text-xl font-bold text-gray-900 dark:text-white mb-2">Ön Provizyon Başarılı!</h2>
                            <div id="auth-payment-result" class="text-gray-600 dark:text-gray-300 mb-6">
                                <!-- Sonuç mesajı buraya eklenecek -->
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="bg-gray-50 dark:bg-gray-700 px-6 py-4 sm:flex sm:flex-row-reverse">
                <button type="button" id="submit-auth" class="w-full inline-flex justify-center rounded-lg border border-transparent shadow-sm px-4 py-3 bg-blue-600 text-base font-medium text-white hover:bg-blue-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500 sm:ml-3 sm:w-auto sm:text-sm">
                    <span class="spinner-status opacity-0 mr-2">
                        <svg aria-hidden="true" class="w-5 h-5 text-gray-200 animate-spin dark:text-gray-600 fill-blue-600" viewBox="0 0 100 101" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path d="M100 50.5908C100 78.2051 77.6142 100.591 50 100.591C22.3858 100.591 0 78.2051 0 50.5908C0 22.9766 22.3858 0.59082 50 0.59082C77.6142 0.59082 100 22.9766 100 50.5908ZM9.08144 50.5908C9.08144 73.1895 27.4013 91.5094 50 91.5094C72.5987 91.5094 90.9186 73.1895 90.9186 50.5908C90.9186 27.9921 72.5987 9.67226 50 9.67226C27.4013 9.67226 9.08144 27.9921 9.08144 50.5908Z" fill="currentColor"/>
                            <path d="M93.9676 39.0409C96.393 38.4038 97.8624 35.9116 97.0079 33.5539C95.2932 28.8227 92.871 24.3692 89.8167 20.348C85.8452 15.1192 80.8826 10.7238 75.2124 7.41289C69.5422 4.10194 63.2754 1.94025 56.7698 1.05124C51.7666 0.367541 46.6976 0.446843 41.7345 1.27873C39.2613 1.69328 37.813 4.19778 38.4501 6.62326C39.0873 9.04874 41.5694 10.4717 44.0505 10.1071C47.8511 9.54855 51.7191 9.52689 55.5402 10.0491C60.8642 10.7766 65.9928 12.5457 70.6331 15.2552C75.2735 17.9648 79.3347 21.5619 82.5849 25.841C84.9175 28.9121 86.7997 32.2913 88.1811 35.8758C89.083 38.2158 91.5421 39.6781 93.9676 39.0409Z" fill="currentFill"/>
                        </svg>
                    </span>
                    <span>Ön Provizyon Yap</span>
                </button>
                <button type="button" id="cancel-auth" class="mt-3 w-full inline-flex justify-center rounded-lg border border-gray-300 dark:border-gray-600 shadow-sm px-4 py-3 bg-white dark:bg-gray-600 text-base font-medium text-gray-700 dark:text-gray-300 hover:bg-gray-50 dark:hover:bg-gray-500 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500 sm:mt-0 sm:ml-3 sm:w-auto sm:text-sm">
                    İptal
                </button>
            </div>
        </div>
    </div>
</div>

<?php
include_once includes('layouts/footer.php');
?>

<script>
    // Detect if user is on mobile and prompt to "Add to Home Screen"
    if (window.matchMedia('(display-mode: standalone)').matches || window.navigator.standalone === true) {
        console.log("Running in standalone PWA mode");
    } else if (/Android|iPhone|iPad|iPod/i.test(navigator.userAgent)) {
        window.addEventListener('beforeinstallprompt', (e) => {
            e.preventDefault();
            const installPrompt = confirm("Bu sayfayı ana ekranınıza ekleyerek daha hızlı erişebilirsiniz. Ekleme yapılsın mı?");
            if (installPrompt) {
                e.prompt();
            }
        });
    }

    // Prevent pinch-zoom on mobile
    document.addEventListener('gesturestart', (e) => {
        e.preventDefault();
    });

    $(document).ready(function () {
        // Kart tipi tespiti
        function detectCardType(number) {
            const cardTypes = {
                'visa': /^4/,
                'mastercard': /^5[1-5]/,
                'amex': /^3[47]/,
                'discover': /^6(?:011|5)/,
                'jcb': /^(?:2131|1800|35)/,
                'diners': /^3(?:0[0-5]|[68])/,
                'troy': /^9792/
            };

            for (const [type, pattern] of Object.entries(cardTypes)) {
                if (pattern.test(number)) {
                    return type;
                }
            }
            return 'unknown';
        }

        // Kart numarası formatlama
        $('#card-number, #auth-card-number').on('input', function() {
            let value = $(this).val().replace(/\s+/g, '');
            if (value.length > 0) {
                value = value.match(new RegExp('.{1,4}', 'g')).join(' ');
            }
            $(this).val(value);

            // Kart tipini göster
            const cardType = detectCardType(value.replace(/\s+/g, ''));
            const cardTypeDisplay = $('#card-type');

            if (cardType !== 'unknown') {
                cardTypeDisplay.html(`<img src="<?= asset('images/content/logos/${cardType}.png') ?>" alt="${cardType}" class="w-full h-full object-contain">`);
            } else {
                cardTypeDisplay.html('');
            }
        });
// Function to update step indicators
        function updateStepIndicator(currentStep) {
            // Reset all steps to inactive
            document.querySelectorAll('[id^="step-"]').forEach(step => {
                step.classList.remove('bg-dark-600', 'text-white');
                step.classList.add('bg-gray-200', 'dark:bg-gray-600', 'text-gray-600', 'dark:text-gray-300');
            });

            document.querySelectorAll('[id^="line-"]').forEach(line => {
                line.classList.remove('bg-dark-600');
                line.classList.add('bg-gray-200');
            });

            // Activate current step and previous ones
            for (let i = 1; i <= currentStep; i++) {
                const stepEl = document.getElementById(`step-${i}`);
                if (stepEl) {
                    stepEl.classList.remove('bg-gray-200', 'dark:bg-gray-600', 'text-gray-600', 'dark:text-gray-300');
                    stepEl.classList.add('bg-dark-600', 'text-white');
                }

                // Also activate connecting lines between steps
                if (i > 1) {
                    const lineEl = document.getElementById(`line-${i-1}-${i}`);
                    if (lineEl) {
                        lineEl.classList.remove('bg-gray-200');
                        lineEl.classList.add('bg-dark-600');
                    }
                }
            }
        }
        updateStepIndicator(1);

        // Handle payment type change
        $("#payment-type").on("change", function() {
            const type = $(this).val();
            const authInfo = $("#auth-installment-info");
            const installmentContainer = $("#installment-container");

            if (type === "SaleTaksit") {
                authInfo.hide();
                installmentContainer.show();
                $("#installment-count").attr("required", true);
                $("#payment-button-text").text("Ödemeyi Tamamla");
            } else if (type === "Auth") {
                authInfo.show();
                installmentContainer.hide();
                $("#installment-count").removeAttr("required");
                $("#payment-button-text").text("Ön Provizyon Al");
            } else {
                authInfo.hide();
                installmentContainer.hide();
                $("#installment-count").removeAttr("required");
                $("#payment-button-text").text("Ödemeyi Tamamla");
            }
        });

        // Process payment or auth
        $("#process-payment").on("click", function() {
            const $button = $(this);
            $button.prop('disabled', true);
            const $spinner = $button.find('.spinner-status');
            $spinner.removeClass('opacity-0');

            const formData = {
                transactionType: $('#payment-type').val(),
                amount: $('#amount').val(),
                cardNumber: $('#card-number').val().replace(/\s+/g, ''),
                expirationMonth: $('#expiration-month').val(),
                expirationYear: $('#expiration-year').val(),
                cvv: $('#cvv').val(),
                cardHolder: $('#card-holder').val(),
                installmentCount: $('#installment-count').val()
            };

            if (formData.transactionType === "Auth") {
                processAuthRequest(formData, $button, $spinner);
            } else {
                processPaymentRequest(formData, $button, $spinner);
            }
        });

        function processAuthRequest(formData, $button, $spinner) {
            $.ajax({
                type: 'POST',
                url: '/linkpay_auth',
                data: formData,
                success: function(response) {
                    $spinner.addClass('opacity-0');
                    $button.prop('disabled', false);

                    try {
                        const result = JSON.parse(response);
                        if (result.success) {
                            // Show installment options
                            showInstallmentOptions(result.installments);
                            $("#payment-button-text").text("Taksit Seçerek Öde");
                            $("#payment-type").val("SaleTaksit"); // Change to installment
                        } else {
                            $(".showError").removeClass("hidden");
                            $(".showError .error-message").text("Ön provizyon hatası: " + result.message);
                        }
                    } catch (e) {
                        console.error("Error parsing response:", e);
                        $(".showError").removeClass("hidden");
                        $(".showError .error-message").text("Bir hata oluştu. Lütfen tekrar deneyin.");
                    }
                },
                error: function(xhr, status, error) {
                    $spinner.addClass('opacity-0');
                    $button.prop('disabled', false);
                    $(".showError").removeClass("hidden");
                    $(".showError .error-message").text("İstek sırasında bir hata oluştu: " + error);
                }
            });
        }

        function showInstallmentOptions(installments) {
            const container = $("#installment-options");
            container.empty();

            installments.forEach(installment => {
                container.append(`
                <div class="installment-option border rounded-lg p-2 text-center cursor-pointer transition-colors duration-200
                     hover:bg-blue-100 dark:hover:bg-blue-800 border-gray-200 dark:border-gray-600"
                     data-months="${installment.installmentNumber}"
                     data-rate="${installment.interestRate}">
                    <div class="font-bold text-gray-800 dark:text-gray-200">${installment.installmentNumber} Taksit</div>
                    <div class="text-sm text-gray-600 dark:text-gray-400">${installment.monthlyAmount} ₺</div>
                    <div class="text-xs ${installment.interestRate === '0' ? 'text-green-600 dark:text-green-400' : 'text-gray-500 dark:text-gray-400'}">
                        ${installment.interestRate === '0' ? 'Peşin fiyatına' : installment.interestRate + '%'}
                    </div>
                </div>
            `);
            });

            // Handle installment selection
            $(".installment-option").on("click", function() {
                $(".installment-option").removeClass("border-blue-500 bg-blue-50 dark:bg-blue-900/30");
                $(this).addClass("border-blue-500 bg-blue-50 dark:bg-blue-900/30");
                $("#installment-count").val($(this).data("months"));
            });
        }

        // Open Auth Modal
        $("#open-auth-modal").on("click", function() {
            // Copy values from main form to modal
            $("#auth-card-number").val($("#card-number").val());
            $("#auth-expiration-month").val($("#expiration-month").val());
            $("#auth-expiration-year").val($("#expiration-year").val());
            $("#auth-cvv").val($("#cvv").val());
            $("#auth-card-holder").val($("#card-holder").val());
            $("#auth-amount").val($("#amount").val());

            $("#auth-modal").removeClass("hidden");
        });

        // Close Auth Modal
        $("#cancel-auth").on("click", function() {
            $("#auth-modal").addClass("hidden");
        });

        // Submit Auth Request
        $("#submit-auth").on("click", function() {
            var $button = $(this);
            $button.prop('disabled', true);
            var $spinner = $button.find('.spinner-status');
            $spinner.removeClass('opacity-0');

            // Collect auth data
            var authData = {
                transactionType: "Auth",
                amount: $('#auth-amount').val()+'.00',
                cardNumber: $("#auth-card-number").val().replace(/\s+/g, ''),
                expirationMonth: $("#auth-expiration-month").val(),
                expirationYear: $("#auth-expiration-year").val(),
                cvv: $("#auth-cvv").val(),
                cardHolder: $("#auth-card-holder").val(),
            };

            $.ajax({
                type: 'POST',
                url: '/linkpay_process',
                data: authData,
                success: function (response) {
                    $spinner.addClass('opacity-0');
                    $button.prop('disabled', false);

                    try {
                        var result = JSON.parse(response);

                        if (result.success) {
                            // Show success message
                            $("#auth-pay-step1").addClass("hidden");
                            $("#auth-pay-step2").removeClass("hidden");
                            updateStepIndicator(2); // <-- Add this
                            $('#auth-pay-step2 #auth-iframe-container').html(result.iframe);
                        } else {
                            // Show error message
                            $(".showError").removeClass("hidden");
                            $(".showError .error-message").text("Ön provizyon hatası: " + result.message);
                        }
                    } catch (e) {
                        console.error("Error parsing response:", e);
                        $(".showError").removeClass("hidden");
                        $(".showError .error-message").text("Bir hata oluştu. Lütfen tekrar deneyin.");
                    }
                },
                error: function (xhr, status, error) {
                    $spinner.addClass('opacity-0');
                    $button.prop('disabled', false);
                    $(".showError").removeClass("hidden");
                    $(".showError .error-message").text("İstek sırasında bir hata oluştu: " + error);
                }
            });
        });

        // Handle Step 1 form submission
        function processPaymentRequest() {
            var $button = $(this);
            $button.prop('disabled', true);
            var $spinner = $button.find('.spinner-status');
            $spinner.removeClass('opacity-0');

            // Check if this is an Auth transaction
            if ($("#payment-type").val() === "Auth") {
                // For Auth, we'll use the modal instead
                $spinner.addClass('opacity-0');
                $button.prop('disabled', false);
                $("#open-auth-modal").click();
                return;
            }

            // Collect form data for regular payments
            var formData = {
                transactionType: $('#payment-type').val(),
                amount: $('#amount').val()+'.00',
                cardNumber: $('#card-number').val().replace(/\s+/g, ''),
                expirationMonth: $('#expiration-month').val(),
                expirationYear: $('#expiration-year').val(),
                cvv: $('#cvv').val(),
                cardHolder: $('#card-holder').val(),
                installmentCount: $('#installment-count').val(),
            };

            $.ajax({
                type: 'POST',
                url: '/linkpay_process',
                data: formData,
                success: function (response) {
                    $spinner.addClass('opacity-0');
                    $button.prop('disabled', false);

                    try {
                        var result = JSON.parse(response);

                        if (result.icon === 'error') {
                            $(".showError").removeClass("hidden");
                            $(".showError .error-message").text(result.message);
                        } else {
                            $("#pay-step1").addClass("hidden");
                            $("#pay-step2").removeClass("hidden");
                            updateStepIndicator(2); // <-- Add this
                            $('#pay-step2 #iframe-container').html(result.iframe);
                        }
                    } catch (e) {
                        console.error("Error parsing response:", e);
                        $(".showError").removeClass("hidden");
                        $(".showError .error-message").text("Bir hata oluştu. Lütfen tekrar deneyin.");
                    }
                },
                error: function (xhr, status, error) {
                    $spinner.addClass('opacity-0');
                    $button.prop('disabled', false);
                    $(".showError").removeClass("hidden");
                    $(".showError .error-message").text("İstek sırasında bir hata oluştu: " + error);
                }
            });
        };

        // Handle Try Again button
        $('#try-again').on('click', function () {
            $('#pay-step3').addClass('hidden');
            $('#pay-step1').removeClass('hidden');
        });
    });
</script>