<?php
// Your $meta array
$meta = array(
    'us' => array(
        'title' => 'Datanito - AI-Powered Web Design, Domain, Hosting, SEO',
        'description' => 'Experience AI-powered web design, domain, hosting, and SEO services with Datanito, a leading software company.',
        'og:title' => 'Datanito - AI-Powered Web Design, Domain, Hosting, SEO',
        'og:description' => 'Experience AI-powered web design, domain, hosting, and SEO services with Datanito, a leading software company.',
        'og:image' => asset('images/brand/open_graph_logo.png'),
    ),
    'tr' => array(
        'title' => 'Datanito - AI Destekli Web Tasarımı, Web Hosting, SEO',
        'description' => 'Datanito ile yapay zeka destekli web tasarımı, alan adı, hosting ve SEO hizmetlerini deneyimleyin.',
        'og:title' => 'Datanito (Türkiye) - AI Web Tasarımı, Alan Adı, Barındırma, SEO',
        'og:description' => 'Datanito ile AI destekli web tasarımı, alan adı, web hosting ve SEO hizmetlerini deneyimleyin.',
        'og:image' => asset('images/brand/open_graph_logo.png'),
    ),
);


// Call the function to set the country and get $currentMeta
$currentMeta = setCountryAndMeta($meta);
// Set up the schema Organization
$schemaOrg = array(
    "@context" => "http://schema.org",
    "@type" => "Organization",
    "name" => "Datanito",
    "description" => "Datanito provides web hosting, web design, app development, SEO, SMO, domain name, marketing and advertising services.",
    "url" => "https://datanito.com",
    "logo" => "https://datanito.com/logo.png",
    "sameAs" => array(
        "https://www.facebook.com/datanito",
        "https://twitter.com/datanito",
        "https://www.instagram.com/datanito/",
        "https://www.linkedin.com/company/datanito/"
    ),
    "contactPoint" => array(
        array(
            "@type" => "ContactPoint",
            "telephone" => "+90-538-224-4717",
            "contactType" => "customer service"
        )
    ),
    "address" => array(
        "@type" => "PostalAddress",
        "streetAddress" => "Yakuplu, Hürriyet Blv, Skyport Residance",
        "addressLocality" => "Beylikdüzü",
        "addressRegion" => "Istanbul",
        "postalCode" => "34524",
        "addressCountry" => "Türkiye"
    ),
    "founder" => array(
        "@type" => "Person",
        "name" => "Milad Saraf"
    )
);
// Convert the schema Organization to JSON-LD format
$jsonOrgLD = json_encode($schemaOrg, JSON_UNESCAPED_SLASHES);
include_once includes('layouts/header.php');
?>
    <div id="content" class="container mx-auto lg:mt-12 mt-12">
        <section class="relative bg-gray-50 dark:bg-black mt-4 py-6 skeleton overflow-hidden h-[30em] sm:h-[35em]">
            <!-- Subtle Particle Overlay (semi-transparent SVG) -->
            <div class="absolute inset-0 opacity-20">
                <svg width="100%" height="100%" xmlns="http://www.w3.org/2000/svg">
                    <defs>
                        <pattern id="dots" x="0" y="0" width="20" height="20" patternUnits="userSpaceOnUse">
                            <!-- Changed fill from white to a dark gray -->
                            <circle cx="2" cy="2" r="1" fill="rgba(0, 0, 0, 0.6)" />
                        </pattern>
                    </defs>
                    <rect width="100%" height="100%" fill="url(#dots)" />
                </svg>
            </div>

            <div aria-hidden="true" class="absolute sm:inset-0 h-max w-full mx-auto grid grid-cols-2 -space-x-52 opacity-20">
                <div class="blur-[50px] sm:blur-[106px] h-56 bg-gradient-to-br to-purple-400 from-blue-700"></div>
                <div class="blur-[50px] sm:blur-[106px] h-32 bg-gradient-to-r from-cyan-400  to-indigo-600"></div>
            </div>

            <div class="looping-wrapper h-56"></div>
            <div class="relative p-1 flex justify-center items-center mx-auto text-center mb-16 mt-12 md:mt-20">
                <div>
                    <div class="flex items-center justify-center space-x-1 my-4 md:my-6 z-10">
                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor" class="w-6 h-6 text-purple-300 dark:text-purple-400">
                            <path fill-rule="evenodd"
                                  d="M9 4.5a.75.75 0 01.721.544l.813 2.846a3.75 3.75 0 002.576 2.576l2.846.813a.75.75 0 010 1.442l-2.846.813a3.75 3.75 0 00-2.576 2.576l-.813 2.846a.75.75 0 01-1.442 0l-.813-2.846a3.75 3.75 0 00-2.576-2.576l-2.846-.813a.75.75 0 010-1.442l2.846-.813A3.75 3.75 0 007.466 7.89l.813-2.846A.75.75 0 019 4.5zM18 1.5a.75.75 0 01.728.568l.258 1.036c.236.94.97 1.674 1.91 1.91l1.036.258a.75.75 0 010 1.456l-1.036.258c-.94.236-1.674.97-1.91 1.91l-.258 1.036a.75.75 0 01-1.456 0l-.258-1.036a2.625 2.625 0 00-1.91-1.91l-1.036-.258a.75.75 0 010-1.456l1.036-.258a2.625 2.625 0 001.91-1.91l.258-1.036A.75.75 0 0118 1.5zM16.5 15a.75.75 0 01.712.513l.394 1.183c.15.447.5.799.948.948l1.183.395a.75.75 0 010 1.422l-1.183.395c-.447.15-.799.5-.948.948l-.395 1.183a.75.75 0 01-1.422 0l-.395-1.183a1.5 1.5 0 00-.948-.948l-1.183-.395a.75.75 0 010-1.422l1.183-.395c.447-.15.799-.5.948-.948l.395-1.183A.75.75 0 0116.5 15z"
                                  clip-rule="evenodd"></path>
                        </svg>
                        <h2 class="text-md md:text-2xl text-transparent bg-clip-text bg-gradient-to-r to-cyan-600 from-purple-400"><?php echo $lang['home-hero-headline'] ?></h2>
                    </div>
                    <h1 class="flex z-10 font-semibold text-dark-900 dark:text-gray-100 text-4xl md:text-6xl max-w-screen-md mx-auto z-10 leading-tight"><?php echo $lang['home-hero-superior'] ?></h1>

                    <div class="inline-flex w-full md:w-auto items-center justify-center space-x-3 mt-8 md:mt-12" role="group">
                        <!-- First Button -->
                        <a href="<?php echo url('/cloud/web-hosting'); ?>"
                           class="flex items-center justify-center text-sm font-medium bg-dark-800 dark:bg-neutral-600 hover:bg-dark-700 dark:hover:bg-neutral-700 hover:shadow-lg transform transition-all duration-300 hover:scale-105 text-white py-3 px-5 md:py-2.5 md:px-6 rounded-full">
                            <svg xmlns="http://www.w3.org/2000/svg" class="w-5 h-5 text-primary-400 mr-2" viewBox="0 0 24 24" fill="currentColor">
                                <path fill-rule="evenodd" d="M9 4.5a.75.75 0 01.721.544l.813 2.846a3.75 3.75 0 002.576 2.576l2.846.813a.75.75 0 010 1.442l-2.846.813a3.75 3.75 0 00-2.576 2.576l-.813 2.846a.75.75 0 01-1.442 0l-.813-2.846a3.75 3.75 0 00-2.576-2.576l-2.846-.813a.75.75 0 010-1.442l2.846-.813A3.75 3.75 0 007.466 7.89l.813-2.846A.75.75 0 019 4.5zM18 1.5a.75.75 0 01.728.568l.258 1.036c.236.94.97 1.674 1.91 1.91l1.036.258a.75.75 0 010 1.456l-1.036.258c-.94.236-1.674.97-1.91 1.91l-.258 1.036a.75.75 0 01-1.456 0l-.258-1.036a2.625 2.625 0 00-1.91-1.91l-1.036-.258a.75.75 0 010-1.456l1.036-.258a2.625 2.625 0 001.91-1.91l.258-1.036A.75.75 0 0118 1.5z"></path>
                            </svg>
                            <?php echo $lang['home-hero-web-hosting-cta']; ?>
                        </a>

                        <!-- Second Button -->
                        <a href="<?php echo url('/solutions/web-design'); ?>"
                           class="flex items-center justify-center text-sm font-medium bg-primary-500 hover:bg-primary-400 dark:bg-primary-500 dark:hover:bg-primary-400 text-neutral-800 hover:shadow-lg transform transition-all duration-300 hover:scale-105 py-3 px-5 md:py-2.5 md:px-6 rounded-full">
                            <?php echo $lang['home-hero-web-design-cta']; ?>
                        </a>
                    </div>
<!--                    <div class="mt-12 flex items-center justify-center mx-auto space-x-6">-->
<!--                        <div class="flex items-center">-->
<!--                            <svg class="w-5 h-5 text-yellow-400 mr-2" fill="currentColor" viewBox="0 0 20 20">-->
<!--                                <path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"></path>-->
<!--                            </svg>-->
<!--                            <span class="text-gray-800 dark:text-gray-100">4.9/5 (120+ reviews)</span>-->
<!--                        </div>-->
<!--                        <div class="flex items-center">-->
<!--                            <svg class="w-5 h-5 text-green-400 mr-2" fill="currentColor" viewBox="0 0 20 20">-->
<!--                                <path fill-rule="evenodd" d="M6.267 3.455a3.066 3.066 0 001.745-.723 3.066 3.066 0 013.976 0 3.066 3.066 0 001.745.723 3.066 3.066 0 012.812 2.812c.051.643.304 1.254.723 1.745a3.066 3.066 0 010 3.976 3.066 3.066 0 00-.723 1.745 3.066 3.066 0 01-2.812 2.812 3.066 3.066 0 00-1.745.723 3.066 3.066 0 01-3.976 0 3.066 3.066 0 00-1.745-.723 3.066 3.066 0 01-2.812-2.812 3.066 3.066 0 00-.723-1.745 3.066 3.066 0 010-3.976 3.066 3.066 0 00.723-1.745 3.066 3.066 0 012.812-2.812zm7.44 5.252a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"></path>-->
<!--                            </svg>-->
<!--                            <span class="text-gray-800 dark:text-gray-100">150+ Enterprise Clients</span>-->
<!--                        </div>-->
<!--                    </div>-->
                </div>
            </div>

            <div class="block md:flex items-center justify-center w-full z-10 mx-auto space-y-4 md:space-y-0 md:space-x-3 p-1 md:p-4 !pb-8 mb-10 relative z-10">


            </div>
            <div id="plansPopup" class="z-10 hidden bg-dark-600 dark:bg-dark-600 backdrop-blur bg-opacity-75 dark:bg-opacity-75 shadow-sm dark:shadow-sm-light divide-y divide-gray-100 rounded-3xl shadow max-w-xs min-w-xs">
                <ul class="navigateBarPlans py-2 text-sm text-gray-200 dark:text-gray-200 w-full p-2 space-y-1" aria-labelledby="plansPopupButton">
                </ul>
            </div>
        </section>
        <style>
            .looping-wrapper .el,
            .looping-wrapper-gray .el {
                opacity: 1;
                margin-top: -18vh;
                transform-origin: 50% 100%;
                position: absolute
            }

            .looping-wrapper {
                position: absolute;
                display: flex;
                align-items: center;
                flex-wrap: wrap;
                width: 1px;
                height: 100%;
                left: 50%;
                top: 20%
            }
            .looping-wrapper .el {
                width: 2px;
                height: 8vh;
                background: #beff01
            }
            @media (max-width: 420px){
                .looping-wrapper .el {
                    width: 1.5px;
                    height: 5vh;
                    background: #beff01
                }
            }


            .looping-wrapper-gray {
                position: absolute;
                display: flex;
                align-items: center;
                flex-wrap: wrap;
                width: 1px;
                height: 100%;
                left: 50%;
                top: 0
            }

            .looping-wrapper-gray .el {
                width: 2px;
                height: 14vh;
                background: #292929
            }

        </style>
        <section class="bg-gray-50 dark:bg-black mt-4 skeleton">
            <div class="py-6 px-4 mx-auto max-w-screen-xl text-center pb-0 lg:pt-12 lg:px-4 h-[32em] sm:h-[35em] overflow-hidden">
                <div class="mb-1 md:mb-2">
                    <span class="inline-flex items-center py-1.5 px-3 md:px-4 md:py-2 rounded-full text-[12px] md:text-sm font-semibold bg-purple-200 text-purple-900 dark:bg-purple-800 dark:text-white animate-pulse">
                        <?php echo $lang['badge-quanta-ai'] ?>
                    </span>
                </div>
                <div class="mb-6 ml-2 flex items-center justify-center space-x-2">
                    <h2 class="mb-3 mt-4 text-5xl tracking-tight font-bold text-gray-900 dark:text-white magic-container">
                            <span class="magic"> <span class="magic-star">
                                    <svg viewBox="0 0 512 512"> <path
                                                d="M512 255.1c0 11.34-7.406 20.86-18.44 23.64l-171.3 42.78l-42.78 171.1C276.7 504.6 267.2 512 255.9 512s-20.84-7.406-23.62-18.44l-42.66-171.2L18.47 279.6C7.406 276.8 0 267.3 0 255.1c0-11.34 7.406-20.83 18.44-23.61l171.2-42.78l42.78-171.1C235.2 7.406 244.7 0 256 0s20.84 7.406 23.62 18.44l42.78 171.2l171.2 42.78C504.6 235.2 512 244.6 512 255.1z"/> </svg> </span> <span
                                        class="magic-star"> <svg viewBox="0 0 512 512"> <path
                                                d="M512 255.1c0 11.34-7.406 20.86-18.44 23.64l-171.3 42.78l-42.78 171.1C276.7 504.6 267.2 512 255.9 512s-20.84-7.406-23.62-18.44l-42.66-171.2L18.47 279.6C7.406 276.8 0 267.3 0 255.1c0-11.34 7.406-20.83 18.44-23.61l171.2-42.78l42.78-171.1C235.2 7.406 244.7 0 256 0s20.84 7.406 23.62 18.44l42.78 171.2l171.2 42.78C504.6 235.2 512 244.6 512 255.1z"/> </svg> </span> <span
                                        class="magic-star"> <svg viewBox="0 0 512 512"> <path
                                                d="M512 255.1c0 11.34-7.406 20.86-18.44 23.64l-171.3 42.78l-42.78 171.1C276.7 504.6 267.2 512 255.9 512s-20.84-7.406-23.62-18.44l-42.66-171.2L18.47 279.6C7.406 276.8 0 267.3 0 255.1c0-11.34 7.406-20.83 18.44-23.61l171.2-42.78l42.78-171.1C235.2 7.406 244.7 0 256 0s20.84 7.406 23.62 18.44l42.78 171.2l171.2 42.78C504.6 235.2 512 244.6 512 255.1z"/> </svg> </span>
                                <span class="magic-text"><?php echo $lang['home-dino-heading']; ?></span>
                            </span>
                    </h2>
                    <span class="inline-flex justify-center items-center w-6 h-6 text-xs font-semibold rounded-lg p-2 bg-dark-800 dark:bg-dark-400 mt-2.5">
                            <span class="text-sm tracking-tight font-extrabold text-white"><?php echo $lang['ai']; ?></span>
                        </span>
                </div>
                <p class="mb-4 text-2xl tracking-tight font-normal text-gray-700 dark:text-gray-200"><?php echo $lang['home-dino-subheading']; ?></p>
                <a href="<?php echo url('/dino'); ?>" class="mb-2 inline-flex text-xl tracking-tight font-normal items-center text-blue-500 dark:text-blue-400 items-center">
                    <span class="hover:underline"><?php echo $lang['home-dino-cta']; ?></span>
                    <span class="material-symbols-outlined text-2xl mt-0.5 ml-0.5">chevron_right</span>
                </a>
                <div class="flex justify-center space-x-8 mt-24">
                    <div>
                        <h3 class="dino-type-effect font-bold text-5xl md:text-6xl text-gray-500 dark:text-gray-300"><?php echo $lang['home-dino-typing']; ?></h3>
                    </div>
                </div>
            </div>
        </section>
            <section class="bg-gray-50 dark:bg-black mt-4 h-[32em] sm:h-[35em] overflow-hidden skeleton">
                <div class="py-6 px-4 mx-auto max-w-screen-xl text-center pb-0 lg:pt-12 lg:px-4">
                    <div class="mb-1 md:mb-2">
    <span class="inline-flex items-center py-1.5 px-3 md:px-4 md:py-2 rounded-full text-[12px] md:text-sm font-semibold bg-green-200 text-green-900 dark:bg-green-800 dark:text-white">
        <?php echo $lang['badge-web-design'] ?>
    </span>
                    </div>
                    <h2 class="mb-3 mt-4 text-5xl tracking-tight font-bold text-gray-900 dark:text-white"><?php echo $lang['home-web-design-heading']; ?></h2>
                    <p class="mb-4 text-2xl tracking-tight font-normal text-gray-700 dark:text-gray-200"><?php echo $lang['home-web-design-subheading']; ?></p>
                    <a href="<?php echo url('/solutions/web-design'); ?>" class="mb-2 inline-flex text-xl tracking-tight font-normal items-center text-blue-500 dark:text-blue-400 items-center">
                        <span class="hover:underline"><?php echo $lang['home-cta']; ?></span>
                        <span class="material-symbols-outlined text-2xl mt-0.5 ml-0.5">chevron_right</span>
                    </a>
                    <div class="flex justify-center relative mt-40 mr-[4em]">
                        <div class="Dbook">
                            <div class="inner">
                                <div class="screen">
                                    <div class="face-one">
                                        <div class="camera"></div>
                                        <div class="display">
                                            <div class="shade"></div>
                                        </div>
                                        <span>Datanito Air</span>
                                    </div>
                                    <svg class="logo" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="151px" height="150px" viewBox="0 0 639 636" version="1.1">
                                        <g id="surface1">
                                            <path style=" stroke:none;fill-rule:nonzero;fill-opacity:1;" class="fill-white dark:fill-white" d="M 543.414062 80.550781 C 563.308594 100.46875 563.308594 132.765625 543.414062 152.683594 L 155.367188 541.199219 C 135.472656 561.121094 103.214844 561.121094 83.316406 541.199219 C 63.421875 521.28125 63.421875 488.984375 83.316406 469.066406 L 471.371094 80.558594 C 491.257812 60.628906 523.515625 60.628906 543.414062 80.550781 Z M 543.414062 80.550781 "/>
                                            <path style=" stroke:none;fill-rule:nonzero;fill-opacity:1;" class="fill-white dark:fill-white" d="M 350.257812 83.671875 C 370.15625 103.589844 370.15625 135.886719 350.257812 155.804688 L 158.246094 348.046875 C 138.347656 367.964844 106.089844 367.964844 86.195312 348.046875 C 66.296875 328.125 66.296875 295.828125 86.195312 275.910156 L 278.207031 83.671875 C 298.097656 63.75 330.363281 63.75 350.257812 83.671875 Z M 350.257812 83.671875 "/>
                                            <path style=" stroke:none;fill-rule:nonzero;fill-opacity:1;" class="fill-white dark:fill-white" d="M 198.839844 42.324219 C 218.734375 62.242188 218.734375 94.539062 198.839844 114.457031 L 116.90625 196.484375 C 97.011719 216.40625 64.753906 216.40625 44.855469 196.484375 C 24.960938 176.566406 24.960938 144.269531 44.855469 124.351562 L 126.78125 42.324219 C 146.679688 22.402344 178.941406 22.402344 198.839844 42.324219 Z M 198.839844 42.324219 "/>
                                            <path style=" stroke:none;fill-rule:nonzero;fill-opacity:1;" class="fill-white dark:fill-white" d="M 549.855469 263.0625 C 569.75 282.984375 569.75 315.277344 549.855469 335.199219 L 337.238281 548.0625 C 317.34375 567.984375 285.085938 567.984375 265.1875 548.0625 C 245.292969 528.140625 245.292969 495.847656 265.1875 475.925781 L 477.804688 263.0625 C 497.699219 243.140625 529.957031 243.140625 549.855469 263.0625 Z M 549.855469 263.0625 "/>
                                            <path style=" stroke:none;fill-rule:nonzero;fill-opacity:1;" class="fill-white dark:fill-white" d="M 578.785156 423.015625 C 598.683594 442.933594 598.683594 475.230469 578.785156 495.148438 L 496.855469 577.171875 C 476.957031 597.089844 444.699219 597.089844 424.804688 577.171875 C 404.90625 557.25 404.90625 524.953125 424.804688 505.035156 L 506.726562 423.015625 C 526.625 403.085938 558.890625 403.085938 578.785156 423.015625 Z M 578.785156 423.015625 "/>
                                        </g>
                                    </svg>
                                </div>
                                <div class="body">
                                    <div class="face-one">
                                        <div class="touchpad">
                                        </div>
                                        <div class="keyboard">
                                            <div class="key"></div>
                                            <div class="key"></div>
                                            <div class="key"></div>
                                            <div class="key"></div>
                                            <div class="key"></div>
                                            <div class="key space"></div>
                                            <div class="key"></div>
                                            <div class="key"></div>
                                            <div class="key"></div>
                                            <div class="key"></div>
                                            <div class="key"></div>
                                            <div class="key"></div>
                                            <div class="key"></div>
                                            <div class="key"></div>
                                            <div class="key"></div>
                                            <div class="key"></div>
                                            <div class="key"></div>
                                            <div class="key"></div>
                                            <div class="key"></div>
                                            <div class="key"></div>
                                            <div class="key"></div>
                                            <div class="key"></div>
                                            <div class="key"></div>
                                            <div class="key"></div>
                                            <div class="key"></div>
                                            <div class="key"></div>
                                            <div class="key"></div>
                                            <div class="key"></div>
                                            <div class="key"></div>
                                            <div class="key"></div>
                                            <div class="key"></div>
                                            <div class="key"></div>
                                            <div class="key"></div>
                                            <div class="key"></div>
                                            <div class="key"></div>
                                            <div class="key"></div>
                                            <div class="key"></div>
                                            <div class="key"></div>
                                            <div class="key"></div>
                                            <div class="key"></div>
                                            <div class="key"></div>
                                            <div class="key"></div>
                                            <div class="key"></div>
                                            <div class="key"></div>
                                            <div class="key"></div>
                                            <div class="key"></div>
                                            <div class="key"></div>
                                            <div class="key"></div>
                                            <div class="key"></div>
                                            <div class="key"></div>
                                            <div class="key"></div>
                                            <div class="key"></div>
                                            <div class="key"></div>
                                            <div class="key"></div>
                                            <div class="key"></div>
                                            <div class="key"></div>
                                            <div class="key"></div>
                                            <div class="key"></div>
                                            <div class="key"></div>
                                            <div class="key f"></div>
                                            <div class="key f"></div>
                                            <div class="key f"></div>
                                            <div class="key f"></div>
                                            <div class="key f"></div>
                                            <div class="key f"></div>
                                            <div class="key f"></div>
                                            <div class="key f"></div>
                                            <div class="key f"></div>
                                            <div class="key f"></div>
                                            <div class="key f"></div>
                                            <div class="key f"></div>
                                            <div class="key f"></div>
                                            <div class="key f"></div>
                                            <div class="key f"></div>
                                            <div class="key f"></div>
                                        </div>
                                    </div>
                                    <div class="pad one"></div>
                                    <div class="pad two"></div>
                                    <div class="pad three"></div>
                                    <div class="pad four"></div>
                                </div>
                            </div>
                            <div class="shadow-device"></div>
                        </div>
                    </div>
                </div>
            </section>
            <section class="bg-dark-950 dark:bg-black mt-4 skeleton">
                <div class="py-6 px-4 mx-auto max-w-screen-xl text-center pb-0 lg:pt-12 lg:px-4 h-[30em] sm:h-[35em] overflow-hidden">
                    <div class="mb-1 md:mb-2">
    <span class="inline-flex items-center py-1.5 px-3 md:px-4 md:py-2 rounded-full text-[12px] md:text-sm font-semibold bg-yellow-200 text-yellow-900 dark:bg-yellow-800 dark:text-white">
        <?php echo $lang['badge-datanito-pay'] ?>
    </span>
                    </div>
                    <div class="flex justify-center mb-2 mt-4 items-center mb-4">
                        <svg class="w-9 h-9 mr-0.5" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="151px" height="150px" viewBox="0 0 639 636" version="1.1">
                            <g id="surface1">
                                <path style=" stroke:none;fill-rule:nonzero;fill-opacity:1;" class="fill-white dark:fill-white" d="M 543.414062 80.550781 C 563.308594 100.46875 563.308594 132.765625 543.414062 152.683594 L 155.367188 541.199219 C 135.472656 561.121094 103.214844 561.121094 83.316406 541.199219 C 63.421875 521.28125 63.421875 488.984375 83.316406 469.066406 L 471.371094 80.558594 C 491.257812 60.628906 523.515625 60.628906 543.414062 80.550781 Z M 543.414062 80.550781 "/>
                                <path style=" stroke:none;fill-rule:nonzero;fill-opacity:1;" class="fill-white dark:fill-white" d="M 350.257812 83.671875 C 370.15625 103.589844 370.15625 135.886719 350.257812 155.804688 L 158.246094 348.046875 C 138.347656 367.964844 106.089844 367.964844 86.195312 348.046875 C 66.296875 328.125 66.296875 295.828125 86.195312 275.910156 L 278.207031 83.671875 C 298.097656 63.75 330.363281 63.75 350.257812 83.671875 Z M 350.257812 83.671875 "/>
                                <path style=" stroke:none;fill-rule:nonzero;fill-opacity:1;" class="fill-white dark:fill-white" d="M 198.839844 42.324219 C 218.734375 62.242188 218.734375 94.539062 198.839844 114.457031 L 116.90625 196.484375 C 97.011719 216.40625 64.753906 216.40625 44.855469 196.484375 C 24.960938 176.566406 24.960938 144.269531 44.855469 124.351562 L 126.78125 42.324219 C 146.679688 22.402344 178.941406 22.402344 198.839844 42.324219 Z M 198.839844 42.324219 "/>
                                <path style=" stroke:none;fill-rule:nonzero;fill-opacity:1;" class="fill-white dark:fill-white" d="M 549.855469 263.0625 C 569.75 282.984375 569.75 315.277344 549.855469 335.199219 L 337.238281 548.0625 C 317.34375 567.984375 285.085938 567.984375 265.1875 548.0625 C 245.292969 528.140625 245.292969 495.847656 265.1875 475.925781 L 477.804688 263.0625 C 497.699219 243.140625 529.957031 243.140625 549.855469 263.0625 Z M 549.855469 263.0625 "/>
                                <path style=" stroke:none;fill-rule:nonzero;fill-opacity:1;" class="fill-white dark:fill-white" d="M 578.785156 423.015625 C 598.683594 442.933594 598.683594 475.230469 578.785156 495.148438 L 496.855469 577.171875 C 476.957031 597.089844 444.699219 597.089844 424.804688 577.171875 C 404.90625 557.25 404.90625 524.953125 424.804688 505.035156 L 506.726562 423.015625 C 526.625 403.085938 558.890625 403.085938 578.785156 423.015625 Z M 578.785156 423.015625 "/>
                            </g>
                        </svg>
                        <h2 class="text-4xl tracking-tight font-bold text-white dark:text-white"><?php echo $lang['datanito-pay']; ?></h2>
                    </div>
                    <div class="mb-3">
                        <p class="text-2xl tracking-tight font-normal text-white dark:text-white"><?php echo $lang['home-pay-subheading']; ?></p>
                    </div>
                    <div class="mb-8">
                        <p class="text-xl tracking-tight font-normal text-gray-200 dark:text-gray-200"><?php echo $lang['home-pay-desc']; ?></p>
                    </div>
                    <a href="<?php echo url('/pay'); ?>" class="inline-flex items-center justify-center bg-gray-100 text-dark-900 hover:bg-white focus:outline-none focus:ring-4 focus:ring-gray-300 font-medium rounded-full text-sm px-5 py-1.5 text-center me-2 dark:text-white dark:bg-dark-600 dark:hover:bg-dark-500 dark:focus:ring-dark-800">
                        <?php echo $lang['home-cta']; ?>
                        <span class="material-symbols-outlined text-2xl mt-0.5 ml-0.5">chevron_right</span>
                    </a>
                    <div class="flex justify-center space-x-8 mt-20 sm:mt-14">
                        <div>
                            <div data-slot-slider data-interval="2500" data-duration="250" class="slot-slider p-0 mx-auto h-[6em]">
                                <div class="slot-slider-items">
                                    <div class="text-green-400 dark:text-green-400 text-lg md:text-2xl font-medium slot-slider-item"><?php echo $lang['home-pay-first-feature']; ?></div>
                                    <div class="text-green-400 dark:text-green-400 text-lg md:text-2xl font-medium slot-slider-item"><?php echo $lang['home-pay-second-feature']; ?></div>
                                    <div class="text-green-400 dark:text-green-400 text-lg md:text-2xl font-medium slot-slider-item"><?php echo $lang['home-pay-third-feature']; ?></div>
                                    <div class="text-green-400 dark:text-green-400 text-lg md:text-2xl font-medium slot-slider-item"><?php echo $lang['home-pay-fourth-feature']; ?></div>
                                    <div class="text-green-400 dark:text-green-400 text-lg md:text-2xl font-medium slot-slider-item"><?php echo $lang['home-pay-fifth-feature']; ?></div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
            <section class="grid md:grid-cols-2 md:space-x-4 mx-4 sm:mx-0">
                <div class="flex items-end bg-dark-950 dark:bg-black mt-4 h-[30em] sm:h-[35em] overflow-hidden md:!ml-4 rounded-3xl skeleton">
                    <div class="py-6 px-4 mx-auto max-w-screen-xl text-center pb-0 lg:pt-12 lg:px-4">
                        <div class="flex justify-center space-x-8 mt-24">
                            <img class="w-28 h-28" src="<?php echo asset('images/content/app-store.png')?>" alt="App Store Logo">
                            <img class="w-28 h-28" src="<?php echo asset('images/content/google-play.png')?>" alt="Google Play Logo">
                        </div>
                        <div class="mt-28 mb-6">
                            <h2 class="mb-3 text-3xl tracking-tight font-bold text-white dark:text-white"><?php echo $lang['home-app-dev-heading']; ?></h2>
                            <p class="mb-4 text-xl tracking-tight font-normal text-white dark:text-white"><?php echo $lang['home-app-dev-subheading']; ?></p>
                            <a href="<?php echo url('/solutions/mobile-app-development'); ?>" class="mb-2 inline-flex text-xl tracking-tight font-normal items-center text-blue-500 dark:text-blue-400 items-center">
                                <span class="hover:underline"><?php echo $lang['home-cta']; ?></span>
                                <span class="material-symbols-outlined text-2xl mt-0.5 ml-0.5">chevron_right</span>
                            </a>
                        </div>
                    </div>
                </div>
                <div class="bg-dark-950 dark:bg-black mt-4 h-[30em] sm:h-[35em] overflow-hidden md:!mr-4 rounded-3xl skeleton">
                    <div class="py-6 px-4 mx-auto max-w-screen-xl text-center pb-0 lg:pt-12 lg:px-4">
                        <h2 class="mb-3 mt-4 text-3xl tracking-tight font-bold text-white dark:text-white"><?php echo $lang['home-seo-heading']; ?></h2>
                        <p class="mb-4 text-xl tracking-tight font-normal text-white dark:text-gray-200"><?php echo $lang['home-seo-subheading']; ?></p>
                        <a href="<?php echo url('/solutions/seo'); ?>" class="mb-2 inline-flex text-xl tracking-tight font-normal items-center text-blue-500 dark:text-blue-400 items-center">
                            <span class="hover:underline"><?php echo $lang['home-cta']; ?></span>
                            <span class="material-symbols-outlined text-2xl mt-0.5 ml-0.5">chevron_right</span>
                        </a>
                        <div class="flex justify-center space-x-2 mt-24">
                            <img class="w-28" src="<?php echo asset('images/content/google-logo.png')?>" alt="Google Logo">
                            <img class="w-28" src="<?php echo asset('images/content/bing-logo.png')?>" alt="Bing Logo">
                        </div>
                    </div>
                </div>
                <div class="bg-dark-950 dark:bg-black mt-4 h-[30em] sm:h-[35em] overflow-hidden md:!ml-4 rounded-3xl skeleton">
                    <div class="py-6 px-4 mx-auto max-w-screen-xl text-center pb-0 lg:pt-12 lg:px-4">
                        <div class="flex justify-center mt-[-0.2em] sm:mt-12">
                            <span class="material-symbols-outlined text-9xl text-green-300 rotate-[-10deg]">visibility_lock</span>
                            <span class="material-symbols-outlined text-[15rem] text-green-400">backup</span>
                            <span class="material-symbols-outlined text-9xl text-green-300 rotate-[10deg]">speed</span>
                        </div>
                        <div class="mt-6 sm:mt-16 mb-6">
                            <div class="flex justify-center mb-2 items-center">
                                <svg class="w-10 h-10 mr-0.5" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="151px" height="150px" viewBox="0 0 639 636" version="1.1">
                                    <g id="surface1">
                                        <path style=" stroke:none;fill-rule:nonzero;fill-opacity:1;" class="fill-white dark:fill-white" d="M 543.414062 80.550781 C 563.308594 100.46875 563.308594 132.765625 543.414062 152.683594 L 155.367188 541.199219 C 135.472656 561.121094 103.214844 561.121094 83.316406 541.199219 C 63.421875 521.28125 63.421875 488.984375 83.316406 469.066406 L 471.371094 80.558594 C 491.257812 60.628906 523.515625 60.628906 543.414062 80.550781 Z M 543.414062 80.550781 "/>
                                        <path style=" stroke:none;fill-rule:nonzero;fill-opacity:1;" class="fill-white dark:fill-white" d="M 350.257812 83.671875 C 370.15625 103.589844 370.15625 135.886719 350.257812 155.804688 L 158.246094 348.046875 C 138.347656 367.964844 106.089844 367.964844 86.195312 348.046875 C 66.296875 328.125 66.296875 295.828125 86.195312 275.910156 L 278.207031 83.671875 C 298.097656 63.75 330.363281 63.75 350.257812 83.671875 Z M 350.257812 83.671875 "/>
                                        <path style=" stroke:none;fill-rule:nonzero;fill-opacity:1;" class="fill-white dark:fill-white" d="M 198.839844 42.324219 C 218.734375 62.242188 218.734375 94.539062 198.839844 114.457031 L 116.90625 196.484375 C 97.011719 216.40625 64.753906 216.40625 44.855469 196.484375 C 24.960938 176.566406 24.960938 144.269531 44.855469 124.351562 L 126.78125 42.324219 C 146.679688 22.402344 178.941406 22.402344 198.839844 42.324219 Z M 198.839844 42.324219 "/>
                                        <path style=" stroke:none;fill-rule:nonzero;fill-opacity:1;" class="fill-white dark:fill-white" d="M 549.855469 263.0625 C 569.75 282.984375 569.75 315.277344 549.855469 335.199219 L 337.238281 548.0625 C 317.34375 567.984375 285.085938 567.984375 265.1875 548.0625 C 245.292969 528.140625 245.292969 495.847656 265.1875 475.925781 L 477.804688 263.0625 C 497.699219 243.140625 529.957031 243.140625 549.855469 263.0625 Z M 549.855469 263.0625 "/>
                                        <path style=" stroke:none;fill-rule:nonzero;fill-opacity:1;" class="fill-white dark:fill-white" d="M 578.785156 423.015625 C 598.683594 442.933594 598.683594 475.230469 578.785156 495.148438 L 496.855469 577.171875 C 476.957031 597.089844 444.699219 597.089844 424.804688 577.171875 C 404.90625 557.25 404.90625 524.953125 424.804688 505.035156 L 506.726562 423.015625 C 526.625 403.085938 558.890625 403.085938 578.785156 423.015625 Z M 578.785156 423.015625 "/>
                                    </g>
                                </svg>
                                <h2 class="text-4xl tracking-tight font-bold text-white dark:text-white"><?php echo $lang['home-cloud-heading']; ?></h2>
                            </div>
                            <p class="mb-4 text-xl tracking-tight font-normal text-white dark:text-white"><?php echo $lang['home-cloud-subheading']; ?></p>
                            <a href="<?php echo url('/cloud/business-hosting'); ?>" class="mb-2 inline-flex text-xl tracking-tight font-normal items-center text-blue-500 dark:text-blue-400 items-center">
                                <span class="hover:underline"><?php echo $lang['home-cloud-business-hosting-cta']; ?></span>
                                <span class="material-symbols-outlined text-2xl mt-0.5 ml-0.5">chevron_right</span>
                            </a>
                            <a href="<?php echo url('/cloud/web-hosting'); ?>" class="mb-2 inline-flex text-xl tracking-tight font-normal items-center text-blue-500 dark:text-blue-400 items-center">
                                <span class="hover:underline"><?php echo $lang['home-cloud-web-hosting-cta']; ?></span>
                                <span class="material-symbols-outlined text-2xl mt-0.5 ml-0.5">chevron_right</span>
                            </a>
                        </div>
                    </div>
                </div>
                <div class="bg-gray-100 dark:bg-black mt-4 h-[30em] sm:h-[35em] overflow-hidden md:!mr-4 rounded-3xl skeleton">
                    <div class="py-6 px-4 mx-auto max-w-screen-xl text-center pb-0 lg:pt-12 lg:px-4">
                        <h2 class="mb-3 mt-4 text-3xl tracking-tight font-bold text-gray-900 dark:text-white"><?php echo $lang['home-digital-adverting-heading']; ?></h2>
                        <p class="mb-4 text-xl tracking-tight font-normal text-gray-700 dark:text-gray-200"><?php echo $lang['home-digital-adverting-subheading']; ?></p>
                        <a href="<?php echo url('/solutions/digital-advertising'); ?>" class="mb-2 inline-flex text-xl tracking-tight font-normal items-center text-blue-500 dark:text-blue-400 items-center">
                            <span class="hover:underline"><?php echo $lang['home-cta']; ?></span>
                            <span class="material-symbols-outlined text-2xl mt-0.5 ml-0.5">chevron_right</span>
                        </a>
                        <div class="flex justify-center sm:mt-12">
                            <img class="w-72" src="<?php echo asset('images/content/digital-advertising-3d.png')?>" alt="Digital Advertising">
                        </div>
                    </div>
                </div>
            </section>
        <section class="bg-white dark:bg-dark-900 my-12">
            <!-- Card Blog -->
            <div class="max-w-[85rem] mx-auto">
                <!-- Title -->
                <div class="max-w-2xl mx-auto text-center mb-10 lg:mb-14">
                    <h2 class="text-3xl font-extrabold leading-snug md:text-5xl md:leading-snug dark:text-white">
                        <?php echo $lang['home-blog-headline']?>
                    </h2>
                    <p class="mt-2 text-gray-700 dark:text-gray-400">
                        <?php echo $lang['home-blog-subheading']?>
                    </p>
                </div>
                <!-- End Title -->

                <div class="mx-auto max-w-screen-xl">
                    <div class="blogArchiveContainer grid gap-8 lg:grid-cols-4">
                    </div>
                    <div class="text-center mx-auto">
                        <div role="status" class="spinner hidden my-6">
                            <svg aria-hidden="true" class="inline w-20 h-20 mr-2 text-gray-200 animate-spin dark:text-gray-600 fill-green-500" viewBox="0 0 100 101" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path d="M100 50.5908C100 78.2051 77.6142 100.591 50 100.591C22.3858 100.591 0 78.2051 0 50.5908C0 22.9766 22.3858 0.59082 50 0.59082C77.6142 0.59082 100 22.9766 100 50.5908ZM9.08144 50.5908C9.08144 73.1895 27.4013 91.5094 50 91.5094C72.5987 91.5094 90.9186 73.1895 90.9186 50.5908C90.9186 27.9921 72.5987 9.67226 50 9.67226C27.4013 9.67226 9.08144 27.9921 9.08144 50.5908Z" fill="currentColor"/>
                                <path d="M93.9676 39.0409C96.393 38.4038 97.8624 35.9116 97.0079 33.5539C95.2932 28.8227 92.871 24.3692 89.8167 20.348C85.8452 15.1192 80.8826 10.7238 75.2124 7.41289C69.5422 4.10194 63.2754 1.94025 56.7698 1.05124C51.7666 0.367541 46.6976 0.446843 41.7345 1.27873C39.2613 1.69328 37.813 4.19778 38.4501 6.62326C39.0873 9.04874 41.5694 10.4717 44.0505 10.1071C47.8511 9.54855 51.7191 9.52689 55.5402 10.0491C60.8642 10.7766 65.9928 12.5457 70.6331 15.2552C75.2735 17.9648 79.3347 21.5619 82.5849 25.841C84.9175 28.9121 86.7997 32.2913 88.1811 35.8758C89.083 38.2158 91.5421 39.6781 93.9676 39.0409Z" fill="currentFill"/>
                            </svg>
                            <span class="sr-only">Loading...</span>
                        </div>
                    </div>
                </div>

                <!-- Card -->
                <div class="mt-12 text-center">
                    <a href="<?php echo url('/blog'); ?>" class="inline-flex justify-center text-sm bg-dark-700 dark:bg-dark-600 hover:shadow-xl transition-all duration-300 hover:scale-105 items-center group space-x-2 text-white py-3 px-4 md:py-2.5 md:px-6 rounded-full cursor-pointer">
                        <?php echo $lang['home-blog-cta']?>
                        <svg class="shrink-0 size-4" xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="m9 18 6-6-6-6"/></svg>
                    </a>
                </div>
                <!-- End Card -->
            </div>
            <!-- End Card Blog -->
        </section>
        <section id="faqs" class="bg-white dark:bg-dark-900 mb-12">
            <div class="py-8 px-4 mx-auto max-w-screen-md text-center lg:py-16 lg:px-6">
                <div class="mx-auto max-w-screen-sm">
                    <h4 class="mb-4 text-4xl tracking-tight font-bold text-gray-900 dark:text-white"><?php echo $lang['faqs-headline'] ?></h4>
                    <p class="mb-8 font-normal text-gray-500 lg:mb-16 sm:text-xl dark:text-gray-400"><?php echo $lang['faqs-subheading'] ?></p>
                </div>
                <div id="accordion-collapse" data-accordion="collapse" class="divide-y-2 divide-gray-100 dark:divide-dark-600">
                    <?php foreach ($faqSection as $index => $faq): ?>
                        <div>
                            <p id="accordion-collapse-heading-<?php echo $index + 1; ?>">
                                <button type="button" class="flex items-center justify-between !bg-transparent dark:!bg-transparent w-full p-5 font-medium text-left text-gray-700 focus:ring-0 dark:text-gray-300 hover:bg-gray-100 dark:hover:bg-dark-700" data-accordion-target="#accordion-collapse-body-<?php echo $index + 1; ?>" aria-expanded="false" aria-controls="accordion-collapse-body-<?php echo $index + 1; ?>">
                                    <span><?php echo $faq['question']; ?></span>
                                    <svg data-accordion-icon class="w-3 h-3 rotate-180 shrink-0" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 10 6">
                                        <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5 5 1 1 5"/>
                                    </svg>
                                </button>
                            </p>
                            <div id="accordion-collapse-body-<?php echo $index + 1; ?>" class="ml-2 hidden !bg-transparent dark:!bg-transparent text-left rounded-xl mb-2 pt-5 px-5 pb-5 mb-6 text-gray-700 dark:text-gray-300 bg-gray-100 dark:bg-dark-700">
                                <?php echo $faq['answer']; ?>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>
            </div>
        </section>

            <!--            <div class="glass-container">-->
<!--                <div class="overlay">-->
<!--                    <div class="card">-->
<!--                        <div class="card__title">Title</div>-->
<!--                        <div class="card__content">This is the content</div>-->
<!--                    </div>-->
<!--                </div>-->
<!--                <div class="overlay overlay--light">-->
<!--                    <div class="card card--light">-->
<!--                        <div class="card__title">Title</div>-->
<!--                        <div class="card__content">This is the content</div>-->
<!--                    </div>-->
<!--                </div>-->
<!--            </div>-->
<!--            <form>-->
<!--                --><?php //echo $_HEADER['datanito']?>
<!--                <label>Name:</label>-->
<!--                <input type="text" id="name" name="name"><br>-->
<!--                <button type="button" id="submit">Submit</button>-->
<!--            </form>-->
<!--            <div id="message"></div>-->
<!--            <div class="alert-container"></div>-->
<!--            <button class="btn button-ux btn-arrow add-to-cart-btn" data-product-id="3" >-->
<!--                <svg aria-hidden="true" class="inline w-5 h-5 mr-2 text-gray-200 animate-spin dark:text-gray-600 fill-gray-600 spinner-status hidden" viewBox="0 0 100 101" fill="none" xmlns="http://www.w3.org/2000/svg">-->
<!--                    <path d="M100 50.5908C100 78.2051 77.6142 100.591 50 100.591C22.3858 100.591 0 78.2051 0 50.5908C0 22.9766 22.3858 0.59082 50 0.59082C77.6142 0.59082 100 22.9766 100 50.5908ZM9.08144 50.5908C9.08144 73.1895 27.4013 91.5094 50 91.5094C72.5987 91.5094 90.9186 73.1895 90.9186 50.5908C90.9186 27.9921 72.5987 9.67226 50 9.67226C27.4013 9.67226 9.08144 27.9921 9.08144 50.5908Z" fill="currentColor"/>-->
<!--                    <path d="M93.9676 39.0409C96.393 38.4038 97.8624 35.9116 97.0079 33.5539C95.2932 28.8227 92.871 24.3692 89.8167 20.348C85.8452 15.1192 80.8826 10.7238 75.2124 7.41289C69.5422 4.10194 63.2754 1.94025 56.7698 1.05124C51.7666 0.367541 46.6976 0.446843 41.7345 1.27873C39.2613 1.69328 37.813 4.19778 38.4501 6.62326C39.0873 9.04874 41.5694 10.4717 44.0505 10.1071C47.8511 9.54855 51.7191 9.52689 55.5402 10.0491C60.8642 10.7766 65.9928 12.5457 70.6331 15.2552C75.2735 17.9648 79.3347 21.5619 82.5849 25.841C84.9175 28.9121 86.7997 32.2913 88.1811 35.8758C89.083 38.2158 91.5421 39.6781 93.9676 39.0409Z" fill="currentFill"/>-->
<!--                </svg><span class="sr-only">Loading...</span>-->
<!--                <span class="d-flex align-items-center text-center">Add to cart<span class="material-symbols-outlined east-icon">east</span></span>-->
<!--            </button>-->

<!--        </div>-->

<!--        <section class="bg-white mt-5 dark:bg-gray-900 bg-[url('https://flowbite.s3.amazonaws.com/docs/jumbotron/hero-pattern.svg')] dark:bg-[url('https://flowbite.s3.amazonaws.com/docs/jumbotron/hero-pattern-dark.svg')]">-->
<!--            <div class="py-8 px-4 mx-auto max-w-screen-xl text-center lg:py-16 z-10 relative">-->
<!--                <a href="#" class="inline-flex justify-between items-center py-1 px-1 pr-4 mb-7 text-sm text-blue-700 bg-blue-100 rounded-full dark:bg-blue-900 dark:text-blue-300 hover:bg-blue-200 dark:hover:bg-blue-800">-->
<!--                    <span class="text-xs bg-blue-600 rounded-full text-white px-4 py-1.5 mr-3">New</span> <span class="text-sm font-medium">Jumbotron component was launched! See what's new</span>-->
<!--                    <svg class="w-2.5 h-2.5 ml-2" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 6 10">-->
<!--                        <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="m1 9 4-4-4-4"/>-->
<!--                    </svg>-->
<!--                </a>-->
<!--                <h1 class="mb-4 text-4xl font-extrabold tracking-tight leading-none text-gray-900 md:text-5xl lg:text-6xl dark:text-white">We invest in the world’s potential</h1>-->
<!--                <p class="mb-8 text-lg font-normal text-gray-500 lg:text-xl sm:px-16 lg:px-48 dark:text-gray-200">Here at Flowbite we focus on markets where technology, innovation, and capital can unlock long-term value and drive economic growth.</p>-->
<!--                <form class="w-full max-w-md mx-auto">-->
<!--                    <label for="default-email" class="mb-2 text-sm font-medium text-gray-900 sr-only dark:text-white">Email sign-up</label>-->
<!--                    <div class="relative">-->
<!--                        <div class="absolute inset-y-0 left-0 flex items-center pl-3.5 pointer-events-none">-->
<!--                            <svg class="w-4 h-4 text-gray-500 dark:text-gray-400" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="currentColor" viewBox="0 0 20 16">-->
<!--                                <path d="m10.036 8.278 9.258-7.79A1.979 1.979 0 0 0 18 0H2A1.987 1.987 0 0 0 .641.541l9.395 7.737Z"/>-->
<!--                                <path d="M11.241 9.817c-.36.275-.801.425-1.255.427-.428 0-.845-.138-1.187-.395L0 2.6V14a2 2 0 0 0 2 2h16a2 2 0 0 0 2-2V2.5l-8.759 7.317Z"/>-->
<!--                            </svg>-->
<!--                        </div>-->
<!--                        <input type="email" id="default-email" class="block w-full p-4 pl-10 text-sm text-gray-900 border border-gray-300 rounded-lg bg-white focus:ring-blue-500 focus:border-blue-500 dark:bg-gray-800 dark:border-gray-700 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500" placeholder="Enter your email here..." required>-->
<!--                        <button type="submit" class="text-white absolute right-2.5 bottom-2.5 bg-blue-700 hover:bg-blue-800 focus:ring-4 focus:outline-none focus:ring-blue-300 font-medium rounded-lg text-sm px-4 py-2 dark:bg-blue-600 dark:hover:bg-blue-700 dark:focus:ring-blue-800">Sign up</button>-->
<!--                    </div>-->
<!--                </form>-->
<!---->
<!--            </div>-->
<!--        </section>-->



    <script>
        const words = [<?php echo $lang['home-dino-typing-words'] ?>], colors = ["text-primary-500", "text-green-500", "text-blue-500", "text-yellow-400"], text = document.querySelector(".text");
        // Generator (iterate from 0-3)
        function* generator() {
            var index = 0;
            while (true) {
                yield index++;

                if (index > 3) {
                    index = 0;
                }
            }
        }

        // Printing effect
        function printChar(word) {
            let i = 0;
            text.innerHTML = "";
            text.classList.add(colors[words.indexOf(word)]);
            let id = setInterval(() => {
                if (i >= word.length) {
                    deleteChar();
                    clearInterval(id);
                } else {
                    text.innerHTML += word[i];
                    i++;
                }
            }, 200);
        }

        // Deleting effect
        function deleteChar() {
            let word = text.innerHTML;
            let i = word.length - 1;
            let id = setInterval(() => {
                if (i >= 0) {
                    text.innerHTML = text.innerHTML.substring(0, text.innerHTML.length - 1);
                    i--;
                } else {
                    text.classList.remove(colors[words.indexOf(word)]);
                    printChar(words[gen.next().value]);
                    clearInterval(id);
                }
            }, 300);
        }

        // Initializing generator
        let gen = generator();

        printChar(words[gen.next().value]);

    </script>

</div>

<?php

include_once includes('layouts/footer.php');
?>
<script>
    $(document).ready(function() {
        const blogArchive = $('.blogArchiveContainer');
        $('.spinner').show();

        // Function to truncate text
        function truncateText(text, maxLength) {
            return text.length > maxLength ? text.substring(0, maxLength) + '...' : text;
        }

        // Fetch and display blog archive using AJAX
        $.ajax({
            type: 'POST',
            url: '/blog-fetch-archive',
            data: { category: '' },
            dataType: 'json',
            success: function(response) {
                $('.spinner').hide();
                if (!response || $.isEmptyObject(response)) {
                    console.log("Empty or invalid response received");
                    return;
                }
                console.log(response);

                // Limit to the last 4 posts
                const recentPosts = response.slice(0, 4);

                // Function to calculate reading time
                function calculateReadingTime(content) {
                    const wordsPerMinute = 200;
                    const words = content.split(' ').length;
                    return Math.ceil(words / wordsPerMinute);
                }

                if (recentPosts.length === 0) {
                    $('.empty-message').removeClass('hidden');
                } else {
                    blogArchive.empty();

                    $.each(recentPosts, function(index, blog) {
                        function formatCreatedAt(updated_at) {
                            const date = new Date(updated_at);
                            const options = { year: 'numeric', month: 'long', day: 'numeric' };

                            // Calculate the difference in milliseconds between the current time and the blog post creation time
                            const timeDifference = Date.now() - date.getTime();

                            // Define time intervals in milliseconds
                            const minute = 60 * 1000;
                            const hour = 60 * minute;
                            const day = 24 * hour;
                            const month = 30 * day;
                            const year = 365 * day;

                            const seconds = Math.floor(timeDifference / 1000);
                            const minutes = Math.floor(timeDifference / minute);
                            const hours = Math.floor(timeDifference / hour);
                            const days = Math.floor(timeDifference / day);
                            const months = Math.floor(timeDifference / month);
                            const years = Math.floor(timeDifference / year);

                            let timeAgo;

                            if (timeDifference < minute) {
                                timeAgo = (seconds > 1 ? '<?php echo $lang['d-seconds-ago']; ?>'.replace('%d', seconds) : '<?php echo $lang['d-second-ago']; ?>'.replace('%d', seconds));
                            } else if (timeDifference < hour) {
                                timeAgo = (minutes > 1 ? '<?php echo $lang['d-minutes-ago']; ?>'.replace('%d', minutes) : '<?php echo $lang['d-minute-ago']; ?>'.replace('%d', minutes));
                            } else if (timeDifference < day) {
                                timeAgo = (hours > 1 ? '<?php echo $lang['d-hours-ago']; ?>'.replace('%d', hours) : '<?php echo $lang['d-hour-ago']; ?>'.replace('%d', hours));
                            } else if (timeDifference < month) {
                                timeAgo = (days > 1 ? '<?php echo $lang['d-days-ago']; ?>'.replace('%d', days) : '<?php echo $lang['d-day-ago']; ?>'.replace('%d', days));
                            } else if (timeDifference < year) {
                                timeAgo = (months > 1 ? '<?php echo $lang['d-months-ago']; ?>'.replace('%d', months) : '<?php echo $lang['d-month-ago']; ?>'.replace('%d', months));
                            } else {
                                timeAgo = (years > 1 ? '<?php echo $lang['d-years-ago']; ?>'.replace('%d', years) : '<?php echo $lang['d-year-ago']; ?>'.replace('%d', years));
                            }

                            return timeAgo;
                        }

                        const readingTime = calculateReadingTime(blog.content);
                        const formattedCreatedAt = formatCreatedAt(blog.updated_at);
                        const readingTimeDisplay = `<?php echo $lang['x-min-read']; ?>`.replace('%d', readingTime);

                        const truncatedTitle = truncateText(blog.title, 45); // Limit title to 50 characters
                        const truncatedDescription = truncateText(blog.short_content, 80); // Limit description to 100 characters

                        const blogRow = $("<article class='p-6 bg-white rounded-3xl border border-gray-200 dark:bg-dark-700 dark:border-dark-600'>");
                        blogRow.html(`
                        <div class="photo-container w-full h-36 mb-4 rounded-3xl">
                            ${blog.main_photo ? `<img class="w-full h-36 rounded-3xl object-cover border-2 border-gray-100 dark:border-dark-600" src="<?php echo asset('uploads/blog/${blog.main_photo}')?>" alt="${truncatedTitle}" />` : '<div class="flex items-center justify-center bg-gray-100 dark:bg-dark-600 w-full h-36 rounded-3xl"><span class="material-symbols-outlined text-gray-300 dark:text-dark-500">no_photography</span></div>'}
                        </div>
                        <div class="flex justify-between items-center mb-5 text-gray-500">
                            <span>${readingTimeDisplay}</span>
                            <time pubdate datetime="${blog.updated_at}" title="${formattedCreatedAt}">${formattedCreatedAt}</time>
                        </div>
                        <h4 class="mb-2 text-2xl font-bold tracking-tight text-gray-900 dark:text-white">
                            <a href="<?php echo url('/blog/${blog.slug}')?>">${truncatedTitle}</a>
                        </h2>
                        <p class="mb-5 font-light text-gray-500 dark:text-gray-400 overflow-hidden">${truncatedDescription}</p>
                        <div class="flex justify-between items-center">
                            <div class="flex items-center">
                                <img class="relative inline-flex w-9 h-9 overflow-hidden rounded-full mr-2" src="<?php echo asset('uploads/profile_pictures/${blog.author_avatar}')?>" alt="${blog.author_name}">
                                <span class="font-medium dark:text-white">${blog.author_name}</span>
                                ${blog.author_verification_badge_html}
                            </div>
                            <a href="<?php echo url('/blog/${blog.slug}')?>" class="inline-flex items-center text-white bg-blue-700 hover:bg-blue-800 focus:outline-none focus:ring-4 focus:ring-blue-300 font-medium rounded-full text-sm px-3 py-3 text-center me-2 mb-2 dark:bg-blue-600 dark:hover:bg-blue-700 dark:focus:ring-blue-800">
                                <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 20 20" xmlns="http://www.w3.org/2000/svg">
                                    <path fill-rule="evenodd" d="M10.293 3.293a1 1 0 011.414 0l6 6a1 1 0 010 1.414l-6 6a1 1 0 01-1.414-1.414L14.586 11H3a1 1 0 110-2h11.586l-4.293-4.293a1 1 0 010-1.414z" clip-rule="evenodd"></path>
                                </svg>
                            </a>
                        </div>
                    `);

                        blogArchive.append(blogRow);
                    });
                }
            },
            error: function(xhr, status, error) {
                console.log(error);
            }
        });
    });

</script>
