
<?php
$meta = array(
    'us' => array(
        'title' => 'Datanito - Enterprise AI Solutions & Software Development',
        'description' => 'Datanito delivers cutting-edge AI solutions, enterprise software development, and cloud services for businesses worldwide. Transform your digital future with our technology expertise.',
        'og:title' => 'Datanito - AI & Software Solutions for Enterprises',
        'og:description' => 'Global leader in AI-powered enterprise solutions, cloud computing, and digital transformation services.',
        'og:image' => asset('images/brand/enterprise-og-image.jpg'),
    ),
    'tr' => array(
        'title' => 'Datanito - Kurumsal Yapay Zeka Çözümleri ve Yazılım Geliştirme',
        'description' => 'Datanito, işletmeler için yapay zeka çözümleri, kurumsal yazılım geliştirme ve bulut hizmetleri sunar. Dijital dönüşümünüzü uzmanlığımızla gerçekleştirin.',
        'og:title' => 'Datanito - Kurumsal Yapay Zeka ve Yazılım Çözümleri',
        'og:description' => 'Yapay zeka destekli kurumsal çözümler, bulut bilişim ve dijital dönüşüm hizmetlerinde küresel lider.',
        'og:image' => asset('images/brand/enterprise-og-image.jpg'),
    ),
);

$currentMeta = setCountryAndMeta($meta);

// Enhanced Schema.org markup for corporate identity
$schemaOrg = array(
    "@context" => "http://schema.org",
    "@type" => "Corporation",
    "name" => "Datanito Software Technology Ltd",
    "legalName" => "Datanito Software Technology Limited",
    "description" => "Global provider of AI-powered enterprise solutions and software development services",
    "url" => "https://datanito.com",
    "logo" => "https://datanito.com/images/brand/logo.png",
    "foundingDate" => "2018",
    "founders" => array(
        array(
            "@type" => "Person",
            "name" => "Milad Saraf"
        )
    ),
    "address" => array(
        "@type" => "PostalAddress",
        "streetAddress" => "Yakuplu, Hürriyet Blv, Skyport Residance",
        "addressLocality" => "Beylikdüzü",
        "addressRegion" => "Istanbul",
        "postalCode" => "34524",
        "addressCountry" => "Türkiye"
    ),
    "contactPoint" => array(
        array(
            "@type" => "ContactPoint",
            "telephone" => "+90-538-224-4717",
            "contactType" => "customer service",
            "areaServed" => "Worldwide"
        )
    ),
    "sameAs" => array(
        "https://www.facebook.com/datanito",
        "https://twitter.com/datanito",
        "https://www.instagram.com/datanito/",
        "https://www.linkedin.com/company/datanito/",
        "https://github.com/datanito"
    )
);

$jsonOrgLD = json_encode($schemaOrg, JSON_UNESCAPED_SLASHES);

include_once includes('layouts/header.php');
?>

<div id="content" class="container mx-auto lg:mt-12 mt-12">
    <!-- Enterprise Hero Section -->
    <section class="relative bg-gradient-to-b from-blue-900 to-blue-800 dark:from-gray-900 dark:to-gray-800 py-20 lg:py-32 overflow-hidden">
        <!-- Animated background elements -->
        <div class="absolute inset-0 overflow-hidden">
            <div class="absolute top-0 left-0 w-full h-full bg-[url('<?php echo asset('images/brand/circuit-pattern-dark.png')?>')] opacity-10"></div>
            <div class="absolute top-0 left-0 w-full h-full bg-gradient-to-r from-blue-900/20 to-transparent"></div>
        </div>

        <div class="container mx-auto px-6 lg:px-8 relative z-10">
            <div class="grid grid-cols-1 lg:grid-cols-2 gap-12 items-center">
                <div>
                    <div class="mb-6">
                        <span class="inline-flex items-center px-4 py-2 rounded-full text-sm font-medium bg-blue-100 text-blue-800 dark:bg-blue-900 dark:text-blue-200">
                            <?php echo $lang['about-us-superior'] ?>
                        </span>
                    </div>
                    <h1 class="text-4xl md:text-5xl lg:text-6xl font-bold text-white mb-6 leading-tight">
                        Enterprise AI Solutions <span class="text-transparent bg-clip-text bg-gradient-to-r from-cyan-400 to-purple-300">That Transform Businesses</span>
                    </h1>
                    <p class="text-xl md:text-2xl text-blue-100 dark:text-blue-200 mb-8 max-w-2xl">
                        Harness the power of artificial intelligence and cutting-edge software to drive innovation and growth.
                    </p>
                    <div class="flex flex-col sm:flex-row gap-4">
                        <a href="<?php echo url('/solutions'); ?>" class="inline-flex items-center justify-center px-8 py-4 border border-transparent text-base font-medium rounded-lg text-blue-900 bg-white hover:bg-blue-50 transition duration-300 shadow-lg hover:shadow-xl">
                            Explore Solutions
                            <svg class="ml-2 w-5 h-5" fill="currentColor" viewBox="0 0 20 20" xmlns="http://www.w3.org/2000/svg">
                                <path fill-rule="evenodd" d="M10.293 5.293a1 1 0 011.414 0l4 4a1 1 0 010 1.414l-4 4a1 1 0 01-1.414-1.414L12.586 11H5a1 1 0 110-2h7.586l-2.293-2.293a1 1 0 010-1.414z" clip-rule="evenodd"></path>
                            </svg>
                        </a>
                        <a href="<?php echo url('/contact'); ?>" class="inline-flex items-center justify-center px-8 py-4 border border-transparent text-base font-medium rounded-lg text-white bg-blue-600 bg-opacity-80 hover:bg-opacity-100 transition duration-300">
                            Contact Our Experts
                        </a>
                    </div>

                    <div class="mt-12 flex items-center space-x-6">
                        <div class="flex items-center">
                            <svg class="w-5 h-5 text-yellow-400 mr-2" fill="currentColor" viewBox="0 0 20 20">
                                <path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"></path>
                            </svg>
                            <span class="text-white">4.9/5 (120+ reviews)</span>
                        </div>
                        <div class="flex items-center">
                            <svg class="w-5 h-5 text-green-400 mr-2" fill="currentColor" viewBox="0 0 20 20">
                                <path fill-rule="evenodd" d="M6.267 3.455a3.066 3.066 0 001.745-.723 3.066 3.066 0 013.976 0 3.066 3.066 0 001.745.723 3.066 3.066 0 012.812 2.812c.051.643.304 1.254.723 1.745a3.066 3.066 0 010 3.976 3.066 3.066 0 00-.723 1.745 3.066 3.066 0 01-2.812 2.812 3.066 3.066 0 00-1.745.723 3.066 3.066 0 01-3.976 0 3.066 3.066 0 00-1.745-.723 3.066 3.066 0 01-2.812-2.812 3.066 3.066 0 00-.723-1.745 3.066 3.066 0 010-3.976 3.066 3.066 0 00.723-1.745 3.066 3.066 0 012.812-2.812zm7.44 5.252a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"></path>
                            </svg>
                            <span class="text-white">150+ Enterprise Clients</span>
                        </div>
                    </div>
                </div>

                <div class="relative hidden lg:block">
                    <div class="relative w-full h-full">
                        <div class="absolute top-0 left-0 w-full h-full bg-blue-600 rounded-2xl opacity-20 blur-3xl"></div>
                        <div class="relative bg-white dark:bg-gray-800 rounded-2xl shadow-2xl overflow-hidden">
                            <img src="<?php echo asset('images/content/ai-dashboard-showcase.jpg')?>" alt="Datanito AI Dashboard" class="w-full h-auto object-cover">
                            <div class="absolute bottom-0 left-0 right-0 bg-gradient-to-t from-black/80 to-transparent p-6">
                                <h3 class="text-white text-xl font-semibold">Datanito AI Enterprise Dashboard</h3>
                                <p class="text-blue-200 text-sm mt-1">Real-time analytics and predictive insights</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Trusted By Section -->
    <section class="py-12 bg-gray-50 dark:bg-gray-900">
        <div class="container mx-auto px-6 lg:px-8">
            <div class="text-center mb-12">
                <p class="text-sm font-semibold tracking-wider text-blue-600 dark:text-blue-400 uppercase">Trusted by industry leaders</p>
                <h2 class="mt-2 text-3xl font-bold text-gray-900 dark:text-white">Powering Innovation Across Industries</h2>
            </div>

            <div class="grid grid-cols-2 md:grid-cols-4 lg:grid-cols-5 gap-8 items-center justify-center">
                <div class="flex justify-center p-4 bg-white dark:bg-gray-800 rounded-lg shadow-sm hover:shadow-md transition duration-300">
                    <img src="<?php echo asset('images/clients/logo-client-1.png')?>" alt="Client Logo" class="h-12 object-contain opacity-70 hover:opacity-100 transition duration-300">
                </div>
                <div class="flex justify-center p-4 bg-white dark:bg-gray-800 rounded-lg shadow-sm hover:shadow-md transition duration-300">
                    <img src="<?php echo asset('images/clients/logo-client-2.png')?>" alt="Client Logo" class="h-12 object-contain opacity-70 hover:opacity-100 transition duration-300">
                </div>
                <div class="flex justify-center p-4 bg-white dark:bg-gray-800 rounded-lg shadow-sm hover:shadow-md transition duration-300">
                    <img src="<?php echo asset('images/clients/logo-client-3.png')?>" alt="Client Logo" class="h-12 object-contain opacity-70 hover:opacity-100 transition duration-300">
                </div>
                <div class="flex justify-center p-4 bg-white dark:bg-gray-800 rounded-lg shadow-sm hover:shadow-md transition duration-300">
                    <img src="<?php echo asset('images/clients/logo-client-4.png')?>" alt="Client Logo" class="h-12 object-contain opacity-70 hover:opacity-100 transition duration-300">
                </div>
                <div class="flex justify-center p-4 bg-white dark:bg-gray-800 rounded-lg shadow-sm hover:shadow-md transition duration-300">
                    <img src="<?php echo asset('images/clients/logo-client-5.png')?>" alt="Client Logo" class="h-12 object-contain opacity-70 hover:opacity-100 transition duration-300">
                </div>
            </div>
        </div>
    </section>

    <!-- AI Solutions Section -->
    <section class="py-16 bg-white dark:bg-gray-900">
        <div class="container mx-auto px-6 lg:px-8">
            <div class="grid grid-cols-1 lg:grid-cols-2 gap-12 items-center">
                <div>
                    <div class="mb-6">
                        <span class="inline-flex items-center px-4 py-2 rounded-full text-sm font-medium bg-blue-100 text-blue-800 dark:bg-blue-900 dark:text-blue-200">
                            AI Innovation
                        </span>
                    </div>
                    <h2 class="text-3xl md:text-4xl font-bold text-gray-900 dark:text-white mb-6">
                        <span class="text-transparent bg-clip-text bg-gradient-to-r from-blue-600 to-cyan-400">AI-Powered Solutions</span> for Modern Enterprises
                    </h2>
                    <p class="text-lg text-gray-600 dark:text-gray-300 mb-8">
                        Our artificial intelligence solutions are transforming industries by automating complex processes, uncovering insights, and driving smarter decision-making.
                    </p>

                    <div class="space-y-6">
                        <div class="flex">
                            <div class="flex-shrink-0 bg-blue-100 dark:bg-blue-900 rounded-lg p-3">
                                <svg class="w-6 h-6 text-blue-600 dark:text-blue-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9.663 17h4.673M12 3v1m6.364 1.636l-.707.707M21 12h-1M4 12H3m3.343-5.657l-.707-.707m2.828 9.9a5 5 0 117.072 0l-.548.547A3.374 3.374 0 0014 18.469V19a2 2 0 11-4 0v-.531c0-.895-.356-1.754-.988-2.386l-.548-.547z"></path>
                                </svg>
                            </div>
                            <div class="ml-4">
                                <h3 class="text-lg font-semibold text-gray-900 dark:text-white">Predictive Analytics</h3>
                                <p class="text-gray-600 dark:text-gray-400">
                                    Leverage machine learning models to forecast trends and make data-driven decisions.
                                </p>
                            </div>
                        </div>

                        <div class="flex">
                            <div class="flex-shrink-0 bg-blue-100 dark:bg-blue-900 rounded-lg p-3">
                                <svg class="w-6 h-6 text-blue-600 dark:text-blue-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 8h10M7 12h4m1 8l-4-4H5a2 2 0 01-2-2V6a2 2 0 012-2h14a2 2 0 012 2v8a2 2 0 01-2 2h-3l-4 4z"></path>
                                </svg>
                            </div>
                            <div class="ml-4">
                                <h3 class="text-lg font-semibold text-gray-900 dark:text-white">Natural Language Processing</h3>
                                <p class="text-gray-600 dark:text-gray-400">
                                    Advanced text analysis and generation for customer service and content creation.
                                </p>
                            </div>
                        </div>

                        <div class="flex">
                            <div class="flex-shrink-0 bg-blue-100 dark:bg-blue-900 rounded-lg p-3">
                                <svg class="w-6 h-6 text-blue-600 dark:text-blue-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 18h.01M8 21h8a2 2 0 002-2V5a2 2 0 00-2-2H8a2 2 0 00-2 2v14a2 2 0 002 2z"></path>
                                </svg>
                            </div>
                            <div class="ml-4">
                                <h3 class="text-lg font-semibold text-gray-900 dark:text-white">Computer Vision</h3>
                                <p class="text-gray-600 dark:text-gray-400">
                                    Image and video analysis for quality control, security, and automation.
                                </p>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="relative">
                    <div class="relative w-full h-full bg-gray-100 dark:bg-gray-800 rounded-2xl overflow-hidden shadow-xl">
                        <img src="<?php echo asset('images/content/ai-solutions-showcase.jpg')?>" alt="AI Solutions" class="w-full h-auto object-cover">
                        <div class="absolute inset-0 bg-gradient-to-t from-blue-900/40 to-transparent"></div>
                        <div class="absolute bottom-0 left-0 right-0 p-6">
                            <div class="bg-white dark:bg-gray-900 rounded-lg p-6 shadow-lg">
                                <h3 class="text-xl font-bold text-gray-900 dark:text-white mb-2">Ready to Transform Your Business with AI?</h3>
                                <p class="text-gray-600 dark:text-gray-300 mb-4">
                                    Schedule a consultation with our AI experts to explore custom solutions.
                                </p>
                                <a href="<?php echo url('/contact'); ?>" class="inline-flex items-center justify-center px-6 py-3 border border-transparent text-base font-medium rounded-lg text-white bg-blue-600 hover:bg-blue-700 transition duration-300">
                                    Book a Demo
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Enterprise Software Development -->
    <section class="py-16 bg-gray-50 dark:bg-gray-900">
        <div class="container mx-auto px-6 lg:px-8">
            <div class="text-center mb-12">
                <span class="inline-flex items-center px-4 py-2 rounded-full text-sm font-medium bg-blue-100 text-blue-800 dark:bg-blue-900 dark:text-blue-200">
                    Software Excellence
                </span>
                <h2 class="mt-4 text-3xl md:text-4xl font-bold text-gray-900 dark:text-white">
                    Enterprise Software <span class="text-transparent bg-clip-text bg-gradient-to-r from-blue-600 to-cyan-400">Development Services</span>
                </h2>
                <p class="mt-4 text-lg text-gray-600 dark:text-gray-300 max-w-3xl mx-auto">
                    Custom software solutions designed to streamline operations, enhance productivity, and drive business growth.
                </p>
            </div>

            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
                <div class="bg-white dark:bg-gray-800 rounded-xl shadow-md overflow-hidden hover:shadow-xl transition duration-300">
                    <div class="h-48 bg-gradient-to-r from-blue-500 to-blue-600 flex items-center justify-center">
                        <svg class="w-16 h-16 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9.75 17L9 20l-1 1h8l-1-1-.75-3M3 13h18M5 17h14a2 2 0 002-2V5a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z"></path>
                        </svg>
                    </div>
                    <div class="p-6">
                        <h3 class="text-xl font-bold text-gray-900 dark:text-white mb-2">Custom Web Applications</h3>
                        <p class="text-gray-600 dark:text-gray-300 mb-4">
                            Scalable, secure web platforms tailored to your business requirements and workflows.
                        </p>
                        <a href="<?php echo url('/solutions/web-development'); ?>" class="inline-flex items-center text-blue-600 dark:text-blue-400 hover:underline">
                            Learn more
                            <svg class="w-4 h-4 ml-1" fill="currentColor" viewBox="0 0 20 20">
                                <path fill-rule="evenodd" d="M12.293 5.293a1 1 0 011.414 0l4 4a1 1 0 010 1.414l-4 4a1 1 0 01-1.414-1.414L14.586 11H3a1 1 0 110-2h11.586l-2.293-2.293a1 1 0 010-1.414z" clip-rule="evenodd"></path>
                            </svg>
                        </a>
                    </div>
                </div>

                <div class="bg-white dark:bg-gray-800 rounded-xl shadow-md overflow-hidden hover:shadow-xl transition duration-300">
                    <div class="h-48 bg-gradient-to-r from-purple-500 to-purple-600 flex items-center justify-center">
                        <svg class="w-16 h-16 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 18h.01M8 21h8a2 2 0 002-2V5a2 2 0 00-2-2H8a2 2 0 00-2 2v14a2 2 0 002 2z"></path>
                        </svg>
                    </div>
                    <div class="p-6">
                        <h3 class="text-xl font-bold text-gray-900 dark:text-white mb-2">Mobile Solutions</h3>
                        <p class="text-gray-600 dark:text-gray-300 mb-4">
                            Cross-platform mobile apps that engage customers and empower your workforce.
                        </p>
                        <a href="<?php echo url('/solutions/mobile-app-development'); ?>" class="inline-flex items-center text-blue-600 dark:text-blue-400 hover:underline">
                            Learn more
                            <svg class="w-4 h-4 ml-1" fill="currentColor" viewBox="0 0 20 20">
                                <path fill-rule="evenodd" d="M12.293 5.293a1 1 0 011.414 0l4 4a1 1 0 010 1.414l-4 4a1 1 0 01-1.414-1.414L14.586 11H3a1 1 0 110-2h11.586l-2.293-2.293a1 1 0 010-1.414z" clip-rule="evenodd"></path>
                            </svg>
                        </a>
                    </div>
                </div>

                <div class="bg-white dark:bg-gray-800 rounded-xl shadow-md overflow-hidden hover:shadow-xl transition duration-300">
                    <div class="h-48 bg-gradient-to-r from-cyan-500 to-cyan-600 flex items-center justify-center">
                        <svg class="w-16 h-16 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 12h14M5 12a2 2 0 01-2-2V6a2 2 0 012-2h14a2 2 0 012 2v4a2 2 0 01-2 2M5 12a2 2 0 00-2 2v4a2 2 0 002 2h14a2 2 0 002-2v-4a2 2 0 00-2-2m-2-4h.01M17 16h.01"></path>
                        </svg>
                    </div>
                    <div class="p-6">
                        <h3 class="text-xl font-bold text-gray-900 dark:text-white mb-2">Enterprise Systems</h3>
                        <p class="text-gray-600 dark:text-gray-300 mb-4">
                            Comprehensive ERP, CRM, and business management solutions for large organizations.
                        </p>
                        <a href="<?php echo url('/solutions/enterprise-software'); ?>" class="inline-flex items-center text-blue-600 dark:text-blue-400 hover:underline">
                            Learn more
                            <svg class="w-4 h-4 ml-1" fill="currentColor" viewBox="0 0 20 20">
                                <path fill-rule="evenodd" d="M12.293 5.293a1 1 0 011.414 0l4 4a1 1 0 010 1.414l-4 4a1 1 0 01-1.414-1.414L14.586 11H3a1 1 0 110-2h11.586l-2.293-2.293a1 1 0 010-1.414z" clip-rule="evenodd"></path>
                            </svg>
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Cloud & Infrastructure -->
    <section class="py-16 bg-white dark:bg-gray-900">
        <div class="container mx-auto px-6 lg:px-8">
            <div class="grid grid-cols-1 lg:grid-cols-2 gap-12 items-center">
                <div class="order-2 lg:order-1">
                    <div class="mb-6">
                        <span class="inline-flex items-center px-4 py-2 rounded-full text-sm font-medium bg-blue-100 text-blue-800 dark:bg-blue-900 dark:text-blue-200">
                            Cloud Technology
                        </span>
                    </div>
                    <h2 class="text-3xl md:text-4xl font-bold text-gray-900 dark:text-white mb-6">
                        Secure, Scalable <span class="text-transparent bg-clip-text bg-gradient-to-r from-blue-600 to-cyan-400">Cloud Infrastructure</span>
                    </h2>
                    <p class="text-lg text-gray-600 dark:text-gray-300 mb-8">
                        Enterprise-grade cloud solutions designed for performance, security, and reliability. Our infrastructure supports mission-critical applications with 99.99% uptime.
                    </p>

                    <div class="grid grid-cols-2 gap-6">
                        <div class="bg-gray-50 dark:bg-gray-800 p-6 rounded-lg">
                            <div class="flex items-center mb-3">
                                <div class="flex-shrink-0 bg-blue-100 dark:bg-blue-900 rounded-lg p-2">
                                    <svg class="w-6 h-6 text-blue-600 dark:text-blue-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16m14 0h2m-2 0h-5m-9 0H3m2 0h5M9 7h1m-1 4h1m4-4h1m-1 4h1m-5 10v-5a1 1 0 011-1h2a1 1 0 011 1v5m-4 0h4"></path>
                                    </svg>
                                </div>
                                <h3 class="ml-3 text-lg font-semibold text-gray-900 dark:text-white">Private Cloud</h3>
                            </div>
                            <p class="text-gray-600 dark:text-gray-400">
                                Dedicated infrastructure for maximum security and control.
                            </p>
                        </div>

                        <div class="bg-gray-50 dark:bg-gray-800 p-6 rounded-lg">
                            <div class="flex items-center mb-3">
                                <div class="flex-shrink-0 bg-blue-100 dark:bg-blue-900 rounded-lg p-2">
                                    <svg class="w-6 h-6 text-blue-600 dark:text-blue-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 15a4 4 0 004 4h9a5 5 0 10-.1-9.999 5.002 5.002 0 10-9.78 2.096A4.001 4.001 0 003 15z"></path>
                                    </svg>
                                </div>
                                <h3 class="ml-3 text-lg font-semibold text-gray-900 dark:text-white">Hybrid Cloud</h3>
                            </div>
                            <p class="text-gray-600 dark:text-gray-400">
                                Flexible solutions combining public and private environments.
                            </p>
                        </div>

                        <div class="bg-gray-50 dark:bg-gray-800 p-6 rounded-lg">
                            <div class="flex items-center mb-3">
                                <div class="flex-shrink-0 bg-blue-100 dark:bg-blue-900 rounded-lg p-2">
                                    <svg class="w-6 h-6 text-blue-600 dark:text-blue-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 3v2m6-2v2M9 19v2m6-2v2M5 9H3m2 6H3m18-6h-2m2 6h-2M7 19h10a2 2 0 002-2V7a2 2 0 00-2-2H7a2 2 0 00-2 2v10a2 2 0 002 2zM9 9h6v6H9V9z"></path>
                                    </svg>
                                </div>
                                <h3 class="ml-3 text-lg font-semibold text-gray-900 dark:text-white">Managed Services</h3>
                            </div>
                            <p class="text-gray-600 dark:text-gray-400">
                                24/7 monitoring, maintenance, and support.
                            </p>
                        </div>

                        <div class="bg-gray-50 dark:bg-gray-800 p-6 rounded-lg">
                            <div class="flex items-center mb-3">
                                <div class="flex-shrink-0 bg-blue-100 dark:bg-blue-900 rounded-lg p-2">
                                    <svg class="w-6 h-6 text-blue-600 dark:text-blue-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 15v2m-6 4h12a2 2 0 002-2v-6a2 2 0 00-2-2H6a2 2 0 00-2 2v6a2 2 0 002 2zm10-10V7a4 4 0 00-8 0v4h8z"></path>
                                    </svg>
                                </div>
                                <h3 class="ml-3 text-lg font-semibold text-gray-900 dark:text-white">Security</h3>
                            </div>
                            <p class="text-gray-600 dark:text-gray-400">
                                Enterprise-grade security and compliance.
                            </p>
                        </div>
                    </div>
                </div>

                <div class="order-1 lg:order-2">
                    <div class="relative w-full h-full bg-gray-100 dark:bg-gray-800 rounded-2xl overflow-hidden shadow-xl">
                        <img src="<?php echo asset('images/content/cloud-infrastructure.jpg')?>" alt="Cloud Infrastructure" class="w-full h-auto object-cover">
                        <div class="absolute inset-0 bg-gradient-to-t from-blue-900/40 to-transparent"></div>
                        <div class="absolute bottom-0 left-0 right-0 p-6">
                            <div class="bg-white dark:bg-gray-900 rounded-lg p-6 shadow-lg">
                                <h3 class="text-xl font-bold text-gray-900 dark:text-white mb-2">Need Enterprise Hosting?</h3>
                                <p class="text-gray-600 dark:text-gray-300 mb-4">
                                    Our cloud experts can design the perfect infrastructure for your needs.
                                </p>
                                <a href="<?php echo url('/cloud'); ?>" class="inline-flex items-center justify-center px-6 py-3 border border-transparent text-base font-medium rounded-lg text-white bg-blue-600 hover:bg-blue-700 transition duration-300">
                                    Explore Cloud Solutions
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Case Studies / Success Stories -->
    <section class="py-16 bg-gray-50 dark:bg-gray-900">
        <div class="container mx-auto px-6 lg:px-8">
            <div class="text-center mb-12">
                <span class="inline-flex items-center px-4 py-2 rounded-full text-sm font-medium bg-blue-100 text-blue-800 dark:bg-blue-900 dark:text-blue-200">
                    Success Stories
                </span>
                <h2 class="mt-4 text-3xl md:text-4xl font-bold text-gray-900 dark:text-white">
                    Transforming Businesses <span class="text-transparent bg-clip-text bg-gradient-to-r from-blue-600 to-cyan-400">Across Industries</span>
                </h2>
                <p class="mt-4 text-lg text-gray-600 dark:text-gray-300 max-w-3xl mx-auto">
                    Discover how our solutions have helped enterprises achieve their digital transformation goals.
                </p>
            </div>

            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
                <div class="bg-white dark:bg-gray-800 rounded-xl shadow-md overflow-hidden hover:shadow-xl transition duration-300">
                    <div class="h-48 bg-[url('<?php echo asset('images/case-studies/finance-case-study.jpg')?>')] bg-cover bg-center"></div>
                    <div class="p-6">
                        <div class="flex items-center mb-3">
                            <span class="bg-blue-100 dark:bg-blue-900 text-blue-800 dark:text-blue-200 text-xs font-semibold px-2.5 py-0.5 rounded">Finance</span>
                        </div>
                        <h3 class="text-xl font-bold text-gray-900 dark:text-white mb-2">Global Bank Digital Transformation</h3>
                        <p class="text-gray-600 dark:text-gray-300 mb-4">
                            Implemented AI-powered fraud detection reducing incidents by 78% and saving $12M annually.
                        </p>
                        <a href="<?php echo url('/case-studies/finance'); ?>" class="inline-flex items-center text-blue-600 dark:text-blue-400 hover:underline">
                            Read case study
                            <svg class="w-4 h-4 ml-1" fill="currentColor" viewBox="0 0 20 20">
                                <path fill-rule="evenodd" d="M12.293 5.293a1 1 0 011.414 0l4 4a1 1 0 010 1.414l-4 4a1 1 0 01-1.414-1.414L14.586 11H3a1 1 0 110-2h11.586l-2.293-2.293a1 1 0 010-1.414z" clip-rule="evenodd"></path>
                            </svg>
                        </a>
                    </div>
                </div>

                <div class="bg-white dark:bg-gray-800 rounded-xl shadow-md overflow-hidden hover:shadow-xl transition duration-300">
                    <div class="h-48 bg-[url('<?php echo asset('images/case-studies/healthcare-case-study.jpg')?>')] bg-cover bg-center"></div>
                    <div class="p-6">
                        <div class="flex items-center mb-3">
                            <span class="bg-green-100 dark:bg-green-900 text-green-800 dark:text-green-200 text-xs font-semibold px-2.5 py-0.5 rounded">Healthcare</span>
                        </div>
                        <h3 class="text-xl font-bold text-gray-900 dark:text-white mb-2">Hospital System Optimization</h3>
                        <p class="text-gray-600 dark:text-gray-300 mb-4">
                            Custom patient management system reduced wait times by 45% and improved care coordination.
                        </p>
                        <a href="<?php echo url('/case-studies/healthcare'); ?>" class="inline-flex items-center text-blue-600 dark:text-blue-400 hover:underline">
                            Read case study
                            <svg class="w-4 h-4 ml-1" fill="currentColor" viewBox="0 0 20 20">
                                <path fill-rule="evenodd" d="M12.293 5.293a1 1 0 011.414 0l4 4a1 1 0 010 1.414l-4 4a1 1 0 01-1.414-1.414L14.586 11H3a1 1 0 110-2h11.586l-2.293-2.293a1 1 0 010-1.414z" clip-rule="evenodd"></path>
                            </svg>
                        </a>
                    </div>
                </div>

                <div class="bg-white dark:bg-gray-800 rounded-xl shadow-md overflow-hidden hover:shadow-xl transition duration-300">
                    <div class="h-48 bg-[url('<?php echo asset('images/case-studies/manufacturing-case-study.jpg')?>')] bg-cover bg-center"></div>
                    <div class="p-6">
                        <div class="flex items-center mb-3">
                            <span class="bg-yellow-100 dark:bg-yellow-900 text-yellow-800 dark:text-yellow-200 text-xs font-semibold px-2.5 py-0.5 rounded">Manufacturing</span>
                        </div>
                        <h3 class="text-xl font-bold text-gray-900 dark:text-white mb-2">Smart Factory Implementation</h3>
                        <p class="text-gray-600 dark:text-gray-300 mb-4">
                            IoT and AI integration increased production efficiency by 32% while reducing defects by 28%.
                        </p>
                        <a href="<?php echo url('/case-studies/manufacturing'); ?>" class="inline-flex items-center text-blue-600 dark:text-blue-400 hover:underline">
                            Read case study
                            <svg class="w-4 h-4 ml-1" fill="currentColor" viewBox="0 0 20 20">
                                <path fill-rule="evenodd" d="M12.293 5.293a1 1 0 011.414 0l4 4a1 1 0 010 1.414l-4 4a1 1 0 01-1.414-1.414L14.586 11H3a1 1 0 110-2h11.586l-2.293-2.293a1 1 0 010-1.414z" clip-rule="evenodd"></path>
                            </svg>
                        </a>
                    </div>
                </div>
            </div>

            <div class="mt-12 text-center">
                <a href="<?php echo url('/case-studies'); ?>" class="inline-flex items-center justify-center px-8 py-3 border border-transparent text-base font-medium rounded-lg text-white bg-blue-600 hover:bg-blue-700 transition duration-300 shadow-lg hover:shadow-xl">
                    View All Case Studies
                </a>
            </div>
        </div>
    </section>

    <!-- Testimonials -->
    <section class="py-16 bg-white dark:bg-gray-900">
        <div class="container mx-auto px-6 lg:px-8">
            <div class="text-center mb-12">
                <span class="inline-flex items-center px-4 py-2 rounded-full text-sm font-medium bg-blue-100 text-blue-800 dark:bg-blue-900 dark:text-blue-200">
                    Client Testimonials
                </span>
                <h2 class="mt-4 text-3xl md:text-4xl font-bold text-gray-900 dark:text-white">
                    What Our <span class="text-transparent bg-clip-text bg-gradient-to-r from-blue-600 to-cyan-400">Clients Say</span>
                </h2>
            </div>

            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
                <div class="bg-gray-50 dark:bg-gray-800 p-8 rounded-xl">
                    <div class="flex items-center mb-4">
                        <svg class="w-5 h-5 text-yellow-400" fill="currentColor" viewBox="0 0 20 20">
                            <path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"></path>
                        </svg>
                        <svg class="w-5 h-5 text-yellow-400" fill="currentColor" viewBox="0 0 20 20">
                            <path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"></path>
                        </svg>
                        <svg class="w-5 h-5 text-yellow-400" fill="currentColor" viewBox="0 0 20 20">
                            <path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"></path>
                        </svg>
                        <svg class="w-5 h-5 text-yellow-400" fill="currentColor" viewBox="0 0 20 20">
                            <path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"></path>
                        </svg>
                        <svg class="w-5 h-5 text-yellow-400" fill="currentColor" viewBox="0 0 20 20">
                            <path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"></path>
                        </svg>
                    </div>
                    <blockquote class="text-lg text-gray-600 dark:text-gray-300 mb-6">
                        "Datanito's AI solutions transformed our customer service operations, reducing response times by 65% while improving satisfaction scores. Their team's expertise was evident throughout the engagement."
                    </blockquote>
                    <div class="flex items-center">
                        <img class="w-12 h-12 rounded-full mr-4" src="<?php echo asset('images/testimonials/testimonial-1.jpg')?>" alt="Sarah Johnson">
                        <div>
                            <div class="font-semibold text-gray-900 dark:text-white">Sarah Johnson</div>
                            <div class="text-gray-500 dark:text-gray-400">CTO, Financial Services Inc.</div>
                        </div>
                    </div>
                </div>

                <div class="bg-gray-50 dark:bg-gray-800 p-8 rounded-xl">
                    <div class="flex items-center mb-4">
                        <svg class="w-5 h-5 text-yellow-400" fill="currentColor" viewBox="0 0 20 20">
                            <path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"></path>
                        </svg>
                        <svg class="w-5 h-5 text-yellow-400" fill="currentColor" viewBox="0 0 20 20">
                            <path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"></path>
                        </svg>
                        <svg class="w-5 h-5 text-yellow-400" fill="currentColor" viewBox="0 0 20 20">
                            <path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"></path>
                        </svg>
                        <svg class="w-5 h-5 text-yellow-400" fill="currentColor" viewBox="0 0 20 20">
                            <path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"></path>
                        </svg>
                        <svg class="w-5 h-5 text-yellow-400" fill="currentColor" viewBox="0 0 20 20">
                            <path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"></path>
                        </svg>
                    </div>
                    <blockquote class="text-lg text-gray-600 dark:text-gray-300 mb-6">
                        "The custom ERP system Datanito developed has streamlined our operations across 14 countries. Their understanding of global business needs is unparalleled."
                    </blockquote>
                    <div class="flex items-center">
                        <img class="w-12 h-12 rounded-full mr-4" src="<?php echo asset('images/testimonials/testimonial-2.jpg')?>" alt="Michael Chen">
                        <div>
                            <div class="font-semibold text-gray-900 dark:text-white">Michael Chen</div>
                            <div class="text-gray-500 dark:text-gray-400">Global Operations Director, Manufacturing Corp</div>
                        </div>
                    </div>
                </div>

                <div class="bg-gray-50 dark:bg-gray-800 p-8 rounded-xl">
                    <div class="flex items-center mb-4">
                        <svg class="w-5 h-5 text-yellow-400" fill="currentColor" viewBox="0 0 20 20">
                            <path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"></path>
                        </svg>
                        <svg class="w-5 h-5 text-yellow-400" fill="currentColor" viewBox="0 0 20 20">
                            <path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"></path>
                        </svg>
                        <svg class="w-5 h-5 text-yellow-400" fill="currentColor" viewBox="0 0 20 20">
                            <path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"></path>
                        </svg>
                        <svg class="w-5 h-5 text-yellow-400" fill="currentColor" viewBox="0 0 20 20">
                            <path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"></path>
                        </svg>
                        <svg class="w-5 h-5 text-yellow-400" fill="currentColor" viewBox="0 0 20 20">
                            <path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"></path>
                        </svg>
                    </div>
                    <blockquote class="text-lg text-gray-600 dark:text-gray-300 mb-6">
                        "Datanito's cloud migration strategy saved us $350K annually in infrastructure costs while improving performance. Their team is truly enterprise-grade."
                    </blockquote>
                    <div class="flex items-center">
                        <img class="w-12 h-12 rounded-full mr-4" src="<?php echo asset('images/testimonials/testimonial-3.jpg')?>" alt="David Rodriguez">
                        <div>
                            <div class="font-semibold text-gray-900 dark:text-white">David Rodriguez</div>
                            <div class="text-gray-500 dark:text-gray-400">CIO, Retail Chain International</div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- CTA Section -->
    <section class="py-16 bg-gradient-to-r from-blue-800 to-blue-600 dark:from-gray-900 dark:to-gray-800">
        <div class="container mx-auto px-6 lg:px-8 text-center">
            <h2 class="text-3xl md:text-4xl font-bold text-white mb-6">
                Ready to Transform Your Business with Technology?
            </h2>
            <p class="text-xl text-blue-100 dark:text-blue-200 mb-8 max-w-3xl mx-auto">
                Our team of experts is ready to help you harness the power of AI and software to drive innovation and growth.
            </p>
            <div class="flex flex-col sm:flex-row gap-4 justify-center">
                <a href="<?php echo url('/contact'); ?>" class="inline-flex items-center justify-center px-8 py-4 border border-transparent text-base font-medium rounded-lg text-blue-900 bg-white hover:bg-blue-50 transition duration-300 shadow-lg hover:shadow-xl">
                    Get Started
                </a>
                <a href="<?php echo url('/solutions'); ?>" class="inline-flex items-center justify-center px-8 py-4 border border-transparent text-base font-medium rounded-lg text-white bg-blue-600 bg-opacity-20 hover:bg-opacity-30 transition duration-300 border border-white/20">
                    Explore Solutions
                </a>
            </div>
        </div>
    </section>
</div>

<?php
include_once includes('layouts/footer.php');
?>