<?php
$meta = array(
    'us' => array(
        'title' => 'Transfer Your Domain: Move to Datanito for a Smooth Transition',
        'description' => 'Experience hassle-free domain transfer services at Datanito. Seamlessly migrate your domain to us and enjoy our exceptional features.',
        'og:title' => 'Transfer Your Domain: Move to Datanito for a Smooth Transition',
        'og:description' => 'Experience hassle-free domain transfer services at Datanito. Seamlessly migrate your domain to us and enjoy our exceptional features.',
        'og:image' => asset('images/brand/open_graph_logo.png'),
    ),
    'tr' => array(
        'title' => 'Alan Adınızı Transfer Edin: Datanito\'ya Sorunsuz Geçiş Yapın',
        'description' => 'Datanito\'da zahmetsiz alan adı transfer hizmetinin tadını çıkarın. Alan adınızı sorunsuz bir şekilde bize taşıyın ve olağanüstü özelliklerimizin keyfini çıkarın.',
        'og:title' => 'Alan Adınızı Transfer Edin: Datanito\'ya Sorunsuz Geçiş Yapın',
        'og:description' => 'Datanito\'da zahmetsiz alan adı transfer hizmetinin tadını çıkarın. Alan adınızı sorunsuz bir şekilde bize taşıyın ve olağanüstü özelliklerimizin keyfini çıkarın.',
        'og:image' => asset('images/brand/open_graph_logo.png'),
    ),
);
$currentMeta = setCountryAndMeta($meta);
include_once includes('layouts/header.php');
?>
    <div id="content" class="container mx-auto lg:mt-12 mt-12">
        <section class="bg-gray-50 dark:bg-dark-800 mt-4 sm:h-[30em] overflow-hidden skeleton">
            <div class="py-6 px-4 mx-auto max-w-screen-xl text-center pb-0 lg:pt-12 lg:px-4 overflow-hidden">
                <h1 class="text-gray-900 mb-4 text-sm font-semibold dark:text-gray-400"><?php echo $lang['domain-transfer-superior'] ?></h1>
                <h2 class="mb-2 text-4xl tracking-tight font-bold text-gray-900 dark:text-white"><?php echo $lang['domain-transfer-headline']; ?></h2>
                <div class="mb-3">
                    <h3 class="text-xl tracking-tight font-medium text-gray-700 dark:text-gray-300"><?php echo $lang['domain-transfer-subheading']; ?></h3>
                </div>
                <div class="sm:mx-auto max-w-screen-md mt-36 mb-2">

                    <div class="relative">
                        <div class="absolute inset-y-0 left-0 flex items-center pl-3 pointer-events-none">
                            <svg class="w-4 h-4 text-gray-500 dark:text-gray-400" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 20 20">
                                <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="m19 19-4-4m0-7A7 7 0 1 1 1 8a7 7 0 0 1 14 0Z"/>
                            </svg>
                        </div>
                        <form id="domainTransferForm">
                            <input type="search" id="userInput" class="block w-full p-4 pl-10 text-sm text-gray-900 border border-gray-300 rounded-full bg-gray-100 focus:ring-blue-500 focus:border-blue-500 dark:bg-dark-700 dark:border-dark-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500" placeholder="<?php echo $lang['domain-transfer-search-placeholder']?>" value="<?php echo $domain;?>" required>
                            <button type="submit" id="checkButton" class="text-white absolute right-2.5 bottom-2.5 bg-dark-700 hover:bg-dark-800 focus:ring-4 focus:outline-none focus:ring-dark-300 font-medium rounded-3xl text-sm p-2 dark:bg-dark-500 dark:hover:bg-dark-600 dark:focus:ring-dark-800">
                                <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 20 20" xmlns="http://www.w3.org/2000/svg"> <path fill-rule="evenodd" d="M10.293 3.293a1 1 0 011.414 0l6 6a1 1 0 010 1.414l-6 6a1 1 0 01-1.414-1.414L14.586 11H3a1 1 0 110-2h11.586l-4.293-4.293a1 1 0 010-1.414z" clip-rule="evenodd"></path> </svg>
                            </button>
                        </form>
                    </div>

                </div>
            </div>
        </section>


        <section id="domain-transfer-stepper" class="bg-white dark:bg-dark-900 hidden sm:mt-6 mb-0">
            <div class="mx-auto max-w-screen-xl">
                <div class="flex p-4 md:p-0 pt-8 flex items-center">

                    <div class="block sm:flex space-x-8">
                        <div class="overflow-hidden bg-gray-50 dark:bg-dark-800 p-8 sm:p-12 border border-gray-200 dark:border-gray-700 rounded-3xl w-full sm:w-[73%] !mx-auto skeleton">
                            <h2 class="text-gray-600 dark:text-white text-lg md:text-xl font-medium mb-6">Transfer "<span class="transfer-domain"></span>" to Datanito Domains</h2>
                            <ol class="relative text-gray-500 border-l border-gray-200 dark:border-gray-700 dark:text-gray-400">
                                <li class="mb-10 ml-6">
                                    <span class="stepper-icon-area absolute flex items-center justify-center w-8 h-8 bg-gray-100 rounded-full -left-4 ring-4 ring-white dark:ring-gray-900 dark:bg-gray-700">
                                        <span class="stepper-icon material-symbols-outlined text-[18px] text-gray-500 dark:text-gray-400">fingerprint</span>
                                    </span>
                                    <h3 class="font-medium leading-tight text-gray-500 dark:text-gray-200 mb-6 pt-1.5">Prepare domain</h3>
                                    <div class="steps hidden">
                                        <p class="text-[16px] font-normal text-gray-500 dark:text-gray-400">Transfer this domain to Datanito Domains for an additional year at <span class="domain-transfer-cost"></span>.</p>
                                        <div class="my-8">
                                            <div class="flex justify-between space-x-2 sm:space-x-8">
                                                <div class="relative w-full">
                                                    <input type="text" id="eppcode" class="block p-4 w-full text-sm text-gray-900 bg-transparent rounded-xl border-1 border-gray-300 appearance-none dark:text-white dark:border-gray-600 dark:focus:border-blue-500 focus:outline-none focus:ring-0 focus:border-blue-600 peer" placeholder=" " />
                                                    <label for="eppcode" class="absolute text-sm text-gray-500 dark:text-gray-400 duration-300 transform -translate-y-4 scale-75 top-2 z-10 origin-[0] bg-gray-50 dark:bg-dark-800 px-2 peer-focus:px-2 peer-focus:text-blue-600 peer-focus:dark:text-blue-500 peer-placeholder-shown:scale-100 peer-placeholder-shown:-translate-y-1/2 peer-placeholder-shown:top-1/2 peer-focus:top-2 peer-focus:scale-75 peer-focus:-translate-y-4 left-1">Enter authorization code</label>
                                                </div>

                                                <button data-popover-target="epp-code-help" type="button" class="text-white font-medium rounded-xl text-sm text-center"><svg class='w-4 h-4 text-gray-400 hover:text-gray-500' aria-hidden='true' fill='currentColor' viewBox='0 0 20 20' xmlns='http://www.w3.org/2000/svg'><path fill-rule='evenodd' d='M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-8-3a1 1 0 00-.867.5 1 1 0 11-1.731-1A3 3 0 0113 8a3.001 3.001 0 01-2 2.83V11a1 1 0 11-2 0v-1a1 1 0 011-1 1 1 0 100-2zm0 8a1 1 0 100-2 1 1 0 000 2z' clip-rule='evenodd'></path></svg><span class='sr-only'>Show Information</span></button>
                                            </div>
                                            <div data-popover id="epp-code-help" role="tooltip" class="absolute z-10 invisible inline-block w-64 text-sm text-gray-500 transition-opacity duration-300 bg-white border border-gray-200 rounded-xl shadow-sm opacity-0 dark:text-gray-400 dark:border-gray-600 dark:bg-dark-800">
                                                <div class="px-3 py-2 bg-gray-100 border-b border-gray-200 rounded-t-lg dark:border-gray-600 dark:bg-dark-700">
                                                    <h3 class="font-semibold text-gray-900 dark:text-white">EPP Code</h3>
                                                </div>
                                                <div class="px-3 py-2">
                                                    <p>Often called an authorization code, transfer code, or EPP code.</p>
                                                </div>
                                                <div data-popper-arrow></div>
                                            </div>

                                        </div>
                                        <button type="submit" id="checkoutButton" class="text-white bg-blue-700 hover:bg-blue-800 focus:ring-4 focus:outline-none focus:ring-blue-300 font-medium rounded-xl text-sm px-4 py-2 dark:bg-blue-600 dark:hover:bg-blue-700 dark:focus:ring-blue-800">Continue</button>

                                    </div>
                                </li>
                                <li class="mb-10 ml-6">
                                    <span class="stepper-icon-area absolute flex items-center justify-center w-8 h-8 bg-gray-100 rounded-full -left-4 ring-4 ring-white dark:ring-gray-900 dark:bg-gray-700">
                                        <span class="stepper-icon material-symbols-outlined text-[18px] text-gray-500 dark:text-gray-400">settings</span>
                                    </span>
                                    <h3 class="font-medium leading-tight text-gray-500 dark:text-gray-200 mb-6 pt-1.5">Import web settings</h3>
                                    <div class="steps hidden">
                                        <p class="text-[16px] font-normal text-gray-500 dark:text-gray-400">Nameservers</p>
                                        <div class="my-8 space-y-4 sm:space-y-0">
                                            <div class="block sm:flex justify-between sm:space-x-8 space-y-4 sm:space-y-0">
                                                <div class="relative w-full">
                                                    <input type="text" id="nameserver-1" class="block p-4 w-full text-sm text-gray-900 bg-transparent rounded-xl border-1 border-gray-300 appearance-none dark:text-white dark:border-gray-600 dark:focus:border-blue-500 focus:outline-none focus:ring-0 focus:border-blue-600 peer" placeholder=" " value="ns1.datanito.com"/>
                                                    <label for="nameserver-1" class="absolute text-sm text-gray-500 dark:text-gray-400 duration-300 transform -translate-y-4 scale-75 top-2 z-10 origin-[0] bg-gray-50 dark:bg-dark-800 px-2 peer-focus:px-2 peer-focus:text-blue-600 peer-focus:dark:text-blue-500 peer-placeholder-shown:scale-100 peer-placeholder-shown:-translate-y-1/2 peer-placeholder-shown:top-1/2 peer-focus:top-2 peer-focus:scale-75 peer-focus:-translate-y-4 left-1">Nameserver 1</label>
                                                </div>
                                                <div class="relative w-full">
                                                    <input type="text" id="nameserver-2" class="block p-4 w-full text-sm text-gray-900 bg-transparent rounded-xl border-1 border-gray-300 appearance-none dark:text-white dark:border-gray-600 dark:focus:border-blue-500 focus:outline-none focus:ring-0 focus:border-blue-600 peer" placeholder=" " value="ns2.datanito.com"/>
                                                    <label for="nameserver-2" class="absolute text-sm text-gray-500 dark:text-gray-400 duration-300 transform -translate-y-4 scale-75 top-2 z-10 origin-[0] bg-gray-50 dark:bg-dark-800 px-2 peer-focus:px-2 peer-focus:text-blue-600 peer-focus:dark:text-blue-500 peer-placeholder-shown:scale-100 peer-placeholder-shown:-translate-y-1/2 peer-placeholder-shown:top-1/2 peer-focus:top-2 peer-focus:scale-75 peer-focus:-translate-y-4 left-1">Nameserver 2</label>
                                                </div>
                                            </div>
                                            <div class="block sm:flex justify-between sm:space-x-8 space-y-4 sm:space-y-0">
                                                <div class="relative w-full">
                                                    <input type="text" id="nameserver-3" class="block p-4 w-full text-sm text-gray-900 bg-transparent rounded-xl border-1 border-gray-300 appearance-none dark:text-white dark:border-gray-600 dark:focus:border-blue-500 focus:outline-none focus:ring-0 focus:border-blue-600 peer" placeholder=" " />
                                                    <label for="nameserver-3" class="absolute text-sm text-gray-500 dark:text-gray-400 duration-300 transform -translate-y-4 scale-75 top-2 z-10 origin-[0] bg-gray-50 dark:bg-dark-800 px-2 peer-focus:px-2 peer-focus:text-blue-600 peer-focus:dark:text-blue-500 peer-placeholder-shown:scale-100 peer-placeholder-shown:-translate-y-1/2 peer-placeholder-shown:top-1/2 peer-focus:top-2 peer-focus:scale-75 peer-focus:-translate-y-4 left-1">Nameserver 3</label>
                                                </div>
                                                <div class="relative w-full">
                                                    <input type="text" id="nameserver-4" class="block p-4 w-full text-sm text-gray-900 bg-transparent rounded-xl border-1 border-gray-300 appearance-none dark:text-white dark:border-gray-600 dark:focus:border-blue-500 focus:outline-none focus:ring-0 focus:border-blue-600 peer" placeholder=" " />
                                                    <label for="nameserver-4" class="absolute text-sm text-gray-500 dark:text-gray-400 duration-300 transform -translate-y-4 scale-75 top-2 z-10 origin-[0] bg-gray-50 dark:bg-dark-800 px-2 peer-focus:px-2 peer-focus:text-blue-600 peer-focus:dark:text-blue-500 peer-placeholder-shown:scale-100 peer-placeholder-shown:-translate-y-1/2 peer-placeholder-shown:top-1/2 peer-focus:top-2 peer-focus:scale-75 peer-focus:-translate-y-4 left-1">Nameserver 4</label>
                                                </div>
                                            </div>
                                            <div class="block sm:flex justify-between sm:space-x-8 space-y-4 sm:space-y-0">
                                                <div class="relative w-full">
                                                    <input type="text" id="nameserver-5" class="block p-4 w-full text-sm text-gray-900 bg-transparent rounded-xl border-1 border-gray-300 appearance-none dark:text-white dark:border-gray-600 dark:focus:border-blue-500 focus:outline-none focus:ring-0 focus:border-blue-600 peer" placeholder=" " />
                                                    <label for="nameserver-5" class="absolute text-sm text-gray-500 dark:text-gray-400 duration-300 transform -translate-y-4 scale-75 top-2 z-10 origin-[0] bg-gray-50 dark:bg-dark-800 px-2 peer-focus:px-2 peer-focus:text-blue-600 peer-focus:dark:text-blue-500 peer-placeholder-shown:scale-100 peer-placeholder-shown:-translate-y-1/2 peer-placeholder-shown:top-1/2 peer-focus:top-2 peer-focus:scale-75 peer-focus:-translate-y-4 left-1">Nameserver 5</label>
                                                </div>
                                                <div class="w-full"></div>
                                            </div>

                                        </div>
                                        <button type="submit" id="checkButton" class="text-white bg-blue-700 hover:bg-blue-800 focus:ring-4 focus:outline-none focus:ring-blue-300 font-medium rounded-xl text-sm px-4 py-2 dark:bg-blue-600 dark:hover:bg-blue-700 dark:focus:ring-blue-800">Continue</button>

                                    </div>
                                </li>
                                <li class="ml-6">
                                    <span class="stepper-icon-area absolute flex items-center justify-center w-8 h-8 bg-gray-100 rounded-full -left-4 ring-4 ring-white dark:ring-gray-900 dark:bg-gray-700">
                                         <span class="stepper-icon material-symbols-outlined text-[18px] text-gray-500 dark:text-gray-400">published_with_changes</span>
                                    </span>
                                    <h3 class="font-medium leading-tight text-gray-500 dark:text-gray-200 mb-6 pt-1.5">Confirmation</h3>
                                    <div class="steps hidden">
                                        <p class="text-[16px] font-normal text-gray-500 dark:text-gray-400">Transfer this domain to Datanito Domains for an additional year at <span class="domain-transfer-cost"></span>.</p>
                                        <button type="submit" id="checkButton" class="text-white mt-8 bg-blue-700 hover:bg-blue-800 focus:ring-4 focus:outline-none focus:ring-blue-300 font-medium rounded-xl text-sm px-4 py-2 dark:bg-blue-600 dark:hover:bg-blue-700 dark:focus:ring-blue-800">Add to cart</button>
                                    </div>
                                </li>
                            </ol>

                        </div>
                        <div class="flex overflow-hidden bg-gray-50 dark:bg-dark-800 p-6 border border-gray-200 dark:border-gray-700 rounded-3xl w-full sm:w-[25%] mt-8 sm:mt-0 !mx-auto skeleton">
                            <div class="text-center space-y-6 w-[95%] mx-auto">
                                <div class="flex justify-center">
                                    <span class="material-symbols-outlined text-9xl text-gray-200 dark:text-dark-600">move_up</span>
                                </div>
                                <div>
                                    <h4 class="text-sm text-gray-700 dark:text-gray-300 font-semibold">Privacy protection included</h4>
                                    <p class="text-sm text-gray-500 dark:text-gray-400 font-normal">Datanito Domains covers the cost of keeping your details private.</p>
                                </div>
                                <hr class="border-gray-200 mx-auto w-36 dark:border-dark-600" />
                                <div>
                                    <h4 class="text-sm text-gray-700 dark:text-gray-300 font-semibold">Custom email & webhosting</h4>
                                    <p class="text-sm text-gray-500 dark:text-gray-400 font-normal">Get custom email through Datanito Cloud. Take your pick from several third-party webhosting providers.</p>
                                </div>
                                <hr class="border-gray-200 mx-auto w-36 dark:border-dark-600" />
                                <div>
                                    <h4 class="text-sm text-gray-700 dark:text-gray-300 font-semibold">Questions about transfer?</h4>
                                    <p class="text-sm text-gray-500 dark:text-gray-400 font-normal mb-4">Contact us 24/7 for expert assistance with your transfer questions.</p>
                                    <a href="" class="text-gray-900 bg-gray-100 border border-gray-300 focus:outline-none hover:bg-gray-100 focus:ring-4 focus:ring-gray-200 font-medium rounded-xl text-sm px-5 py-2.5 mr-2 mb-2 mt-6 dark:bg-dark-800 dark:text-white dark:border-dark-600 dark:hover:bg-dark-700 dark:hover:border-dark-600 dark:focus:ring-dark-700">Get Expert Assistance</a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>

        <section class="bg-white dark:bg-dark-900 mb-12 overflow-hidden min-h-36">
            <div class="mx-auto text-center overflow-hidden">
                <div class="sm:mx-auto">
                    <div class="flex mx-auto justify-center items-center w-full my-7 sm:my-6 max-w-screen-md">
                        <ol class="flex items-center w-full mt-12">
                            <li class="flex w-full items-center text-gray-600 dark:text-gray-200 after:content-[''] after:w-full after:h-1 after:border-b after:border-gray-100 after:border-4 after:inline-block dark:after:border-gray-700 before:content-[''] before:w-14 before:h-1 before:border-b before:border-gray-100 before:border-4 before:inline-block dark:before:border-gray-700">
                                <div class="relative">
                                    <div class="flex items-center justify-center w-10 h-10 bg-gray-100 rounded-full lg:h-12 lg:w-12 dark:bg-dark-700 shrink-0">
                                        <svg class="w-4 h-4 text-gray-600 lg:w-6 lg:h-6 dark:text-gray-300" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="currentColor" viewBox="0 0 20 16">
                                            <path d="M18 0H2a2 2 0 0 0-2 2v12a2 2 0 0 0 2 2h16a2 2 0 0 0 2-2V2a2 2 0 0 0-2-2ZM6.5 3a2.5 2.5 0 1 1 0 5 2.5 2.5 0 0 1 0-5ZM3.014 13.021l.157-.625A3.427 3.427 0 0 1 6.5 9.571a3.426 3.426 0 0 1 3.322 2.805l.159.622-6.967.023ZM16 12h-3a1 1 0 0 1 0-2h3a1 1 0 0 1 0 2Zm0-3h-3a1 1 0 1 1 0-2h3a1 1 0 1 1 0 2Zm0-3h-3a1 1 0 1 1 0-2h3a1 1 0 1 1 0 2Z"/>
                                        </svg>
                                    </div>
                                    <p class="absolute left-[-4.5em] mt-1 text-sm w-44"><?php echo $lang['domain-transfer-first-step'] ?></p>
                                </div>
                            </li>
                            <li class="flex w-full items-center text-gray-600 dark:text-gray-200 after:content-[''] after:w-full after:h-1 after:border-b after:border-gray-100 after:border-4 after:inline-block dark:after:border-gray-700 before:content-[''] before:w-14 before:h-1 before:border-b before:border-gray-100 before:border-4 before:inline-block dark:before:border-gray-700">
                                <div class="relative">
                                    <div class="flex items-center justify-center w-10 h-10 bg-gray-100 rounded-full lg:h-12 lg:w-12 dark:bg-dark-700 shrink-0">
                                        <svg class="w-4 h-4 text-gray-600 lg:w-6 lg:h-6 dark:text-gray-300" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="currentColor" viewBox="0 0 20 14">
                                            <path d="M18 0H2a2 2 0 0 0-2 2v10a2 2 0 0 0 2 2h16a2 2 0 0 0 2-2V2a2 2 0 0 0-2-2ZM2 12V6h16v6H2Z"/>
                                            <path d="M6 8H4a1 1 0 0 0 0 2h2a1 1 0 0 0 0-2Zm8 0H9a1 1 0 0 0 0 2h5a1 1 0 1 0 0-2Z"/>
                                        </svg>
                                    </div>
                                    <p class="absolute left-[-4.5em] mt-1 text-sm w-44"><?php echo $lang['domain-transfer-second-step'] ?></p>
                                </div>
                            </li>
                            <li class="flex w-full items-center text-gray-600 dark:text-gray-200 after:content-[''] after:w-full after:h-1 after:border-b after:border-gray-100 after:border-4 after:inline-block dark:after:border-gray-700 before:content-[''] before:w-14 before:h-1 before:border-b before:border-gray-100 before:border-4 before:inline-block dark:before:border-gray-700">
                                <div class="relative">
                                    <div class="flex items-center justify-center w-10 h-10 bg-gray-100 rounded-full lg:h-12 lg:w-12 dark:bg-dark-700 shrink-0">
                                        <svg class="w-4 h-4 text-gray-600 lg:w-6 lg:h-6 dark:text-gray-300" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="currentColor" viewBox="0 0 20 14">
                                            <path d="M18 0H2a2 2 0 0 0-2 2v10a2 2 0 0 0 2 2h16a2 2 0 0 0 2-2V2a2 2 0 0 0-2-2ZM2 12V6h16v6H2Z"/>
                                            <path d="M6 8H4a1 1 0 0 0 0 2h2a1 1 0 0 0 0-2Zm8 0H9a1 1 0 0 0 0 2h5a1 1 0 1 0 0-2Z"/>
                                        </svg>
                                    </div>
                                    <p class="absolute left-[-4.5em] mt-1 text-sm w-44"><?php echo $lang['domain-transfer-third-step'] ?></p>
                                </div>
                            </li>
                            <li class="flex items-center after:content-[''] after:w-14 after:h-1 after:border-b after:border-gray-100 after:border-4 after:inline-block dark:after:border-gray-700 before:content-[''] before:w-10 before:h-1 before:border-b before:border-gray-100 before:border-4 before:inline-block dark:before:border-gray-700">
                                <div class="relative">
                                    <div class="flex items-center text-gray-600 dark:text-gray-200 justify-center w-10 h-10 bg-gray-100 rounded-full lg:h-12 lg:w-12 dark:bg-dark-700 shrink-0">
                                        <svg class="w-4 h-4 text-gray-600 lg:w-6 lg:h-6 dark:text-gray-300" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="currentColor" viewBox="0 0 18 20">
                                            <path d="M16 1h-3.278A1.992 1.992 0 0 0 11 0H7a1.993 1.993 0 0 0-1.722 1H2a2 2 0 0 0-2 2v15a2 2 0 0 0 2 2h14a2 2 0 0 0 2-2V3a2 2 0 0 0-2-2ZM7 2h4v3H7V2Zm5.7 8.289-3.975 3.857a1 1 0 0 1-1.393 0L5.3 12.182a1.002 1.002 0 1 1 1.4-1.436l1.328 1.289 3.28-3.181a1 1 0 1 1 1.392 1.435Z"/>
                                        </svg>
                                    </div>
                                    <p class="absolute left-[-4.5em] mt-1 text-sm w-44"><?php echo $lang['domain-transfer-fourth-step'] ?></p>
                                </div>
                            </li>
                        </ol>
                    </div>
                </div>
            </div>
        </section>
                <section id="features" class="bg-white dark:bg-dark-900">
            <div class="mx-auto max-w-screen-md">
                <div class="flex p-4 md:p-0 pt-8 flex items-center">
                    <div class="space-y-8 w-full">
                        <div class="flex items-center justify-center text-center bg-gray-50 dark:bg-dark-800 border border-gray-200 dark:border-gray-700 rounded-3xl p-8 md:p-6 md:min-h-80 skeleton">
                            <div class="text-center">
                                <h2 class="text-gray-600 dark:text-white text-xl md:text-2xl font-bold mb-2"><?php echo $lang['why-domain-transfer-headline'] ?></h2>
                                <div class="flex-1 flex flex-col justify-between items-start gap-4">
                                    <p class="text-lg font-normal text-gray-600 dark:text-gray-300"><?php echo $lang['why-domain-transfer-subheading'] ?></p>
                                </div>
                                <div class="flex justify-center mt-3">
                                    <div class="grid grid-cols-1 md:grid-cols-2 md:space-x-8">
                                        <ul class="space-y-2 text-gray-500 list-inside dark:text-gray-400 mt-1.5 sm:mt-3">
                                            <li class="flex items-center text-gray-600 dark:text-gray-300">
                                                <svg class="w-3.5 h-3.5 mr-2 text-green-500 dark:text-green-400 flex-shrink-0" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="currentColor" viewBox="0 0 20 20">
                                                    <path d="M10 .5a9.5 9.5 0 1 0 9.5 9.5A9.51 9.51 0 0 0 10 .5Zm3.707 8.207-4 4a1 1 0 0 1-1.414 0l-2-2a1 1 0 0 1 1.414-1.414L9 10.586l3.293-3.293a1 1 0 0 1 1.414 1.414Z"/>
                                                </svg>
                                                <?php echo $lang['domain-transfer-wide-range-of-extensions'] ?>
                                            </li>
                                            <li class="flex items-center text-gray-600 dark:text-gray-300">
                                                <svg class="w-3.5 h-3.5 mr-2 text-green-500 dark:text-green-400 flex-shrink-0" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="currentColor" viewBox="0 0 20 20">
                                                    <path d="M10 .5a9.5 9.5 0 1 0 9.5 9.5A9.51 9.51 0 0 0 10 .5Zm3.707 8.207-4 4a1 1 0 0 1-1.414 0l-2-2a1 1 0 0 1 1.414-1.414L9 10.586l3.293-3.293a1 1 0 0 1 1.414 1.414Z"/>
                                                </svg>
                                                <?php echo $lang['domain-transfer-secure-your-brand'] ?>
                                            </li>
                                            <li class="flex items-center text-gray-600 dark:text-gray-300">
                                                <svg class="w-3.5 h-3.5 mr-2 text-green-500 dark:text-green-400 flex-shrink-0" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="currentColor" viewBox="0 0 20 20">
                                                    <path d="M10 .5a9.5 9.5 0 1 0 9.5 9.5A9.51 9.51 0 0 0 10 .5Zm3.707 8.207-4 4a1 1 0 0 1-1.414 0l-2-2a1 1 0 0 1 1.414-1.414L9 10.586l3.293-3.293a1 1 0 0 1 1.414 1.414Z"/>
                                                </svg>
                                                <?php echo $lang['domain-transfer-memorable-online-identity'] ?>
                                            </li>
                                            <li class="flex items-center text-gray-600 dark:text-gray-300">
                                                <svg class="w-3.5 h-3.5 mr-2 text-green-500 dark:text-green-400 flex-shrink-0" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="currentColor" viewBox="0 0 20 20">
                                                    <path d="M10 .5a9.5 9.5 0 1 0 9.5 9.5A9.51 9.51 0 0 0 10 .5Zm3.707 8.207-4 4a1 1 0 0 1-1.414 0l-2-2a1 1 0 0 1 1.414-1.414L9 10.586l3.293-3.293a1 1 0 0 1 1.414 1.414Z"/>
                                                </svg>
                                                <?php echo $lang['domain-transfer-email-personalization'] ?>
                                            </li>
                                        </ul>
                                        <ul class="max-w-md space-y-2 text-gray-500 list-inside dark:text-gray-400 mt-1.5 sm:mt-3">
                                            <li class="flex items-center text-gray-600 dark:text-gray-300">
                                                <svg class="w-3.5 h-3.5 mr-2 text-green-500 dark:text-green-400 flex-shrink-0" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="currentColor" viewBox="0 0 20 20">
                                                    <path d="M10 .5a9.5 9.5 0 1 0 9.5 9.5A9.51 9.51 0 0 0 10 .5Zm3.707 8.207-4 4a1 1 0 0 1-1.414 0l-2-2a1 1 0 0 1 1.414-1.414L9 10.586l3.293-3.293a1 1 0 0 1 1.414 1.414Z"/>
                                                </svg>
                                                <?php echo $lang['domain-transfer-competitive-pricing'] ?>
                                            </li>
                                            <li class="flex items-center text-gray-600 dark:text-gray-300">
                                                <svg class="w-3.5 h-3.5 mr-2 text-green-500 dark:text-green-400 flex-shrink-0" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="currentColor" viewBox="0 0 20 20">
                                                    <path d="M10 .5a9.5 9.5 0 1 0 9.5 9.5A9.51 9.51 0 0 0 10 .5Zm3.707 8.207-4 4a1 1 0 0 1-1.414 0l-2-2a1 1 0 0 1 1.414-1.414L9 10.586l3.293-3.293a1 1 0 0 1 1.414 1.414Z"/>
                                                </svg>
                                                <?php echo $lang['domain-transfer-enhance-credibility'] ?>
                                            </li>
                                            <li class="flex items-center text-gray-600 dark:text-gray-300">
                                                <svg class="w-3.5 h-3.5 mr-2 text-green-500 dark:text-green-400 flex-shrink-0" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="currentColor" viewBox="0 0 20 20">
                                                    <path d="M10 .5a9.5 9.5 0 1 0 9.5 9.5A9.51 9.51 0 0 0 10 .5Zm3.707 8.207-4 4a1 1 0 0 1-1.414 0l-2-2a1 1 0 0 1 1.414-1.414L9 10.586l3.293-3.293a1 1 0 0 1 1.414 1.414Z"/>
                                                </svg>
                                                <?php echo $lang['domain-transfer-future-proofing'] ?>
                                            </li>
                                            <li class="flex items-center text-gray-600 dark:text-gray-300">
                                                <svg class="w-3.5 h-3.5 mr-2 text-green-500 dark:text-green-400 flex-shrink-0" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="currentColor" viewBox="0 0 20 20">
                                                    <path d="M10 .5a9.5 9.5 0 1 0 9.5 9.5A9.51 9.51 0 0 0 10 .5Zm3.707 8.207-4 4a1 1 0 0 1-1.414 0l-2-2a1 1 0 0 1 1.414-1.414L9 10.586l3.293-3.293a1 1 0 0 1 1.414 1.414Z"/>
                                                </svg>
                                                <?php echo $lang['domain-transfer-expert-support'] ?>
                                            </li>
                                        </ul>

                                    </div>
                                </div>
        </section>
        <section class="bg-white dark:bg-dark-900">
            <div class="mx-auto max-w-screen-xl lg:pb-12 lg:pt-1">
                <div class="p-4 md:p-6 sm:pt-8 flex items-center">
                    <div class="block mx-auto max-w-screen-md justify-center sm:flex sm:space-x-8 space-y-6 sm:space-y-0">
                        <div class="block text-center overflow-hidden bg-gradient-to-b from-green-50 dark:from-dark-800 to-transparent justify-center bg-gray-100 dark:bg-dark-900 p-5 border border-gray-200 dark:border-gray-700 rounded-3xl mt-8 sm:mt-0 !mx-auto w-full h-[20em] sm:min-w-[25em] sm:h-[25em] bg-contain bg-center bg-no-repeat bg-image-[url('<?php echo asset('images/content/creative-image.png')?>')] bg-blend-multiply skeleton">
                            <h2 class="text-xl md:text-2xl font-bold text-green-600/100 dark:text-green-500/100"><?php echo $lang['domain-transfer-feature-first'] ?></h2>
                            <p class="text-xl md:text-2xl font-bold text-green-600/75 dark:text-green-500/75"><?php echo $lang['domain-transfer-feature-first'] ?></p>
                            <p class="text-xl md:text-2xl font-bold text-green-600/50 dark:text-green-500/50"><?php echo $lang['domain-transfer-feature-first'] ?></p>
                            <p class="text-xl md:text-2xl font-bold text-green-600/25 dark:text-green-500/25"><?php echo $lang['domain-transfer-feature-first'] ?></p>

                            <div id="circle">
                                <svg class="!relative !h-57" version="1.1" xmlns="http://www.w3.org/2000/svg"
                                     xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" width="300px"
                                     height="300px" viewBox="0 0 300 300" enable-background="new 0 0 300 300"
                                     xml:space="preserve">
                                            <defs>
                                                <path id="circlePath" d="M 150, 150 m -60, 0 a 60,60 0 0,1 120,0 a 60,60 0 0,1 -120,0 "/>
                                            </defs>
                                    <circle cx="150" cy="100" r="75" fill="none"/>
                                    <g>
                                        <use xlink:href="#circlePath" fill="none"/>
                                        <text class="fill-gray-400 dark:fill-gray-300">
                                            <textPath xlink:href="#circlePath">
                                                <?php echo $lang['domain-transfer-circle'] ?>
                                            </textPath>
                                        </text>
                                    </g>
                                    </svg>
                            </div>
                        </div>
                        <div class="space-y-6 mr-0 sm:mr-8">
                            <div class="flex items-center text-center overflow-hidden bg-gray-100 dark:bg-dark-900 border border-gray-200 dark:border-gray-700 rounded-3xl p-8 md:p-6 skeleton w-full min-h-[10em] sm:min-h-[11.5em] sm:min-w-[20em]">
                                <h2 class="text-transparent bg-clip-text bg-gradient-to-r to-emerald-600 from-sky-700 text-2xl md:text-3xl font-bold"><?php echo $lang['domain-transfer-feature-second'] ?></h2>
                            </div>
                            <div class="flex items-center text-center overflow-hidden bg-gray-100 dark:bg-dark-900 border border-gray-200 dark:border-gray-700 rounded-3xl p-8 md:p-6 skeleton w-full min-h-[10em] sm:min-h-[11.5em] sm:min-w-[20em]">
                                <h2 class="text-green-800 dark:text-green-500 text-2xl md:text-3xl font-bold"><?php echo $lang['domain-transfer-feature-third'] ?></h2>
                            </div>
                        </div>

                    </div>
                </div>
                <div class="p-4 md:p-6 sm:pt-8 flex items-center">
                    <div class="block mx-auto max-w-screen-md justify-center sm:flex sm:space-x-8 space-y-6 sm:space-y-0">
                        <div class="flex justify-end items-end mx-auto text-start overflow-hidden bg-gray-100 dark:bg-dark-900 border border-gray-200 dark:border-gray-700 rounded-3xl p-8 md:p-6 skeleton w-full min-h-[10em] sm:min-w-[15em] sm:h-[15em]">
                            <h2 class="text-transparent bg-clip-text bg-gradient-to-r to-emerald-600 from-sky-700 text-2xl md:text-3xl font-bold"><?php echo $lang['domain-transfer-feature-fourth'] ?></h2>
                        </div>
                        <div class="flex items-start text-center overflow-hidden border border-gray-200 dark:border-gray-700 rounded-3xl p-8 md:p-6 skeleton w-full min-h-[15em] sm:min-h-[15em] sm:min-w-[30em] bg-cover bg-center bg-no-repeat bg-[url('<?php echo asset('images/content/privacy-protection.jpg')?>')] bg-blend-multiply">
                            <h2 class="text-transparent bg-clip-text bg-gradient-to-r to-gray-200 from-gray-100 text-2xl md:text-3xl font-bold"><?php echo $lang['domain-transfer-feature-fifth'] ?></h2>
                        </div>
                    </div>
                </div>
                <div class="p-4 md:p-6 sm:pt-8 flex items-center">
                    <div class="block mx-auto max-w-screen-md justify-center sm:flex sm:space-x-8 space-y-6 sm:space-y-0">
                        <div class="flex justify-end items-end text-start overflow-hidden border border-gray-200 dark:border-gray-700 rounded-3xl p-8 md:p-6 skeleton w-full min-h-[20em] sm:min-w-[15em] sm:h-[30em] bg-cover bg-right bg-no-repeat bg-[url('<?php echo asset('images/content/dns-management.jpg')?>')] bg-blend-multiply">
                            <h2 class="text-transparent bg-clip-text bg-gradient-to-r to-purple-50 from-gray-50 text-2xl md:text-3xl font-bold"><?php echo $lang['domain-transfer-feature-sixth'] ?></h2>
                        </div>
                        <div class="flex items-start text-center overflow-hidden border border-gray-200 dark:border-gray-700 rounded-3xl p-8 md:p-6 skeleton w-full min-h-[20em] sm:min-h-[15em] sm:min-w-[30em] bg-cover bg-center bg-no-repeat bg-[url('<?php echo asset('images/content/easy-transfer.jpg')?>')] bg-blend-multiply">
                            <h2 class="text-transparent bg-clip-text bg-gradient-to-r to-gray-200 from-gray-100 text-2xl md:text-3xl font-bold"><?php echo $lang['domain-transfer-feature-seventh'] ?></h2>
                        </div>
                    </div>
                </div>
                <div class="p-4 md:p-6 sm:pt-8 flex items-center">
                    <div class="block mx-auto max-w-screen-md justify-center sm:flex sm:space-x-8 space-y-6 sm:space-y-0">
                        <div class="space-y-6">
                            <div class="flex justify-start items-start text-start overflow-hidden border border-gray-200 dark:border-gray-700 rounded-3xl p-8 md:p-6 skeleton w-full min-h-[25em] sm:min-w-[25em] sm:h-[30em] bg-cover bg-center bg-no-repeat bg-[url('<?php echo asset('images/content/auto-renewal.jpg')?>')] bg-blend-multiply">
                                <h2 class="text-transparent bg-clip-text bg-gradient-to-r to-gray-50 from-gray-100 text-2xl md:text-3xl font-bold"><?php echo $lang['domain-transfer-feature-eighth'] ?></h2>
                            </div>
                            <div class="flex items-end justify-start text-left overflow-hidden border border-gray-200 dark:border-gray-700 rounded-3xl p-8 md:p-6 skeleton w-full min-h-[16em] sm:min-w-[15em] sm:h-[30em] sm:min-w-[10em] bg-gradient-to-t from-green-50 to-transparent dark:from-dark-800"">
                            <h2 class="text-transparent bg-clip-text bg-gradient-to-r to-emerald-600 from-sky-700 text-2xl md:text-3xl font-bold"><?php echo $lang['domain-transfer-feature-ninth'] ?></h2>
                            <svg width="82" height="82" viewBox="0 0 82 82" fill="none" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
                                <rect width="72" height="72" fill="url(#pattern0)"/>
                                <defs>
                                    <pattern id="pattern0" patternContentUnits="objectBoundingBox" width="1" height="1">
                                        <use xlink:href="#image0_36_3323" transform="scale(0.0138889)"/>
                                    </pattern>
                                    <image id="image0_36_3323" width="72" height="72" xlink:href="data:image/png;base64,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"/>
                                </defs>
                            </svg>

                        </div>
                    </div>
                    <div class="space-y-6">
                        <div class="flex items-center justify-center text-center overflow-hidden border border-gray-200 dark:border-gray-700 rounded-3xl p-8 md:p-6 skeleton w-full h-[12em] sm:min-h-[20em] sm:min-w-[10em] bg-gradient-to-tl from-green-50 to-transparent dark:from-dark-800">
                            <h2 class="text-transparent bg-clip-text bg-gradient-to-r to-emerald-600 from-sky-700 text-2xl md:text-3xl font-bold"><?php echo $lang['domain-transfer-feature-tenth'] ?></h2>
                        </div>
                        <div class="flex items-start text-center overflow-hidden border border-gray-200 dark:border-gray-700 rounded-3xl p-8 md:p-6 skeleton w-full h-[15em] sm:min-h-[40em] sm:min-w-[10em] bg-gradient-to-t from-green-50 to-transparent dark:from-dark-800">
                            <h2 class="text-transparent bg-clip-text bg-gradient-to-r to-emerald-600 from-sky-700 text-2xl md:text-3xl font-bold"><?php echo $lang['domain-transfer-feature-eleventh'] ?></h2>
                        </div>
                    </div>

                </div>
            </div>


    <section class="bg-white dark:bg-dark-900 mb-12">
        <div class="py-8 px-4 mx-auto max-w-screen-md text-center lg:py-16 lg:px-6">
            <div class="mx-auto max-w-screen-sm">
                <h3 class="mb-4 text-4xl tracking-tight font-bold text-gray-900 dark:text-white"><?php echo $lang['faqs-headline'] ?></h3>
                <p class="mb-8 font-normal text-gray-500 lg:mb-16 sm:text-xl dark:text-gray-400"><?php echo $lang['faqs-subheading'] ?></p>
            </div>
            <div id="accordion-collapse" data-accordion="collapse" class="divide-y-2 divide-gray-200 dark:divide-dark-600">
                <?php foreach ($faqSectionDomainTransfer as $index => $faq): ?>
                    <div>
                        <h2 id="accordion-collapse-heading-<?php echo $index + 1; ?>">
                            <button type="button" class="flex items-center justify-between !bg-transparent dark:!bg-transparent w-full p-5 font-medium text-left text-gray-700 focus:ring-0 dark:text-gray-300 hover:bg-gray-100 dark:hover:bg-dark-700" data-accordion-target="#accordion-collapse-body-<?php echo $index + 1; ?>" aria-expanded="false" aria-controls="accordion-collapse-body-<?php echo $index + 1; ?>">
                                <span><?php echo $faq['question']; ?></span>
                                <svg data-accordion-icon class="w-3 h-3 rotate-180 shrink-0" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 10 6">
                                    <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5 5 1 1 5"/>
                                </svg>
                            </button>
                        </h2>
                        <div id="accordion-collapse-body-<?php echo $index + 1; ?>" class="ml-2 hidden !bg-transparent dark:!bg-transparent text-left rounded-xl mb-2 pt-5 px-5 pb-5 mb-6 text-gray-700 dark:text-gray-300 bg-gray-100 dark:bg-dark-700">
                            <?php echo $faq['answer']; ?>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        </div>
    </section>
    <!-- Main modal -->
    <div id="broker-guide-modal" tabindex="-1" aria-hidden="true" class="fixed top-0 left-0 right-0 z-50 items-center justify-center hidden w-full overflow-x-hidden overflow-y-auto md:inset-0 h-[100%] max-h-full cssanimation fadeInBottom dark:!bg-dark-800/25">
        <div class="sm:relative sm:w-full sm:max-w-xl sm:max-h-full fixed bottom-0 w-full">
            <!-- Modal content -->
            <div class="relative bg-white sm:rounded-xl shadow dark:bg-dark-800 rounded-t-[2rem]">
                <button type="button" class="close-modal absolute top-3 right-2.5 text-gray-400 bg-transparent hover:bg-gray-200 hover:text-gray-900 rounded-xl text-sm w-8 h-8 ml-auto inline-flex justify-center items-center dark:hover:bg-gray-600 dark:hover:text-white" data-modal-hide="broker-guide-modal">
                    <svg class="w-3 h-3" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 14 14">
                        <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="m1 1 6 6m0 0 6 6M7 7l6-6M7 7l-6 6"/>
                    </svg>
                    <span class="sr-only">Close modal</span>
                </button>
                <!-- Modal header -->
                <div class="p-3 md:px-6 py-1 pt-4 md:py-4 rounded-t dark:border-gray-600">
                    <h3 class="text-sm font-bold text-gray-900 lg:text-lg dark:text-white">
                        <?php echo $lang['domain-broker-modal-headline'] ?>
                    </h3>
                </div>
                <!-- Modal body -->
                <div class="p-3 md:px-6 py-0.5 md:py-1">
                    <h3 class="font-bold text-primary-700 text-sm dark:text-primary-300 mb-4"><?php echo $lang['domain-broker-modal-subheading'] ?></h3>
                    <ol class="relative text-gray-500 border-gray-200 dark:border-dark-700 dark:text-gray-400">
                        <li class="mb-3 md:mb-6 flex items-center">
                            <img class="w-12 h-12 md:w-20 md:h-20 rounded-full mr-4" src="<?php echo asset('images/content/domain-broker-agent.jpg')?>" alt="Domain Broker Agent">
                            <span>
                                    <h3 class="font-bold text-sm md:text-lg leading-tight dark:text-white"><?php echo $lang['domain-broker-modal-first-item-heading'] ?></h3>
                                     <p class="text-xs md:text-sm font-medium md:mt-1 md:ml-1 dark:text-gray-300"><?php echo $lang['domain-broker-modal-first-item-subheading'] ?></p>
                               </span>
                        </li>
                        <li class="mb-3 md:mb-6 flex items-center">
                                <span class="!flex items-center justify-center p-4 md:p-8 w-12 h-12 md:w-20 md:h-20 bg-gray-100 rounded-full ring-white dark:ring-gray-900 dark:bg-dark-700 mr-4">
                                    <span class="material-symbols-outlined">
                                    sync_alt
                                    </span>
                                </span>
                            <span>
                                    <h3 class="font-bold text-sm md:text-lg leading-tight dark:text-white"><?php echo $lang['domain-broker-modal-second-item-heading'] ?></h3>
                                     <p class="text-xs md:text-sm font-medium md:mt-1 md:ml-1 dark:text-gray-300"><?php echo $lang['domain-broker-modal-second-item-subheading'] ?></p>
                               </span>
                        </li>
                        <li class="mb-3 md:mb-6 flex items-center">
                                <span class="!flex items-center justify-center p-4 md:p-8 w-12 h-12 md:w-20 md:h-20 bg-gray-100 rounded-full ring-white dark:ring-gray-900 dark:bg-dark-700 mr-4">
                                    <span class="material-symbols-outlined">
                                    language
                                    </span>
                                </span>
                            <span>
                                    <h3 class="font-bold text-sm md:text-lg leading-tight dark:text-white"><?php echo $lang['domain-broker-modal-third-item-heading'] ?></h3>
                                     <p class="text-xs md:text-sm font-medium md:mt-1 md:ml-1 dark:text-gray-300"><?php echo $lang['domain-broker-modal-third-item-subheading'] ?></p>
                               </span>
                        </li>
                    </ol>
                    <div class="flex justify-between items-center my-3 py-3 px-5 h-20 bg-white border border-gray-200 rounded-xl hover:bg-gray-100 dark:bg-dark-700 dark:border-dark-600 dark:hover:bg-dark-700">
                        <div class="flex items-center">
                                <span class="block text-left text-sm text-dark-700 font-medium text-dark-700 mr-4 font-semibold">
                                    <p class="text-sm font-medium text-gray-600 dark:text-gray-300"><?php echo $lang['broker-service-fee'] ?></p>
                                    <p class="flex items-center justify-start text-left text-lg text-dark-700 font-semibold dark:text-gray-300"><?php echo $lang['broker-service-fee-price'] ?></p>
                                    <p class="text-xs font-medium text-gray-500 dark:text-gray-400"><?php echo $lang['broker-service-fee-commission'] ?></p>
                                </span>
                        </div>
                        <div class="flex items-center justify-end">
                            <button class="add-to-cart-btn w-full text-white bg-gray-800 hover:bg-gray-900 focus:ring-4 focus:ring-gray-300 font-medium rounded-full text-sm px-5 py-2.5 dark:bg-dark-600 dark:hover:bg-dark-500 focus:outline-none dark:focus:ring-dark-800" data-domain="" data-tld=""><?php echo $lang['broker-service-cta'] ?></button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    </div>
<?php
include_once includes('layouts/footer.php');
?>