<?php
$meta = array(
    'us' => array(
        'title' => 'AI Domain Search: Find the Perfect Name - Datanito',
        'description' => 'Secure your online identity with Datanito\'s AI domain search. Find and register your ideal domain name with ease.',
        'og:title' => 'AI Domain Search: Find the Perfect Name - Datanito',
        'og:description' => 'Secure your online identity with Datanito\'s AI domain search. Find and register your ideal domain name with ease.',
        'og:image' => asset('images/brand/open_graph_logo.png'),
    ),
    'tr' => array(
        'title' => 'AI Destekli Alan Adı Arama: Mükemmel Alan Adını Bulun - Datanito',
        'description' => 'Datanito\'nun AI destekli alan adı arama hizmeti ile çevrimiçi kimliğinizi güvence altına alın. İdeal alan adınızı kolayca bulun ve kaydedin.',
        'og:title' => 'AI Destekli Alan Adı Arama: Mükemmel Alan Adını Bulun - Datanito',
        'og:description' => 'Datanito\'nun AI destekli alan adı arama hizmeti ile çevrimiçi kimliğinizi güvence altına alın. İdeal alan adınızı kolayca bulun ve kaydedin.',
        'og:image' => asset('images/brand/open_graph_logo.png'),
    ),
);

$currentMeta = setCountryAndMeta($meta);
include_once includes('layouts/header.php');
?>
<style>
    .input {
        --icon-size: 28px;
        position: relative;
    }

    .input svg {
        position: absolute;
        width: var(--icon-size);
        top: 50%;
        left: 1rem;
        translate: 0 -50%;
        overflow: visible;
        color: color-mix(in lch, canvas, canvasText 30%);
    }

    .input svg path {
        transform-box: fill-box;
        transform-origin: center;
    }

    .input:is(:hover, :focus-within) svg path {
        animation: pop 0.5s var(--d);
    }

    .input svg path:nth-of-type(1) { --d: 0.24s; --r: 20deg; --s: 1.5; }
    .input svg path:nth-of-type(2) { --d: 0.12s; --r: 10deg; --s: 1.4;}
    .input svg path:nth-of-type(3) { --d: 0s; --r: 0deg; --s: 1.25; }

    @keyframes pop {
        50% { scale: var(--s, 1); rotate: var(--r, 0deg); }
    }

    input::placeholder {
        color: color-mix(in lch, canvas, canvasText 30%);
    }

    input {
        font-family: inherit;
        min-width: 300px;
        padding: 1rem 1rem 1rem calc(1rem + var(--icon-size) + 0.5rem);
        font-size: 1.025rem;
        field-sizing: content;
        /*background:*/
        /*        linear-gradient(canvas, canvas) padding-box,*/
        /*        linear-gradient(120deg, hsl(278, 44%, 73%), hsl(35, 81%, 73%)) border-box;*/
        border: 4px solid transparent;
        border-radius: 12px;
        outline: none;
        /*   background-clip: padding-box, border-box; */
    }

    .bear-link {
        color: canvasText;
        position: fixed;
        top: 1rem;
        left: 1rem;
        width: 48px;
        aspect-ratio: 1;
        display: grid;
        place-items: center;
        opacity: 0.8;
    }
</style>
    <div id="content" class="container mx-auto lg:mt-12 mt-12">
        <section class="relative bg-transparent pt-16 md:pt-24 pb-6 md:pb-10 overflow-hidden">
            <!-- Background gradient elements -->
            <div aria-hidden="true" class="absolute inset-0 h-full w-full mx-auto grid grid-cols-2 -space-x-52 opacity-20 pointer-events-none">
                <div class="blur-[50px] sm:blur-[106px] h-56 bg-gradient-to-br to-purple-400 from-blue-700"></div>
                <div class="blur-[50px] sm:blur-[106px] h-32 bg-gradient-to-r from-cyan-400 to-indigo-600"></div>
            </div>

            <div class="container mx-auto px-4 relative z-10">
                <!-- Headline section -->
                <div class="text-center mb-12">
                    <h1 class="text-4xl md:text-6xl lg:text-7xl font-bold text-black dark:text-white leading-tight">
                        <?php echo $lang['register-domain-superior'] ?>
                    </h1>
                    <div class="flex items-center justify-center mt-6 space-x-2">
                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor" class="w-6 h-6 text-purple-400">
                            <path fill-rule="evenodd" d="M9 4.5a.75.75 0 01.721.544l.813 2.846a3.75 3.75 0 002.576 2.576l2.846.813a.75.75 0 010 1.442l-2.846.813a3.75 3.75 0 00-2.576 2.576l-.813 2.846a.75.75 0 01-1.442 0l-.813-2.846a3.75 3.75 0 00-2.576-2.576l-2.846-.813a.75.75 0 010-1.442l2.846-.813A3.75 3.75 0 007.466 7.89l.813-2.846A.75.75 0 019 4.5zM18 1.5a.75.75 0 01.728.568l.258 1.036c.236.94.97 1.674 1.91 1.91l1.036.258a.75.75 0 010 1.456l-1.036.258c-.94.236-1.674.97-1.91 1.91l-.258 1.036a.75.75 0 01-1.456 0l-.258-1.036a2.625 2.625 0 00-1.91-1.91l-1.036-.258a.75.75 0 010-1.456l1.036-.258a2.625 2.625 0 001.91-1.91l.258-1.036A.75.75 0 0118 1.5z" clip-rule="evenodd"></path>
                        </svg>
                        <h2 class="text-lg md:text-xl text-transparent bg-clip-text bg-gradient-to-r from-purple-400 to-cyan-600 font-medium">
                            <?php echo $lang['register-domain-headline'] ?>
                        </h2>
                    </div>
                </div>

                <!-- Search domain section -->
                <div class="max-w-2xl mx-auto mb-10">
                    <div class="relative">
                        <form id="domainSearchForm" class="flex items-center">
                            <div class="relative flex-grow">
                                <div class="absolute inset-y-0 left-0 flex items-center pl-4 pointer-events-none">
                                    <svg class="w-5 h-5 text-gray-500 dark:text-gray-400" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 20 20">
                                        <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="m19 19-4-4m0-7A7 7 0 1 1 1 8a7 7 0 0 1 14 0Z"/>
                                    </svg>
                                </div>
                                <input type="search" id="userInput" class="block w-full p-4 pl-12 text-base text-gray-900 border border-gray-300 rounded-full bg-gray-50 focus:ring-2 focus:ring-purple-500 focus:border-purple-500 dark:bg-dark-700 dark:border-dark-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-purple-500 dark:focus:border-purple-500" placeholder="<?php echo $lang['register-domain-search-placeholder']?>" required>
                            </div>
                            <button type="submit" id="checkButton" class="ml-3 px-6 py-4 bg-gradient-to-r from-purple-600 to-blue-600 hover:from-purple-700 hover:to-blue-700 text-white font-medium rounded-full shadow-lg hover:shadow-xl transition-all duration-300 transform hover:scale-105 focus:outline-none focus:ring-2 focus:ring-purple-500 focus:ring-offset-2 dark:focus:ring-offset-dark-800">
                                <?php echo $lang['search-domain-button'] ?? 'Search'; ?>
                            </button>
                        </form>
                    </div>
                    <p class="text-center mt-4 text-sm text-gray-500 dark:text-gray-400">
                        <?php echo $lang['domain-search-tip'] ?? 'Enter your desired domain name to check availability'; ?>
                    </p>
                </div>

                <!-- AI CTA section -->
                <div class="text-center">
                    <button type="button" data-modal-target="domainDinoModal" data-modal-toggle="domainDinoModal" class="inline-flex items-center px-6 py-3 border border-transparent text-base font-medium rounded-full shadow-sm text-white bg-gradient-to-r from-purple-500 to-pink-500 hover:from-purple-600 hover:to-pink-600 transition-all duration-300 hover:shadow-lg transform hover:scale-105 focus:outline-none focus:ring-2 focus:ring-purple-500 focus:ring-offset-2 dark:focus:ring-offset-dark-800">
                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor" class="w-5 h-5 mr-2">
                            <path fill-rule="evenodd" d="M9 4.5a.75.75 0 01.721.544l.813 2.846a3.75 3.75 0 002.576 2.576l2.846.813a.75.75 0 010 1.442l-2.846.813a3.75 3.75 0 00-2.576 2.576l-.813 2.846a.75.75 0 01-1.442 0l-.813-2.846a3.75 3.75 0 00-2.576-2.576l-2.846-.813a.75.75 0 010-1.442l2.846-.813A3.75 3.75 0 007.466 7.89l.813-2.846A.75.75 0 019 4.5zM18 1.5a.75.75 0 01.728.568l.258 1.036c.236.94.97 1.674 1.91 1.91l1.036.258a.75.75 0 010 1.456l-1.036.258c-.94.236-1.674.97-1.91 1.91l-.258 1.036a.75.75 0 01-1.456 0l-.258-1.036a2.625 2.625 0 00-1.91-1.91l-1.036-.258a.75.75 0 010-1.456l1.036-.258a2.625 2.625 0 001.91-1.91l.258-1.036A.75.75 0 0118 1.5z"></path>
                        </svg>
                        <?php echo $lang['ai-register-domain-modal-cta']; ?>
                    </button>
                    <p class="mt-3 text-sm text-gray-500 dark:text-gray-400">
                        <?php echo $lang['ai-cta-subtext'] ?? 'Not sure what domain to choose? Let our AI help!'; ?>
                    </p>
                </div>
            </div>
        </section>        <div id="navigateBar" class="invisible fixed max-h-14 -translate-x-1/2 left-1/2 z-20 w-full max-w-[7em] mx-auto flex space-x-3">
            <div class="navigation_items grid grid-cols-3 justify-between bg-dark-600 dark:bg-dark-600 dark:bg-opacity-75 backdrop-blur bg-opacity-75 rounded-full p-1 w-[77%] h-14" role="group">
                <button type="button" id="featuresButton" class="nav-button text-white dark:text-white text-xs !font-bold border-b-2 border-transparent rounded-full">
                    <?php echo $lang['navigateBar-features']?>
                </button>
                <button type="button" id="results-tabButton" class="nav-button text-white dark:text-white text-xs !font-bold border-b-2 border-transparent rounded-full">
                    <?php echo $lang['results']?>
                </button>
                <button type="button" id="faqsButton" class="nav-button text-white dark:text-white text-xs !font-bold border-b-2 border-transparent rounded-full">
                    <?php echo $lang['navigateBar-faqs']?>
                </button>
            </div>
            <div class="text-white dark:text-white bg-dark-600 dark:bg-dark-600 dark:hover:bg-dark-500 dark:!bg-opacity-75 backdrop-blur !bg-opacity-75 rounded-full flex items-center justify-center w-14 h-14" role="group">
                <button type="button" data-modal-target="domainDinoModal" data-modal-toggle="domainDinoModal" class="nav-button !border-0 flex items-center justify-center w-full h-full text-xs font-medium rounded-full">
                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor" class="w-5 h-5 text-white">
                        <path fill-rule="evenodd" d="M9 4.5a.75.75 0 01.721.544l.813 2.846a3.75 3.75 0 002.576 2.576l2.846.813a.75.75 0 010 1.442l-2.846.813a3.75 3.75 0 00-2.576 2.576l-.813 2.846a.75.75 0 01-1.442 0l-.813-2.846a3.75 3.75 0 00-2.576-2.576l-2.846-.813a.75.75 0 010-1.442l2.846-.813A3.75 3.75 0 007.466 7.89l.813-2.846A.75.75 0 019 4.5zM18 1.5a.75.75 0 01.728.568l.258 1.036c.236.94.97 1.674 1.91 1.91l1.036.258a.75.75 0 010 1.456l-1.036.258c-.94.236-1.674.97-1.91 1.91l-.258 1.036a.75.75 0 01-1.456 0l-.258-1.036a2.625 2.625 0 00-1.91-1.91l-1.036-.258a.75.75 0 010-1.456l1.036-.258a2.625 2.625 0 001.91-1.91l.258-1.036A.75.75 0 0118 1.5zM16.5 15a.75.75 0 01.712.513l.394 1.183c.15.447.5.799.948.948l1.183.395a.75.75 0 010 1.422l-1.183.395c-.447.15-.799.5-.948.948l-.395 1.183a.75.75 0 01-1.422 0l-.395-1.183a1.5 1.5 0 00-.948-.948l-1.183-.395a.75.75 0 010-1.422l1.183-.395c.447-.15.799-.5.948-.948l.395-1.183A.75.75 0 0116.5 15z" clip-rule="evenodd"></path>
                    </svg>
                </button>
            </div>
        </div>
        <div id="navigateBarActivate"></div>
        <section class="bg-white dark:bg-dark-900 mb-12 overflow-hidden min-h-36 relative z-10">
            <div class="mx-auto text-center overflow-hidden">
                <div class="sm:mx-auto">
                    <div class="domain-names-registration w-full bg-white dark:bg-dark-900">
                        <ul class="flex flex-wrap text-sm font-medium text-center justify-center text-gray-500 border-b border-gray-200 dark:border-dark-700 dark:text-gray-400 relative z-10" id="domainRegistrationTabs" data-tabs-toggle="#domainRegistrationTabsContent" role="tablist">
                            <li class="mr-2 border-b-2 border-transparent hover:border-blue-600 duration-200">
                                <button id="results-tab" data-tabs-target="#resultsT" type="button" role="tab" aria-controls="resultsT" aria-selected="true" class="inline-flex items-center p-4 text-blue-600 dark:hover:bg-dark-700 dark:text-blue-500">
                                    <span class="material-symbols-outlined text-xl mr-2">search</span>
                                    <span><?php echo $lang['results']?></span>
                                </button>
                            </li>
                            <li class="mr-2 border-b-2 border-transparent hover:border-blue-600 duration-200">
                                <button id="history-tab" data-tabs-target="#historyT" type="button" role="tab" aria-controls="historyT" aria-selected="false" class="inline-flex items-center p-4 hover:text-gray-600 dark:hover:bg-dark-700 dark:hover:text-gray-300">
                                    <span class="material-symbols-outlined text-xl mr-2">history</span>
                                    <span><?php echo $lang['history']?></span>
                                </button>
                            </li>
                            <li class="mr-2 border-b-2 border-transparent hover:border-blue-600 duration-200">
                                <button id="favorites-tab" data-tabs-target="#favoritesT" type="button" role="tab" aria-controls="favoritesT" aria-selected="false" class="inline-flex items-center p-4 hover:text-gray-600 dark:hover:bg-dark-700 dark:hover:text-gray-300">
                                    <span class="material-symbols-outlined text-xl mr-2">favorite</span>
                                    <span><?php echo $lang['favorites']?></span>
                                </button>
                            </li>
                        </ul>
                        <div id="domainRegistrationTabsContent" class="max-w-screen-xl mx-auto">
                            <div class="hidden p-4 bg-white rounded-xl md:p-8 dark:bg-dark-900" id="resultsT" role="tabpanel" aria-labelledby="results-tab">
                                <div role="status" class="spinner hidden my-6 p-4 space-y-4 bg-gray-50 dark:bg-dark-700 rounded-3xl">
                                    <svg aria-hidden="true" class="inline w-20 h-20 text-gray-200 animate-spin dark:text-gray-600 fill-blue-500" viewBox="0 0 100 101" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path d="M100 50.5908C100 78.2051 77.6142 100.591 50 100.591C22.3858 100.591 0 78.2051 0 50.5908C0 22.9766 22.3858 0.59082 50 0.59082C77.6142 0.59082 100 22.9766 100 50.5908ZM9.08144 50.5908C9.08144 73.1895 27.4013 91.5094 50 91.5094C72.5987 91.5094 90.9186 73.1895 90.9186 50.5908C90.9186 27.9921 72.5987 9.67226 50 9.67226C27.4013 9.67226 9.08144 27.9921 9.08144 50.5908Z" fill="currentColor"/>
                                        <path d="M93.9676 39.0409C96.393 38.4038 97.8624 35.9116 97.0079 33.5539C95.2932 28.8227 92.871 24.3692 89.8167 20.348C85.8452 15.1192 80.8826 10.7238 75.2124 7.41289C69.5422 4.10194 63.2754 1.94025 56.7698 1.05124C51.7666 0.367541 46.6976 0.446843 41.7345 1.27873C39.2613 1.69328 37.813 4.19778 38.4501 6.62326C39.0873 9.04874 41.5694 10.4717 44.0505 10.1071C47.8511 9.54855 51.7191 9.52689 55.5402 10.0491C60.8642 10.7766 65.9928 12.5457 70.6331 15.2552C75.2735 17.9648 79.3347 21.5619 82.5849 25.841C84.9175 28.9121 86.7997 32.2913 88.1811 35.8758C89.083 38.2158 91.5421 39.6781 93.9676 39.0409Z" fill="currentFill"/>
                                    </svg>
                                    <span class="block text-center w-72 space-y-4">
                                        <p class="headline text-lg font-medium text-gray-700 dark:text-gray-200"></p>
                                        <p class="subheading font-light text-gray-600 dark:text-gray-300"></p>
                                    </span>
                                    <span class="sr-only">Loading...</span>
                                </div>
                                <div id="domainResults"></div>
                            </div>
                            <div class="hidden p-4 bg-white rounded-xl md:p-8 dark:bg-dark-900" id="historyT" role="tabpanel" aria-labelledby="history-tab">
                                <div id="history-results"></div>
                            </div>
                            <div class="hidden p-4 bg-white rounded-xl md:p-8 dark:bg-dark-900" id="favoritesT" role="tabpanel" aria-labelledby="favorites-tab">
                                <div role="status" class="fav-spinner hidden my-6">
                                    <svg aria-hidden="true" class="inline w-20 h-20 mr-2 text-gray-200 animate-spin dark:text-gray-600 fill-green-500" viewBox="0 0 100 101" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path d="M100 50.5908C100 78.2051 77.6142 100.591 50 100.591C22.3858 100.591 0 78.2051 0 50.5908C0 22.9766 22.3858 0.59082 50 0.59082C77.6142 0.59082 100 22.9766 100 50.5908ZM9.08144 50.5908C9.08144 73.1895 27.4013 91.5094 50 91.5094C72.5987 91.5094 90.9186 73.1895 90.9186 50.5908C90.9186 27.9921 72.5987 9.67226 50 9.67226C27.4013 9.67226 9.08144 27.9921 9.08144 50.5908Z" fill="currentColor"/>
                                        <path d="M93.9676 39.0409C96.393 38.4038 97.8624 35.9116 97.0079 33.5539C95.2932 28.8227 92.871 24.3692 89.8167 20.348C85.8452 15.1192 80.8826 10.7238 75.2124 7.41289C69.5422 4.10194 63.2754 1.94025 56.7698 1.05124C51.7666 0.367541 46.6976 0.446843 41.7345 1.27873C39.2613 1.69328 37.813 4.19778 38.4501 6.62326C39.0873 9.04874 41.5694 10.4717 44.0505 10.1071C47.8511 9.54855 51.7191 9.52689 55.5402 10.0491C60.8642 10.7766 65.9928 12.5457 70.6331 15.2552C75.2735 17.9648 79.3347 21.5619 82.5849 25.841C84.9175 28.9121 86.7997 32.2913 88.1811 35.8758C89.083 38.2158 91.5421 39.6781 93.9676 39.0409Z" fill="currentFill"/>
                                    </svg>
                                    <span class="sr-only">Loading...</span>
                                </div>
                                <div id="fav-results"></div>
                            </div>
                        </div>
                    </div>

                </div>
            </div>
        </section>
        <section class="bg-white dark:bg-dark-900">
            <div class="mx-auto max-w-screen-md">
                <div class="flex p-4 md:p-0 pt-8 flex items-center">
                    <div class="space-y-8 w-full">
                        <div class="flex items-center justify-center text-center bg-gray-50 dark:bg-dark-800 border border-gray-200 dark:border-gray-700 rounded-3xl p-8 md:p-6 md:h-80 skeleton">
                            <div class="text-center">
                                <h2 class="text-gray-600 dark:text-white text-xl md:text-2xl font-bold mb-2"><?php echo $lang['why-register-domain-headline'] ?></h2>
                                <div class="flex-1 flex flex-col justify-between items-center gap-4">
                                    <p class="text-lg font-normal text-gray-600 dark:text-gray-300"><?php echo $lang['why-register-domain-subheading'] ?></p>
                                </div>
                                <div class="flex justify-center mt-3">
                                    <div class="grid grid-cols-1 md:grid-cols-2 md:space-x-8">
                                        <ul class="space-y-2 text-gray-500 list-inside dark:text-gray-400 mt-1.5 sm:mt-3">
                                            <li class="flex items-center text-gray-600 dark:text-gray-300">
                                                <svg class="w-3.5 h-3.5 mr-2 text-green-500 dark:text-green-400 flex-shrink-0" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="currentColor" viewBox="0 0 20 20">
                                                    <path d="M10 .5a9.5 9.5 0 1 0 9.5 9.5A9.51 9.51 0 0 0 10 .5Zm3.707 8.207-4 4a1 1 0 0 1-1.414 0l-2-2a1 1 0 0 1 1.414-1.414L9 10.586l3.293-3.293a1 1 0 0 1 1.414 1.414Z"/>
                                                </svg>
                                                <?php echo $lang['domain-wide-range-of-extensions'] ?>
                                            </li>
                                            <li class="flex items-center text-gray-600 dark:text-gray-300">
                                                <svg class="w-3.5 h-3.5 mr-2 text-green-500 dark:text-green-400 flex-shrink-0" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="currentColor" viewBox="0 0 20 20">
                                                    <path d="M10 .5a9.5 9.5 0 1 0 9.5 9.5A9.51 9.51 0 0 0 10 .5Zm3.707 8.207-4 4a1 1 0 0 1-1.414 0l-2-2a1 1 0 0 1 1.414-1.414L9 10.586l3.293-3.293a1 1 0 0 1 1.414 1.414Z"/>
                                                </svg>
                                                <?php echo $lang['domain-affordable-pricing'] ?>
                                            </li>
                                            <li class="flex items-center text-gray-600 dark:text-gray-300">
                                                <svg class="w-3.5 h-3.5 mr-2 text-green-500 dark:text-green-400 flex-shrink-0" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="currentColor" viewBox="0 0 20 20">
                                                    <path d="M10 .5a9.5 9.5 0 1 0 9.5 9.5A9.51 9.51 0 0 0 10 .5Zm3.707 8.207-4 4a1 1 0 0 1-1.414 0l-2-2a1 1 0 0 1 1.414-1.414L9 10.586l3.293-3.293a1 1 0 0 1 1.414 1.414Z"/>
                                                </svg>
                                                <?php echo $lang['domain-secure-your-brand'] ?>
                                            </li>
                                            <li class="flex items-center text-gray-600 dark:text-gray-300">
                                                <svg class="w-3.5 h-3.5 mr-2 text-green-500 dark:text-green-400 flex-shrink-0" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="currentColor" viewBox="0 0 20 20">
                                                    <path d="M10 .5a9.5 9.5 0 1 0 9.5 9.5A9.51 9.51 0 0 0 10 .5Zm3.707 8.207-4 4a1 1 0 0 1-1.414 0l-2-2a1 1 0 0 1 1.414-1.414L9 10.586l3.293-3.293a1 1 0 0 1 1.414 1.414Z"/>
                                                </svg>
                                                <?php echo $lang['domain-enhance-credibility'] ?>
                                            </li>
                                        </ul>
                                        <ul class="max-w-md space-y-2 text-gray-500 list-inside dark:text-gray-400 mt-1.5 sm:mt-3">
                                            <li class="flex items-center text-gray-600 dark:text-gray-300">
                                                <svg class="w-3.5 h-3.5 mr-2 text-green-500 dark:text-green-400 flex-shrink-0" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="currentColor" viewBox="0 0 20 20">
                                                    <path d="M10 .5a9.5 9.5 0 1 0 9.5 9.5A9.51 9.51 0 0 0 10 .5Zm3.707 8.207-4 4a1 1 0 0 1-1.414 0l-2-2a1 1 0 0 1 1.414-1.414L9 10.586l3.293-3.293a1 1 0 0 1 1.414 1.414Z"/>
                                                </svg>
                                                <?php echo $lang['domain-better-seo'] ?>
                                            </li>
                                            <li class="flex items-center text-gray-600 dark:text-gray-300">
                                                <svg class="w-3.5 h-3.5 mr-2 text-green-500 dark:text-green-400 flex-shrink-0" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="currentColor" viewBox="0 0 20 20">
                                                    <path d="M10 .5a9.5 9.5 0 1 0 9.5 9.5A9.51 9.51 0 0 0 10 .5Zm3.707 8.207-4 4a1 1 0 0 1-1.414 0l-2-2a1 1 0 0 1 1.414-1.414L9 10.586l3.293-3.293a1 1 0 0 1 1.414 1.414Z"/>
                                                </svg>
                                                <?php echo $lang['domain-memorable-online-identity'] ?>
                                            </li>
                                            <li class="flex items-center text-gray-600 dark:text-gray-300">
                                                <svg class="w-3.5 h-3.5 mr-2 text-green-500 dark:text-green-400 flex-shrink-0" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="currentColor" viewBox="0 0 20 20">
                                                    <path d="M10 .5a9.5 9.5 0 1 0 9.5 9.5A9.51 9.51 0 0 0 10 .5Zm3.707 8.207-4 4a1 1 0 0 1-1.414 0l-2-2a1 1 0 0 1 1.414-1.414L9 10.586l3.293-3.293a1 1 0 0 1 1.414 1.414Z"/>
                                                </svg>
                                                <?php echo $lang['domain-email-personalization'] ?>
                                            </li>
                                            <li class="flex items-center text-gray-600 dark:text-gray-300">
                                                <svg class="w-3.5 h-3.5 mr-2 text-green-500 dark:text-green-400 flex-shrink-0" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="currentColor" viewBox="0 0 20 20">
                                                    <path d="M10 .5a9.5 9.5 0 1 0 9.5 9.5A9.51 9.51 0 0 0 10 .5Zm3.707 8.207-4 4a1 1 0 0 1-1.414 0l-2-2a1 1 0 0 1 1.414-1.414L9 10.586l3.293-3.293a1 1 0 0 1 1.414 1.414Z"/>
                                                </svg>
                                                <?php echo $lang['domain-future-proofing'] ?>
                                            </li>
                                        </ul>

                                    </div>
                                </div>

        </section>

        <section id="features" class="bg-white dark:bg-dark-900">
            <div class="mx-auto max-w-screen-xl lg:py-12">
                <div class="p-4 md:p-6 sm:pt-8 flex items-center">
                    <div class="block mx-auto max-w-screen-md justify-center sm:flex sm:space-x-8 space-y-6 sm:space-y-0">
                        <div class="block text-center overflow-hidden bg-gradient-to-b from-green-50 dark:from-dark-800 to-transparent justify-center bg-gray-100 dark:bg-dark-900 p-5 border border-gray-200 dark:border-gray-700 rounded-3xl mt-8 sm:mt-0 !mx-auto w-full h-[20em] sm:min-w-[25em] sm:h-[25em] bg-contain bg-center bg-no-repeat bg-image-[url('<?php echo asset('images/content/creative-image.png')?>')] bg-blend-multiply skeleton">
                            <h2 class="text-xl md:text-3xl font-bold text-green-600/100 dark:text-green-500/100"><?php echo $lang['register-domain-feature-first'] ?></h2>
                            <p class="text-xl md:text-3xl font-bold text-green-600/75 dark:text-green-500/75"><?php echo $lang['register-domain-feature-first'] ?></p>
                            <p class="text-xl md:text-3xl font-bold text-green-600/50 dark:text-green-500/50"><?php echo $lang['register-domain-feature-first'] ?></p>
                            <p class="text-xl md:text-3xl font-bold text-green-600/25 dark:text-green-500/25"><?php echo $lang['register-domain-feature-first'] ?></p>

                            <div id="circle">
                                <svg class="!relative !h-57" version="1.1" xmlns="http://www.w3.org/2000/svg"
                                     xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" width="300px"
                                     height="300px" viewBox="0 0 300 300" enable-background="new 0 0 300 300"
                                     xml:space="preserve">
                                            <defs>
                                                <path id="circlePath" d="M 150, 150 m -60, 0 a 60,60 0 0,1 120,0 a 60,60 0 0,1 -120,0 "/>
                                            </defs>
                                    <circle cx="150" cy="100" r="75" fill="none"/>
                                    <g>
                                        <use xlink:href="#circlePath" fill="none"/>
                                        <text class="fill-gray-400 dark:fill-gray-300">
                                            <textPath xlink:href="#circlePath">
                                                <?php echo $lang['register-domain-circle'] ?>
                                            </textPath>
                                        </text>
                                    </g>
                                    </svg>
                            </div>
                        </div>
                        <div class="space-y-6 mr-0 sm:mr-8">
                            <div class="flex items-center text-center overflow-hidden bg-gray-100 dark:bg-dark-900 border border-gray-200 dark:border-gray-700 rounded-3xl p-8 md:p-6 skeleton w-full min-h-[10em] sm:min-h-[11.5em] sm:min-w-[20em]">
                                <h4 class="text-transparent bg-clip-text bg-gradient-to-r to-emerald-600 from-sky-700 text-2xl md:text-3xl font-bold"><?php echo $lang['register-domain-feature-second'] ?></h4>
                            </div>
                            <div class="flex items-center text-center overflow-hidden bg-gray-100 dark:bg-dark-900 border border-gray-200 dark:border-gray-700 rounded-3xl p-8 md:p-6 skeleton w-full min-h-[10em] sm:min-h-[11.5em] sm:min-w-[20em]">
                                <h4 class="text-transparent bg-clip-text bg-gradient-to-r to-emerald-600 from-sky-700 text-2xl md:text-3xl font-bold"><?php echo $lang['register-domain-feature-third'] ?></h4>
                            </div>
                        </div>

                    </div>
                </div>
                <div class="p-4 md:p-6 sm:pt-8 flex items-center">
                    <div class="block mx-auto max-w-screen-md justify-center sm:flex sm:space-x-8 space-y-6 sm:space-y-0">
                        <div class="flex justify-end items-end mx-auto text-start overflow-hidden bg-gray-100 dark:bg-dark-900 border border-gray-200 dark:border-gray-700 rounded-3xl p-8 md:p-6 skeleton w-full min-h-[10em] sm:min-w-[15em] sm:h-[15em]">
                            <h4 class="text-transparent bg-clip-text bg-gradient-to-r to-emerald-600 from-sky-700 text-xl md:text-2xl font-bold"><?php echo $lang['register-domain-feature-fourth'] ?></h4>
                            <img class="w-16 h-16" src="<?php echo asset('images/content/emoji__eriyz672w3e6_large.png')?>" alt="Shocked Emoji">
                        </div>
                        <div class="flex items-start text-center overflow-hidden border border-gray-200 dark:border-gray-700 rounded-3xl skeleton w-full min-h-[15em] sm:min-h-[15em] sm:min-w-[30em] bg-cover bg-center bg-no-repeat bg-[url('<?php echo asset('images/content/privacy-protection.jpg')?>')] bg-blend-multiply">
                            <h4 class="text-transparent bg-clip-text bg-gradient-to-r to-gray-200 from-gray-100 text-2xl md:text-3xl font-bold backdrop-blur p-8 md:p-6 w-full min-h-[15em] sm:min-h-[8em]"><?php echo $lang['register-domain-feature-fifth'] ?></h4>
                        </div>
                    </div>
                </div>
                <div class="p-4 md:p-6 sm:pt-8 flex items-center">
                    <div class="block mx-auto max-w-screen-md justify-center sm:flex sm:space-x-8 space-y-6 sm:space-y-0">
                        <div class="flex items-center text-center overflow-hidden border border-gray-200 dark:border-gray-700 rounded-3xl skeleton w-full min-h-[10em] sm:min-w-[15em] sm:h-[30em] bg-cover bg-center bg-no-repeat bg-[url('<?php echo asset('images/content/dns-management.jpg')?>')] bg-blend-multiply">
                            <h4 class="text-transparent bg-clip-text bg-gradient-to-r to-gray-200 from-gray-100 text-2xl md:text-3xl font-bold backdrop-blur p-8 md:p-6 w-full min-h-[15em] md:h-full flex items-end"><span><?php echo $lang['register-domain-feature-sixth'] ?></span></h4>
                        </div>
                        <div class="flex items-end text-center overflow-hidden border border-gray-200 dark:border-gray-700 rounded-3xl skeleton w-full min-h-[20em] sm:min-h-[15em] sm:min-w-[30em] bg-cover bg-center bg-no-repeat bg-[url('<?php echo asset('images/content/easy-transfer.jpg')?>')] bg-blend-multiply">
                            <h4 class="text-transparent bg-clip-text bg-gradient-to-r to-gray-200 from-gray-100 text-2xl md:text-3xl font-bold backdrop-blur p-8 md:p-6 w-full min-h-[15em] md:h-full"><?php echo $lang['register-domain-feature-seventh'] ?></h4>
                        </div>
                    </div>
                </div>
                <div class="p-4 md:p-6 sm:pt-8 flex items-center">
                    <div class="block mx-auto max-w-screen-md justify-center sm:flex sm:space-x-8 space-y-6 sm:space-y-0">
                        <div class="space-y-6">
                            <div class="flex justify-start items-end text-start overflow-hidden border border-gray-200 dark:border-gray-700 rounded-3xl skeleton w-full min-h-[15em] sm:min-w-[25em] sm:h-[30em] bg-cover bg-center bg-no-repeat bg-[url('<?php echo asset('images/content/auto-renewal.jpg')?>')] bg-blend-multiply">
                                <h4 class="text-transparent bg-clip-text bg-gradient-to-b to-white from-sky-200 text-2xl md:text-3xl font-bold backdrop-blur-[3px] p-8 md:p-6 w-full min-h-[15em] md:h-full"><?php echo $lang['register-domain-feature-eighth'] ?></h4>
                            </div>
                            <div class="flex justify-between items-end text-start overflow-hidden bg-gray-100 dark:bg-dark-900 border border-gray-200 dark:border-gray-700 rounded-3xl p-8 md:p-6 skeleton w-full min-h-[12em] sm:min-w-[15em] sm:h-[30em] bg-gradient-to-t from-green-50 to-transparent dark:from-dark-800">
                                <h4 class="text-transparent bg-clip-text bg-gradient-to-r to-emerald-600 from-sky-700 text-2xl md:text-3xl font-bold"><?php echo $lang['register-domain-feature-ninth'] ?></h4>
                                <svg width="82" height="82" viewBox="0 0 82 82" fill="none" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
                                    <rect width="82" height="82" fill="url(#pattern0)"/>
                                    <defs>
                                        <pattern id="pattern0" patternContentUnits="objectBoundingBox" width="1" height="1">
                                            <use xlink:href="#image0_15_323" transform="scale(0.0138889)"/>
                                        </pattern>
                                        <image id="image0_15_323" width="72" height="72" xlink:href="data:image/png;base64,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"/>
                                    </defs>
                                </svg>
                            </div>
                        </div>
                        <div class="space-y-6">
                            <div class="flex items-center text-center overflow-hidden border border-gray-200 dark:border-gray-700 rounded-3xl p-8 md:p-6 skeleton w-full h-[12em] sm:min-h-[20em] sm:min-w-[10em] bg-gradient-to-tl from-green-50 to-transparent dark:from-dark-800">
                                <h4 class="text-transparent bg-clip-text bg-gradient-to-r to-emerald-600 from-sky-700 text-2xl md:text-3xl font-bold"><?php echo $lang['register-domain-feature-tenth'] ?></h4>
                            </div>
                            <div class="flex items-start text-center overflow-hidden border border-gray-200 dark:border-gray-700 rounded-3xl p-8 md:p-6 skeleton w-full h-[15em] sm:min-h-[40em] sm:min-w-[10em] bg-gradient-to-t from-green-50 to-transparent dark:from-dark-800">
                                <h4 class="text-transparent bg-clip-text bg-gradient-to-r to-emerald-600 from-sky-700 text-2xl md:text-3xl font-bold"><?php echo $lang['register-domain-feature-eleventh'] ?></h4>
                            </div>
                        </div>

                    </div>
                </div>
            </div>
        </section>

        <section id="faqs" class="bg-white dark:bg-dark-900 mb-12">
            <div class="py-8 px-4 mx-auto max-w-screen-md text-center lg:py-16 lg:px-6">
                <div class="mx-auto max-w-screen-sm">
                    <h3 class="mb-4 text-4xl tracking-tight font-bold text-gray-900 dark:text-white"><?php echo $lang['faqs-headline'] ?></h3>
                    <p class="mb-8 font-normal text-gray-500 lg:mb-16 sm:text-xl dark:text-gray-400"><?php echo $lang['faqs-subheading'] ?></p>
                </div>
                <div id="accordion-collapse" data-accordion="collapse" class="divide-y-2 divide-gray-200 dark:divide-dark-600">
                    <?php foreach ($faqSectionDomainRegistration as $index => $faq): ?>
                        <div>
                            <h2 id="accordion-collapse-heading-<?php echo $index + 1; ?>">
                                <button type="button" class="flex items-center justify-between !bg-transparent dark:!bg-transparent w-full p-5 font-medium text-left text-gray-700 focus:ring-0 dark:text-gray-300 hover:bg-gray-100 dark:hover:bg-dark-700" data-accordion-target="#accordion-collapse-body-<?php echo $index + 1; ?>" aria-expanded="false" aria-controls="accordion-collapse-body-<?php echo $index + 1; ?>">
                                    <span><?php echo $faq['question']; ?></span>
                                    <svg data-accordion-icon class="w-3 h-3 rotate-180 shrink-0" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 10 6">
                                        <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5 5 1 1 5"/>
                                    </svg>
                                </button>
                            </h2>
                            <div id="accordion-collapse-body-<?php echo $index + 1; ?>" class="ml-2 hidden !bg-transparent dark:!bg-transparent text-left rounded-xl mb-2 pt-5 px-5 pb-5 mb-6 text-gray-700 dark:text-gray-300 bg-gray-100 dark:bg-dark-700">
                                <?php echo $faq['answer']; ?>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>
            </div>
        </section>
        <div id="domainDinoModal" tabindex="-1" aria-hidden="true" class="fixed top-0 left-0 right-0 z-50 hidden w-full overflow-x-hidden overflow-y-hidden md:inset-0 h-[100%] max-h-full justify-center items-center cssanimation fadeInBottom dark:!bg-dark-800/25 backdrop-blur">
            <div class="sm:relative sm:w-full sm:max-w-4xl sm:max-h-full fixed bottom-0 w-full">
                <!-- Modal content -->
                <div class="relative bg-white sm:rounded-3xl shadow dark:bg-dark-800 rounded-t-[2rem]">
                    <button type="button" class="close-modal absolute top-3 right-2.5 text-gray-400 bg-transparent hover:bg-gray-200 hover:text-gray-900 rounded-full text-sm w-8 h-8 ml-auto inline-flex justify-center items-center dark:hover:bg-dark-600 dark:hover:text-white" data-modal-hide="domainDinoModal">
                        <svg class="w-3 h-3" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 14 14">
                            <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="m1 1 6 6m0 0 6 6M7 7l6-6M7 7l-6 6"/>
                        </svg>
                        <span class="sr-only">Close modal</span>
                    </button>
                    <div class="max-h-[550px] lg:max-h-[100%] overflow-hidden">
                        <div class="flex items-center justify-center text-center h-[25em] md:h-[40em] px-6 py-4 sm:py-10 lg:px-8 mb-4 overflow-y-auto overflow-x-hidden">
                            <div class="dinoDomainIntro bg-gray-50 dark:bg-dark-700 px-6 w-full h-full rounded-3xl">
                                <div class="flex items-center space-x-2 mt-6">
                                    <div class="w-9 h-9 p-1.5 bg-dark-600 overflow-hidden rounded-full">
                                        <svg class="w-6 h-6" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="151px" height="150px" viewBox="0 0 639 636">
                                            <g id="surface1">
                                                <path style=" stroke:none;fill-rule:nonzero;fill-opacity:1;" class="fill-gray-300" d="M 543.414062 80.550781 C 563.308594 100.46875 563.308594 132.765625 543.414062 152.683594 L 155.367188 541.199219 C 135.472656 561.121094 103.214844 561.121094 83.316406 541.199219 C 63.421875 521.28125 63.421875 488.984375 83.316406 469.066406 L 471.371094 80.558594 C 491.257812 60.628906 523.515625 60.628906 543.414062 80.550781 Z M 543.414062 80.550781 "></path>
                                                <path style=" stroke:none;fill-rule:nonzero;fill-opacity:1;" class="fill-gray-300" d="M 350.257812 83.671875 C 370.15625 103.589844 370.15625 135.886719 350.257812 155.804688 L 158.246094 348.046875 C 138.347656 367.964844 106.089844 367.964844 86.195312 348.046875 C 66.296875 328.125 66.296875 295.828125 86.195312 275.910156 L 278.207031 83.671875 C 298.097656 63.75 330.363281 63.75 350.257812 83.671875 Z M 350.257812 83.671875 "></path>
                                                <path style=" stroke:none;fill-rule:nonzero;fill-opacity:1;" class="fill-gray-300" d="M 198.839844 42.324219 C 218.734375 62.242188 218.734375 94.539062 198.839844 114.457031 L 116.90625 196.484375 C 97.011719 216.40625 64.753906 216.40625 44.855469 196.484375 C 24.960938 176.566406 24.960938 144.269531 44.855469 124.351562 L 126.78125 42.324219 C 146.679688 22.402344 178.941406 22.402344 198.839844 42.324219 Z M 198.839844 42.324219 "></path>
                                                <path style=" stroke:none;fill-rule:nonzero;fill-opacity:1;" class="fill-gray-300" d="M 549.855469 263.0625 C 569.75 282.984375 569.75 315.277344 549.855469 335.199219 L 337.238281 548.0625 C 317.34375 567.984375 285.085938 567.984375 265.1875 548.0625 C 245.292969 528.140625 245.292969 495.847656 265.1875 475.925781 L 477.804688 263.0625 C 497.699219 243.140625 529.957031 243.140625 549.855469 263.0625 Z M 549.855469 263.0625 "></path>
                                                <path style=" stroke:none;fill-rule:nonzero;fill-opacity:1;" class="fill-gray-300" d="M 578.785156 423.015625 C 598.683594 442.933594 598.683594 475.230469 578.785156 495.148438 L 496.855469 577.171875 C 476.957031 597.089844 444.699219 597.089844 424.804688 577.171875 C 404.90625 557.25 404.90625 524.953125 424.804688 505.035156 L 506.726562 423.015625 C 526.625 403.085938 558.890625 403.085938 578.785156 423.015625 Z M 578.785156 423.015625 "></path>
                                            </g>
                                        </svg>
                                    </div>
                                    <div class="font-bold"><?php echo $lang['dino']; ?></div>
                                </div>
                                <div class="flex items-center justify-center space-x-1 my-4 md:my-10">
                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor" class="w-6 h-6 text-purple-300 dark:text-purple-400">
                                        <path fill-rule="evenodd" d="M9 4.5a.75.75 0 01.721.544l.813 2.846a3.75 3.75 0 002.576 2.576l2.846.813a.75.75 0 010 1.442l-2.846.813a3.75 3.75 0 00-2.576 2.576l-.813 2.846a.75.75 0 01-1.442 0l-.813-2.846a3.75 3.75 0 00-2.576-2.576l-2.846-.813a.75.75 0 010-1.442l2.846-.813A3.75 3.75 0 007.466 7.89l.813-2.846A.75.75 0 019 4.5zM18 1.5a.75.75 0 01.728.568l.258 1.036c.236.94.97 1.674 1.91 1.91l1.036.258a.75.75 0 010 1.456l-1.036.258c-.94.236-1.674.97-1.91 1.91l-.258 1.036a.75.75 0 01-1.456 0l-.258-1.036a2.625 2.625 0 00-1.91-1.91l-1.036-.258a.75.75 0 010-1.456l1.036-.258a2.625 2.625 0 001.91-1.91l.258-1.036A.75.75 0 0118 1.5zM16.5 15a.75.75 0 01.712.513l.394 1.183c.15.447.5.799.948.948l1.183.395a.75.75 0 010 1.422l-1.183.395c-.447.15-.799.5-.948.948l-.395 1.183a.75.75 0 01-1.422 0l-.395-1.183a1.5 1.5 0 00-.948-.948l-1.183-.395a.75.75 0 010-1.422l1.183-.395c.447-.15.799-.5.948-.948l.395-1.183A.75.75 0 0116.5 15z" clip-rule="evenodd"></path>
                                    </svg>
                                    <h2 class="text-lg md:text-xl text-transparent bg-clip-text bg-gradient-to-r to-cyan-600 from-purple-400"><?php echo $lang['ai-register-domain-superior']; ?></h2>
                                </div>
                                <p class="text-gray-700 dark:text-gray-200 font-semibold text-4xl text-center max-w-sm mx-auto my-8"><?php echo $lang['ai-register-domain-headline']; ?></p>
                                <p class="text-gray-600 dark:text-gray-300 font-normal text-base text-center max-w-sm mx-auto"><?php echo $lang['ai-register-domain-subheading']; ?></p>
                            </div>
                            <div role="status" class="relative dino-domain-generating w-full h-full hidden my-6 p-4 hidden">
                                <div class="dinoGenerating"></div>
                                <div role="status" class="w-full h-full p-4 space-y-4 border border-gray-200 divide-y divide-gray-200 rounded-xl animate-pulse dark:divide-gray-700 md:p-6 dark:border-gray-700">
                                    <div class="flex items-center justify-between">
                                        <div>
                                            <div class="h-2.5 bg-gray-300 rounded-full dark:bg-gray-600 w-24 mb-2.5"></div>
                                            <div class="w-32 h-2 bg-gray-200 rounded-full dark:bg-gray-700"></div>
                                        </div>
                                        <div class="h-2.5 bg-gray-300 rounded-full dark:bg-gray-700 w-12"></div>
                                    </div>
                                    <div class="flex items-center justify-between pt-4">
                                        <div>
                                            <div class="h-2.5 bg-gray-300 rounded-full dark:bg-gray-600 w-24 mb-2.5"></div>
                                            <div class="w-32 h-2 bg-gray-200 rounded-full dark:bg-gray-700"></div>
                                        </div>
                                        <div class="h-2.5 bg-gray-300 rounded-full dark:bg-gray-700 w-12"></div>
                                    </div>
                                    <div class="flex items-center justify-between pt-4">
                                        <div>
                                            <div class="h-2.5 bg-gray-300 rounded-full dark:bg-gray-600 w-24 mb-2.5"></div>
                                            <div class="w-32 h-2 bg-gray-200 rounded-full dark:bg-gray-700"></div>
                                        </div>
                                        <div class="h-2.5 bg-gray-300 rounded-full dark:bg-gray-700 w-12"></div>
                                    </div>
                                    <div class="flex items-center justify-between pt-4">
                                        <div>
                                            <div class="h-2.5 bg-gray-300 rounded-full dark:bg-gray-600 w-24 mb-2.5"></div>
                                            <div class="w-32 h-2 bg-gray-200 rounded-full dark:bg-gray-700"></div>
                                        </div>
                                        <div class="h-2.5 bg-gray-300 rounded-full dark:bg-gray-700 w-12"></div>
                                    </div>
                                    <div class="flex items-center justify-between pt-4">
                                        <div>
                                            <div class="h-2.5 bg-gray-300 rounded-full dark:bg-gray-600 w-24 mb-2.5"></div>
                                            <div class="w-32 h-2 bg-gray-200 rounded-full dark:bg-gray-700"></div>
                                        </div>
                                        <div class="h-2.5 bg-gray-300 rounded-full dark:bg-gray-700 w-12"></div>
                                    </div>
                                    <span class="sr-only">Loading...</span>
                                </div>
                            </div>
                            <div id="suggestion-container" class="w-full h-full hidden">
                                <div class="flex items-center space-x-2">
                                    <div class="w-9 h-9 p-1.5 bg-dark-600 overflow-hidden rounded-full">
                                        <svg class="w-6 h-6" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="151px" height="150px" viewBox="0 0 639 636">
                                            <g id="surface1">
                                                <path style=" stroke:none;fill-rule:nonzero;fill-opacity:1;" class="fill-gray-300" d="M 543.414062 80.550781 C 563.308594 100.46875 563.308594 132.765625 543.414062 152.683594 L 155.367188 541.199219 C 135.472656 561.121094 103.214844 561.121094 83.316406 541.199219 C 63.421875 521.28125 63.421875 488.984375 83.316406 469.066406 L 471.371094 80.558594 C 491.257812 60.628906 523.515625 60.628906 543.414062 80.550781 Z M 543.414062 80.550781 "></path>
                                                <path style=" stroke:none;fill-rule:nonzero;fill-opacity:1;" class="fill-gray-300" d="M 350.257812 83.671875 C 370.15625 103.589844 370.15625 135.886719 350.257812 155.804688 L 158.246094 348.046875 C 138.347656 367.964844 106.089844 367.964844 86.195312 348.046875 C 66.296875 328.125 66.296875 295.828125 86.195312 275.910156 L 278.207031 83.671875 C 298.097656 63.75 330.363281 63.75 350.257812 83.671875 Z M 350.257812 83.671875 "></path>
                                                <path style=" stroke:none;fill-rule:nonzero;fill-opacity:1;" class="fill-gray-300" d="M 198.839844 42.324219 C 218.734375 62.242188 218.734375 94.539062 198.839844 114.457031 L 116.90625 196.484375 C 97.011719 216.40625 64.753906 216.40625 44.855469 196.484375 C 24.960938 176.566406 24.960938 144.269531 44.855469 124.351562 L 126.78125 42.324219 C 146.679688 22.402344 178.941406 22.402344 198.839844 42.324219 Z M 198.839844 42.324219 "></path>
                                                <path style=" stroke:none;fill-rule:nonzero;fill-opacity:1;" class="fill-gray-300" d="M 549.855469 263.0625 C 569.75 282.984375 569.75 315.277344 549.855469 335.199219 L 337.238281 548.0625 C 317.34375 567.984375 285.085938 567.984375 265.1875 548.0625 C 245.292969 528.140625 245.292969 495.847656 265.1875 475.925781 L 477.804688 263.0625 C 497.699219 243.140625 529.957031 243.140625 549.855469 263.0625 Z M 549.855469 263.0625 "></path>
                                                <path style=" stroke:none;fill-rule:nonzero;fill-opacity:1;" class="fill-gray-300" d="M 578.785156 423.015625 C 598.683594 442.933594 598.683594 475.230469 578.785156 495.148438 L 496.855469 577.171875 C 476.957031 597.089844 444.699219 597.089844 424.804688 577.171875 C 404.90625 557.25 404.90625 524.953125 424.804688 505.035156 L 506.726562 423.015625 C 526.625 403.085938 558.890625 403.085938 578.785156 423.015625 Z M 578.785156 423.015625 "></path>
                                            </g>
                                        </svg>
                                    </div>
                                    <div class="font-bold"><?php echo $lang['dino']; ?></div>
                                </div>
                                <h2 class="mb-2 text-2xl font-bold"><?php echo $lang['ai-register-domain-result-headline']; ?></h2>
                                <div id="suggestion-list" class="domain-names-registration w-full h-full"></div>
                            </div>
                        </div>
                        <div class="w-full text-center md:px-6 md:pb-2">
                            <div class="w-full flex justify-center items-center">
                                <form class="ai-domain-suggester relative mx-auto max-w-screen-lg w-[90%] md:w-full justify-center">
                                    <div class="input">
                                        <!-- <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path fill-rule="evenodd" clip-rule="evenodd" d="M16.4983 15C16.6558 14.9999 16.8094 15.0494 16.9372 15.1415C17.065 15.2336 17.1605 15.3636 17.2103 15.513L17.6043 16.696C17.7543 17.143 18.1043 17.495 18.5523 17.644L19.7353 18.039C19.8843 18.089 20.0138 18.1845 20.1055 18.3121C20.1972 18.4397 20.2466 18.5929 20.2466 18.75C20.2466 18.9071 20.1972 19.0603 20.1055 19.1879C20.0138 19.3155 19.8843 19.411 19.7353 19.461L18.5523 19.856C18.1053 20.006 17.7533 20.356 17.6043 20.804L17.2093 21.987C17.1593 22.136 17.0637 22.2655 16.9362 22.3572C16.8086 22.4489 16.6554 22.4983 16.4983 22.4983C16.3412 22.4983 16.188 22.4489 16.0604 22.3572C15.9328 22.2655 15.8373 22.136 15.7873 21.987L15.3923 20.804C15.3186 20.5833 15.1946 20.3827 15.0301 20.2182C14.8656 20.0537 14.665 19.9297 14.4443 19.856L13.2613 19.461C13.1123 19.411 12.9828 19.3155 12.8911 19.1879C12.7994 19.0603 12.75 18.9071 12.75 18.75C12.75 18.5929 12.7994 18.4397 12.8911 18.3121C12.9828 18.1845 13.1123 18.089 13.2613 18.039L14.4443 17.644C14.8913 17.494 15.2433 17.144 15.3923 16.696L15.7873 15.513C15.837 15.3637 15.9324 15.2339 16.06 15.1418C16.1876 15.0497 16.341 15.0001 16.4983 15Z" fill="currentColor"/>
                                        <path fill-rule="evenodd" clip-rule="evenodd" d="M18.0017 1.5C18.169 1.49991 18.3315 1.55576 18.4635 1.65869C18.5954 1.76161 18.6891 1.90569 18.7297 2.068L18.9877 3.104C19.2237 4.044 19.9577 4.778 20.8977 5.014L21.9337 5.272C22.0963 5.31228 22.2408 5.40586 22.344 5.5378C22.4473 5.66974 22.5034 5.83246 22.5034 6C22.5034 6.16754 22.4473 6.33026 22.344 6.4622C22.2408 6.59414 22.0963 6.68772 21.9337 6.728L20.8977 6.986C19.9577 7.222 19.2237 7.956 18.9877 8.896L18.7297 9.932C18.6894 10.0946 18.5958 10.2391 18.4639 10.3423C18.3319 10.4456 18.1692 10.5017 18.0017 10.5017C17.8341 10.5017 17.6714 10.4456 17.5395 10.3423C17.4075 10.2391 17.314 10.0946 17.2737 9.932L17.0157 8.896C16.9003 8.43443 16.6616 8.0129 16.3252 7.67648C15.9888 7.34005 15.5672 7.10139 15.1057 6.986L14.0697 6.728C13.9071 6.68772 13.7626 6.59414 13.6593 6.4622C13.5561 6.33026 13.5 6.16754 13.5 6C13.5 5.83246 13.5561 5.66974 13.6593 5.5378C13.7626 5.40586 13.9071 5.31228 14.0697 5.272L15.1057 5.014C15.5672 4.89861 15.9888 4.65995 16.3252 4.32352C16.6616 3.9871 16.9003 3.56557 17.0157 3.104L17.2737 2.068C17.3143 1.90569 17.408 1.76161 17.5399 1.65869C17.6718 1.55576 17.8344 1.49991 18.0017 1.5Z" fill="currentColor"/>
                                        <path fill-rule="evenodd" clip-rule="evenodd" d="M8.99946 4.5C9.16242 4.50003 9.32094 4.55315 9.45103 4.6513C9.58112 4.74945 9.6757 4.8873 9.72046 5.044L10.5335 7.89C10.7085 8.50292 11.0369 9.0611 11.4876 9.51183C11.9384 9.96255 12.4965 10.291 13.1095 10.466L15.9555 11.279C16.1121 11.3239 16.2498 11.4185 16.3478 11.5486C16.4459 11.6786 16.4989 11.8371 16.4989 12C16.4989 12.1629 16.4459 12.3214 16.3478 12.4514C16.2498 12.5815 16.1121 12.6761 15.9555 12.721L13.1095 13.534C12.4965 13.709 11.9384 14.0374 11.4876 14.4882C11.0369 14.9389 10.7085 15.4971 10.5335 16.11L9.72046 18.956C9.6756 19.1126 9.58098 19.2503 9.4509 19.3484C9.32082 19.4464 9.16235 19.4995 8.99946 19.4995C8.83657 19.4995 8.6781 19.4464 8.54802 19.3484C8.41794 19.2503 8.32332 19.1126 8.27846 18.956L7.46546 16.11C7.29041 15.4971 6.96201 14.9389 6.51129 14.4882C6.06056 14.0374 5.50238 13.709 4.88946 13.534L2.04346 12.721C1.88686 12.6761 1.74913 12.5815 1.65108 12.4514C1.55303 12.3214 1.5 12.1629 1.5 12C1.5 11.8371 1.55303 11.6786 1.65108 11.5486C1.74913 11.4185 1.88686 11.3239 2.04346 11.279L4.88946 10.466C5.50238 10.291 6.06056 9.96255 6.51129 9.51183C6.96201 9.0611 7.29041 8.50292 7.46546 7.89L8.27846 5.044C8.32322 4.8873 8.4178 4.74945 8.54789 4.6513C8.67798 4.55315 8.8365 4.50003 8.99946 4.5Z" fill="currentColor"/>
                                        </svg> -->
                                        <svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path fill-rule="evenodd" clip-rule="evenodd" d="M11.5 6C11.3949 6.00006 11.2925 5.96705 11.2073 5.90565C11.1221 5.84425 11.0583 5.75758 11.0251 5.65792L10.7623 4.86908C10.6623 4.57101 10.4288 4.33629 10.13 4.23693L9.34102 3.97354C9.24166 3.94019 9.1553 3.87649 9.09411 3.79142C9.03292 3.70635 9 3.60421 9 3.49943C9 3.39465 9.03292 3.29252 9.09411 3.20745C9.1553 3.12238 9.24166 3.05867 9.34102 3.02532L10.13 2.76193C10.4282 2.66191 10.663 2.42852 10.7623 2.12979L11.0258 1.34094C11.0591 1.24161 11.1229 1.15526 11.2079 1.09409C11.293 1.03291 11.3952 1 11.5 1C11.6048 1 11.707 1.03291 11.7921 1.09409C11.8771 1.15526 11.9409 1.24161 11.9742 1.34094L12.2377 2.12979C12.2868 2.27697 12.3695 2.4107 12.4792 2.52041C12.589 2.63013 12.7227 2.71281 12.87 2.76193L13.659 3.02532C13.7583 3.05867 13.8447 3.12238 13.9059 3.20745C13.9671 3.29252 14 3.39465 14 3.49943C14 3.60421 13.9671 3.70635 13.9059 3.79142C13.8447 3.87649 13.7583 3.94019 13.659 3.97354L12.87 4.23693C12.5718 4.33696 12.337 4.57034 12.2377 4.86908L11.9742 5.65792C11.9411 5.75747 11.8774 5.84406 11.7923 5.90545C11.7072 5.96684 11.6049 5.99992 11.5 6Z" fill="currentColor"/>
                                            <path fill-rule="evenodd" clip-rule="evenodd" d="M6 13C5.85133 13.0001 5.7069 12.9504 5.58969 12.859C5.47247 12.7675 5.38921 12.6395 5.35313 12.4952L5.12388 11.5745C4.91418 10.7391 4.26198 10.0868 3.42674 9.87703L2.50619 9.64774C2.36169 9.61194 2.23333 9.52878 2.14159 9.41151C2.04985 9.29425 2 9.14964 2 9.00075C2 8.85185 2.04985 8.70724 2.14159 8.58998C2.23333 8.47272 2.36169 8.38955 2.50619 8.35376L3.42674 8.12446C4.26198 7.91473 4.91418 7.2624 5.12388 6.427L5.35313 5.50629C5.38892 5.36176 5.47207 5.23338 5.58931 5.14162C5.70655 5.04986 5.85113 5 6 5C6.14887 5 6.29345 5.04986 6.41069 5.14162C6.52793 5.23338 6.61108 5.36176 6.64687 5.50629L6.87612 6.427C6.97865 6.83721 7.19071 7.21184 7.48965 7.51082C7.78858 7.80981 8.16313 8.02192 8.57326 8.12446L9.49381 8.35376C9.63831 8.38955 9.76667 8.47272 9.85841 8.58998C9.95015 8.70724 10 8.85185 10 9.00075C10 9.14964 9.95015 9.29425 9.85841 9.41151C9.76667 9.52878 9.63831 9.61194 9.49381 9.64774L8.57326 9.87703C8.16313 9.97957 7.78858 10.1917 7.48965 10.4907C7.19071 10.7897 6.97865 11.1643 6.87612 11.5745L6.64687 12.4952C6.61079 12.6395 6.52753 12.7675 6.41031 12.859C6.2931 12.9504 6.14867 13.0001 6 13Z" fill="currentColor"/>
                                            <path fill-rule="evenodd" clip-rule="evenodd" d="M13.5005 23C13.3376 23 13.1791 22.9469 13.049 22.8487C12.9189 22.7505 12.8243 22.6127 12.7795 22.456L11.9665 19.61C11.7915 18.9971 11.4631 18.4389 11.0124 17.9882C10.5616 17.5374 10.0035 17.209 9.39054 17.034L6.54454 16.221C6.38795 16.1761 6.25021 16.0815 6.15216 15.9514C6.05411 15.8214 6.00108 15.6629 6.00108 15.5C6.00108 15.3371 6.05411 15.1786 6.15216 15.0486C6.25021 14.9185 6.38795 14.8239 6.54454 14.779L9.39054 13.966C10.0035 13.791 10.5616 13.4626 11.0124 13.0118C11.4631 12.5611 11.7915 12.0029 11.9665 11.39L12.7795 8.544C12.8244 8.38741 12.919 8.24967 13.0491 8.15162C13.1792 8.05357 13.3376 8.00054 13.5005 8.00054C13.6634 8.00054 13.8219 8.05357 13.952 8.15162C14.0821 8.24967 14.1767 8.38741 14.2215 8.544L15.0345 11.39C15.2096 12.0029 15.538 12.5611 15.9887 13.0118C16.4394 13.4626 16.9976 13.791 17.6105 13.966L20.4565 14.779C20.6131 14.8239 20.7509 14.9185 20.8489 15.0486C20.947 15.1786 21 15.3371 21 15.5C21 15.6629 20.947 15.8214 20.8489 15.9514C20.7509 16.0815 20.6131 16.1761 20.4565 16.221L17.6105 17.034C16.9976 17.209 16.4394 17.5374 15.9887 17.9882C15.538 18.4389 15.2096 18.9971 15.0345 19.61L14.2215 22.456C14.1768 22.6127 14.0822 22.7505 13.9521 22.8487C13.822 22.9469 13.6635 23 13.5005 23Z" fill="currentColor"/>
                                        </svg>
                                        <input id="prompt-textarea" class="block w-full !pr-28 text-sm text-gray-900 rounded-full !text-[16px] bg-gray-100 dark:bg-dark-600 placeholder-gray-800 dark:placeholder-gray-200 dark:text-white overflow-hidden resize-none max-h-56" placeholder="<?php echo $lang['account-dino-prompt-placeholder']; ?>" required>
                                    </div>
                                    <div class="absolute right-2.5 bottom-1.5 md:bottom-2.5 flex items-center space-x-1 mt-0.5">
                                        <button type="submit" id="generate-button" data-tooltip-target="tooltip-send-button" class="flex items-center justify-center w-12 h-12 md:w-10 md:h-10 bg-dark-600 text-sm font-semibold dark:bg-black hover:shadow-2xl transition-all duration-300 hover:scale-105 items-center group space-x-2.5 text-white p-2 rounded-full cursor-pointer">
                                            <svg class="w-6 h-6 text-white" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" width="24" height="24" fill="none" viewBox="0 0 24 24">
                                                <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16.872 9.687 20 6.56 17.44 4 4 17.44 6.56 20 16.873 9.687Zm0 0-2.56-2.56M6 7v2m0 0v2m0-2H4m2 0h2m7 7v2m0 0v2m0-2h-2m2 0h2M8 4h.01v.01H8V4Zm2 2h.01v.01H10V6Zm2-2h.01v.01H12V4Zm8 8h.01v.01H20V12Zm-2 2h.01v.01H18V14Zm2 2h.01v.01H20V16Z"/>
                                            </svg>
                                            <span class="sr-only">Send message</span>
                                        </button>
                                    </div>
                                </form>
                            </div>
                            <p class="text-[10px] md:text-xs font-normal text-gray-600 dark:text-gray-300 my-3"><?php echo $lang['account-dino-footer']; ?></p>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Main modal -->
        <div id="broker-guide-modal" tabindex="-1" aria-hidden="true" class="fixed top-0 left-0 right-0 z-50 items-center justify-center hidden w-full overflow-x-hidden overflow-y-auto md:inset-0 h-[100%] max-h-full cssanimation fadeInBottom dark:!bg-dark-800/25">
            <div class="sm:relative sm:w-full sm:max-w-xl sm:max-h-full fixed bottom-0 w-full">
                <!-- Modal content -->
                <div class="relative bg-white sm:rounded-xl shadow dark:bg-dark-800 rounded-t-[2rem]">
                    <button type="button" class="close-modal absolute top-3 right-2.5 text-gray-400 bg-transparent hover:bg-gray-200 hover:text-gray-900 rounded-xl text-sm w-8 h-8 ml-auto inline-flex justify-center items-center dark:hover:bg-gray-600 dark:hover:text-white" data-modal-hide="broker-guide-modal">
                        <svg class="w-3 h-3" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 14 14">
                            <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="m1 1 6 6m0 0 6 6M7 7l6-6M7 7l-6 6"/>
                        </svg>
                        <span class="sr-only">Close modal</span>
                    </button>
                    <!-- Modal header -->
                    <div class="p-3 md:px-6 py-1 pt-4 md:py-4 rounded-t dark:border-gray-600">
                        <h3 class="text-sm font-bold text-gray-900 lg:text-lg dark:text-white">
                            <?php echo $lang['domain-broker-modal-headline'] ?>
                        </h3>
                    </div>
                    <!-- Modal body -->
                    <div class="p-3 md:px-6 py-0.5 md:py-1">
                        <h3 class="font-bold text-primary-700 text-sm dark:text-primary-300 mb-4"><?php echo $lang['domain-broker-modal-subheading'] ?></h3>
                        <ol class="relative text-gray-500 border-gray-200 dark:border-dark-700 dark:text-gray-400">
                            <li class="mb-3 md:mb-6 flex items-center">
                                <img class="w-12 h-12 md:w-20 md:h-20 rounded-full mr-4" src="<?php echo asset('images/content/domain-broker-agent.jpg')?>" alt="Domain Broker Agent">
                                <span>
                                    <h3 class="font-bold text-sm md:text-lg leading-tight dark:text-white"><?php echo $lang['domain-broker-modal-first-item-heading'] ?></h3>
                                     <p class="text-xs md:text-sm font-medium md:mt-1 md:ml-1 dark:text-gray-300"><?php echo $lang['domain-broker-modal-first-item-subheading'] ?></p>
                               </span>
                            </li>
                            <li class="mb-3 md:mb-6 flex items-center">
                                <span class="!flex items-center justify-center p-4 md:p-8 w-12 h-12 md:w-20 md:h-20 bg-gray-100 rounded-full ring-white dark:ring-gray-900 dark:bg-dark-700 mr-4">
                                    <span class="material-symbols-outlined">
                                    sync_alt
                                    </span>
                                </span>
                                <span>
                                    <h3 class="font-bold text-sm md:text-lg leading-tight dark:text-white"><?php echo $lang['domain-broker-modal-second-item-heading'] ?></h3>
                                     <p class="text-xs md:text-sm font-medium md:mt-1 md:ml-1 dark:text-gray-300"><?php echo $lang['domain-broker-modal-second-item-subheading'] ?></p>
                               </span>
                            </li>
                            <li class="mb-3 md:mb-6 flex items-center">
                                <span class="!flex items-center justify-center p-4 md:p-8 w-12 h-12 md:w-20 md:h-20 bg-gray-100 rounded-full ring-white dark:ring-gray-900 dark:bg-dark-700 mr-4">
                                    <span class="material-symbols-outlined">
                                    language
                                    </span>
                                </span>
                                <span>
                                    <h3 class="font-bold text-sm md:text-lg leading-tight dark:text-white"><?php echo $lang['domain-broker-modal-third-item-heading'] ?></h3>
                                     <p class="text-xs md:text-sm font-medium md:mt-1 md:ml-1 dark:text-gray-300"><?php echo $lang['domain-broker-modal-third-item-subheading'] ?></p>
                               </span>
                            </li>
                        </ol>
                        <div class="flex justify-between items-center my-3 py-3 px-5 h-20 bg-white border border-gray-200 rounded-xl hover:bg-gray-100 dark:bg-dark-700 dark:border-dark-600 dark:hover:bg-dark-700">
                            <div class="flex items-center">
                                <span class="block text-left text-sm text-dark-700 font-medium text-dark-700 mr-4 font-semibold">
                                    <p class="text-sm font-medium text-gray-600 dark:text-gray-300"><?php echo $lang['broker-service-fee'] ?></p>
                                    <p class="broker-service-fee flex items-center justify-start text-left text-lg text-dark-700 font-semibold dark:text-gray-300"></p>
                                    <p class="text-xs font-medium text-gray-500 dark:text-gray-400"><?php echo $lang['broker-service-fee-commission'] ?></p>
                                </span>
                            </div>
                            <div class="flex items-center justify-end">
                                <button data-product-id="11" class="add-to-cart-btn broker-service-details w-full text-white bg-gray-800 hover:bg-gray-900 focus:ring-4 focus:ring-gray-300 font-medium rounded-xl text-sm px-5 py-2.5 dark:bg-dark-600 dark:hover:bg-dark-500 focus:outline-none dark:focus:ring-dark-800" data-domain="" data-tld=""><?php echo $lang['broker-service-cta'] ?></button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php
include_once includes('layouts/footer.php');
?>
<script>
    function showLoading() {
        $('.dinoGenerating').empty();

        const avatar = '<svg class="w-6 h-6" width="328" height="187" viewBox="0 0 650 650" fill="none" xmlns="http://www.w3.org/2000/svg"> <defs> <linearGradient id="gradient-datanito"> <stop offset="0" stop-color="#086FFF"> <animate attributeName="stop-color" values="#086FFF;#FFDDB7;#086FFF" dur="3s" repeatCount="indefinite"></animate> </stop> <stop offset="50%" stop-color="#FFDDB7"> <animate attributeName="offset" values=".5;.2;.5" dur="3.1500000000000004s" repeatCount="indefinite"></animate> </stop> <stop offset="100%" stop-color="#FFDDB7"> <animate attributeName="offset" values="1;.9;1" dur="3.1500000000000004s" repeatCount="indefinite"></animate> <animate attributeName="stop-color" values="#FFDDB7;#086FFF;#FFDDB7" dur="3.1500000000000004s" repeatCount="indefinite"></animate> </stop> <animateTransform attributeName="gradientTransform" type="rotate" from="0 .5 .5" to="360 .5 .5" dur="5.4s" repeatCount="indefinite"></animateTransform> </linearGradient> </defs> <rect x="0" y="0" width="600" height="600" fill="url(#gradient-datanito)" mask="url(#logo-datanito)"></rect> <mask id="logo-datanito"> <path style=" stroke:none;fill-rule:nonzero;fill-opacity:1;" class="fill-gray-300 dark:fill-gray-300" d="M 543.414062 80.550781 C 563.308594 100.46875 563.308594 132.765625 543.414062 152.683594 L 155.367188 541.199219 C 135.472656 561.121094 103.214844 561.121094 83.316406 541.199219 C 63.421875 521.28125 63.421875 488.984375 83.316406 469.066406 L 471.371094 80.558594 C 491.257812 60.628906 523.515625 60.628906 543.414062 80.550781 Z M 543.414062 80.550781 "/> <path style=" stroke:none;fill-rule:nonzero;fill-opacity:1;" class="fill-gray-300 dark:fill-gray-300" d="M 350.257812 83.671875 C 370.15625 103.589844 370.15625 135.886719 350.257812 155.804688 L 158.246094 348.046875 C 138.347656 367.964844 106.089844 367.964844 86.195312 348.046875 C 66.296875 328.125 66.296875 295.828125 86.195312 275.910156 L 278.207031 83.671875 C 298.097656 63.75 330.363281 63.75 350.257812 83.671875 Z M 350.257812 83.671875 "/> <path style=" stroke:none;fill-rule:nonzero;fill-opacity:1;" class="fill-gray-300 dark:fill-gray-300" d="M 198.839844 42.324219 C 218.734375 62.242188 218.734375 94.539062 198.839844 114.457031 L 116.90625 196.484375 C 97.011719 216.40625 64.753906 216.40625 44.855469 196.484375 C 24.960938 176.566406 24.960938 144.269531 44.855469 124.351562 L 126.78125 42.324219 C 146.679688 22.402344 178.941406 22.402344 198.839844 42.324219 Z M 198.839844 42.324219 "/> <path style=" stroke:none;fill-rule:nonzero;fill-opacity:1;" class="fill-gray-300 dark:fill-gray-300" d="M 549.855469 263.0625 C 569.75 282.984375 569.75 315.277344 549.855469 335.199219 L 337.238281 548.0625 C 317.34375 567.984375 285.085938 567.984375 265.1875 548.0625 C 245.292969 528.140625 245.292969 495.847656 265.1875 475.925781 L 477.804688 263.0625 C 497.699219 243.140625 529.957031 243.140625 549.855469 263.0625 Z M 549.855469 263.0625 "/> <path style=" stroke:none;fill-rule:nonzero;fill-opacity:1;" class="fill-gray-300 dark:fill-gray-300" d="M 578.785156 423.015625 C 598.683594 442.933594 598.683594 475.230469 578.785156 495.148438 L 496.855469 577.171875 C 476.957031 597.089844 444.699219 597.089844 424.804688 577.171875 C 404.90625 557.25 404.90625 524.953125 424.804688 505.035156 L 506.726562 423.015625 C 526.625 403.085938 558.890625 403.085938 578.785156 423.015625 Z M 578.785156 423.015625 "/> </mask> </svg>';
        const loadingMessages = [
            "<?php echo $lang['dino-generating-generating'];?>",
            "<?php echo $lang['dino-generating-analyzing'];?>",
            "<?php echo $lang['dino-generating-deep-thinking'];?>",
            "<?php echo $lang['dino-generating-oracle'];?>"
        ];
        const loadingDiv = `
                <div class="overflow-hidden text-left text-sm py-4 px-4 mb-4">
                    <div class="block">
                        <div class="flex items-center space-x-2">
                            <div class="w-9 h-9 p-1.5 bg-dark-600 dark:bg-dark-600 text-gray-800 dark:text-gray-200 overflow-hidden rounded-full">${avatar}</div>
                            <div class="font-bold"><?php echo $lang['dino']; ?></div>
                            <div class="dino-generating-status flex">
                                <div class="vl border-0.5 h-5 border-gray-200 dark:border-dark-500 mr-2 ml-0"></div>
                                <p id="loading-message">${loadingMessages[0]}</p>
                            </div>
                        </div>
                    </div>
                    <span class="block text-left mt-3">
                        <p class="headline text-lg font-medium text-gray-700 dark:text-gray-200"></p>
                        <p class="subheading font-light text-gray-600 dark:text-gray-300"></p>
                    </span>
                </div>
            `;
        $('.dinoGenerating').append(loadingDiv);
        loadTips();
        let index = 1;
        const messageInterval = setInterval(() => {
            if (index < loadingMessages.length) {
                document.getElementById('loading-message').innerText = loadingMessages[index];
                index++;
            } else {
                clearInterval(messageInterval);
            }
        }, 4000); // Change interval here (milliseconds)
    }

    function loadTips() {
        $.ajax({
            type: "POST",
            url: "/get-domain-tips",
            dataType: "json",
            success: function (data) {
                // Update HTML content with fetched data
                $(".headline").text(data[0]);
                $(".subheading").text(data[1]);
            },
            error: function (error) {
                console.error("Error fetching product data:", error);
            },
        });
    }

    // Call the function when the search button is clicked
    $("#generate-button").click(function() {
        loadTips();
        showLoading();
    });

    $("#checkButton").click(function() {
        loadTips();
        showLoading();
    });

    $(".ai-domain-suggester").on("submit", function(event) {
        loadTips();
        showLoading();
    });
    $("#domainSearchForm").on("submit", function(event) {
        loadTips();
        showLoading();
    });


    function loadProducts() {
        var brokerService = $('.broker-service-details');
        $.ajax({
            type: "POST",
            url: "/get_products",
            dataType: "json",
            data: { category: "domain-broker" },
            success: function (data) {
                if (data && Array.isArray(data) && data.length > 0) {
                    var product = data[0]; // Assuming the product data is in the first element of the array
                    if (product && product.price !== undefined) {
                        $(".broker-service-fee").text(product.price);
                        console.log("Product data loaded successfully:", product);
                    } else {
                        console.error("Invalid or missing 'price' field in the response:", product);
                    }
                } else {
                    console.error("Invalid or missing data in the response:", data);
                }
            },
            error: function (error) {
                console.error("Error fetching product data:", error);
            },
        });
    }
    loadProducts();
</script>
