<?php
$meta = array(
    'us' => array(
        'title' => 'Contact - How to Contact Us - Datanito',
        'description' => 'Get in touch with Datanito for expert solutions. Contact our support team for assistance and inquiries.',
        'og:title' => 'Contact - How to Contact Us - Datanito',
        'og:description' => 'Connect with Datanito for inquiries and support. Reach out to us to explore our services and solutions.',
        'og:image' => asset('images/brand/open_graph_logo.png'),
    ),
    'tr' => array(
        'title' => 'İletişim - Bizimle Nasıl İletişime Geçilir - Datanito',
        'description' => 'Uzman çözümler için Datanito ile iletişime geçin. Destek ekibimize sorularınız için veya yardım almak için iletişime geçin.',
        'og:title' => 'İletişim - Bizimle Nasıl İletişime Geçilir - Datanito',
        'og:description' => 'Sorularınız ve destek için Datanito ile iletişime geçin. Hizmetlerimizi ve çözümlerimizi keşfetmek için bize ulaşın.',
        'og:image' => asset('images/brand/open_graph_logo.png'),
    ),
);
$currentMeta = setCountryAndMeta($meta);
include_once includes('layouts/header.php');
?>
    <div id="content" class="container mx-auto lg:mt-12 mt-12">
        <section id="submit-form-area" class="bg-white mt-12 dark:bg-dark-900">
            <div class="mx-auto max-w-screen-xl">
                <div class="p-4 md:p-6 pt-8 flex items-center">
                    <div class="block sm:flex space-x-8">
                        <div class="space-y-8 w-full sm:w-[65%] mr-0 sm:mr-8">
                            <div class="flex items-center bg-gray-50 dark:bg-dark-800 border border-gray-200 dark:border-gray-700 rounded-3xl p-8 md:p-6 skeleton min-h-[10rem] sm:h-[47%]">
                                <div class="space-y-6">
                                    <h1 class="text-dark-600 dark:text-white text-2xl md:text-4xl font-bold mb-2"><?php echo $lang['contact-us-headline'] ?></h1>
                                    <div class="flex justify-between items-start gap-4">
                                        <h3 class="text-lg font-normal text-gray-500 dark:text-gray-400"><?php echo $lang['contact-us-subheading'] ?></h3>
                                        <span class="material-symbols-outlined text-9xl text-gray-400 rotate-[30deg] opacity-25">contact_support</span>
                                    </div>
                                </div>
                            </div>
                            <div class="grid md:grid-cols-2 space-y-4 sm:space-y-0 sm:space-x-8 sm:h-[47%]">
                                <div class="flex items-center bg-gray-50 dark:bg-dark-800 border border-gray-200 dark:border-gray-700 rounded-3xl p-8 md:p-6 skeleton min-h-[10rem]">
                                    <div>
                                        <h2 class="text-gray-600 dark:text-white text-xl md:text-2xl font-bold mb-2"><?php echo $lang['support-request-heading'] ?></h2>
                                        <div class="flex-1 flex flex-col justify-between items-start gap-4">
                                            <p class="text-lg font-normal text-gray-500 dark:text-gray-400"><?php echo $lang['support-request-subheading'] ?></p>
                                            <a class="text-blue-600 dark:text-blue-400 hover:text-blue-500 hover:underline" href="<?php echo url('/account/support/requests');?>"><?php echo $lang['support-request-cta'] ?></a>
                                        </div>
                                    </div>
                                </div>
                                <div class="flex items-center bg-gray-50 dark:bg-dark-800 border border-gray-200 dark:border-gray-700 rounded-3xl p-8 md:p-6 skeleton min-h-[10rem]">
                                    <div>
                                        <h2 class="text-gray-600 dark:text-white text-xl md:text-2xl font-bold mb-2"><?php echo $lang['email-heading'] ?></h2>
                                        <div class="flex-1 flex flex-col justify-between items-start gap-4">
                                            <p class="text-lg font-normal text-gray-500 dark:text-gray-400"><?php echo $lang['email-subheading'] ?></p>
                                            <a class="text-blue-600 dark:text-blue-400 hover:text-blue-500 hover:underline" href="mailto:<?php echo $lang['datanito-email'] ?>"><?php echo $lang['datanito-email'] ?></a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div id="apply-form" class="flex overflow-hidden bg-gray-50 dark:bg-dark-800 p-5 border border-gray-200 dark:border-gray-700 rounded-3xl w-full sm:w-[35%] mt-8 sm:mt-0 !mx-auto skeleton">
                            <form class="submit-application space-y-2 lg:space-y-6 ">
                                <h3 class="mb-0.5 text-xl font-bold text-gray-900 dark:text-white"><?php echo $lang['contact-us-form-heading'] ?></h3>
                                <span class="mb-1 text-sm font-normal text-gray-700 dark:text-gray-300"><?php echo $lang['contact-us-form-subheading'] ?></span>
                                <?php set_csrf(); ?>
                                <input type="hidden" id="selected-package" name="selected_package" value="">
                                <input type="hidden" id="lead-source" name="lead_source" value="<?php echo $lang['contact-us'] ?>">
                                <div class="relative">
                                    <input type="text" id="name-input" class="block px-2.5 pb-2.5 pt-4 w-full text-sm text-gray-900 bg-transparent rounded-lg border-1 border-gray-300 appearance-none dark:text-white dark:border-gray-600 dark:focus:border-blue-500 focus:outline-none focus:ring-0 focus:border-blue-600 peer" placeholder=" " required/>
                                    <label for="name-input" class="absolute text-sm text-gray-500 dark:text-gray-400 duration-300 transform -translate-y-4 scale-75 top-2 z-10 origin-[0] bg-gray-50 dark:bg-dark-800 px-2 peer-focus:px-2 peer-focus:text-blue-600 peer-focus:dark:text-blue-500 peer-placeholder-shown:scale-100 peer-placeholder-shown:-translate-y-1/2 peer-placeholder-shown:top-1/2 peer-focus:top-2 peer-focus:scale-75 peer-focus:-translate-y-4 left-1"><?php echo $lang['full-name']; ?> <span class="text-[12px]">(<?php echo $lang['required']; ?>)</span></label>
                                </div>
                                <div class="relative">
                                    <input type="text" id="email-input" class="block px-2.5 pb-2.5 pt-4 w-full text-sm text-gray-900 bg-transparent rounded-lg border-1 border-gray-300 appearance-none dark:text-white dark:border-gray-600 dark:focus:border-blue-500 focus:outline-none focus:ring-0 focus:border-blue-600 peer" placeholder=" " required/>
                                    <label for="email-input" class="absolute text-sm text-gray-500 dark:text-gray-400 duration-300 transform -translate-y-4 scale-75 top-2 z-10 origin-[0] bg-gray-50 dark:bg-dark-800 px-2 peer-focus:px-2 peer-focus:text-blue-600 peer-focus:dark:text-blue-500 peer-placeholder-shown:scale-100 peer-placeholder-shown:-translate-y-1/2 peer-placeholder-shown:top-1/2 peer-focus:top-2 peer-focus:scale-75 peer-focus:-translate-y-4 left-1"><?php echo $lang['email']; ?> <span class="text-[12px]">(<?php echo $lang['required']; ?>)</span></label>
                                </div>
                                <div class="relative">
                                    <input type="text" id="phone-number-input" class="block px-2.5 pb-2.5 pt-4 w-full text-sm text-gray-900 bg-transparent rounded-lg border-1 border-gray-300 appearance-none dark:text-white dark:border-gray-600 dark:focus:border-blue-500 focus:outline-none focus:ring-0 focus:border-blue-600 peer" placeholder=" " required/>
                                    <label for="phone-number-input" class="absolute text-sm text-gray-500 dark:text-gray-400 duration-300 transform -translate-y-4 scale-75 top-2 z-10 origin-[0] bg-gray-50 dark:bg-dark-800 px-2 peer-focus:px-2 peer-focus:text-blue-600 peer-focus:dark:text-blue-500 peer-placeholder-shown:scale-100 peer-placeholder-shown:-translate-y-1/2 peer-placeholder-shown:top-1/2 peer-focus:top-2 peer-focus:scale-75 peer-focus:-translate-y-4 left-1"><?php echo $lang['phone-number']; ?> <span class="text-[12px]">(<?php echo $lang['required']; ?>)</span></label>
                                </div>
                                <div class="relative hidden">
                                    <select id="submit-reasons" class="block w-full p-3 text-sm text-gray-500 border border-gray-300 rounded-lg bg-white focus:ring-blue-500 focus:border-blue-500 dark:bg-dark-800 dark:border-gray-600 dark:placeholder-gray-400 dark:text-gray-400 dark:focus:ring-blue-500 dark:focus:border-blue-500" required>
                                        <option><?php echo $lang['choose-reason']; ?> <span class="text-[12px]">(<?php echo $lang['required']; ?>)</span></option>
                                        <option value="web-design"><?php echo $lang['web-design']; ?></option>
                                        <option value="seo"><?php echo $lang['seo']; ?></option>
                                        <option value="app-development"><?php echo $lang['app-development']; ?></option>
                                        <option value="advertising"><?php echo $lang['advertising']; ?></option>
                                        <option value="digital-marketing"><?php echo $lang['digital-marketing']; ?></option>
                                        <option value="contact" selected><?php echo $lang['contact']; ?></option>
                                        <option value="other"><?php echo $lang['other']; ?></option>
                                    </select>
                                </div>
                                <div class="relative">
                                    <label for="message-input" class="absolute text-sm text-gray-500 dark:text-gray-400 duration-300 transform -translate-y-4 scale-75 top-2 z-10 origin-[0] bg-gray-50 dark:bg-dark-800 px-2 peer-focus:px-2 peer-focus:text-blue-600 peer-focus:dark:text-blue-500 peer-placeholder-shown:scale-100 peer-placeholder-shown:-translate-y-1/2 peer-placeholder-shown:top-1/2 peer-focus:top-2 peer-focus:scale-75 peer-focus:-translate-y-4 left-1"><?php echo $lang['your-message']; ?></label>
                                    <textarea id="message-input" rows="3" class="block px-2.5 pb-2.5 pt-4 w-full text-sm text-gray-900 bg-transparent rounded-lg border-1 border-gray-300 appearance-none dark:text-white dark:border-gray-600 dark:focus:border-blue-500 focus:outline-none focus:ring-0 focus:border-blue-600 peer resize-none" placeholder=" " ></textarea>
                                </div>
                                <div class="flex items-center mb-4 hidden">
                                    <input id="promotional-offers" type="checkbox" value="" class="w-4 h-4 text-blue-600 bg-gray-50 border-gray-300 rounded focus:ring-blue-500 dark:focus:ring-blue-600 dark:ring-offset-gray-800 dark:focus:ring-offset-gray-800 focus:ring-2 dark:bg-dark-800 dark:border-gray-600">
                                    <label for="promotional-offers" class="ml-2 text-sm font-medium text-gray-900 dark:text-gray-300"><?php echo $lang['promotional-offers']; ?> <span class="text-[12px]">(<?php echo $lang['exclusive-offers']; ?>)</span></label>
                                </div>
                                <div class="relative hidden">
                                    <input type="text" id="honeypot" name="honeypot" value="">
                                </div>
                                <div class="flex justify-center sm:justify-start">
                                    <button id="apply-form-btn" type="submit" class="text-white bg-blue-700 hover:bg-blue-800 focus:ring-4 focus:ring-blue-300 font-medium rounded-3xl text-sm px-12 py-3 sm:px-5 sm:py-2.5 mr-2 sm:mb-2 dark:bg-blue-600 dark:hover:bg-blue-700 focus:outline-none dark:focus:ring-blue-800"><?php echo $lang['apply-now']; ?></button>
                                </div>
                                <p class="text-sm !mt-1 text-gray-500 dark:text-gray-400"><?php echo $lang['form-privacy']; ?></p>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <section class="mx-auto max-w-screen-xl bg-white dark:bg-dark-900 my-12">
           <div class="mx-6 md:mx-12">
               <div class="grid grid-cols-1 md:grid-cols-2 space-y-12">
                   <div class="mx-auto max-w-screen-sm space-y-12 md:mr-16">
                       <div>
                           <h3 class="mb-4 text-2xl tracking-tight font-semibold text-black dark:text-white"><?php echo $lang['datanito-store-heading']; ?></h3>
                           <p class="font-normal text-black sm:text-lg dark:text-gray-200"><?php echo $lang['datanito-store-subheading']; ?></p>
                       </div>
                       <div>
                           <h3 class="mb-4 text-2xl tracking-tight font-semibold text-black dark:text-white"><?php echo $lang['how-to-buy-education-heading']; ?></h3>
                           <p class="font-normal text-black sm:text-lg dark:text-white"><?php echo $lang['how-to-buy-education-subheading']; ?></p>
                           <ul class="mt-3 list-disc md:ml-5 space-y-4">
                               <li class="font-normal text-black sm:text-lg dark:text-white"><?php echo $lang['for-students-and-teachers']; ?></li>
                               <li class="font-normal text-black sm:text-lg dark:text-white"><?php echo $lang['for-educational-institutions']; ?></li>
                           </ul>
                           <p class="mt-6 font-normal text-black sm:text-lg dark:text-white"><?php echo $lang['how-to-buy-education-additional']; ?></p>
                       </div>
                   </div>
                   <div class="mx-auto max-w-screen-sm space-y-12 sm:!mt-0 md:ml-16">
                       <div>
                           <h3 class="mb-4 text-2xl tracking-tight font-semibold text-black dark:text-white"><?php echo $lang['open-support-heading']; ?></h3>
                           <p class="font-normal text-black sm:text-lg dark:text-white"><?php echo $lang['open-support-subheading']; ?></p><a class="text-blue-600 dark:text-blue-400 hover:text-blue-500 hover:underline" href="<?php echo url('/account/support/requests');?>"><?php echo $lang['open-support-link']; ?></a>
                       </div>
                       <div>
                           <h3 class="mb-4 text-2xl tracking-tight font-semibold text-black dark:text-white"><?php echo $lang['corporate-government-heading']; ?></h3>
                           <p class="font-normal text-black sm:text-lg dark:text-white"><?php echo $lang['corporate-government-subheading']; ?></p>
                           <ul class="mt-3 list-disc md:ml-5">
                               <li class="font-normal text-black sm:text-lg dark:text-white"><?php echo $lang['datanito-enterprise-sales']; ?></li>
                               <li class="font-normal text-black sm:text-lg dark:text-white"><?php echo $lang['datanito-government-sales']; ?></li>
                           </ul>
                           <p class="mt-6 font-normal text-black sm:text-lg dark:text-white"><?php echo $lang['corporate-government-additional']; ?></p>
                       </div>

                   </div>
               </div>
           </div>
        </section>
        <section class="bg-white dark:bg-dark-900 mb-12">
            <div class="py-8 px-4 mx-auto max-w-screen-md text-center lg:py-16 lg:px-6">
                <div class="mx-auto max-w-screen-sm">
                    <h3 class="mb-4 text-4xl tracking-tight font-bold text-gray-900 dark:text-white"><?php echo $lang['faqs-headline'] ?></h3>
                    <p class="mb-8 font-normal text-gray-500 lg:mb-16 sm:text-xl dark:text-gray-400"><?php echo $lang['faqs-subheading'] ?></p>
                </div>
                <div id="accordion-collapse" data-accordion="collapse" class="divide-y-2 divide-gray-200 dark:divide-dark-600">
                    <?php foreach ($faqSectionContactUs as $index => $faq): ?>
                        <div>
                            <h2 id="accordion-collapse-heading-<?php echo $index + 1; ?>">
                                <button type="button" class="flex items-center justify-between !bg-transparent dark:!bg-transparent w-full p-5 font-medium text-left text-gray-700 focus:ring-0 dark:text-gray-300 hover:bg-gray-100 dark:hover:bg-dark-700" data-accordion-target="#accordion-collapse-body-<?php echo $index + 1; ?>" aria-expanded="false" aria-controls="accordion-collapse-body-<?php echo $index + 1; ?>">
                                    <span><?php echo $faq['question']; ?></span>
                                    <svg data-accordion-icon class="w-3 h-3 rotate-180 shrink-0" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 10 6">
                                        <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5 5 1 1 5"/>
                                    </svg>
                                </button>
                            </h2>
                            <div id="accordion-collapse-body-<?php echo $index + 1; ?>" class="ml-2 hidden !bg-transparent dark:!bg-transparent text-left rounded-xl mb-2 pt-5 px-5 pb-5 mb-6 text-gray-700 dark:text-gray-300 bg-gray-100 dark:bg-dark-700">
                                <?php echo $faq['answer']; ?>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>
            </div>
        </section>

    </div>

<?php
include_once includes('layouts/footer.php');
?>