<?php
$slug = $id;
include_once includes('config.php');

global $title, $description, $icon, $notFound;

function getBlogMeta($slug, $conn) {
    global $title, $description, $icon, $notFound;

    $query = "SELECT name, description, icon FROM blog_categories WHERE slug = ?";
    $stmt = $conn->prepare($query);
    $stmt->bind_param("s", $slug);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result && $result->num_rows > 0) {
        $metaData = $result->fetch_assoc();

        $title = $metaData['name'];
        $description = $metaData['description'];
        $icon = $metaData['icon'];

        return array(
            'title' => $metaData['name'],
            'description' => $metaData['description'],
            'icon' => $metaData['icon'],
            'og_title' => $metaData['name'],
            'og_description' => $metaData['description'],
            'og_image' => asset('images/brand/open_graph_logo.png'),
        );
    } else {
        // Category not available, handle the error
        $notFound = true;
        return array(
            'title' => '404 - Category Not Found',
            'description' => 'The requested category could not be found.',
            'og_title' => '404 - Category Not Found',
            'og_description' => 'The requested category could not be found.',
            'og_image' => asset('images/brand/open_graph_logo.png'),
        );
    }
}

$currentMeta = getBlogMeta($slug, $conn);

include_once includes('layouts/header.php');
?>
<div id="content" class="container mx-auto lg:mt-5 mt-10">
    <section class="bg-white dark:bg-dark-900">
        <section class="bg-dark-950 dark:bg-dark-800 mt-8 skeleton">
            <div class="py-6 px-4 mx-auto max-w-screen-xl text-center pb-0 lg:pt-12 lg:px-4 h-[20em] sm:h-[25em] overflow-hidden">
                <?php if ($notFound): ?>
                    <div class="container mx-auto mt-10 text-center">
                        <div class="flex justify-center mb-6">
                            <span class="material-symbols-outlined text-5xl text-green-400">error</span>
                        </div>
                        <div class="flex justify-center mb-2 mt-4 items-center mb-4">
                            <h1 class="text-4xl tracking-tight font-bold text-white dark:text-white"><?php echo $lang['category-not-found-headline'];?></h1>
                        </div>
                        <div class="mb-8 mx-auto">
                            <h2 class="text-lg tracking-tight font-normal text-white dark:text-white"><?php echo $lang['category-not-found-subheading'];?></h2>
                        </div>
                        <div class="mb-8 mx-auto">
                            <a href="<?php echo url('/blog')?>" class="text-blue-500 hover:underline"><?php echo $lang['category-not-found-cta'];?></a>
                        </div>
                    </div>
                <?php else: ?>
                <div class="flex justify-center mb-6">
                    <span class="material-symbols-outlined text-5xl text-green-400"><?php echo $icon;?></span>
                </div>
                <div class="flex justify-center mb-2 mt-4 items-center mb-4">
                    <h1 class="text-4xl tracking-tight font-bold text-white"><?php echo $title;?></h1>
                </div>
                <div class="mb-8 sm:w-[70%] mx-auto">
                    <h2 class="text-lg tracking-tight font-normal text-gray-200"><?php echo $description;?></h2>
                </div>
                <?php endif; ?>
            </div>
        </section>
        <div class="py-8 px-4 mx-auto max-w-screen-xl lg:py-16 lg:px-6">
            <div class="blogArchiveContainer grid gap-8 lg:grid-cols-2">
            </div>
            <div class="text-center mx-auto">
                <div role="status" class="spinner hidden my-6">
                    <svg aria-hidden="true" class="inline w-20 h-20 mr-2 text-gray-200 animate-spin dark:text-gray-600 fill-green-500" viewBox="0 0 100 101" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M100 50.5908C100 78.2051 77.6142 100.591 50 100.591C22.3858 100.591 0 78.2051 0 50.5908C0 22.9766 22.3858 0.59082 50 0.59082C77.6142 0.59082 100 22.9766 100 50.5908ZM9.08144 50.5908C9.08144 73.1895 27.4013 91.5094 50 91.5094C72.5987 91.5094 90.9186 73.1895 90.9186 50.5908C90.9186 27.9921 72.5987 9.67226 50 9.67226C27.4013 9.67226 9.08144 27.9921 9.08144 50.5908Z" fill="currentColor"/>
                        <path d="M93.9676 39.0409C96.393 38.4038 97.8624 35.9116 97.0079 33.5539C95.2932 28.8227 92.871 24.3692 89.8167 20.348C85.8452 15.1192 80.8826 10.7238 75.2124 7.41289C69.5422 4.10194 63.2754 1.94025 56.7698 1.05124C51.7666 0.367541 46.6976 0.446843 41.7345 1.27873C39.2613 1.69328 37.813 4.19778 38.4501 6.62326C39.0873 9.04874 41.5694 10.4717 44.0505 10.1071C47.8511 9.54855 51.7191 9.52689 55.5402 10.0491C60.8642 10.7766 65.9928 12.5457 70.6331 15.2552C75.2735 17.9648 79.3347 21.5619 82.5849 25.841C84.9175 28.9121 86.7997 32.2913 88.1811 35.8758C89.083 38.2158 91.5421 39.6781 93.9676 39.0409Z" fill="currentFill"/>
                    </svg>
                    <span class="sr-only">Loading...</span>
                </div>
            </div>
        </div>
    </section>
</div>

<?php
include_once includes('layouts/footer.php');
?>

<script>
    $(document).ready(function() {
        const blogArchive = $('.blogArchiveContainer');
        $('.spinner').show();

        // Fetch and display blog archive using AJAX
        $.ajax({
            type: 'POST',
            url: '/blog-fetch-archive',
            data: { category: '<?php echo $slug;?>',},
            dataType: 'json',
            success: function(response) {
                $('.spinner').hide();
                console.log(response);
                // Function to calculate reading time
                function calculateReadingTime(content) {
                    // Assuming average reading speed is 200 words per minute
                    const wordsPerMinute = 200;
                    const words = content.split(' ').length;
                    const minutes = Math.ceil(words / wordsPerMinute);
                    return minutes;
                }
                if (response.length === 0) {
                    $('.empty-message').removeClass('hidden');
                } else {
                    blogArchive.empty();

                    $.each(response, function(index, blog) {
                        // Format the currency amount based on your requirement
                        function formatCreatedAt(updated_at) {
                            const date = new Date(updated_at);
                            const options = { year: 'numeric', month: 'long', day: 'numeric' };

                            // Calculate the difference in milliseconds between the current time and the blog post creation time
                            const timeDifference = Date.now() - date.getTime();

                            // Define time intervals in milliseconds
                            const minute = 60 * 1000;
                            const hour = 60 * minute;
                            const day = 24 * hour;
                            const month = 30 * day;
                            const year = 365 * day;

                            const seconds = Math.floor(timeDifference / 1000);
                            const minutes = Math.floor(timeDifference / minute);
                            const hours = Math.floor(timeDifference / hour);
                            const days = Math.floor(timeDifference / day);
                            const months = Math.floor(timeDifference / month);
                            const years = Math.floor(timeDifference / year);

                            let timeAgo;

                            if (timeDifference < minute) {
                                timeAgo = (seconds > 1 ? '<?php echo $lang['d-seconds-ago']; ?>'.replace('%d', seconds) : '<?php echo $lang['d-second-ago']; ?>'.replace('%d', seconds));
                            } else if (timeDifference < hour) {
                                timeAgo = (minutes > 1 ? '<?php echo $lang['d-minutes-ago']; ?>'.replace('%d', minutes) : '<?php echo $lang['d-minute-ago']; ?>'.replace('%d', minutes));
                            } else if (timeDifference < day) {
                                timeAgo = (hours > 1 ? '<?php echo $lang['d-hours-ago']; ?>'.replace('%d', hours) : '<?php echo $lang['d-hour-ago']; ?>'.replace('%d', hours));
                            } else if (timeDifference < month) {
                                timeAgo = (days > 1 ? '<?php echo $lang['d-days-ago']; ?>'.replace('%d', days) : '<?php echo $lang['d-day-ago']; ?>'.replace('%d', days));
                            } else if (timeDifference < year) {
                                timeAgo = (months > 1 ? '<?php echo $lang['d-months-ago']; ?>'.replace('%d', months) : '<?php echo $lang['d-month-ago']; ?>'.replace('%d', months));
                            } else {
                                timeAgo = (years > 1 ? '<?php echo $lang['d-years-ago']; ?>'.replace('%d', years) : '<?php echo $lang['d-year-ago']; ?>'.replace('%d', years));
                            }

                            return timeAgo;
                        }

                        const readingTime = calculateReadingTime(blog.content);

                        const formattedCreatedAt = formatCreatedAt(blog.updated_at);
                        const readingTimeDisplay = `<?php echo $lang['x-min-read']; ?>`.replace('%d', readingTime);
                        const blogRow = $("<article class='p-6 bg-white rounded-3xl border border-gray-200 dark:bg-dark-700 dark:border-dark-600'>");
                        blogRow.html(`
                        <div class="photo-container w-full h-36 mb-4 rounded-3xl">
                            ${blog.main_photo ? `<img class="w-full h-36 rounded-3xl object-cover border-2 border-gray-100 dark:border-dark-600" src="<?php echo asset('uploads/blog/${blog.main_photo}')?>" alt="${blog.title}" />` : '<div class="flex items-center justify-center bg-gray-100 dark:bg-dark-600 w-full h-36 rounded-3xl"><span class="material-symbols-outlined text-gray-300 dark:text-dark-500">no_photography</span></div>'}
                        </div>
                        <div class="flex justify-between items-center mb-5 text-gray-500">
                            <span>
                                ${readingTimeDisplay}
                            </span>
                        <time pubdate datetime="${blog.updated_at}" title="${formattedCreatedAt}">${formattedCreatedAt}</time>
                        </div>
                        <h2 class="mb-2 text-2xl font-bold tracking-tight text-gray-900 dark:text-white">
                            <a href="#">${blog.title}</a>
                        </h2>
                        <p class="mb-5 font-light text-gray-500 dark:text-gray-400 overflow-hidden">${blog.short_content}</p>
                        <div class="flex justify-between items-center">
                            <div class="flex items-center">
                                <img class="relative inline-flex w-9 h-9 overflow-hidden rounded-full mr-2" src="<?php echo asset('uploads/profile_pictures/${blog.author_avatar}')?>" alt="${blog.author_name}">
                                <span class="font-medium dark:text-white">${blog.author_name}</span>
                                ${blog.author_verification_badge_html}
                            </div>
                            <a href="<?php echo url('/blog/${blog.slug}')?>" class="inline-flex items-center text-white bg-blue-700 hover:bg-blue-800 focus:outline-none focus:ring-4 focus:ring-blue-300 font-medium rounded-full text-sm px-3 py-3 text-center me-2 mb-2 dark:bg-blue-600 dark:hover:bg-blue-700 dark:focus:ring-blue-800">
                                <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 20 20" xmlns="http://www.w3.org/2000/svg">
                                    <path fill-rule="evenodd" d="M10.293 3.293a1 1 0 011.414 0l6 6a1 1 0 010 1.414l-6 6a1 1 0 01-1.414-1.414L14.586 11H3a1 1 0 110-2h11.586l-4.293-4.293a1 1 0 010-1.414z" clip-rule="evenodd"></path>
                                </svg>
                            </a>
                        </div>
                    `);

                        // Append the row to the blog list
                        blogArchive.append(blogRow);
                    });
                }
            },
            error: function(xhr, status, error) {
                console.log(error);
            }
        });
    });

</script>
