<?php
$meta = array(
    'us' => array(
        'title' => 'Datanito - Send SMS',
        'description' => 'Send SMS messages through Datanito\'s reliable messaging platform.',
        'og:title' => 'Datanito - Send SMS',
        'og:description' => 'Send SMS messages through Datanito\'s reliable messaging platform.',
        'og:image' => asset('images/brand/open_graph_logo.png'),
    ),
    'tr' => array(
        'title' => 'Datanito - SMS Gönder',
        'description' => 'Datanito güvenilir mesajlaşma platformu üzerinden SMS gönderin.',
        'og:title' => 'Datanito - SMS Gönder',
        'og:description' => 'Datanito güvenilir mesajlaşma platformu üzerinden SMS gönderin.',
        'og:image' => asset('images/brand/open_graph_logo.png'),
    ),
);
$currentMeta = setCountryAndMeta($meta);
include_once includes('layouts/dashboard.php');
?>

<main class="p-4 md:pl-72 md:ml-8 md:mr-4 h-full pt-20 min-h-[70em] overflow-hidden bg-gray-50 dark:bg-dark-800">
    <div class="max-w-4xl mx-auto">
        <!-- Page Header -->
        <div class="flex justify-between items-center mb-6">
            <div>
                <h1 class="text-2xl font-bold text-gray-900 dark:text-white"><?php echo $lang['send-sms-title']; ?></h1>
                <p class="text-gray-600 dark:text-gray-400"><?php echo $lang['send-sms-subtitle']; ?></p>
            </div>
            <div class="flex items-center space-x-3">
                <a href="<?php echo url('/account/sms/history'); ?>" class="flex items-center text-sm font-medium px-4 py-2 bg-gray-200 hover:bg-gray-300 dark:bg-dark-700 dark:hover:bg-dark-600 text-gray-700 dark:text-gray-300 rounded-lg transition-colors">
                    <span class="material-symbols-outlined mr-1 text-base">history</span>
                    <?php echo $lang['sms-history']; ?>
                </a>
            </div>
        </div>

        <!-- SMS Form Card -->
        <div class="rounded-xl bg-white dark:bg-dark-700 border border-gray-200 dark:border-dark-600 p-6 shadow-sm mb-6">
            <form id="smsForm" method="POST">
                <?php set_csrf(); ?>

                <!-- Phone Number Input -->
                <div class="mb-6">
                    <label for="phone-number" class="block mb-2 text-sm font-medium text-gray-900 dark:text-white">
                        <?php echo $lang['recipient-phone']; ?>
                        <span class="text-red-500">*</span>
                    </label>
                    <div class="relative">
                        <div class="absolute inset-y-0 left-0 flex items-center pl-3 pointer-events-none">
                            <span class="material-symbols-outlined text-gray-500 dark:text-gray-400">call</span>
                        </div>
                        <input type="tel" id="phone-number" name="phone-number" required
                               class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full pl-10 p-2.5 dark:bg-dark-600 dark:border-dark-500 dark:placeholder-gray-400 dark:text-white"
                               placeholder="905551234567" pattern="[0-9]{11,15}">
                    </div>
                    <p class="mt-1 text-xs text-gray-500 dark:text-gray-400">
                        <?php echo $lang['phone-format-hint']; ?>
                    </p>
                </div>

                <!-- Message Type Selector -->
                <div class="mb-6">
                    <label class="block mb-2 text-sm font-medium text-gray-900 dark:text-white">
                        <?php echo $lang['message-type']; ?>
                    </label>
                    <div class="flex flex-wrap gap-4">
                        <div class="flex items-center">
                            <input id="message-type-normal" type="radio" value="normal" name="message-type" checked
                                   class="w-4 h-4 text-blue-600 bg-gray-100 border-gray-300 focus:ring-blue-500 dark:focus:ring-blue-600 dark:ring-offset-gray-800 focus:ring-2 dark:bg-gray-700 dark:border-gray-600">
                            <label for="message-type-normal" class="ml-2 text-sm font-medium text-gray-900 dark:text-gray-300">
                                <?php echo $lang['normal-sms']; ?>
                            </label>
                        </div>
                        <div class="flex items-center">
                            <input id="message-type-tr" type="radio" value="tr" name="message-type"
                                   class="w-4 h-4 text-blue-600 bg-gray-100 border-gray-300 focus:ring-blue-500 dark:focus:ring-blue-600 dark:ring-offset-gray-800 focus:ring-2 dark:bg-gray-700 dark:border-gray-600">
                            <label for="message-type-tr" class="ml-2 text-sm font-medium text-gray-900 dark:text-gray-300">
                                <?php echo $lang['turkish-sms']; ?>
                            </label>
                        </div>
                    </div>
                </div>

                <!-- Message Content -->
                <div class="mb-6">
                    <label for="message" class="block mb-2 text-sm font-medium text-gray-900 dark:text-white">
                        <?php echo $lang['message-content']; ?>
                        <span class="text-red-500">*</span>
                    </label>
                    <textarea id="message" name="message" rows="6" required maxlength="1600"
                              class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full p-2.5 dark:bg-dark-600 dark:border-dark-500 dark:placeholder-gray-400 dark:text-white"
                              placeholder="<?php echo $lang['message-placeholder']; ?>"></textarea>
                    <div class="flex justify-between items-center mt-1">
                        <p class="text-xs text-gray-500 dark:text-gray-400">
                            <?php echo $lang['character-count']; ?>: <span id="charCount">0</span>/1600
                        </p>
                        <p class="text-xs text-gray-500 dark:text-gray-400">
                            <?php echo $lang['sms-count']; ?>: <span id="smsCount">0</span>
                        </p>
                    </div>
                </div>

                <!-- Submit Button -->
                <div class="flex justify-end">
                    <button type="submit" id="sendSmsBtn"
                            class="flex items-center px-5 py-2.5 text-sm font-medium text-center text-white bg-blue-700 rounded-lg hover:bg-blue-800 focus:ring-4 focus:ring-blue-300 dark:bg-blue-600 dark:hover:bg-blue-700 dark:focus:ring-blue-800">
                        <span class="material-symbols-outlined mr-2">send</span>
                        <?php echo $lang['send-sms-button']; ?>
                    </button>
                </div>
            </form>
        </div>

        <!-- Recent SMS History (Compact) -->
        <div class="rounded-xl bg-white dark:bg-dark-700 border border-gray-200 dark:border-dark-600 p-6 shadow-sm">
            <h3 class="text-lg font-bold text-gray-900 dark:text-white mb-4">
                <?php echo $lang['recent-sms-history']; ?>
            </h3>

            <div id="recentSmsList" class="space-y-3">
                <!-- Loading state -->
                <div class="flex justify-center items-center py-8">
                    <div role="status">
                        <svg aria-hidden="true" class="inline w-8 h-8 text-gray-200 animate-spin dark:text-gray-600 fill-blue-600" viewBox="0 0 100 101" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path d="M100 50.5908C100 78.2051 77.6142 100.591 50 100.591C22.3858 100.591 0 78.2051 0 50.5908C0 22.9766 22.3858 0.59082 50 0.59082C77.6142 0.59082 100 22.9766 100 50.5908ZM9.08144 50.5908C9.08144 73.1895 27.4013 91.5094 50 91.5094C72.5987 91.5094 90.9186 73.1895 90.9186 50.5908C90.9186 27.9921 72.5987 9.67226 50 9.67226C27.4013 9.67226 9.08144 27.9921 9.08144 50.5908Z" fill="currentColor"/>
                            <path d="M93.9676 39.0409C96.393 38.4038 97.8624 35.9116 97.0079 33.5539C95.2932 28.8227 92.871 24.3692 89.8167 20.348C85.8452 15.1192 80.8826 10.7238 75.2124 7.41289C69.5422 4.10194 63.2754 1.94025 56.7698 1.05124C51.7666 0.367541 46.6976 0.446843 41.7345 1.27873C39.2613 1.69328 37.813 4.19778 38.4501 6.62326C39.0873 9.04874 41.5694 10.4717 44.0505 10.1071C47.8511 9.54855 51.7191 9.52689 55.5402 10.0491C60.8642 10.7766 65.9928 12.5457 70.6331 15.2552C75.2735 17.9648 79.3347 21.5619 82.5849 25.841C84.9175 28.9121 86.7997 32.2913 88.1811 35.8758C89.083 38.2158 91.5421 39.6781 93.9676 39.0409Z" fill="currentFill"/>
                        </svg>
                        <span class="sr-only">Loading...</span>
                    </div>
                </div>
            </div>

            <div class="flex justify-center mt-4">
                <a href="<?php echo url('/account/sms/history'); ?>" class="text-sm font-medium text-blue-600 dark:text-blue-400 hover:underline">
                    <?php echo $lang['view-full-history']; ?>
                </a>
            </div>
        </div>
    </div>
</main>

<!-- Success Modal -->
<div id="successModal" tabindex="-1" aria-hidden="true" class="hidden overflow-y-auto overflow-x-hidden fixed top-0 right-0 left-0 z-50 justify-center items-center w-full md:inset-0 h-[calc(100%-1rem)] max-h-full bg-black bg-opacity-50">
    <div class="relative p-4 w-full max-w-md max-h-full">
        <div class="relative bg-white rounded-lg shadow dark:bg-dark-700">
            <div class="p-4 md:p-5 text-center">
                <div class="w-12 h-12 rounded-full bg-green-100 dark:bg-green-900/20 flex items-center justify-center mx-auto mb-3.5">
                    <span class="material-symbols-outlined text-green-500 dark:text-green-400">check_circle</span>
                </div>
                <h3 class="mb-3 text-lg font-semibold text-gray-900 dark:text-white" id="successModalTitle"></h3>
                <p class="text-gray-500 dark:text-gray-400 mb-4" id="successModalMessage"></p>
                <button data-modal-hide="successModal" type="button" class="px-4 py-2 text-sm font-medium text-center text-white bg-green-600 rounded-lg hover:bg-green-700 focus:ring-4 focus:outline-none focus:ring-green-300 dark:bg-green-500 dark:hover:bg-green-600 dark:focus:ring-green-800">
                    <?php echo $lang['close-button']; ?>
                </button>
            </div>
        </div>
    </div>
</div>

<!-- Error Modal -->
<div id="errorModal" tabindex="-1" aria-hidden="true" class="hidden overflow-y-auto overflow-x-hidden fixed top-0 right-0 left-0 z-50 justify-center items-center w-full md:inset-0 h-[calc(100%-1rem)] max-h-full bg-black bg-opacity-50">
    <div class="relative p-4 w-full max-w-md max-h-full">
        <div class="relative bg-white rounded-lg shadow dark:bg-dark-700">
            <div class="p-4 md:p-5 text-center">
                <div class="w-12 h-12 rounded-full bg-red-100 dark:bg-red-900/20 flex items-center justify-center mx-auto mb-3.5">
                    <span class="material-symbols-outlined text-red-500 dark:text-red-400">error</span>
                </div>
                <h3 class="mb-3 text-lg font-semibold text-gray-900 dark:text-white" id="errorModalTitle"></h3>
                <p class="text-gray-500 dark:text-gray-400 mb-4" id="errorModalMessage"></p>
                <button data-modal-hide="errorModal" type="button" class="px-4 py-2 text-sm font-medium text-center text-white bg-red-600 rounded-lg hover:bg-red-700 focus:ring-4 focus:outline-none focus:ring-red-300 dark:bg-red-500 dark:hover:bg-red-600 dark:focus:ring-red-800">
                    <?php echo $lang['close-button']; ?>
                </button>
            </div>
        </div>
    </div>
</div>

<?php
include_once includes('layouts/dashboard-end.php');
?>

<script>
    $(document).ready(function() {
        // Character counter for message textarea
        $('#message').on('input', function() {
            const length = $(this).val().length;
            $('#charCount').text(length);

            // Calculate SMS count (1 SMS = 160 characters)
            const smsCount = Math.ceil(length / 160);
            $('#smsCount').text(smsCount);
        });

// Load recent SMS history
        function loadRecentSms() {
            $.ajax({
                url: '/account/sms/get_recent',
                type: 'POST',
                dataType: 'json',
                success: function(response) {
                    console.log(response); // Debugging: Check the response structure

                    const recentList = $('#recentSmsList');
                    recentList.empty();

                    // Ensure response.data is an array
                    if (!Array.isArray(response.data) || response.data.length === 0) {
                        recentList.html(`
                    <div class="text-center py-8 text-gray-500 dark:text-gray-400">
                        <span class="material-symbols-outlined text-4xl mb-2">sms_failed</span>
                        <p><?php echo $lang['no-recent-sms']; ?></p>
                    </div>
                `);
                        return;
                    }

                    // Loop through SMS records
                    response.data.forEach(sms => {
                        const date = new Date(sms.created_at);
                        const formattedDate = date.toLocaleString();
                        const statusClass = sms.status === 'delivered' ? 'text-green-500 dark:text-green-400' :
                            sms.status === 'failed' ? 'text-red-500 dark:text-red-400' : 'text-yellow-500 dark:text-yellow-400';

                        recentList.append(`
                    <div class="sms-item flex items-start p-3 bg-gray-50 dark:bg-dark-600 rounded-lg">
                        <div class="flex-shrink-0 mt-1 mr-3">
                            <span class="material-symbols-outlined ${statusClass}">${sms.status === 'delivered' ? 'done_all' : sms.status === 'failed' ? 'error' : 'schedule'}</span>
                        </div>
                        <div class="flex-1 min-w-0">
                            <div class="flex justify-between items-baseline mb-1">
                                <p class="text-sm font-medium text-gray-900 dark:text-white truncate">${sms.recipient}</p>
                                <span class="text-xs text-gray-500 dark:text-gray-400">${formattedDate}</span>
                            </div>
                            <p class="text-sm text-gray-600 dark:text-gray-300 truncate">${sms.message.substring(0, 60)}${sms.message.length > 60 ? '...' : ''}</p>
                        </div>
                    </div>
                `);
                    });
                },
                error: function() {
                    $('#recentSmsList').html(`
                <div class="text-center py-8 text-red-500 dark:text-red-400">
                    <span class="material-symbols-outlined text-4xl mb-2">error</span>
                    <p><?php echo $lang['failed-load-history']; ?></p>
                </div>
            `);
                }
            });
        }

// Load initial recent SMS
        loadRecentSms();


        // SMS Form Submission
        $('#smsForm').on('submit', function(e) {
            e.preventDefault();

            const form = $(this);
            const submitBtn = $('#sendSmsBtn');
            const originalBtnText = submitBtn.html();

            // Disable button and show loading state
            submitBtn.prop('disabled', true);
            submitBtn.html(`
            <span class="inline-flex items-center">
                <svg aria-hidden="true" role="status" class="inline w-4 h-4 mr-2 text-white animate-spin" viewBox="0 0 100 101" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path d="M100 50.5908C100 78.2051 77.6142 100.591 50 100.591C22.3858 100.591 0 78.2051 0 50.5908C0 22.9766 22.3858 0.59082 50 0.59082C77.6142 0.59082 100 22.9766 100 50.5908ZM9.08144 50.5908C9.08144 73.1895 27.4013 91.5094 50 91.5094C72.5987 91.5094 90.9186 73.1895 90.9186 50.5908C90.9186 27.9921 72.5987 9.67226 50 9.67226C27.4013 9.67226 9.08144 27.9921 9.08144 50.5908Z" fill="#E5E7EB"/>
                    <path d="M93.9676 39.0409C96.393 38.4038 97.8624 35.9116 97.0079 33.5539C95.2932 28.8227 92.871 24.3692 89.8167 20.348C85.8452 15.1192 80.8826 10.7238 75.2124 7.41289C69.5422 4.10194 63.2754 1.94025 56.7698 1.05124C51.7666 0.367541 46.6976 0.446843 41.7345 1.27873C39.2613 1.69328 37.813 4.19778 38.4501 6.62326C39.0873 9.04874 41.5694 10.4717 44.0505 10.1071C47.8511 9.54855 51.7191 9.52689 55.5402 10.0491C60.8642 10.7766 65.9928 12.5457 70.6331 15.2552C75.2735 17.9648 79.3347 21.5619 82.5849 25.841C84.9175 28.9121 86.7997 32.2913 88.1811 35.8758C89.083 38.2158 91.5421 39.6781 93.9676 39.0409Z" fill="currentColor"/>
                </svg>
                <?php echo $lang['sending']; ?>
            </span>
        `);

            $.ajax({
                url: '/account/sms/send',
                type: 'POST',
                data: form.serialize(),
                dataType: 'json',
                success: function(response) {
                    console.log(response)
                    if (response.success) {
                        // Show success modal
                        $('#successModalTitle').text('<?php echo $lang['sms-sent-title']; ?>');
                        $('#successModalMessage').html(`
                        <?php echo $lang['sms-sent-message']; ?><br>
                        <span class="font-medium">${$('#phone-number').val()}</span>
                    `);
                        $('#successModal').removeClass('hidden').addClass('flex');

                        // Reset form
                        form[0].reset();
                        $('#charCount').text('0');
                        $('#smsCount').text('0');

                        // Reload recent SMS
                        loadRecentSms();
                    } else {
                        // Show error modal
                        $('#errorModalTitle').text('<?php echo $lang['sms-failed-title']; ?>');
                        $('#errorModalMessage').text(response.message || '<?php echo $lang['sms-failed-generic']; ?>');
                        $('#errorModal').removeClass('hidden').addClass('flex');
                    }
                },
                error: function(xhr) {
                    let errorMessage = '<?php echo $lang['sms-failed-generic']; ?>';
                    if (xhr.responseJSON && xhr.responseJSON.message) {
                        errorMessage = xhr.responseJSON.message;
                    }

                    $('#errorModalTitle').text('<?php echo $lang['sms-failed-title']; ?>');
                    $('#errorModalMessage').text(errorMessage);
                    $('#errorModal').removeClass('hidden').addClass('flex');
                },
                complete: function() {
                    submitBtn.prop('disabled', false);
                    submitBtn.html(originalBtnText);
                }
            });
        });

        // Close modal handlers
        $('[data-modal-hide="successModal"], [data-modal-hide="errorModal"]').on('click', function() {
            $(this).closest('.fixed').addClass('hidden').removeClass('flex');
        });
    });
</script>