<?php
$meta = array(
    'us' => array(
        'title' => 'Category - Blog - Datanito',
        'description' => 'View and manage your previous support requests with Datanito. Access details of your support history and find solutions to common issues.',
        'og:title' => 'View Previous Help Requests - Datanito',
        'og:description' => 'View and manage your previous support requests with Datanito. Access details of your support history and find solutions to common issues.',
        'og:image' => asset('images/brand/open_graph_logo.png'),
    ),
    'tr' => array(
        'title' => 'Yardım Taleplerini - Datanito (Türkiye)',
        'description' => 'Datanito ile önceki yardım taleplerinizi görüntüleyin ve yönetin. Destek geçmişinizin detaylarına erişin ve ortak sorunlara çözüm bulun.',
        'og:title' => 'Önceki Yardım Taleplerini Görüntüle - Datanito (Türkiye)',
        'og:description' => 'Datanito ile önceki yardım taleplerinizi görüntüleyin ve yönetin. Destek geçmişinizin detaylarına erişin ve ortak sorunlara çözüm bulun.',
        'og:image' => asset('images/brand/open_graph_logo.png'),
    ),
);
$currentMeta = $meta[$_SESSION["country"]];
include_once includes('layouts/dashboard.php');
include_once includes('auth/admin-validation.php');
?>
<main class="p-4 md:ml-64 h-full pt-20 min-h-screen bg-gray-100 dark:bg-gray-900">
    <div class="container mx-auto mt-8">
        <div class="bg-white dark:bg-gray-800 p-6 rounded-lg shadow-lg">
            <h1 class="text-3xl font-bold mb-4 text-gray-800 dark:text-gray-100">Add Blog Category</h1>
            <form id="categoryForm" class="space-y-4">
                <div>
                    <label for="name" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Category Name:</label>
                    <input type="text" id="name" name="name" required class="w-full mt-1 p-2 border rounded-md shadow-sm focus:ring-blue-500 focus:border-blue-500 dark:bg-gray-700 dark:border-gray-600 dark:text-gray-100">
                </div>

                <div>
                    <label for="slug" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Category Slug:</label>
                    <input type="text" id="slug" name="slug" required class="w-full mt-1 p-2 border rounded-md shadow-sm focus:ring-blue-500 focus:border-blue-500 dark:bg-gray-700 dark:border-gray-600 dark:text-gray-100">
                </div>

                <div>
                    <label for="description" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Description:</label>
                    <textarea id="description" name="description" class="w-full mt-1 p-2 border rounded-md shadow-sm focus:ring-blue-500 focus:border-blue-500 dark:bg-gray-700 dark:border-gray-600 dark:text-gray-100"></textarea>
                </div>

                <div>
                    <label for="icon" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Icon:</label>
                    <input type="text" id="icon" name="icon" class="w-full mt-1 p-2 border rounded-md shadow-sm focus:ring-blue-500 focus:border-blue-500 dark:bg-gray-700 dark:border-gray-600 dark:text-gray-100">
                </div>

                <button type="button" onclick="addCategory()" class="mt-4 w-full bg-blue-600 text-white py-2 rounded-md shadow-lg hover:bg-blue-700 focus:ring-4 focus:ring-blue-300 dark:bg-blue-700 dark:hover:bg-blue-600 dark:focus:ring-blue-500">
                    Add Category
                </button>
            </form>
        </div>

        <!-- Display Blog Categories -->
        <div id="categories" class="mt-8 p-6 bg-white dark:bg-gray-800 rounded-lg shadow-lg">
            <!-- Category content will be dynamically inserted here -->
        </div>
    </div>
</main>
<?php include_once includes('layouts/dashboard-end.php'); ?>

<script src="https://cdn.tiny.cloud/1/no-api-key/tinymce/5/tinymce.min.js"></script>

<script>
    function addCategory() {
        const formData = {
            name: $('#name').val(),
            slug: $('#slug').val(),
            description: $('#description').val(),
            icon: $('#icon').val(),
        };

        $.ajax({
            type: 'POST',
            url: '/admin/add-blog-category',
            data: formData,
            dataType: 'json',
            success: function(response) {
                if (response.success) {
                    alert('Category added successfully!');
                    $('#categoryForm')[0].reset();
                } else {
                    alert('Error adding category. Please try again.');
                }
            },
            error: function() {
                alert('Error adding category. Please try again.');
            }
        });
    }
</script>
