<?php
$meta = array(
    'us' => array(
        'title' => 'Blog Archive - Datanito',
        'description' => 'Explore the Datanito blog archive. Browse past posts on AI, SEO, and more, and discover insightful content to help you succeed.',
        'og:title' => 'Blog Archive - Datanito',
        'og:description' => 'Explore the Datanito blog archive. Browse past posts on AI, SEO, and more, and discover insightful content to help you succeed.',
        'og:image' => asset('images/brand/open_graph_logo.png'),
    ),
    'tr' => array(
        'title' => 'Blog Arşivi - Datanito (Türkiye)',
        'description' => 'Datanito blog arşivini keşfedin. Geçmiş yazılara göz atın ve başarılı olmanıza yardımcı olacak içerikleri bulun.',
        'og:title' => 'Blog Arşivi - Datanito (Türkiye)',
        'og:description' => 'Datanito blog arşivini keşfedin. Geçmiş yazılara göz atın ve başarılı olmanıza yardımcı olacak içerikleri bulun.',
        'og:image' => asset('images/brand/open_graph_logo.png'),
    ),
);

$currentMeta = setCountryAndMeta($meta);
include_once includes('layouts/dashboard.php');
include_once includes('auth/admin-validation.php');
?>

<main class="p-4 md:ml-64 h-full pt-20 min-h-[70em] bg-gray-100 dark:bg-gray-900">
    <section class="bg-white dark:bg-gray-800 p-6 rounded-lg shadow-lg">
        <div class="py-8 px-4 mx-auto max-w-screen-xl lg:py-16 lg:px-6">
            <div class="blogArchiveContainer grid gap-8 lg:grid-cols-2"></div>
            <div class="text-center mx-auto">
                <div role="status" class="spinner hidden my-6">
                    <svg aria-hidden="true" class="inline w-20 h-20 mr-2 text-gray-200 animate-spin dark:text-gray-600 fill-green-500" viewBox="0 0 100 101" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M100 50.5908C100 78.2051 77.6142 100.591 50 100.591C22.3858 100.591 0 78.2051 0 50.5908C0 22.9766 22.3858 0.59082 50 0.59082C77.6142 0.59082 100 22.9766 100 50.5908ZM9.08144 50.5908C9.08144 73.1895 27.4013 91.5094 50 91.5094C72.5987 91.5094 90.9186 73.1895 90.9186 50.5908C90.9186 27.9921 72.5987 9.67226 50 9.67226C27.4013 9.67226 9.08144 27.9921 9.08144 50.5908Z" fill="currentColor"/>
                        <path d="M93.9676 39.0409C96.393 38.4038 97.8624 35.9116 97.0079 33.5539C95.2932 28.8227 92.871 24.3692 89.8167 20.348C85.8452 15.1192 80.8826 10.7238 75.2124 7.41289C69.5422 4.10194 63.2754 1.94025 56.7698 1.05124C51.7666 0.367541 46.6976 0.446843 41.7345 1.27873C39.2613 1.69328 37.813 4.19778 38.4501 6.62326C39.0873 9.04874 41.5694 10.4717 44.0505 10.1071C47.8511 9.54855 51.7191 9.52689 55.5402 10.0491C60.8642 10.7766 65.9928 12.5457 70.6331 15.2552C75.2735 17.9648 79.3347 21.5619 82.5849 25.841C84.9175 28.9121 86.7997 32.2913 88.1811 35.8758C89.083 38.2158 91.5421 39.6781 93.9676 39.0409Z" fill="currentFill"/>
                    </svg>
                    <span class="sr-only">Loading...</span>
                </div>
            </div>
        </div>
    </section>
</main>

<?php include_once includes('layouts/dashboard-end.php'); ?>

<script>
    $(document).ready(function() {
        const blogArchive = $('.blogArchiveContainer');
        $('.spinner').show();

        $.ajax({
            type: 'POST',
            url: '/admin/blog-fetch-archive',
            dataType: 'json',
            success: function(response) {
                $('.spinner').hide();

                try {
                    if (!Array.isArray(response)) {
                        throw new Error('Invalid response format');
                    }

                    if (response.length === 0) {
                        $('<p class="text-center text-gray-500 dark:text-gray-400">No posts available.</p>').appendTo(blogArchive);
                    } else {
                        blogArchive.empty();
                        response.forEach(blog => {
                            const formattedCreatedAt = formatCreatedAt(blog.updated_at);
                            const blogCategory = blog.category || 'Uncategorized';
                            const photoSrc = blog.main_photo || 'images/content/blog-placeholder.jpg';

                            const blogRow = $(`
                                <article class='p-6 bg-white rounded-3xl border border-gray-200 dark:bg-gray-700 dark:border-gray-600'>
                                    <div class="photo-container w-full h-36 mb-4 rounded-3xl">
                                        ${photoSrc ? `<img class="blog-photo w-full h-full rounded-3xl object-cover" src="${photoSrc}" alt="${blog.title}" />` : '<div class="flex items-center justify-center bg-gray-100 dark:bg-gray-600 w-full h-36 rounded-3xl"><span class="material-symbols-outlined text-gray-300 dark:text-gray-500">no_photography</span></div>'}
                                    </div>
                                    <div class="flex justify-between items-center mb-5 text-gray-500">
                                        <span class="bg-blue-100 text-blue-800 text-xs font-medium px-2.5 py-0.5 rounded-xl dark:bg-blue-200 dark:text-blue-800">${blogCategory}</span>
                                        <time pubdate datetime="${blog.updated_at}" title="${formattedCreatedAt}">${formattedCreatedAt}</time>
                                    </div>
                                    <h2 class="mb-2 text-2xl font-bold text-gray-900 dark:text-white">${blog.title}</h2>
                                    <p class="mb-5 text-gray-500 dark:text-gray-400">${blog.short_content}</p>
                                    <div class="flex justify-between items-center">
                                        <a href="/admin/blog/p/${blog.slug}" class="text-blue-700 dark:text-blue-600 hover:underline">Read More</a>
                                    </div>
                                </article>
                            `);
                            blogArchive.append(blogRow);
                        });
                    }
                } catch (error) {
                    console.error('Error processing response:', error);
                    $('<p class="text-center text-red-500 dark:text-red-400">An error occurred while loading the archive.</p>').appendTo(blogArchive);
                }
            },
            error: function() {
                $('.spinner').hide();
                $('<p class="text-center text-red-500 dark:text-red-400">Failed to load blog archive. Please try again later.</p>').appendTo(blogArchive);
            }
        });

        function formatCreatedAt(updated_at) {
            const date = new Date(updated_at);
            const options = { year: 'numeric', month: 'long', day: 'numeric' };
            return date.toLocaleDateString(undefined, options);
        }
    });
</script>
