<?php
session_start();

// Function to generate a bot message
function generateBotMessage($text) {
    return [
        'text' => $text,
        'sender' => 'assistant',
    ];
}

// Function to handle the incoming message
function handleMessage($message) {
    $response = [
        'chat_messages' => [],
    ];

    // Retrieve the chat messages from the session
    $chatMessages = isset($_SESSION['chat_messages']) ? $_SESSION['chat_messages'] : [];

    // Check if it's the first message
    if (empty($chatMessages)) {
        // Generate and store the initial bot message
        $botMessage = generateBotMessage('Welcome to the chat! How can I assist you today?');
        $chatMessages[] = $botMessage;
        $response['chat_messages'][] = $botMessage;
    } else {
        // Handle the user's message
        $userMessage = [
            'text' => $message,
            'sender' => 'user',
        ];
        $chatMessages[] = $userMessage;

        // Generate and store a bot response
        $botResponse = generateBotMessage('This is a bot response. You can customize it based on your needs.');
        $chatMessages[] = $botResponse;
        $response['chat_messages'][] = $botResponse;
    }

    // Store the updated chat messages in the session
    $_SESSION['chat_messages'] = $chatMessages;

    return $response;
}

// Check if a message is submitted
if (isset($_POST['message'])) {
    $message = $_POST['message'];

    // Handle the message
    $response = handleMessage($message);

    // Generate a response in JSON format
    echo json_encode($response);
}
?>

<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Chat Application</title>

    <!-- Flowbite CSS -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/flowbite/css/flowbite.css">

    <style>
        .chat-box {
            height: 400px;
            overflow-y: scroll;
            border: 1px solid #ccc;
            padding: 10px;
        }

        .user-list {
            list-style-type: none;
            padding: 0;
            margin: 0;
        }

        .user-list-item {
            cursor: pointer;
            padding: 10px;
            border-bottom: 1px solid #ccc;
        }

        .user-list-item:hover {
            background-color: #f4f4f4;
        }
    </style>
</head>

<body>
<div class="container mt-4">
    <div class="columns">
        <div class="column col-4">
            <h3>Online Users</h3>
            <ul id="user-list" class="user-list"></ul>
        </div>
        <div class="column col-8">
            <div class="chat-box" id="chat-box"></div>
            <form id="message-form">
                <div class="input-group">
                    <input type="text" id="message-input" class="form-input" placeholder="Type your message">
                    <button type="submit" class="btn">Send</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Flowbite JS -->
<script src="https://cdn.jsdelivr.net/npm/flowbite/js/flowbite.js"></script>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
    $(function () {
        var chatBox = $('#chat-box');
        var messageForm = $('#message-form');
        var messageInput = $('#message-input');
        var userList = $('#user-list');

        var selectedUser = null; // Store the currently selected user

        // Function to append a new message to the chat box
        function appendMessage(message) {
            chatBox.append('<p><strong>' + message.sender + ':</strong> ' + message.text + '</p>');
            chatBox.scrollTop(chatBox.prop('scrollHeight'));
        }

        // Function to update the user list
        function updateUserList(users) {
            userList.empty();

            users.forEach(function (user) {
                var listItem = $('<li>').text(user.session + ' - ' + user.ip);
                listItem.addClass('user-list-item');
                listItem.click(function () {
                    selectedUser = user;
                    chatBox.empty();
                    loadChatHistory();
                });
                userList.append(listItem);
            });
        }

        // Function to send a message to the selected user
        function sendMessage(message) {
            if (selectedUser) {
                // Send the message to the server along with the selected user's ID
                $.post('/dino/send_message', { userId: selectedUser.id, message: message }, function (response) {
                    // Append the sent message to the chat box
                    appendMessage(response);
                });

                // Clear the message input field
                messageInput.val('');
            }
        }

        // Handle the form submission
        messageForm.submit(function (e) {
            e.preventDefault();
            var message = messageInput.val().trim();
            if (message !== '') {
                sendMessage(message);
            }
        });

        // Function to load the chat history for the selected user
        function loadChatHistory() {
            if (selectedUser) {
                // Fetch the chat history for the selected user from the server
                $.get('/dino/get_chat_history', { userId: selectedUser.id }, function (response) {
                    // Append each message to the chat box
                    response.forEach(function (message) {
                        appendMessage(message);
                    });
                });
            }
        }

        // Function to load the user list
        function loadUserList() {
            // Fetch the user list from the server
            $.get('/dino/get_user_list', function (response) {
                // Update the user list
                updateUserList(response);

                // Select the first user by default
                if (response.length > 0) {
                    selectedUser = response[0];
                    loadChatHistory();
                }
            });
        }

        // Load the user list when the page loads
        loadUserList();
    });
</script>
</body>

</html>
