<?php
$meta = array(
    'us' => array(
        'title' => 'Help Requests - Datanito',
        'description' => 'View and manage your previous support requests with Datanito. Access details of your support history and find solutions to common issues.',
        'og:title' => 'View Previous Help Requests - Datanito',
        'og:description' => 'View and manage your previous support requests with Datanito. Access details of your support history and find solutions to common issues.',
        'og:image' => asset('images/brand/open_graph_logo.png'),
    ),
    'tr' => array(
        'title' => 'Destek Taleplerini - Datanito (Türkiye)',
        'description' => 'Datanito ile önceki yardım taleplerinizi görüntüleyin ve yönetin. Destek geçmişinizin detaylarına erişin ve ortak sorunlara çözüm bulun.',
        'og:title' => 'Önceki Yardım Taleplerini Görüntüle - Datanito (Türkiye)',
        'og:description' => 'Datanito ile önceki yardım taleplerinizi görüntüleyin ve yönetin. Destek geçmişinizin detaylarına erişin ve ortak sorunlara çözüm bulun.',
        'og:image' => asset('images/brand/open_graph_logo.png'),
    ),
);
$currentMeta = setCountryAndMeta($meta);
include_once includes('layouts/dashboard.php');
?>
<main class="p-4 md:pl-64 md:ml-8 md:mr-4 h-full pt-20 min-h-[70em] !overflow-hidden">
        <div class="h-full">
            <div id="ticketListContainer">
                <div class="my-6 ml-5">
                    <h3 class="text-2xl tracking-tight font-semibold text-gray-900 dark:text-white"><?php echo $lang['support-requests-headline']; ?></h3>
                    <h3 class="text-lg mt-2 tracking-tight font-normal text-gray-900 dark:text-white"><?php echo $lang['support-requests-subheading']; ?></h3>
                </div>
                <div class="relative overflow-x-auto sm:rounded-lg mx-3">
                    <div id="ticketList"></div>
                </div>
                <div class="text-center mx-auto mt-24">
                    <div role="status" class="spinner hidden my-6">
                        <svg aria-hidden="true" class="inline w-20 h-20 mr-2 text-gray-200 animate-spin dark:text-gray-600 fill-green-500" viewBox="0 0 100 101" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path d="M100 50.5908C100 78.2051 77.6142 100.591 50 100.591C22.3858 100.591 0 78.2051 0 50.5908C0 22.9766 22.3858 0.59082 50 0.59082C77.6142 0.59082 100 22.9766 100 50.5908ZM9.08144 50.5908C9.08144 73.1895 27.4013 91.5094 50 91.5094C72.5987 91.5094 90.9186 73.1895 90.9186 50.5908C90.9186 27.9921 72.5987 9.67226 50 9.67226C27.4013 9.67226 9.08144 27.9921 9.08144 50.5908Z" fill="currentColor"/>
                            <path d="M93.9676 39.0409C96.393 38.4038 97.8624 35.9116 97.0079 33.5539C95.2932 28.8227 92.871 24.3692 89.8167 20.348C85.8452 15.1192 80.8826 10.7238 75.2124 7.41289C69.5422 4.10194 63.2754 1.94025 56.7698 1.05124C51.7666 0.367541 46.6976 0.446843 41.7345 1.27873C39.2613 1.69328 37.813 4.19778 38.4501 6.62326C39.0873 9.04874 41.5694 10.4717 44.0505 10.1071C47.8511 9.54855 51.7191 9.52689 55.5402 10.0491C60.8642 10.7766 65.9928 12.5457 70.6331 15.2552C75.2735 17.9648 79.3347 21.5619 82.5849 25.841C84.9175 28.9121 86.7997 32.2913 88.1811 35.8758C89.083 38.2158 91.5421 39.6781 93.9676 39.0409Z" fill="currentFill"/>
                        </svg>
                        <span class="sr-only">Loading...</span>
                    </div>
                    <div id="emptyMessage" class="hidden"><?php echo $lang['support-requests-not-found']?></div>
                </div>
            </div>
        </div>
    </main>
<?php
include_once includes('layouts/dashboard-end.php');
?>
<script>
    $(document).ready(function () {
        const ticketList = $('#ticketList');
        const loadingSpinner = $('.spinner');
        const emptyMessage = $('#emptyMessage');

        // Show the loading spinner while data is being loaded
        loadingSpinner.removeClass('hidden');

        // Load user-specific tickets
        $.ajax({
            type: 'POST',
            url: '/support_requests', // Replace with the actual URL to fetch tickets
            dataType: 'json',
            success: function (data) {
                // Hide the loading spinner when data is loaded
                loadingSpinner.addClass('hidden');

                if (data.tickets.length === 0) {
                    // If no tickets found, display the empty message
                    emptyMessage.removeClass('hidden');
                } else {
                    // Clear the existing ticket list
                    ticketList.empty();

                    // Loop through the tickets and add them to the table
                    $.each(data.tickets, function (index, ticket) {
                        // Format the created_at date
                        function formatCreatedAt(created_at) {
                            const date = new Date(created_at);
                            const options = { year: 'numeric', month: 'long', day: 'numeric' };

                            <?php
                            $websiteLanguage = $_SESSION["country"];
                            if ($websiteLanguage === 'tr') {
                                echo "const formattedDate = date.toLocaleDateString('tr-TR', options);";
                            } else {
                                echo "const formattedDate = date.toLocaleDateString(undefined, options);";
                            }
                            ?>

                            return formattedDate;
                        }

                        const formattedCreatedAt = formatCreatedAt(ticket.created_at);

                        // Determine the status indicator and color
                        let statusIndicator = '';
                        let statusColorClass = '';
                        let statusTitle = '';

                        if (ticket.status === 'Open') {
                            statusIndicator = '<div class="h-2.5 w-2.5 rounded-full bg-green-500 mr-2"></div>';
                            statusColorClass = 'text-green-500 dark:text-green-400';
                            statusTitle = '<?php echo $lang['support-status-open']?>';
                        } else if (ticket.status === 'Closed') {
                            statusIndicator = '<div class="h-2.5 w-2.5 rounded-full bg-red-500 mr-2"></div>';
                            statusColorClass = 'text-red-500 dark:text-red-400';
                            statusTitle = '<?php echo $lang['support-status-closed']?>';
                        } else if (ticket.status === 'In Progress') {
                            statusIndicator = '<div class="h-2.5 w-2.5 rounded-full bg-yellow-500 mr-2"></div>';
                            statusColorClass = 'text-yellow-500 dark:text-yellow-400';
                            statusTitle = '<?php echo $lang['support-status-in-progress']?>';
                        }

                        // Create a new row for each ticket
                        const ticketRow = $("<div class='block md:flex justify-between mb-4 px-4 sm:px-5 py-4 sm:py-6 space-y-4 md:space-y-0 rounded-3xl border border-gray-200 bg-gray-50 dark:bg-dark-600 dark:border-gray-600 max-h-36 md:max-h-24 overflow-hidden w-full'>");
                        ticketRow.html(`
                        <span class="flex md:space-x-12 justify-between items-center">
                            <span class="text-left font-medium text-gray-900 whitespace-nowrap dark:text-white max-w-24 w-96">
                                <p class="font-semibold text-lg w-48 sm:w-64 overflow-hidden overflow-ellipsis break-words">${ticket.subject}</p>
                            </span>
                            <span>
                                <span class="flex items-center ${statusColorClass}">${statusIndicator} ${statusTitle}</span>
                            </span>
                        </span>
                        <span class="flex md:space-x-12 justify-between items-center">
                            <span>
                                ${formattedCreatedAt}
                            </span>
                            <span>
                                    <a href="requests/${ticket.id}" class="text-white bg-blue-700 hover:bg-blue-800 focus:ring-4 focus:outline-none focus:ring-blue-300 font-medium rounded-3xl text-sm p-2.5 text-center inline-flex items-center mr-2 dark:bg-blue-600 dark:hover:bg-blue-700 dark:focus:ring-blue-800">
                                          <svg class="w-5 h-5" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 14 10">
                                            <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M1 5h12m0 0L9 1m4 4L9 9"/>
                                          </svg>
                                          <span class="sr-only">Icon description</span>
                                    </a>
                            </span>
                        </span>
                        `);

                        // Append the row to the ticket list
                        ticketList.append(ticketRow);
                    });
                }
            },
            error: function (error) {
                // Hide the loading spinner on error
                loadingSpinner.addClass('hidden');
                alert('Error: ' + error.responseText);
            }
        });
    });



</script>


