<?php
$meta = array(
    'us' => array(
        'title' => 'Open a New Help Request - Datanito',
        'description' => 'Request assistance by opening a new support request with Datanito. Our team is here to support you with any questions or issues you may have.',
        'og:title' => 'Open a New Help Request - Datanito',
        'og:description' => 'Request assistance by opening a new support request with Datanito. Our team is here to support you with any questions or issues you may have.',
        'og:image' => asset('images/brand/open_graph_logo.png'),
    ),
    'tr' => array(
        'title' => 'Yeni Bir Yardım Talebi Açın - Datanito (Türkiye)',
        'description' => 'Datanito ile yeni bir yardım talebi açarak yardım isteyin. Ekibimiz, herhangi bir sorunuz veya sorununuz olduğunda size yardımcı olmak için burada.',
        'og:title' => 'Yeni Bir Yardım Talebi Açın - Datanito (Türkiye)',
        'og:description' => 'Datanito ile yeni bir yardım talebi açarak yardım isteyin. Ekibimiz, herhangi bir sorunuz veya sorununuz olduğunda size yardımcı olmak için burada.',
        'og:image' => asset('images/brand/open_graph_logo.png'),
    ),
);
$currentMeta = setCountryAndMeta($meta);
include_once includes('layouts/dashboard.php');
?>
<main class="p-4 md:pl-64 md:ml-8 md:mr-4 h-full pt-20 min-h-[70em] !overflow-hidden">
    <div class="h-full">
        <div class="my-6 ml-5">
            <h3 class="text-2xl tracking-tight font-semibold text-gray-900 dark:text-white"><?php echo $lang['new-support-requests-headline']; ?></h3>
            <h3 class="text-lg mt-2 tracking-tight font-normal text-gray-900 dark:text-white"><?php echo $lang['new-support-requests-subheading']; ?></h3>
        </div>
        <form id="supportForm" class="mb-2 mx-3" enctype="multipart/form-data">
            <?php set_csrf(); ?>
            <div class="relative rounded-xl skeleton w-full md:w-[50%] bg-gray-50 dark:bg-dark-800">
                <input type="text" id="subject" name="subject" maxlength="24" onkeyup="count_down(this)" class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-xl focus:ring-blue-500 focus:border-blue-500 block w-full p-3.5 dark:bg-dark-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500" placeholder="<?php echo $lang['subject-label']; ?>">
            </div>
            <div class="relative text-right w-full md:w-[50%] mb-4">
                <?php echo $lang['support-subject-check-characters']?>
            </div>
            <script>
                function count_down(obj){
                    let element = document.getElementById('count');
                    let minLength = 5;

                    element.innerHTML = 24 - obj.value.length;

                    if (24 - obj.value.length < minLength) {
                        element.classList.remove('text-gray-500', 'dark:text-gray-400');
                        element.classList.add('text-red-500', 'dark:text-red-400');
                    } else {
                        element.classList.remove('text-red-500', 'dark:text-red-400');
                        element.classList.add('text-gray-500', 'dark:text-gray-400');
                    }
                }
            </script>

            <div class="w-full mb-4 border border-gray-200 rounded-xl bg-gray-100 dark:bg-dark-600 dark:border-gray-600">
                <div class="px-4 py-2 bg-gray-50 rounded-t-xl dark:bg-dark-700 skeleton">
                    <label for="messageInput" class="sr-only"><?php echo $lang['your-message']; ?></label>
                    <textarea id="messageInput" rows="12" class="w-full px-0 pt-1 text-sm text-gray-900 bg-gray-50 border-0 dark:bg-dark-700 focus:ring-0 dark:text-white dark:placeholder-gray-400 resize-none" placeholder="<?php echo $lang['your-message']; ?>" required></textarea>
                </div>
                <div class="flex items-center justify-between px-3 py-2 border-t dark:border-gray-600">
                    <button type="submit" class="flex items-center space-x-4 text-white bg-blue-700 hover:bg-blue-800 focus:ring-4 focus:outline-none focus:ring-blue-300 font-medium rounded-3xl text-sm sm:w-auto px-5 py-2.5 text-center dark:bg-blue-600 dark:hover:bg-blue-700 dark:focus:ring-blue-800 skeleton">
                        <span><?php echo $lang['support-new-cta']; ?></span>
                        <span class="material-symbols-outlined">reply</span>
                    </button>
                </div>
            </div>
            <p class="ml-auto text-sm text-gray-500 dark:text-gray-400 mb-6"><?php echo $lang['support-guidelines']; ?></p>
            <div class="relative hidden">
                <input type="text" id="honeypot" name="honeypot" value="">
            </div>
            <div id="uploadArea" class="upload-area skeleton bg-gray-50 dark:bg-dark-600 p-4 mb-8 border border-gray-200 rounded-xl dark:bg-dark-700 dark:border-gray-600 md:w-[50%] max-h-96">
                <!-- Header -->
                <div class="upload-area__header">
                    <p class="upload-area__paragraph text-gray-600 dark:text-gray-300">
                        .<span class="upload-area__tooltip-data"></span> <?php echo $lang['support-upload-title']; ?>
                    </p>
                </div>
                <!-- End Header -->

                <!-- Drop Zoon -->
                <div id="dropZoon" class="upload-area__drop-zoon drop-zoon mt-3 border-2 border-dashed rounded-xl border-gray-300 dark:border-gray-600 z-0">
                    <span class="drop-zoon__icon">
                      <i class='bx bxs-file-image'></i>
                    </span>
                    <p class="drop-zoon__paragraph text-gray-700 dark:text-gray-200"><?php echo $lang['support-upload-subtitle']; ?></p>
                    <span id="loadingText" class="drop-zoon__loading-text"><?php echo $lang['support-upload-wait']; ?></span>
                    <img src="" alt="Preview Image" id="previewImage" class="drop-zoon__preview-image" draggable="false">
                    <input id="fileInput" class="drop-zoon__file-input" type="file" name="fileInput" accept=".pdf, .jpg, .jpeg, .png">
                </div>
                <!-- End Drop Zoon -->

                <!-- File Details -->
                <div id="fileDetails" class="upload-area__file-details file-details">
                    <h3 class="file-details__title my-3"><?php echo $lang['support-upload-uploaded-file']; ?></h3>

                    <div id="uploadedFile" class="uploaded-file">
                        <div class="uploaded-file__icon-container">
                            <i class='bx bxs-file-blank uploaded-file__icon'></i>
                            <span class="uploaded-file__icon-text hidden"></span><!-- Data Will be Comes From Js -->
                        </div>

                        <div id="uploadedFileInfo" class="uploaded-file__info">
                            <span class="uploaded-file__name">Proejct 1</span>
                            <span class="uploaded-file__counter">0%</span>
                        </div>
                    </div>
                </div>
                <!-- End File Details -->
            </div>
        </form>
    </div>
</main>
<?php
include_once includes('layouts/dashboard-end.php');
?>

<script>
    $(document).ready(function() {
        $('#supportForm').submit(function(event) {
            event.preventDefault();

            // Create a FormData object
            const subject = $('#subject').val();
            const messageInput = $('#messageInput').val();
            const honeypot = $('#honeypot').val();
            const attachmentInput = $('#fileInput')[0].files[0]; // Get the selected file
            var csrf = $('input[name="csrf"]').val();

            // Create a FormData object for sending data with files
            const formData = new FormData();
            formData.append('subject', subject);
            formData.append('message', messageInput);
            formData.append('csrf', csrf);
            formData.append('attachment', attachmentInput);
            formData.append('honeypot', honeypot);
            // Send AJAX request to /open_help_request
            $.ajax({
                type: 'POST',
                url: '/open_help_request',
                data: formData,
                processData: false,
                contentType: false,
                dataType: 'json', // Expect JSON response
                success: function(response) {
                    // Show a success message (you can customize this part)
                    $("#toast-success").css("display", "flex");
                    $("#toast-success").removeClass("hidden");
                    $(".toast-message").text(response.message);
                    if (response.icon === 'error') {
                        $(".notification-success").addClass("hidden");
                        $(".notification-error").removeClass("hidden");
                    }
                    $("#toast-success").addClass("notification-opened");
                    $("#toast-success svg").addClass("notification-checkmark");
                    $("#toast-success").removeClass("notification-closed");

                    // Hide the success message after 2 seconds
                    setTimeout(function () {
                        $("#toast-success").addClass("notification-closed");
                        $("#toast-success").removeClass("notification-opened");
                        $("#toast-success svg").removeClass("notification-checkmark");
                    }, 2000);
                    setTimeout(function () {
                        window.location.href = "<?php echo url('/account/support/requests/" + response.ticket_id'); ?>;
                    }, 3500);
                },
                error: function() {
                    $('#result').html('<div class="error">Error: Something went wrong.</div>');
                }
            });

        });
    });

</script>

