<?php
$meta = array(
    'us' => array(
        'title' => 'Datanito Solutions Management - Explore Web Design, SEO, and More',
        'description' => 'Effortlessly oversee and explore your web design, SEO, and more with Datanito. Enhance your online presence today.',
        'og:title' => 'Datanito Solutions Management - Explore Web Design, SEO, and More',
        'og:description' => 'Effortlessly oversee and explore your web design, SEO, and more with Datanito. Enhance your online presence today.',
        'og:image' => asset('images/brand/open_graph_logo.png'),
    ),
    'tr' => array(
        'title' => 'Datanito Çözüm Yönetimi - Web Tasarımı, SEO ve Daha Fazlasını Keşfedin',
        'description' => 'Datanito ile web tasarımınızı, SEO\'nuzu ve daha fazlasını kolayca yönetin ve keşfedin. Çevrimiçi varlığınızı güçlendirin.',
        'og:title' => 'Datanito Çözüm Yönetimi - Web Tasarımı, SEO ve Daha Fazlasını Keşfedin',
        'og:description' => 'Datanito ile web tasarımınızı, SEO\'nuzu ve daha fazlasını kolayca yönetin ve keşfedin. Çevrimiçi varlığınızı güçlendirin.',
        'og:image' => asset('images/brand/open_graph_logo.png'),
    ),
);
$currentMeta = setCountryAndMeta($meta);
include_once includes('layouts/dashboard.php');
?>
<main class="p-4 md:pl-64 md:ml-8 md:mr-4 h-full pt-20 min-h-[70em] !overflow-hidden">
    <div class="relative min-h-[50em]">
        <div class="grid grid-cols-1 md:grid-cols-2 justify-between items-center space-y-4 md:space-y-0 mb-6">
            <div class="ml-2">
                <h1 class="text-2xl tracking-tight font-semibold text-gray-900 dark:text-white"><?php echo $lang['solutions-products-headline']; ?></h1>
                <h3 class="text-lg ml-2 mt-2 tracking-tight font-normal text-gray-700 dark:text-gray-300"><?php echo $lang['cloud-products-subheading']; ?></h3>
            </div>
            <div class="flex items-center justify-end">
                <button id="addNewSolutionButton" data-dropdown-toggle="addNewSolution" class="flex items-center justify-between text-center text-white bg-dark-700 focus:ring-0 font-medium rounded-full text-sm p-3 dark:bg-dark-500 focus:outline-none" type="button">
                    <?php echo $lang['domain-add-new'];?>
                    <svg class="w-2.5 h-2.5 ml-2.5" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 10 6">
                        <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="m1 1 4 4 4-4"/>
                    </svg>
                </button>

                <!-- Dropdown menu -->
                <div id="addNewSolution" class="z-10 hidden bg-white divide-y divide-gray-100 rounded-3xl shadow w-48 dark:bg-dark-700 border border-gray-200 dark:border-gray-500">
                    <ul class="py-4 px-2 space-y-3 text-sm text-gray-700 dark:text-gray-200" aria-labelledby="addNewSolutionButton">
                        <li>
                            <a href="<?php echo url('/solutions/web-design'); ?>" class="block p-3 hover:bg-gray-100 dark:hover:bg-dark-600 dark:hover:text-white rounded-3xl"><?php echo $lang['web-design']?></a>
                        </li>
                        <li>
                            <a href="<?php echo url('/solutions/mobile-app-development'); ?>" class="block p-3 hover:bg-gray-100 dark:hover:bg-dark-600 dark:hover:text-white rounded-3xl"><?php echo $lang['mobile-app-dev-solutions']?></a>
                        </li>
                        <li>
                            <a href="<?php echo url('/solutions/seo'); ?>" class="block p-3 hover:bg-gray-100 dark:hover:bg-dark-600 dark:hover:text-white rounded-3xl"><?php echo $lang['seo']?></a>
                        </li>
                        <li>
                            <a href="<?php echo url('/solutions/digital-advertising'); ?>" class="block p-3 hover:bg-gray-100 dark:hover:bg-dark-600 dark:hover:text-white rounded-3xl"><?php echo $lang['digital-advertising']?></a>
                        </li>
                        <li>
                            <a href="<?php echo url('/solutions/wordpress-premium-support'); ?>" class="block p-3 hover:bg-gray-100 dark:hover:bg-dark-600 dark:hover:text-white rounded-3xl"><?php echo $lang['wordpress-premium-support']?></a>
                        </li>
                    </ul>
                </div>
            </div>
        </div>
        <div class="text-center">
            <div id="productsList">
                <!-- Product data will be displayed here -->
                <div class="mt-36">
                    <div role="status" class="spinner hidden my-6 p-4 bg-gray-50 dark:bg-dark-700 rounded-3xl">
                        <svg aria-hidden="true" class="inline w-20 h-20 text-gray-200 animate-spin dark:text-gray-600 fill-blue-500" viewBox="0 0 100 101" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path d="M100 50.5908C100 78.2051 77.6142 100.591 50 100.591C22.3858 100.591 0 78.2051 0 50.5908C0 22.9766 22.3858 0.59082 50 0.59082C77.6142 0.59082 100 22.9766 100 50.5908ZM9.08144 50.5908C9.08144 73.1895 27.4013 91.5094 50 91.5094C72.5987 91.5094 90.9186 73.1895 90.9186 50.5908C90.9186 27.9921 72.5987 9.67226 50 9.67226C27.4013 9.67226 9.08144 27.9921 9.08144 50.5908Z" fill="currentColor"/>
                            <path d="M93.9676 39.0409C96.393 38.4038 97.8624 35.9116 97.0079 33.5539C95.2932 28.8227 92.871 24.3692 89.8167 20.348C85.8452 15.1192 80.8826 10.7238 75.2124 7.41289C69.5422 4.10194 63.2754 1.94025 56.7698 1.05124C51.7666 0.367541 46.6976 0.446843 41.7345 1.27873C39.2613 1.69328 37.813 4.19778 38.4501 6.62326C39.0873 9.04874 41.5694 10.4717 44.0505 10.1071C47.8511 9.54855 51.7191 9.52689 55.5402 10.0491C60.8642 10.7766 65.9928 12.5457 70.6331 15.2552C75.2735 17.9648 79.3347 21.5619 82.5849 25.841C84.9175 28.9121 86.7997 32.2913 88.1811 35.8758C89.083 38.2158 91.5421 39.6781 93.9676 39.0409Z" fill="currentFill"/>
                        </svg>
                        <span class="sr-only">Loading...</span>
                    </div>
                    <span class="inline-flex justify-center text-center empty-message hidden p-6 bg-gray-50 dark:bg-dark-700 rounded-3xl">
                        <span>
                            <span class="material-symbols-outlined block text-8xl text-gray-700 dark:text-gray-300 mb-4">info</span>
                            <span class="block sm:w-96">
                                <span class="block font-semibold text-lg mb-2 text-gray-800 dark:text-gray-200"><?php echo $lang['solutions-empty-headline']?></span>
                                <span class="block font-medium text-sm text-gray-600 dark:text-gray-400"><?php echo $lang['solutions-empty-subheading']?></span>
                            </span>
                        </span>
                    </span>
                </div>
            </div>
        </div>
    </div>
</main>
<?php
include_once includes('layouts/dashboard-end.php');
?>

<script>
    $(document).ready(function() {
        $('.spinner').addClass('inline-flex');
        $('.spinner').removeClass('hidden');
        const products = $('#productsList');

        function loadProducts() {
            var categories = 'wp-support'; // Comma-separated string
            $.ajax({
                type: 'POST',
                url: '/get_user_products',
                dataType: 'json',
                data: { categories: categories }, // Pass the string as a single parameter
                success: function (response) {
                    $('.spinner').hide();
                    console.log(response);
                    if (response.length === 0) {
                        // If no invoices found, display the empty message
                        // You can add an "empty" element in your HTML to display the message.
                        $('.empty-message').removeClass('hidden');
                    } else {
                        // Clear the existing invoice list
                        products.empty();

                        // Loop through the invoices and add them to the container
                        $.each(response, function (index, product) {
                            function formatCreatedAt(created_at) {
                                const date = new Date(created_at);
                                const options = { year: 'numeric', month: 'long', day: 'numeric' };

                                <?php
                                $websiteLanguage = $_SESSION["country"];
                                if ($websiteLanguage === 'tr') {
                                    echo "const formattedDate = date.toLocaleDateString('tr-TR', options);";
                                } else {
                                    echo "const formattedDate = date.toLocaleDateString(undefined, options);";
                                }
                                ?>

                                return formattedDate;
                            }

                            const formattedCreatedAt = formatCreatedAt(product.renewal_date);

                            // Format the currency amount based on your requirement
                            let statusColorClass = '';
                            let statusTitle = '';

                            if (product.status === 'Active') {
                                statusColorClass = 'bg-green-500 dark:bg-green-600';
                                statusTitle = '<?php echo $lang['product-status-active']?>';
                            } else if (product.status === 'Overdue') {
                                statusColorClass = 'bg-red-500 dark:bg-red-600';
                                statusTitle = '<?php echo $lang['product-status-overdue']?>';
                            } else if (product.status === 'Pending') {
                                statusColorClass = 'bg-yellow-500 dark:bg-yellow-600';
                                statusTitle = '<?php echo $lang['product-status-pending']?>';
                            }

                            // Determine the text color for "Renew in X days"
                            let renewDaysText = '<?php echo $lang['waiting-for-payment']?>';
                            let renewDateDisplay = ''; // Declare renewDateDisplay outside the if block
                            let renewDaysColorClass = '';

                            if (product.renewal_date === null) {
                                renewDateDisplay = 'hidden'; // Modify the variable declared outside the block
                            }
                            if (product.renewal_date !== null) {
                                if (product.days_left > 30) {
                                    const monthsLeft = Math.ceil(product.days_left / 30);

                                    if (monthsLeft < 12) {
                                        renewDaysText = '<?php echo $lang['renew-in-d-months']; ?>'.replace('%d', monthsLeft);
                                    } else {
                                        const yearsLeft = Math.floor(monthsLeft / 12);
                                        const remainingMonths = monthsLeft % 12;
                                        renewDaysText = '<?php echo $lang['renew-in-d-years']; ?>'.replace('%d', yearsLeft);
                                    }

                                    renewDaysColorClass = 'text-gray-500'; // Blue for more than 30 days left
                                } else if (product.days_left <= 30 && product.days_left > 7) {
                                    renewDaysText = '<?php echo $lang['renew-in-d-days']; ?>'.replace('%d', product.days_left);
                                    renewDaysColorClass = 'text-green-500'; // Green for 8 to 30 days left
                                } else if (product.days_left <= 7 && product.days_left > 3) {
                                    renewDaysText = '<?php echo $lang['renew-in-d-days']; ?>'.replace('%d', product.days_left);
                                    renewDaysColorClass = 'text-yellow-500'; // Yellow for 4 to 7 days left
                                } else if (product.days_left <= 3 && product.days_left > 1) {
                                    renewDaysText = '<?php echo $lang['renew-in-d-days']; ?>'.replace('%d', product.days_left);
                                    renewDaysColorClass = 'text-red-500'; // Red for 3 or fewer days left
                                } else if (product.days_left <= 1 && product.days_left >= 0) {
                                    renewDaysText = '<?php echo $lang['renew-in-d-days']; ?>'.replace('%d', product.days_left);
                                    renewDaysColorClass = 'text-red-500'; // Red for 3 or fewer days left
                                } else if (product.days_left < 0) {
                                    const overdueDays = Math.abs(product.days_left);
                                    renewDaysText = '<?php echo $lang['overdue-d-days-ago']; ?>'.replace('%d', overdueDays);
                                    renewDaysColorClass = 'text-red-500'; // Red for overdue
                                }
                            }


                            const productRow = $("<div class='block md:flex justify-between mb-4 px-4 sm:px-5 py-4 sm:py-6 space-y-4 md:space-y-0 rounded-3xl bg-gray-50 dark:bg-dark-600 max-h-36 md:max-h-24 overflow-hidden w-full'>");

                            productRow.html(`
                                <!-- Left side -->
                                <span class="flex md:space-x-12 justify-between items-center">

                                    <!-- Status and Product Name -->
                                    <span class="text-left font-medium text-gray-900 whitespace-nowrap dark:text-white sm:max-w-56 w-full flex items-center">
                                        <!-- Status Badge -->
                                        <span class="mr-3 hidden sm:block">
                                            <span class="material-symbols-outlined text-4xl">category</span>
                                        </span>
                                        <span class="flex items-center justify-between flex-row-reverse w-full sm:block sm:space-y-1">
                                            <!-- Status Badge -->
                                            <span class="inline items-center text-xs ${statusColorClass} text-white rounded-xl py-1 px-3 sm:py-0.5 sm:px-2">${statusTitle}</span>
                                            <!-- Product Name -->
                                            <span class="font-semibold text-lg block text-gray-700 dark:text-gray-300">${product.name}</span>
                                        </span>
                                    </span>
                                </span>
                            <!-- Right side -->
                                <span class="flex md:space-x-3 justify-between items-center">

                                    <!-- Date and Renewal -->
                                    <span class="block text-center">
                                        <!-- Date and Renewal information -->
                                        <span class="flex items-center space-x-1 ${renewDateDisplay}">
                                            <span class="material-symbols-outlined block dark:text-gray-400 text-sm">history</span>
                                            <span class="block dark:text-gray-400 text-sm">${formattedCreatedAt}</span>
                                        </span>
                                        <span class="${renewDaysColorClass} text-sm font-semibold">${renewDaysText}</span>
                                    </span>

                                    <!-- Action Button -->
                                    <span class="flex">
                                        <button id="dropdownMenu${product.order_number}" data-dropdown-toggle="dropdown${product.order_number}" class="flex w-full text-center text-white bg-dark-700 hover:bg-dark-800 focus:ring-0 font-medium rounded-full text-sm p-3 dark:bg-dark-700 dark:hover:bg-dark-800 focus:outline-none" type="button">
                                        <svg class="w-5 h-5" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="currentColor" viewBox="0 0 4 15">
                                        <path d="M3.5 1.5a1.5 1.5 0 1 1-3 0 1.5 1.5 0 0 1 3 0Zm0 6.041a1.5 1.5 0 1 1-3 0 1.5 1.5 0 0 1 3 0Zm0 5.959a1.5 1.5 0 1 1-3 0 1.5 1.5 0 0 1 3 0Z"/>
                                        </svg>
                                    </button>

                                        <!-- Dropdown menu -->
                                        <div id="dropdown${product.order_number}" class="z-10 hidden bg-white divide-y divide-gray-100 rounded-2xl shadow w-44 dark:bg-dark-600 dark:divide-dark-500">
                                            <ul class="py-2 text-left text-sm text-gray-700 dark:text-gray-200" aria-labelledby="dropdownMenu${product.order_number}">
                                              <li>
                                                <a href="<?php echo url('/account/billing/invoices'); ?>" class="block px-4 py-2 hover:bg-gray-100 dark:hover:bg-dark-500 dark:hover:text-white rounded-xl"><?php echo $lang['cloud-invoices']?></a>
                                              </li>
                                            </ul>
                                            <div class="py-2">
                                              <a href="<?php echo url('/account/support/new'); ?>" class="block px-4 py-2 text-sm text-gray-700 hover:bg-gray-100 dark:hover:bg-dark-500 dark:text-gray-200 dark:hover:text-white rounded-xl"><?php echo $lang['cloud-support']?></a>
                                            </div>
                                        </div>
                                    </span>
                                </span>
                        `);

                            // Append the row to the product list
                            products.append(productRow);
                        });
                    }

                },
                error: function(xhr, status, error) {
                    console.log("AJAX Error: " + error);
                }
            });
        }

        // Initial load of user profile
        loadProducts();
    });



</script>
