<?php
$meta = array(
    'us' => array(
        'title' => 'Datanito - Update Your Profile',
        'description' => 'Manage and update your profile on Datanito. Customize your information, profile picture, and more.',
        'og:title' => 'Datanito - Update Your Profile',
        'og:description' => 'Manage and update your profile on Datanito. Customize your information, profile picture, and more.',
        'og:image' => asset('images/brand/open_graph_logo.png'),
    ),
    'tr' => array(
        'title' => 'Datanito (Türkiye) - Profilinizi Güncelleyin',
        'description' => 'Datanito\'da profilinizi yönetin ve güncelleyin. Bilgilerinizi, profil fotoğrafınızı ve daha fazlasını özelleştirin.',
        'og:title' => 'Datanito (Türkiye) - Profilinizi Güncelleyin',
        'og:description' => 'Datanito\'da profilinizi yönetin ve güncelleyin. Bilgilerinizi, profil fotoğrafınızı ve daha fazlasını özelleştirin.',
        'og:image' => asset('images/brand/open_graph_logo.png'),
    ),
);
$currentMeta = setCountryAndMeta($meta);
include_once includes('layouts/dashboard.php');
?>
<main class="p-4 md:pl-64 md:ml-8 md:mr-4 h-full pt-20 min-h-[70em] overflow-hidden">
    <div class="container mx-auto py-8">
        <div class="flex flex-col md:flex-row md:space-x-6 space-y-6 md:space-y-0">
            <div class="md:w-1/3">
                <div class="bg-white dark:bg-dark-900 rounded-xl border border-gray-100 dark:border-dark-500 p-6 skeleton">
                    <div class="user-avatar-show !w-12 !h-12"></div>
                    <h5 class="mb-1 text-xl font-medium text-gray-900 dark:text-white user-name"></h5>
                    <div class="flex items-center">
                        <p class="text-sm text-gray-500 dark:text-gray-400 user-username"></p>
                        <span class="flex user-verification-badge"></span>
                    </div>
                    <p class="text-sm text-gray-500 dark:text-gray-400 user-email"></p>
                </div>
            </div>
            <div class="md:w-2/3">
                <div class="bg-white dark:bg-dark-900 rounded-2xl border border-gray-100 dark:border-dark-500 p-6 mb-6 skeleton">
                    <div class="flex items-center justify-center relative">
                        <div class="relative group w-32 h-32">
                            <!-- User Avatar -->
                            <div class="user-avatar bg-gray-200 dark:bg-dark-600 rounded-full flex items-center justify-center text-gray-600 text-lg w-full h-full overflow-hidden">
                                <span></span>
                            </div>
                            <!-- Upload Logo Input -->
                            <div class="absolute inset-0 flex items-center justify-center opacity-0 group-hover:opacity-100 transition-opacity duration-300 cursor-pointer">
                                <label for="upload-logo" class="flex items-center justify-center w-full h-full bg-black bg-opacity-50 rounded-full">
                                    <span class="material-symbols-outlined text-white text-3xl">add_a_photo</span>
                                </label>
                                <input type="file" id="upload-logo" accept="image/*" class="hidden">
                            </div>
                        </div>
                    </div>

                </div>
                <form id="profileUpdateForm" class="bg-white dark:bg-dark-900 rounded-2xl border border-gray-100 dark:border-dark-500 p-6 skeleton" autocomplete="off">
                    <h3 class="text-2xl tracking-tight font-semibold text-gray-900 dark:text-white"><?php echo $lang['update-profile-headline']; ?></h3>
                    <?php set_csrf(); ?>
                    <div class="block space-y-3 mt-6">
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                            <div>
                                <label for="name" class="block text-sm font-medium text-gray-900 dark:text-white"><?php echo $lang['update-profile-form-name']; ?></label>
                                <input type="text" name="name" id="name" class="block w-full bg-white dark:bg-dark-600 mt-1 px-3 py-2 rounded-2xl border-gray-300 dark:border-gray-600 focus:ring-blue-500 focus:border-blue-500 text-gray-900 dark:text-white">
                            </div>
                            <div>
                                <label for="username" class="block text-sm font-medium text-gray-900 dark:text-white"><?php echo $lang['update-profile-form-username']; ?></label>
                                <input type="text" name="username" id="username" class="block w-full bg-white dark:bg-dark-600 mt-1 px-3 py-2 rounded-2xl border-gray-300 dark:border-gray-600 focus:ring-blue-500 focus:border-blue-500 text-gray-900 dark:text-white">
                            </div>
                        </div>
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                            <div>
                                <label for="email" class="block text-sm font-medium text-gray-900 dark:text-white"><?php echo $lang['update-profile-form-email']; ?></label>
                                <input type="email" name="email" id="email" class="block w-full bg-white dark:bg-dark-600 mt-1 px-3 py-2 rounded-2xl border-gray-300 dark:border-gray-600 focus:ring-blue-500 focus:border-blue-500 text-gray-900 dark:text-white">
                            </div>
                            <div>
                                <label for="phone-number" class="block text-sm font-medium text-gray-900 dark:text-white"><?php echo $lang['update-profile-form-phone-number']; ?></label>
                                <input type="tel" name="phone-number" id="phone-number" class="block w-full bg-white dark:bg-dark-600 mt-1 px-3 py-2 rounded-2xl border-gray-300 dark:border-gray-600 focus:ring-blue-500 focus:border-blue-500 text-gray-900 dark:text-white">
                            </div>
                        </div>
                        <div class="col-span-2">
                            <label for="currency" class="block text-sm font-medium text-gray-900 dark:text-white"><?php echo $lang['update-profile-form-currency-placeholder']; ?></label>
                            <select name="currency" id="currency" class="block w-full bg-white dark:bg-dark-600 mt-1 px-3 py-2 rounded-2xl border-gray-300 dark:border-gray-600 focus:ring-blue-500 focus:border-blue-500 text-gray-900 dark:text-white">
                                <option value="USD">USD</option>
                                <option value="TRY">TRY</option>
                                <option value="EUR">EUR</option>
                                <option value="GBP">GBP</option>
                            </select>
                        </div>
                        <div class="col-span-2">
                            <label for="password" class="block text-sm font-medium text-gray-900 dark:text-white"><?php echo $lang['update-profile-form-password']; ?></label>
                            <input type="password" name="password" id="password" class="block w-full bg-white dark:bg-dark-600 mt-1 px-3 py-2 rounded-2xl border-gray-300 dark:border-gray-600 focus:ring-blue-500 focus:border-blue-500 text-gray-900 dark:text-white" autocomplete="off">
                        </div>
                        <div class="col-span-2">
                            <label for="confirmPassword" class="block text-sm font-medium text-gray-900 dark:text-white"><?php echo $lang['update-profile-form-confirm-password']; ?></label>
                            <input type="password" name="confirmPassword" id="confirmPassword" class="block w-full bg-white dark:bg-dark-600 mt-1 px-3 py-2 rounded-2xl border-gray-300 dark:border-gray-600 focus:ring-blue-500 focus:border-blue-500 text-gray-900 dark:text-white" autocomplete="off">
                        </div>
                    </div>
                    <div class="mt-6">
                        <button type="submit" class="inline-block w-full px-4 py-2 text-sm font-medium text-white bg-blue-700 hover:bg-blue-800 rounded-2xl focus:outline-none focus:ring-2 focus:ring-blue-500 focus:ring-offset-2"><?php echo $lang['update-profile-form-cta']; ?></button>
                    </div>
                </form>
            </div>
        </div>
    </div>

</main>

<?php
include_once includes('layouts/dashboard-end.php');
?>
<script>
    $(document).ready(function () {
        var csrf = $('input[name="csrf"]').val();
        $('.spinner').show();

        // Function to load user profile information
        function loadProfile() {
            $.ajax({
                type: 'POST',
                url: '/view_profile',
                dataType: 'json',
                data: {
                    csrf: csrf, // Make sure you have the 'csrf' variable defined
                },
                success: function (data) {
                    $('.spinner').hide();
                    if (data.user_name) {
                        // Populate user information into HTML elements
                        $('.user-name').text(data.user_name);
                        $('.user-email').text(data.user_email);
                        if (data.user_username) {
                            $('.user-username').text('@'+data.user_username);
                        }
                        $('.user-id').text(data.user_id);
                        $('.user-avatar span').html(data.userAvatar);
                        $('.user-avatar-show').html(data.userAvatar);
                        $('.user-avatar img').addClass('!w-24 !h-24 w-full h-full object-cover');
                        $('.user-avatar img').addClass('!w-36 !h-36 w-full h-full object-cover');
                        $('.user-avatar-show img').addClass('!w-10 !h-10');
                        $('.user-avatar-show img').addClass('!w-12 !h-12');
                        $('.user-verification-badge').html(data.user_verificationBadge);
                        $('#name').val(data.user_name);

                        // Populate the 'username' input field
                        $('#username').val(data.user_username);

                        // Populate the 'email' input field
                        $('#email').val(data.user_email);
                        $('#phone-number').val(data.user_phoneNumber);
                    } else {
                        // Handle the case where there is an error or the user is not logged in
                        $('.user-profile').html('<p>Error fetching user profile.</p>');
                    }
                },
                error: function (error) {
                    // Handle error if needed
                    $('#user-profile').html('<p>An error occurred while fetching user profile.</p>');
                }
            });
        }

        // Initial load of user profile
        loadProfile();
// Handle the file input change event
        $('#upload-logo').on('change', function (e) {
            var fileInput = e.target;
            if (fileInput.files.length > 0) {
                var file = fileInput.files[0];

                // Validate the file type (you can add more file type checks)
                if (file.type.startsWith('image/')) {
                    var reader = new FileReader();

                    reader.onload = function (event) {
                        // Create an image element to load the selected image
                        var img = new Image();
                        img.src = event.target.result;

                        img.onload = function () {
                            // Calculate the dimensions for cropping to a 1x1 aspect ratio
                            var aspectRatio = 1; // 1x1 aspect ratio
                            var width = img.width;
                            var height = img.height;
                            var size = Math.min(width, height);
                            var x = (width - size) / 2;
                            var y = (height - size) / 2;

                            // Create a canvas to draw the cropped image
                            var canvas = document.createElement('canvas');
                            canvas.width = size;
                            canvas.height = size;
                            var ctx = canvas.getContext('2d');
                            ctx.drawImage(img, x, y, size, size, 0, 0, size, size);

                            // Convert the cropped image to a data URL
                            var croppedDataURL = canvas.toDataURL('image/jpeg'); // You can specify the desired format

                            // Update the image preview with the cropped image
                            $('.user-avatar img').attr('src', croppedDataURL);
                        };
                    };

                    reader.readAsDataURL(file);
                } else {
                    // Handle invalid file type
                    alert('Invalid file type. Please select an image.');
                }
            }
        });

        $(document).ready(function () {
            $('#profileUpdateForm').submit(function (e) {
                e.preventDefault();
                $('.spinner').show();

                // Serialize the form data
                var formData = new FormData(this);

                // Handle the file input separately
                var fileInput = $('#upload-logo')[0];
                if (fileInput.files.length > 0) {
                    formData.append('profile-picture', fileInput.files[0]);
                }

                $.ajax({
                    type: 'POST',
                    url: '/update_profile',
                    data: formData,
                    processData: false,
                    contentType: false, // Set content type to false for FormData
                    success: function (response) {
                        var result = JSON.parse(response);
                        console.log(result.message); // Debugging statement

                        // Update the profile information after successful update
                        loadProfile();
                        $('.spinner').hide();

                        // Show a success message (you can customize this part)
                        $("#toast-success").css("display", "flex");
                        $("#toast-success").removeClass("hidden");
                        $(".toast-message").text(result.message);
                        if (result.icon === 'error') {
                            $(".notification-success").addClass("hidden");
                            $(".notification-error").removeClass("hidden");
                        }
                        $("#toast-success").addClass("notification-opened");
                        $("#toast-success svg").addClass("notification-checkmark");
                        $("#toast-success").removeClass("notification-closed");

                        // Hide the success message after 2 seconds
                        setTimeout(function () {
                            $("#toast-success").addClass("notification-closed");
                            $("#toast-success").removeClass("notification-opened");
                            $("#toast-success svg").removeClass("notification-checkmark");
                        }, 2000);
                    },
                    error: function (error) {
                        // Handle AJAX error here if needed
                        alert('Error: ' + error.responseText);
                    }
                });
            });
        });


    });


</script>
