<?php
$meta = array(
    'us' => array(
        'title' => 'Datanito - Your Account Overview',
        'description' => 'Get an overview of your Datanito account. Manage your profile, settings, and more from your account dashboard.',
        'og:title' => 'Datanito - Your Account Overview',
        'og:description' => 'Get an overview of your Datanito account. Manage your profile, settings, and more from your account dashboard.',
        'og:image' => asset('images/brand/open_graph_logo.png'),
    ),
    'tr' => array(
        'title' => 'Datanito - Hesap Genel Bakışı',
        'description' => 'Datanito hesabınızın genel bir bakışını alın. Profilinizi, ayarlarınızı ve daha fazlasını hesap panelinizden yönetin.',
        'og:title' => 'Datanito - Hesap Genel Bakışı',
        'og:description' => 'Datanito hesabınızın genel bir bakışını alın. Profilinizi, ayarlarınızı ve daha fazlasını hesap panelinizden yönetin.',
        'og:image' => asset('images/brand/open_graph_logo.png'),
    ),
);

$lang = array(
    'us' => array(
        // Profile Section
        'welcome-back' => 'Welcome back',
        'profile-since' => 'Member since',
        'edit-profile' => 'Edit Profile',
        'view-profile' => 'View Profile',
        'verified-account' => 'Verified account',
        'verified-since' => 'Verified since',
        'learn-more' => 'Learn more',
        'get-verified' => 'Get Verified',
        'datanito-profile-id' => 'Datanito Profile ID:',

        // Email Verification
        'resend-email-conformation-headline' => 'Please verify your email address',
        'resend-email-conformation-cta' => 'Resend Verification',

        // Dino AI Section
        'dino' => 'Dino',
        'ai' => 'AI',
        'dino-new-chat' => 'New Chat',
        'dino-recent-conversations' => 'Recent Conversations',
        'account-dino-c-modal-today' => 'Today',
        'account-dino-c-modal-yesterday' => 'Yesterday',
        'account-dino-c-modal-a-week-ago' => 'This Week',
        'account-dino-c-modal-a-month-ago' => 'This Month',
        'account-dino-c-modal-other-month' => 'Older',

        // Analytics Section
        'DAnalytics' => 'Analytics',
        'datanito-analytics-no-domain-headline' => 'No Website Connected',
        'datanito-analytics-no-domain-subheading' => 'Connect your website to start tracking analytics and gain valuable insights.',
        'datanito-analytics-no-domain-cta' => 'Connect Website',

        // Cloud Section
        'DCloud' => 'Cloud',
        'cloud-add-new' => 'Add New',
        'cloud' => 'Cloud Services',
        'web-hosting' => 'Web Hosting',
        'business-hosting' => 'Business Hosting',
        'cloud-products-empty-headline' => 'No Cloud Products',
        'cloud-products-empty-subheading' => 'Get started by adding your first cloud service or hosting package.',

        // Pay Section
        'datanito-pay' => 'Pay',
        'datanito-pay-notice-subheading' => 'Manage your payments, subscriptions, and billing information in one place.',

        // Product Status
        'product-status-active' => 'Active',
        'product-status-overdue' => 'Overdue',
        'product-status-pending' => 'Pending',
        'renew-in-d-months' => 'Renew in %d months',
        'renew-in-d-years' => 'Renew in %d years',
        'renew-in-d-days' => 'Renew in %d days',
        'overdue-d-days-ago' => 'Overdue %d days ago',
        'waiting-for-payment' => 'Waiting for payment',
    ),
    'tr' => array(
        // Profile Section
        'welcome-back' => 'Tekrar hoş geldiniz',
        'profile-since' => 'Üyelik tarihi',
        'edit-profile' => 'Profili Düzenle',
        'view-profile' => 'Profili Görüntüle',
        'verified-account' => 'Doğrulanmış hesap',
        'verified-since' => 'Doğrulama tarihi',
        'learn-more' => 'Daha fazla bilgi',
        'get-verified' => 'Doğrulan',
        'datanito-profile-id' => 'Datanito Profil ID:',

        // Email Verification
        'resend-email-conformation-headline' => 'Lütfen e-posta adresinizi doğrulayın',
        'resend-email-conformation-cta' => 'Doğrulama Gönder',

        // Dino AI Section
        'dino' => 'Dino',
        'ai' => 'AI',
        'dino-new-chat' => 'Yeni Sohbet',
        'dino-recent-conversations' => 'Son Konuşmalar',
        'account-dino-c-modal-today' => 'Bugün',
        'account-dino-c-modal-yesterday' => 'Dün',
        'account-dino-c-modal-a-week-ago' => 'Bu Hafta',
        'account-dino-c-modal-a-month-ago' => 'Bu Ay',
        'account-dino-c-modal-other-month' => 'Daha Eski',

        // Analytics Section
        'DAnalytics' => 'Analiz',
        'datanito-analytics-no-domain-headline' => 'Bağlı Web Sitesi Yok',
        'datanito-analytics-no-domain-subheading' => 'Analizleri takip etmeye başlamak ve değerli bilgiler elde etmek için web sitenizi bağlayın.',
        'datanito-analytics-no-domain-cta' => 'Web Sitesi Bağla',

        // Cloud Section
        'DCloud' => 'Bulut',
        'cloud-add-new' => 'Yeni Ekle',
        'cloud' => 'Bulut Hizmetleri',
        'web-hosting' => 'Web Hosting',
        'business-hosting' => 'İş Hosting',
        'cloud-products-empty-headline' => 'Bulut Ürünü Yok',
        'cloud-products-empty-subheading' => 'İlk bulut hizmetinizi veya hosting paketinizi ekleyerek başlayın.',

        // Pay Section
        'datanito-pay' => 'Ödeme',
        'datanito-pay-notice-subheading' => 'Ödemelerinizi, aboneliklerinizi ve fatura bilgilerinizi tek bir yerden yönetin.',

        // Product Status
        'product-status-active' => 'Aktif',
        'product-status-overdue' => 'Gecikmiş',
        'product-status-pending' => 'Beklemede',
        'renew-in-d-months' => '%d ay sonra yenile',
        'renew-in-d-years' => '%d yıl sonra yenile',
        'renew-in-d-days' => '%d gün sonra yenile',
        'overdue-d-days-ago' => '%d gün önce gecikti',
        'waiting-for-payment' => 'Ödeme bekleniyor',
    )
);

$currentMeta = setCountryAndMeta($meta);
$currentLang = $lang[$_SESSION['country']] ?? $lang['us'];
include_once includes('layouts/dashboard.php');
?>

<main class="p-4 md:pl-64 md:ml-8 md:mr-4 h-full pt-20 min-h-[70em] !overflow-hidden">
    <!-- Email Verification Banner -->
    <div id="email-confirmation-banner" tabindex="-1" class="hidden rounded-2xl bg-yellow-50 dark:bg-yellow-900/20 border border-yellow-200 dark:border-yellow-800 p-4 flex flex-col sm:flex-row items-center justify-between mb-6 animate-fade-in">
        <div class="flex items-center mb-3 sm:mb-0">
            <span class="flex items-center justify-center w-8 h-8 rounded-full bg-yellow-100 dark:bg-yellow-800 text-yellow-600 dark:text-yellow-300 mr-3">
                <span class="material-symbols-outlined">mail</span>
            </span>
            <p class="text-sm font-medium text-yellow-800 dark:text-yellow-200">
                <?php echo $currentLang['resend-email-conformation-headline']?>
            </p>
        </div>
        <div>
            <?php set_csrf(); ?>
            <button id="resend-verification-button" class="w-full sm:w-auto flex items-center justify-center px-4 py-2 bg-yellow-600 hover:bg-yellow-700 text-white text-sm font-medium rounded-lg transition-colors" type="button">
                <span><?php echo $currentLang['resend-email-conformation-cta']?></span>
                <span class="material-symbols-outlined ml-1">send</span>
            </button>
        </div>
    </div>

    <!-- Main Dashboard Grid -->
    <div class="grid grid-cols-1 lg:grid-cols-3 gap-6 mb-6">
        <!-- Profile Card -->
        <div class="bg-white dark:bg-dark-800 rounded-2xl border border-gray-200 dark:border-dark-700 shadow-xs overflow-hidden">
            <div class="p-6 pb-0">
                <div class="flex justify-between items-start">
                    <div>
                        <h3 class="text-sm font-medium text-gray-500 dark:text-gray-400 mb-1">
                            <?php echo $currentLang['welcome-back']?>
                        </h3>
                        <h2 class="text-xl font-semibold text-gray-900 dark:text-white user-name"></h2>
                    </div>
                    <div class="flex space-x-2">
                        <a href="<?php echo url('/account/profile'); ?>" class="p-2 rounded-lg bg-gray-100 dark:bg-dark-700 text-gray-700 dark:text-gray-300 hover:bg-gray-200 dark:hover:bg-dark-600 transition-colors" title="<?php echo $currentLang['edit-profile']?>">
                            <span class="material-symbols-outlined">edit</span>
                        </a>
                    </div>
                </div>

                <div class="mt-6 flex justify-center">
                    <div class="relative">
                        <div class="user-avatar w-24 h-24 rounded-full overflow-hidden border-4 border-white dark:border-dark-700 shadow-md mx-auto">
                            <!-- Avatar will be inserted here -->
                        </div>
                        <span class="user-verification-badge absolute -bottom-2 -right-2"></span>
                    </div>
                </div>

                <div class="mt-4 text-center">
                    <p class="text-sm text-gray-500 dark:text-gray-400 user-username"></p>
                    <p class="text-xs text-gray-400 dark:text-gray-500 mt-1">
                        <?php echo $currentLang['datanito-profile-id']?> <span class="user-id font-medium"></span>
                    </p>
                </div>
            </div>

            <div class="mt-6 border-t border-gray-200 dark:border-dark-700 p-4">
                <div class="flex justify-between items-center">
                    <div class="flex items-center">
                        <span class="material-symbols-outlined text-gray-400 dark:text-gray-500 mr-2">calendar_today</span>
                        <span class="text-sm text-gray-600 dark:text-gray-300">
                            <?php echo $currentLang['profile-since']?> <span class="member-since-date font-medium"></span>
                        </span>
                    </div>
                    <a href="<?php echo url('/account/profile'); ?>" class="text-sm font-medium text-blue-600 dark:text-blue-400 hover:underline flex items-center">
                        <?php echo $currentLang['view-profile']?>
                        <span class="material-symbols-outlined ml-1 text-base">chevron_right</span>
                    </a>
                </div>
            </div>
        </div>

        <!-- Dino AI Card -->
        <div class="bg-white dark:bg-dark-800 rounded-2xl border border-gray-200 dark:border-dark-700 shadow-xs overflow-hidden">
            <div class="p-6">
                <div class="flex justify-between items-center mb-4">
                    <div class="flex items-center">
                        <div class="bg-purple-100 dark:bg-purple-900/20 text-purple-600 dark:text-purple-300 p-2 rounded-lg mr-3">
                            <span class="material-symbols-outlined">smart_toy</span>
                        </div>
                        <h3 class="text-xl font-semibold text-gray-900 dark:text-white">
                            <?php echo $currentLang['dino']?> <span class="text-purple-600 dark:text-purple-300"><?php echo $currentLang['ai']?></span>
                        </h3>
                    </div>
                    <a href="<?php echo url('/account/dino'); ?>" class="flex items-center px-4 py-2 bg-purple-600 hover:bg-purple-700 text-white text-sm font-medium rounded-lg transition-colors">
                        <?php echo $currentLang['dino-new-chat']?>
                        <span class="material-symbols-outlined ml-1">add</span>
                    </a>
                </div>

                <div class="mb-3 flex justify-between items-center">
                    <h4 class="text-sm font-medium text-gray-500 dark:text-gray-400">
                        <?php echo $currentLang['dino-recent-conversations']?>
                    </h4>
                    <a href="<?php echo url('/account/dino'); ?>" class="text-xs text-blue-600 dark:text-blue-400 hover:underline">
                        <?php echo $currentLang['view-all']?>
                    </a>
                </div>

                <div class="space-y-3 max-h-64 overflow-y-auto pr-2">
                    <div id="conversationList" class="space-y-2">
                        <!-- Conversations will be loaded here -->
                    </div>

                    <div id="noConversations" class="hidden py-8 text-center">
                        <span class="material-symbols-outlined mx-auto text-gray-400 dark:text-gray-500 text-4xl mb-3">forum</span>
                        <p class="text-gray-500 dark:text-gray-400 text-sm">
                            <?php echo $currentLang['no-conversations']?>
                        </p>
                        <a href="<?php echo url('/account/dino'); ?>" class="inline-block mt-3 px-4 py-2 bg-purple-600 hover:bg-purple-700 text-white text-sm font-medium rounded-lg transition-colors">
                            <?php echo $currentLang['start-chat']?>
                        </a>
                    </div>
                </div>
            </div>
        </div>

        <!-- Analytics Card -->
        <div class="bg-white dark:bg-dark-800 rounded-2xl border border-gray-200 dark:border-dark-700 shadow-xs overflow-hidden">
            <div class="p-6">
                <div class="flex justify-between items-center mb-4">
                    <div class="flex items-center">
                        <div class="bg-blue-100 dark:bg-blue-900/20 text-blue-600 dark:text-blue-300 p-2 rounded-lg mr-3">
                            <span class="material-symbols-outlined">analytics</span>
                        </div>
                        <h3 class="text-xl font-semibold text-gray-900 dark:text-white">
                            <?php echo $currentLang['DAnalytics']?>
                        </h3>
                    </div>
                    <div id="website_info" class="hidden">
                        <span class="flex items-center text-xs font-medium px-3 py-1.5 rounded-full bg-gray-100 dark:bg-dark-700 text-gray-700 dark:text-gray-300">
                            <span class="material-symbols-outlined mr-1 text-base">language</span>
                            <span id="website_url" class="truncate max-w-[120px]"></span>
                        </span>
                    </div>
                </div>

                <div id="website-info" class="min-h-[200px]">
                    <!-- Analytics data will be loaded here -->
                    <div class="flex flex-col items-center justify-center py-8">
                        <div class="spinner">
                            <svg aria-hidden="true" class="inline w-10 h-10 text-gray-200 animate-spin dark:text-gray-600 fill-blue-500" viewBox="0 0 100 101" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path d="M100 50.5908C100 78.2051 77.6142 100.591 50 100.591C22.3858 100.591 0 78.2051 0 50.5908C0 22.9766 22.3858 0.59082 50 0.59082C77.6142 0.59082 100 22.9766 100 50.5908ZM9.08144 50.5908C9.08144 73.1895 27.4013 91.5094 50 91.5094C72.5987 91.5094 90.9186 73.1895 90.9186 50.5908C90.9186 27.9921 72.5987 9.67226 50 9.67226C27.4013 9.67226 9.08144 27.9921 9.08144 50.5908Z" fill="currentColor"/>
                                <path d="M93.9676 39.0409C96.393 38.4038 97.8624 35.9116 97.0079 33.5539C95.2932 28.8227 92.871 24.3692 89.8167 20.348C85.8452 15.1192 80.8826 10.7238 75.2124 7.41289C69.5422 4.10194 63.2754 1.94025 56.7698 1.05124C51.7666 0.367541 46.6976 0.446843 41.7345 1.27873C39.2613 1.69328 37.813 4.19778 38.4501 6.62326C39.0873 9.04874 41.5694 10.4717 44.0505 10.1071C47.8511 9.54855 51.7191 9.52689 55.5402 10.0491C60.8642 10.7766 65.9928 12.5457 70.6331 15.2552C75.2735 17.9648 79.3347 21.5619 82.5849 25.841C84.9175 28.9121 86.7997 32.2913 88.1811 35.8758C89.083 38.2158 91.5421 39.6781 93.9676 39.0409Z" fill="currentFill"/>
                            </svg>
                            <span class="sr-only">Loading...</span>
                        </div>
                    </div>
                </div>

                <div class="mt-4 border-t border-gray-200 dark:border-dark-700 pt-4">
                    <a href="<?php echo url('/account/analytics'); ?>" class="flex items-center justify-center text-sm font-medium text-blue-600 dark:text-blue-400 hover:underline">
                        <?php echo $currentLang['view-full-analytics']?>
                        <span class="material-symbols-outlined ml-1">chevron_right</span>
                    </a>
                </div>
            </div>
        </div>
    </div>

    <!-- Second Row -->
    <div class="grid grid-cols-1 lg:grid-cols-2 gap-6">
        <!-- Cloud Services Card -->
        <div class="bg-white dark:bg-dark-800 rounded-2xl border border-gray-200 dark:border-dark-700 shadow-xs overflow-hidden">
            <div class="p-6">
                <div class="flex justify-between items-center mb-4">
                    <div class="flex items-center">
                        <div class="bg-green-100 dark:bg-green-900/20 text-green-600 dark:text-green-300 p-2 rounded-lg mr-3">
                            <span class="material-symbols-outlined">cloud</span>
                        </div>
                        <h3 class="text-xl font-semibold text-gray-900 dark:text-white">
                            <?php echo $currentLang['DCloud']?>
                        </h3>
                    </div>

                    <div class="relative">
                        <button id="addNewCloudButton" data-dropdown-toggle="addNewCloud" class="flex items-center px-4 py-2 bg-green-600 hover:bg-green-700 text-white text-sm font-medium rounded-lg transition-colors">
                            <?php echo $currentLang['cloud-add-new']?>
                            <span class="material-symbols-outlined ml-1">expand_more</span>
                        </button>

                        <!-- Dropdown menu -->
                        <div id="addNewCloud" class="hidden absolute z-10 right-0 mt-2 w-48 bg-white dark:bg-dark-700 rounded-lg shadow-lg border border-gray-200 dark:border-dark-600">
                            <ul class="py-1">
                                <li>
                                    <a href="<?php echo url('/cloud'); ?>" class="block px-4 py-2 text-sm text-gray-700 dark:text-gray-300 hover:bg-gray-100 dark:hover:bg-dark-600">
                                        <?php echo $currentLang['cloud']?>
                                    </a>
                                </li>
                                <li>
                                    <a href="<?php echo url('/cloud/web-hosting'); ?>" class="block px-4 py-2 text-sm text-gray-700 dark:text-gray-300 hover:bg-gray-100 dark:hover:bg-dark-600">
                                        <?php echo $currentLang['web-hosting']?>
                                    </a>
                                </li>
                                <li>
                                    <a href="<?php echo url('/cloud/business-hosting'); ?>" class="block px-4 py-2 text-sm text-gray-700 dark:text-gray-300 hover:bg-gray-100 dark:hover:bg-dark-600">
                                        <?php echo $currentLang['business-hosting']?>
                                    </a>
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>

                <div id="productsList" class="min-h-[300px]">
                    <div class="spinner flex justify-center items-center py-12">
                        <svg aria-hidden="true" class="inline w-10 h-10 text-gray-200 animate-spin dark:text-gray-600 fill-blue-500" viewBox="0 0 100 101" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path d="M100 50.5908C100 78.2051 77.6142 100.591 50 100.591C22.3858 100.591 0 78.2051 0 50.5908C0 22.9766 22.3858 0.59082 50 0.59082C77.6142 0.59082 100 22.9766 100 50.5908ZM9.08144 50.5908C9.08144 73.1895 27.4013 91.5094 50 91.5094C72.5987 91.5094 90.9186 73.1895 90.9186 50.5908C90.9186 27.9921 72.5987 9.67226 50 9.67226C27.4013 9.67226 9.08144 27.9921 9.08144 50.5908Z" fill="currentColor"/>
                            <path d="M93.9676 39.0409C96.393 38.4038 97.8624 35.9116 97.0079 33.5539C95.2932 28.8227 92.871 24.3692 89.8167 20.348C85.8452 15.1192 80.8826 10.7238 75.2124 7.41289C69.5422 4.10194 63.2754 1.94025 56.7698 1.05124C51.7666 0.367541 46.6976 0.446843 41.7345 1.27873C39.2613 1.69328 37.813 4.19778 38.4501 6.62326C39.0873 9.04874 41.5694 10.4717 44.0505 10.1071C47.8511 9.54855 51.7191 9.52689 55.5402 10.0491C60.8642 10.7766 65.9928 12.5457 70.6331 15.2552C75.2735 17.9648 79.3347 21.5619 82.5849 25.841C84.9175 28.9121 86.7997 32.2913 88.1811 35.8758C89.083 38.2158 91.5421 39.6781 93.9676 39.0409Z" fill="currentFill"/>
                        </svg>
                    </div>

                    <div class="empty-message hidden flex flex-col items-center justify-center py-12 text-center">
                        <span class="material-symbols-outlined mx-auto text-gray-400 dark:text-gray-500 text-4xl mb-3">cloud_off</span>
                        <h3 class="text-lg font-medium text-gray-700 dark:text-gray-300 mb-1">
                            <?php echo $currentLang['cloud-products-empty-headline']?>
                        </h3>
                        <p class="text-sm text-gray-500 dark:text-gray-400 mb-4">
                            <?php echo $currentLang['cloud-products-empty-subheading']?>
                        </p>
                        <button id="addNewCloudButton2" class="flex items-center px-4 py-2 bg-green-600 hover:bg-green-700 text-white text-sm font-medium rounded-lg transition-colors">
                            <?php echo $currentLang['cloud-add-new']?>
                            <span class="material-symbols-outlined ml-1">add</span>
                        </button>
                    </div>
                </div>
            </div>
        </div>

        <!-- Pay Services Card -->
        <div class="bg-white dark:bg-dark-800 rounded-2xl border border-gray-200 dark:border-dark-700 shadow-xs overflow-hidden">
            <div class="p-6">
                <div class="flex justify-between items-center mb-4">
                    <div class="flex items-center">
                        <div class="bg-orange-100 dark:bg-orange-900/20 text-orange-600 dark:text-orange-300 p-2 rounded-lg mr-3">
                            <span class="material-symbols-outlined">payments</span>
                        </div>
                        <h3 class="text-xl font-semibold text-gray-900 dark:text-white">
                            <?php echo $currentLang['datanito-pay']?>
                        </h3>
                    </div>
                    <a href="<?php echo url('/account/pay'); ?>" class="flex items-center px-4 py-2 bg-orange-600 hover:bg-orange-700 text-white text-sm font-medium rounded-lg transition-colors">
                        <?php echo $currentLang['view-all']?>
                        <span class="material-symbols-outlined ml-1">chevron_right</span>
                    </a>
                </div>

                <div class="flex flex-col items-center justify-center py-12 text-center">
                    <span class="material-symbols-outlined mx-auto text-gray-400 dark:text-gray-500 text-4xl mb-3">credit_card</span>
                    <h3 class="text-lg font-medium text-gray-700 dark:text-gray-300 mb-1">
                        <?php echo $currentLang['datanito-pay']?>
                    </h3>
                    <p class="text-sm text-gray-500 dark:text-gray-400 mb-4 max-w-md mx-auto">
                        <?php echo $currentLang['datanito-pay-notice-subheading']?>
                    </p>
                    <a href="<?php echo url('/account/pay'); ?>" class="flex items-center px-4 py-2 bg-orange-600 hover:bg-orange-700 text-white text-sm font-medium rounded-lg transition-colors">
                        <?php echo $currentLang['explore-pay']?>
                        <span class="material-symbols-outlined ml-1">arrow_forward</span>
                    </a>
                </div>
            </div>
        </div>
    </div>
</main>

<?php
include_once includes('layouts/dashboard-end.php');
?>

<script>
    $(document).ready(function() {
        // Initialize CSRF token
        const csrfToken = $('input[name="csrf"]').val();

        // Initialize tooltips
        $('[data-tooltip]').tooltip({
            trigger: 'hover',
            placement: 'top'
        });

        // Initialize dropdowns
        $('[data-dropdown-toggle]').on('click', function(e) {
            e.stopPropagation();
            const target = $(this).data('dropdown-toggle');
            $('#' + target).toggleClass('hidden');
        });

        // Close dropdowns when clicking outside
        $(document).on('click', function() {
            $('[data-dropdown]').addClass('hidden');
        });

        // Load all data when page loads
        loadProfile();
        fetchConversations();
        loadProducts();
        fetchAnalyticsData();

        // Set up periodic refresh (every 5 minutes)
        setInterval(fetchConversations, 300000);
        setInterval(loadProducts, 300000);
        setInterval(fetchAnalyticsData, 300000);

        // Resend verification email handler
        $('#resend-verification-button').on('click', function() {
            resendVerificationEmail();
        });

        // Click handler for the secondary cloud add button
        $('#addNewCloudButton2').on('click', function() {
            $('#addNewCloudButton').click();
        });

        // ==================== PROFILE FUNCTIONS ==================== //
        function loadProfile() {
            showLoading('.user-profile');

            $.ajax({
                type: 'POST',
                url: '/view_profile',
                dataType: 'json',
                data: { csrf: csrfToken },
                success: function(data) {
                    if (data.user_name) {
                        // Update profile information
                        $('.user-name').text(data.user_name);
                        $('.user-username').text(data.user_username ? '@' + data.user_username : '');

                        // Show email verification banner if needed
                        if (!data.email_verification_status) {
                            $('#email-confirmation-banner').removeClass('hidden').addClass('flex');
                        }

                        // Update other profile elements
                        $('.user-id').text(data.user_id);
                        $('.user-avatar').html(data.userAvatar || defaultAvatar());
                        $('.user-verification-badge').html(data.user_verificationBadge || '');

                        // Format and display member since date
                        if (data.member_since) {
                            const memberSince = new Date(data.member_since);
                            $('.member-since-date').text(memberSince.toLocaleDateString(undefined, {
                                year: 'numeric',
                                month: 'short'
                            }));
                        }
                    }
                },
                error: function(xhr, status, error) {
                    console.error('Error loading profile:', error);
                    showError('.user-profile', 'Failed to load profile data');
                }
            });
        }

        function defaultAvatar() {
            return '<div class="w-full h-full bg-gray-200 dark:bg-dark-600 flex items-center justify-center text-gray-400 dark:text-gray-500">' +
                '<span class="material-symbols-outlined">person</span></div>';
        }

        function resendVerificationEmail() {
            const button = $('#resend-verification-button');
            const originalText = button.html();

            // Show loading state
            button.prop('disabled', true).html(`
            <span class="inline-flex items-center">
                <svg class="animate-spin -ml-1 mr-2 h-4 w-4 text-white" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24">
                    <circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle>
                    <path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path>
                </svg>
                Sending...
            </span>
        `);

            $.ajax({
                type: 'POST',
                url: '/resend_verification_email',
                dataType: 'json',
                data: { csrf: csrfToken },
                success: function(response) {
                    if (response.success) {
                        $('#email-confirmation-banner').addClass('hidden');
                        showToast('Verification email sent successfully!', 'success');
                    } else {
                        showToast(response.message || 'Failed to send verification email', 'error');
                    }
                },
                error: function(xhr, status, error) {
                    console.error('Error resending verification:', error);
                    showToast('An error occurred. Please try again.', 'error');
                },
                complete: function() {
                    button.prop('disabled', false).html(originalText);
                }
            });
        }

        // ==================== DINO AI CONVERSATIONS ==================== //
        function fetchConversations() {
            showLoading('#conversationList');

            $.ajax({
                url: "/dino/fetch_conversations",
                type: "POST",
                dataType: "json",
                data: { csrf: csrfToken },
                success: function(data) {
                    if (data && data.length > 0) {
                        renderConversations(data);
                    } else {
                        showEmptyState('#conversationList', {
                            icon: 'forum',
                            title: 'No conversations yet',
                            message: 'Start a new chat with Dino AI',
                            actionText: 'New Chat',
                            actionUrl: '<?php echo url('/account/dino'); ?>'
                        });
                    }
                },
                error: function(xhr, status, error) {
                    console.error("Error fetching conversations:", error);
                    showError('#conversationList', 'Failed to load conversations');
                }
            });
        }

        function renderConversations(conversations) {
            const currentDate = new Date();
            currentDate.setHours(0, 0, 0, 0);

            // Categorize conversations by date
            const categorized = {
                today: [],
                yesterday: [],
                thisWeek: [],
                thisMonth: [],
                older: []
            };

            conversations.forEach(convo => {
                const convoDate = new Date(convo.last_message_date);
                convoDate.setHours(0, 0, 0, 0);

                const diffDays = Math.floor((currentDate - convoDate) / (1000 * 60 * 60 * 24));

                if (diffDays === 0) categorized.today.push(convo);
                else if (diffDays === 1) categorized.yesterday.push(convo);
                else if (diffDays <= 7) categorized.thisWeek.push(convo);
                else if (diffDays <= 30) categorized.thisMonth.push(convo);
                else categorized.older.push(convo);
            });

            // Clear existing content
            const container = $('#conversationList').empty();

            // Render each category
            if (categorized.today.length > 0) {
                renderConversationCategory(container, 'Today', categorized.today);
            }
            if (categorized.yesterday.length > 0) {
                renderConversationCategory(container, 'Yesterday', categorized.yesterday);
            }
            if (categorized.thisWeek.length > 0) {
                renderConversationCategory(container, 'This Week', categorized.thisWeek);
            }
            if (categorized.thisMonth.length > 0) {
                renderConversationCategory(container, 'This Month', categorized.thisMonth);
            }
            if (categorized.older.length > 0) {
                renderConversationCategory(container, 'Older', categorized.older);
            }
        }

        function renderConversationCategory(container, title, conversations) {
            // Add category header
            container.append(`
            <div class="conversation-category">
                <div class="category-header flex items-center py-2 px-3 text-xs font-medium text-gray-500 dark:text-gray-400 uppercase tracking-wider">
                    <span class="mr-2">${title}</span>
                    <span class="flex-1 border-t border-gray-200 dark:border-dark-600"></span>
                </div>
                <div class="category-conversations">
                    ${conversations.map(convo => conversationItem(convo)).join('')}
                </div>
            </div>
        `);
        }

        function conversationItem(conversation) {
            const lastMessageTime = formatConversationTime(conversation.last_message_date);

            return `
            <a href="<?php echo url('/account/dino/c/${conversation.id}')?>"
               class="conversation-item flex items-center p-3 hover:bg-gray-50 dark:hover:bg-dark-700 rounded-lg transition-colors">
                <div class="flex-shrink-0 mr-3">
                    <div class="w-10 h-10 rounded-full bg-purple-100 dark:bg-purple-900/20 flex items-center justify-center text-purple-600 dark:text-purple-300">
                        <span class="material-symbols-outlined">forum</span>
                    </div>
                </div>
                <div class="flex-1 min-w-0">
                    <div class="flex justify-between items-center">
                        <p class="text-sm font-medium text-gray-900 dark:text-white truncate">${conversation.name}</p>
                        <span class="text-xs text-gray-500 dark:text-gray-400">${lastMessageTime}</span>
                    </div>
                    <p class="text-sm text-gray-500 dark:text-gray-400 truncate">${conversation.last_message || 'No messages yet'}</p>
                </div>
            </a>
        `;
        }

        function formatConversationTime(dateString) {
            const date = new Date(dateString);
            const now = new Date();
            const diffHours = Math.floor((now - date) / (1000 * 60 * 60));

            if (diffHours < 24) {
                return date.toLocaleTimeString([], { hour: '2-digit', minute: '2-digit' });
            } else if (diffHours < 168) { // 7 days
                return date.toLocaleDateString([], { weekday: 'short' });
            } else {
                return date.toLocaleDateString([], { month: 'short', day: 'numeric' });
            }
        }

        // ==================== CLOUD PRODUCTS ==================== //
        function loadProducts() {
            showLoading('#productsList');

            $.ajax({
                type: 'POST',
                url: '/get_user_products',
                dataType: 'json',
                data: {
                    csrf: csrfToken,
                    categories: 'web-hosting,business-hosting,cloud',
                    include: 'category,is_featured'
                },
                success: function(response) {
                    if (response && response.length > 0) {
                        renderProducts(response);
                    } else {
                        showEmptyState('#productsList', {
                            icon: 'cloud_off',
                            title: 'No cloud products',
                            message: 'Add your first cloud service to get started',
                            actionText: 'Add Product',
                            actionUrl: '<?php echo url('/cloud'); ?>'
                        });
                    }
                },
                error: function(xhr, status, error) {
                    console.error('Error loading products:', error);
                    showError('#productsList', 'Failed to load cloud products');
                }
            });
        }

        function renderProducts(products) {
            const container = $('#productsList').empty();

            // Sort products by status (Active first)
            const sortedProducts = [...products].sort((a, b) => {
                const statusOrder = { 'Active': 1, 'Pending': 2, 'Overdue': 3 };
                return (statusOrder[a.status] || 4) - (statusOrder[b.status] || 4);
            });

            // Group by category
            const byCategory = sortedProducts.reduce((acc, product) => {
                const category = product.category || 'other';
                if (!acc[category]) acc[category] = [];
                acc[category].push(product);
                return acc;
            }, {});

            // Render each category
            Object.entries(byCategory).forEach(([category, products]) => {
                const categoryName = category.split('-').map(word =>
                    word.charAt(0).toUpperCase() + word.slice(1)
                ).join(' ');

                container.append(`
                <div class="product-category mb-6">
                    <h3 class="category-title flex items-center text-sm font-semibold text-gray-500 dark:text-gray-400 mb-3">
                        <span class="material-symbols-outlined mr-2">${getProductIcon(category)}</span>
                        ${categoryName} (${products.length})
                    </h3>
                    <div class="product-list grid gap-3">
                        ${products.map(product => renderProductItem(product)).join('')}
                    </div>
                </div>
            `);
            });
        }

        function renderProductItem(product) {
            const status = getProductStatus(product);
            const renewalInfo = getRenewalInfo(product);

            return `
            <div class="product-item flex flex-col md:flex-row justify-between items-start md:items-center gap-4 p-4 bg-gray-50 dark:bg-dark-700 rounded-lg border border-gray-200 dark:border-dark-600 hover:shadow-xs transition-colors">
                <div class="flex items-start gap-3 w-full md:w-auto">
                    <div class="flex-shrink-0 p-2 bg-indigo-50 dark:bg-indigo-900/20 rounded-lg">
                        <span class="material-symbols-outlined text-indigo-600 dark:text-indigo-300">${getProductIcon(product.category)}</span>
                    </div>
                    <div class="flex-1 min-w-0">
                        <div class="flex items-center gap-2 mb-1">
                            <span class="status-badge text-xs font-medium px-2 py-1 rounded-full ${status.color} text-white">
                                ${status.text}
                            </span>
                            ${product.isFeatured ? '<span class="featured-badge text-xs font-medium px-2 py-1 rounded-full bg-yellow-100 dark:bg-yellow-900/30 text-yellow-800 dark:text-yellow-200">Featured</span>' : ''}
                        </div>
                        <h4 class="text-base font-semibold text-gray-900 dark:text-white truncate">${product.name}</h4>
                        <p class="text-sm text-gray-500 dark:text-gray-400 truncate">${product.order_name}</p>
                    </div>
                </div>
                <div class="flex flex-col items-start md:items-center gap-1 w-full md:w-auto">
                    <div class="flex items-center gap-1 text-sm ${renewalInfo.dateClass}">
                        <span class="material-symbols-outlined text-gray-400 dark:text-gray-500 text-base">event</span>
                        <span class="text-gray-600 dark:text-gray-300">${renewalInfo.date}</span>
                    </div>
                    <span class="text-sm font-medium ${renewalInfo.textColor}">
                        ${renewalInfo.text}
                    </span>
                </div>
                <div class="flex-shrink-0 w-full md:w-auto">
                    <a href="<?php echo url('/account/cloud/${product.order_number}')?>" class="flex items-center justify-center gap-1 w-full md:w-auto px-4 py-2 bg-indigo-600 hover:bg-indigo-700 text-white text-sm font-medium rounded-lg transition-colors">
                        <span>Manage</span>
                        <span class="material-symbols-outlined text-base">chevron_right</span>
                    </a>
                </div>
            </div>
        `;
        }

        function getProductStatus(product) {
            const statusMap = {
                'Active': { color: 'bg-green-500 dark:bg-green-600', text: 'Active' },
                'Pending': { color: 'bg-yellow-500 dark:bg-yellow-600', text: 'Pending' },
                'Overdue': { color: 'bg-red-500 dark:bg-red-600', text: 'Overdue' }
            };
            return statusMap[product.status] || { color: 'bg-gray-500', text: product.status || 'Unknown' };
        }

        function getRenewalInfo(product) {
            if (!product.renewal_date) {
                return {
                    date: 'N/A',
                    dateClass: 'hidden',
                    text: 'Waiting for payment',
                    textColor: 'text-gray-500'
                };
            }

            const renewalDate = new Date(product.renewal_date);
            const daysLeft = product.days_left || 0;

            let text, textColor;
            if (daysLeft > 30) {
                const monthsLeft = Math.ceil(daysLeft / 30);
                text = monthsLeft < 12 ?
                    `Renew in ${monthsLeft} months` :
                    `Renew in ${Math.floor(monthsLeft / 12)} years`;
                textColor = 'text-gray-600 dark:text-gray-300';
            } else if (daysLeft > 7) {
                text = `Renew in ${daysLeft} days`;
                textColor = 'text-green-600 dark:text-green-400';
            } else if (daysLeft > 3) {
                text = `Renew in ${daysLeft} days`;
                textColor = 'text-yellow-600 dark:text-yellow-400';
            } else if (daysLeft >= 0) {
                text = daysLeft === 0 ? 'Renew today' : `Renew in ${daysLeft} days`;
                textColor = 'text-red-600 dark:text-red-400';
            } else {
                text = `Overdue ${Math.abs(daysLeft)} days`;
                textColor = 'text-red-600 dark:text-red-400';
            }

            return {
                date: renewalDate.toLocaleDateString(undefined, { month: 'short', day: 'numeric' }),
                dateClass: '',
                text: text,
                textColor: textColor
            };
        }

        function getProductIcon(category) {
            const icons = {
                'web-hosting': 'language',
                'business-hosting': 'business_center',
                'cloud': 'cloud',
                'vps': 'dns',
                'dedicated': 'storage'
            };
            return icons[category] || 'widgets';
        }

        // ==================== ANALYTICS ==================== //
        function fetchAnalyticsData() {
            showLoading('#website-info');

            $.ajax({
                url: '/analytics_get_summary',
                type: 'POST',
                dataType: 'json',
                data: {
                    csrf: csrfToken,
                    timeframe: '30d',
                    metrics: 'visits,unique_visitors,bounce_rate,avg_duration'
                },
                success: function(response) {
                    if (response.success) {
                        renderAnalytics(response);
                    } else if (response.message === 'no_domain') {
                        showEmptyState('#website-info', {
                            icon: 'public',
                            title: 'No website connected',
                            message: 'Connect your website to start tracking analytics',
                            actionText: 'Connect Website',
                            actionUrl: '<?php echo url('/account/analytics'); ?>'
                        });
                    } else {
                        showError('#website-info', response.message || 'Failed to load analytics');
                    }
                },
                error: function(xhr, status, error) {
                    console.error('Error fetching analytics:', error);
                    showError('#website-info', 'Failed to load analytics data');
                }
            });
        }

        function renderAnalytics(data) {
            const container = $('#website-info').empty();

            if (data.websiteInfo) {
                $('#website_info').removeClass('hidden');
                $('#website_url').text(data.websiteInfo.website_url || 'Your Website');
            }

            if (!data.analyticsData || data.analyticsData.length === 0) {
                showEmptyState('#website-info', {
                    icon: 'analytics',
                    title: 'No analytics data',
                    message: 'We need more data to show your analytics',
                    actionText: 'View Analytics',
                    actionUrl: '<?php echo url('/account/analytics'); ?>'
                });
                return;
            }

            // Calculate metrics
            const totalVisits = calculateTotal(data.analyticsData, 'visits');
            const visitsChange = calculateChange(data.analyticsData, 'visits');
            const totalUnique = calculateTotal(data.analyticsData, 'unique_visitors');
            const uniqueChange = calculateChange(data.analyticsData, 'unique_visitors');

            container.html(`
            <div class="analytics-grid grid grid-cols-1 sm:grid-cols-2 gap-4">
                ${analyticsCard('Total Visits', totalVisits, visitsChange, 'group')}
                ${analyticsCard('Unique Visitors', totalUnique, uniqueChange, 'person')}
            </div>
            <div class="mt-4 border-t border-gray-200 dark:border-dark-700 pt-4">
                <a href="<?php echo url('/account/analytics'); ?>" class="flex items-center justify-center text-sm font-medium text-blue-600 dark:text-blue-400 hover:underline">
                    View full analytics
                    <span class="material-symbols-outlined ml-1">chevron_right</span>
                </a>
            </div>
        `);
        }

        function analyticsCard(title, value, change, icon) {
            const isPositive = !change.startsWith('-');
            const arrowIcon = isPositive ? 'trending_up' : 'trending_down';
            const colorClass = isPositive ? 'text-green-600 dark:text-green-400' : 'text-red-600 dark:text-red-400';

            return `
            <div class="analytics-card p-4 bg-gray-50 dark:bg-dark-700 rounded-lg border border-gray-200 dark:border-dark-600 hover:shadow-xs transition-colors">
                <div class="flex items-center justify-between mb-3">
                    <h3 class="text-sm font-medium text-gray-500">${title}</h3>
                    <span class="flex items-center justify-center w-8 h-8 rounded-lg bg-blue-50 dark:bg-blue-900/20 text-blue-600 dark:text-blue-300">
                        <span class="material-symbols-outlined">${icon}</span>
                    </span>
                </div>
                <div class="flex items-end justify-between">
                    <div>
                        <p class="text-2xl font-light text-gray-900 dark:text-white mb-1">${value}</p>
                        <div class="flex items-center ${colorClass}">
                            <span class="material-symbols-outlined text-base">${arrowIcon}</span>
                            <span class="text-sm font-medium ml-1">${change}</span>
                        </div>
                    </div>
                </div>
            </div>
        `;
        }

        function calculateTotal(data, metric) {
            if (!data || !Array.isArray(data)) return 0;
            return data.reduce((sum, item) => sum + (item[metric] || 0), 0);
        }

        function calculateChange(data, metric) {
            if (!data || data.length < 2) return '0%';

            const current = data[data.length - 1][metric] || 0;
            const previous = data[data.length - 2][metric] || 0;

            if (previous === 0) return '∞';

            const change = ((current - previous) / previous * 100).toFixed(1);
            return `${change > 0 ? '+' : ''}${change}%`;
        }

        // ==================== UTILITY FUNCTIONS ==================== //
        function showLoading(selector) {
            $(selector).html(`
            <div class="flex justify-center items-center py-12">
                <svg aria-hidden="true" class="inline w-10 h-10 text-gray-200 animate-spin dark:text-gray-600 fill-blue-500" viewBox="0 0 100 101" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path d="M100 50.5908C100 78.2051 77.6142 100.591 50 100.591C22.3858 100.591 0 78.2051 0 50.5908C0 22.9766 22.3858 0.59082 50 0.59082C77.6142 0.59082 100 22.9766 100 50.5908ZM9.08144 50.5908C9.08144 73.1895 27.4013 91.5094 50 91.5094C72.5987 91.5094 90.9186 73.1895 90.9186 50.5908C90.9186 27.9921 72.5987 9.67226 50 9.67226C27.4013 9.67226 9.08144 27.9921 9.08144 50.5908Z" fill="currentColor"/>
                    <path d="M93.9676 39.0409C96.393 38.4038 97.8624 35.9116 97.0079 33.5539C95.2932 28.8227 92.871 24.3692 89.8167 20.348C85.8452 15.1192 80.8826 10.7238 75.2124 7.41289C69.5422 4.10194 63.2754 1.94025 56.7698 1.05124C51.7666 0.367541 46.6976 0.446843 41.7345 1.27873C39.2613 1.69328 37.813 4.19778 38.4501 6.62326C39.0873 9.04874 41.5694 10.4717 44.0505 10.1071C47.8511 9.54855 51.7191 9.52689 55.5402 10.0491C60.8642 10.7766 65.9928 12.5457 70.6331 15.2552C75.2735 17.9648 79.3347 21.5619 82.5849 25.841C84.9175 28.9121 86.7997 32.2913 88.1811 35.8758C89.083 38.2158 91.5421 39.6781 93.9676 39.0409Z" fill="currentFill"/>
                </svg>
            </div>
        `);
        }

        function showEmptyState(selector, options) {
            $(selector).html(`
            <div class="empty-state text-center py-8">
                <span class="material-symbols-outlined mx-auto text-gray-400 dark:text-gray-500 text-4xl mb-3">${options.icon}</span>
                <h3 class="text-lg font-medium text-gray-700 dark:text-gray-300 mb-1">${options.title}</h3>
                <p class="text-sm text-gray-500 dark:text-gray-400 mb-4">${options.message}</p>
                <a href="${options.actionUrl}" class="inline-flex items-center px-4 py-2 bg-blue-600 hover:bg-blue-700 text-white text-sm font-medium rounded-lg transition-colors">
                    ${options.actionText}
                    <span class="material-symbols-outlined ml-1">arrow_forward</span>
                </a>
            </div>
        `);
        }

        function showError(selector, message) {
            $(selector).html(`
            <div class="error-state p-6 bg-red-50 dark:bg-red-900/10 rounded-lg text-center border border-red-200 dark:border-red-800">
                <span class="material-symbols-outlined flex mx-auto text-red-600 dark:text-red-400 text-4xl mb-3">error</span>
                <h3 class="text-lg font-medium text-gray-900 dark:text-white mb-1">Something went wrong</h3>
                <p class="text-sm text-gray-600 dark:text-gray-300 mb-4">${message}</p>
                <button onclick="location.reload()" class="retry-button px-4 py-2 bg-red-600 hover:bg-red-700 text-white text-sm font-medium rounded-lg transition-colors">
                    Try Again
                </button>
            </div>
        `);
        }

        function showToast(message, type = 'success') {
            const toastId = 'toast-' + Date.now();
            const icon = type === 'success' ? 'check_circle' : 'error';
            const bgClass = type === 'success' ? 'bg-green-50 dark:bg-green-900/20 text-green-800 dark:text-green-200' : 'bg-red-50 dark:bg-red-900/20 text-red-800 dark:text-red-200';

            $('body').append(`
            <div id="${toastId}" class="fixed bottom-4 right-4 z-50 animate-fade-in-up">
                <div class="flex items-center p-4 rounded-lg shadow-lg ${bgClass}">
                    <span class="material-symbols-outlined mr-2">${icon}</span>
                    <span>${message}</span>
                </div>
            </div>
        `);

            // Auto-remove after 5 seconds
            setTimeout(() => {
                $(`#${toastId}`).addClass('animate-fade-out');
                setTimeout(() => $(`#${toastId}`).remove(), 300);
            }, 5000);
        }
    });
</script>