<?php
$meta = array(
    'us' => array(
        'title' => 'Datanito Cloud Management - Control Your Hosting Services',
        'description' => 'Effortlessly oversee web hosting and business hosting with Datanito Cloud. Discover control and flexibility for your online presence.',
        'og:title' => 'Datanito Cloud Management - Control Web Hosting and Business Hosting',
        'og:description' => 'Effortlessly oversee web hosting and business hosting with Datanito Cloud. Discover control and flexibility for your online presence.',
        'og:image' => asset('images/brand/open_graph_logo.png'),
    ),
    'tr' => array(
        'title' => 'Datanito Cloud Yönetimi - Datanito (Türkiye)',
        'description' => 'Datanito Cloud ile web hosting ve işletme hosting hizmetlerinizi kolayca yönetin. Çevrimiçi varlığınız için kontrol ve esnekliği keşfedin.',
        'og:title' => 'Datanito Cloud Yönetimi - Web Hosting ve İşletme Hosting Kontrolü',
        'og:description' => 'Datanito Cloud ile web hosting ve işletme hosting hizmetlerinizi kolayca yönetin. Çevrimiçi varlığınız için kontrol ve esnekliği keşfedin.',
        'og:image' => asset('images/brand/open_graph_logo.png'),
    ),
);
$currentMeta = setCountryAndMeta($meta);
include_once includes('layouts/dashboard.php');
?>
<main class="p-4 md:pl-64 md:ml-8 md:mr-4 h-full pt-20 min-h-[70em] !overflow-hidden">
    <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 gap-4 mb-4">
        <div class="rounded-3xl border border-gray-200 bg-gray-50 dark:bg-dark-700 dark:border-gray-600 p-4 md:p-6 space-y-4 skeleton flex items-center justify-center">
            <div class="text-center">
                <div role="status" class="spinner hidden my-6 p-4 bg-gray-50 dark:bg-dark-700 rounded-3xl">
                    <svg aria-hidden="true" class="inline w-20 h-20 text-gray-200 animate-spin dark:text-gray-600 fill-blue-500" viewBox="0 0 100 101" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M100 50.5908C100 78.2051 77.6142 100.591 50 100.591C22.3858 100.591 0 78.2051 0 50.5908C0 22.9766 22.3858 0.59082 50 0.59082C77.6142 0.59082 100 22.9766 100 50.5908ZM9.08144 50.5908C9.08144 73.1895 27.4013 91.5094 50 91.5094C72.5987 91.5094 90.9186 73.1895 90.9186 50.5908C90.9186 27.9921 72.5987 9.67226 50 9.67226C27.4013 9.67226 9.08144 27.9921 9.08144 50.5908Z" fill="currentColor"/>
                        <path d="M93.9676 39.0409C96.393 38.4038 97.8624 35.9116 97.0079 33.5539C95.2932 28.8227 92.871 24.3692 89.8167 20.348C85.8452 15.1192 80.8826 10.7238 75.2124 7.41289C69.5422 4.10194 63.2754 1.94025 56.7698 1.05124C51.7666 0.367541 46.6976 0.446843 41.7345 1.27873C39.2613 1.69328 37.813 4.19778 38.4501 6.62326C39.0873 9.04874 41.5694 10.4717 44.0505 10.1071C47.8511 9.54855 51.7191 9.52689 55.5402 10.0491C60.8642 10.7766 65.9928 12.5457 70.6331 15.2552C75.2735 17.9648 79.3347 21.5619 82.5849 25.841C84.9175 28.9121 86.7997 32.2913 88.1811 35.8758C89.083 38.2158 91.5421 39.6781 93.9676 39.0409Z" fill="currentFill"/>
                    </svg>
                    <span class="sr-only">Loading...</span>
                </div>
                <div class="productContent hidden">
                    <div class="relative">
                        <div class="relative overflow-hidden text-center">
                            <div>
                                <span class="material-symbols-outlined text-6xl">filter_drama</span>
                            </div>
                        </div>
                    </div>
                    <div class="flex items-center justify-center text-center mb-2">
                        <span class="text-sm text-gray-500 dark:text-gray-400 productStatus"></span>
                    </div>
                    <h1 class="mb-1 text-lg font-bold text-gray-900 dark:text-white text-center productName"></h1>
                    <p class="mb-1 text-sm font-medium text-gray-900 dark:text-white text-center productDescription"></p>
                </div>
            </div>

        </div>

        <div class="relative rounded-3xl border border-gray-200 bg-gray-50 dark:bg-dark-700 dark:border-gray-600 p-4 md:p-6 h-80 skeleton">
            <div class="absolute left-[50%] top-[50%] translate-y-[-50%] translate-x-[-50%] flex justify-center items-center z-10 h-full w-full text-center backdrop-blur rounded-3xl">
                <div role="status" class="spinner hidden my-6 p-4 bg-gray-50 dark:bg-dark-700 rounded-3xl">
                    <svg aria-hidden="true" class="inline w-20 h-20 text-gray-200 animate-spin dark:text-gray-600 fill-blue-500" viewBox="0 0 100 101" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M100 50.5908C100 78.2051 77.6142 100.591 50 100.591C22.3858 100.591 0 78.2051 0 50.5908C0 22.9766 22.3858 0.59082 50 0.59082C77.6142 0.59082 100 22.9766 100 50.5908ZM9.08144 50.5908C9.08144 73.1895 27.4013 91.5094 50 91.5094C72.5987 91.5094 90.9186 73.1895 90.9186 50.5908C90.9186 27.9921 72.5987 9.67226 50 9.67226C27.4013 9.67226 9.08144 27.9921 9.08144 50.5908Z" fill="currentColor"/>
                        <path d="M93.9676 39.0409C96.393 38.4038 97.8624 35.9116 97.0079 33.5539C95.2932 28.8227 92.871 24.3692 89.8167 20.348C85.8452 15.1192 80.8826 10.7238 75.2124 7.41289C69.5422 4.10194 63.2754 1.94025 56.7698 1.05124C51.7666 0.367541 46.6976 0.446843 41.7345 1.27873C39.2613 1.69328 37.813 4.19778 38.4501 6.62326C39.0873 9.04874 41.5694 10.4717 44.0505 10.1071C47.8511 9.54855 51.7191 9.52689 55.5402 10.0491C60.8642 10.7766 65.9928 12.5457 70.6331 15.2552C75.2735 17.9648 79.3347 21.5619 82.5849 25.841C84.9175 28.9121 86.7997 32.2913 88.1811 35.8758C89.083 38.2158 91.5421 39.6781 93.9676 39.0409Z" fill="currentFill"/>
                    </svg>
                    <span class="sr-only">Loading...</span>
                </div>
                <div class="productContent hidden space-y-2">
                    <span class="flex items-center space-x-2"><span class="material-symbols-outlined p-1 rounded-xl bg-gray-200 dark:bg-dark-500">cloud_upload</span> <span class="mb-1 text-lg font-normal text-gray-700 dark:text-white text-center productStorage"></span></span>
                    <span class="flex items-center space-x-2"><span class="material-symbols-outlined p-1 rounded-xl bg-gray-200 dark:bg-dark-500">language</span> <span class="mb-1 text-lg font-normal text-gray-700 dark:text-white text-center productWebsites"></span></span>
                    <span class="flex items-center space-x-2"><span class="material-symbols-outlined p-1 rounded-xl bg-gray-200 dark:bg-dark-500">sync_alt</span> <span class="mb-1 text-lg font-normal text-gray-700 dark:text-white text-center productBandwidth"></span></span>
                </div>
            </div>
        </div>

        <div class="relative rounded-3xl border border-gray-200 bg-gray-50 dark:bg-dark-700 dark:border-gray-600 p-4 md:p-6 h-80 skeleton">
            <div class="absolute left-[50%] top-[50%] translate-y-[-50%] translate-x-[-50%] flex justify-center items-center z-10 h-full w-full text-center backdrop-blur rounded-3xl">
                <div role="status" class="spinner hidden my-6 p-4 bg-gray-50 dark:bg-dark-700 rounded-3xl">
                    <svg aria-hidden="true" class="inline w-20 h-20 text-gray-200 animate-spin dark:text-gray-600 fill-blue-500" viewBox="0 0 100 101" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M100 50.5908C100 78.2051 77.6142 100.591 50 100.591C22.3858 100.591 0 78.2051 0 50.5908C0 22.9766 22.3858 0.59082 50 0.59082C77.6142 0.59082 100 22.9766 100 50.5908ZM9.08144 50.5908C9.08144 73.1895 27.4013 91.5094 50 91.5094C72.5987 91.5094 90.9186 73.1895 90.9186 50.5908C90.9186 27.9921 72.5987 9.67226 50 9.67226C27.4013 9.67226 9.08144 27.9921 9.08144 50.5908Z" fill="currentColor"/>
                        <path d="M93.9676 39.0409C96.393 38.4038 97.8624 35.9116 97.0079 33.5539C95.2932 28.8227 92.871 24.3692 89.8167 20.348C85.8452 15.1192 80.8826 10.7238 75.2124 7.41289C69.5422 4.10194 63.2754 1.94025 56.7698 1.05124C51.7666 0.367541 46.6976 0.446843 41.7345 1.27873C39.2613 1.69328 37.813 4.19778 38.4501 6.62326C39.0873 9.04874 41.5694 10.4717 44.0505 10.1071C47.8511 9.54855 51.7191 9.52689 55.5402 10.0491C60.8642 10.7766 65.9928 12.5457 70.6331 15.2552C75.2735 17.9648 79.3347 21.5619 82.5849 25.841C84.9175 28.9121 86.7997 32.2913 88.1811 35.8758C89.083 38.2158 91.5421 39.6781 93.9676 39.0409Z" fill="currentFill"/>
                    </svg>
                    <span class="sr-only">Loading...</span>
                </div>
                <div class="productContent hidden space-y-4 text-center mx-auto">
                    <div class="block space-y-2">
                        <span class="renewDate"></span>
                        <span class="renewDay"></span>
                    </div>
                </div>
            </div>
        </div>

    </div>
    <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-2 gap-4 mb-4">
        <div class="rounded-3xl border border-gray-200 bg-gray-50 dark:bg-dark-700 dark:border-gray-600 p-4 md:p-6 space-y-4 skeleton">
            <div class="text-center overflow-y-auto overflow-x-hidden h-96 flex items-center justify-center">
                <p class="domainName"></p>
            </div>
        </div>
        <div class="relative rounded-3xl border border-gray-200 bg-gray-50 dark:bg-dark-700 dark:border-gray-600 p-4 md:p-6 h-80 sm:h-full skeleton">
            <div class="absolute left-[50%] top-[50%] translate-y-[-50%] translate-x-[-50%] flex justify-center items-center z-10 h-full w-full text-center backdrop-blur rounded-3xl">
                <div role="status" class="spinner hidden my-6 p-4 bg-gray-50 dark:bg-dark-700 rounded-3xl">
                    <svg aria-hidden="true" class="inline w-20 h-20 text-gray-200 animate-spin dark:text-gray-600 fill-blue-500" viewBox="0 0 100 101" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M100 50.5908C100 78.2051 77.6142 100.591 50 100.591C22.3858 100.591 0 78.2051 0 50.5908C0 22.9766 22.3858 0.59082 50 0.59082C77.6142 0.59082 100 22.9766 100 50.5908ZM9.08144 50.5908C9.08144 73.1895 27.4013 91.5094 50 91.5094C72.5987 91.5094 90.9186 73.1895 90.9186 50.5908C90.9186 27.9921 72.5987 9.67226 50 9.67226C27.4013 9.67226 9.08144 27.9921 9.08144 50.5908Z" fill="currentColor"/>
                        <path d="M93.9676 39.0409C96.393 38.4038 97.8624 35.9116 97.0079 33.5539C95.2932 28.8227 92.871 24.3692 89.8167 20.348C85.8452 15.1192 80.8826 10.7238 75.2124 7.41289C69.5422 4.10194 63.2754 1.94025 56.7698 1.05124C51.7666 0.367541 46.6976 0.446843 41.7345 1.27873C39.2613 1.69328 37.813 4.19778 38.4501 6.62326C39.0873 9.04874 41.5694 10.4717 44.0505 10.1071C47.8511 9.54855 51.7191 9.52689 55.5402 10.0491C60.8642 10.7766 65.9928 12.5457 70.6331 15.2552C75.2735 17.9648 79.3347 21.5619 82.5849 25.841C84.9175 28.9121 86.7997 32.2913 88.1811 35.8758C89.083 38.2158 91.5421 39.6781 93.9676 39.0409Z" fill="currentFill"/>
                    </svg>
                    <span class="sr-only">Loading...</span>
                </div>
                <div class="productContent hidden grid grid-cols-3 space-x-4 items-center justify-between m-2">
                    <a href="<?php echo url('/account/billing/invoices')?>" class="block text-center p-3 md:p-4 bg-gray-200 dark:bg-dark-600 hover:bg-gray-100 dark:hover:bg-dark-500 rounded-3xl">
                        <span class="material-symbols-outlined text-4xl block text-gray-600 dark:text-gray-300">receipt</span>
                        <span class="text-lg text-gray-600 dark:text-gray-300">Invoices</span>
                    </a>
                    <a href="<?php echo url('/account/support/requests')?>" class="block text-center p-3 md:p-4 bg-gray-200 dark:bg-dark-600 hover:bg-gray-100 dark:hover:bg-dark-500 rounded-3xl">
                        <span class="material-symbols-outlined text-4xl block text-gray-600 dark:text-gray-300">support</span>
                        <span class="text-lg text-gray-600 dark:text-gray-300">Support</span>
                    </a>
                    <a id="loginBtn" class="block text-center p-3 md:p-4 bg-gray-200 dark:bg-dark-600 hover:bg-gray-100 dark:hover:bg-dark-500 rounded-3xl cursor-pointer">
                        <span class="material-symbols-outlined text-4xl block text-gray-600 dark:text-gray-300">folder</span>
                        <span class="text-lg text-gray-600 dark:text-gray-300">cPanel</span>
                    </a>
                </div>
                <div id="result" class="hidden"></div>
            </div>
        </div>
    </div>
</main>
<?php
include_once includes('layouts/dashboard-end.php');
?>

<script>
    $(document).ready(function() {
        var orderNumber = '<?php echo $id;?>'; // Assuming $id contains the order number

        $("#loginBtn").click(function() {
            // Perform AJAX call to PHP script
            $.ajax({
                url: "/host/login", // Replace with the path to your PHP script
                type: "POST",
                dataType: "html", // Assuming your PHP script returns HTML
                data: { orderNumber: orderNumber }, // Pass order number as data
                success: function(response) {
                    // Display response
                    $("#result").html(response);
                },
                error: function(xhr, status, error) {
                    // Handle errors
                    console.error("Error:", error);
                    $("#result").html("An error occurred while processing your request.");
                }
            });
        });
    });
    $(document).ready(function() {
        $('.spinner').addClass('inline-flex');
        $('.spinner').removeClass('hidden');

        function loadProducts() {
            // Modify the code to check for categories or product_id
            var order_numbers = '<?php echo $id?>'; // Add product_id variable
            console.log('Order Numbers:', order_numbers);

            $.ajax({
                type: 'POST',
                url: '/fetch_product',
                dataType: 'json',
                data: {
                    order_numbers: order_numbers
                },
                success: function(response) {
                    $('.spinner').hide();
                    $('.productContent').removeClass('hidden');
                    console.log(JSON.stringify(response) + 'cloud');
                    $('.productName').text(response[0].name);
                    $('.domainName').text(response[0].order_name);
                    $('.productDescription').text(response[0].description);
                    if (response.length > 0 && response[0].features) {
                        var featuresArray = JSON.parse(response[0].features);
                        displayFeatures(featuresArray);
                    } else {
                        console.log('Features not found in the response.');
                    }
                    function displayFeatures(featuresArray) {
                        // Assuming the features you want to display are at specific indices
                        var storageFeature = featuresArray[2]; // "100 GB NVMe Storage"
                        var websitesFeature = featuresArray[1]; // "Unlimited Websites"
                        var bandwidthFeature = featuresArray[3]; // "Unlimited Websites"

                        // Update the following lines to display the features as needed
                        $('.productStorage').text(storageFeature);
                        $('.productWebsites').text(websitesFeature);
                        $('.productBandwidth').text(bandwidthFeature);
                    }
                    function formatCreatedAt(created_at) {
                        const date = new Date(created_at);
                        const options = { year: 'numeric', month: 'long', day: 'numeric' };

                        <?php
                        $websiteLanguage = $_SESSION["country"];
                        if ($websiteLanguage === 'tr') {
                            echo "const formattedDate = date.toLocaleDateString('tr-TR', options);";
                        } else {
                            echo "const formattedDate = date.toLocaleDateString(undefined, options);";
                        }
                        ?>

                        return formattedDate;
                    }

                    const formattedCreatedAt = formatCreatedAt(response[0].renewal_date);

                    // Format the currency amount based on your requirement
                    let statusColorClass = '';
                    let statusTitle = '';

                    if (response[0].status === 'Active') {
                        statusColorClass = 'bg-green-500 dark:bg-green-600';
                        statusTitle = '<?php echo $lang['product-status-active']?>';
                    } else if (response[0].status === 'Overdue') {
                        statusColorClass = 'bg-red-500 dark:bg-red-600';
                        statusTitle = '<?php echo $lang['product-status-overdue']?>';
                    } else if (response[0].status === 'Pending') {
                        statusColorClass = 'bg-yellow-500 dark:bg-yellow-600';
                        statusTitle = '<?php echo $lang['product-status-pending']?>';
                    }

                    // Determine the text color for "Renew in X days"
                    let renewDaysText = '<?php echo $lang['waiting-for-payment']?>';
                    let renewDateDisplay = ''; // Declare renewDateDisplay outside the if block
                    let renewDaysColorClass = '';

                    if (response[0].renewal_date === null) {
                        renewDateDisplay = 'hidden'; // Modify the variable declared outside the block
                    }
                    if (response[0].renewal_date !== null) {
                        if (response[0].days_left > 30) {
                            const monthsLeft = Math.ceil(response[0].days_left / 30);

                            if (monthsLeft < 12) {
                                renewDaysText = '<?php echo $lang['renew-in-d-months']; ?>'.replace('%d', monthsLeft);
                            } else {
                                const yearsLeft = Math.floor(monthsLeft / 12);
                                const remainingMonths = monthsLeft % 12;
                                renewDaysText = '<?php echo $lang['renew-in-d-years']; ?>'.replace('%d', yearsLeft);
                            }

                            renewDaysColorClass = 'text-gray-600 dark:text-gray-500'; // Blue for more than 30 days left
                        } else if (response[0].days_left <= 30 && response[0].days_left > 7) {
                            renewDaysText = '<?php echo $lang['renew-in-d-days']; ?>'.replace('%d', response[0].days_left);
                            renewDaysColorClass = 'text-green-600 dark:text-green-500'; // Green for 8 to 30 days left
                        } else if (response[0].days_left <= 7 && response[0].days_left > 3) {
                            renewDaysText = '<?php echo $lang['renew-in-d-days']; ?>'.replace('%d', response[0].days_left);
                            renewDaysColorClass = 'text-yellow-600 dark:text-yellow-500'; // Yellow for 4 to 7 days left
                        } else if (response[0].days_left <= 3 && response[0].days_left > 1) {
                            renewDaysText = '<?php echo $lang['renew-in-d-days']; ?>'.replace('%d', response[0].days_left);
                            renewDaysColorClass = 'text-red-600 dark:text-red-500'; // Red for 3 or fewer days left
                        } else if (response[0].days_left <= 1 && response[0].days_left >= 0) {
                            renewDaysText = '<?php echo $lang['renew-in-d-days']; ?>'.replace('%d', response[0].days_left);
                            renewDaysColorClass = 'text-red-600 dark:text-red-500'; // Red for 3 or fewer days left
                        } else if (response[0].days_left < 0) {
                            const overdueDays = Math.abs(response[0].days_left);
                            renewDaysText = '<?php echo $lang['overdue-d-days-ago']; ?>'.replace('%d', overdueDays);
                            renewDaysColorClass = 'text-red-600 dark:text-red-500'; // Red for overdue
                        }
                    }
                    $('.productStatus').html(`<span class="inline items-center text-xs ${statusColorClass} text-white rounded-xl py-1 px-3 sm:py-0.5 sm:px-2">${statusTitle}</span>`);
                    $('.renewDate').html(`<span class="flex items-center space-x-1">
                                            <span class="material-symbols-outlined block dark:text-gray-300 text-lg">history</span>
                                            <span class="block dark:text-gray-300 text-lg">${formattedCreatedAt}</span>
                                       </span>`);
                    $('.renewDay').html(`<span class="${renewDaysColorClass} text-sm font-semibold">${renewDaysText}</span>`);

                },
                error: function(xhr, status, error) {
                    console.log("AJAX Error: " + error);
                }
            });
        }

        // Initial load of user profile
        loadProducts();
    });
</script>
