<?php
$meta = array(
    'us' => array(
        'title' => 'Datanito Cloud Management - Control Your Hosting Services',
        'description' => 'Effortlessly oversee web hosting and business hosting with Datanito Cloud. Discover control and flexibility for your online presence.',
        'og:title' => 'Datanito Cloud Management - Control Web Hosting and Business Hosting',
        'og:description' => 'Effortlessly oversee web hosting and business hosting with Datanito Cloud. Discover control and flexibility for your online presence.',
        'og:image' => asset('images/brand/open_graph_logo.png'),
    ),
    'tr' => array(
        'title' => 'Datanito Cloud Yönetimi - Datanito (Türkiye)',
        'description' => 'Datanito Cloud ile web hosting ve işletme hosting hizmetlerinizi kolayca yönetin. Çevrimiçi varlığınız için kontrol ve esnekliği keşfedin.',
        'og:title' => 'Datanito Cloud Yönetimi - Web Hosting ve İşletme Hosting Kontrolü',
        'og:description' => 'Datanito Cloud ile web hosting ve işletme hosting hizmetlerinizi kolayca yönetin. Çevrimiçi varlığınız için kontrol ve esnekliği keşfedin.',
        'og:image' => asset('images/brand/open_graph_logo.png'),
    ),
);
$currentMeta = setCountryAndMeta($meta);
include_once includes('layouts/dashboard.php');
?>
<main class="p-4 md:pl-64 md:ml-8 md:mr-4 h-full pt-20 min-h-[70em] !overflow-hidden">
    <div class="relative min-h-[50em]">
        <div class="grid grid-cols-1 md:grid-cols-2 justify-between items-center space-y-4 md:space-y-0 mb-6">
            <div class="ml-2">
                <div class="flex items-center text-center justify-start">
                    <svg class="w-7 h-7 mr-4" xmlns="http://www.w3.org/2000/svg"
                         xmlns:xlink="http://www.w3.org/1999/xlink" width="151px" height="150px"
                         viewBox="0 0 639 636">
                        <g id="surface1">
                            <path style=" stroke:none;fill-rule:nonzero;fill-opacity:1;"
                                  class="fill-dark-950 dark:fill-white"
                                  d="M 543.414062 80.550781 C 563.308594 100.46875 563.308594 132.765625 543.414062 152.683594 L 155.367188 541.199219 C 135.472656 561.121094 103.214844 561.121094 83.316406 541.199219 C 63.421875 521.28125 63.421875 488.984375 83.316406 469.066406 L 471.371094 80.558594 C 491.257812 60.628906 523.515625 60.628906 543.414062 80.550781 Z M 543.414062 80.550781 "/>
                            <path style=" stroke:none;fill-rule:nonzero;fill-opacity:1;"
                                  class="fill-dark-950 dark:fill-white"
                                  d="M 350.257812 83.671875 C 370.15625 103.589844 370.15625 135.886719 350.257812 155.804688 L 158.246094 348.046875 C 138.347656 367.964844 106.089844 367.964844 86.195312 348.046875 C 66.296875 328.125 66.296875 295.828125 86.195312 275.910156 L 278.207031 83.671875 C 298.097656 63.75 330.363281 63.75 350.257812 83.671875 Z M 350.257812 83.671875 "/>
                            <path style=" stroke:none;fill-rule:nonzero;fill-opacity:1;"
                                  class="fill-dark-950 dark:fill-white"
                                  d="M 198.839844 42.324219 C 218.734375 62.242188 218.734375 94.539062 198.839844 114.457031 L 116.90625 196.484375 C 97.011719 216.40625 64.753906 216.40625 44.855469 196.484375 C 24.960938 176.566406 24.960938 144.269531 44.855469 124.351562 L 126.78125 42.324219 C 146.679688 22.402344 178.941406 22.402344 198.839844 42.324219 Z M 198.839844 42.324219 "/>
                            <path style=" stroke:none;fill-rule:nonzero;fill-opacity:1;"
                                  class="fill-dark-950 dark:fill-white"
                                  d="M 549.855469 263.0625 C 569.75 282.984375 569.75 315.277344 549.855469 335.199219 L 337.238281 548.0625 C 317.34375 567.984375 285.085938 567.984375 265.1875 548.0625 C 245.292969 528.140625 245.292969 495.847656 265.1875 475.925781 L 477.804688 263.0625 C 497.699219 243.140625 529.957031 243.140625 549.855469 263.0625 Z M 549.855469 263.0625 "/>
                            <path style=" stroke:none;fill-rule:nonzero;fill-opacity:1;"
                                  class="fill-dark-950 dark:fill-white"
                                  d="M 578.785156 423.015625 C 598.683594 442.933594 598.683594 475.230469 578.785156 495.148438 L 496.855469 577.171875 C 476.957031 597.089844 444.699219 597.089844 424.804688 577.171875 C 404.90625 557.25 404.90625 524.953125 424.804688 505.035156 L 506.726562 423.015625 C 526.625 403.085938 558.890625 403.085938 578.785156 423.015625 Z M 578.785156 423.015625 "/>
                        </g>
                    </svg>
                    <h1 class="text-2xl ml-[-0.6em] tracking-tight font-bold text-dark-950 dark:text-white"><?php echo $lang['DCloud']; ?></h1>
                </div>
                <h3 class="text-lg ml-2 mt-2 tracking-tight font-normal text-gray-700 dark:text-gray-300"><?php echo $lang['cloud-products-subheading']; ?></h3>
            </div>
            <div class="flex items-center justify-end">
                <button id="addNewCloudButton" data-dropdown-toggle="addNewCloud" class="flex items-center justify-between text-center text-white bg-dark-700 focus:ring-0 font-medium rounded-full text-sm p-3 dark:bg-dark-500 focus:outline-none" type="button">
                    <?php echo $lang['cloud-add-new'];?>
                    <svg class="w-2.5 h-2.5 ml-2.5" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 10 6">
                        <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="m1 1 4 4 4-4"/>
                    </svg>
                </button>

                <!-- Dropdown menu -->
                <div id="addNewCloud" class="z-10 hidden bg-white divide-y divide-gray-100 rounded-3xl shadow w-48 dark:bg-dark-700 border border-gray-200 dark:border-gray-500">
                    <ul class="py-4 px-2 space-y-3 text-sm text-gray-700 dark:text-gray-200" aria-labelledby="addNewCloudButton">
                        <li>
                            <a href="<?php echo url('/cloud'); ?>" class="block p-3 hover:bg-gray-100 dark:hover:bg-dark-600 dark:hover:text-white rounded-3xl"><?php echo $lang['cloud']?></a>
                        </li>
                        <li>
                            <a href="<?php echo url('/cloud/web-hosting'); ?>" class="block p-3 hover:bg-gray-100 dark:hover:bg-dark-600 dark:hover:text-white rounded-3xl"><?php echo $lang['web-hosting']?></a>
                        </li>
                        <li>
                            <a href="<?php echo url('/cloud/business-hosting'); ?>" class="block p-3 hover:bg-gray-100 dark:hover:bg-dark-600 dark:hover:text-white rounded-3xl"><?php echo $lang['business-hosting']?></a>
                        </li>
                    </ul>
                </div>
            </div>
        </div>
        <div class="text-center">
            <div id="productsList">
                <!-- Product data will be displayed here -->
                <div class="mt-36">
                    <div role="status" class="spinner hidden my-6 p-4 bg-gray-50 dark:bg-dark-700 rounded-3xl">
                        <svg aria-hidden="true" class="inline w-20 h-20 text-gray-200 animate-spin dark:text-gray-600 fill-blue-500" viewBox="0 0 100 101" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path d="M100 50.5908C100 78.2051 77.6142 100.591 50 100.591C22.3858 100.591 0 78.2051 0 50.5908C0 22.9766 22.3858 0.59082 50 0.59082C77.6142 0.59082 100 22.9766 100 50.5908ZM9.08144 50.5908C9.08144 73.1895 27.4013 91.5094 50 91.5094C72.5987 91.5094 90.9186 73.1895 90.9186 50.5908C90.9186 27.9921 72.5987 9.67226 50 9.67226C27.4013 9.67226 9.08144 27.9921 9.08144 50.5908Z" fill="currentColor"/>
                            <path d="M93.9676 39.0409C96.393 38.4038 97.8624 35.9116 97.0079 33.5539C95.2932 28.8227 92.871 24.3692 89.8167 20.348C85.8452 15.1192 80.8826 10.7238 75.2124 7.41289C69.5422 4.10194 63.2754 1.94025 56.7698 1.05124C51.7666 0.367541 46.6976 0.446843 41.7345 1.27873C39.2613 1.69328 37.813 4.19778 38.4501 6.62326C39.0873 9.04874 41.5694 10.4717 44.0505 10.1071C47.8511 9.54855 51.7191 9.52689 55.5402 10.0491C60.8642 10.7766 65.9928 12.5457 70.6331 15.2552C75.2735 17.9648 79.3347 21.5619 82.5849 25.841C84.9175 28.9121 86.7997 32.2913 88.1811 35.8758C89.083 38.2158 91.5421 39.6781 93.9676 39.0409Z" fill="currentFill"/>
                        </svg>
                        <span class="sr-only">Loading...</span>
                    </div>
                    <span class="inline-flex justify-center text-center empty-message hidden p-6 bg-gray-50 dark:bg-dark-700 rounded-3xl">
                        <span>
                            <span class="material-symbols-outlined block text-8xl text-gray-700 dark:text-gray-300 mb-4">info</span>
                            <span class="block sm:w-96">
                                <span class="block font-semibold text-lg mb-2 text-gray-800 dark:text-gray-200"><?php echo $lang['cloud-products-empty-headline']?></span>
                                <span class="block font-medium text-sm text-gray-600 dark:text-gray-400"><?php echo $lang['cloud-products-empty-subheading']?></span>
                            </span>
                        </span>
                    </span>
                </div>
            </div>
        </div>
    </div>
</main>
<?php
include_once includes('layouts/dashboard-end.php');
?>

<script>
    $(document).ready(function() {
        $('.spinner').addClass('inline-flex');
        $('.spinner').removeClass('hidden');
        const products = $('#productsList');

        function loadProducts() {
            var categories = 'web-hosting, business-hosting, cloud'; // Comma-separated string
            const domainsContainer = $('#domainsList');
            const spinner = domainsContainer.find('.spinner');
            const emptyMessage = domainsContainer.find('.empty-message');
            const content = $('#domainsContent');
            const tableBody = $('#domainsTableBody');

            // Show loading state
            spinner.removeClass('hidden').show();
            emptyMessage.addClass('hidden').hide();
            content.addClass('hidden');

            $.ajax({
                type: 'POST',
                url: '/get_user_products',
                dataType: 'json',
                data: { categories: categories }, // Pass the string as a single parameter
                success: function (response) {
                    $('.spinner').hide();
                    console.log(response);
                    if (response.length === 0) {
                        // If no invoices found, display the empty message
                        // You can add an "empty" element in your HTML to display the message.
                        $('.empty-message').removeClass('hidden');
                    } else {
                        // Clear the existing invoice list
                        products.empty();

                        // Loop through the invoices and add them to the container
                        $.each(response, function (index, product) {
                            function formatCreatedAt(created_at) {
                                const date = new Date(created_at);
                                const options = { year: 'numeric', month: 'long', day: 'numeric' };

                                <?php
                                $websiteLanguage = $_SESSION["country"];
                                if ($websiteLanguage === 'tr') {
                                    echo "const formattedDate = date.toLocaleDateString('tr-TR', options);";
                                } else {
                                    echo "const formattedDate = date.toLocaleDateString(undefined, options);";
                                }
                                ?>

                                return formattedDate;
                            }

                            const formattedCreatedAt = formatCreatedAt(product.renewal_date);

                            // Format the currency amount based on your requirement
                            let statusColorClass = '';
                            let statusTitle = '';

                            if (product.status === 'Active') {
                                statusColorClass = 'bg-green-500 dark:bg-green-600';
                                statusTitle = '<?php echo $lang['product-status-active']?>';
                            } else if (product.status === 'Overdue') {
                                statusColorClass = 'bg-red-500 dark:bg-red-600';
                                statusTitle = '<?php echo $lang['product-status-overdue']?>';
                            } else if (product.status === 'Pending') {
                                statusColorClass = 'bg-yellow-500 dark:bg-yellow-600';
                                statusTitle = '<?php echo $lang['product-status-pending']?>';
                            }

                            // Determine the text color for "Renew in X days"
                            let renewDaysText = '<?php echo $lang['waiting-for-payment']?>';
                            let renewDateDisplay = ''; // Declare renewDateDisplay outside the if block
                            let renewDaysColorClass = '';

                            if (product.renewal_date === null) {
                                renewDateDisplay = 'hidden'; // Modify the variable declared outside the block
                            }
                            if (product.renewal_date !== null) {
                                if (product.days_left > 30) {
                                    const monthsLeft = Math.ceil(product.days_left / 30);

                                    if (monthsLeft < 12) {
                                        renewDaysText = '<?php echo $lang['renew-in-d-months']; ?>'.replace('%d', monthsLeft);
                                    } else {
                                        const yearsLeft = Math.floor(monthsLeft / 12);
                                        const remainingMonths = monthsLeft % 12;
                                        renewDaysText = '<?php echo $lang['renew-in-d-years']; ?>'.replace('%d', yearsLeft);
                                    }

                                    renewDaysColorClass = 'text-gray-500'; // Blue for more than 30 days left
                                } else if (product.days_left <= 30 && product.days_left > 7) {
                                    renewDaysText = '<?php echo $lang['renew-in-d-days']; ?>'.replace('%d', product.days_left);
                                    renewDaysColorClass = 'text-green-500'; // Green for 8 to 30 days left
                                } else if (product.days_left <= 7 && product.days_left > 3) {
                                    renewDaysText = '<?php echo $lang['renew-in-d-days']; ?>'.replace('%d', product.days_left);
                                    renewDaysColorClass = 'text-yellow-500'; // Yellow for 4 to 7 days left
                                } else if (product.days_left <= 3 && product.days_left > 1) {
                                    renewDaysText = '<?php echo $lang['renew-in-d-days']; ?>'.replace('%d', product.days_left);
                                    renewDaysColorClass = 'text-red-500'; // Red for 3 or fewer days left
                                } else if (product.days_left <= 1 && product.days_left >= 0) {
                                    renewDaysText = '<?php echo $lang['renew-in-d-days']; ?>'.replace('%d', product.days_left);
                                    renewDaysColorClass = 'text-red-500'; // Red for 3 or fewer days left
                                } else if (product.days_left < 0) {
                                    const overdueDays = Math.abs(product.days_left);
                                    renewDaysText = '<?php echo $lang['overdue-d-days-ago']; ?>'.replace('%d', overdueDays);
                                    renewDaysColorClass = 'text-red-500'; // Red for overdue
                                }
                            }



                            const productRow = $("<div class='block md:flex justify-between mb-4 px-4 sm:px-5 py-4 sm:py-6 space-y-4 md:space-y-0 rounded-3xl bg-white border border-gray-200 dark:border-dark-500 dark:bg-dark-900 max-h-36 md:max-h-24 overflow-hidden w-full'>");

                            productRow.html(`
                                <!-- Left side -->
                                <span class="flex md:space-x-12 justify-between items-center">

                                    <!-- Status and Product Name -->
                                    <span class="text-left font-medium text-gray-900 whitespace-nowrap dark:text-white sm:max-w-56 w-full flex items-center">
                                        <!-- Status Badge -->
                                        <span class="mr-3 hidden sm:block">
                                            <span class="material-symbols-outlined text-4xl">filter_drama</span>
                                        </span>
                                        <span class="flex items-center justify-between flex-row-reverse w-full sm:block sm:space-y-1">
                                            <!-- Status Badge -->
                                            <span class="inline items-center text-xs ${statusColorClass} text-white rounded-xl py-1 px-3 sm:py-0.5 sm:px-2">${statusTitle}</span>
                                            <!-- Product Name -->
                                            <span><span class="font-semibold text-lg block text-gray-700 dark:text-gray-300">${product.name}</span><span class="text-sm flex">(${product.order_name})</span></span>
                                        </span>
                                    </span>
                                </span>

                                <!-- Right side -->
                                <span class="flex md:space-x-3 justify-between items-center">

                                    <!-- Date and Renewal -->
                                    <span class="block text-center">
                                        <!-- Date and Renewal information -->
                                        <span class="flex items-center space-x-1 ${renewDateDisplay}">
                                            <span class="material-symbols-outlined block dark:text-gray-400 text-sm">history</span>
                                            <span class="block dark:text-gray-400 text-sm">${formattedCreatedAt}</span>
                                        </span>
                                        <span class="${renewDaysColorClass} text-sm font-semibold">${renewDaysText}</span>
                                    </span>

                                    <!-- Action Button -->
                                    <span class="flex">
                                        <a href="<?php echo url('/account/cloud/${product.order_number}')?>" class="flex w-full text-center text-white bg-dark-700 hover:bg-dark-800 focus:ring-0 font-medium rounded-full text-sm p-3 dark:bg-dark-700 dark:hover:bg-dark-800 focus:outline-none" type="button">
                                            <span class="material-symbols-outlined flex items-center jsutify-center w-5 h-5 font-bold text-2xl">chevron_right</span>
                                        </a>
                                    </span>
                                </span>

                        `);

                            // Append the row to the product list
                            products.append(productRow);
                        });
                    }

                },
                error: function(xhr, status, error) {
                    console.log("AJAX Error: " + error);
                }
            });
        }

        // Initial load of user profile
        loadProducts();
    });



</script>
