<?php
$meta = array(
    'us' => array(
        'title' => 'Datanito Analytics - Website Performance Metrics and Data',
        'description' => 'Analyze and track your website\'s performance with Datanito Analytics. Get valuable insights and data to optimize your online presence.',
        'og:title' => 'Datanito Analytics - Website Performance Metrics and Data',
        'og:description' => 'Analyze and track your website\'s performance with Datanito Analytics. Get valuable insights and data to optimize your online presence.',
        'og:image' => asset('images/brand/open_graph_logo.png'),
    ),
    'tr' => array(
        'title' => 'Datanito Analytics (Türkiye) - Web Sitesi Performans Metrikleri ve Verileri',
        'description' => 'Datanito Analytics ile web sitenizin performansını analiz edin ve takip edin. Çevrimiçi varlığınızı optimize etmek için değerli bilgiler ve veriler elde edin.',
        'og:title' => 'Datanito Analytics (Türkiye) - Web Sitesi Performans Metrikleri ve Verileri',
        'og:description' => 'Datanito Analytics ile web sitenizin performansını analiz edin ve takip edin. Çevrimiçi varlığınızı optimize etmek için değerli bilgiler ve veriler elde edin.',
        'og:image' => asset('images/brand/open_graph_logo.png'),
    ),
);
$currentMeta = setCountryAndMeta($meta);
include_once includes('layouts/dashboard.php');
?>
<main class="p-4 md:pl-64 md:ml-8 md:mr-4 h-full pt-20 min-h-[70em] !overflow-hidden">
    <div class="relative min-h-[50em]">
        <div class="grid grid-cols-1 md:grid-cols-2 justify-between items-center space-y-4 md:space-y-0 mb-6">
            <div class="ml-2">
                <button data-modal-target="dataDurationModal" data-modal-toggle="dataDurationModal" class="flex items-center bg-blue-100 hover:bg-blue-200 dark:bg-dark-500 p-1.5 px-3 rounded-full text-sm font-semibold space-x-2" type="button">
                    <span>
                        <span>
                            Data:
                        </span>
                        <span id="selectedDataDuration">
                            Last 3 months
                        </span>
                    </span>
                    <span class="material-symbols-outlined text-lg">edit</span>
                </button>
            </div>
            <div class="flex items-center justify-end">
                <button id="dropdownPropertiesButton" data-dropdown-toggle="dropdownProperties" class="flex items-center justify-between text-center text-white bg-dark-700 focus:ring-0 font-medium rounded-full text-sm p-3 dark:bg-dark-500 focus:outline-none" type="button">
                    Add a new
                    <svg class="w-2.5 h-2.5 ml-2.5" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 10 6">
                        <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="m1 1 4 4 4-4"/>
                    </svg>
                </button>

                <!-- Dropdown menu -->
                <div id="dropdownProperties" class="z-10 hidden bg-white divide-y divide-gray-100 rounded-3xl shadow w-60 dark:bg-dark-700 border border-gray-200 dark:border-gray-500">
                    <ul class="h-64 py-2 overflow-y-auto text-gray-700 dark:text-gray-200" aria-labelledby="dropdownPropertiesButton" id="website-list">
                        <!-- Websites will be dynamically added here -->
                        <p class="flex text-center justify-center items-center text-gray-600 dark:text-gray-400">No any website added</p>
                    </ul>
                    <button data-modal-target="addNewWebsiteModal" data-modal-toggle="addNewWebsiteModal"  class="flex items-center w-full space-x-2 p-3 text-sm font-medium text-gray-600 rounded-3xl bg-gray-50 hover:bg-gray-100 dark:bg-dark-600 dark:hover:bg-dark-500 dark:text-gray-400 border-none" type="button">
                        <span class="material-symbols-outlined">add</span>
                        <span>New website</span>
                    </button>
                </div>
            </div>
        </div>
        <div class="text-center">
            <div id="productsList">

                <div id="website-info">
                    <h2></h2>
                    <p id="info-message"></p>
                    <div id="tracking-code">
                        <!-- Your tracking code will be generated here -->
                    </div>
                </div>
                <!-- Product data will be displayed here -->
                <div class="mt-36">
                    <div role="status" class="spinner hidden my-6 p-4 bg-gray-50 dark:bg-dark-700 rounded-3xl">
                        <svg aria-hidden="true" class="inline w-20 h-20 text-gray-200 animate-spin dark:text-gray-600 fill-blue-500" viewBox="0 0 100 101" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path d="M100 50.5908C100 78.2051 77.6142 100.591 50 100.591C22.3858 100.591 0 78.2051 0 50.5908C0 22.9766 22.3858 0.59082 50 0.59082C77.6142 0.59082 100 22.9766 100 50.5908ZM9.08144 50.5908C9.08144 73.1895 27.4013 91.5094 50 91.5094C72.5987 91.5094 90.9186 73.1895 90.9186 50.5908C90.9186 27.9921 72.5987 9.67226 50 9.67226C27.4013 9.67226 9.08144 27.9921 9.08144 50.5908Z" fill="currentColor"/>
                            <path d="M93.9676 39.0409C96.393 38.4038 97.8624 35.9116 97.0079 33.5539C95.2932 28.8227 92.871 24.3692 89.8167 20.348C85.8452 15.1192 80.8826 10.7238 75.2124 7.41289C69.5422 4.10194 63.2754 1.94025 56.7698 1.05124C51.7666 0.367541 46.6976 0.446843 41.7345 1.27873C39.2613 1.69328 37.813 4.19778 38.4501 6.62326C39.0873 9.04874 41.5694 10.4717 44.0505 10.1071C47.8511 9.54855 51.7191 9.52689 55.5402 10.0491C60.8642 10.7766 65.9928 12.5457 70.6331 15.2552C75.2735 17.9648 79.3347 21.5619 82.5849 25.841C84.9175 28.9121 86.7997 32.2913 88.1811 35.8758C89.083 38.2158 91.5421 39.6781 93.9676 39.0409Z" fill="currentFill"/>
                        </svg>
                        <span class="sr-only">Loading...</span>
                    </div>
                    <span class="inline-flex justify-center text-center empty-message hidden p-6 bg-gray-50 dark:bg-dark-700 rounded-3xl">
                        <span>
                            <span class="material-symbols-outlined block text-8xl text-gray-700 dark:text-gray-300 mb-4">info</span>
                            <span class="block sm:w-96">
                                <span class="block font-semibold text-lg mb-2 text-gray-800 dark:text-gray-200"><?php echo $lang['cloud-products-empty-headline']?></span>
                                <span class="block font-medium text-sm text-gray-600 dark:text-gray-400"><?php echo $lang['cloud-products-empty-subheading']?></span>
                            </span>
                        </span>
                    </span>
                </div>
            </div>
        </div>
    </div>
    <div id="addNewWebsiteModal" tabindex="-1" aria-hidden="true" class="fixed top-0 left-0 right-0 z-50 hidden w-full overflow-x-hidden overflow-y-auto md:inset-0 h-[100%] max-h-full justify-center items-center cssanimation fadeInBottom dark:!bg-dark-800/25">
        <div class="sm:relative sm:w-full sm:max-w-md sm:max-h-full fixed bottom-0 w-full">
            <!-- Modal content -->
            <div class="relative bg-white sm:rounded-3xl shadow dark:bg-dark-700 rounded-t-[2rem]">
                <button type="button" class="close-modal absolute top-3 right-2.5 text-gray-400 bg-transparent hover:bg-gray-200 hover:text-gray-900 rounded-3xl text-sm w-8 h-8 ml-auto inline-flex justify-center items-center dark:hover:bg-dark-600 dark:hover:text-white" data-modal-hide="addNewWebsiteModal">
                    <svg class="w-3 h-3" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 14 14">
                        <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="m1 1 6 6m0 0 6 6M7 7l6-6M7 7l-6 6"/>
                    </svg>
                    <span class="sr-only">Close modal</span>
                </button>
                <div class="px-6 py-4 sm:py-6 lg:px-8 max-h-[550px] lg:max-h-[100%] overflow-hidden">
                    <h3 class="mb-0.5 text-xl font-bold text-gray-900 dark:text-white">Add a new property</h3>
                    <span class="mb-1 text-sm font-normal text-dark-800 dark:text-gray-300">You can add your website to Datanito Analytics and start improving.</span>
                    <form id="add-website-form" class="space-y-2 lg:space-y-6">
                        <?php set_csrf(); ?>
                        <div class="relative !my-6 sm:my-0">
                            <input type="text" name="website_url" id="website_url" class="block px-2.5 pb-2.5 pt-4 w-full text-sm text-gray-900 bg-transparent rounded-lg border-1 border-gray-300 appearance-none dark:text-white dark:border-gray-600 dark:focus:border-blue-500 focus:outline-none focus:ring-0 focus:border-blue-600 peer" placeholder=" " required/>
                            <label for="website_url" class="absolute text-sm text-gray-500 dark:text-gray-400 duration-300 transform -translate-y-4 scale-75 top-2 z-10 origin-[0] bg-white dark:bg-dark-700 px-2 peer-focus:px-2 peer-focus:text-blue-600 peer-focus:dark:text-blue-500 peer-placeholder-shown:scale-100 peer-placeholder-shown:-translate-y-1/2 peer-placeholder-shown:top-1/2 peer-focus:top-2 peer-focus:scale-75 peer-focus:-translate-y-4 left-1">Enter URL</span></label>
                        </div>
                        <div class="relative hidden">
                            <input type="text" id="honeypot" name="honeypot" value="">
                        </div>
                        <div class="flex items-center justify-end my-6">
                            <button type="submit" class="flex items-center justify-between space-x-2 text-center text-white bg-dark-700 focus:ring-0 font-medium rounded-full text-sm p-3 py-1.5 dark:bg-dark-500 focus:outline-none">
                                <span>Add Now</span>
                                <span class="material-symbols-outlined flex items-center justify-center w-8 h-8 bg-dark-600 dark:bg-dark-800 rounded-full font-bold text-2xl">chevron_right</span>
                            </button>
                        </div>
                        <p class="text-sm !mt-4 text-gray-500 dark:text-gray-400"><?php echo $lang['form-privacy']; ?></p>
                    </form>
                </div>

            </div>
        </div>
    </div>
    <div id="dataDurationModal" tabindex="-1" aria-hidden="true" class="fixed top-0 left-0 right-0 z-50 hidden w-full overflow-x-hidden overflow-y-auto md:inset-0 h-[100%] max-h-full justify-center items-center cssanimation fadeInBottom dark:!bg-dark-800/25">
        <div class="sm:relative sm:w-full sm:max-w-md sm:max-h-full fixed bottom-0 w-full">
            <!-- Modal content -->
                <div class="relative bg-white sm:rounded-3xl shadow dark:bg-dark-700 rounded-t-[2rem]">
                <!-- Modal header -->
                <div class="flex items-center justify-between p-4 md:p-5 border-b rounded-t dark:border-gray-600">
                    <h3 class="text-xl font-semibold text-gray-900 dark:text-white">
                        Date range
                    </h3>
                    <button type="button" class="text-gray-400 bg-transparent hover:bg-gray-200 hover:text-gray-900 rounded-lg text-sm w-8 h-8 ms-auto inline-flex justify-center items-center dark:hover:bg-gray-600 dark:hover:text-white" data-modal-hide="default-modal">
                        <svg class="w-3 h-3" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 14 14">
                            <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="m1 1 6 6m0 0 6 6M7 7l6-6M7 7l-6 6"/>
                        </svg>
                        <span class="sr-only">Close modal</span>
                    </button>
                </div>
                <!-- Modal body -->
                <div class="p-4 md:p-5 space-y-4">
                    <!-- Duration options -->
                    <div class="flex items-center mb-4">
                        <input id="most-recent" type="radio" value="most_recent" name="duration" class="w-5 h-5 text-blue-600 bg-gray-100 border-gray-300 focus:ring-blue-500 dark:focus:ring-blue-600 dark:ring-offset-gray-800 focus:ring-2 dark:bg-gray-700 dark:border-gray-600">
                        <label for="most-recent" class="ms-2 text-md font-base text-gray-900 dark:text-gray-300">Most recent date (April 3, 2024)</label>
                    </div>
                    <div class="flex items-center mb-4">
                        <input id="last-7-days" type="radio" value="last_7_days" name="duration" class="w-5 h-5 text-blue-600 bg-gray-100 border-gray-300 focus:ring-blue-500 dark:focus:ring-blue-600 dark:ring-offset-gray-800 focus:ring-2 dark:bg-gray-700 dark:border-gray-600">
                        <label for="last-7-days" class="ms-2 text-md font-base text-gray-900 dark:text-gray-300">Last 7 days</label>
                    </div>
                    <div class="flex items-center mb-4">
                        <input id="last-28-days" type="radio" value="last_28_days" name="duration" class="w-5 h-5 text-blue-600 bg-gray-100 border-gray-300 focus:ring-blue-500 dark:focus:ring-blue-600 dark:ring-offset-gray-800 focus:ring-2 dark:bg-gray-700 dark:border-gray-600">
                        <label for="last-28-days" class="ms-2 text-md font-base text-gray-900 dark:text-gray-300">Last 28 days</label>
                    </div>
                    <div class="flex items-center mb-4">
                        <input id="last-3-months" type="radio" value="last_3_months" name="duration" class="w-5 h-5 text-blue-600 bg-gray-100 border-gray-300 focus:ring-blue-500 dark:focus:ring-blue-600 dark:ring-offset-gray-800 focus:ring-2 dark:bg-gray-700 dark:border-gray-600">
                        <label for="last-3-months" class="ms-2 text-md font-base text-gray-900 dark:text-gray-300">Last 3 months</label>
                    </div>
                    <div class="flex items-center mb-4">
                        <input id="last-6-months" type="radio" value="last_6_months" name="duration" class="w-5 h-5 text-blue-600 bg-gray-100 border-gray-300 focus:ring-blue-500 dark:focus:ring-blue-600 dark:ring-offset-gray-800 focus:ring-2 dark:bg-gray-700 dark:border-gray-600">
                        <label for="last-6-months" class="ms-2 text-md font-base text-gray-900 dark:text-gray-300">Last 6 months</label>
                    </div>
                    <div class="flex items-center mb-4">
                        <input id="last-12-months" type="radio" value="last_12_months" name="duration" class="w-5 h-5 text-blue-600 bg-gray-100 border-gray-300 focus:ring-blue-500 dark:focus:ring-blue-600 dark:ring-offset-gray-800 focus:ring-2 dark:bg-gray-700 dark:border-gray-600">
                        <label for="last-12-months" class="ms-2 text-md font-base text-gray-900 dark:text-gray-300">Last 12 months</label>
                    </div>
                    <div class="flex items-center mb-4">
                        <input id="last-16-months" type="radio" value="last_16_months" name="duration" class="w-5 h-5 text-blue-600 bg-gray-100 border-gray-300 focus:ring-blue-500 dark:focus:ring-blue-600 dark:ring-offset-gray-800 focus:ring-2 dark:bg-gray-700 dark:border-gray-600">
                        <label for="last-16-months" class="ms-2 text-md font-base text-gray-900 dark:text-gray-300">Last 16 months</label>
                    </div>
                    <div class="flex items-center mb-4">
                        <input id="custom-date" type="radio" value="custom_date" name="duration" class="w-5 h-5 text-blue-600 bg-gray-100 border-gray-300 focus:ring-blue-500 dark:focus:ring-blue-600 dark:ring-offset-gray-800 focus:ring-2 dark:bg-gray-700 dark:border-gray-600">
                        <label for="custom-date" class="ms-2 text-md font-base text-gray-900 dark:text-gray-300">Custom date</label>
                    </div>
                </div>
                <!-- Modal footer -->
                <div class="flex items-center justify-end p-4 md:p-5 border-t border-gray-200 rounded-b dark:border-gray-600">
                    <button data-modal-hide="default-modal" type="button" class="py-2.5 px-5 ms-3 text-sm font-medium text-gray-900 focus:outline-none bg-transparent rounded-full hover:bg-blue-50 focus:z-10 focus:ring-4 focus:ring-gray-100 dark:focus:ring-gray-700 dark:bg-transparent dark:text-gray-400 dark:hover:bg-dark-500">Cancel</button>
                    <button data-modal-hide="default-modal" type="button" class="text-white bg-blue-700 hover:bg-blue-800 focus:ring-4 focus:outline-none focus:ring-blue-300 font-medium rounded-full text-sm px-5 py-2.5 text-center dark:bg-blue-600 dark:hover:bg-blue-700 dark:focus:ring-blue-800">Apply</button>
                </div>
            </div>
        </div>
    </div>

    </div>
</main>
<?php
include_once includes('layouts/dashboard-end.php');
?>
<script src="https://cdn.jsdelivr.net/npm/apexcharts"></script>

<script>
    $(document).ready(function() {
        $('.spinner').addClass('inline-flex');
        $('.spinner').removeClass('hidden');
        $("#add-website-form").submit(function(event) {
            event.preventDefault(); // Prevent the form from submitting the traditional way

            var websiteURL = $("#website_url").val(); // Get the website URL from the input field
            var csrf = $('input[name="csrf"]').val();

            // Send an AJAX request to the PHP script
            $.ajax({
                type: "POST",
                url: "/analytics_add_new_website",
                data: {
                    website_url: websiteURL,
                    csrf: csrf,
                },
                dataType: 'json', // Expect JSON response
                success: function(response) {
                    // Display the result in the 'result' div
                    $("#toast-success").css("display", "flex");
                    $('#website_url').val('');
                    $('.close-modal').trigger('click');
                    $("#toast-success").removeClass("hidden");
                    $(".toast-message").text(response.message);
                    if (response.icon === 'error') {
                        $(".notification-success").addClass("hidden");
                        $(".notification-error").removeClass("hidden");
                    }
                    $("#toast-success").addClass("notification-opened");
                    $("#toast-success svg").addClass("notification-checkmark");
                    $("#toast-success").removeClass("notification-closed");
                    getWebsites();

                    // Hide the success message after 2 seconds
                    setTimeout(function () {
                        $("#toast-success").addClass("notification-closed");
                        $("#toast-success").removeClass("notification-opened");
                        $("#toast-success svg").removeClass("notification-checkmark");
                        $(".notification-error").addClass("hidden");
                        $(".notification-success").removeClass("hidden");
                    }, 2000);
                }
            });
        });
        getWebsites();

        function getWebsites() {
            $.ajax({
                url: '/analytics_get_websites',
                method: 'POST',
                dataType: 'json',
                success: function(data) {
                    // Check if the data array is not empty
                    if (data.length > 0) {
                        // Clear the website list before populating it
                        var websiteList = $('#website-list');
                        websiteList.empty();

                        var selectedWebsite = ''; // Initialize the selected website text
                        var selectedFavicon = ''; // Initialize the selected favicon URL
                        var autoSelectedSpan = null; // Store the auto-selected span
                        var manualSelectionMade = false; // Flag to track manual selections

                        $.each(data, function(index, website) {
                            // Create a list item for each website
                            var listItem = $('<li></li>');
                            var span = $('<span></span>', {
                                class: 'flex items-center justify-center m-1 p-3 hover:bg-gray-100 dark:hover:bg-dark-600 dark:hover:text-white rounded-3xl cursor-pointer',
                            });

                            // Create an image for the website favicon
                            var img = $('<img />', {
                                class: 'w-6 h-6 mr-2 rounded-full',
                                alt: 'Website Favicon',
                            });

                            // Fetch the favicon using a service (e.g., favicon.io)
                            // Replace 'example.com' with the actual website's domain
                            var faviconURL = 'https://www.google.com/s2/favicons?domain=' + website.website_url;
                            img.attr('src', faviconURL);

                            // Add the image and website name to the span
                            span.append(img);
                            span.append(website.website_url); // You can customize this part

                            // Add a click event to set the selected website when the span is clicked
                            span.on('click', function(event) {
                                // Remove the background from all spans
                                $('#website-list span').removeClass('bg-gray-100 dark:bg-dark-500 selected');
                                // Set the selected class to the clicked span
                                span.addClass('bg-gray-100 dark:bg-dark-500 selected');

                                selectedWebsite = website.website_url;
                                selectedFavicon = faviconURL;

                                updateDropdownButton(selectedWebsite, selectedFavicon);
                                getWebsiteInfo(selectedWebsite);
                                $('.spinner').show();


                                // Indicate that this is a manual selection
                                autoSelectedSpan = null;
                                manualSelectionMade = true;
                            });

                            // Add the list item to the website list
                            listItem.append(span);
                            websiteList.append(listItem);

                            // Add a "selected" class to the last added website (only for auto-selection)
                            if (index === data.length - 1 && !manualSelectionMade) {
                                span.addClass('bg-gray-100 dark:bg-dark-500 selected');
                                selectedWebsite = website.website_url; // Set the initially selected website
                                selectedFavicon = faviconURL; // Set the initially selected favicon
                                autoSelectedSpan = span; // Set the auto-selected span
                            }
                        });

                        // Scroll to the last added website
                        var selectedListItem = $('.selected');
                        if (selectedListItem.length > 0) {
                            websiteList.scrollTop(selectedListItem.position().top);
                        }

                        // Update the dropdown button with the selected website and favicon
                        getWebsiteInfo(selectedWebsite);
                        updateDropdownButton(selectedWebsite, selectedFavicon);
                    } else {
                        $('.spinner').hide();
                        console.log('Website data is empty.');
                        // You might want to handle this case, for example, by displaying a message or hiding the dropdown button.
                    }
                },
                error: function() {
                    // Handle any errors if necessary
                    console.log('Failed to fetch website data.');
                }
            });
        }
// Function to update the dropdown button with the selected website and favicon
        function updateDropdownButton(selectedWebsite, selectedFavicon) {
            var dropdownButton = $('#dropdownPropertiesButton');
            var imageElement = $('<img />', {
                class: 'w-6 h-6 mr-2 rounded-full',
                alt: 'Website Favicon',
                src: selectedFavicon,
            });
            dropdownButton.html(imageElement);
            dropdownButton.append(selectedWebsite + ' <svg class="w-2.5 h-2.5 ml-2.5" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 10 6"><path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="m1 1 4 4 4-4"/></svg>');
        }
        function getWebsiteInfo(selectedWebsite) {
            var websiteURL = selectedWebsite;
            var csrf = $('input[name="csrf"]').val();
            var selectedDuration = $('#duration-dropdown').val(); // Assuming you have a dropdown with ID 'duration-dropdown' for selecting duration

            $.ajax({
                type: 'POST',
                url: '/analytics_get_website_data',
                data: {
                    website_url: websiteURL,
                    duration: selectedDuration, // Send selected duration to backend
                    csrf: csrf,
                },
                dataType: 'json',
                success: function(response) {
                    setTimeout(function() {
                        $('.spinner').hide();
                    }, 500);
                    console.log(response);
                    if (response.success) {
                        var analyticsData = response.analyticsData;
                        var websiteInfo = response.websiteInfo;
                        displayWebsiteInfo(websiteInfo, analyticsData);
                    } else {
                        $('#info-message').text(response.message);
                    }
                },
                error: function(error) {
                    console.log(error)
                }
            });
        }
        function displayWebsiteInfo(websiteInfo, analyticsData) {
            // Generate summary box for analytics data
            var summaryBoxHTML = `
<section class="grid gap-6 my-6 md:grid-cols-4">
    <div class="p-6 bg-gray-50 dark:bg-dark-600 rounded-3xl cursor-pointer summary-box !bg-gray-100 dark:!bg-dark-700" data-series="Visits">
        <dl class="space-y-2">
            <dt class="text-sm font-medium text-gray-500">Visits</dt>
            <dd class="text-5xl font-light md:text-6xl">${calculateTotal(analyticsData, 'visits')}</dd>
            <dd class="flex items-center space-x-1 text-sm font-medium text-green-500">
                <span>${calculateChange(analyticsData, 'visits')}</span>
                ${getArrowIcon(analyticsData, 'visits')}
            </dd>
        </dl>
    </div>

    <div class="p-6 bg-gray-50 dark:bg-dark-600 rounded-3xl cursor-pointer summary-box" data-series="Unique Visitors">
        <dl class="space-y-2">
            <dt class="text-sm font-medium text-gray-500">Unique Visitors</dt>
            <dd class="text-5xl font-light md:text-6xl">${calculateTotal(analyticsData, 'unique_visitors')}</dd>
            <dd class="flex items-center space-x-1 text-sm font-medium text-green-500">
                <span>${calculateChange(analyticsData, 'unique_visitors')}</span>
                ${getArrowIcon(analyticsData, 'unique_visitors')}
            </dd>
        </dl>
    </div>

    <div class="p-6 bg-gray-50 dark:bg-dark-600 rounded-3xl cursor-pointer summary-box" data-series="Bounce Rate">
        <dl class="space-y-2">
            <dt class="text-sm font-medium text-gray-500">Bounce Rate</dt>
            <dd class="text-5xl font-light md:text-6xl">${calculateAverage(analyticsData, 'bounce_rate')}%</dd>
            <dd class="flex items-center space-x-1 text-sm font-medium text-red-500">
                <span>${calculateChange(analyticsData, 'bounce_rate')}%</span>
                ${getArrowIcon(analyticsData, 'bounce_rate')}
            </dd>
        </dl>
    </div>

    <div class="p-6 bg-gray-50 dark:bg-dark-600 rounded-3xl cursor-pointer summary-box" data-series="Average Duration">
        <dl class="space-y-2">
            <dt class="text-sm font-medium text-gray-500">Average Duration</dt>
            <dd class="text-5xl font-light md:text-6xl">${calculateAverageDuration(analyticsData)}</dd>
            <dd class="flex items-center space-x-1 text-sm font-medium text-green-500">
                <span>${calculateChangeDuration(analyticsData)}</span>
                ${getArrowIconDuration(analyticsData)}
            </dd>
        </dl>
    </div>
</section>
                <div class="w-full bg-gray-50 rounded-3xl dark:bg-dark-600 p-4 md:p-6">
                    <div class="flex justify-between mb-5">
                        <div>
                            <p id="chosen-data-name" class="text-gray-600 dark:text-gray-400 font-semibold text-sm">Visits</p>
                        </div>
                        <div id="data-change" class="flex items-center px-2.5 py-0.5 text-base font-semibold text-green-500 dark:text-green-500 text-center">
                        </div>
                    </div>
                    <div id="main-chart"></div>
                </div>
`;

            $('#website-info').html(summaryBoxHTML);

            // Generate the chart
            var chartDataVisits = [];
            var chartDataUniqueVisitors = [];
            var chartDataBounceRate = [];
            var chartDataAvgDuration = [];
            var chartCategories = [];

            analyticsData.forEach(function(data) {
                chartDataVisits.push(data.visits);
                chartDataUniqueVisitors.push(data.unique_visitors);
                chartDataBounceRate.push(data.bounce_rate);
                // Convert the duration from "HH:MM:SS" format to seconds
                chartDataAvgDuration.push(durationToSeconds(data.average_duration));
                chartCategories.push(data.date);
            });

            // Initialize the default data series to be displayed
            var currentSeries = "Visits";

            // Chart options
            var options = {
                yaxis: {
                    show: false,
                    labels: {
                        formatter: function (value) {
                            return value;
                        }
                    }
                },
                chart: {
                    height: "100%",
                    maxWidth: "100%",
                    type: "area",
                    fontFamily: "Inter, sans-serif",
                    dropShadow: {
                        enabled: false,
                    },
                    toolbar: {
                        show: false,
                    },
                },
                tooltip: {
                    enabled: true,
                    x: {
                        show: false,
                    },
                },
                legend: {
                    show: true
                },
                fill: {
                    type: "gradient",
                    gradient: {
                        opacityFrom: 0.55,
                        opacityTo: 0,
                        shade: "#1C64F2",
                        gradientToColors: ["#1C64F2"],
                    },
                },
                dataLabels: {
                    enabled: false,
                },
                stroke: {
                    width: 6,
                },
                grid: {
                    show: false,
                    strokeDashArray: 4,
                    padding: {
                        left: 2,
                        right: 2,
                        top: -26
                    },
                },
                colors: ["#1A56DB"],
                series: [
                    {
                        name: "Visits",
                        data: chartDataVisits,
                        color: '#1A56DB',
                    },
                    {
                        name: "Unique Visitors",
                        data: chartDataUniqueVisitors,
                        color: '#1A56DB',
                    },
                    {
                        name: "Bounce Rate",
                        data: chartDataBounceRate,
                        color: '#1A56DB',
                    },
                    {
                        name: "Average Duration",
                        data: chartDataAvgDuration,
                        color: '#1A56DB',
                    }
                ],
                xaxis: {
                    categories: chartCategories,
                    labels: {
                        style: {
                            colors: '#787878',
                        },
                    },
                    axisBorder: {
                        show: false,
                    },
                    axisTicks: {
                        show: false,
                    },
                },
            };

            if (document.getElementById("main-chart") && typeof ApexCharts !== 'undefined') {
                const chart = new ApexCharts(document.getElementById("main-chart"), options);
                chart.render();

// Function to update the chart series
                function updateChart(seriesName, render = true) {
                    console.log("Updating chart with series:", seriesName);
                    var selectedSeries = options.series.find(series => series.name.trim() === seriesName.trim());
                    if (selectedSeries) {
                        console.log("Selected series:", selectedSeries);
                        // Update chosen data name
                        document.getElementById("chosen-data-name").innerText = seriesName;
                        chart.updateSeries([selectedSeries], render);
                    } else {
                        console.error("Series not found:", seriesName);
                    }
                }

// Initialize the chart with the "Visits" series
                updateChart("Visits", true);


// Add click event listeners to the summary boxes to switch the displayed data series
                document.querySelectorAll(".summary-box").forEach(box => {
                    box.addEventListener("click", function () {
                        // Remove "selected" class from all boxes
                        document.querySelectorAll(".summary-box").forEach(box => {
                            box.classList.remove("!bg-gray-100", "dark:!bg-dark-700");
                        });

                        // Add "selected" class to the clicked box
                        this.classList.add("!bg-gray-100", "dark:!bg-dark-700");

                        var seriesName = this.getAttribute("data-series");
                        updateChart(seriesName);
                        currentSeries = seriesName;
                    });
                });


            }
        }

// Function to convert duration from "HH:MM:SS" format to seconds
        function durationToSeconds(duration) {
            var timeParts = duration.split(":");
            var hours = parseInt(timeParts[0]);
            var minutes = parseInt(timeParts[1]);
            var seconds = parseInt(timeParts[2]);
            return hours * 3600 + minutes * 60 + seconds;
        }

// Function to format duration in seconds to "HH:MM:SS" format
        function formatDuration(seconds) {
            var hours = Math.floor(seconds / 3600);
            var minutes = Math.floor((seconds % 3600) / 60);
            var remainingSeconds = seconds % 60;
            return `${hours}:${minutes}:${remainingSeconds}`;
        }
        // Function to calculate change in data
        function calculateChange(data, property) {
            var change = data.length > 1 ? ((data[data.length - 1][property] - data[data.length - 2][property]) / data[data.length - 2][property] * 100).toFixed(2) + '%' : '';
            return change ? change : 'No change';
        }

// Function to get arrow icon based on change in data
        function getArrowIcon(data, property) {
            var change = calculateChange(data, property);
            if (change.includes('-')) {
                return `
            <svg class="w-7 h-7 text-red-500" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24">
                <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M17.25 8.75V17.25H8.75"></path>
                <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M17 17L6.75 6.75"></path>
            </svg>
        `;
            } else {
                return `
            <svg class="w-7 h-7 text-green-500" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24">
                <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M17.25 15.25V6.75H8.75"></path>
                <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M17 7L6.75 17.25"></path>
            </svg>
        `;
            }
        }


// Function to get arrow icon for change in average duration
        function getArrowIconDuration(data) {
            var changeInSeconds = calculateChangeDuration(data);
            if (changeInSeconds.includes('-')) {
                return `
            <svg class="w-7 h-7 text-red-500" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24">
                <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M17.25 8.75V17.25H8.75"></path>
                <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M17 17L6.75 6.75"></path>
            </svg>
        `;
            } else {
                return `
            <svg class="w-7 h-7 text-green-500" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24">
                <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M17.25 15.25V6.75H8.75"></path>
                <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M17 7L6.75 17.25"></path>
            </svg>
        `;
            }
        }
// Function to calculate the total of a specific property in the analytics data
        function calculateTotal(data, property) {
            var total = 0;
            for (var i = 0; i < data.length; i++) {
                total += data[i][property];
            }
            return total;
        }

// Function to calculate the average of a specific property in the analytics data
        function calculateAverage(data, property) {
            var total = calculateTotal(data, property);
            var average = total / data.length;
            return average.toFixed(2);
        }
// Function to calculate change in average duration
        function calculateChangeDuration(data) {
            var latestAverageDuration = parseDurationStringToSeconds(calculateAverageDuration(data[data.length - 1]));
            var previousAverageDuration = parseDurationStringToSeconds(calculateAverageDuration(data[data.length - 2]));
            var changeInSeconds = latestAverageDuration - previousAverageDuration;
            var sign = changeInSeconds >= 0 ? '+' : '-';
            var absChange = Math.abs(changeInSeconds);

            var hours = Math.floor(absChange / 3600);
            var minutes = Math.floor((absChange % 3600) / 60);
            var seconds = Math.floor(absChange % 60);

            return sign + hours.toString().padStart(2, '0') + ':' + minutes.toString().padStart(2, '0') + ':' + seconds.toString().padStart(2, '0');
        }


// Helper function to parse duration string (HH:mm:ss) to seconds
        function parseDurationStringToSeconds(durationString) {
            var durationParts = durationString.split(':');
            var hours = parseInt(durationParts[0]) || 0;
            var minutes = parseInt(durationParts[1]) || 0;
            var seconds = parseInt(durationParts[2]) || 0;
            return hours * 3600 + minutes * 60 + seconds;
        }


// Function to calculate the average duration
        function calculateAverageDuration(data) {
            var totalSeconds = 0;
            var validEntries = 0;

            for (var i = 0; i < data.length; i++) {
                var durationParts = data[i]['average_duration'].split(':');
                if (durationParts.length === 3 && !isNaN(durationParts[0]) && !isNaN(durationParts[1]) && !isNaN(durationParts[2])) {
                    var hoursInSeconds = parseInt(durationParts[0]) * 3600;
                    var minutesInSeconds = parseInt(durationParts[1]) * 60;
                    var seconds = parseInt(durationParts[2]);
                    totalSeconds += hoursInSeconds + minutesInSeconds + seconds;
                    validEntries++;
                }
            }

            if (validEntries > 0) {
                var averageSeconds = totalSeconds / validEntries;

                // Convert averageSeconds back to HH:mm:ss format
                var hours = Math.floor(averageSeconds / 3600);
                var minutes = Math.floor((averageSeconds % 3600) / 60);
                var seconds = Math.floor(averageSeconds % 60);

                return hours.toString().padStart(2, '0') + ':' + minutes.toString().padStart(2, '0') + ':' + seconds.toString().padStart(2, '0');
            } else {
                return 'No valid data available';
            }
        }




    });

</script>

