<?php
$meta = array(
    'us' => array(
        'title' => 'Update Password - Datanito',
        'description' => 'Update your Datanito account password for added security. Stay connected with web design, app development, and SEO solutions from Datanito.',
        'og:title' => 'Update Password - Datanito',
        'og:description' => 'Update your Datanito account password for added security. Stay connected with web design, app development, and SEO solutions from Datanito.',
        'og:image' => asset('images/brand/open_graph_logo.png'),
    ),
    'tr' => array(
        'title' => 'Şifre Güncelleme - Datanito (Türkiye)',
        'description' => 'Datanito hesabınızın şifresini güncelleyerek ek güvenlik sağlayın. Datanito ile web tasarımı, uygulama geliştirme ve SEO çözümleri ile bağlantınızı sürdürün.',
        'og:title' => 'Şifre Güncelleme - Datanito (Türkiye)',
        'og:description' => 'Datanito hesabınızın şifresini güncelleyerek ek güvenlik sağlayın. Datanito ile web tasarımı, uygulama geliştirme ve SEO çözümleri ile bağlantınızı sürdürün.',
        'og:image' => asset('images/brand/open_graph_logo.png'),
    ),
);
$currentMeta = setCountryAndMeta($meta);
include_once includes('head.php');
?>
    <div id="content">
        <section class="bg-gray-50 dark:bg-dark-900 h-full">
            <div class="flex flex-col items-center justify-center px-6 py-8 mx-auto !h-screen h-full lg:py-0">
                <header class="absolute top-[20px]">
                    <a href="<?php echo url(''); ?>" class="flex items-center mb-6 text-2xl font-semibold text-dark-900 dark:text-white">
                        <svg class="w-9 h-9" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="151px" height="150px" viewBox="0 0 639 636" version="1.1">
                            <g id="surface1">
                                <path style=" stroke:none;fill-rule:nonzero;fill-opacity:1;" class="fill-dark-950 dark:fill-white" d="M 543.414062 80.550781 C 563.308594 100.46875 563.308594 132.765625 543.414062 152.683594 L 155.367188 541.199219 C 135.472656 561.121094 103.214844 561.121094 83.316406 541.199219 C 63.421875 521.28125 63.421875 488.984375 83.316406 469.066406 L 471.371094 80.558594 C 491.257812 60.628906 523.515625 60.628906 543.414062 80.550781 Z M 543.414062 80.550781 "/>
                                <path style=" stroke:none;fill-rule:nonzero;fill-opacity:1;" class="fill-dark-950 dark:fill-white" d="M 350.257812 83.671875 C 370.15625 103.589844 370.15625 135.886719 350.257812 155.804688 L 158.246094 348.046875 C 138.347656 367.964844 106.089844 367.964844 86.195312 348.046875 C 66.296875 328.125 66.296875 295.828125 86.195312 275.910156 L 278.207031 83.671875 C 298.097656 63.75 330.363281 63.75 350.257812 83.671875 Z M 350.257812 83.671875 "/>
                                <path style=" stroke:none;fill-rule:nonzero;fill-opacity:1;" class="fill-dark-950 dark:fill-white" d="M 198.839844 42.324219 C 218.734375 62.242188 218.734375 94.539062 198.839844 114.457031 L 116.90625 196.484375 C 97.011719 216.40625 64.753906 216.40625 44.855469 196.484375 C 24.960938 176.566406 24.960938 144.269531 44.855469 124.351562 L 126.78125 42.324219 C 146.679688 22.402344 178.941406 22.402344 198.839844 42.324219 Z M 198.839844 42.324219 "/>
                                <path style=" stroke:none;fill-rule:nonzero;fill-opacity:1;" class="fill-dark-950 dark:fill-white" d="M 549.855469 263.0625 C 569.75 282.984375 569.75 315.277344 549.855469 335.199219 L 337.238281 548.0625 C 317.34375 567.984375 285.085938 567.984375 265.1875 548.0625 C 245.292969 528.140625 245.292969 495.847656 265.1875 475.925781 L 477.804688 263.0625 C 497.699219 243.140625 529.957031 243.140625 549.855469 263.0625 Z M 549.855469 263.0625 "/>
                                <path style=" stroke:none;fill-rule:nonzero;fill-opacity:1;" class="fill-dark-950 dark:fill-white" d="M 578.785156 423.015625 C 598.683594 442.933594 598.683594 475.230469 578.785156 495.148438 L 496.855469 577.171875 C 476.957031 597.089844 444.699219 597.089844 424.804688 577.171875 C 404.90625 557.25 404.90625 524.953125 424.804688 505.035156 L 506.726562 423.015625 C 526.625 403.085938 558.890625 403.085938 578.785156 423.015625 Z M 578.785156 423.015625 "/>
                            </g>
                        </svg>
                    </a>
                </header>
                <div id="step-1" class="w-full bg-white rounded-3xl border border-gray-200 md:mt-0 sm:max-w-md xl:p-0 dark:bg-dark-800 dark:border-dark-700 skeleton">
                    <div class="p-6 space-y-4 md:space-y-6 sm:p-8">
                        <h1 class="text-xl font-bold leading-tight tracking-tight text-dark-900 md:text-2xl dark:text-white text-center">
                            <?php echo $lang['user-update-password-headline'];?>
                        </h1>
                        <p class="text-black dark:text-white text-sm text-center"><?php echo $lang['user-update-password-subheading'];?></p>
                        <form id="auth-update-password" class="my-3" method="post" novalidate>
                            <?php set_csrf(); ?>
                            <input type="hidden" name="token" value="<?php echo $token;?>">
                            <div>
                                <div class="relative mt-4">
                                    <input type="password" id="new-password" name="new-password" class="block px-2.5 pb-2.5 pt-4 w-full text-sm text-dark-900 bg-transparent rounded-xl border-1 border-gray-300 appearance-none dark:text-white dark:border-gray-600 dark:focus:border-blue-500 focus:outline-none focus:ring-0 focus:border-blue-600 peer" placeholder=" " required>
                                    <label for="new-password" class="absolute text-sm text-gray-500 dark:text-gray-400 duration-300 transform -translate-y-4 scale-75 top-2 z-10 origin-[0] bg-white dark:bg-dark-800 px-2 peer-focus:px-2 peer-focus:text-blue-600 peer-focus:dark:text-blue-500 peer-placeholder-shown:scale-100 peer-placeholder-shown:-translate-y-1/2 peer-placeholder-shown:top-1/2 peer-focus:top-2 peer-focus:scale-75 peer-focus:-translate-y-4 left-1"><?php echo $lang['user-update-password-password-label'];?></label>
                                    <div class="input-group-append">
                                    <span class="input-group-text password-toggle-new">
                                         <span class="material-symbols-outlined text-gray-500 dark:text-gray-400">
                                             visibility
                                         </span>
                                    </span>
                                    </div>
                                </div>
                            </div>
                            <div>
                                <div class="relative mt-4">
                                    <input type="password" id="confirm-password" name="new-password" class="block px-2.5 pb-2.5 pt-4 w-full text-sm text-dark-900 bg-transparent rounded-xl border-1 border-gray-300 appearance-none dark:text-white dark:border-gray-600 dark:focus:border-blue-500 focus:outline-none focus:ring-0 focus:border-blue-600 peer" placeholder=" " required>
                                    <label for="confirm-password" class="absolute text-sm text-gray-500 dark:text-gray-400 duration-300 transform -translate-y-4 scale-75 top-2 z-10 origin-[0] bg-white dark:bg-dark-800 px-2 peer-focus:px-2 peer-focus:text-blue-600 peer-focus:dark:text-blue-500 peer-placeholder-shown:scale-100 peer-placeholder-shown:-translate-y-1/2 peer-placeholder-shown:top-1/2 peer-focus:top-2 peer-focus:scale-75 peer-focus:-translate-y-4 left-1"><?php echo $lang['user-update-password-confirm-password-label'];?></label>
                                    <div class="input-group-append">
                                    <span class="input-group-text password-toggle-confirm">
                                         <span class="material-symbols-outlined text-gray-500 dark:text-gray-400">
                                             visibility
                                         </span>
                                    </span>
                                    </div>
                                </div>
                            </div>
                            <p id="error_step1" class="flex items-center mt-2 text-xs text-red-600 dark:text-red-400 hidden"><span class="material-symbols-outlined mx-1 font-medium">info</span><span class="font-medium response-text"></span></p>

                            <div class="input-wrapper group skeleton auth__password_strength my-3">
                                <p class="text-black dark:text-white"><?php echo $lang['user-password-requirement-headline'];?></p>
                                <p class="flex items-center text-sm auth__password_strength_item my-1"><span class="material-symbols-outlined icon text-sm mr-2">radio_button_unchecked</span> <?php echo $lang['user-password-requirement'];?></p>
                            </div>
                            <button type="submit" id="continue-button" class="w-full text-white hover:text-white bg-blue-700 hover:bg-blue-800 focus:ring-4 focus:ring-blue-300 font-medium rounded-2xl px-5 py-2.5 text-center inline-flex items-center justify-center text-[16px] py-[15px] mt-5 flex justify-between animated_btn">
                                <svg aria-hidden="true" role="status" class="inline w-4 h-4 mr-3 text-white animate-spin opacity-0" viewBox="0 0 100 101" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <path d="M100 50.5908C100 78.2051 77.6142 100.591 50 100.591C22.3858 100.591 0 78.2051 0 50.5908C0 22.9766 22.3858 0.59082 50 0.59082C77.6142 0.59082 100 22.9766 100 50.5908ZM9.08144 50.5908C9.08144 73.1895 27.4013 91.5094 50 91.5094C72.5987 91.5094 90.9186 73.1895 90.9186 50.5908C90.9186 27.9921 72.5987 9.67226 50 9.67226C27.4013 9.67226 9.08144 27.9921 9.08144 50.5908Z" fill="#E5E7EB"/>
                                    <path d="M93.9676 39.0409C96.393 38.4038 97.8624 35.9116 97.0079 33.5539C95.2932 28.8227 92.871 24.3692 89.8167 20.348C85.8452 15.1192 80.8826 10.7238 75.2124 7.41289C69.5422 4.10194 63.2754 1.94025 56.7698 1.05124C51.7666 0.367541 46.6976 0.446843 41.7345 1.27873C39.2613 1.69328 37.813 4.19778 38.4501 6.62326C39.0873 9.04874 41.5694 10.4717 44.0505 10.1071C47.8511 9.54855 51.7191 9.52689 55.5402 10.0491C60.8642 10.7766 65.9928 12.5457 70.6331 15.2552C75.2735 17.9648 79.3347 21.5619 82.5849 25.841C84.9175 28.9121 86.7997 32.2913 88.1811 35.8758C89.083 38.2158 91.5421 39.6781 93.9676 39.0409Z" fill="currentColor"/>
                                </svg>
                                <?php echo $lang['user-update-password-cta'];?>
                                <svg aria-hidden="true" class="w-5 h-5 ml-2 -mr-1 animated_btn_arrow" fill="currentColor" viewBox="0 0 20 20" xmlns="http://www.w3.org/2000/svg"><path fill-rule="evenodd" d="M10.293 3.293a1 1 0 011.414 0l6 6a1 1 0 010 1.414l-6 6a1 1 0 01-1.414-1.414L14.586 11H3a1 1 0 110-2h11.586l-4.293-4.293a1 1 0 010-1.414z" clip-rule="evenodd"></path></svg>
                            </button>
                            <div class="text-center mt-7">
                                <p class="text-sm font-light text-gray-500 dark:text-gray-400">
                                    <a href="<?php echo url('/account/login'); ?>" class="font-medium text-primary-600 hover:underline dark:text-primary-500"><?php echo $lang['user-update-password-back-to-login'];?></a>
                                </p>
                            </div>
                        </form>
                    </div>
                </div>
                <div id="step-2" class="w-full bg-white rounded-lg shadow dark:border md:mt-0 sm:max-w-md xl:p-0 dark:bg-dark-800 dark:border-dark-700" style="display: none">
                    <div class="p-6 space-y-4 md:space-y-6 sm:p-8">
                        <span class="block text-center">
                            <span class="material-symbols-outlined py-5 px-6 border-2 border-green-300 text-green-300 rounded-full text-center text-3xl">done</span>
                        </span>
                        <h1 class="text-xl font-bold leading-tight tracking-tight text-dark-900 md:text-2xl dark:text-white text-center">
                            <?php echo $lang['user-update-password-succeed-headline'];?>
                        </h1>
                        <p class="text-black dark:text-white text-center"><?php echo $lang['user-update-password-succeed-subheading'];?></p>
                        <a href="<?php echo url('/account/login'); ?>" class="w-full text-white hover:text-white bg-blue-700 hover:bg-blue-800 focus:ring-4 focus:ring-blue-300 font-medium rounded-2xl px-5 py-2.5 text-center inline-flex items-center justify-center text-[16px] py-[15px] mt-5 flex justify-between animated_btn">
                            <svg aria-hidden="true" role="status" class="inline w-4 h-4 mr-3 text-white animate-spin opacity-0" viewBox="0 0 100 101" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path d="M100 50.5908C100 78.2051 77.6142 100.591 50 100.591C22.3858 100.591 0 78.2051 0 50.5908C0 22.9766 22.3858 0.59082 50 0.59082C77.6142 0.59082 100 22.9766 100 50.5908ZM9.08144 50.5908C9.08144 73.1895 27.4013 91.5094 50 91.5094C72.5987 91.5094 90.9186 73.1895 90.9186 50.5908C90.9186 27.9921 72.5987 9.67226 50 9.67226C27.4013 9.67226 9.08144 27.9921 9.08144 50.5908Z" fill="#E5E7EB"/>
                                <path d="M93.9676 39.0409C96.393 38.4038 97.8624 35.9116 97.0079 33.5539C95.2932 28.8227 92.871 24.3692 89.8167 20.348C85.8452 15.1192 80.8826 10.7238 75.2124 7.41289C69.5422 4.10194 63.2754 1.94025 56.7698 1.05124C51.7666 0.367541 46.6976 0.446843 41.7345 1.27873C39.2613 1.69328 37.813 4.19778 38.4501 6.62326C39.0873 9.04874 41.5694 10.4717 44.0505 10.1071C47.8511 9.54855 51.7191 9.52689 55.5402 10.0491C60.8642 10.7766 65.9928 12.5457 70.6331 15.2552C75.2735 17.9648 79.3347 21.5619 82.5849 25.841C84.9175 28.9121 86.7997 32.2913 88.1811 35.8758C89.083 38.2158 91.5421 39.6781 93.9676 39.0409Z" fill="currentColor"/>
                            </svg>
                            <?php echo $lang['user-update-password-succeed-cta'];?>
                            <svg aria-hidden="true" class="w-5 h-5 ml-2 -mr-1 animated_btn_arrow" fill="currentColor" viewBox="0 0 20 20" xmlns="http://www.w3.org/2000/svg"><path fill-rule="evenodd" d="M10.293 3.293a1 1 0 011.414 0l6 6a1 1 0 010 1.414l-6 6a1 1 0 01-1.414-1.414L14.586 11H3a1 1 0 110-2h11.586l-4.293-4.293a1 1 0 010-1.414z" clip-rule="evenodd"></path></svg>
                        </a>
                    </div>
                </div>
                <footer class="absolute bottom-[20px]">
                    <a href="<?php echo url('/legal/terms'); ?>" target="_blank" class="text-gray-500 dark:text-gray-400"><?php echo $lang['terms-of-use'];?></a> <span class="mx-1 text-gray-500 dark:text-gray-400">|</span> <a href="<?php echo url('/legal/privacy'); ?>" target="_blank" class="text-gray-500 dark:text-gray-400"><?php echo $lang['privacy-policy'];?></a>
                </footer>
            </div>
        </section>
    </div>
<?php
include_once includes('scripts.php');
?>