<?php
$meta = array(
    'us' => array(
        'title' => '404 Not Found - Datanito',
        'description' => 'Oops! The page you are looking for could not be found. Unlock the power of web design, app development, and SEO with Datanito.',
        'og:title' => '404 Not Found - Datanito',
        'og:description' => 'Oops! The page you are looking for could not be found. Unlock the power of web design, app development, and SEO with Datanito.',
        'og:image' => asset('images/brand/open_graph_logo.png'),
    ),
    'tr' => array(
        'title' => '404 Bulunamadı - Datanito (Türkiye)',
        'description' => 'Ups! Aradığınız sayfa bulunamadı. Web tasarımının, uygulama geliştirmenin ve SEO\'nun gücünü Datanito ile keşfedin.',
        'og:title' => '404 Bulunamadı - Datanito',
        'og:description' => 'Ups! Aradığınız sayfa bulunamadı. Web tasarımının, uygulama geliştirmenin ve SEO\'nun gücünü Datanito ile keşfedin.',
        'og:image' => asset('images/brand/open_graph_logo.png'),
    ),
);
$currentMeta = setCountryAndMeta($meta);
include_once includes('layouts/header.php');
?>
    <div id="content" class="container mx-auto lg:mt-5 mt-10">
            <section class="bg-white dark:bg-dark-900 justify-center my-32 sm:my-60">
                <div class="py-8 px-4 mx-auto max-w-screen-xl lg:py-16 lg:px-6">
                    <div class="mx-auto max-w-screen-sm text-center">
                        <p class="mb-4 text-3xl tracking-tight font-bold text-gray-900 md:text-4xl dark:text-white"><?php echo $lang['error-not-found']?></p>
                        <a href="<?php echo url(''); ?>" class="inline-flex text-white hover:text-white bg-blue-600 hover:bg-blue-800 focus:ring-4 focus:outline-none focus:ring-blue-300 font-medium rounded-3xl text-sm px-5 py-2.5 text-center dark:focus:ring-blue-900 my-4"><?php echo $lang['error-not-found-cta']?></a>
                    </div>
                </div>
            </section>
    </div>

<?php
include_once includes('layouts/footer.php');
?>