<div id="bottom-banner" tabindex="-1" class="hidden fixed bottom-0 left-0 z-10 flex justify-between w-full p-2 border-t border-gray-200 bg-white dark:bg-dark-800 !bg-opacity-50 dark:border-gray-600 shadow-lg backdrop-blur">
    <div class="flex items-center justify-between mx-auto space-x-3 sm:space-x-4 max-w-screen-md w-full">
        <div class="inline-flex items-center justify-start">
                    <span class="sm:inline-flex p-1 me-3 bg-primary-200 rounded-full dark:bg-primary-900 w-8 h-8 items-center justify-center hidden">
            <svg class="w-5 h-5 text-primary-900 dark:text-primary-500" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="currentColor" viewBox="0 0 20 20">
                <path d="M18.435 7.546A2.32 2.32 0 0 1 17.7 5.77a3.354 3.354 0 0 0-3.47-3.47 2.322 2.322 0 0 1-1.776-.736 3.357 3.357 0 0 0-4.907 0 2.281 2.281 0 0 1-1.776.736 3.414 3.414 0 0 0-2.489.981 3.372 3.372 0 0 0-.982 2.49 2.319 2.319 0 0 1-.736 1.775 3.36 3.36 0 0 0 0 4.908A2.317 2.317 0 0 1 2.3 14.23a3.356 3.356 0 0 0 3.47 3.47 2.318 2.318 0 0 1 1.777.737 3.36 3.36 0 0 0 4.907 0 2.36 2.36 0 0 1 1.776-.737 3.356 3.356 0 0 0 3.469-3.47 2.319 2.319 0 0 1 .736-1.775 3.359 3.359 0 0 0 0-4.908ZM8.5 5.5a1 1 0 1 1 0 2 1 1 0 0 1 0-2Zm3 9.063a1 1 0 1 1 0-2 1 1 0 0 1 0 2Zm2.207-6.856-6 6a1 1 0 0 1-1.414-1.414l6-6a1 1 0 0 1 1.414 1.414Z"/>
            </svg>
            <span class="sr-only">Discount</span>
        </span>
            <p class="block text-sm font-semibold text-gray-800 dark:text-gray-200">
                <span class="block"><?php echo $lang['web-design-banner-headline']?></span>
                <span class="block font-normal text-gray-600 dark:text-gray-400">
                <?php echo $lang['web-design-banner-subheading']?>
            </span>
            </p>
        </div>

        <?php
        // Get the current URL
        $currentUrl = $_SERVER['REQUEST_URI'];

        // Check if the URL contains 'web-design'
        if (strpos($currentUrl, 'web-design') !== false) {
            // Render the button with the `onclick` attribute
            echo '<a class="group inline-flex items-center gap-x-2 py-2 px-3 bg-primary-500 font-medium text-sm text-neutral-800 rounded-full focus:outline-none cursor-pointer hover:shadow-2xl transition-all duration-300 hover:scale-105" onclick="selectAndScroll()" aria-describedby="tier-standard">'. $lang['web-design-banner-cta'].'</a>';
        } else {
            // Render the default button
            echo '<a href="' . url('/solutions/web-design') . '" class="group inline-flex items-center gap-x-2 py-2 px-3 bg-primary-500 font-medium text-sm text-neutral-800 rounded-full focus:outline-none cursor-pointer hover:shadow-2xl transition-all duration-300 hover:scale-105">'. $lang['web-design-banner-cta'].'</a>';
        }
        ?>
    </div>
    <div class="flex items-center">
        <button data-dismiss-target="#bottom-banner" type="button" class="ml-2 hidden sm:inline-flex justify-center w-7 h-7 items-center text-gray-400 hover:bg-gray-200 hover:text-gray-900 rounded-lg text-sm p-1.5 dark:hover:bg-gray-600 dark:hover:text-white">
            <svg class="w-3 h-3" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 14 14">
                <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="m1 1 6 6m0 0 6 6M7 7l6-6M7 7l-6 6"/>
            </svg>
            <span class="sr-only">Close banner</span>
        </button>
    </div>
</div>


<!-- End Announcement Banner -->
<div id="toast-success" class="notification fixed max-h-14 -translate-x-1/2 left-1/2 z-50 w-full max-w-[8em] mx-auto flex space-x-3">
    <div class="flex items-center justify-center bg-dark-600 dark:bg-dark-600 dark:bg-opacity-75 backdrop-blur bg-opacity-75 rounded-full w-[77%] h-14" role="group">
        <div class="text-sm font-bold text-white dark:text-white p-1 toast-message"></div>
    </div>
    <div class="text-white dark:text-white bg-dark-600 dark:bg-dark-600 dark:hover:bg-dark-500 dark:!bg-opacity-75 backdrop-blur !bg-opacity-75 rounded-full flex items-center justify-center w-14 h-14" role="group">
        <svg class="notification-success flex-shrink-0 w-9 h-9" viewBox="0 0 52 52">
            <circle cx="26" cy="26" r="25" fill="none"/>
            <path fill="none" d="M14.1 27.2l7.1 7.2 16.7-16.8"/>
        </svg>
        <svg class="p-2 flex-shrink-0 w-9 h-9 notification-error hidden" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 14 14">
            <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="m1 1 6 6m0 0 6 6M7 7l6-6M7 7l-6 6"/>
        </svg>
    </div>
</div>
<!-- Main modal -->
<div id="submit-application-modal" tabindex="-1" aria-hidden="true" class="fixed justify-center items-center top-0 left-0 right-0 z-50 hidden w-full overflow-x-hidden overflow-y-auto md:inset-0 h-[100%] max-h-full cssanimation fadeInBottom dark:!bg-dark-800/25">
    <div class="sm:relative sm:w-full sm:max-w-md sm:max-h-full fixed bottom-0 w-full">
        <!-- Modal content -->
        <div class="relative bg-white sm:rounded-3xl shadow dark:bg-dark-700 rounded-t-[2rem]">
            <button type="button" class="close-modal absolute top-3 right-2.5 text-gray-400 bg-transparent hover:bg-gray-200 hover:text-gray-900 rounded-full text-sm w-8 h-8 ml-auto inline-flex justify-center items-center dark:hover:bg-dark-600 dark:hover:text-white" data-modal-hide="submit-application-modal">
                <svg class="w-3 h-3" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 14 14">
                    <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="m1 1 6 6m0 0 6 6M7 7l6-6M7 7l-6 6"/>
                </svg>
                <span class="sr-only">Close modal</span>
            </button>
            <div class="px-6 py-4 sm:py-6 lg:px-8 max-h-[550px] lg:max-h-[100%] overflow-hidden">
                <p class="mb-0.5 text-xl font-bold text-gray-900 dark:text-white"><?php echo $lang['claim-special-deal']; ?></p>
                <span class="mb-1 text-sm font-normal text-dark-800 dark:text-gray-300"><?php echo $lang['limited-spots-available']; ?></span>
                <form class="submit-application space-y-2 lg:space-y-6">
                    <?php set_csrf(); ?>
                    <div class="relative">
                        <input type="text" id="name-input-modal" class="block px-2.5 pb-2.5 pt-4 w-full text-sm text-gray-900 bg-transparent rounded-lg border-1 border-gray-300 appearance-none dark:text-white dark:border-gray-600 dark:focus:border-blue-500 focus:outline-none focus:ring-0 focus:border-blue-600 peer" placeholder=" " required/>
                        <label for="name-input-modal" class="absolute text-sm text-gray-500 dark:text-gray-400 duration-300 transform -translate-y-4 scale-75 top-2 z-10 origin-[0] bg-white dark:bg-dark-700 px-2 peer-focus:px-2 peer-focus:text-blue-600 peer-focus:dark:text-blue-500 peer-placeholder-shown:scale-100 peer-placeholder-shown:-translate-y-1/2 peer-placeholder-shown:top-1/2 peer-focus:top-2 peer-focus:scale-75 peer-focus:-translate-y-4 left-1"><?php echo $lang['full-name']; ?> <span class="text-[12px]">(<?php echo $lang['required']; ?>)</span></label>
                    </div>
                    <div class="relative">
                        <input type="email" id="email-input-modal" class="block px-2.5 pb-2.5 pt-4 w-full text-sm text-gray-900 bg-transparent rounded-lg border-1 border-gray-300 appearance-none dark:text-white dark:border-gray-600 dark:focus:border-blue-500 focus:outline-none focus:ring-0 focus:border-blue-600 peer" placeholder=" " required/>
                        <label for="email-input-modal" class="absolute text-sm text-gray-500 dark:text-gray-400 duration-300 transform -translate-y-4 scale-75 top-2 z-10 origin-[0] bg-white dark:bg-dark-700 px-2 peer-focus:px-2 peer-focus:text-blue-600 peer-focus:dark:text-blue-500 peer-placeholder-shown:scale-100 peer-placeholder-shown:-translate-y-1/2 peer-placeholder-shown:top-1/2 peer-focus:top-2 peer-focus:scale-75 peer-focus:-translate-y-4 left-1"><?php echo $lang['email']; ?> <span class="text-[12px]">(<?php echo $lang['required']; ?>)</span></label>
                    </div>
                    <div class="relative">
                        <input type="text" id="phone-number-input-modal" class="block px-2.5 pb-2.5 pt-4 w-full text-sm text-gray-900 bg-transparent rounded-lg border-1 border-gray-300 appearance-none dark:text-white dark:border-gray-600 dark:focus:border-blue-500 focus:outline-none focus:ring-0 focus:border-blue-600 peer" placeholder=" " required/>
                        <label for="phone-number-input-modal" class="absolute text-sm text-gray-500 dark:text-gray-400 duration-300 transform -translate-y-4 scale-75 top-2 z-10 origin-[0] bg-white dark:bg-dark-700 px-2 peer-focus:px-2 peer-focus:text-blue-600 peer-focus:dark:text-blue-500 peer-placeholder-shown:scale-100 peer-placeholder-shown:-translate-y-1/2 peer-placeholder-shown:top-1/2 peer-focus:top-2 peer-focus:scale-75 peer-focus:-translate-y-4 left-1"><?php echo $lang['phone-number']; ?> <span class="text-[12px]">(<?php echo $lang['required']; ?>)</span></label>
                    </div>
                    <div class="relative">
                        <select id="submit-reasons-modal" class="block w-full p-3 text-sm text-gray-500 border border-gray-300 rounded-lg bg-white focus:ring-blue-500 focus:border-blue-500 dark:bg-dark-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-gray-400 dark:focus:ring-blue-500 dark:focus:border-blue-500" required>
                            <option selected><?php echo $lang['choose-reason']; ?> <span class="text-[12px]">(<?php echo $lang['required']; ?>)</span></option>
                            <option value="web-design"><?php echo $lang['web-design']; ?></option>
                            <option value="seo"><?php echo $lang['seo']; ?></option>
                            <option value="app-development"><?php echo $lang['app-development']; ?></option>
                            <option value="advertising"><?php echo $lang['advertising']; ?></option>
                            <option value="digital-marketing"><?php echo $lang['digital-marketing']; ?></option>
                            <option value="contact"><?php echo $lang['contact']; ?></option>
                            <option value="other"><?php echo $lang['other']; ?></option>
                        </select>
                    </div>
                    <div class="relative">
                        <label for="message-input-modal" class="absolute text-sm text-gray-500 dark:text-gray-400 duration-300 transform -translate-y-4 scale-75 top-2 z-10 origin-[0] bg-white dark:bg-dark-700 px-2 peer-focus:px-2 peer-focus:text-blue-600 peer-focus:dark:text-blue-500 peer-placeholder-shown:scale-100 peer-placeholder-shown:-translate-y-1/2 peer-placeholder-shown:top-1/2 peer-focus:top-2 peer-focus:scale-75 peer-focus:-translate-y-4 left-1"><?php echo $lang['your-message']; ?></label>
                        <textarea id="message-input-modal" rows="3" class="block px-2.5 pb-2.5 pt-4 w-full text-sm text-gray-900 bg-transparent rounded-lg border-1 border-gray-300 appearance-none dark:text-white dark:border-gray-600 dark:focus:border-blue-500 focus:outline-none focus:ring-0 focus:border-blue-600 peer resize-none" placeholder=" "></textarea>
                    </div>
                    <div class="flex items-center mb-4">
                        <input id="promotional-offers-modal" type="checkbox" value="" class="w-4 h-4 text-blue-600 bg-gray-100 border-gray-300 rounded focus:ring-blue-500 dark:focus:ring-blue-600 dark:ring-offset-gray-800 dark:focus:ring-offset-gray-800 focus:ring-2 dark:bg-dark-800 dark:border-gray-600">
                        <label for="promotional-offers-modal" class="ml-2 text-sm font-medium text-gray-900 dark:text-gray-300"><?php echo $lang['promotional-offers']; ?></label>
                    </div>
                    <div class="relative hidden">
                        <input type="text" id="honeypot" name="honeypot" value="">
                    </div>
                    <div class="flex justify-center sm:justify-start">
                        <button id="submit-form-btn" type="submit" class="flex appearance-none inline-flex hover:shadow-2xl transition-all duration-300 hover:scale-105 items-center group space-x-2.5 bg-black dark:bg-blue-600 text-white py-3 px-5 rounded-full cursor-pointer"><?php echo $lang['apply-now']; ?></button>
                    </div>
                    <p class="text-sm !mt-2 text-gray-500 dark:text-gray-400"><?php echo $lang['form-privacy']; ?></p>
                </form>
            </div>

        </div>
    </div>
</div>
<div id="add-card-modal" tabindex="-1" aria-hidden="true" class="paymentModal fixed top-0 left-0 right-0 z-50 hidden w-full overflow-x-hidden overflow-y-auto md:inset-0 h-[100%] max-h-full justify-center items-center cssanimation fadeInBottom dark:!bg-dark-800/25">
    <div class="sm:relative sm:w-full sm:max-w-md sm:max-h-full fixed bottom-0 w-full">
        <!-- Modal content -->
        <div class="relative bg-white sm:rounded-3xl shadow dark:bg-dark-700 rounded-t-[2rem]">
            <button type="button" class="close-modal absolute top-3 right-2.5 text-gray-400 bg-transparent hover:bg-gray-200 hover:text-gray-900 rounded-full text-sm w-8 h-8 ml-auto inline-flex justify-center items-center dark:hover:bg-dark-600 dark:hover:text-white" data-modal-hide="add-card-modal">
                <svg class="w-3 h-3" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 14 14">
                    <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="m1 1 6 6m0 0 6 6M7 7l6-6M7 7l-6 6"/>
                </svg>
                <span class="sr-only">Close modal</span>
            </button>
            <div class="px-6 py-4 sm:py-6 lg:px-8 max-h-[550px] lg:max-h-[100%] overflow-hidden">
                <iframe id="paymentIframe" style="width: 100%; height: 400px; border: none;"></iframe>
            </div>
        </div>
    </div>
</div>

<!-- Main modal -->
<div id="region-modal" tabindex="-1" aria-hidden="true" class="fixed top-0 left-0 right-0 z-50 hidden w-full overflow-x-hidden overflow-y-auto md:inset-0 h-[100%] max-h-full cssanimation fadeInBottom dark:!bg-dark-800/25">
    <div class="sm:relative sm:w-full sm:max-w-md sm:max-h-full fixed bottom-0 w-full">
        <!-- Modal content -->
        <div class="relative bg-white sm:rounded-3xl shadow dark:bg-dark-700 rounded-t-[2rem]">
            <button type="button" class="absolute top-3 right-2.5 text-gray-400 bg-transparent hover:bg-gray-200 hover:text-gray-900 rounded-full text-sm w-8 h-8 ml-auto inline-flex justify-center items-center dark:hover:bg-dark-600 dark:hover:text-white" data-modal-hide="region-modal">
                <svg class="w-3 h-3" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 14 14">
                    <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="m1 1 6 6m0 0 6 6M7 7l6-6M7 7l-6 6"/>
                </svg>
                <span class="sr-only">Close modal</span>
            </button>
            <!-- Modal header -->
            <div class="px-6 py-4 rounded-t sm:border-b dark:border-dark-600">
                <p class="text-base font-semibold text-gray-900 lg:text-xl dark:text-white">
                    <?php echo $lang['country-and-currency'] ?>
                </p>
            </div>
            <!-- Modal body -->
            <div class="p-6">
                <p class="text-sm font-normal text-gray-500 dark:text-gray-400"><?php echo $lang['select-country-and-currency'] ?></p>
                <form method="POST" class="settings-form">

                    <div class="flex flex-col">
                        <label for="country" class="text-gray-900 dark:text-white font-medium mt-5 mb-2"><?php echo $lang['country-or-region'] ?></label>
                        <select id="country" name="country" class="block w-full px-4 py-2 my-1 text-base text-gray-900 border border-gray-300 rounded-xl bg-gray-50 focus:ring-blue-500 focus:border-blue-500 dark:bg-dark-800 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500">
                            <option value="us" <?php if ($_SESSION["country"] === 'us') echo 'selected'; ?>>United States - English</option>
                            <option value="tr" <?php if ($_SESSION["country"] === 'tr') echo 'selected'; ?>>Türkiye - Türkçe</option>
                        </select>
                    </div>


                    <div class="flex flex-col">
                        <label for="currency" class="text-gray-900 dark:text-white font-medium my-2"><?php echo $lang['choose-currency'] ?></label>
                        <select id="currency" name="currency" class="block w-full px-4 py-2 my-1 text-base text-gray-900 border border-gray-300 rounded-xl bg-gray-50 focus:ring-blue-500 focus:border-blue-500 dark:bg-dark-800 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500">
                            <option value="usd" <?php if ($_SESSION["currency"] === 'USD') echo 'selected'; ?>>USD $</option>
                            <option value="eur" <?php if ($_SESSION["currency"] === 'EUR') echo 'selected'; ?>>EUR €</option>
                            <option value="try" <?php if ($_SESSION["currency"] === 'TRY') echo 'selected'; ?>>TRY TL</option>
                            <option value="gbp" <?php if ($_SESSION["currency"] === 'GBP') echo 'selected'; ?>>GBP £</option>
                        </select>
                    </div>
                    <div class="flex flex-col mt-4 items-end">
                        <button type="button"  class="save-settings text-white bg-dark-700 hover:bg-dark-800 focus:ring-4 focus:outline-none focus:ring-dark-300 font-medium rounded-3xl text-sm px-5 py-2.5 text-center dark:bg-dark-500 dark:hover:bg-dark-600 dark:focus:ring-dark-800 mt-4"><?php echo $lang['setting-modal-save'] ?></button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>


<div id="chat-circle" class="dino-ai-assistant-btn -rotate-[5deg] group flex items-center justify-center overflow-hidden fixed !w-16 !h-16 z-10 bg-primary-500 font-medium text-sm rounded-full focus:outline-none cursor-pointer hover:shadow-2xl transition-all duration-300 hover:scale-105 bottom-24 right-5 sm:bottom-8 sm:right-8">
    <svg class="w-8 h-8 text-neutral-800" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" width="24" height="24" fill="none" viewBox="0 0 24 24">
        <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 17h6l3 3v-3h2V9h-2M4 4h11v8H9l-3 3v-3H4V4Z"/>
    </svg>
</div>


<div class="chat-box bg-gray-200 dark:bg-dark-700 sm:!bg-opacity-75 z-40 sm:z-10 backdrop-blur fixed hidden sm:right-5 sm:bottom-5 sm:w-[24rem] sm:max-w-[24rem] sm:h-[38rem] sm:max-h-[38rem] 2xl:w-[25rem] 2xl:max-w-[25rem] 2xl:h-[40rem] 2xl:max-h-[40rem] rounded-2xl w-full max-w-full right-0 bottom-0 h-full">
    <div class="bg-gray-100 border-gray-200 dark:bg-dark-600 !bg-opacity-75 w-full z-30 backdrop-blur fixed flex items-center justify-between h-12 px-3 rounded-xl">
        <span class="flex items-center">
            <span class="text-gray-900 dark:text-gray-300 ml-2 font-medium">
                <span class="block text-lg font-bold"><?php echo $lang['account-dino-generating'] ?> <span class="text-[10px]"><?php echo $lang['ai-assistant'] ?></span></span>
<!--                <span class="block text-[10px]">--><?php //echo $lang['by-datanito'] ?><!--</span>-->
            </span>
        </span>
        <button type="button" class="chat-box-toggle flex items-center p-2 text-gray-500 rounded-full hover:bg-gray-200 dark:text-gray-400 dark:hover:text-white dark:hover:bg-dark-700 focus:ring-4 focus:ring-gray-300 dark:focus:ring-gray-600">
            <svg class="w-5 h-5 text-gray-500 dark:text-gray-400" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24">
                <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18 18 6m0 12L6 6"/>
            </svg>
        </button>
    </div>
    <div class="chat-box-body h-full rounded-2xl">
        <div class="chat-box-overlay"></div>
        <div class="chat-logs pt-14 pb-24 h-full overflow-auto">

        </div>

    </div>
    <div class="absolute z-10 bottom-0 w-full flex items-center justify-center bg-gradient-to-t from-primary-500/10 via-transparent md:rounded-2xl">
        <div class="w-full text-center">
            <div class="w-full flex justify-center items-center">
                <div class="relative w-[90%] justify-center">
                    <form id="chat-form" autocomplete="off">
                    <input id="chat-input" class="block w-full p-4 pl-3 pr-12 text-sm text-gray-900 border border-gray-300 rounded-full bg-white dark:bg-dark-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white focus:outline-none overflow-hidden" placeholder="<?php echo $lang['dino-assistant-placeholder']?>" required />
                    <button type="submit" id="chat-submit" data-tooltip-target="tooltip-assistant-send-button" class="btn-send-message text-white absolute right-2.5 bottom-2 flex appearance-none inline-flex hover:shadow-2xl transition-all duration-300 px-2 py-2 items-center group bg-black dark:bg-blue-600 text-white rounded-full cursor-pointer">
                        <svg class="w-6 h-6" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" width="24" height="24" fill="none" viewBox="0 0 24 24"> <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6v13m0-13 4 4m-4-4-4 4"/> </svg>
                        <span class="sr-only">Send message</span>
                    </button>
                    </form>
                </div>
            </div>
            <div id="tooltip-assistant-send-button" role="tooltip" class="absolute z-10 invisible inline-block px-3 py-2 text-sm font-medium text-white transition-opacity duration-300 bg-gray-900 rounded-lg shadow-sm opacity-0 tooltip dark:bg-dark-500">
                <?php echo $lang['dino-assistant-send-message']?>
                <div class="tooltip-arrow" data-popper-arrow></div>
            </div>
            <p class="text-xs font-normal text-gray-600 dark:text-gray-300 my-2"><?php echo $lang['dino-assistant-footer']?></p>
        </div>
    </div>
</div>
<!-- JavaScript -->
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.7.0/jquery.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/animejs/3.2.1/anime.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/flowbite/1.6.6/flowbite.min.js"></script>
<!--<script src="https://cdn.jsdelivr.net/npm/apexcharts"></script>-->
<script src="<?php echo asset('js/main.min.js'); ?>"></script>
<script>
    $(document).ready(function() {
        // Add a click event handler for all navigation buttons
        $('.nav-button').on('click', function() {
            // Remove the 'visible' class to hide the navigation bar
            $('#navigateBar').removeClass('visible');

            // Get the target section's ID based on the clicked button
            var targetSectionId = $(this).attr('id').replace('Button', ''); // Remove 'Button' from the ID

            // Scroll to the target section
            $('html, body').animate({
                scrollTop: $('#' + targetSectionId).offset().top - 50
            }, 500);
        });

        // Add a scroll event listener
        $(window).scroll(function() {
            var scrollPosition = $(this).scrollTop();

            // Iterate over each section to determine the active section
            $('section').each(function() {
                var sectionId = $(this).attr('id');
                var sectionTop = $(this).offset().top;
                var sectionBottom = sectionTop + $(this).outerHeight();

// Check if the scroll position is within the current section
                if (scrollPosition >= sectionTop - 50 && scrollPosition < sectionBottom) {
                    // Update the active button in the navigation bar
                    $('.nav-button').removeClass('navigation_selected bg-dark-950 dark:bg-dark-950');
                    $('#' + sectionId + 'Button').addClass('navigation_selected bg-dark-950 dark:bg-dark-950');

                    // Remove class from the popup button when within a section
                    $('.action-button').removeClass('text-blue-600 dark:text-blue-500');
                } else {
                    // Scroll position doesn't cover any section
                    // Add class to the popup button if no nav-button is selected
                    if ($('.nav-button.navigation_selected').length === 0) {
                        $('.action-button').addClass('text-blue-600 dark:text-blue-500');
                    } else {
                        // Remove class from the popup button if any nav-button is selected
                        $('.action-button').removeClass('text-blue-600 dark:text-blue-500');
                    }
                }


            });

            // Get the offset of the 'navigateBarActivate' element
            var activateOffset = $('#navigateBarActivate').offset().top;

            // Check if the scroll position is greater than activateOffset - 150
            if (scrollPosition > activateOffset - 150) {
                // Add the 'visible' class to trigger the opening animation
                $('#navigateBar').addClass('visible').removeClass('invisible');
            } else {
                // Remove the 'visible' class if the scroll position is less than activateOffset - 150
                $('#navigateBar').removeClass('visible');
            }
        });
    });

</script>
<!--<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-nice-select/1.1.0/js/jquery.nice-select.min.js" integrity="sha512-NqYds8su6jivy1/WLoW8x1tZMRD7/1ZfhWG/jcRQLOzV1k1rIODCpMgoBnar5QXshKJGV7vi0LXLNXPoFsM5Zg==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>-->

<?php
$domain = '';
if ($domain){
    ?>
    <script>
        $(document).ready(function() {
            $('#checkButton').click();
        });
    </script>
    <?php
}
?>

<script>
    <?php if (isset($languageJS)): ?>
    const translations = <?php echo json_encode($languageJS); ?>;
    // Store as a JSON string
    sessionStorage.setItem('translations', JSON.stringify(translations));
    console.log('Translations stored:', translations);
    <?php endif; ?>

    // Setting session storage for user-specific data
    <?php if (isset($this_userAvatar)): ?>
    sessionStorage.setItem('profilePic', '<?php echo addslashes($this_userAvatar); ?>');
    <?php endif; ?>

    <?php if (isset($this_name)): ?>
    sessionStorage.setItem('userName', '<?php echo addslashes($this_name); ?>');
    <?php endif; ?>

    <?php if (isset($this_email)): ?>
    sessionStorage.setItem('userEmail', '<?php echo addslashes($this_email); ?>');
    <?php endif; ?>

    <?php if (isset($this_phoneNumber)): ?>
    sessionStorage.setItem('userPhoneNumber', '<?php echo addslashes($this_phoneNumber); ?>');
    <?php endif; ?>

    <?php if (isset($_SESSION["country"])): ?>
    sessionStorage.setItem('userRegion', '<?php echo addslashes($_SESSION["country"]); ?>');
    <?php endif; ?>
    <?php
    // PHP values to be passed to JavaScript
    $phpData = array(
        'connect-domain-cta' => 'Add Domain',
        'nonce' => 'abc123'
    );
    ?>
    var phpData = <?php echo json_encode($phpData); ?>;
    // jQuery(document).ready(function() {
    //     jQuery('select3').niceSelect();
    //     $(".nice-select .list").addClass("bg-gray-50 dark:bg-gray-500");
    //     $(".nice-select .list .option").addClass("!bg-gray-100 dark:!bg-gray-500 hover:!bg-primary-400 dark:hover:!bg-primary-400 focus:!bg-gray-100 dark:focus:!bg-gray-600");
    // });
    var themeToggleDarkIcon = document.getElementById('theme-toggle-dark-icon');
    var themeToggleLightIcon = document.getElementById('theme-toggle-light-icon');

    // Change the icons inside the button based on previous settings
    if (localStorage.getItem('color-theme') === 'dark' || (!('color-theme' in localStorage) && window.matchMedia('(prefers-color-scheme: dark)').matches)) {
        themeToggleLightIcon.classList.remove('hidden');
    } else {
        themeToggleDarkIcon.classList.remove('hidden');
    }

    var themeToggleBtn = document.getElementById('theme-toggle');

    themeToggleBtn.addEventListener('click', function() {

        // toggle icons inside button
        themeToggleDarkIcon.classList.toggle('hidden');
        themeToggleLightIcon.classList.toggle('hidden');

        // if set via local storage previously
        if (localStorage.getItem('color-theme')) {
            if (localStorage.getItem('color-theme') === 'light') {
                document.documentElement.classList.add('dark');
                localStorage.setItem('color-theme', 'dark');
            } else {
                document.documentElement.classList.remove('dark');
                localStorage.setItem('color-theme', 'light');
            }

            // if NOT set via local storage previously
        } else {
            if (document.documentElement.classList.contains('dark')) {
                document.documentElement.classList.remove('dark');
                localStorage.setItem('color-theme', 'light');
            } else {
                document.documentElement.classList.add('dark');
                localStorage.setItem('color-theme', 'dark');
            }
        }

    });
</script>
<script>
    function selectAndScroll(packageKey) {
        document.getElementById('selected-package').value = packageKey;
        scrollToSubmitFormArea();
    }
    function scrollToSubmitFormArea() {
        const formArea = document.getElementById('apply-form');
        const offset = -100; // Scroll 100px above the target
        formArea.classList.add('border-pulsing'); // Apply the animation class

        // Calculate the top position of the target element with the offset
        const topPosition = formArea.getBoundingClientRect().top + window.pageYOffset + offset;

        window.scrollTo({ top: topPosition, behavior: 'smooth' });

        // Remove the animation class after the animation completes
        setTimeout(() => {
            formArea.classList.remove('border-pulsing');
        }, 2000); // Adjust the timeout to match the animation duration
    }
    document.addEventListener('DOMContentLoaded', () => {
        const scrollLinks = document.querySelectorAll('.scroll-link');

        scrollLinks.forEach(link => {
            link.addEventListener('click', (e) => {
                e.preventDefault();

                const targetSectionId = link.getAttribute('data-scroll-target');
                const targetSection = document.getElementById(targetSectionId);

                if (targetSection) {
                    scrollToArea(targetSection);
                }
            });
        });
    });
    function scrollToArea(targetElement) {
        const offset = -50;
        const topPosition = targetElement.getBoundingClientRect().top + window.pageYOffset + offset;
        window.scrollTo({ top: topPosition, behavior: 'smooth' });
    }


</script>

<script>

    $(function(){

        var cards = [{
            nome: "mastercard",
            colore: "#0061A8",
            src: "<?php echo asset('images/content/logos/mastercard.png')?>"
        }, {
            nome: "visa",
            colore: "#E2CB38",
            src: "<?php echo asset('images/content/logos/visa.png')?>"
        }, {
            nome: "dinersclub",
            colore: "#888",
            src: "http://www.worldsultimatetravels.com/wp-content/uploads/2016/07/Diners-Club-Logo-1920x512.png"
        }, {
            nome: "americanExpress",
            colore: "#108168",
            src: "https://upload.wikimedia.org/wikipedia/commons/thumb/3/30/American_Express_logo.svg/600px-American_Express_logo.svg.png"
        }, {
            nome: "discover",
            colore: "#86B8CF",
            src: "https://lendedu.com/wp-content/uploads/2016/03/discover-it-for-students-credit-card.jpg"
        }, {
            nome: "dankort",
            colore: "#0061A8",
            src: "https://upload.wikimedia.org/wikipedia/commons/5/51/Dankort_logo.png"
        },{
            nome: "troy",
            colore: "#E2CB38",
            src: "<?php echo asset('images/content/logos/troy.png')?>"
        },];

        var month = 0;
        var html = document.getElementsByTagName('html')[0];
        var number = "";

        var selected_card = -1;

        $(document).click(function(e){
            if(!$(e.target).is(".ccv") || !$(e.target).closest(".ccv").length){
                $(".bank-card").css("transform", "rotatey(0deg)");
                $(".seccode").css("color", "var(--text-color)");
            }
            if(!$(e.target).is(".expire") || !$(e.target).closest(".expire").length){
                $(".date_value").css("color", "var(--text-color)");
            }
            if(!$(e.target).is(".number") || !$(e.target).closest(".number").length){
                $(".card_number").css("color", "var(--text-color)");
            }
            if(!$(e.target).is(".inputname") || !$(e.target).closest(".inputname").length){
                $(".fullname").css("color", "var(--text-color)");
            }
        });


        //Card number input
        $(".number").keyup(function(event){
            $(".card_number").text($(this).val());
            number = $(this).val();

            if(parseInt(number.substring(0, 2)) > 50 && parseInt(number.substring(0, 2)) < 56){
                selected_card = 0;
            }else if(parseInt(number.substring(0, 1)) == 4){
                selected_card = 1;
            }else if(parseInt(number.substring(0, 2)) == 36 || parseInt(number.substring(0, 2)) == 38 || parseInt(number.substring(0, 2)) == 39){
                selected_card = 2;
            }else if(parseInt(number.substring(0, 2)) == 34 || parseInt(number.substring(0, 2)) == 37){
                selected_card = 3;
            }else if(parseInt(number.substring(0, 2)) == 65){
                selected_card = 4;
            }else if(parseInt(number.substring(0, 4)) == 5019){
                selected_card = 5;
            }else if(parseInt(number.substring(0, 2)) == 97){
                selected_card = 6;
            }else{
                selected_card = -1;
            }

            if(selected_card != -1){
                html.setAttribute("style", "--card-color: " + cards[selected_card].colore);
                $(".bankid").attr("src", cards[selected_card].src).show();
            }else{
                html.setAttribute("style", "--card-color: #cecece");
                $(".bankid").attr("src", "").hide();
            }

            if($(".card_number").text().length === 0){
                $(".card_number").html("0000 0000 0000 0000");
            }

        }).focus(function(){
            $(".card_number").css("color", "white");
        }).on("keydown input", function(){

            $(".card_number").text($(this).val());

            if(event.key >= 0 && event.key <= 9){
                if($(this).val().length === 4 || $(this).val().length === 9 || $(this).val().length === 14){
                    $(this).val($(this).val() +  " ");
                }
            }
        })

        //Name Input
        $(".inputname").keyup(function(){
            $(".fullname").text($(this).val());
            if($(".inputname").val().length === 0){
                $(".fullname").text("FULL NAME");
            }
            return event.charCode;
        }).focus(function(){
            $(".fullname").css("color", "white");
        });

        //Security code Input
        $(".ccv").focus(function(){
            $(".bank-card").css("transform", "rotatey(180deg)");
            $(".seccode").css("color", "white");
        }).keyup(function(){
            $(".seccode").text($(this).val());
            if($(this).val().length === 0){
                $(".seccode").html("000");
            }
        }).focusout(function() {
            $(".bank-card").css("transform", "rotatey(0deg)");
            $(".seccode").css("color", "var(--text-color)");
        });


        //Date expire input
        $(".expire").keypress(function(event){
            if(event.charCode >= 48 && event.charCode <= 57){
                if($(this).val().length === 1){
                    $(this).val($(this).val() + event.key + " / ");
                }else if($(this).val().length === 0){
                    if(event.key == 1 || event.key == 0){
                        month = event.key;
                        return event.charCode;
                    }else{
                        $(this).val(0 + event.key + " / ");
                    }
                }else if($(this).val().length > 2 && $(this).val().length < 9){
                    return event.charCode;
                }
            }
            return false;
        }).keyup(function(event){
            $(".date_value").html($(this).val());
            if(event.keyCode == 8 && $(".expire").val().length == 4){
                $(this).val(month);
            }

            if($(this).val().length === 0){
                $(".date_value").text("MM / YYYY");
            }
        }).keydown(function(){
            $(".date_value").html($(this).val());
        }).focus(function(){
            $(".date_value").css("color", "white");
        });
    });
    let index = 0,
        interval = 1000;

    const rand = (min, max) =>
        Math.floor(Math.random() * (max - min + 1)) + min;

    const animate = star => {
        star.style.setProperty("--star-left", `${rand(-10, 100)}%`);
        star.style.setProperty("--star-top", `${rand(-40, 80)}%`);

        star.style.animation = "none";
        star.offsetHeight;
        star.style.animation = "";
    }

    for(const star of document.getElementsByClassName("magic-star")) {
        setTimeout(() => {
            animate(star);

            setInterval(() => animate(star), 1000);
        }, index++ * (interval / 3))
    }

    /* -- ↓↓↓ If you want the sparkle effect to only occur on hover, replace lines 16 and on with this code ↓↓↓ -- */

    // let timeouts = [],
    //     intervals = [];

    // const magic = document.querySelector(".magic");

    // magic.onmouseenter = () => {
    //   let index = 1;

    //   for(const star of document.getElementsByClassName("magic-star")) {
    //     timeouts.push(setTimeout(() => {
    //       animate(star);

    //       intervals.push(setInterval(() => animate(star), 1000));
    //     }, index++ * 300));
    //   };
    // }

    // magic.onmouseleave = onMouseLeave = () => {
    //   for(const t of timeouts) clearTimeout(t);
    //   for(const i of intervals) clearInterval(i);

    //   timeouts = [];
    //   intervals = [];
    // }
</script>
</body>
</html>
