<?php
include_once includes('head.php');




?>

<header class="bg-gray-100 dark:bg-dark-700 !bg-opacity-75 dark:!bg-opacity-50 !w-full z-30 backdrop-blur header fixed">
    <div id="localization-banner" tabindex="-1" class="w-full p-3 bg-dark-700/90 hidden">
        <div class="mx-auto w-full max-w-screen-2xl space-x-4 flex items-center justify-between">
            <div class="flex items-center justify-start">
                <p class="text-gray-100 font-light text-xs">Ülke veya bölge seçerek özel içeriklere erişin.</p>
            </div>
            <div class="flex items-center justify-end space-x-3">
                <button id="localizationDropdown" data-dropdown-toggle="dropdown" class="hidden sm:flex items-center text-white focus:ring-4 focus:outline-none font-medium rounded-xl text-sm px-5 py-2.5 text-center inline-flex items-center bg-dark-500 dark:bg-dark-600 focus:ring-blue-300 dark:focus:ring-blue-800" type="button">
                    <svg class="w-6 h-6 text-white" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" width="24" height="24" fill="none" viewBox="0 0 24 24">
                        <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 11.917 9.724 16.5 19 7.5"/>
                    </svg>
                    <span class="mr-4 md:mr-12 lg:mr-20 ml-2 md:ml-4">Türkiye</span>
                    <svg class="w-2.5 h-2.5 ms-3" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 10 6">
                        <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="m1 1 4 4 4-4"/>
                    </svg>
                </button>
                <!-- Dropdown menu -->
                <div id="dropdown" class="z-10 hidden divide-y divide-gray-100 rounded-xl w-56 !bg-opacity-75 backdrop-blur bg-dark-600">
                    <ul class="py-2 text-sm text-gray-200" aria-labelledby="localizationDropdown">
                        <li>
                            <button type="button" data-modal-target="region-modal" data-modal-toggle="region-modal" class="block px-4 py-2 hover:bg-dark-600 hover:text-white">Başka bir ülke veya bölge</button>
                        </li>
                    </ul>
                </div>
                <form method="POST" class="suggest-settings-form">
                    <select id="country" name="country" class="hidden">
                        <option value="tr" selected></option>
                    </select>
                    <select id="currency" name="currency" class="hidden">
                        <option value="try" selected></option>
                    </select>
                    <button type="button" class="suggest-save-settings text-gray-900 bg-gray-50 focus:outline-none hover:bg-white focus:ring-0 font-medium rounded-xl text-sm px-5 py-2.5 dark:bg-gray-50 dark:text-dark-700 dark:hover:bg-white">Devam</button>
                </form>
                <button data-dismiss-target="#localization-banner" type="button" class="flex-shrink-0 inline-flex justify-center w-7 h-7 items-center text-gray-400 hover:bg-gray-200 hover:text-gray-900 rounded-full text-sm p-1.5 dark:hover:bg-dark-600 dark:hover:text-white">
                    <svg class="w-3 h-3" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 14 14">
                        <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="m1 1 6 6m0 0 6 6M7 7l6-6M7 7l-6 6"/>
                    </svg>
                    <span class="sr-only">Close banner</span>
                </button>
            </div>
        </div>
    </div>
    <div class="px-2 md:hidden">
        <!-- Content for mobile menu -->
        <nav class="mx-auto w-full max-w-screen-xl py-2">
            <div class="flex flex-wrap justify-between mx-1 items-center">
                <div class="flex items-center lg:order-2">
                    <a href="<?php echo url(''); ?>" class="flex items-center">
                        <svg class="w-7 h-7" xmlns="http://www.w3.org/2000/svg"
                             xmlns:xlink="http://www.w3.org/1999/xlink" width="151px" height="150px"
                             viewBox="0 0 639 636">
                            <g id="surface1">
                                <path style=" stroke:none;fill-rule:nonzero;fill-opacity:1;" class="fill-dark-950 dark:fill-gray-300" d="M 543.414062 80.550781 C 563.308594 100.46875 563.308594 132.765625 543.414062 152.683594 L 155.367188 541.199219 C 135.472656 561.121094 103.214844 561.121094 83.316406 541.199219 C 63.421875 521.28125 63.421875 488.984375 83.316406 469.066406 L 471.371094 80.558594 C 491.257812 60.628906 523.515625 60.628906 543.414062 80.550781 Z M 543.414062 80.550781 "/>
                                <path style=" stroke:none;fill-rule:nonzero;fill-opacity:1;" class="fill-dark-950 dark:fill-gray-300" d="M 350.257812 83.671875 C 370.15625 103.589844 370.15625 135.886719 350.257812 155.804688 L 158.246094 348.046875 C 138.347656 367.964844 106.089844 367.964844 86.195312 348.046875 C 66.296875 328.125 66.296875 295.828125 86.195312 275.910156 L 278.207031 83.671875 C 298.097656 63.75 330.363281 63.75 350.257812 83.671875 Z M 350.257812 83.671875 "/>
                                <path style=" stroke:none;fill-rule:nonzero;fill-opacity:1;" class="fill-dark-950 dark:fill-gray-300" d="M 198.839844 42.324219 C 218.734375 62.242188 218.734375 94.539062 198.839844 114.457031 L 116.90625 196.484375 C 97.011719 216.40625 64.753906 216.40625 44.855469 196.484375 C 24.960938 176.566406 24.960938 144.269531 44.855469 124.351562 L 126.78125 42.324219 C 146.679688 22.402344 178.941406 22.402344 198.839844 42.324219 Z M 198.839844 42.324219 "/>
                                <path style=" stroke:none;fill-rule:nonzero;fill-opacity:1;" class="fill-dark-950 dark:fill-gray-300" d="M 549.855469 263.0625 C 569.75 282.984375 569.75 315.277344 549.855469 335.199219 L 337.238281 548.0625 C 317.34375 567.984375 285.085938 567.984375 265.1875 548.0625 C 245.292969 528.140625 245.292969 495.847656 265.1875 475.925781 L 477.804688 263.0625 C 497.699219 243.140625 529.957031 243.140625 549.855469 263.0625 Z M 549.855469 263.0625 "/>
                                <path style=" stroke:none;fill-rule:nonzero;fill-opacity:1;" class="fill-dark-950 dark:fill-gray-300" d="M 578.785156 423.015625 C 598.683594 442.933594 598.683594 475.230469 578.785156 495.148438 L 496.855469 577.171875 C 476.957031 597.089844 444.699219 597.089844 424.804688 577.171875 C 404.90625 557.25 404.90625 524.953125 424.804688 505.035156 L 506.726562 423.015625 C 526.625 403.085938 558.890625 403.085938 578.785156 423.015625 Z M 578.785156 423.015625 "/>
                            </g>
                        </svg>
                        <span class="sr-only">Datanito</span>
                        <?php
                        $patterns = [
                            '/^\/(?:[a-z]{2}\/)?cloud/' => 'DCloud',
                            '/^\/(?:[a-z]{2}\/)?domain/' => 'DDomain',
                            '/^\/(?:[a-z]{2}\/)?pay/' => 'datanito-pay',
                            '/^\/(?:[a-z]{2}\/)?dino/' => 'ai'
                        ];

                        foreach ($patterns as $pattern => $langKey) {
                            if (preg_match($pattern, $URL)) {
                                ?>
                                <h2 class="text-2xl tracking-tight font-bold text-dark-950 dark:text-gray-300"><?php echo $lang[$langKey]; ?></h2>
                                <?php
                                break;
                            }
                        }
                        ?>
                    </a>
                </div>
                <div class="flex items-center lg:order-2 space-x-1">
                    <div class="text-center">
                        <button type="button" data-drawer-target="cart-drawer" data-drawer-show="cart-drawer"
                                data-drawer-placement="right" aria-controls="cart-drawer" class="flex items-center p-2 mr-1 text-gray-500 rounded-full hover:text-gray-900 hover:bg-gray-100 dark:text-gray-400 dark:hover:text-white dark:hover:bg-dark-700 focus:ring-4 focus:ring-gray-300 dark:focus:ring-gray-600">
                            <svg class="w-5 h-5 text-gray-500 dark:text-gray-400" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 18 20">
                                <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 9V4a3 3 0 0 0-6 0v5m9.92 10H2.08a1 1 0 0 1-1-1.077L2 6h14l.917 11.923A1 1 0 0 1 15.92 19Z"/>
                            </svg>
                        </button>
                    </div>
                    <button type="button"
                            class="btn-open inline-flex items-center text-sm rounded-xl lg:hidden focus:outline-none focus:ring-0 text-gray-700 dark:text-gray-300"
                            aria-expanded="false">
                        <span class="sr-only">Open main menu</span>
                        <svg aria-hidden="true" class="w-6 h-6 text-gray-500 dark:text-gray-400" fill="currentColor" viewBox="0 0 20 20" xmlns="http://www.w3.org/2000/svg">
                            <path fill-rule="evenodd" d="M3 5a1 1 0 011-1h12a1 1 0 110 2H4a1 1 0 01-1-1zM3 10a1 1 0 011-1h6a1 1 0 110 2H4a1 1 0 01-1-1zM3 15a1 1 0 011-1h12a1 1 0 110 2H4a1 1 0 01-1-1z" clip-rule="evenodd"></path>
                        </svg>
                        <svg class="hidden w-6 h-6" fill="currentColor" viewBox="0 0 20 20"
                             xmlns="http://www.w3.org/2000/svg">
                            <path fill-rule="evenodd"
                                  d="M4.293 4.293a1 1 0 011.414 0L10 8.586l4.293-4.293a1 1 0 111.414 1.414L11.414 10l4.293 4.293a1 1 0 01-1.414 1.414L10 11.414l-4.293 4.293a1 1 0 01-1.414-1.414L8.586 10 4.293 5.707a1 1 0 010-1.414z"
                                  clip-rule="evenodd"></path>
                        </svg>
                    </button>
                </div>

            </div>
        </nav>
    </div>
    <div class="hidden md:block">
        <!-- Content for desktop menu -->
        <nav class="mx-auto w-full max-w-screen-2xl px-5 py-2">
            <div class="flex flex-wrap justify-between items-center !w-full">
                <div class="flex items-center">
                    <a href="<?php echo url(''); ?>" class="flex items-center mr-3">
                        <svg class="w-7 h-7 mr-4" xmlns="http://www.w3.org/2000/svg"
                             xmlns:xlink="http://www.w3.org/1999/xlink" width="151px" height="150px"
                             viewBox="0 0 639 636">
                            <g id="surface1">
                                <path style=" stroke:none;fill-rule:nonzero;fill-opacity:1;" class="fill-dark-950 dark:fill-gray-300" d="M 543.414062 80.550781 C 563.308594 100.46875 563.308594 132.765625 543.414062 152.683594 L 155.367188 541.199219 C 135.472656 561.121094 103.214844 561.121094 83.316406 541.199219 C 63.421875 521.28125 63.421875 488.984375 83.316406 469.066406 L 471.371094 80.558594 C 491.257812 60.628906 523.515625 60.628906 543.414062 80.550781 Z M 543.414062 80.550781 "/>
                                <path style=" stroke:none;fill-rule:nonzero;fill-opacity:1;" class="fill-dark-950 dark:fill-gray-300" d="M 350.257812 83.671875 C 370.15625 103.589844 370.15625 135.886719 350.257812 155.804688 L 158.246094 348.046875 C 138.347656 367.964844 106.089844 367.964844 86.195312 348.046875 C 66.296875 328.125 66.296875 295.828125 86.195312 275.910156 L 278.207031 83.671875 C 298.097656 63.75 330.363281 63.75 350.257812 83.671875 Z M 350.257812 83.671875 "/>
                                <path style=" stroke:none;fill-rule:nonzero;fill-opacity:1;" class="fill-dark-950 dark:fill-gray-300" d="M 198.839844 42.324219 C 218.734375 62.242188 218.734375 94.539062 198.839844 114.457031 L 116.90625 196.484375 C 97.011719 216.40625 64.753906 216.40625 44.855469 196.484375 C 24.960938 176.566406 24.960938 144.269531 44.855469 124.351562 L 126.78125 42.324219 C 146.679688 22.402344 178.941406 22.402344 198.839844 42.324219 Z M 198.839844 42.324219 "/>
                                <path style=" stroke:none;fill-rule:nonzero;fill-opacity:1;" class="fill-dark-950 dark:fill-gray-300" d="M 549.855469 263.0625 C 569.75 282.984375 569.75 315.277344 549.855469 335.199219 L 337.238281 548.0625 C 317.34375 567.984375 285.085938 567.984375 265.1875 548.0625 C 245.292969 528.140625 245.292969 495.847656 265.1875 475.925781 L 477.804688 263.0625 C 497.699219 243.140625 529.957031 243.140625 549.855469 263.0625 Z M 549.855469 263.0625 "/>
                                <path style=" stroke:none;fill-rule:nonzero;fill-opacity:1;" class="fill-dark-950 dark:fill-gray-300" d="M 578.785156 423.015625 C 598.683594 442.933594 598.683594 475.230469 578.785156 495.148438 L 496.855469 577.171875 C 476.957031 597.089844 444.699219 597.089844 424.804688 577.171875 C 404.90625 557.25 404.90625 524.953125 424.804688 505.035156 L 506.726562 423.015625 C 526.625 403.085938 558.890625 403.085938 578.785156 423.015625 Z M 578.785156 423.015625 "/>
                            </g>
                        </svg>
                        <?php
                        $patterns = [
                            '/^\/(?:[a-z]{2}\/)?cloud/' => 'DCloud',
                            '/^\/(?:[a-z]{2}\/)?domain/' => 'DDomain',
                            '/^\/(?:[a-z]{2}\/)?pay/' => 'datanito-pay',
                            '/^\/(?:[a-z]{2}\/)?dino/' => 'ai'
                        ];

                        foreach ($patterns as $pattern => $langKey) {
                            if (preg_match($pattern, $URL)) {
                                ?>
                                <h2 class="text-2xl ml-[-0.6em] tracking-tight font-bold text-dark-950 dark:text-gray-300"><?php echo $lang[$langKey]; ?></h2>
                                <?php
                                break;
                            }
                        }
                        ?>
                    </a>
                </div>
                <div class="hidden md:hidden justify-between items-center w-full lg:flex lg:w-auto lg:order-1 menu"
                     id="mobile-menu-2">
                    <ul class="flex flex-col mt-4 font-medium lg:flex-row lg:space-x-8 lg:mt-0">
                        <li>
                            <span
                               class="cursor-pointer mega-menu-item block py-2 pr-4 pl-3 text-gray-600 border-b border-gray-100 hover:bg-gray-50 lg:hover:bg-transparent lg:border-0 lg:hover:text-gray-800 lg:p-0 dark:text-gray-400 lg:dark:hover:text-gray-200 dark:hover:bg-gray-700 dark:hover:text-white lg:dark:hover:bg-transparent dark:border-gray-700 text-sm"><?php echo $lang['domain-names'] ?></span>
                            <ul class="bg-gray-100 border-gray-100 dark:bg-dark-700 border-b border-gray-200 dark:border-dark-600 pb-48 w-full top-12 p-6">
                                <div class="mx-auto w-full max-w-screen-xl flex justify-between">
                                    <li>
                                        <p class="!flex mt-5 mb-3 items-center text-xs text-gray-600 dark:text-gray-300"><?php echo $lang['domain-names'] ?></p>
                                        <ul>
                                            <li class="mb-2">
                                                <a href="<?php echo url('/domain/register');?>" class="inline-flex items-center text-lg font-semibold text-dark-700 dark:text-white">
                                                <?php echo $lang['get-a-new-domain'] ?>
                                                </a>
                                            </li>
                                            <li class="mb-2">
                                                <a href="<?php echo url('/domain/transfer');?>" class="inline-flex items-center text-lg font-semibold text-dark-700 dark:text-white">
                                                <?php echo $lang['transfer-your-domain'] ?>
                                                </a>
                                            </li>
                                        </ul>
                                    </li>
                                    <li>
                                        <ul>
                                            <li></li>
                                        </ul>
                                    </li>
                                    <li>
                                        <ul>
                                            <li></li>
                                        </ul>
                                    </li>

                                    <li>
                                        <ul>
                                            <li>
                                            </li>
                                        </ul>
                                    </li>
                                </div>

                            </ul>
                        </li>
                        <li>
                            <span
                                    class="cursor-pointer mega-menu-item block py-2 pr-4 pl-3 text-gray-600 border-b border-gray-100 hover:bg-gray-50 lg:hover:bg-transparent lg:border-0 lg:hover:text-gray-800 lg:p-0 dark:text-gray-400 lg:dark:hover:text-gray-200 dark:hover:bg-gray-700 dark:hover:text-white lg:dark:hover:bg-transparent dark:border-gray-700 text-sm"><?php echo $lang['cloud-hosting'] ?></span>

                            <ul class="bg-gray-100 border-gray-100 dark:bg-dark-700 border-b border-gray-200 dark:border-dark-600 pb-48 w-full top-12 p-6">
                                <div class="mx-auto w-full max-w-screen-xl flex justify-between">

                                    <li>
                                        <p class="!flex mt-5 mb-3 items-center text-xs text-gray-600 dark:text-gray-300"><?php echo $lang['cloud'] ?></p>
                                        <ul>
                                            <li class="mb-2">
                                                <a href="<?php echo url('/cloud');?>" class="inline-flex items-center text-lg font-semibold text-dark-700 dark:text-white">
                                                <?php echo $lang['datanito-cloud'] ?>
                                                </a>
                                            </li>
                                        </ul>
                                    </li>
                                    <li>
                                        <p class="!flex mt-5 mb-3 items-center text-xs text-gray-600 dark:text-gray-300"><?php echo $lang['hosting'] ?></p>
                                        <ul>
                                            <li class="mb-2">
                                                <a href="<?php echo url('/cloud/web-hosting');?>" class="inline-flex items-center text-lg font-semibold text-dark-700 dark:text-white">
                                                <?php echo $lang['web-hosting'] ?>
                                                </a>
                                            </li>
                                            <li class="mb-2">
                                                <a href="<?php echo url('/cloud/business-hosting');?>" class="inline-flex items-center text-lg font-semibold text-dark-700 dark:text-white">
                                                <?php echo $lang['business-hosting'] ?>
                                                </a>
                                            </li>
                                        </ul>
                                    </li>
                                    <li>
                                        <ul>
                                            <li></li>
                                        </ul>
                                    </li>
                                    <li>
                                        <ul>
                                            <li>
                                            </li>
                                        </ul>
                                    </li>
                                </div>
                            </ul>
                        </li>
                        <li>
                            <span
                                    class="cursor-pointer mega-menu-item block py-2 pr-4 pl-3 text-gray-600 border-b border-gray-100 hover:bg-gray-50 lg:hover:bg-transparent lg:border-0 lg:hover:text-gray-800 lg:p-0 dark:text-gray-400 lg:dark:hover:text-gray-200 dark:hover:bg-gray-700 dark:hover:text-white lg:dark:hover:bg-transparent dark:border-gray-700 text-sm"><?php echo $lang['solutions'] ?></span>
                            <ul class="bg-gray-100 border-gray-100 dark:bg-dark-700 border-b border-gray-200 dark:border-dark-600 pb-64 w-full top-12 p-6">
                                <div class="mx-auto w-full max-w-screen-xl flex justify-between">

                                    <li>
                                        <p class="!flex mt-5 mb-3 items-center text-xs text-gray-600 dark:text-gray-300"><?php echo $lang['websites'] ?></p>
                                        <ul>
                                            <li class="mb-2">
                                                <a href="<?php echo url('/solutions/web-design');?>" class="inline-flex items-center text-lg font-semibold text-dark-700 dark:text-white">
                                                <?php echo $lang['web-design-solutions'] ?>
                                                </a>
                                            </li>
                                            <li class="mb-2">
                                                <a href="<?php echo url('/solutions/seo');?>" class="inline-flex items-center text-lg font-semibold text-dark-700 dark:text-white">
                                                <?php echo $lang['seo-solutions'] ?>
                                                </a>
                                            </li>
                                            <li class="mb-2">
                                                <a href="<?php echo url('/solutions/wordpress-premium-support');?>" class="inline-flex items-center text-lg font-semibold text-dark-700 dark:text-white">
                                                <?php echo $lang['wordpress-premium-support'] ?>
                                                </a>
                                            </li>

                                        </ul>
                                    </li>
                                    <li>
                                        <p class="!flex mt-5 mb-3 items-center text-xs text-gray-600 dark:text-gray-300"><?php echo $lang['mobile-app'] ?></p>
                                        <ul>
                                            <li class="mb-2">
                                                <a href="<?php echo url('/solutions/mobile-app-development');?>" class="inline-flex items-center text-lg font-semibold text-dark-700 dark:text-white">
                                                    <?php echo $lang['mobile-app-dev-solutions'] ?>
                                                </a>
                                            </li>
                                        </ul>
                                    </li>
                                    <li>
                                        <p class="!flex mt-5 mb-3 items-center text-xs text-gray-600 dark:text-gray-300"><?php echo $lang['digital-marketing'] ?></p>
                                        <ul>
                                            <li class="mb-2">
                                                <a href="<?php echo url('/solutions/digital-advertising');?>" class="inline-flex items-center text-lg font-semibold text-dark-700 dark:text-white">
                                                <?php echo $lang['digital-advertising'] ?>
                                                </a>
                                            </li>
                                        </ul>
                                    </li>
                                    <li>
                                        <p class="!flex mt-5 mb-3 items-center text-xs text-gray-600 dark:text-gray-300"><?php echo $lang['datanito-pay-title'] ?></p>
                                        <ul>
                                            <li class="mb-2">
                                                <a href="<?php echo url('/pay');?>" class="inline-flex items-center text-lg font-semibold text-dark-700 dark:text-white">
                                                    <?php echo $lang['accept-payments'] ?>
                                                </a>
                                            </li>
                                            <li class="mb-2">
                                                <a href="<?php echo url('/pay/links');?>" class="inline-flex items-center text-lg font-semibold text-dark-700 dark:text-white">
                                                    <?php echo $lang['online-payment-links'] ?>
                                                </a>
                                            </li>
                                        </ul>
                                    </li>
                                </div>
                            </ul>
                        </li>
                        <li>
                            <a href="<?php echo url('/dino'); ?>"
                               class="block py-2 pr-4 pl-3 text-gray-700 border-b border-gray-100 hover:bg-gray-50 lg:hover:bg-transparent lg:border-0 lg:hover:text-gray-500 lg:p-0 dark:text-gray-400 lg:dark:hover:text-gray-200 dark:hover:bg-gray-700 dark:hover:text-white lg:dark:hover:bg-transparent dark:border-gray-700 text-sm"><?php echo $lang['dino-dino'] ?></a>
                        </li>
                        <li>
                            <a href="<?php echo url('/blog'); ?>"
                               class="block py-2 pr-4 pl-3 text-gray-700 border-b border-gray-100 hover:bg-gray-50 lg:hover:bg-transparent lg:border-0 lg:hover:text-gray-500 lg:p-0 dark:text-gray-400 lg:dark:hover:text-gray-200 dark:hover:bg-gray-700 dark:hover:text-white lg:dark:hover:bg-transparent dark:border-gray-700 text-sm"><?php echo $lang['blog'] ?></a>
                        </li>
                        <li>
                            <span
                                    class="cursor-pointer mega-menu-item block py-2 pr-4 pl-3 text-gray-600 border-b border-gray-100 hover:bg-gray-50 lg:hover:bg-transparent lg:border-0 lg:hover:text-gray-800 lg:p-0 dark:text-gray-400 lg:dark:hover:text-gray-200 dark:hover:bg-gray-700 dark:hover:text-white lg:dark:hover:bg-transparent dark:border-gray-700 text-sm"><?php echo $lang['support'] ?></span>
                            <ul class="bg-gray-100 border-gray-100 dark:bg-dark-700 border-b border-gray-200 dark:border-dark-600 pb-48 w-full top-12 p-6">
                                <div class="mx-auto w-full max-w-screen-xl flex justify-between">
                                    <li>
                                        <p class="!flex mt-5 mb-3 items-center text-xs text-gray-600 dark:text-gray-300"><?php echo $lang['support'] ?></p>
                                        <ul>
                                            <li class="mb-2">
                                                <a href="<?php echo url('/contact');?>" class="inline-flex items-center text-lg font-semibold text-dark-700 dark:text-white">
                                                <?php echo $lang['contact-us'] ?>
                                                </a>
                                            </li>
                                            <li class="mb-2">
                                                <a href="<?php echo url('/about');?>" class="inline-flex items-center text-lg font-semibold text-dark-700 dark:text-white">
                                                <?php echo $lang['about-us'] ?>
                                                </a>
                                            </li>
                                            <li class="mb-2">
                                                <a href="<?php echo url('/account/support/requests');?>" class="inline-flex items-center text-lg font-semibold text-dark-700 dark:text-white">
                                                <?php echo $lang['support-requests'] ?>
                                                </a>
                                            </li>
                                        </ul>
                                    </li>
                                    <li>
                                        <ul>
                                            <li></li>
                                        </ul>
                                    </li>
                                    <li>
                                        <ul>
                                            <li></li>
                                        </ul>
                                    </li>

                                    <li>
                                        <ul>

                                            <li>
                                            </li>

                                        </ul>
                                    </li>
                                </div>
                            </ul>
                        </li>

                    </ul>
                </div>

                <div class="flex items-center lg:order-2 space-x-1">
                    <!-- drawer init and toggle -->
                    <div class="text-center">
                        <button type="button" data-drawer-target="cart-drawer" data-drawer-show="cart-drawer"
                                data-drawer-placement="right" aria-controls="cart-drawer" class="flex items-center p-2 mr-1 text-gray-500 rounded-full  bg-gray-200 rounded-full dark:bg-dark-600 hover:bg-gray-300 dark:hover:bg-dark-500 focus:ring-4 focus:ring-gray-300 dark:focus:ring-gray-600">
                            <svg class="w-5 h-5 text-gray-500 dark:text-gray-300" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 18 20">
                                <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 9V4a3 3 0 0 0-6 0v5m9.92 10H2.08a1 1 0 0 1-1-1.077L2 6h14l.917 11.923A1 1 0 0 1 15.92 19Z"/>
                            </svg>
                            <span class="sr-only">Cart</span>
                        </button>
                    </div>
                    <div class="flex items-center md:order-2 pl-1.5">
                        <button type="button"
                                class="flex mr-3 text-sm rounded-full md:mr-0 focus:ring-4 focus:ring-gray-300 dark:focus:ring-gray-600"
                                id="user-menu-button" aria-expanded="false" data-dropdown-toggle="user-dropdown"
                                data-dropdown-placement="bottom">
                            <span class="sr-only">Open user menu</span>
                            <span class="relative inline-flex items-center justify-center w-9 h-9 overflow-hidden bg-gray-200 rounded-full dark:bg-dark-600 hover:bg-gray-300 dark:hover:bg-dark-500">
                                <?php if (isset($_SESSION['userLoggedIn']) && $_SESSION['userLoggedIn']): ?>
                                    <span class="font-medium text-gray-600 dark:text-gray-300"><?php echo $this_userAvatar; ?></span>
                                <?php else: ?>
                                    <svg class="w-6 h-6 text-gray-500 dark:text-gray-300" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" width="24" height="24" fill="none" viewBox="0 0 24 24">
                                      <path stroke="currentColor" stroke-width="2" d="M7 17v1a1 1 0 0 0 1 1h8a1 1 0 0 0 1-1v-1a3 3 0 0 0-3-3h-4a3 3 0 0 0-3 3Zm8-9a3 3 0 1 1-6 0 3 3 0 0 1 6 0Z"/>
                                    </svg>
                                <?php endif; ?>
                            </span>
                        </button>
                        <!-- Dropdown menu -->
                        <div class="z-50 hidden my-4 mr-5 text-base list-none bg-white divide-y divide-gray-100 rounded-3xl shadow dark:bg-dark-600 dark:divide-gray-600 w-[20em] !inset-x-[-0.5em] overflow-hidden"
                             id="user-dropdown">
                            <?php if (isset($_SESSION['userLoggedIn']) && $_SESSION['userLoggedIn']): ?>
                                <div class="py-3 px-4 m-2 rounded-3xl bg-gray-100 dark:bg-dark-500 w-[95%]">
                                    <div class="flex w-full items-center justify-between">
                                        <div class="flex w-full items-center">
                                            <div class="relative inline-flex items-center justify-center w-[3.5em] h-[3.5em] mr-2 overflow-hidden bg-gray-100 rounded-full dark:bg-dark-600">
                                                <span class="font-medium text-gray-600 dark:text-gray-300 profile__picture"><?php echo $this_userAvatar; ?></span>
                                            </div>
                                            <div>
                        <span class="block text-sm font-semibold text-gray-900 dark:text-white">
                            <?php echo $this_name; ?>
                        </span>
                                                <span class="flex text-sm text-gray-900 truncate dark:text-white items-center">
                                                    <?php
                                                    if (!empty($this_username)) {
                                                        echo '@' . $this_username;
                                                        if (!empty($this_verificationBadge)) {
                                                            echo $this_verificationBadge;
                                                        }
                                                    }
                                                    ?>
                        </span>
                                            </div>
                                        </div>
                                        <div class="flex items-center justify-end">
                                            <a href="<?php echo url('/account/overview'); ?>"
                                               class="text-white bg-dark-700 hover:bg-dark-800 focus:ring-0 font-medium rounded-full text-sm p-3 dark:bg-dark-700 dark:hover:bg-dark-800 focus:outline-none">
                                                <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 20 20" xmlns="http://www.w3.org/2000/svg">
                                                    <path fill-rule="evenodd" d="M10.293 3.293a1 1 0 011.414 0l6 6a1 1 0 010 1.414l-6 6a1 1 0 01-1.414-1.414L14.586 11H3a1 1 0 110-2h11.586l-4.293-4.293a1 1 0 010-1.414z" clip-rule="evenodd"></path>
                                                </svg>
                                                <span class="sr-only"><?php echo $lang['dashboard']?></span>
                                            </a>
                                        </div>
                                    </div>
                                </div>
                                <ul class="py-2 w-full" aria-labelledby="user-menu-button">
                                    <li>
                                        <a href="<?php echo url('/account/profile/update'); ?>"
                                           class="flex items-center px-4 py-2 text-sm text-gray-700 hover:bg-gray-100 dark:hover:bg-dark-500 dark:text-gray-200 dark:hover:text-white">
                                            <span class="material-symbols-outlined mr-3">account_circle</span><?php echo $lang['manage-your-account']; ?>
                                        </a>
                                    </li>
                                    <li>
                                        <form method="POST" class="logout-action">
                                            <button class="flex w-full items-center px-4 py-2 text-sm text-gray-700 hover:bg-gray-100 dark:hover:bg-dark-500 dark:text-gray-200 dark:hover:text-white"
                                                    type="submit">
                                                <span class="material-symbols-outlined mr-3">logout</span><?php echo $lang['sign-out'] ?>
                                            </button>
                                        </form>
                                    </li>
                                </ul>
                            <?php else: ?>
                                <div class="py-3 px-4 bg-gray-50 dark:bg-dark-500">
                                    <div class="block w-full">
                                        <a href="<?php echo url('/account/login'); ?>"
                                           class="block w-full text-center text-white bg-dark-700 hover:bg-dark-800 focus:ring-4 focus:ring-dark-300 font-medium rounded-xl text-sm px-3 py-2.5 dark:bg-dark-700 dark:hover:bg-dark-800 focus:outline-none dark:focus:ring-dark-800">
                                            <?php echo $lang['login'] ?>
                                        </a>
                                    </div>
                                </div>
                                <ul class="py-2 w-full" aria-labelledby="user-menu-button">
                                    <li>
                                        <a href="<?php echo url('/account/create'); ?>"
                                           class="flex items-center px-4 py-2 text-sm text-gray-700 hover:bg-gray-100 dark:hover:bg-dark-500 dark:text-gray-200 dark:hover:text-white">
                                            <span class="material-symbols-outlined mr-3">person_add</span><?php echo $lang['create-datanito-account'] ?>
                                        </a>
                                    </li>
                                </ul>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>

                    <button data-collapse-toggle="mobile-menu-2" type="button"
                            class="btn-open inline-flex items-center p-2 ml-1 text-sm text-gray-500 rounded-xl lg:hidden hover:bg-gray-100 focus:outline-none focus:ring-2 focus:ring-gray-200 dark:text-gray-400 dark:hover:bg-dark-900 dark:focus:ring-gray-600"
                            aria-controls="mobile-menu-2" aria-expanded="false">
                        <span class="sr-only">Open main menu</span>
                        <svg class="w-6 h-6" fill="currentColor" viewBox="0 0 20 20" xmlns="http://www.w3.org/2000/svg">
                            <path fill-rule="evenodd"
                                  d="M3 5a1 1 0 011-1h12a1 1 0 110 2H4a1 1 0 01-1-1zM3 10a1 1 0 011-1h12a1 1 0 110 2H4a1 1 0 01-1-1zM3 15a1 1 0 011-1h12a1 1 0 110 2H4a1 1 0 01-1-1z"
                                  clip-rule="evenodd"></path>
                        </svg>
                        <svg class="hidden w-6 h-6" fill="currentColor" viewBox="0 0 20 20"
                             xmlns="http://www.w3.org/2000/svg">
                            <path fill-rule="evenodd"
                                  d="M4.293 4.293a1 1 0 011.414 0L10 8.586l4.293-4.293a1 1 0 111.414 1.414L11.414 10l4.293 4.293a1 1 0 01-1.414 1.414L10 11.414l-4.293 4.293a1 1 0 01-1.414-1.414L8.586 10 4.293 5.707a1 1 0 010-1.414z"
                                  clip-rule="evenodd"></path>
                        </svg>
                    </button>
                </div>
        </nav>
    </div>

</header>
<div id="mega-menu-overlay" class="hidden fixed backdrop-blur w-full left-0 bottom-0 top-0 z-20"></div>

<div class="mobileMenu bg-gray-100 dark:bg-dark-700 !opacity-[98%] backdrop-blur max-w-[85%]">
    <a href="<?php echo url(''); ?>" class="flex items-center mr-3 pl-[15px]">
        <svg class="w-[100px] h-12" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink"
             width="300px" height="77px" viewBox="0 0 2485 636">
            <g id="surface1">
                <path style=" stroke:none;fill-rule:nonzero;fill-opacity:1;" class="fill-gray-900 dark:fill-gray-300" d="M 543.941406 80.550781 C 563.855469 100.46875 563.855469 132.765625 543.941406 152.683594 L 155.519531 541.199219 C 135.601562 561.121094 103.3125 561.121094 83.398438 541.199219 C 63.480469 521.28125 63.480469 488.984375 83.398438 469.066406 L 471.828125 80.558594 C 491.734375 60.628906 524.023438 60.628906 543.941406 80.550781 Z M 543.941406 80.550781 "/>
                <path style=" stroke:none;fill-rule:nonzero;fill-opacity:1;" class="fill-gray-900 dark:fill-gray-300" d="M 350.597656 83.671875 C 370.515625 103.589844 370.515625 135.886719 350.597656 155.804688 L 158.398438 348.046875 C 138.480469 367.964844 106.195312 367.964844 86.277344 348.046875 C 66.363281 328.125 66.363281 295.828125 86.277344 275.910156 L 278.480469 83.671875 C 298.386719 63.75 330.683594 63.75 350.597656 83.671875 Z M 350.597656 83.671875 "/>
                <path style=" stroke:none;fill-rule:nonzero;fill-opacity:1;" class="fill-gray-900 dark:fill-gray-300" d="M 199.03125 42.324219 C 218.949219 62.242188 218.949219 94.539062 199.03125 114.457031 L 117.019531 196.484375 C 97.105469 216.40625 64.816406 216.40625 44.902344 196.484375 C 24.984375 176.566406 24.984375 144.269531 44.902344 124.351562 L 126.90625 42.324219 C 146.820312 22.402344 179.117188 22.402344 199.03125 42.324219 Z M 199.03125 42.324219 "/>
                <path style=" stroke:none;fill-rule:nonzero;fill-opacity:1;" class="fill-gray-900 dark:fill-gray-300" d="M 550.390625 263.0625 C 570.304688 282.984375 570.304688 315.277344 550.390625 335.199219 L 337.566406 548.0625 C 317.652344 567.984375 285.363281 567.984375 265.445312 548.0625 C 245.53125 528.140625 245.53125 495.847656 265.445312 475.925781 L 478.269531 263.0625 C 498.183594 243.140625 530.472656 243.140625 550.390625 263.0625 Z M 550.390625 263.0625 "/>
                <path style=" stroke:none;fill-rule:nonzero;fill-opacity:1;" class="fill-gray-900 dark:fill-gray-300" d="M 579.347656 423.015625 C 599.265625 442.933594 599.265625 475.230469 579.347656 495.148438 L 497.335938 577.171875 C 477.421875 597.089844 445.132812 597.089844 425.21875 577.171875 C 405.300781 557.25 405.300781 524.953125 425.21875 505.035156 L 507.21875 423.015625 C 527.136719 403.085938 559.433594 403.085938 579.347656 423.015625 Z M 579.347656 423.015625 "/>
                <path style=" stroke:none;fill-rule:nonzero;fill-opacity:1;" class="fill-gray-900 dark:fill-gray-300" d="M 783.945312 475.972656 L 783.945312 150.816406 L 897.996094 150.816406 C 992.066406 150.816406 1046.167969 217.605469 1046.167969 313.640625 C 1046.167969 409.679688 992.554688 475.980469 898.484375 475.980469 L 783.945312 475.980469 Z M 965.746094 313.640625 C 965.746094 253.191406 942.351562 219.554688 898.484375 219.554688 L 862.902344 219.554688 L 862.902344 407.242188 L 898.484375 407.242188 C 940.886719 407.242188 965.746094 370.679688 965.746094 313.640625 Z M 965.746094 313.640625 "/>
                <path style=" stroke:none;fill-rule:nonzero;fill-opacity:1;" class="fill-gray-900 dark:fill-gray-300" d="M 1206.035156 475.972656 L 1206.035156 452.574219 C 1193.851562 470.609375 1167.53125 481.824219 1143.648438 481.824219 C 1106.605469 481.824219 1070.050781 455.011719 1070.050781 403.824219 C 1070.050781 351.171875 1106.605469 327.773438 1143.648438 327.773438 C 1168.503906 327.773438 1193.851562 337.523438 1206.035156 355.558594 L 1206.035156 330.699219 C 1206.035156 308.761719 1190.925781 294.136719 1164.117188 294.136719 C 1144.621094 294.136719 1124.152344 302.910156 1106.605469 318.511719 L 1081.261719 269.273438 C 1107.09375 244.410156 1146.570312 234.660156 1178.253906 234.660156 C 1231.867188 234.660156 1276.707031 257.574219 1276.707031 320.460938 L 1276.707031 475.972656 Z M 1206.035156 417.472656 L 1206.035156 392.609375 C 1199.210938 379.933594 1185.5625 374.574219 1171.429688 374.574219 C 1153.394531 374.574219 1139.75 385.785156 1139.75 404.796875 C 1139.75 424.296875 1153.394531 435.023438 1171.429688 435.023438 C 1185.5625 435.03125 1199.210938 430.15625 1206.035156 417.472656 Z M 1206.035156 417.472656 "/>
                <path style=" stroke:none;fill-rule:nonzero;fill-opacity:1;" class="fill-gray-900 dark:fill-gray-300" d="M 1335.195312 414.546875 L 1335.195312 301.449219 L 1304.976562 301.449219 L 1304.976562 240.511719 L 1335.195312 240.511719 L 1335.195312 176.160156 L 1405.382812 176.160156 L 1405.382812 240.511719 L 1443.398438 240.511719 L 1443.398438 301.449219 L 1405.382812 301.449219 L 1405.382812 397.484375 C 1405.382812 411.136719 1411.230469 419.421875 1421.464844 419.421875 C 1428.289062 419.421875 1434.625 416.984375 1437.550781 414.058594 L 1450.222656 468.660156 C 1441.449219 475.972656 1424.390625 481.824219 1401.484375 481.824219 C 1356.148438 481.824219 1335.195312 459.40625 1335.195312 414.546875 Z M 1335.195312 414.546875 "/>
                <path style=" stroke:none;fill-rule:nonzero;fill-opacity:1;" class="fill-gray-900 dark:fill-gray-300" d="M 1599.847656 475.972656 L 1599.847656 452.574219 C 1587.664062 470.609375 1561.34375 481.824219 1537.460938 481.824219 C 1500.417969 481.824219 1463.863281 455.011719 1463.863281 403.824219 C 1463.863281 351.171875 1500.417969 327.773438 1537.460938 327.773438 C 1562.316406 327.773438 1587.664062 337.523438 1599.847656 355.558594 L 1599.847656 330.699219 C 1599.847656 308.761719 1584.738281 294.136719 1557.929688 294.136719 C 1538.433594 294.136719 1517.964844 302.910156 1500.417969 318.511719 L 1475.074219 269.273438 C 1500.90625 244.410156 1540.386719 234.660156 1572.066406 234.660156 C 1625.679688 234.660156 1670.519531 257.574219 1670.519531 320.460938 L 1670.519531 475.972656 Z M 1599.847656 417.472656 L 1599.847656 392.609375 C 1593.023438 379.933594 1579.378906 374.574219 1565.242188 374.574219 C 1547.207031 374.574219 1533.5625 385.785156 1533.5625 404.796875 C 1533.5625 424.296875 1547.207031 435.023438 1565.242188 435.023438 C 1579.378906 435.03125 1593.023438 430.15625 1599.847656 417.472656 Z M 1599.847656 417.472656 "/>
                <path style=" stroke:none;fill-rule:nonzero;fill-opacity:1;" class="fill-gray-900 dark:fill-gray-300" d="M 1852.800781 475.972656 L 1852.800781 327.773438 C 1852.800781 305.835938 1842.566406 297.058594 1825.019531 297.058594 C 1807.472656 297.058594 1794.800781 309.734375 1787.976562 321.921875 L 1787.976562 475.972656 L 1717.304688 475.972656 L 1717.304688 240.515625 L 1787.976562 240.515625 L 1787.976562 269.765625 C 1799.675781 252.21875 1826.96875 234.667969 1857.675781 234.667969 C 1903.492188 234.667969 1923.476562 261.480469 1923.476562 299.503906 L 1923.476562 475.980469 L 1852.800781 475.980469 Z M 1852.800781 475.972656 "/>
                <path style=" stroke:none;fill-rule:nonzero;fill-opacity:1;" class="fill-gray-900 dark:fill-gray-300" d="M 1964.90625 177.140625 C 1964.90625 154.230469 1982.9375 136.191406 2005.847656 136.191406 C 2028.265625 136.191406 2046.789062 154.230469 2046.789062 177.140625 C 2046.789062 199.566406 2028.265625 218.09375 2005.847656 218.09375 C 1982.9375 218.09375 1964.90625 199.566406 1964.90625 177.140625 Z M 1970.265625 475.972656 L 1970.265625 240.515625 L 2040.9375 240.515625 L 2040.9375 475.980469 L 1970.265625 475.980469 Z M 1970.265625 475.972656 "/>
                <path style=" stroke:none;fill-rule:nonzero;fill-opacity:1;" class="fill-gray-900 dark:fill-gray-300" d="M 2099.425781 414.546875 L 2099.425781 301.449219 L 2069.207031 301.449219 L 2069.207031 240.511719 L 2099.425781 240.511719 L 2099.425781 176.160156 L 2169.613281 176.160156 L 2169.613281 240.511719 L 2207.628906 240.511719 L 2207.628906 301.449219 L 2169.613281 301.449219 L 2169.613281 397.484375 C 2169.613281 411.136719 2175.460938 419.421875 2185.699219 419.421875 C 2192.519531 419.421875 2198.859375 416.984375 2201.78125 414.058594 L 2214.453125 468.660156 C 2205.679688 475.972656 2188.621094 481.824219 2165.714844 481.824219 C 2120.386719 481.824219 2099.425781 459.40625 2099.425781 414.546875 Z M 2099.425781 414.546875 "/>
                <path style=" stroke:none;fill-rule:nonzero;fill-opacity:1;" class="fill-gray-900 dark:fill-gray-300" d="M 2228.09375 358.003906 C 2228.09375 292.191406 2267.574219 234.667969 2340.683594 234.667969 C 2414.28125 234.667969 2453.273438 292.191406 2453.273438 358.003906 C 2453.273438 423.816406 2414.28125 481.828125 2340.683594 481.828125 C 2267.574219 481.824219 2228.09375 423.808594 2228.09375 358.003906 Z M 2380.652344 358.003906 C 2380.652344 323.878906 2368.464844 297.066406 2340.683594 297.066406 C 2313.390625 297.066406 2300.71875 323.878906 2300.71875 358.003906 C 2300.71875 392.617188 2313.390625 419.429688 2340.683594 419.429688 C 2368.464844 419.421875 2380.652344 392.617188 2380.652344 358.003906 Z M 2380.652344 358.003906 "/>
            </g>
        </svg>
    </a>
    <ul class="overflow-y-auto py-5 px-3 h-full space-y-2 m-2">

        <li class="has-submenu">
            <a class="flex w-full items-center font-medium text-gray-600 dark:text-gray-300 bg-gray-100 dark:bg-dark-700 hover:bg-white dark:hover:bg-dark-600 p-2 rounded-full cursor-pointer whitespace-nowrap transition-colors" href="#" data-submenu="domain">
                <div class="flex items-center justify-center text-sm mr-4 w-8 h-8 bg-gray-200 dark:bg-dark-500 rounded-full"><span class="material-symbols-outlined text-xl">language</span></div>
                <?php echo $lang['domain-names'] ?></a>
            <div id="domain" class="submenu bg-gray-100 dark:bg-dark-700">
                <div class="submenu-header border-gray-300 dark:border-dark-700">
                    <a class="text-black dark:text-white" href="#"
                       data-submenu-close="domain"><?php echo $lang['main-menu'] ?></a>
                </div>

                <label class="text-gray-600 dark:text-gray-300 inline-flex items-center px-3 py-1.5 rounded-full mt-4 mb-0.5 text-sm font-medium"><?php echo $lang['domain-names'] ?></label>

                <ul class="m-2 space-y-2">
                    <li>
                        <a class="flex w-full items-center font-medium text-gray-600 dark:text-gray-300 bg-gray-100 dark:bg-dark-700 hover:bg-white dark:hover:bg-dark-600 p-3 rounded-full cursor-pointer whitespace-nowrap transition-colors" href="<?php echo url('/domain/register');?>"><?php echo $lang['get-a-new-domain'] ?></a>
                    </li>

                    <li>
                        <a class="flex w-full items-center font-medium text-gray-600 dark:text-gray-300 bg-gray-100 dark:bg-dark-700 hover:bg-white dark:hover:bg-dark-600 p-3 rounded-full cursor-pointer whitespace-nowrap transition-colors" href="<?php echo url('/domain/transfer');?>"><?php echo $lang['transfer-your-domain'] ?></a>
                    </li>

                </ul>
            </div>
        </li>
        <li class="has-submenu">
            <a class="flex w-full items-center font-medium text-gray-600 dark:text-gray-300 bg-gray-100 dark:bg-dark-700 hover:bg-white dark:hover:bg-dark-600 p-2 rounded-full cursor-pointer whitespace-nowrap transition-colors" href="#" data-submenu="cloud">
                <div class="flex items-center justify-center text-sm mr-4 w-8 h-8 bg-gray-200 dark:bg-dark-500 rounded-full"><span class="material-symbols-outlined text-xl">cloud</span></div>
                <?php echo $lang['cloud-hosting'] ?></a>
            <div id="cloud" class="submenu bg-gray-100 dark:bg-dark-700">
                <div class="submenu-header border-gray-300 dark:border-dark-700">
                    <a class="text-black dark:text-white" href="#"
                       data-submenu-close="cloud"><?php echo $lang['main-menu'] ?></a>
                </div>

                <label class="text-gray-600 dark:text-gray-300 inline-flex items-center px-3 py-1.5 rounded-full mt-4 mb-0.5 text-sm font-medium"><?php echo $lang['cloud-hosting'] ?></label>

                <ul class="m-2 space-y-2">

                    <li>
                        <a class="flex w-full items-center font-medium text-gray-600 dark:text-gray-300 bg-gray-100 dark:bg-dark-700 hover:bg-white dark:hover:bg-dark-600 p-3 rounded-full cursor-pointer whitespace-nowrap transition-colors" href="<?php echo url('/cloud/web-hosting');?>"><?php echo $lang['web-hosting'] ?></a>
                    </li>

                    <li>
                        <a class="flex w-full items-center font-medium text-gray-600 dark:text-gray-300 bg-gray-100 dark:bg-dark-700 hover:bg-white dark:hover:bg-dark-600 p-3 rounded-full cursor-pointer whitespace-nowrap transition-colors" href="<?php echo url('/cloud');?>"><?php echo $lang['datanito-cloud'] ?></a>
                    </li>

                    <li>
                        <a class="flex w-full items-center font-medium text-gray-600 dark:text-gray-300 bg-gray-100 dark:bg-dark-700 hover:bg-white dark:hover:bg-dark-600 p-3 rounded-full cursor-pointer whitespace-nowrap transition-colors" href="<?php echo url('/cloud/business-hosting');?>"><?php echo $lang['business-hosting'] ?></a>
                    </li>

                </ul>
            </div>
        </li>

        <li class="has-submenu">
            <a class="flex w-full items-center font-medium text-gray-600 dark:text-gray-300 bg-gray-100 dark:bg-dark-700 hover:bg-white dark:hover:bg-dark-600 p-2 rounded-full cursor-pointer whitespace-nowrap transition-colors" href="#" data-submenu="solutions">
                <div class="flex items-center justify-center text-sm mr-4 w-8 h-8 bg-gray-200 dark:bg-dark-500 rounded-full"><span class="material-symbols-outlined text-xl">lightbulb</span></div>
                <?php echo $lang['solutions'] ?></a>

            <div id="solutions" class="submenu bg-gray-100 dark:bg-dark-700">
                <div class="submenu-header border-gray-300 dark:border-dark-700">
                    <a class="text-black dark:text-white" href="#"
                       data-submenu-close="solutions"><?php echo $lang['main-menu'] ?></a>
                </div>

                <label class="text-gray-600 dark:text-gray-300 inline-flex items-center px-3 py-1.5 rounded-full mt-4 mb-0.5 text-sm font-medium"><?php echo $lang['solutions'] ?></label>

                <ul class="m-2 space-y-2">

                    <li>
                        <a class="flex w-full items-center font-medium text-gray-600 dark:text-gray-300 bg-gray-100 dark:bg-dark-700 hover:bg-white dark:hover:bg-dark-600 p-3 rounded-full cursor-pointer whitespace-nowrap transition-colors" href="<?php echo url('/solutions/web-design');?>"><?php echo $lang['web-design-solutions'] ?></a>
                    </li>

                    <li>
                        <a class="flex w-full items-center font-medium text-gray-600 dark:text-gray-300 bg-gray-100 dark:bg-dark-700 hover:bg-white dark:hover:bg-dark-600 p-3 rounded-full cursor-pointer whitespace-nowrap transition-colors"
                           href="<?php echo url('/solutions/mobile-app-development');?>"><?php echo $lang['mobile-app-dev-solutions'] ?></a>
                    </li>

                    <li>
                        <a class="flex w-full items-center font-medium text-gray-600 dark:text-gray-300 bg-gray-100 dark:bg-dark-700 hover:bg-white dark:hover:bg-dark-600 p-3 rounded-full cursor-pointer whitespace-nowrap transition-colors" href="<?php echo url('/solutions/seo');?>"><?php echo $lang['seo-solutions'] ?></a>
                    </li>

                    <li>
                        <a class="flex w-full items-center font-medium text-gray-600 dark:text-gray-300 bg-gray-100 dark:bg-dark-700 hover:bg-white dark:hover:bg-dark-600 p-3 rounded-full cursor-pointer whitespace-nowrap transition-colors"
                           href="<?php echo url('/solutions/wordpress-premium-support');?>"><?php echo $lang['wordpress-premium-support'] ?></a>
                    </li>

                </ul>
                <label class="text-gray-600 dark:text-gray-300 inline-flex items-center px-3 py-1.5 rounded-full mt-4 mb-0.5 text-sm font-medium"><?php echo $lang['datanito-pay-title'] ?></label>

                <ul class="m-2 space-y-2">

                    <li>
                        <a class="flex w-full items-center font-medium text-gray-600 dark:text-gray-300 bg-gray-100 dark:bg-dark-700 hover:bg-white dark:hover:bg-dark-600 p-3 rounded-full cursor-pointer whitespace-nowrap transition-colors" href="<?php echo url('/pay');?>"><?php echo $lang['accept-payments'] ?></a>
                    </li>
                    <li>
                        <a class="flex w-full items-center font-medium text-gray-600 dark:text-gray-300 bg-gray-100 dark:bg-dark-700 hover:bg-white dark:hover:bg-dark-600 p-3 rounded-full cursor-pointer whitespace-nowrap transition-colors" href="<?php echo url('/pay/links');?>"><?php echo $lang['online-payment-links'] ?></a>
                    </li>

                </ul>
            </div>
        </li>

        <li>
            <a class="flex w-full items-center font-medium text-gray-600 dark:text-gray-300 bg-gray-100 dark:bg-dark-700 hover:bg-white dark:hover:bg-dark-600 p-2 rounded-full cursor-pointer whitespace-nowrap transition-colors" href="<?php echo url('/dino');?>">
                <div class="flex items-center justify-center text-sm mr-4 w-8 h-8 bg-gray-200 dark:bg-dark-500 rounded-full"><svg class="w-5 h-5 text-gray-500 transition duration-75 dark:text-gray-400" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 20 21">
                        <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="m12.555 5.117 2.828 2.828M14 16v4m-2-2h4M3 6v4M1 8h4m11.01-6.339 2.828 2.829L3.99 19.339 1.161 16.51 16.01 1.661Z"></path>
                        <path fill="currentColor" d="M16 13h-2v2h2v-2ZM10 2H8v2h2V2ZM7 4H5v2h2V4ZM4 2H2v2h2V2Zm15 8h-2v2h2v-2Zm0 5h-2v2h2v-2Z"></path>
                    </svg>
                </div>
                <?php echo $lang['dino-dino'] ?></a>
        </li>

        <li>
            <a class="flex w-full items-center font-medium text-gray-600 dark:text-gray-300 bg-gray-100 dark:bg-dark-700 hover:bg-white dark:hover:bg-dark-600 p-2 rounded-full cursor-pointer whitespace-nowrap transition-colors" href="<?php echo url('/blog');?>">
                <div class="flex items-center justify-center text-sm mr-4 w-8 h-8 bg-gray-200 dark:bg-dark-500 rounded-full"><span class="material-symbols-outlined text-xl">description</span></div>
                <?php echo $lang['blog'] ?></a>
        </li>

        <li class="has-submenu">
            <a class="flex w-full items-center font-medium text-gray-600 dark:text-gray-300 bg-gray-100 dark:bg-dark-700 hover:bg-white dark:hover:bg-dark-600 p-2 rounded-full cursor-pointer whitespace-nowrap transition-colors" href="#" data-submenu="support">
                <div class="flex items-center justify-center text-sm mr-4 w-8 h-8 bg-gray-200 dark:bg-dark-500 rounded-full"><span class="material-symbols-outlined text-xl">support</span></div>
                <?php echo $lang['support'] ?></a>

            <div id="support" class="submenu bg-gray-100 dark:bg-dark-700">
                <div class="submenu-header border-gray-300 dark:border-dark-700">
                    <a class="text-black dark:text-white" href="#"
                       data-submenu-close="support"><?php echo $lang['main-menu'] ?></a>
                </div>

                <label class="text-gray-600 dark:text-gray-300 inline-flex items-center px-3 py-1.5 rounded-full mt-4 mb-0.5 text-sm font-medium"><?php echo $lang['support'] ?></label>

                <ul class="m-2 space-y-2">

                    <li>
                        <a class="flex w-full items-center font-medium text-gray-600 dark:text-gray-300 bg-gray-100 dark:bg-dark-700 hover:bg-white dark:hover:bg-dark-600 p-3 rounded-full cursor-pointer whitespace-nowrap transition-colors" href="<?php echo url('/contact');?>"><?php echo $lang['contact-us'] ?></a>
                    </li>
                    <li>
                        <a class="flex w-full items-center font-medium text-gray-600 dark:text-gray-300 bg-gray-100 dark:bg-dark-700 hover:bg-white dark:hover:bg-dark-600 p-3 rounded-full cursor-pointer whitespace-nowrap transition-colors" href="<?php echo url('/about');?>"><?php echo $lang['about-us'] ?></a>
                    </li>
                    <li>
                        <a class="flex w-full items-center font-medium text-gray-600 dark:text-gray-300 bg-gray-100 dark:bg-dark-700 hover:bg-white dark:hover:bg-dark-600 p-3 rounded-full cursor-pointer whitespace-nowrap transition-colors" href="<?php echo url('/account/support/requests');?>"><?php echo $lang['support-requests'] ?></a>
                    </li>

                </ul>
            </div>
        </li>
    </ul>
    <div class="flex items-center md:order-2 justify-center absolute bottom-1 w-[100%]">
        <?php if (isset($_SESSION['userLoggedIn']) && $_SESSION['userLoggedIn']): ?>
            <div class="py-3 px-4 m-2 rounded-3xl bg-gray-200 dark:bg-dark-600 w-[100%]">
                <div class="flex w-full items-center justify-between">
                    <div class="flex w-full items-center">
                        <div class="relative inline-flex items-center justify-center w-[3.5em] h-[3.5em] mr-2 overflow-hidden bg-gray-100 rounded-full dark:bg-dark-600">
                            <span class="font-medium text-gray-600 dark:text-gray-300 profile__picture"><?php echo $this_userAvatar; ?></span>
                        </div>
                        <div>
                        <span class="block text-sm font-semibold text-gray-900 dark:text-white">
                            <?php echo $this_name; ?>
                        </span>
                                <span class="flex text-sm text-gray-900 truncate dark:text-white items-center">
                                                    <?php
                                                    if (!empty($this_username)) {
                                                        echo '@' . $this_username;
                                                        if (!empty($this_verificationBadge)) {
                                                            echo $this_verificationBadge;
                                                        }
                                                    }
                                                    ?>
                        </span>
                        </div>
                    </div>
                    <div class="flex items-center justify-end">
                        <a href="<?php echo url('/account/overview'); ?>"
                           class="flex w-full text-center text-white bg-dark-700 hover:bg-dark-800 focus:ring-0 font-medium rounded-full text-sm p-3 dark:bg-dark-700 dark:hover:bg-dark-800 focus:outline-none">
                            <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 20 20" xmlns="http://www.w3.org/2000/svg">
                                <path fill-rule="evenodd" d="M10.293 3.293a1 1 0 011.414 0l6 6a1 1 0 010 1.414l-6 6a1 1 0 01-1.414-1.414L14.586 11H3a1 1 0 110-2h11.586l-4.293-4.293a1 1 0 010-1.414z" clip-rule="evenodd"></path>
                            </svg>
                            <span class="sr-only"><?php echo $lang['dashboard']?></span>
                        </a>
                    </div>
                </div>
            </div>
        <?php else: ?>
            <div class="py-3 px-4 m-2 rounded-3xl bg-gray-200 dark:bg-dark-600 w-[100%]">
                <div class="block w-[100%]">
                    <a href="<?php echo url('/account/login'); ?>"
                       class="block w-full mb-3 text-center text-white bg-dark-700 hover:bg-dark-800 focus:ring-4 focus:ring-dark-300 font-medium rounded-3xl text-sm px-3 lg:px-4 py-3 lg:py-3.5 dark:bg-dark-700 dark:hover:bg-dark-800 focus:outline-none dark:focus:ring-dark-800">
                        <?php echo $lang['login'] ?>
                    </a>
                    <a href="<?php echo url('/account/create'); ?>"
                       class="block w-full text-center text-white bg-dark-700 hover:bg-dark-800 focus:ring-4 focus:ring-dark-300 font-medium rounded-3xl text-sm px-3 lg:px-4 py-3 lg:py-3.5 dark:bg-dark-700 dark:hover:bg-dark-800 focus:outline-none dark:focus:ring-dark-800">
                        <?php echo $lang['create-account'] ?>
                    </a>
                </div>
            </div>

        <?php endif; ?>
    </div>

</div>
<div class="mobileMenu-overlay backdrop-blur"></div>

