<?php
include_once includes('head.php');
// Start the session
if (!isset($_SESSION['user']['id'])) {
    // User is not logged in. Display a message and a spinner.

    // Output HTML to display a spinner and a message
    echo '<div class="absolute left-[50%] top-[50%] translate-y-[-50%] translate-x-[-50%] bg-gray-50 dark:bg-dark-600 p-4 rounded-3xl">';
    echo '<div class="flex items-center justify-center">';
    echo '<div role="status" class="spinner my-6">
                        <svg aria-hidden="true" class="inline w-20 h-20 mr-2 text-gray-200 animate-spin dark:text-gray-600 fill-blue-500" viewBox="0 0 100 101" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path d="M100 50.5908C100 78.2051 77.6142 100.591 50 100.591C22.3858 100.591 0 78.2051 0 50.5908C0 22.9766 22.3858 0.59082 50 0.59082C77.6142 0.59082 100 22.9766 100 50.5908ZM9.08144 50.5908C9.08144 73.1895 27.4013 91.5094 50 91.5094C72.5987 91.5094 90.9186 73.1895 90.9186 50.5908C90.9186 27.9921 72.5987 9.67226 50 9.67226C27.4013 9.67226 9.08144 27.9921 9.08144 50.5908Z" fill="currentColor"/>
                            <path d="M93.9676 39.0409C96.393 38.4038 97.8624 35.9116 97.0079 33.5539C95.2932 28.8227 92.871 24.3692 89.8167 20.348C85.8452 15.1192 80.8826 10.7238 75.2124 7.41289C69.5422 4.10194 63.2754 1.94025 56.7698 1.05124C51.7666 0.367541 46.6976 0.446843 41.7345 1.27873C39.2613 1.69328 37.813 4.19778 38.4501 6.62326C39.0873 9.04874 41.5694 10.4717 44.0505 10.1071C47.8511 9.54855 51.7191 9.52689 55.5402 10.0491C60.8642 10.7766 65.9928 12.5457 70.6331 15.2552C75.2735 17.9648 79.3347 21.5619 82.5849 25.841C84.9175 28.9121 86.7997 32.2913 88.1811 35.8758C89.083 38.2158 91.5421 39.6781 93.9676 39.0409Z" fill="currentFill"/>
                        </svg>
                        <span class="sr-only">Loading...</span>
                    </div>';
    echo '</div>';
    echo '<div class="flex items-center justify-center">';
    echo '<p class="text-center">'.$lang['user-not-logged-in'].'</p>';
    echo '</div>';
    echo '</div>';

    // Debugging: Output the URL to check if it's correct
    $loginURL = url('/account/login');
    echo '<script>
        setTimeout(function() {
            window.location.href = "'.$loginURL.'";
        }, 1000); // Redirect after 2 seconds
    </script>';
// Set the intended destination to the current URL
    $_SESSION['intended_destination'] = $_SERVER['REQUEST_URI'];

// Check if the intended destination is the same as the login URL
    if ($_SESSION['intended_destination'] === $loginURL) {
        // Set the intended destination to the overview URL
        $_SESSION['intended_destination'] = url('/account/overview');
    }
    exit; // Make sure to exit to prevent further execution
}
$user_id = $_SESSION['user']['id']; // Get the user's ID from the session

function isPremiumUser($user_id, $conn) {
    $query = "SELECT is_premium FROM users WHERE user_id = ?";
    $stmt = mysqli_prepare($conn, $query);
    mysqli_stmt_bind_param($stmt, "i", $user_id);
    mysqli_stmt_execute($stmt);
    mysqli_stmt_bind_result($stmt, $isPremium);

    if (mysqli_stmt_fetch($stmt)) {
        return ['isPremium' => $isPremium];
    } else {
        return null; // User not found
    }
}
$getPremiumStatus = isPremiumUser($user_id, $conn);

// SQL query to count open tickets for a specific user
$querySupportUser = "SELECT COUNT(*) AS ticket_count FROM support_tickets WHERE user_id = ? AND (status = 'Open' OR status = 'In Progress')";
$queryInvoiceUser = "SELECT COUNT(*) AS invoice_count FROM invoices WHERE user_id = ? AND invoice_status = 'Unpaid'";

// Prepare and execute the query for open tickets
$stmt = $conn->prepare($querySupportUser);

$stmt->bind_param("i", $user_id);
$stmt->execute();

// Bind the result to a variable
$stmt->bind_result($openTicketCount);

// Fetch the result
$stmt->fetch();

// Close the statement for the first query
$stmt->close();

// Prepare and execute the second query for counting unpaid invoices
$stmtInvoice = $conn->prepare($queryInvoiceUser);

$stmtInvoice->bind_param("i", $user_id);
$stmtInvoice->execute();

// Bind the result to a variable
$stmtInvoice->bind_result($unpaidInvoiceCount);

// Fetch the result
$stmtInvoice->fetch();

// Close the statement for the second query
$stmtInvoice->close();

?>
<style>
    #bottom-banner{
        display: none!important;
    }
</style>
<div id="content">
    <div id="page-content">
        <div id="dashboard" class="antialiased bg-white dark:bg-dark-900">
            <nav class="bg-transparent backdrop-blur md:backdrop-blur-0 px-2 py-1 md:py-2 dark:border-gray-700 fixed left-0 right-0 top-0 z-40 md:px-4">
                <div class="flex flex-wrap justify-between items-center">
                    <div class="flex justify-start items-center">
                        <button data-drawer-target="drawer-navigation" data-drawer-toggle="drawer-navigation" aria-controls="drawer-navigation" class="p-2 mr-2 text-gray-600 rounded-lg cursor-pointer md:hidden hover:text-gray-900 hover:bg-gray-100 focus:bg-gray-100 dark:focus:bg-dark-700 focus:ring-2 focus:ring-gray-100 dark:focus:ring-dark-700 dark:text-gray-400 dark:hover:bg-dark-700 dark:hover:text-white">
                            <svg aria-hidden="true" class="w-6 h-6" fill="currentColor" viewBox="0 0 20 20" xmlns="http://www.w3.org/2000/svg">
                                <path fill-rule="evenodd" d="M3 5a1 1 0 011-1h12a1 1 0 110 2H4a1 1 0 01-1-1zM3 10a1 1 0 011-1h6a1 1 0 110 2H4a1 1 0 01-1-1zM3 15a1 1 0 011-1h12a1 1 0 110 2H4a1 1 0 01-1-1z" clip-rule="evenodd"></path>
                            </svg>
                            <svg aria-hidden="true" class="hidden w-6 h-6" fill="currentColor" viewBox="0 0 20 20" xmlns="http://www.w3.org/2000/svg">
                                <path fill-rule="evenodd" d="M4.293 4.293a1 1 0 011.414 0L10 8.586l4.293-4.293a1 1 0 111.414 1.414L11.414 10l4.293 4.293a1 1 0 01-1.414 1.414L10 11.414l-4.293 4.293a1 1 0 01-1.414-1.414L8.586 10 4.293 5.707a1 1 0 010-1.414z" clip-rule="evenodd"></path>
                            </svg>
                            <span class="sr-only">Toggle sidebar</span>
                        </button>
                        <a href="<?php echo url('/account/overview'); ?>" class="flex items-center md:mr-4">
                            <svg class="w-8 h-8" xmlns="http://www.w3.org/2000/svg"
                                 xmlns:xlink="http://www.w3.org/1999/xlink" width="151px" height="150px"
                                 viewBox="0 0 639 636">
                                <g id="surface1">
                                    <path style=" stroke:none;fill-rule:nonzero;fill-opacity:1;" class="fill-dark-950 dark:fill-gray-300" d="M 543.414062 80.550781 C 563.308594 100.46875 563.308594 132.765625 543.414062 152.683594 L 155.367188 541.199219 C 135.472656 561.121094 103.214844 561.121094 83.316406 541.199219 C 63.421875 521.28125 63.421875 488.984375 83.316406 469.066406 L 471.371094 80.558594 C 491.257812 60.628906 523.515625 60.628906 543.414062 80.550781 Z M 543.414062 80.550781 "/>
                                    <path style=" stroke:none;fill-rule:nonzero;fill-opacity:1;" class="fill-dark-950 dark:fill-gray-300" d="M 350.257812 83.671875 C 370.15625 103.589844 370.15625 135.886719 350.257812 155.804688 L 158.246094 348.046875 C 138.347656 367.964844 106.089844 367.964844 86.195312 348.046875 C 66.296875 328.125 66.296875 295.828125 86.195312 275.910156 L 278.207031 83.671875 C 298.097656 63.75 330.363281 63.75 350.257812 83.671875 Z M 350.257812 83.671875 "/>
                                    <path style=" stroke:none;fill-rule:nonzero;fill-opacity:1;" class="fill-dark-950 dark:fill-gray-300" d="M 198.839844 42.324219 C 218.734375 62.242188 218.734375 94.539062 198.839844 114.457031 L 116.90625 196.484375 C 97.011719 216.40625 64.753906 216.40625 44.855469 196.484375 C 24.960938 176.566406 24.960938 144.269531 44.855469 124.351562 L 126.78125 42.324219 C 146.679688 22.402344 178.941406 22.402344 198.839844 42.324219 Z M 198.839844 42.324219 "/>
                                    <path style=" stroke:none;fill-rule:nonzero;fill-opacity:1;" class="fill-dark-950 dark:fill-gray-300" d="M 549.855469 263.0625 C 569.75 282.984375 569.75 315.277344 549.855469 335.199219 L 337.238281 548.0625 C 317.34375 567.984375 285.085938 567.984375 265.1875 548.0625 C 245.292969 528.140625 245.292969 495.847656 265.1875 475.925781 L 477.804688 263.0625 C 497.699219 243.140625 529.957031 243.140625 549.855469 263.0625 Z M 549.855469 263.0625 "/>
                                    <path style=" stroke:none;fill-rule:nonzero;fill-opacity:1;" class="fill-dark-950 dark:fill-gray-300" d="M 578.785156 423.015625 C 598.683594 442.933594 598.683594 475.230469 578.785156 495.148438 L 496.855469 577.171875 C 476.957031 597.089844 444.699219 597.089844 424.804688 577.171875 C 404.90625 557.25 404.90625 524.953125 424.804688 505.035156 L 506.726562 423.015625 C 526.625 403.085938 558.890625 403.085938 578.785156 423.015625 Z M 578.785156 423.015625 "/>
                                </g>
                            </svg>
                            <?php
                            if ($getPremiumStatus['isPremium']) {
                                ?>
                                <h2 class="text-2xl ml-1 tracking-tight font-extrabold text-dark-950 dark:text-gray-300"><?php echo $lang['premium-headline']?></h2>
                                <?php
                            } else{
                            ?>
                                <h2 class="text-2xl ml-1 tracking-tight font-extrabold text-dark-950 dark:text-gray-300"><?php echo $lang['account-headline']?></h2>
                                <?php
                            }
                            ?>
                        </a>
                    </div>
                    <div class="flex items-center lg:order-2 p-2 bg-gray-100 dark:bg-dark-600 rounded-full">
                        <div class="flex-shrink-0">
                            <!-- Notifications -->
                            <button type="button" data-dropdown-toggle="notification-dropdown" class="flex items-center p-2 mr-1 text-gray-500 rounded-full hover:text-gray-900 hover:bg-gray-200 dark:text-gray-300 dark:hover:text-white dark:hover:bg-dark-700 focus:ring-4 focus:ring-gray-300 dark:focus:ring-gray-600">
                                <span class="sr-only">View notifications</span>
                                <!-- Bell icon -->
                                <svg aria-hidden="true" class="w-6 h-6" fill="currentColor" viewBox="0 0 20 20" xmlns="http://www.w3.org/2000/svg">
                                    <path d="M10 2a6 6 0 00-6 6v3.586l-.707.707A1 1 0 004 14h12a1 1 0 00.707-1.707L16 11.586V8a6 6 0 00-6-6zM10 18a3 3 0 01-3-3h6a3 3 0 01-3 3z"></path>
                                </svg>
                            </button>
                            <?php if ($unpaidInvoiceCount + $openTicketCount > 0): ?>
                                <div class="flex absolute justify-center items-center ml-6 -mt-9 w-5 h-5 text-white bg-red-700 dark:bg-red-800 rounded-full">
                                    <span class="material-symbols-outlined text-[14px]">priority_high</span>
                                </div>
                            <?php endif; ?>
                        </div>
                        <!-- Dropdown menu -->
                        <div class="hidden overflow-hidden z-50 my-4 max-w-sm text-base list-none bg-white rounded divide-y divide-gray-100 shadow-lg dark:divide-gray-600 dark:bg-dark-600 rounded-3xl w-[20em] !inset-x-[-0.5em]" id="notification-dropdown">
                            <div class="block py-2 px-4 text-base font-medium text-center text-gray-700 bg-gray-50 dark:bg-dark-700 dark:text-gray-300">
                                <?php echo $lang['notification-headline']; ?>
                            </div>
                            <div class="divide-y divide-gray-100 dark:divide-gray-600">
                                <!-- Unpaid Invoices -->
                                <?php if ($unpaidInvoiceCount > 0): ?>
                                    <a href="<?php echo url('/account/billing/invoices'); ?>" class="flex py-3 px-4 hover:bg-gray-50 dark:hover:bg-dark-500">
                                        <div class="flex-shrink-0">
                                            <div class="flex items-center justify-center w-11 h-11 rounded-full bg-gray-100 dark:bg-dark-400">
                                                <span class="material-symbols-outlined">receipt_long</span>
                                            </div>
                                            <div class="flex absolute justify-center items-center ml-6 -mt-5 w-5 h-5 text-white bg-red-700 dark:bg-red-800 rounded-full">
                                                <span class="material-symbols-outlined text-[14px]">priority_high</span>
                                            </div>
                                        </div>
                                        <div class="pl-3 w-full">
                                            <div class="text-gray-500 font-normal text-sm mb-1.5 dark:text-gray-400">
                                            <span class="font-semibold text-gray-900 dark:text-white">
                                                <?php echo sprintf($lang['unpaid-invoice-headline'], $unpaidInvoiceCount); ?>
                                            </span>
                                            </div>
                                            <div class="text-xs font-medium text-blue-600 dark:text-gray-300">
                                                <?php echo $lang['unpaid-invoice-subheading']; ?>
                                            </div>
                                        </div>
                                    </a>
                                <?php elseif ($unpaidInvoiceCount === 0): ?>
                                    <div class="flex py-3 px-4 hover:bg-gray-50 dark:hover:bg-dark-500">
                                        <div class="flex-shrink-0">
                                            <div class="flex items-center justify-center w-11 h-11 rounded-full bg-gray-100 dark:bg-dark-400">
                                                <span class="material-symbols-outlined">receipt_long</span>
                                            </div>
                                            <div class="flex absolute justify-center items-center ml-6 -mt-5 w-5 h-5 text-white bg-green-500 dark:bg-green-600 rounded-full">
                                                <span class="material-symbols-outlined text-[14px]">done</span>
                                            </div>
                                        </div>
                                        <div class="pl-3 w-full">
                                            <div class="text-gray-500 font-normal text-sm mb-1.5 dark:text-gray-400">
                                            <span class="font-semibold text-gray-900 dark:text-white">
                                                <?php echo $lang['no-unpaid-invoice-headline']; ?>
                                            </span>
                                            </div>
                                            <div class="text-xs font-medium text-blue-600 dark:text-gray-300">
                                                <?php echo $lang['no-unpaid-invoice-subheading']; ?>
                                            </div>
                                        </div>
                                    </div>
                                <?php endif; ?>

                                <!-- Open Support Cases -->
                                <?php if ($openTicketCount > 0): ?>
                                    <a href="<?php echo url('/account/support/requests'); ?>" class="flex py-3 px-4 hover:bg-gray-50 dark:hover:bg-dark-500">
                                        <div class="flex-shrink-0">
                                            <div class="flex items-center justify-center w-11 h-11 rounded-full bg-gray-100 dark:bg-dark-400">
                                                <span class="material-symbols-outlined">chat_bubble</span>
                                            </div>
                                            <div class="flex absolute justify-center items-center ml-6 -mt-5 w-5 h-5 text-white bg-yellow-700 dark:bg-yellow-800 rounded-full">
                                                <span class="material-symbols-outlined text-[14px]">priority_high</span>
                                            </div>
                                        </div>
                                        <div class="pl-3 w-full">
                                            <div class="text-gray-500 font-normal text-sm mb-1.5 dark:text-gray-400">
                                            <span class="font-semibold text-gray-900 dark:text-white">
                                                <?php echo sprintf($lang['open-support-case-headline'], $openTicketCount); ?>
                                            </span>
                                            </div>
                                            <div class="text-xs font-medium text-blue-600 dark:text-gray-300">
                                                <?php echo $lang['open-support-case-subheading']; ?>
                                            </div>
                                        </div>
                                    </a>
                                <?php elseif ($openTicketCount === 0): ?>
                                    <div class="flex py-3 px-4 hover:bg-gray-50 dark:hover:bg-dark-500">
                                        <div class="flex-shrink-0">
                                            <div class="flex items-center justify-center w-11 h-11 rounded-full bg-gray-100 dark:bg-dark-400">
                                                <span class="material-symbols-outlined">chat_bubble</span>
                                            </div>
                                            <div class="flex absolute justify-center items-center ml-6 -mt-5 w-5 h-5 text-white bg-green-500 dark:bg-green-600 rounded-full">
                                                <span class="material-symbols-outlined text-[14px]">done</span>
                                            </div>
                                        </div>
                                        <div class="pl-3 w-full">
                                            <div class="text-gray-500 font-normal text-sm mb-1.5 dark:text-gray-400">
                                            <span class="font-semibold text-gray-900 dark:text-white">
                                                <?php echo $lang['no-open-support-case-headline']; ?>
                                            </span>
                                            </div>
                                            <div class="text-xs font-medium text-blue-600 dark:text-gray-300">
                                                <?php echo $lang['no-open-support-case-subheading']; ?>
                                            </div>
                                        </div>
                                    </div>
                                <?php endif; ?>
                            </div>


                        </div>
                        <!-- Apps -->
                        <button type="button" data-modal-target="settings-modal" data-modal-toggle="settings-modal" class="flex items-center p-2 text-gray-500 rounded-full hover:text-gray-900 hover:bg-gray-200 dark:text-gray-300 dark:hover:text-white dark:hover:bg-dark-700 focus:ring-4 focus:ring-gray-300 dark:focus:ring-gray-600">
                            <span class="sr-only">Settings</span>
                            <!-- Icon -->
                            <svg
                                    aria-hidden="true"
                                    class="w-6 h-6"
                                    fill="currentColor"
                                    viewBox="0 0 20 20"
                                    xmlns="http://www.w3.org/2000/svg"
                            >
                                <path
                                        fill-rule="evenodd"
                                        d="M11.49 3.17c-.38-1.56-2.6-1.56-2.98 0a1.532 1.532 0 01-2.286.948c-1.372-.836-2.942.734-2.106 2.106.54.886.061 2.042-.947 2.287-1.561.379-1.561 2.6 0 2.978a1.532 1.532 0 01.947 2.287c-.836 1.372.734 2.942 2.106 2.106a1.532 1.532 0 012.287.947c.379 1.561 2.6 1.561 2.978 0a1.533 1.533 0 012.287-.947c1.372.836 2.942-.734 2.106-2.106a1.533 1.533 0 01.947-2.287c1.561-.379 1.561-2.6 0-2.978a1.532 1.532 0 01-.947-2.287c.836-1.372-.734-2.942-2.106-2.106a1.532 1.532 0 01-2.287-.947zM10 13a3 3 0 100-6 3 3 0 000 6z"
                                        clip-rule="evenodd"
                                ></path>
                            </svg>
                        </button>
                        <?php if ($_SESSION['userLoggedIn']): ?>
                            <div class="flex ml-3 items-center md:order-2">
                                <button type="button"
                                        class="flex mr-3 text-sm bg-dark-800 rounded-full md:mr-0 focus:ring-4 focus:ring-gray-300 dark:focus:ring-gray-600"
                                        id="user-menu-button" aria-expanded="false" data-dropdown-toggle="user-dropdown"
                                        data-dropdown-placement="bottom">
                                    <span class="sr-only">Open user menu</span>
                                    <span class="relative inline-flex items-center justify-center w-9 h-9 overflow-hidden bg-gray-100 rounded-full dark:bg-dark-800">
                                    <span class="font-medium text-gray-600 dark:text-gray-300"><?php echo $this_userAvatar; ?></span>
                                </span>
                                </button>
                                <!-- Dropdown menu -->
                                <div class="z-50 hidden my-4 mr-5 text-base list-none bg-white divide-y divide-gray-100 rounded-3xl shadow dark:bg-dark-600 dark:divide-gray-600 w-[20em] !inset-x-[-0.5em] overflow-hidden"
                                     id="user-dropdown">
                                    <div class="py-3 px-4 m-2 rounded-3xl bg-gray-100 dark:bg-dark-500 w-[95%]">
                                        <div class="flex w-full items-center justify-between">
                                            <div class="flex w-full items-center">
                                                <div class="relative inline-flex items-center justify-center w-[3.5em] h-[3.5em] mr-2 overflow-hidden bg-gray-100 rounded-full dark:bg-dark-600">
                                                    <span class="font-medium text-gray-600 dark:text-gray-300 profile__picture"><?php echo $this_userAvatar; ?></span>
                                                </div>
                                                <div>
                        <span class="block text-sm font-semibold text-gray-900 dark:text-white">
                            <?php echo $this_name; ?>
                        </span>
                                                    <span class="flex text-sm text-gray-900 truncate dark:text-white items-center">
                                                    <?php
                                                    if (!empty($this_username)) {
                                                        echo '@' . $this_username;
                                                        if (!empty($this_verificationBadge)) {
                                                            echo $this_verificationBadge;
                                                        }
                                                    }
                                                    ?>
                        </span>
                                                </div>
                                            </div>
                                            <div class="flex items-center justify-end">
                                                <a href="<?php echo url('/account/profile/update'); ?>"
                                                   class="flex w-full text-center text-white bg-dark-700 hover:bg-dark-800 focus:ring-0 font-medium rounded-full text-sm p-3 dark:bg-dark-700 dark:hover:bg-dark-800 focus:outline-none">
                                                    <svg class="w-5 h-5" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24">
                                                        <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="m14.3 4.8 2.9 2.9M7 7H4a1 1 0 0 0-1 1v10c0 .6.4 1 1 1h11c.6 0 1-.4 1-1v-4.5m2.4-10a2 2 0 0 1 0 3l-6.8 6.8L8 14l.7-3.6 6.9-6.8a2 2 0 0 1 2.8 0Z"/>
                                                    </svg>
                                                    <span class="sr-only"><?php echo $lang['manage-your-account']; ?></span>
                                                </a>
                                            </div>
                                        </div>
                                    </div>
                                    <ul class="py-2 w-full" aria-labelledby="user-menu-button">
                                        <li>
                                            <a href="<?php echo url(''); ?>"
                                               class="flex items-center  px-4 py-2 text-sm text-gray-700 hover:bg-gray-100 dark:hover:bg-dark-500 dark:text-gray-200 dark:hover:text-white"><span
                                                        class="material-symbols-outlined mr-3 -scale-y-100">reply</span><?php echo $lang['return-to-website'] ?></a>
                                        </li>
                                        <li>
                                            <form method="POST" class="logout-action">
                                                <button class="flex w-full items-center px-4 py-2 text-sm text-gray-700 hover:bg-gray-100 dark:hover:bg-dark-500 dark:text-gray-200 dark:hover:text-white"
                                                        type="submit"><span
                                                            class="material-symbols-outlined mr-3">logout</span><?php echo $lang['sign-out'] ?>
                                                </button>
                                            </form>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                        <?php else: ?>
                            <div class="flex ml-3 items-center md:order-2">
                                <button type="button"
                                        class="flex mr-3 text-sm bg-dark-800 rounded-full md:mr-0 focus:ring-4 focus:ring-gray-300 dark:focus:ring-gray-600"
                                        id="user-menu-button" aria-expanded="false" data-dropdown-toggle="user-dropdown"
                                        data-dropdown-placement="bottom">
                                    <span class="sr-only">Open user menu</span>
                                    <span class="relative inline-flex items-center justify-center w-9 h-9 overflow-hidden bg-gray-100 rounded-full dark:bg-dark-800">
                                    <span class="font-medium text-gray-600 dark:text-gray-300">
                                        <span class="relative inline-flex items-center justify-center w-9 h-9 overflow-hidden bg-gray-100 rounded-full dark:bg-dark-600">
                                            <span class="material-symbols-outlined">person</span>
                                        </span></span>
                                </span>
                                </button>

                                <!-- Dropdown menu -->
                                <div class="z-50 hidden my-4 mr-5 text-base list-none bg-white divide-y divide-gray-100 rounded-xl shadow dark:bg-dark-800 dark:divide-dark-800 rounded-xl w-[20em] !inset-x-[-0.5em]"
                                     id="user-dropdown">
                                    <ul class="py-2 w-full" aria-labelledby="user-menu-button">
                                        <li>
                                            <a href="<?php echo url('/account/login'); ?>"
                                               class="flex items-center px-4 py-2 text-sm text-gray-700 hover:bg-gray-100 dark:hover:bg-dark-900 dark:text-gray-200 dark:hover:text-white"><span
                                                        class="material-symbols-outlined mr-3">login</span><?php echo $lang['login'] ?></a>
                                        </li>
                                        <li>
                                            <a href="<?php echo url('/account/create'); ?>"
                                               class="flex items-center px-4 py-2 text-sm text-gray-700 hover:bg-gray-100 dark:hover:bg-dark-900 dark:text-gray-200 dark:hover:text-white"><span
                                                        class="material-symbols-outlined mr-3">person_add</span><?php echo $lang['create-datanito-account'] ?></a>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </nav>

            <!-- Sidebar -->
            <?php
            if ($currentCountry === 'tr') {
                $accountURL = '/tr/account';
            } else {
                $accountURL = '/account'; // Change this line if you want different behavior for non-'tr' countries
            }
            if ($currentCountry === 'tr') {
                $adminURL = '/tr/admin';
            } else {
                $adminURL = '/admin'; // Change this line if you want different behavior for non-'tr' countries
            }
            ?>
            <aside class="fixed top-0 left-0 z-[39] w-64 h-screen pt-14 transition-transform -translate-x-full bg-gray-100 md:translate-x-0 dark:bg-dark-700 md:block pb-16" aria-label="Sidenav" id="drawer-navigation">
                <div class="overflow-y-auto py-5 px-3 h-full bg-gray-100 dark:bg-dark-700">
                    <ul class="space-y-2">
                        <li>
                            <a href="<?php echo url('/account/overview'); ?>" class="<?php echo (strpos($URL, $accountURL.'/overview') === 0 || $URL === $accountURL.'/overview') ? '!bg-white dark:!bg-dark-600' : ''; ?>  flex w-full items-center font-medium text-gray-600 dark:text-gray-300 bg-gray-100 dark:bg-dark-700 hover:bg-white dark:hover:bg-dark-600 p-1.5 rounded-3xl cursor-pointer whitespace-nowrap">
                                <div class="flex items-center justify-center text-sm mr-4 w-8 h-8 bg-gray-200 dark:bg-dark-500 rounded-full"><span class="material-symbols-outlined text-xl">dashboard</span></div>
                                <span><?php echo $lang['account-overview']?></span>
                            </a>
                        </li>
                        <li>
                            <a href="<?php echo url('/account/solutions'); ?>" class="<?php echo (strpos($URL, $accountURL.'/solutions') === 0 || $URL === $accountURL.'/solutions') ? '!bg-white dark:!bg-dark-600' : ''; ?>  flex w-full items-center font-medium text-gray-600 dark:text-gray-300 bg-gray-100 dark:bg-dark-700 hover:bg-white dark:hover:bg-dark-600 p-1.5 rounded-3xl cursor-pointer whitespace-nowrap">
                                <div class="flex items-center justify-center text-sm mr-4 w-8 h-8 bg-gray-200 dark:bg-dark-500 rounded-full"><span class="material-symbols-outlined text-xl">lightbulb</span></div>
                                <span><?php echo $lang['solutions']?></span>
                            </a>
                        </li>
                        <li>
                            <a href="<?php echo url('/account/cloud'); ?>" class="<?php echo (strpos($URL, $accountURL.'/cloud') === 0 || $URL === $accountURL.'/cloud') ? '!bg-white dark:!bg-dark-600' : ''; ?>  flex w-full items-center font-medium text-gray-600 dark:text-gray-300 bg-gray-100 dark:bg-dark-700 hover:bg-white dark:hover:bg-dark-600 p-1.5 rounded-3xl cursor-pointer whitespace-nowrap">
                                <div class="flex items-center justify-center text-sm mr-4 w-8 h-8 bg-gray-200 dark:bg-dark-500 rounded-full"><span class="material-symbols-outlined text-xl">cloud</span></div>
                                <span><?php echo $lang['cloud']?></span>
                            </a>
                        </li>
                        <li>
                            <a href="<?php echo url('/account/domains'); ?>" class="<?php echo (strpos($URL, $accountURL.'/domains') === 0 || $URL === $accountURL.'/domains') ? '!bg-white dark:!bg-dark-600' : ''; ?>  flex w-full items-center font-medium text-gray-600 dark:text-gray-300 bg-gray-100 dark:bg-dark-700 hover:bg-white dark:hover:bg-dark-600 p-1.5 rounded-3xl cursor-pointer whitespace-nowrap">
                                <div class="flex items-center justify-center text-sm mr-4 w-8 h-8 bg-gray-200 dark:bg-dark-500 rounded-full"><span class="material-symbols-outlined text-xl">domain</span></div>
                                <span><?php echo $lang['domain']?></span>
                            </a>
                        </li>
                    </ul>
                    <hr class="w-full h-0.5 mx-auto my-6 bg-gray-100 border-0 rounded dark:bg-dark-700">

                    <ul class="space-y-2">
                        <li>
                            <a href="<?php echo url('/account/pay'); ?>" class="<?php echo (strpos($URL, $accountURL.'/pay') === 0 || $URL === $accountURL.'/pay') ? '!bg-white dark:!bg-dark-600' : ''; ?>  flex w-full items-center font-medium text-gray-600 dark:text-gray-300 bg-gray-100 dark:bg-dark-700 hover:bg-white dark:hover:bg-dark-600 p-1.5 rounded-3xl cursor-pointer whitespace-nowrap">
                                <div class="flex items-center justify-center text-sm mr-4 w-8 h-8 bg-gray-200 dark:bg-dark-500 rounded-full"><span class="material-symbols-outlined text-xl">credit_card</span></div>
                                <span><?php echo $lang['datanito-pay-title']?></span>
                            </a>
                        </li>
                        <li>
                            <a href="<?php echo url('/account/analytics'); ?>" class="<?php echo (strpos($URL, $accountURL.'/analytics') === 0 || $URL === $accountURL.'/analytics') ? '!bg-white dark:!bg-dark-600' : ''; ?>  flex w-full items-center font-medium text-gray-600 dark:text-gray-300 bg-gray-100 dark:bg-dark-700 hover:bg-white dark:hover:bg-dark-600 p-1.5 rounded-3xl cursor-pointer whitespace-nowrap">
                                <div class="flex items-center justify-center text-sm mr-4 w-8 h-8 bg-gray-200 dark:bg-dark-500 rounded-full"><span class="material-symbols-outlined text-xl">analytics</span></div>
                                <span><?php echo $lang['datanito-analytics']?></span>
                            </a>
                        </li>
                        <li>
                            <a href="<?php echo url('/account/dino'); ?>" class="<?php echo (strpos($URL, $accountURL.'/dino') === 0 || $URL === $accountURL.'/dino') ? '!bg-white dark:!bg-dark-600' : ''; ?>  flex w-full items-center font-medium text-gray-600 dark:text-gray-300 bg-gray-100 dark:bg-dark-700 hover:bg-white dark:hover:bg-dark-600 p-1.5 rounded-3xl cursor-pointer whitespace-nowrap">
                                <div class="flex items-center justify-center text-sm mr-4 w-8 h-8 bg-gray-200 dark:bg-dark-500 rounded-full">
                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor" class="w-5 h-5 text-gray-600 transition duration-75 dark:text-gray-300">
                                        <path fill-rule="evenodd"
                                              d="M9 4.5a.75.75 0 01.721.544l.813 2.846a3.75 3.75 0 002.576 2.576l2.846.813a.75.75 0 010 1.442l-2.846.813a3.75 3.75 0 00-2.576 2.576l-.813 2.846a.75.75 0 01-1.442 0l-.813-2.846a3.75 3.75 0 00-2.576-2.576l-2.846-.813a.75.75 0 010-1.442l2.846-.813A3.75 3.75 0 007.466 7.89l.813-2.846A.75.75 0 019 4.5zM18 1.5a.75.75 0 01.728.568l.258 1.036c.236.94.97 1.674 1.91 1.91l1.036.258a.75.75 0 010 1.456l-1.036.258c-.94.236-1.674.97-1.91 1.91l-.258 1.036a.75.75 0 01-1.456 0l-.258-1.036a2.625 2.625 0 00-1.91-1.91l-1.036-.258a.75.75 0 010-1.456l1.036-.258a2.625 2.625 0 001.91-1.91l.258-1.036A.75.75 0 0118 1.5zM16.5 15a.75.75 0 01.712.513l.394 1.183c.15.447.5.799.948.948l1.183.395a.75.75 0 010 1.422l-1.183.395c-.447.15-.799.5-.948.948l-.395 1.183a.75.75 0 01-1.422 0l-.395-1.183a1.5 1.5 0 00-.948-.948l-1.183-.395a.75.75 0 010-1.422l1.183-.395c.447-.15.799-.5.948-.948l.395-1.183A.75.75 0 0116.5 15z"
                                              clip-rule="evenodd"></path>
                                    </svg>
                                </div>
                                <span class="flex-1 whitespace-nowrap"><?php echo $lang['dino']?></span>
                                <span class="inline-flex justify-center items-center w-6 h-6 text-xs font-semibold rounded-lg p-2 bg-dark-800 dark:bg-dark-400">
                                    <?php echo $lang['account-dino-ai']?>
                                </span>
                            </a>
                        </li>
                    </ul>
                    <hr class="w-full h-0.5 mx-auto my-6 bg-gray-100 border-0 rounded dark:bg-dark-700">

                    <ul class="space-y-2">
                        <li>
                            <button type="button" class="flex w-full items-center font-medium text-gray-600 dark:text-gray-300 bg-gray-100 dark:bg-dark-700 hover:bg-white dark:hover:bg-dark-600 p-1.5 rounded-3xl cursor-pointer whitespace-nowrap" aria-controls="dropdown-billing" data-collapse-toggle="dropdown-billing">
                                <span class="flex items-center justify-center text-sm mr-4 w-8 h-8 bg-gray-200 dark:bg-dark-500 rounded-full"><span class="material-symbols-outlined text-xl">wallet</span></span>
                                <span class="flex-1 text-left whitespace-nowrap"><?php echo $lang['account-billing']?></span>
                                <svg aria-hidden="true" class="w-6 h-6" fill="currentColor" viewBox="0 0 20 20" xmlns="http://www.w3.org/2000/svg">
                                    <path fill-rule="evenodd" d="M5.293 7.293a1 1 0 011.414 0L10 10.586l3.293-3.293a1 1 0 111.414 1.414l-4 4a1 1 0 01-1.414 0l-4-4a1 1 0 010-1.414z" clip-rule="evenodd"></path>
                                </svg>
                            </button>
                            <ul id="dropdown-billing" class="<?php echo (strpos($URL, $accountURL.'/billing') === 0 || $URL === $accountURL.'/billing') ? '' : 'hidden'; ?> py-2 space-y-2">
                                <li>
                                    <a href="<?php echo url('/account/billing/invoices'); ?>" class="<?php echo (strpos($URL, $accountURL.'/billing') === 0 || $URL === $accountURL.'/billing') ? '!bg-white dark:!bg-dark-600' : ''; ?> flex w-[96%] items-center ml-2 p-3 font-medium text-gray-600 dark:text-gray-300 bg-gray-100 dark:bg-dark-700 hover:bg-white dark:hover:bg-dark-600 p-1.5 rounded-3xl cursor-pointer whitespace-nowrap"><?php echo $lang['account-invoices']?></a>
                                </li>
                            </ul>
                        </li>
                        <li>
                            <button type="button" class="flex w-full items-center font-medium text-gray-600 dark:text-gray-300 bg-gray-100 dark:bg-dark-700 hover:bg-white dark:hover:bg-dark-600 p-1.5 rounded-3xl cursor-pointer whitespace-nowrap" aria-controls="dropdown-support" data-collapse-toggle="dropdown-support">
                                <span class="flex items-center justify-center text-sm mr-4 w-8 h-8 bg-gray-200 dark:bg-dark-500 rounded-full"><span class="material-symbols-outlined text-xl">support</span></span>
                                <span class="flex-1 text-left whitespace-nowrap"><?php echo $lang['account-support']?></span>
                                <svg aria-hidden="true" class="w-6 h-6" fill="currentColor" viewBox="0 0 20 20" xmlns="http://www.w3.org/2000/svg">
                                    <path fill-rule="evenodd" d="M5.293 7.293a1 1 0 011.414 0L10 10.586l3.293-3.293a1 1 0 111.414 1.414l-4 4a1 1 0 01-1.414 0l-4-4a1 1 0 010-1.414z" clip-rule="evenodd"></path>
                                </svg>
                            </button>
                            <ul id="dropdown-support" class="<?php echo (strpos($URL, $accountURL.'/support') === 0 || $URL === $accountURL.'/support') ? '' : 'hidden'; ?> py-2 space-y-2">
                                <li>
                                    <a href="<?php echo url('/account/support/requests'); ?>" class="<?php echo (strpos($URL, '/account/support/requests') === 0 || $URL === '/account/support/requests') ? '!bg-white dark:!bg-dark-600' : ''; ?> flex w-[96%] items-center ml-2 p-3 font-medium text-gray-600 dark:text-gray-300 bg-gray-100 dark:bg-dark-700 hover:bg-white dark:hover:bg-dark-600 p-1.5 rounded-3xl cursor-pointer whitespace-nowrap"><?php echo $lang['account-support-requests']?></a>
                                </li>
                                <li>
                                    <a href="<?php echo url('/account/support/new'); ?>" class="<?php echo (strpos($URL, '/account/support/new') === 0 || $URL === '/account/support/new') ? '!bg-white dark:!bg-dark-600' : ''; ?> flex w-[96%] items-center ml-2 p-3 font-medium text-gray-600 dark:text-gray-300 bg-gray-100 dark:bg-dark-700 hover:bg-white dark:hover:bg-dark-600 p-1.5 rounded-3xl cursor-pointer whitespace-nowrap"><?php echo $lang['account-support-new']?></a>
                                </li>
                            </ul>
                        </li>
                        <li>
                            <a type="button" data-modal-target="datanito-premium-modal" data-modal-toggle="datanito-premium-modal" class="flex w-full items-center font-medium text-gray-600 dark:text-gray-300 bg-gray-100 dark:bg-dark-700 hover:bg-white dark:hover:bg-dark-600 p-1.5 rounded-3xl cursor-pointer whitespace-nowrap">
                                <div class="flex items-center justify-center text-sm mr-4 w-8 h-8 bg-gray-200 dark:bg-dark-500 rounded-full">
                                    <svg class="w-5 h-5" xmlns="http://www.w3.org/2000/svg"
                                         xmlns:xlink="http://www.w3.org/1999/xlink" width="151px" height="150px"
                                         viewBox="0 0 639 636">
                                        <g id="surface1">
                                            <path style=" stroke:none;fill-rule:nonzero;fill-opacity:1;" class="fill-gray-700 dark:fill-gray-300" d="M 543.414062 80.550781 C 563.308594 100.46875 563.308594 132.765625 543.414062 152.683594 L 155.367188 541.199219 C 135.472656 561.121094 103.214844 561.121094 83.316406 541.199219 C 63.421875 521.28125 63.421875 488.984375 83.316406 469.066406 L 471.371094 80.558594 C 491.257812 60.628906 523.515625 60.628906 543.414062 80.550781 Z M 543.414062 80.550781 "/>
                                            <path style=" stroke:none;fill-rule:nonzero;fill-opacity:1;" class="fill-gray-700 dark:fill-gray-300" d="M 350.257812 83.671875 C 370.15625 103.589844 370.15625 135.886719 350.257812 155.804688 L 158.246094 348.046875 C 138.347656 367.964844 106.089844 367.964844 86.195312 348.046875 C 66.296875 328.125 66.296875 295.828125 86.195312 275.910156 L 278.207031 83.671875 C 298.097656 63.75 330.363281 63.75 350.257812 83.671875 Z M 350.257812 83.671875 "/>
                                            <path style=" stroke:none;fill-rule:nonzero;fill-opacity:1;" class="fill-gray-700 dark:fill-gray-300" d="M 198.839844 42.324219 C 218.734375 62.242188 218.734375 94.539062 198.839844 114.457031 L 116.90625 196.484375 C 97.011719 216.40625 64.753906 216.40625 44.855469 196.484375 C 24.960938 176.566406 24.960938 144.269531 44.855469 124.351562 L 126.78125 42.324219 C 146.679688 22.402344 178.941406 22.402344 198.839844 42.324219 Z M 198.839844 42.324219 "/>
                                            <path style=" stroke:none;fill-rule:nonzero;fill-opacity:1;" class="fill-gray-700 dark:fill-gray-300" d="M 549.855469 263.0625 C 569.75 282.984375 569.75 315.277344 549.855469 335.199219 L 337.238281 548.0625 C 317.34375 567.984375 285.085938 567.984375 265.1875 548.0625 C 245.292969 528.140625 245.292969 495.847656 265.1875 475.925781 L 477.804688 263.0625 C 497.699219 243.140625 529.957031 243.140625 549.855469 263.0625 Z M 549.855469 263.0625 "/>
                                            <path style=" stroke:none;fill-rule:nonzero;fill-opacity:1;" class="fill-gray-700 dark:fill-gray-300" d="M 578.785156 423.015625 C 598.683594 442.933594 598.683594 475.230469 578.785156 495.148438 L 496.855469 577.171875 C 476.957031 597.089844 444.699219 597.089844 424.804688 577.171875 C 404.90625 557.25 404.90625 524.953125 424.804688 505.035156 L 506.726562 423.015625 C 526.625 403.085938 558.890625 403.085938 578.785156 423.015625 Z M 578.785156 423.015625 "/>
                                        </g>
                                    </svg>
                                </div>
                                <span class="flex-1 whitespace-nowrap">Premium</span>
                                <svg class="w-4 h-4" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 16 16">
                                    <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 1h4m0 0v4m0-4-5 5.243M5 15H1m0 0v-4m0 4 5.243-5"/>
                                </svg>
                            </a>
                        </li>
                    </ul>
                    <?php if ($this_role === 'admin'):
                        // SQL query to count open tickets
                        $querySupport = "SELECT COUNT(*) AS open_ticket_count FROM support_tickets WHERE (status = 'Open' OR status = 'In Progress')";

                        // Prepare and execute the query
                        $stmt = $conn->prepare($querySupport);
                        $stmt->execute();

                        // Bind the result to a variable
                        $stmt->bind_result($openTicketCount);

                        // Fetch the result
                        $stmt->fetch();

                        // Close the statement
                        $stmt->close();
                        ?>
                        <div class="flex justify-between items-center bg-gray-200 dark:bg-dark-600 py-2 rounded-3xl px-4 mt-6">
                            <span class="material-symbols-outlined">lock</span>
                            <p class="text-center text-gray-600 dark:text-gray-200 font-semibold">Admin</p>
                            <button class="toggleAdminButton flex justify-center items-center"><span class="material-symbols-outlined text-lg">visibility</span></button>
                        </div>
                        <ul class="adminArea pt-5 space-y-2">
                            <li>
                                <a href="<?php echo url('/admin'); ?>" class="<?php echo (strpos($URL, $accountURL.'/admin') === 0 || $URL === $accountURL.'/admin') ? '!bg-white dark:!bg-dark-600' : ''; ?>  flex w-full items-center font-medium text-gray-600 dark:text-gray-300 bg-gray-100 dark:bg-dark-700 hover:bg-white dark:hover:bg-dark-600 p-1.5 rounded-3xl cursor-pointer whitespace-nowrap">
                                    <div class="flex items-center justify-center text-sm mr-4 w-8 h-8 bg-gray-200 dark:bg-dark-500 rounded-full"><span class="material-symbols-outlined text-xl">dashboard</span></div>
                                    <span><?php echo $lang['account-overview']?></span>
                                </a>
                            </li>
                            <li>
                                <button type="button" class="flex w-full items-center font-medium text-gray-600 dark:text-gray-300 bg-gray-100 dark:bg-dark-700 hover:bg-white dark:hover:bg-dark-600 p-1.5 rounded-3xl cursor-pointer whitespace-nowrap" aria-controls="dropdown-blog-admin" data-collapse-toggle="dropdown-blog-admin">
                                    <span class="flex items-center justify-center text-sm mr-4 w-8 h-8 bg-gray-200 dark:bg-dark-500 rounded-full"><span class="material-symbols-outlined text-xl">local_library</span></span>
                                    <span class="flex-1 text-left whitespace-nowrap">Blog</span>
                                    <svg aria-hidden="true" class="w-6 h-6" fill="currentColor" viewBox="0 0 20 20" xmlns="http://www.w3.org/2000/svg">
                                        <path fill-rule="evenodd" d="M5.293 7.293a1 1 0 011.414 0L10 10.586l3.293-3.293a1 1 0 111.414 1.414l-4 4a1 1 0 01-1.414 0l-4-4a1 1 0 010-1.414z" clip-rule="evenodd"></path>
                                    </svg>
                                </button>
                                <ul id="dropdown-blog-admin" class="hidden py-2 space-y-2">
                                    <li>
                                        <a href="<?php echo url('/admin/blog'); ?>" class="<?php echo (strpos($URL, '/admin/blog') === 0 || $URL === '/admin/blog') ? '!bg-white dark:!bg-dark-600' : ''; ?> flex w-[96%] items-center ml-2 p-3 font-medium text-gray-600 dark:text-gray-300 bg-gray-100 dark:bg-dark-700 hover:bg-white dark:hover:bg-dark-600 p-1.5 rounded-3xl cursor-pointer whitespace-nowrap">Archive</a>
                                    </li>
                                    <li>
                                        <a href="<?php echo url('/admin/blog/new'); ?>" class="<?php echo (strpos($URL, '/admin/blog/new') === 0 || $URL === '/admin/blog/new') ? '!bg-white dark:!bg-dark-600' : ''; ?> flex w-[96%] items-center ml-2 p-3 font-medium text-gray-600 dark:text-gray-300 bg-gray-100 dark:bg-dark-700 hover:bg-white dark:hover:bg-dark-600 p-1.5 rounded-3xl cursor-pointer whitespace-nowrap">Add New</a>
                                    </li>
                                    <li>
                                        <a href="<?php echo url('/admin/blog/category'); ?>" class="<?php echo (strpos($URL, '/admin/blog/category') === 0 || $URL === '/admin/blog/category') ? '!bg-white dark:!bg-dark-600' : ''; ?> flex w-[96%] items-center ml-2 p-3 font-medium text-gray-600 dark:text-gray-300 bg-gray-100 dark:bg-dark-700 hover:bg-white dark:hover:bg-dark-600 p-1.5 rounded-3xl cursor-pointer whitespace-nowrap">Category</a>
                                    </li>
                                </ul>
                            </li>
                            <li>
                                <button type="button" class="flex w-full items-center font-medium text-gray-600 dark:text-gray-300 bg-gray-100 dark:bg-dark-700 hover:bg-white dark:hover:bg-dark-600 p-1.5 rounded-3xl cursor-pointer whitespace-nowrap" aria-controls="dropdown-operations-admin" data-collapse-toggle="dropdown-operations-admin">
                                    <span class="flex items-center justify-center text-sm mr-4 w-8 h-8 bg-gray-200 dark:bg-dark-500 rounded-full"><span class="material-symbols-outlined text-xl">category</span></span>
                                    <span class="flex-1 text-left whitespace-nowrap">Operations</span>
                                    <svg aria-hidden="true" class="w-6 h-6" fill="currentColor" viewBox="0 0 20 20" xmlns="http://www.w3.org/2000/svg">
                                        <path fill-rule="evenodd" d="M5.293 7.293a1 1 0 011.414 0L10 10.586l3.293-3.293a1 1 0 111.414 1.414l-4 4a1 1 0 01-1.414 0l-4-4a1 1 0 010-1.414z" clip-rule="evenodd"></path>
                                    </svg>
                                </button>
                                <ul id="dropdown-operations-admin" class="hidden py-2 space-y-2">
                                    <li>
                                        <a href="<?php echo url('/admin/leads'); ?>" class="<?php echo (strpos($URL, '/admin/leads') === 0 || $URL === '/admin/leads') ? '!bg-white dark:!bg-dark-600' : ''; ?> flex w-[96%] items-center ml-2 p-3 font-medium text-gray-600 dark:text-gray-300 bg-gray-100 dark:bg-dark-700 hover:bg-white dark:hover:bg-dark-600 p-1.5 rounded-3xl cursor-pointer whitespace-nowrap">Leads</a>
                                    </li>
                                    <li>
                                        <a href="<?php echo url('/admin/products'); ?>" class="<?php echo (strpos($URL, '/admin/products') === 0 || $URL === '/admin/products') ? '!bg-white dark:!bg-dark-600' : ''; ?> flex w-[96%] items-center ml-2 p-3 font-medium text-gray-600 dark:text-gray-300 bg-gray-100 dark:bg-dark-700 hover:bg-white dark:hover:bg-dark-600 p-1.5 rounded-3xl cursor-pointer whitespace-nowrap"><?php echo $lang['account-products']?></a>
                                    </li>
                                    <li>
                                        <a href="<?php echo url('/admin/users'); ?>" class="<?php echo (strpos($URL, '/admin/users') === 0 || $URL === '/admin/users') ? '!bg-white dark:!bg-dark-600' : ''; ?> flex w-[96%] items-center ml-2 p-3 font-medium text-gray-600 dark:text-gray-300 bg-gray-100 dark:bg-dark-700 hover:bg-white dark:hover:bg-dark-600 p-1.5 rounded-3xl cursor-pointer whitespace-nowrap">Users</a>
                                    </li>
                                    <li>
                                        <a href="<?php echo url('/admin/sms/send'); ?>" class="<?php echo (strpos($URL, '/admin/sms/send') === 0 || $URL === '/admin/sms/send') ? '!bg-white dark:!bg-dark-600' : ''; ?> flex w-[96%] items-center ml-2 p-3 font-medium text-gray-600 dark:text-gray-300 bg-gray-100 dark:bg-dark-700 hover:bg-white dark:hover:bg-dark-600 p-1.5 rounded-3xl cursor-pointer whitespace-nowrap">Send Sms</a>
                                    </li>
                                    <li>
                                        <a href="<?php echo url('/admin/email/send'); ?>" class="<?php echo (strpos($URL, '/admin/email/send') === 0 || $URL === '/admin/email/send') ? '!bg-white dark:!bg-dark-600' : ''; ?> flex w-[96%] items-center ml-2 p-3 font-medium text-gray-600 dark:text-gray-300 bg-gray-100 dark:bg-dark-700 hover:bg-white dark:hover:bg-dark-600 p-1.5 rounded-3xl cursor-pointer whitespace-nowrap">Send email</a>
                                    </li>
                                </ul>
                            </li>
                            <li>
                                <button type="button" class="flex w-full items-center font-medium text-gray-600 dark:text-gray-300 bg-gray-100 dark:bg-dark-700 hover:bg-white dark:hover:bg-dark-600 p-1.5 rounded-3xl cursor-pointer whitespace-nowrap" aria-controls="dropdown-support-admin" data-collapse-toggle="dropdown-support-admin">
                                    <span class="flex items-center justify-center text-sm mr-4 w-8 h-8 bg-gray-200 dark:bg-dark-500 rounded-full"><span class="material-symbols-outlined text-xl">support</span></span>
                                    <span class="flex-1 text-left whitespace-nowrap"><?php echo $lang['account-support']?></span><span class="inline-flex justify-center items-center w-6 h-6 text-xs font-semibold rounded-full text-blue-800 bg-blue-100 dark:bg-blue-200 dark:text-blue-800"><?php echo $openTicketCount; ?></span>
                                    <svg aria-hidden="true" class="w-6 h-6" fill="currentColor" viewBox="0 0 20 20" xmlns="http://www.w3.org/2000/svg">
                                        <path fill-rule="evenodd" d="M5.293 7.293a1 1 0 011.414 0L10 10.586l3.293-3.293a1 1 0 111.414 1.414l-4 4a1 1 0 01-1.414 0l-4-4a1 1 0 010-1.414z" clip-rule="evenodd"></path>
                                    </svg>
                                </button>
                                <ul id="dropdown-support-admin" class="<?php echo (strpos($URL, $adminURL.'/support') === 0 || $URL === $adminURL.'/support') ? '' : 'hidden'; ?> py-2 space-y-2">
                                    <li>
                                        <a href="<?php echo url('/admin/support/requests'); ?>" class="<?php echo (strpos($URL, '/admin/support/requests') === 0 || $URL === '/admin/support/requests') ? '!bg-white dark:!bg-dark-600' : ''; ?> flex w-[96%] items-center ml-2 p-3 font-medium text-gray-600 dark:text-gray-300 bg-gray-100 dark:bg-dark-700 hover:bg-white dark:hover:bg-dark-600 p-1.5 rounded-3xl cursor-pointer whitespace-nowrap"><?php echo $lang['account-support-requests']?></a>
                                    </li>
                                    <li>
                                        <a href="<?php echo url('/admin/support/new'); ?>" class="<?php echo (strpos($URL, '/admin/support/new') === 0 || $URL === '/admin/support/new') ? '!bg-white dark:!bg-dark-600' : ''; ?> flex w-[96%] items-center ml-2 p-3 font-medium text-gray-600 dark:text-gray-300 bg-gray-100 dark:bg-dark-700 hover:bg-white dark:hover:bg-dark-600 p-1.5 rounded-3xl cursor-pointer whitespace-nowrap"><?php echo $lang['account-support-new']?></a>
                                    </li>
                                </ul>
                            </li>
                        </ul>
                    <?php
                    endif;
                    ?>
                </div>
                <div class="absolute bottom-0 left-0 justify-center p-2 w-full flex bg-gray-100 dark:bg-dark-700 z-20">
                    <button id="theme-toggle" type="button" class="px-4 py-2 my-1 text-gray-500 rounded-3xl hover:bg-gray-200 dark:hover:bg-dark-600">
                        <span class="sr-only">Switch Theme</span>
                        <p id="theme-toggle-dark-icon" class="hidden">
                            <span class="!flex space-x-2 items-center">
                                <svg id="theme-toggle-dark-icon" class="w-6 h-6" fill="currentColor" viewBox="0 0 20 20" xmlns="http://www.w3.org/2000/svg">
                                <path d="M17.293 13.293A8 8 0 016.707 2.707a8.001 8.001 0 1010.586 10.586z"></path>
                            </svg>
                            <span><?php echo $lang['use-theme-dark'] ?></span>
                            </span>
                        </p>
                        <p id="theme-toggle-light-icon" class="hidden">
                            <span class="!flex space-x-2 items-center">
                               <svg id="theme-toggle-light-icon" class="w-6 h-6" fill="currentColor" viewBox="0 0 20 20" xmlns="http://www.w3.org/2000/svg">
                                    <path d="M10 2a1 1 0 011 1v1a1 1 0 11-2 0V3a1 1 0 011-1zm4 8a4 4 0 11-8 0 4 4 0 018 0zm-.464 4.95l.707.707a1 1 0 001.414-1.414l-.707-.707a1 1 0 00-1.414 1.414zm2.12-10.607a1 1 0 010 1.414l-.706.707a1 1 0 11-1.414-1.414l.707-.707a1 1 0 011.414 0zM17 11a1 1 0 100-2h-1a1 1 0 100 2h1zm-7 4a1 1 0 011 1v1a1 1 0 11-2 0v-1a1 1 0 011-1zM5.05 6.464A1 1 0 106.465 5.05l-.708-.707a1 1 0 00-1.414 1.414l.707.707zm1.414 8.486l-.707.707a1 1 0 01-1.414-1.414l.707-.707a1 1 0 011.414 1.414zM4 11a1 1 0 100-2H3a1 1 0 000 2h1z" fill-rule="evenodd" clip-rule="evenodd"></path>
                               </svg>
                            <span><?php echo $lang['use-theme-light'] ?></span>
                            </span>
                        </p>
                    </button>
                </div>
            </aside>
            <div class="fixed left-0 top-1/2 z-40 toggle-sidebar hidden md:flex">
                <button class="sidebar-action-btn" type="button" data-tooltip-target="tooltip-close-sidebar" data-tooltip-placement="right">
                    <span class="" data-state="closed"><div class="flex h-[72px] w-8 items-center justify-center">
                            <div class="flex h-6 w-6 flex-col items-center sidebar-btn">
                                <div class="h-3 w-1 rounded-full bg-gray-300 dark:bg-gray-500 first-sidebar-line"></div>
                                <div class="h-3 w-1 rounded-full bg-gray-300 dark:bg-gray-500 second-sidebar-line"></div>
                            </div>
                        </div>
                        <span style="position: absolute; border: 0px; width: 1px; height: 1px; padding: 0px; margin: -1px; overflow: hidden; clip: rect(0px, 0px, 0px, 0px); white-space: nowrap; overflow-wrap: normal;">Close sidebar</span></span>
                </button>
            </div>
            <div id="tooltip-close-sidebar" role="tooltip" class="absolute z-10 invisible inline-block px-3 py-2 text-sm font-medium text-white bg-dark-900 rounded-lg shadow-sm opacity-0 tooltip dark:bg-dark-600">
                <span class="close-sidebar-text">Close sidebar</span>
                <span class="open-sidebar-text hidden">Open sidebar</span>
                <div class="tooltip-arrow" data-popper-arrow></div>
            </div>
