<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\YouTube;

class PlaylistSnippet extends \Google\Collection
{
  protected $collection_key = 'tags';
  /**
   * @var string
   */
  public $channelId;
  /**
   * @var string
   */
  public $channelTitle;
  /**
   * @var string
   */
  public $defaultLanguage;
  /**
   * @var string
   */
  public $description;
  /**
   * @var PlaylistLocalization
   */
  public $localized;
  protected $localizedType = PlaylistLocalization::class;
  protected $localizedDataType = '';
  /**
   * @var string
   */
  public $publishedAt;
  /**
   * @var string[]
   */
  public $tags;
  /**
   * @var string
   */
  public $thumbnailVideoId;
  /**
   * @var ThumbnailDetails
   */
  public $thumbnails;
  protected $thumbnailsType = ThumbnailDetails::class;
  protected $thumbnailsDataType = '';
  /**
   * @var string
   */
  public $title;

  /**
   * @param string
   */
  public function setChannelId($channelId)
  {
    $this->channelId = $channelId;
  }
  /**
   * @return string
   */
  public function getChannelId()
  {
    return $this->channelId;
  }
  /**
   * @param string
   */
  public function setChannelTitle($channelTitle)
  {
    $this->channelTitle = $channelTitle;
  }
  /**
   * @return string
   */
  public function getChannelTitle()
  {
    return $this->channelTitle;
  }
  /**
   * @param string
   */
  public function setDefaultLanguage($defaultLanguage)
  {
    $this->defaultLanguage = $defaultLanguage;
  }
  /**
   * @return string
   */
  public function getDefaultLanguage()
  {
    return $this->defaultLanguage;
  }
  /**
   * @param string
   */
  public function setDescription($description)
  {
    $this->description = $description;
  }
  /**
   * @return string
   */
  public function getDescription()
  {
    return $this->description;
  }
  /**
   * @param PlaylistLocalization
   */
  public function setLocalized(PlaylistLocalization $localized)
  {
    $this->localized = $localized;
  }
  /**
   * @return PlaylistLocalization
   */
  public function getLocalized()
  {
    return $this->localized;
  }
  /**
   * @param string
   */
  public function setPublishedAt($publishedAt)
  {
    $this->publishedAt = $publishedAt;
  }
  /**
   * @return string
   */
  public function getPublishedAt()
  {
    return $this->publishedAt;
  }
  /**
   * @param string[]
   */
  public function setTags($tags)
  {
    $this->tags = $tags;
  }
  /**
   * @return string[]
   */
  public function getTags()
  {
    return $this->tags;
  }
  /**
   * @param string
   */
  public function setThumbnailVideoId($thumbnailVideoId)
  {
    $this->thumbnailVideoId = $thumbnailVideoId;
  }
  /**
   * @return string
   */
  public function getThumbnailVideoId()
  {
    return $this->thumbnailVideoId;
  }
  /**
   * @param ThumbnailDetails
   */
  public function setThumbnails(ThumbnailDetails $thumbnails)
  {
    $this->thumbnails = $thumbnails;
  }
  /**
   * @return ThumbnailDetails
   */
  public function getThumbnails()
  {
    return $this->thumbnails;
  }
  /**
   * @param string
   */
  public function setTitle($title)
  {
    $this->title = $title;
  }
  /**
   * @return string
   */
  public function getTitle()
  {
    return $this->title;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(PlaylistSnippet::class, 'Google_Service_YouTube_PlaylistSnippet');
