<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\TagManager;

class ZoneBoundary extends \Google\Collection
{
  protected $collection_key = 'customEvaluationTriggerId';
  /**
   * @var Condition[]
   */
  public $condition;
  protected $conditionType = Condition::class;
  protected $conditionDataType = 'array';
  /**
   * @var string[]
   */
  public $customEvaluationTriggerId;

  /**
   * @param Condition[]
   */
  public function setCondition($condition)
  {
    $this->condition = $condition;
  }
  /**
   * @return Condition[]
   */
  public function getCondition()
  {
    return $this->condition;
  }
  /**
   * @param string[]
   */
  public function setCustomEvaluationTriggerId($customEvaluationTriggerId)
  {
    $this->customEvaluationTriggerId = $customEvaluationTriggerId;
  }
  /**
   * @return string[]
   */
  public function getCustomEvaluationTriggerId()
  {
    return $this->customEvaluationTriggerId;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(ZoneBoundary::class, 'Google_Service_TagManager_ZoneBoundary');
