<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Sheets;

class BooleanRule extends \Google\Model
{
  /**
   * @var BooleanCondition
   */
  public $condition;
  protected $conditionType = BooleanCondition::class;
  protected $conditionDataType = '';
  /**
   * @var CellFormat
   */
  public $format;
  protected $formatType = CellFormat::class;
  protected $formatDataType = '';

  /**
   * @param BooleanCondition
   */
  public function setCondition(BooleanCondition $condition)
  {
    $this->condition = $condition;
  }
  /**
   * @return BooleanCondition
   */
  public function getCondition()
  {
    return $this->condition;
  }
  /**
   * @param CellFormat
   */
  public function setFormat(CellFormat $format)
  {
    $this->format = $format;
  }
  /**
   * @return CellFormat
   */
  public function getFormat()
  {
    return $this->format;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(BooleanRule::class, 'Google_Service_Sheets_BooleanRule');
