<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Dataproc;

class KubernetesClusterConfig extends \Google\Model
{
  /**
   * @var GkeClusterConfig
   */
  public $gkeClusterConfig;
  protected $gkeClusterConfigType = GkeClusterConfig::class;
  protected $gkeClusterConfigDataType = '';
  /**
   * @var string
   */
  public $kubernetesNamespace;
  /**
   * @var KubernetesSoftwareConfig
   */
  public $kubernetesSoftwareConfig;
  protected $kubernetesSoftwareConfigType = KubernetesSoftwareConfig::class;
  protected $kubernetesSoftwareConfigDataType = '';

  /**
   * @param GkeClusterConfig
   */
  public function setGkeClusterConfig(GkeClusterConfig $gkeClusterConfig)
  {
    $this->gkeClusterConfig = $gkeClusterConfig;
  }
  /**
   * @return GkeClusterConfig
   */
  public function getGkeClusterConfig()
  {
    return $this->gkeClusterConfig;
  }
  /**
   * @param string
   */
  public function setKubernetesNamespace($kubernetesNamespace)
  {
    $this->kubernetesNamespace = $kubernetesNamespace;
  }
  /**
   * @return string
   */
  public function getKubernetesNamespace()
  {
    return $this->kubernetesNamespace;
  }
  /**
   * @param KubernetesSoftwareConfig
   */
  public function setKubernetesSoftwareConfig(KubernetesSoftwareConfig $kubernetesSoftwareConfig)
  {
    $this->kubernetesSoftwareConfig = $kubernetesSoftwareConfig;
  }
  /**
   * @return KubernetesSoftwareConfig
   */
  public function getKubernetesSoftwareConfig()
  {
    return $this->kubernetesSoftwareConfig;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(KubernetesClusterConfig::class, 'Google_Service_Dataproc_KubernetesClusterConfig');
