<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Apigee;

class GoogleCloudApigeeV1ProfileConfig extends \Google\Collection
{
  protected $collection_key = 'categories';
  /**
   * @var GoogleCloudApigeeV1ProfileConfigCategory[]
   */
  public $categories;
  protected $categoriesType = GoogleCloudApigeeV1ProfileConfigCategory::class;
  protected $categoriesDataType = 'array';

  /**
   * @param GoogleCloudApigeeV1ProfileConfigCategory[]
   */
  public function setCategories($categories)
  {
    $this->categories = $categories;
  }
  /**
   * @return GoogleCloudApigeeV1ProfileConfigCategory[]
   */
  public function getCategories()
  {
    return $this->categories;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(GoogleCloudApigeeV1ProfileConfig::class, 'Google_Service_Apigee_GoogleCloudApigeeV1ProfileConfig');
