<?php
include_once includes('config.php');

$user_id = $_SESSION['user']['id'];
$sql = "SELECT card_number, expiration_date, cvv, cardholder_name FROM credit_cards WHERE user_id = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $user_id);
$stmt->execute();
$result = $stmt->get_result();

$response = [];

if ($result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        $cardNumber = $row["card_number"];
        $lastFourDigits = substr($cardNumber, -4);
        $cardType = getCardType($cardNumber);
        $expirationDate = htmlspecialchars($row["expiration_date"]);
        $cardholderName = htmlspecialchars($row["cardholder_name"]);

        $response[] = [
            'cardNumber' => $cardNumber,
            'lastFourDigits' => $lastFourDigits,
            'cardType' => $cardType,
            'expirationDate' => $expirationDate,
            'cardholderName' => $cardholderName,
        ];
    }
} else {
    $response = ['message' => $lang['check-out-no-saved-card']];
}

$stmt->close();
$conn->close();

echo json_encode($response);
exit;

function getCardType($cardNumber) {
    $cardNumber = str_replace(' ', '', $cardNumber);

    if (preg_match('/^4[0-9]{12}(?:[0-9]{3})?$/', $cardNumber)) {
        return asset('images/content/logos/visa.svg');
    } elseif (preg_match('/^5[1-5][0-9]{14}$/', $cardNumber)) {
        return asset('images/content/logos/mastercard.svg');
    } else {
        return 'Unknown';
    }
}
