<?php
session_start();
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (is_csrf_valid() && empty($_POST['honeypot'])) {
        include_once includes('config.php');
        include_once includes('mailer/send.php');

        // Process the lead application form submission
        if (isset($_POST['name']) && isset($_POST['email']) && isset($_POST['submit_reason'])) {
            $name = $_POST["name"];
            $email = $_POST["email"];
            $phoneNumber = $_POST["phone_number"];
            $submitReason = $_POST["submit_reason"];
            $message = $_POST["message"];
            $promotionalOffers = isset($_POST["promotional_offers"]) ? $_POST["promotional_offers"] : "No";
            $leadSource = $_POST["lead_source"];
            $selectedPlan = $_POST["selected_package"];

            // Prepare the SQL statement with placeholders
            $sql = "INSERT INTO leads (name, email, phone_number, submit_reason, message, promotional_offers, lead_source) 
                    VALUES (?, ?, ?, ?, ?, ?, ?)";
            $stmt = mysqli_prepare($conn, $sql);
            mysqli_stmt_bind_param($stmt, "sssssss", $name, $email, $phoneNumber, $submitReason, $message, $promotionalOffers, $leadSource);

            if (mysqli_stmt_execute($stmt)) {
                $response = [
                    "status" => "success",
                    "message" => $lang['application-submitted'],
                ];

                // Try sending email, but don't prevent the main action if it fails
                try {
                    $to = "info@datanito.com"; // Replace with your email address
                    $emailSubject = "New Lead: ".$submitReason;
                    $emailMessage = "
                        <p><strong>Name:</strong> $name</p>
                        <p><strong>Email:</strong> $email</p>
                        <p><strong>Phone Number:</strong> $phoneNumber</p>
                        <p><strong>Reason for Submission:</strong> $submitReason</p>
                        <p><strong>Message:</strong> $message</p>
                        <p><strong>Promotional Offers:</strong> $promotionalOffers</p>
                        <p><strong>Lead Source:</strong> $leadSource</p>
                        <p><strong>Selected Plan:</strong> $selectedPlan</p>
                    ";

                    $emailCtaLink = url('/admin/leads');
                    $emailContent = getEmailContent($emailCtaLink, $emailMessage, $name, $email, $phoneNumber, $submitReason, $message, $promotionalOffers, $leadSource, $selectedPlan, $lang);

                    sendEmail($to, $emailSubject, $emailContent, '');
                } catch (Exception $e) {
                    // Log the error message if email sending fails
                    error_log("Email sending error: " . $e->getMessage());
                }
            } else {
                $response = [
                    "status" => "error",
                    "message" => $lang['application-failed'],
                ];
            }

            // Close the statement and the database connection
            mysqli_stmt_close($stmt);
            mysqli_close($conn);

            // Return the response as JSON
            header("Content-Type: application/json");
            echo json_encode($response);
        }
    } else {
        // handle CSRF token validation failure
        $response = [
            "status" => "error",
            "message" => "CSRF token validation failed.",
        ];
        header("Content-Type: application/json");
        echo json_encode($response);
    }
}
function getEmailContent($emailCtaLink, $emailMessage, $name, $email, $phoneNumber, $submitReason, $message, $promotionalOffers, $leadSource, $selectedPlan, $lang) {
    $htmlContent = file_get_contents('includes/emails/system_email.php');

    // Replace placeholders with dynamic content
    $htmlContent = str_replace('{{cta-link}}', $emailCtaLink, $htmlContent);
    $htmlContent = str_replace('{{user-name}}', 'Executive', $htmlContent);

    // Replace email content with language variables
    $htmlContent = str_replace('{{hello}}', $lang['email-hello'], $htmlContent);
    $htmlContent = str_replace('{{headline}}', 'New Lead Submission', $htmlContent);
    $htmlContent = str_replace('{{email-p1}}', $emailMessage, $htmlContent);
    $htmlContent = str_replace('{{cta}}', 'View All Leads', $htmlContent);
    $htmlContent = str_replace('{{email-p2}}', '', $htmlContent);
    $htmlContent = str_replace('{{email-p3}}', '', $htmlContent);
    $htmlContent = str_replace('{{email-copyright}}', $lang['email-copyright'], $htmlContent);

    return $htmlContent;
}