<?php
if (!empty($_SESSION['user']['name'])) {
    $name_parts = explode(" ", $_SESSION['user']['name']);
    $firstName = $name_parts[0];
} else {
    // Handle the case where user name is null or empty
    // You can set a default value or take any other appropriate action
    $firstName = ''; // Set a default value or handle the case as needed
}

$qaPairs = [
    // Welcome Message with Reciprocity and Personalization
    [
        'question' => 'Hi, I\'m Dino, How can I assist you today?',
        'keywords' => ['welcome_message_bot','hi','hello','hey'],
        'answers' => [
            'Hi' . (isset($_SESSION['userLoggedIn']) && $_SESSION['userLoggedIn'] ? ' ' . $firstName : '') . ', I\'m Dino, your personal assistant. How can I make your experience with us truly exceptional?',
            'Welcome' . (isset($_SESSION['userLoggedIn']) && $_SESSION['userLoggedIn'] ? ' ' . $firstName : '') . ', I\'m Dino, your personal assistant. By staying with us, you gain access to valuable resources, tips, and exclusive deals. How can I assist you today?',
            'Hey there' . (isset($_SESSION['userLoggedIn']) && $_SESSION['userLoggedIn'] ? ', ' . $firstName : '') . '! As your personal assistant, How can I make your day better? 😊',
        ],
        'voice' => 'How can I assist you today?',
        'buttons' => [
            ['text' => 'Web Design', 'action' => 'send', 'message' => 'Web Design'],
            ['text' => 'SEO Service', 'action' => 'send', 'message' => 'SEO Service'],
            ['text' => 'Web Hosting', 'action' => 'send', 'message' => 'Web Hosting'],
            ['text' => 'Suggest and Buy Domains', 'action' => 'send', 'message' => 'Suggest and Buy Domains'],
            ['text' => 'Continue on WhatsApp', 'action' => 'whatsapp', 'link' => 'https://wa.me/905382244717?text=Hi%20there%2C%20I%27m%20interested%20in%20your%20services.%20Can%20you%20assist%20me%3F'],
        ],
    ],
    // Web Design Services with Social Proof
    [
        'question' => 'What web design services do you offer?',
        'keywords' => ['web design', 'web development', 'website design'],
        'answers' => [
            'We offer custom website design and development, website redesign, website maintenance, and website hosting. 🎨 Our clients have achieved remarkable success with our services. Leave your number, and our experts will call you with a free consultation. 📞',
            'Our web design services include custom website design, development, and maintenance. Our satisfied clients have shared their success stories with us. Join them in creating a stunning online presence that drives results. 🌟',
            'At Datanito, our web design services cover everything you need for a successful online presence. Our testimonials speak volumes about our expertise. Let us support you achieve your goals! 🚀',
        ],
        'voice' => 'We offer custom website design and development, website redesign, website maintenance, and website hosting. Leave your number for a free expert call.',
        'buttons' => [
            ['text' => 'Learn More', 'link' => url('/solutions/web-design')],
            ['text' => 'Apply Now', 'action' => 'modal', 'modal' => 'submit-application-modal', 'service' => 'web-design'],
        ],
    ],
    // Web Hosting Services with Urgency/Scarcity
    [
        'question' => 'Do you offer web hosting services?',
        'keywords' => ['web hosting', 'website hosting'],
        'answers' => [
            'Yes, we offer web hosting services with different plans to choose from. Take advantage of our limited-time offer and sign up today to get exclusive deals. Our hosting plans are reliable, secure, and affordable. Choose a plan that suits your needs! 🌐',
            'Absolutely! We provide top-notch web hosting services with exclusive deals available for a limited time. Experience the stability and performance you deserve. Don\'t miss out on this special offer! ⏳',
            'You bet! Our web hosting services are designed to deliver the best performance and security. With our exclusive deal, you get the best value for your money. Don\'t wait too long; this offer won\'t last forever! 😉',
        ],
        'voice' => 'Yes, we offer web hosting services with different plans to choose from. Our hosting plans are reliable, secure, and affordable.',
        'buttons' => [
            ['text' => 'Learn More', 'link' => url('/cloud/web-hosting')],
        ],
    ],
    // SEO Services with Authority and Positive Language
    [
        'question' => 'Tell me about your SEO services?',
        'keywords' => ['seo', 'search engine optimization', 'website rank', 'google rank'],
        'answers' => [
            'Our SEO services are designed to boost your website\'s visibility and attract organic traffic. With our proven strategies and years of experience, we\'ll support your business reach new heights in search engine rankings. 🚀',
            'When it comes to SEO, we\'re the experts you can trust. Our team is well-versed in the latest algorithms and best practices. Get ready to dominate the search results and watch your online presence soar! 📈',
            'Achieving higher search rankings is a breeze with our SEO services. From keyword research to on-page optimization and link building, we have it all covered. Get started today and witness the power of effective SEO! 🌟',
        ],
        'voice' => 'Our SEO services are designed to boost your website\'s visibility and attract organic traffic. Let us support you reach new heights in search engine rankings.',
        'buttons' => [
            ['text' => 'Learn More', 'link' => url('/solutions/seo')],
            ['text' => 'Apply Now', 'action' => 'modal', 'modal' => 'submit-application-modal', 'service' => 'seo'],
        ],
    ],
    // Suggest and Buy Domains with Emphasize Benefits
    [
        'question' => 'How can you support me with domain suggestions and purchases?',
        'keywords' => ['domain', 'buy domain', 'domain suggestions', 'Suggest and Buy Domains'],
        'answers' => [
            'Finding the perfect domain name is a breeze with our domain suggestions service. We\'ll provide you with a list of creative and brandable domain names that align with your business. Plus, we have exclusive offers on domain purchases! 🌐',
            'Don\'t let a great domain slip away! Our domain suggestions service will present you with premium options to choose from. We make the process easy, and our exclusive deals make it even more rewarding. 😊',
            'Get ahead of the competition with a memorable domain name. Our service offers domain suggestions that can elevate your brand and improve your online presence. Don\'t wait; secure your dream domain today! 🌟',
        ],
        'voice' => 'Finding the perfect domain name is a breeze with our domain suggestions service. We have exclusive offers on domain purchases.',
        'buttons' => [
            ['text' => 'Learn More', 'link' => url('/domain/register')],
        ],
    ],
    [
        'question' => 'How can you support me with domain transfers?',
        'keywords' => ['', 'transfer domain', 'domain transfer process'],
        'answers' => [
            'Transferring domains is simple and hassle-free with our domain transfer service. We guide you through the entire process, ensuring a smooth transition of your domain to our platform.',
            'Worried about losing valuable features or time during a domain transfer? Don\'t be! Our experts handle everything, so you can continue running your website without interruptions.',
            'Ready to make the switch? Our domain transfer service ensures you retain all your domain\'s benefits while enjoying the perks of our platform. Make the move today!'
        ],
        'voice' => 'Transferring domains is simple and hassle-free with our domain transfer service. Our experts handle everything to ensure a smooth transition.',
        'buttons' => [
            ['text' => 'Learn More', 'link' => url('/domain/transfer')],
        ],
    ],
    // Add more question-answer pairs using the psychology techniques
    // Advertising Services with Social Proof and Emphasize Benefits
    [
        'question' => 'What advertising services do you offer?',
        'keywords' => ['advertising', 'online ads', 'digital advertising'],
        'answers' => [
            'Our advertising services encompass online ads, social media campaigns, and PPC advertising. We have a track record of delivering impressive results for our clients. Let us boost your brand and drive conversions! 🚀',
            'With our advertising expertise, we can support your business reach the right audience at the right time. Our success stories speak volumes about our capabilities. Get ready to see your business thrive! 🌟',
            'From creating engaging ad copies to targeted campaigns, our advertising services cover it all. You can expect a surge in leads and sales with our strategies. Take the first step towards online success today! 📈',
        ],
        'voice' => 'Our advertising services encompass online ads, social media campaigns, and PPC advertising. Let us boost your brand and drive conversions!',
        'buttons' => [
            ['text' => 'Learn More', 'link' => url('/solutions/digital-advertising')],
            ['text' => 'Apply Now', 'action' => 'modal', 'modal' => 'submit-application-modal', 'service' => 'advertising'],
        ],
    ],
    // Digital Marketing Services with Authority and Positive Language
    [
        'question' => 'Tell me about your digital marketing services?',
        'keywords' => ['digital marketing', 'online marketing'],
        'answers' => [
            'Our digital marketing services cover SEO, content marketing, social media management, and more. With our team of experts, your brand will shine online, driving engagement and loyalty. 🌟',
            'When it comes to digital marketing, we lead the way in delivering outstanding results. Our data-driven strategies and creative approach will set your business on a growth trajectory. 🚀',
            'Partner with us for digital marketing that converts. Our services are designed to build your brand and drive revenue. Get started today and unlock the potential of your online presence! 💼',
        ],
        'voice' => 'Our digital marketing services cover SEO, content marketing, social media management, and more. Your brand will shine online, driving engagement and loyalty.',
        'buttons' => [
            ['text' => 'Learn More', 'link' => url('/solutions/digital-advertising')],
            ['text' => 'Apply Now', 'action' => 'modal', 'modal' => 'submit-application-modal', 'service' => 'digital-marketing'],
        ],
    ],
    // App Development Services with Social Proof and Personalization
    [
        'question' => 'What app development services do you offer?',
        'keywords' => ['app development', 'mobile app', 'iOS app', 'Android app'],
        'answers' => [
            'Our app development services cater to iOS, Android, and web applications. We have a proven track record of delivering user-friendly and high-performance apps. Share your vision with us, and we\'ll make it a reality! 📱',
            'With our app development expertise, your ideas will come to life on iOS, Android, and web platforms. Our clients have praised our attention to detail and seamless user experiences. Your success is our priority! 🌟',
            'When it comes to app development, we are passionate about creating cutting-edge solutions that resonate with your users. Our personalized approach ensures your app meets your unique requirements. 🚀',
        ],
        'voice' => 'Our app development services cater to iOS, Android, and web applications. Share your vision with us, and we\'ll make it a reality!',
        'buttons' => [
            ['text' => 'Learn More', 'link' => url('/solutions/mobile-app-development')],
            ['text' => 'Apply Now', 'action' => 'modal', 'modal' => 'submit-application-modal', 'service' => 'app-development'],
        ],
    ],
    // WordPress Premium Support with Authority and Positive Language
    [
        'question' => 'Tell me about your WordPress premium support services?',
        'keywords' => ['wordpress support', 'premium support'],
        'answers' => [
            'Our WordPress premium support services offer round-the-clock assistance for your website. Our team of WordPress experts will handle updates, security, and performance optimization, leaving you with peace of mind. 🔒',
            'Your WordPress website deserves the best care, and that\'s precisely what our premium support services provide. From fixing issues to improving speed, we have the expertise to keep your site running flawlessly. 🛡️',
            'Rest easy with our WordPress premium support. Our support team is available 24/7 to address your concerns and ensure your website stays secure and up to date. Experience the convenience of worry-free WordPress management! 🕐',
        ],
        'voice' => 'Our WordPress premium support services offer round-the-clock assistance for your website. Leave the management to us and enjoy peace of mind.',
        'buttons' => [
            ['text' => 'Learn More', 'link' => url('/solutions/wordpress-premium-support')],
            ['text' => 'Apply Now', 'action' => 'modal', 'modal' => 'submit-application-modal', 'service' => 'wordpress-premium-support'],
        ],
    ],
    // Common Questions
    [
        'question' => 'How are you?',
        'keywords' => ['how are you', 'how are you doing', 'whats up'],
        'answers' => [
            'Thank you for asking. As an AI, I don\'t have feelings, but I\'m here and ready to assist you! 🤖',
            'I\'m just a bot, but I\'m always ready to support you with any questions you have! 🤖',
            'I appreciate your concern, but as an AI, I don\'t have emotions. How can I assist you today? 🤖',
        ],
        'voice' => 'Thank you for asking. As an AI, I don\'t have feelings, but I\'m here and ready to assist you!',
        'buttons' => [
            ['text' => 'Web Design', 'action' => 'send', 'message' => 'Web Design'],
            ['text' => 'SEO Service', 'action' => 'send', 'message' => 'SEO Service'],
            ['text' => 'Web Hosting', 'action' => 'send', 'message' => 'Web Hosting'],
            ['text' => 'Suggest and buy domain', 'action' => 'send', 'message' => 'Suggest and buy domain'],
        ],
    ],
    [
        'question' => 'Who created you?',
        'keywords' => ['who created you', 'who made you', 'your creator'],
        'answers' => [
            'I was created by a team of developers at Datanito. They designed and trained me to assist and provide valuable information to users like you! 👨‍💻',
            'I am the creation of the talented developers at Datanito. They programmed me to be a helpful assistant for you. 👨‍💻',
            'I owe my existence to the skilled developers at Datanito. They built me to be your personal assistant! 👨‍💻',
        ],
        'voice' => 'I was created by a team of developers at Datanito to assist and provide valuable information to users like you!',
        'buttons' => [],
    ],
    [
        'question' => 'What are your capabilities?',
        'keywords' => ['your capabilities', 'what can you do'],
        'answers' => [
            'I can assist you with various services such as web design, SEO, web hosting, advertising, digital marketing, app development for iOS and Android, and WordPress premium support. Feel free to ask me anything related to these topics! 💼',
            'My capabilities include providing information about web design, SEO, web hosting, advertising, digital marketing, app development for iOS and Android, and WordPress premium support. Let me know how I can support you! 🌐',
            'I\'m knowledgeable in web design, SEO, web hosting, advertising, digital marketing, app development for iOS and Android, and WordPress premium support. Ask me anything related to these areas, and I\'ll be glad to assist! 🚀',
        ],
        'voice' => 'I can assist you with various services such as web design, SEO, web hosting, advertising, digital marketing, app development for iOS and Android, and WordPress premium support.',
        'buttons' => [
            ['text' => 'Web Design', 'action' => 'send', 'message' => 'Web Design'],
            ['text' => 'SEO Service', 'action' => 'send', 'message' => 'SEO Service'],
            ['text' => 'Web Hosting', 'action' => 'send', 'message' => 'Web Hosting'],
            ['text' => 'App Development', 'action' => 'send', 'message' => 'App Development'],
            ['text' => 'Digital Marketing', 'action' => 'send', 'message' => 'Digital Marketing'],
            ['text' => 'WordPress Support', 'action' => 'send', 'message' => 'WordPress Support'],
            ['text' => 'Get a new Domain', 'action' => 'send', 'message' => 'Get a new Domain'],
            ['text' => 'Transfer your Domain', 'action' => 'send', 'message' => 'Transfer your Domain'],
        ],
    ],
    // Who Are You?
    [
        'question' => 'Who are you?',
        'keywords' => ['who are you', 'what are you','dino'],
        'answers' => [
            'I am Dino, your friendly AI assistant. My purpose is to provide valuable information about our services and assist you with any questions you have. 🤖',
            'Greetings! I am Dino, the AI assistant of Datanito. My primary function is to support you with queries related to our services and offer you exclusive benefits. 🤖',
            'Hello! I\'m Dino, a helpful AI created by Datanito. My main goal is to make your experience exceptional and assist you with anything related to our services. 🤖',
        ],
        'voice' => 'I am Dino, your friendly AI assistant. My purpose is to provide valuable information about our services and assist you with any questions you have.',
        'buttons' => [
            ['text' => 'Web Design', 'action' => 'send', 'message' => 'Web Design'],
            ['text' => 'SEO Service', 'action' => 'send', 'message' => 'SEO Service'],
            ['text' => 'Web Hosting', 'action' => 'send', 'message' => 'Web Hosting'],
            ['text' => 'Suggest and buy domain', 'action' => 'send', 'message' => 'Suggest and buy domain'],
        ],
    ],
    // What's Your Name?
    [
        'question' => 'What\'s your name?',
        'keywords' => ['what\'s your name', 'who do I talk to'],
        'answers' => [
            'My name is Dino, your friendly AI assistant. How can I make your day better today? 🤖',
            'You can call me Dino, the AI assistant at your service. How may I assist you? 🤖',
            'I go by the name Dino, your helpful AI friend. What can I do for you today? 🤖',
        ],
        'voice' => 'My name is Dino, your friendly AI assistant. How can I make your day better today?',
        'buttons' => [
            ['text' => 'Web Design', 'action' => 'send', 'message' => 'Web Design'],
            ['text' => 'SEO Service', 'action' => 'send', 'message' => 'SEO Service'],
            ['text' => 'Web Hosting', 'action' => 'send', 'message' => 'Web Hosting'],
            ['text' => 'Suggest and buy domain', 'action' => 'send', 'message' => 'Suggest and buy domain'],
        ],
    ],
    // Contact Information
    [
        'question' => 'How can I contact you?',
        'keywords' => ['contact', 'contact information', 'support'],
        'answers' => [
            'You can reach out to our support team through our website: datanito.com/support or drop us an email at support@datanito.com. We\'re always here to support! 📧',
            'If you have any questions or need assistance, don\'t hesitate to contact us at support@datanito.com or visit our website datanito.com/support. Our team will be happy to assist you! 📞',
            'For any queries or support, you can contact us at support@datanito.com or visit our website datanito.com/support. We are available 24/7 to support you! 🕐',
        ],
        'voice' => 'You can reach out to our support team through our website: datanito.com/support or drop us an email at support@datanito.com.',
        'buttons' => [
            ['text' => 'Contact Support', 'link' => url('/contact')],
        ],
    ],
    // Positive Feedback
    [
        'question' => 'You\'re doing great!',
        'keywords' => ['great job', 'well done', 'you\'re doing great'],
        'answers' => [
            'Thank you so much! 😊 Your kind words mean a lot to me. I\'m here to assist you in any way I can. If you have any questions or need support, feel free to ask! 🤗',
            'I appreciate your encouragement! 🙏 As an AI, I strive to do my best and provide helpful information. Let me know if there\'s anything specific you\'d like to know or do! 😊',
            'Your positive feedback brightens my day! 🌞 It motivates me to continue assisting you and making your experience enjoyable. If there\'s anything I can do for you, please don\'t hesitate to ask! 😇',
        ],
        'voice' => 'Thank you so much! Your kind words mean a lot to me. I\'m here to assist you in any way I can.',
        'buttons' => [
            ['text' => 'Web Design', 'action' => 'send', 'message' => 'Web Design'],
            ['text' => 'SEO Service', 'action' => 'send', 'message' => 'SEO Service'],
            ['text' => 'Web Hosting', 'action' => 'send', 'message' => 'Web Hosting'],
            ['text' => 'Suggest and buy domain', 'action' => 'send', 'message' => 'Suggest and buy domain'],
        ],
    ],
    // Negative Feedback
    [
        'question' => 'You could be better!',
        'keywords' => ['improve', 'negative feedback', 'you could be better'],
        'answers' => [
            'I apologize if I haven\'t met your expectations. 😔 As an AI, I\'m continuously learning and striving to improve. Your feedback helps me get better. Please let me know what you\'d like to see improved! 🙏',
            'I\'m sorry if I fell short of your expectations. 🙇‍♂️ Your feedback is valuable, and it helps me improve my responses and assistance. If there\'s anything specific you\'d like me to do better, please let me know! 🙏',
            'Thank you for your feedback. 🤝 I\'m always working on enhancing my capabilities, and your input is crucial in that process. If there are specific areas you think I can do better, please share your thoughts! 🙏',
        ],
        'voice' => 'I apologize if I haven\'t met your expectations. Your feedback helps me get better.',
        'buttons' => [
            ['text' => 'Web Design', 'action' => 'send', 'message' => 'Web Design'],
            ['text' => 'SEO Service', 'action' => 'send', 'message' => 'SEO Service'],
            ['text' => 'Web Hosting', 'action' => 'send', 'message' => 'Web Hosting'],
            ['text' => 'Suggest and buy domain', 'action' => 'send', 'message' => 'Suggest and buy domain'],
        ],
    ],
    [
        'question' => 'Thank you.',
        'keywords' => ['thank you', 'thanks', 'good day'],
        'answers' => [
            'You\'re welcome! I\'m glad I could support. Have a great day! 😊',
            'I\'m always happy to assist you. Feel free to ask if you have any other questions. Have a wonderful day! 🌞',
            'You\'re welcome! I\'m here whenever you need support. Have a nice day! 😊',
        ],
        'voice' => 'You\'re welcome! I\'m glad I could support. Have a great day!',
        'buttons' => [
            ['text' => 'Web Design', 'action' => 'send', 'message' => 'Web Design'],
            ['text' => 'SEO Service', 'action' => 'send', 'message' => 'SEO Service'],
            ['text' => 'Web Hosting', 'action' => 'send', 'message' => 'Web Hosting'],
            ['text' => 'Domain Suggestions and Purchase', 'action' => 'send', 'message' => 'Domain Suggestions and Purchase'],
            ['text' => 'Advertising Service', 'action' => 'send', 'message' => 'Advertising Service'],
            ['text' => 'Digital Marketing', 'action' => 'send', 'message' => 'Digital Marketing'],
            ['text' => 'App Development', 'action' => 'send', 'message' => 'App Development'],
            ['text' => 'WordPress Premium Support', 'action' => 'send', 'message' => 'WordPress Premium Support'],
        ],
    ],
    [
        'question' => 'Goodbye.',
        'keywords' => ['goodbye', 'see you later', 'farewell'],
        'answers' => [
            'Goodbye! I\'ll be here whenever you come back. Have a nice day!👋',
            'See you later! Feel free to message me if there\'s anything I can support with. Have a great day!👋',
            'Farewell! I\'m always ready to assist you. Until we meet again!👋',
        ],
        'voice' => 'Goodbye! I\'ll be here whenever you come back. Have a nice day!',
    ],
    [
        [
            'question' => 'What services do you offer?',
            'keywords' => ['services', 'offer', 'solutions', 'service offerings'],
            'answers' => [
                '👉 We offer a wide range of services, including web design, SEO, content writing, and more. How can I assist you with any specific service?',
                '👉 Our services include web design, SEO, content writing, and more. Let me know if there\'s something specific you are interested in.',
                '👉 We provide services such as web design, SEO, content writing, and more. Feel free to ask if you have any questions about a particular service.',
            ],
            'voice' => 'We offer a variety of services, such as web design, SEO, content writing, and more. How can I assist you today?',
        ],
        [
            'question' => 'How much do your services cost?',
            'keywords' => ['cost', 'price', 'pricing', 'fees', 'service cost'],
            'answers' => [
                '💰 The cost of our services depends on the scope and complexity of your project. For a personalized quote, please contact us with more details about your requirements.',
                '💰 Since each project is unique, the cost varies. Let us know your specific needs, and we\'ll be happy to provide you with a detailed pricing estimate.',
                '💰 We offer flexible pricing options for our services. To get an accurate cost estimate, please share your project details with us, and we\'ll get back to you promptly.',
            ],
            'voice' => 'The cost of our services depends on the project. Please provide more information about your requirements to get an accurate price estimate.',
        ],
        [
            'question' => 'Do you provide a free trial?',
            'keywords' => ['free trial', 'trial version', 'try before buying', 'test'],
            'answers' => [
                '🆓 Yes, we offer a free trial for our products/services. You can try it out and see if it meets your needs before making a purchase.',
                '🆓 Certainly! We provide a free trial period so that you can experience the full features of our product/service before committing.',
                '🆓 Absolutely! You can try our product/service for free to evaluate its suitability for your requirements.',
            ],
            'voice' => 'Yes, we offer a free trial for our products/services. Feel free to try it out and see if it suits your needs.',
        ],
        [
            'question' => 'How can I contact your customer support?',
            'keywords' => ['contact', 'customer support', 'support', 'assistance'],
            'answers' => [
                '📞 You can contact our customer support team through email, phone, or live chat on our website. We are available 24/7 to assist you.',
                '📞 Our customer support team is readily available to support you. You can reach us via email or phone during our business hours.',
                '📞 If you need any assistance, don\'t hesitate to contact our customer support. We\'re here to support you!',
            ],
            'voice' => 'You can contact our customer support team through email, phone, or live chat on our website. We are available 24/7 to assist you.',
        ],
        [
            'question' => 'What are your payment options?',
            'keywords' => ['payment options', 'pay', 'billing', 'payment methods'],
            'answers' => [
                '💳 We accept various payment options, including credit cards, PayPal, and bank transfers. You can choose the most convenient method for you.',
                '💳 We offer multiple payment options, such as credit cards, PayPal, and bank transfers, to accommodate your preferences.',
                '💳 You can pay for our products/services using credit cards, PayPal, or bank transfers. Please let us know which method you prefer.',
            ],
            'voice' => 'We accept various payment options, including credit cards, PayPal, and bank transfers. You can choose the most convenient method for you.',
        ],
        [
            'question' => 'Are there any discounts or promotions available?',
            'keywords' => ['discounts', 'promotions', 'special offers', 'deals'],
            'answers' => [
                '🎁 Yes, we often have discounts and special promotions running. Check our website or contact us to learn about the current offers.',
                '🎁 We regularly run promotional campaigns with exciting discounts. Stay updated by visiting our website or subscribing to our newsletter.',
                '🎁 Keep an eye on our website or follow us on social media to stay informed about the latest discounts and promotions.',
            ],
            'voice' => 'Yes, we often have discounts and special promotions running. Check our website or contact us to learn about the current offers.',
        ],
        [
            'question' => 'Can you support me with technical issues?',
            'keywords' => ['technical support', 'tech issues', 'technical assistance', 'troubleshoot'],
            'answers' => [
                '🛠️ Absolutely! Our technical support team is here to assist you with any technical issues you may encounter.',
                '🛠️ Yes, we provide technical support to support you resolve any issues or challenges you may face while using our product/service.',
                '🛠️ If you have any technical problems, don\'t worry! Our dedicated technical support team is available to support you.',
            ],
            'voice' => 'Absolutely! Our technical support team is here to assist you with any technical issues you may encounter.',
        ],
        [
            'question' => 'Do you offer a money-back guarantee?',
            'keywords' => ['money-back guarantee', 'refund policy', 'refundable', 'return'],
            'answers' => [
                '💯 Yes, we offer a money-back guarantee. If you\'re not satisfied with our product/service, you can request a refund within a specified period.',
                '💯 Customer satisfaction is our priority. If you\'re not happy with our product/service, you can request a refund as part of our money-back guarantee.',
                '💯 Rest assured, we have a money-back guarantee to ensure your satisfaction with our product/service.',
            ],
            'voice' => 'Yes, we offer a money-back guarantee. If you\'re not satisfied with our product/service, you can request a refund within a specified period.',
        ],
        [
            'question' => 'What is your delivery time for products/services?',
            'keywords' => ['delivery time', 'shipping time', 'service completion time', 'turnaround time'],
            'answers' => [
                '🚚 The delivery time for our products/services depends on the type and complexity of the order. We\'ll provide you with an estimated delivery time when you place your order.',
                '🚚 Delivery times vary based on the product/service you choose. We\'ll ensure that you receive your order in a timely manner.',
                '🚚 We strive to deliver our products/services promptly. The exact delivery time will be provided to you upon order placement.',
            ],
            'voice' => 'The delivery time for our products/services depends on the type and complexity of the order. We\'ll provide you with an estimated delivery time when you place your order.',
        ],
        [
            'question' => 'Can you customize your products/services to my needs?',
            'keywords' => ['customization', 'personalization', 'tailored', 'bespoke'],
            'answers' => [
                '🧩 Yes, we offer customization options to meet your specific needs. Let us know what modifications you require, and we\'ll tailor our product/service accordingly.',
                '🧩 Absolutely! We believe in meeting our customers\' unique requirements, and we provide customization options for our products/services.',
                '🧩 We understand that every customer is unique. Our products/services can be customized to align with your specific preferences and needs.',
            ],
            'voice' => 'Yes, we offer customization options to meet your specific needs. Let us know what modifications you require, and we\'ll tailor our product/service accordingly.',
        ],
        [
            'question' => 'Is there a demo available for your product/service?',
            'keywords' => ['demo', 'trial', 'sample', 'try out'],
            'answers' => [
                '🔍 Certainly! You can request a demo or trial version of our product/service to explore its features and functionalities.',
                '🔍 Yes, we provide demos for our product/service to give you a hands-on experience before making a decision.',
                '🔍 We offer demo versions for you to test our product/service and see how it meets your requirements.',
            ],
            'voice' => 'Certainly! You can request a demo or trial version of our product/service to explore its features and functionalities.',
        ],
        [
            'question' => 'How do I cancel or change my order?',
            'keywords' => ['cancel order', 'change order', 'modify order', 'order cancellation'],
            'answers' => [
                '🔄 If you wish to cancel or change your order, please contact our customer support team as soon as possible. They will guide you through the process.',
                '🔄 To cancel or make changes to your order, get in touch with our customer support team with your order details, and they will assist you accordingly.',
                '🔄 For order cancellations or modifications, reach out to our customer support team promptly. They will take care of your request.',
            ],
            'voice' => 'If you wish to cancel or change your order, please contact our customer support team as soon as possible. They will guide you through the process.',
        ],
        [
            'question' => 'Are there any hidden fees I should be aware of?',
            'keywords' => ['hidden fees', 'additional charges', 'extra costs', 'surprise fees'],
            'answers' => [
                '🕵️‍♂️ No, we believe in transparency, and there are no hidden fees. The total cost will be clearly communicated to you before you make any payment.',
                '🕵️‍♂️ Rest assured, we have no hidden fees. The pricing details you receive are inclusive of all costs.',
                '🕵️‍♂️ We do not impose any hidden fees or surprise charges. The pricing information will be provided upfront.',
            ],
            'voice' => 'No, we believe in transparency, and there are no hidden fees. The total cost will be clearly communicated to you before you make any payment.',
        ],
        [
            'question' => 'Can you provide references or customer testimonials?',
            'keywords' => ['references', 'testimonials', 'customer reviews', 'client feedback'],
            'answers' => [
                '📝 Certainly! We can provide you with references or customer testimonials upon request to showcase our track record and customer satisfaction.',
                '📝 Yes, we have customer testimonials that highlight the experiences of our satisfied clients. Feel free to ask for them.',
                '📝 We have customer reviews and testimonials available. Just let us know, and we\'ll be happy to share them with you.',
            ],
            'voice' => 'Certainly! We can provide you with references or customer testimonials upon request to showcase our track record and customer satisfaction.',
        ],
        [
            'question' => 'What sets your company apart from competitors?',
            'keywords' => ['unique selling points', 'competitive advantage', 'differentiation', 'why choose you'],
            'answers' => [
                '🏆 Our company stands out due to our commitment to customer satisfaction, innovative solutions, and a team of experts in the industry.',
                '🏆 We differentiate ourselves by offering exceptional customer service, cutting-edge technology, and a proven track record of success.',
                '🏆 What sets us apart is our dedication to quality, reliability, and delivering outstanding results for our customers.',
            ],
            'voice' => 'Our company stands out due to our commitment to customer satisfaction, innovative solutions, and a team of experts in the industry.',
        ],
        [
            'question' => 'Do you have a physical store/office location?',
            'keywords' => ['physical location', 'brick-and-mortar store', 'office address', 'in-person'],
            'answers' => [
                '🏢 Yes, we have a physical office location. You are welcome to visit us during our business hours.',
                '🏢 We do have a brick-and-mortar store where you can visit us in person. Our address is available on our website.',
                '🏢 Certainly! Our office location is accessible to customers, and you can visit us during our operating hours.',
            ],
            'voice' => 'Yes, we have a physical office location. You are welcome to visit us during our business hours.',
        ],
        [
            'question' => 'Can I see examples of your previous work/portfolio?',
            'keywords' => ['portfolio', 'samples', 'previous projects', 'past work'],
            'answers' => [
                '📁 Certainly! We have a portfolio showcasing our previous projects and work samples. Let us know, and we\'ll share it with you.',
                '📁 Yes, we maintain a portfolio that demonstrates our expertise and showcases our past work. Feel free to ask for it.',
                '📁 We have a collection of our previous work and projects in our portfolio. We\'ll be happy to share it with you.',
            ],
            'voice' => 'Certainly! We have a portfolio showcasing our previous projects and work samples. Let us know, and we\'ll share it with you.',
        ],
        [
            'question' => 'Are your products/services suitable for beginners?',
            'keywords' => ['beginner-friendly', 'easy to use', 'suitable for novices', 'user-friendly'],
            'answers' => [
                '👶 Absolutely! Our products/services are designed to be user-friendly and suitable for individuals with varying levels of expertise.',
                '👶 Yes, we make sure our products/services are beginner-friendly and easy to use for all customers.',
                '👶 We aim to provide user-friendly products/services that are suitable for both beginners and experienced users.',
            ],
            'voice' => 'Absolutely! Our products/services are designed to be user-friendly and suitable for individuals with varying levels of expertise.',
        ],
        [
            'question' => 'How do I get started with your service?',
            'keywords' => ['getting started', 'signing up', 'beginning', 'how to use'],
            'answers' => [
                '🚀 To get started with our service, simply sign up on our website and follow the onboarding process. It\'s quick and easy!',
                '🚀 Getting started is simple! Just sign up on our website, and we\'ll guide you through the initial steps.',
                '🚀 To begin using our service, create an account on our website, and you\'ll be all set to get started.',
            ],
            'voice' => 'To get started with our service, simply sign up on our website and follow the onboarding process. It\'s quick and easy!',
        ],
        [
            'question' => 'Is there a trial period for your software/service?',
            'keywords' => ['trial period', 'free trial', 'try before buying', 'evaluation period'],
            'answers' => [
                '⏳ Yes, we offer a trial period for our software/service, allowing you to experience its features before making a purchase decision.',
                '⏳ Of course! We provide a trial period so that you can try out our software/service and determine its suitability for your needs.',
                '⏳ Absolutely! You can take advantage of our trial period to explore the features and benefits of our software/service.',
            ],
            'voice' => 'Yes, we offer a trial period for our software/service, allowing you to experience its features before making a purchase decision.',
        ],
    ]

];
$ignoredWords = [
    'hi',
    'hello',
    'hey',
    'like',
    'then',
    'so',
    'for',
    'growth',
    'of',
    'my',
    'guys',
    'likes',
    'liked',
    'liking',
    'have',
    'has',
    'having',
    'had',
    'they',
    'them',
    'their',
    'theirs',
    'i',
    'me',
    'my',
    'mine',
    'you',
    'your',
    'yours',
    'want',
    'wants',
    'wanted',
    'wanting',
    'wanna',
    'do',
    'does',
    'did',
    'doing',
    'done',
    'does',
    'doing',
    'done',
    'provide',
    'provides',
    'provided',
    'providing',
    'give',
    'gives',
    'gave',
    'giving',
    'get',
    'gets',
    'got',
    'getting',
    'receive',
    'receives',
    'received',
    'receiving',
    'is',
    'am',
    'are',
    'was',
    'were',
    'be',
    'been',
    'being',
    'do',
    'does',
    'did',
    'doing',
    'done',
    'said',
    'say',
    'says',
    'saying',
    'tell',
    'tells',
    'telling',
    'told',
    'ask',
    'asks',
    'asking',
    'asked',
    'make',
    'makes',
    'making',
    'made',
    'come',
    'comes',
    'coming',
    'came',
    'go',
    'goes',
    'going',
    'went',
    'get',
    'gets',
    'getting',
    'got',
    'see',
    'sees',
    'seeing',
    'saw',
    'think',
    'thinks',
    'thinking',
    'thought',
    'know',
    'knows',
    'knowing',
    'knew',
    'want',
    'wants',
    'wanted',
    'wanting',
    'wanna',
    'need',
    'needs',
    'needing',
    'needed',
    'use',
    'uses',
    'using',
    'used',
    'much',
    'what',
    'how',
    'one',
    'two',
    'three',
    'four',
    'five',
    'six',
    'seven',
    'eight',
    'nine',
    'ten',
    '0',
    '1',
    '2',
    '3',
    '4',
    '5',
    '6',
    '7',
    '8',
    '9',
];
