<?php

include_once includes('domain/dna.php');
include_once includes('config.php');
$username = 'datanito';
$password = 'at*rF2h@6gC.W#k';
$dna = new \DomainNameApi\DomainNameAPI_PHPLibrary($username, $password);
// Start or resume the session
session_start();
$currencySymbols = array(
    'USD' => '$', // US Dollar
    'EUR' => '€', // Euro
    'TL' => 'TL', // Turkish Lira
);

// Function to call OpenAI API and get the response
function getChatGptResponse($message) {
    // Configure your OpenAI API settings here

    $apiKey = 'sk-proj-wFF0z0nlP0NvmbWIKwVBT3BlbkFJ4junWXkzaSCwLtMPone4';
    $url = 'https://api.openai.com/v1/chat/completions';
    $headers = [
        'Content-Type: application/json',
        'Authorization: Bearer ' . $apiKey
    ];

    $data = [
        'model' => 'gpt-3.5-turbo',
        'messages' => [
            ['role' => 'system', 'content' => 'Your role is to assist our customers in finding the perfect and unique domain name for their online businesses, considering various domain tips and factors. Always return a list of 10 possibilities, each with scores ranging from 0 to 10, in JSON format like this: [{"business_name": "","domain_name": "", "marketing_score" : "", "seo_score" : "", "branding_score" : ""},].'],
//            ['role' => 'system', 'content' => 'Generate unique domain name. return a list of 10 possibilities with scores ranging from 0 to 10 like this: [{"business_name": "","domain_name": "", "marketing_score" : "", "seo_score" : "", "branding_score" : ""},].'],
            ['role' => 'user', 'content' => $message]
        ]
    ];

    $curl = curl_init($url);
    curl_setopt($curl, CURLOPT_POST, true);
    curl_setopt($curl, CURLOPT_POSTFIELDS, json_encode($data));
    curl_setopt($curl, CURLOPT_HTTPHEADER, $headers);
    curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);

    $response = curl_exec($curl);
    $error = curl_error($curl);
    $httpCode = curl_getinfo($curl, CURLINFO_HTTP_CODE);
    curl_close($curl);

    if ($error) {
        echo 'An error occurred: ' . $error;
    } elseif ($httpCode === 429) {
        echo 'Rate limit exceeded. Please wait and try again later.';
    } elseif ($httpCode !== 200) {
        echo 'Invalid response: HTTP ' . $httpCode;
    } else {
        $responseData = json_decode($response, true);
        $botResponse = $responseData['choices'][0]['message']['content'];
        return $botResponse;
    }
}

// Function to generate domain suggestions based on WHOIS data and user input
function generateDomainSuggestions($text) {

    // Generate domain suggestions using ChatGPT
    $suggestions = [];
    $suggestion = getChatGptResponse($text);
    $suggestions[] = $suggestion;

    return $suggestions;
}

// Check if the message is submitted
if (isset($_POST['message'])) {
    $message = $_POST['message'];

    $suggestions = generateDomainSuggestions($message);

    if ($suggestions[0] !== null) {
        $suggestions = json_decode($suggestions[0], true);
    }

    // Check if suggestions are available
    if (!empty($suggestions)) {
        // Check availability for each domain suggestion
        foreach ($suggestions as $key => $suggestion) {
            $domainName = $suggestion['domain_name'];

            // Separate TLD and SLD from the domain name
            $domainParts = explode('.', $domainName);
            $sld = $domainParts[0]; // Second-Level Domain
            $tld = $domainParts[1]; // Top-Level Domain

            // Check availability
            $result = $dna->CheckAvailability([$sld], [$tld], 1, 'create');

            // Assuming there is only one result for each domain
            $domainInfo = $result[0];

            if ($domainInfo['Status'] !== 'available') {
                // Domain not available, remove from suggestions
                unset($suggestions[$key]);
                continue;
            }

            $instagramUsername = checkInstagramUsername($sld);
            $facebookUsername = checkFacebookUsername($sld);
            $twitterUsername = checkTwitterUsername($sld);
            if ($instagramUsername){
                $instagramUsername = '<svg class="w-5 h-5 text-green-400 dark:text-green-700" fill="currentColor" viewBox="0 0 24 24" aria-hidden="true"><path fill-rule="evenodd" d="M12.315 2c2.43 0 2.784.013 3.808.06 1.064.049 1.791.218 2.427.465a4.902 4.902 0 011.772 1.153 4.902 4.902 0 011.153 1.772c.247.636.416 1.363.465 2.427.048 1.067.06 1.407.06 4.123v.08c0 2.643-.012 2.987-.06 4.043-.049 1.064-.218 1.791-.465 2.427a4.902 4.902 0 01-1.153 1.772 4.902 4.902 0 01-1.772 1.153c-.636.247-1.363.416-2.427.465-1.067.048-1.407.06-4.123.06h-.08c-2.643 0-2.987-.012-4.043-.06-1.064-.049-1.791-.218-2.427-.465a4.902 4.902 0 01-1.772-1.153 4.902 4.902 0 01-1.153-1.772c-.247-.636-.416-1.363-.465-2.427-.047-1.024-.06-1.379-.06-3.808v-.63c0-2.43.013-2.784.06-3.808.049-1.064.218-1.791.465-2.427a4.902 4.902 0 011.153-1.772A4.902 4.902 0 015.45 2.525c.636-.247 1.363-.416 2.427-.465C8.901 2.013 9.256 2 11.685 2h.63zm-.081 1.802h-.468c-2.456 0-2.784.011-3.807.058-.975.045-1.504.207-1.857.344-.467.182-.8.398-1.15.748-.35.35-.566.683-.748 1.15-.137.353-.3.882-.344 1.857-.047 1.023-.058 1.351-.058 3.807v.468c0 2.456.011 2.784.058 3.807.045.975.207 1.504.344 1.857.182.466.399.8.748 1.15.35.35.683.566 1.15.748.353.137.882.3 1.857.344 1.054.048 1.37.058 4.041.058h.08c2.597 0 2.917-.01 3.96-.058.976-.045 1.505-.207 1.858-.344.466-.182.8-.398 1.15-.748.35-.35.566-.683.748-1.15.137-.353.3-.882.344-1.857.048-1.055.058-1.37.058-4.041v-.08c0-2.597-.01-2.917-.058-3.96-.045-.976-.207-1.505-.344-1.858a3.097 3.097 0 00-.748-1.15 3.098 3.098 0 00-1.15-.748c-.353-.137-.882-.3-1.857-.344-1.023-.047-1.351-.058-3.807-.058zM12 6.865a5.135 5.135 0 110 10.27 5.135 5.135 0 010-10.27zm0 1.802a3.333 3.333 0 100 6.666 3.333 3.333 0 000-6.666zm5.338-3.205a1.2 1.2 0 110 2.4 1.2 1.2 0 010-2.4z" clip-rule="evenodd"></path></svg>';
            } else{
                $instagramUsername = '<svg class="w-5 h-5 text-gray-400 dark:text-gray-500" fill="currentColor" viewBox="0 0 24 24" aria-hidden="true"><path fill-rule="evenodd" d="M12.315 2c2.43 0 2.784.013 3.808.06 1.064.049 1.791.218 2.427.465a4.902 4.902 0 011.772 1.153 4.902 4.902 0 011.153 1.772c.247.636.416 1.363.465 2.427.048 1.067.06 1.407.06 4.123v.08c0 2.643-.012 2.987-.06 4.043-.049 1.064-.218 1.791-.465 2.427a4.902 4.902 0 01-1.153 1.772 4.902 4.902 0 01-1.772 1.153c-.636.247-1.363.416-2.427.465-1.067.048-1.407.06-4.123.06h-.08c-2.643 0-2.987-.012-4.043-.06-1.064-.049-1.791-.218-2.427-.465a4.902 4.902 0 01-1.772-1.153 4.902 4.902 0 01-1.153-1.772c-.247-.636-.416-1.363-.465-2.427-.047-1.024-.06-1.379-.06-3.808v-.63c0-2.43.013-2.784.06-3.808.049-1.064.218-1.791.465-2.427a4.902 4.902 0 011.153-1.772A4.902 4.902 0 015.45 2.525c.636-.247 1.363-.416 2.427-.465C8.901 2.013 9.256 2 11.685 2h.63zm-.081 1.802h-.468c-2.456 0-2.784.011-3.807.058-.975.045-1.504.207-1.857.344-.467.182-.8.398-1.15.748-.35.35-.566.683-.748 1.15-.137.353-.3.882-.344 1.857-.047 1.023-.058 1.351-.058 3.807v.468c0 2.456.011 2.784.058 3.807.045.975.207 1.504.344 1.857.182.466.399.8.748 1.15.35.35.683.566 1.15.748.353.137.882.3 1.857.344 1.054.048 1.37.058 4.041.058h.08c2.597 0 2.917-.01 3.96-.058.976-.045 1.505-.207 1.858-.344.466-.182.8-.398 1.15-.748.35-.35.566-.683.748-1.15.137-.353.3-.882.344-1.857.048-1.055.058-1.37.058-4.041v-.08c0-2.597-.01-2.917-.058-3.96-.045-.976-.207-1.505-.344-1.858a3.097 3.097 0 00-.748-1.15 3.098 3.098 0 00-1.15-.748c-.353-.137-.882-.3-1.857-.344-1.023-.047-1.351-.058-3.807-.058zM12 6.865a5.135 5.135 0 110 10.27 5.135 5.135 0 010-10.27zm0 1.802a3.333 3.333 0 100 6.666 3.333 3.333 0 000-6.666zm5.338-3.205a1.2 1.2 0 110 2.4 1.2 1.2 0 010-2.4z" clip-rule="evenodd"></path></svg>';
            }
            if ($facebookUsername){
                $facebookUsername = '<svg class="w-5 h-5 text-green-400 dark:text-green-700" fill="currentColor" viewBox="0 0 24 24" aria-hidden="true"><path fill-rule="evenodd" d="M22 12c0-5.523-4.477-10-10-10S2 6.477 2 12c0 4.991 3.657 9.128 8.438 9.878v-6.987h-2.54V12h2.54V9.797c0-2.506 1.492-3.89 3.777-3.89 1.094 0 2.238.195 2.238.195v2.46h-1.26c-1.243 0-1.63.771-1.63 1.562V12h2.773l-.443 2.89h-2.33v6.988C18.343 21.128 22 16.991 22 12z" clip-rule="evenodd"></path></svg>';
            } else{
                $facebookUsername = '<svg class="w-5 h-5 text-gray-400 dark:text-gray-500" fill="currentColor" viewBox="0 0 24 24" aria-hidden="true"><path fill-rule="evenodd" d="M22 12c0-5.523-4.477-10-10-10S2 6.477 2 12c0 4.991 3.657 9.128 8.438 9.878v-6.987h-2.54V12h2.54V9.797c0-2.506 1.492-3.89 3.777-3.89 1.094 0 2.238.195 2.238.195v2.46h-1.26c-1.243 0-1.63.771-1.63 1.562V12h2.773l-.443 2.89h-2.33v6.988C18.343 21.128 22 16.991 22 12z" clip-rule="evenodd"></path></svg>';
            }
            if ($twitterUsername){
                $twitterUsername = '<svg class="w-5 h-5 text-green-400 dark:text-green-700" fill="currentColor" viewBox="0 0 24 24" aria-hidden="true"><path d="M13.795 10.533 20.68 2h-3.073l-5.255 6.517L7.69 2H1l7.806 10.91L1.47 22h3.074l5.705-7.07L15.31 22H22l-8.205-11.467Zm-2.38 2.95L9.97 11.464 4.36 3.627h2.31l4.528 6.317 1.443 2.02 6.018 8.409h-2.31l-4.934-6.89Z"/></svg>';
            } else{
                $twitterUsername = '<svg class="w-5 h-5 text-gray-400 dark:text-gray-500" fill="currentColor" viewBox="0 0 24 24" aria-hidden="true"><path d="M13.795 10.533 20.68 2h-3.073l-5.255 6.517L7.69 2H1l7.806 10.91L1.47 22h3.074l5.705-7.07L15.31 22H22l-8.205-11.467Zm-2.38 2.95L9.97 11.464 4.36 3.627h2.31l4.528 6.317 1.443 2.02 6.018 8.409h-2.31l-4.934-6.89Z"/></svg>';
            }
            $priceWithDecimal = $domainInfo['Price'];
            $currency = $domainInfo['Currency'];

            // Convert price based on conditions
            if ($currentCurrency === 'TRY' && $currency === 'TL') {
                $price = round($priceWithDecimal, 2);
                $currencySymbol = getCurrencySign($currentCurrency);
            } elseif ($currentCurrency === 'TRY' && $currency === 'USD') {
                $price = round($priceWithDecimal * $conversionRate, 2);
                $currencySymbol = getCurrencySign($currentCurrency);
            } elseif ($currentCurrency === 'USD' && $currency === 'USD') {
                $price = round($priceWithDecimal * $conversionRate, 2);
                $currencySymbol = getCurrencySign($currentCurrency);
            } elseif ($currentCurrency === 'USD' && $currency === 'TL') {
                $price = round($priceWithDecimal / $tlRate, 2);
                $currencySymbol = getCurrencySign($currentCurrency);
            } else {
                $price = ($currency === 'TL') ? round($priceWithDecimal * $conversionRate, 2) : $priceWithDecimal;
                $currencySymbol = getCurrencySign($currentCurrency);
            }
            $checkoutPrice = round($price, 2);

            // Remove trailing zeros from the price
            $formattedPrice = number_format($price, 2, '.', '');
            $formattedPrice = rtrim($formattedPrice, '0');
            $formattedPrice = rtrim($formattedPrice, '.');

            // Calculate increased price
            $increasedPrice = round($price * 1.20, 2);

            // Format prices with appropriate currency symbol
            $normalPrice = ($currencySymbol === ' TL') ? $increasedPrice . $currencySymbol : $currencySymbol . number_format($increasedPrice, 2);
            $renderPrice = ($currencySymbol === ' TL') ? $formattedPrice . $currencySymbol : $currencySymbol . $formattedPrice;


            // Domain available, add pricing details
            $suggestions[$key]['sld'] = $sld;
            $suggestions[$key]['tld'] = $tld;
            $suggestions[$key]['instagram'] = $instagramUsername;
            $suggestions[$key]['facebook'] = $facebookUsername;
            $suggestions[$key]['twitter'] = $twitterUsername;
            $suggestions[$key]['offer_price'] = $formattedPrice;
            $suggestions[$key]['formatted_price'] = $increasedPrice;
            $suggestions[$key]['price'] = $normalPrice;
            $suggestions[$key]['discounted_price'] = $renderPrice;
            $suggestions[$key]['currency'] = $currencySymbol;
            // Add any other data you need here
        }
    } else {
        // Handle case when no suggestions are available
        echo $lang['ai-register-error'];
        exit; // Terminate script
    }
    // Calculate overall score for each suggestion
    foreach ($suggestions as &$item) {
        // Calculate overall score by summing up individual scores
        $overallScore = $item['marketing_score'] + $item['seo_score'] + $item['branding_score'];
        $item['overall_score'] = $overallScore;
    }
    unset($item); // Unset reference variable to avoid unexpected behavior in the next loop

    // Sort the suggestions array based on the overall score
    usort($suggestions, function($a, $b) {
        return $b['overall_score'] - $a['overall_score'];
    });

    // Start building the HTML content
    $html = '';

    // Add the best choice as the first item
    $bestChoice = array_shift($suggestions);
    $isFavorite = false;
    $html .= '
            <div class="block md:flex items-center justify-start space-x-4 mb-1 md:mb-2 mt-3 md:mt-6">
                <span class="flex items-center space-x-1">
                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor" class="w-6 h-6 text-purple-300 dark:text-purple-400"> <path fill-rule="evenodd" d="M9 4.5a.75.75 0 01.721.544l.813 2.846a3.75 3.75 0 002.576 2.576l2.846.813a.75.75 0 010 1.442l-2.846.813a3.75 3.75 0 00-2.576 2.576l-.813 2.846a.75.75 0 01-1.442 0l-.813-2.846a3.75 3.75 0 00-2.576-2.576l-2.846-.813a.75.75 0 010-1.442l2.846-.813A3.75 3.75 0 007.466 7.89l.813-2.846A.75.75 0 019 4.5zM18 1.5a.75.75 0 01.728.568l.258 1.036c.236.94.97 1.674 1.91 1.91l1.036.258a.75.75 0 010 1.456l-1.036.258c-.94.236-1.674.97-1.91 1.91l-.258 1.036a.75.75 0 01-1.456 0l-.258-1.036a2.625 2.625 0 00-1.91-1.91l-1.036-.258a.75.75 0 010-1.456l1.036-.258a2.625 2.625 0 001.91-1.91l.258-1.036A.75.75 0 0118 1.5zM16.5 15a.75.75 0 01.712.513l.394 1.183c.15.447.5.799.948.948l1.183.395a.75.75 0 010 1.422l-1.183.395c-.447.15-.799.5-.948.948l-.395 1.183a.75.75 0 01-1.422 0l-.395-1.183a1.5 1.5 0 00-.948-.948l-1.183-.395a.75.75 0 010-1.422l1.183-.395c.447-.15.799-.5.948-.948l.395-1.183A.75.75 0 0116.5 15z" clip-rule="evenodd"></path> </svg>   
                    <h3 class="text-lg font-semibold text-gray-800 dark:text-gray-200">' . $bestChoice['business_name'] . '</h3>
                </span>
                <span class="flex items-center justify-end mb-4 md:mb-0">
                    <span class="flex items-center space-x-2 text-base font-normal text-green-700 dark:text-green-300 px-4 py-1 rounded-full bg-green-50 dark:bg-green-900">'. $lang['ai-register-ai-top-pick'] .'</span>
                </span>
            </div>
            <div class="flex items-center md:ml-4 mb-2 md:mb-4 space-x-3">
               <span class="flex items-center space-x-2 bg-gray-50 dark:bg-dark-600 rounded-full text-sm font-normal px-2 md:px-4 py-1 text-gray-600 dark:text-gray-400">
                   <span class="flex items-center space-x-2 text-sm"> '. $lang['ai-register-marketing-score'] .'</span>
                   <span>' . $bestChoice['marketing_score'] . '/10</span>
               </span>    
               <span class="flex items-center space-x-2 bg-gray-50 dark:bg-dark-600 rounded-full text-sm font-normal px-2 md:px-4 py-1 text-gray-600 dark:text-gray-400">
                   <span class="flex items-center space-x-2 text-sm"> '. $lang['ai-register-seo-score'] .'</span>
                   <span>' . $bestChoice['seo_score'] . '/10</span>
               </span>     
               <span class="flex items-center space-x-2 bg-gray-50 dark:bg-dark-600 rounded-full text-sm font-normal px-2 md:px-4 py-1 text-gray-600 dark:text-gray-400">
                   <span class="flex items-center space-x-2 text-sm"> '. $lang['ai-register-branding-score'] .'</span>
                   <span>' . $bestChoice['branding_score'] . '/10</span>
               </span>             
               <span class="flex items-center space-x-2 bg-gray-50 dark:bg-dark-600 rounded-full text-sm font-normal px-2 md:px-4 py-1 text-gray-600 dark:text-gray-400 hidden">
                   <span>' . $bestChoice['instagram'] . '</span>
                   <span>' . $bestChoice['facebook'] . '</span>
                   <span>' . $bestChoice['twitter'] . '</span>
               </span>
            </div>
            <div class="block md:flex justify-between items-center mb-3 py-3 px-5 space-y-4 md:space-y-0 md:h-20 bg-white border border-gray-200 rounded-3xl hover:bg-gray-100 dark:bg-dark-700 dark:border-dark-600 dark:hover:bg-dark-700">
                <span class="flex items-center space-x-4">
                    <span class="flex items-center justify-start font-bold cursor-pointer favorite-icon" data-offer-price="'.$bestChoice['offer_price'].'" data-price="'.$bestChoice['formatted_price'].'" data-domain="'.$bestChoice['sld'].'" data-tld="'.$bestChoice['tld'].'" data-status="available" data-render-price="'.$bestChoice['discounted_price'].'" data-normal-price="'.$bestChoice['price'].'" data-currency="'.$bestChoice['currency'].'" data-quantity="1">
                        <svg class="w-5 h-5 ' . ($isFavorite ? "text-red-600 fill-red-600" : "text-dark-600 fill-white dark:text-white dark:fill-dark-900") . '" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 21 19">
                        <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 4C5.5-1.5-1.5 5.5 4 11l7 7 7-7c5.458-5.458-1.542-12.458-7-7Z"/>
                        </svg>
                    </span>      
                    <span class="flex items-center justify-start font-bold">' . $bestChoice['sld'] . '<span class="text-green-600">.' . $bestChoice['tld'] . '</span></span>
                </span>
                <span class="flex items-center justify-between">
                  <span>
                        <span class="block text-sm font-medium text-gray-900 line-through dark:text-white mr-2">' . $bestChoice['price'] . '</span>
                        <span class="block text-lg text-gray-700 mr-4 font-semibold dark:text-white">' . $bestChoice['discounted_price'] . '</span>
                  </span>
                  <button data-offer-price="'.$bestChoice['offer_price'].'" data-price="'.$bestChoice['formatted_price'].'" data-currency="'.$bestChoice['currency'].'" data-product-id="16" data-domain="'.$bestChoice['sld'].'" data-tld="'.$bestChoice['tld'].'" data-quantity="1" class="add-to-cart-btn-domain w-[9em] flex items-center justify-center button-ux btn-arrow cursor-pointer text-white bg-blue-600 hover:bg-blue-700 focus:ring-4 focus:ring-blue-500 font-medium rounded-3xl text-sm px-4 py-3 text-center dark:text-white dark:focus:ring-blue-700">
                      <span>
                      <svg aria-hidden="true" class="w-5 h-5 text-gray-200 animate-spin dark:text-gray-300 fill-dark-500 spinner-status hidden" viewBox="0 0 100 101" fill="none" xmlns="http://www.w3.org/2000/svg">
                         <path d="M100 50.5908C100 78.2051 77.6142 100.591 50 100.591C22.3858 100.591 0 78.2051 0 50.5908C0 22.9766 22.3858 0.59082 50 0.59082C77.6142 0.59082 100 22.9766 100 50.5908ZM9.08144 50.5908C9.08144 73.1895 27.4013 91.5094 50 91.5094C72.5987 91.5094 90.9186 73.1895 90.9186 50.5908C90.9186 27.9921 72.5987 9.67226 50 9.67226C27.4013 9.67226 9.08144 27.9921 9.08144 50.5908Z" fill="currentColor"/>
                         <path d="M93.9676 39.0409C96.393 38.4038 97.8624 35.9116 97.0079 33.5539C95.2932 28.8227 92.871 24.3692 89.8167 20.348C85.8452 15.1192 80.8826 10.7238 75.2124 7.41289C69.5422 4.10194 63.2754 1.94025 56.7698 1.05124C51.7666 0.367541 46.6976 0.446843 41.7345 1.27873C39.2613 1.69328 37.813 4.19778 38.4501 6.62326C39.0873 9.04874 41.5694 10.4717 44.0505 10.1071C47.8511 9.54855 51.7191 9.52689 55.5402 10.0491C60.8642 10.7766 65.9928 12.5457 70.6331 15.2552C75.2735 17.9648 79.3347 21.5619 82.5849 25.841C84.9175 28.9121 86.7997 32.2913 88.1811 35.8758C89.083 38.2158 91.5421 39.6781 93.9676 39.0409Z" fill="currentFill"/>
                      </svg>
                      <span class="sr-only">Loading...</span>
                      </span>
                      <span class="add-to-cart-cta">'. $lang['domain-register-cta'] .'</span>
                  </button>
                </span>
            </div>    
            <hr class="h-px my-8 bg-gray-200 border-0 dark:bg-gray-700">
        ';
    foreach ($suggestions as $item) {
        $isFavorite = false;
        foreach ($_SESSION['favorite_domains'] ?? array() as $favoriteDomain) {
            if ($favoriteDomain['domain'] === $item['sld'] && $favoriteDomain['tld'] === $item['tld']) {
                $isFavorite = true;
                break;
            }
        }
        $html .= '
            <div class="flex items-center justify-start space-x-1 mb-1 md:mb-2 mt-2 md:mt-4">
                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor" class="w-6 h-6 text-purple-300 dark:text-purple-400"> <path fill-rule="evenodd" d="M9 4.5a.75.75 0 01.721.544l.813 2.846a3.75 3.75 0 002.576 2.576l2.846.813a.75.75 0 010 1.442l-2.846.813a3.75 3.75 0 00-2.576 2.576l-.813 2.846a.75.75 0 01-1.442 0l-.813-2.846a3.75 3.75 0 00-2.576-2.576l-2.846-.813a.75.75 0 010-1.442l2.846-.813A3.75 3.75 0 007.466 7.89l.813-2.846A.75.75 0 019 4.5zM18 1.5a.75.75 0 01.728.568l.258 1.036c.236.94.97 1.674 1.91 1.91l1.036.258a.75.75 0 010 1.456l-1.036.258c-.94.236-1.674.97-1.91 1.91l-.258 1.036a.75.75 0 01-1.456 0l-.258-1.036a2.625 2.625 0 00-1.91-1.91l-1.036-.258a.75.75 0 010-1.456l1.036-.258a2.625 2.625 0 001.91-1.91l.258-1.036A.75.75 0 0118 1.5zM16.5 15a.75.75 0 01.712.513l.394 1.183c.15.447.5.799.948.948l1.183.395a.75.75 0 010 1.422l-1.183.395c-.447.15-.799.5-.948.948l-.395 1.183a.75.75 0 01-1.422 0l-.395-1.183a1.5 1.5 0 00-.948-.948l-1.183-.395a.75.75 0 010-1.422l1.183-.395c.447-.15.799-.5.948-.948l.395-1.183A.75.75 0 0116.5 15z" clip-rule="evenodd"></path> </svg>   
                <h3 class="text-lg font-semibold text-gray-800 dark:text-gray-200">' . $item['business_name'] . '</h3>
            </div>
            <div class="flex items-center md:ml-4 mb-2 md:mb-4 space-x-3">
               <span class="flex items-center space-x-2 bg-gray-50 dark:bg-dark-600 rounded-full text-sm font-normal px-2 md:px-4 py-1 text-gray-600 dark:text-gray-400">
                   <span class="flex items-center space-x-2 text-sm"> '. $lang['ai-register-marketing-score'] .'</span>
                   <span>' . $item['marketing_score'] . '/10</span>
               </span>    
               <span class="flex items-center space-x-2 bg-gray-50 dark:bg-dark-600 rounded-full text-sm font-normal px-2 md:px-4 py-1 text-gray-600 dark:text-gray-400">
                   <span class="flex items-center space-x-2 text-sm"> '. $lang['ai-register-seo-score'] .'</span>
                   <span>' . $item['seo_score'] . '/10</span>
               </span>     
               <span class="flex items-center space-x-2 bg-gray-50 dark:bg-dark-600 rounded-full text-sm font-normal px-2 md:px-4 py-1 text-gray-600 dark:text-gray-400">
                   <span class="flex items-center space-x-2 text-sm"> '. $lang['ai-register-branding-score'] .'</span>
                   <span>' . $item['branding_score'] . '/10</span>
               </span>
               <span class="flex items-center space-x-2 bg-gray-50 dark:bg-dark-600 rounded-full text-sm font-normal px-2 md:px-4 py-1 text-gray-600 dark:text-gray-400 hidden">
                   <span>' . $item['instagram'] . '</span>
                   <span>' . $item['facebook'] . '</span>
                   <span>' . $item['twitter'] . '</span>
               </span>
            </div>
            <div class="block md:flex justify-between items-center mb-3 py-3 px-5 space-y-4 md:space-y-0 md:h-20 bg-white border border-gray-200 rounded-3xl hover:bg-gray-100 dark:bg-dark-700 dark:border-dark-600 dark:hover:bg-dark-700">
                <span class="flex items-center space-x-4">
                    <span class="flex items-center justify-start font-bold cursor-pointer favorite-icon" data-offer-price="'.$bestChoice['offer_price'].'" data-price="'.$bestChoice['formatted_price'].'" data-domain="'.$item['sld'].'" data-tld="'.$item['tld'].'" data-status="available" data-render-price="'.$item['discounted_price'].'" data-normal-price="'.$item['price'].'" data-currency="'.$item['currency'].'" data-quantity="1">
                        <svg class="w-5 h-5 ' . ($isFavorite ? "text-red-600 fill-red-600" : "text-dark-600 fill-white dark:text-white dark:fill-dark-900") . '" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 21 19">
                        <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 4C5.5-1.5-1.5 5.5 4 11l7 7 7-7c5.458-5.458-1.542-12.458-7-7Z"/>
                        </svg>
                    </span>    
                    <span class="flex items-center justify-start font-bold">' . $item['sld'] . '<span class="text-green-600">.' . $item['tld'] . '</span></span>
                </span>
                <span class="flex items-center justify-between">
                  <span>
                        <span class="block text-sm font-medium text-gray-900 line-through dark:text-white mr-2">' . $item['price'] . '</span>
                        <span class="block text-lg text-gray-700 mr-4 font-semibold dark:text-white">' . $item['discounted_price'] . '</span>
                  </span>
                  <button data-offer-price="'.$bestChoice['offer_price'].'" data-price="'.$bestChoice['formatted_price'].'" data-currency="'.$item['currency'].'" data-product-id="16" data-domain="'.$item['sld'].'" data-tld="'.$item['tld'].'" data-quantity="1" class="add-to-cart-btn-domain w-[9em] flex items-center justify-center button-ux btn-arrow cursor-pointer text-white bg-blue-600 hover:bg-blue-700 focus:ring-4 focus:ring-blue-500 font-medium rounded-3xl text-sm px-4 py-3 text-center dark:text-white dark:focus:ring-blue-700">
                      <span>
                      <svg aria-hidden="true" class="w-5 h-5 text-gray-200 animate-spin dark:text-gray-300 fill-dark-500 spinner-status hidden" viewBox="0 0 100 101" fill="none" xmlns="http://www.w3.org/2000/svg">
                         <path d="M100 50.5908C100 78.2051 77.6142 100.591 50 100.591C22.3858 100.591 0 78.2051 0 50.5908C0 22.9766 22.3858 0.59082 50 0.59082C77.6142 0.59082 100 22.9766 100 50.5908ZM9.08144 50.5908C9.08144 73.1895 27.4013 91.5094 50 91.5094C72.5987 91.5094 90.9186 73.1895 90.9186 50.5908C90.9186 27.9921 72.5987 9.67226 50 9.67226C27.4013 9.67226 9.08144 27.9921 9.08144 50.5908Z" fill="currentColor"/>
                         <path d="M93.9676 39.0409C96.393 38.4038 97.8624 35.9116 97.0079 33.5539C95.2932 28.8227 92.871 24.3692 89.8167 20.348C85.8452 15.1192 80.8826 10.7238 75.2124 7.41289C69.5422 4.10194 63.2754 1.94025 56.7698 1.05124C51.7666 0.367541 46.6976 0.446843 41.7345 1.27873C39.2613 1.69328 37.813 4.19778 38.4501 6.62326C39.0873 9.04874 41.5694 10.4717 44.0505 10.1071C47.8511 9.54855 51.7191 9.52689 55.5402 10.0491C60.8642 10.7766 65.9928 12.5457 70.6331 15.2552C75.2735 17.9648 79.3347 21.5619 82.5849 25.841C84.9175 28.9121 86.7997 32.2913 88.1811 35.8758C89.083 38.2158 91.5421 39.6781 93.9676 39.0409Z" fill="currentFill"/>
                      </svg>
                      <span class="sr-only">Loading...</span>
                      </span>
                      <span class="add-to-cart-cta">'. $lang['domain-register-cta'] .'</span>
                  </button>
                </span>
            </div>    
        ';
    }

    // Return the HTML content
    echo $html;
}
function getCurrencySign($currency) {
    // Define currency signs for different currencies
    $currencySigns = [
        'USD' => '$',
        'EUR' => '€',
        'GBP' => '£',
        'TRY' => ' TL', // Added space before the TRY sign
    ];

    // Default to '$' if the currency is not recognized
    return $currencySigns[$currency] ?? '$';
}
// Function to check Instagram username availability
// Function to check Instagram username availability
function checkInstagramUsername($username) {
    // Prepare the URL to check Instagram username availability
    $url = 'https://www.instagram.com/' . $username;

    // Initialize cURL session
    $ch = curl_init();

    // Set cURL options
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_TIMEOUT, 10);

    // Execute the request
    $response = curl_exec($ch);

    // Check for cURL errors
    if(curl_errno($ch)) {
        // If an error occurred, return false
        curl_close($ch);
        return false;
    }

    // Get the HTTP status code
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);

    // Close cURL session
    curl_close($ch);

    // If HTTP status code is not 200, return false
    if($httpCode !== 200) {
        return false;
    }

    // If response contains "error", the username is not available
    return strpos($response, '"error"') === false;
}

// Function to check Facebook username availability
function checkFacebookUsername($username) {
    // Prepare the URL to check Facebook username availability
    $url = 'https://www.facebook.com/' . $username;

    // Initialize cURL session
    $ch = curl_init();

    // Set cURL options
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_TIMEOUT, 10);

    // Execute the request
    $response = curl_exec($ch);

    // Get the HTTP status code
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);

    // Close cURL session
    curl_close($ch);

    // If HTTP status code is 404, the username is available
    return $httpCode == 404;
}

// Function to check Twitter username availability
function checkTwitterUsername($username) {
    // Prepare the URL to check Twitter username availability
    $url = 'https://twitter.com/users/username_available?username=' . $username;

    // Initialize cURL session
    $ch = curl_init();

    // Set cURL options
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_TIMEOUT, 10);

    // Execute the request
    $response = curl_exec($ch);

    // Get the HTTP status code
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);

    // Close cURL session
    curl_close($ch);

    // If HTTP status code is 200 and response contains "valid":true, the username is available
    return $httpCode == 200 && strpos($response, '"valid":true') !== false;
}

?>
