<?php
session_start();

// Function to generate a bot message
function generateBotMessage($text, $buttons = []) {
    return [
        'text' => $text,
        'sender' => 'assistant',
        'buttons' => $buttons,
    ];
}

// Function to calculate the Jaccard similarity coefficient between two sets
function jaccardSimilarity($a, $b) {
    $intersection = count(array_intersect($a, $b));
    $union = count(array_unique(array_merge($a, $b)));
    return $intersection / $union;
}

// Function to handle the incoming message
function handleMessage($message) {
    // Initialize response array
    $response = [
        'chat_messages' => [],
    ];

    // Convert user input to lowercase for easier processing
    $userInput = strtolower($message);
    $time = date('g:i A');

    // Process user input and provide appropriate responses
    $matchedAnswer = null;
    $maxSimilarity = 0;

    // Dataset with question-answer pairs
    include_once includes('dino/language/'.$_SESSION["country"].'.php');
    include_once includes('config.php');


    // Convert user input to an array of words
    $userWords = preg_split('/\s+/', $userInput, -1, PREG_SPLIT_NO_EMPTY);

    // Find the closest matching answer based on Jaccard similarity coefficient
    foreach ($qaPairs as $qaPair) {
        if (isset($qaPair['keywords']) && is_array($qaPair['keywords'])) {
            foreach ($qaPair['keywords'] as $keyword) {
                // Convert keyword to lowercase and check if it's not in the ignored words list
                $keywordWords = array_diff(preg_split('/\s+/', strtolower($keyword), -1, PREG_SPLIT_NO_EMPTY), $ignoredWords);
                $userWordsFiltered = array_diff($userWords, $ignoredWords);

                $similarity = jaccardSimilarity($userWordsFiltered, $keywordWords);

                if ($similarity > $maxSimilarity) {
                    $maxSimilarity = $similarity;
                    $matchedAnswer = $qaPair;
                }
            }
        }
    }


    // If a matching answer is found and the similarity is above a threshold, generate and store the bot response
    $threshold = 0.2;
    if ($matchedAnswer && $maxSimilarity >= $threshold) {
        $responseText = $matchedAnswer['answers'][array_rand($matchedAnswer['answers'])];
        $voice = $matchedAnswer['voice'];
        $buttons = $matchedAnswer['buttons'];

        // Add bot response to chat history
        $botMessage = generateBotMessage($responseText, $buttons);
        $_SESSION['chatHistory'][] = $botMessage;
        $response['chat_messages'][] = $botMessage;
    } else {
        // If no close match found, provide a generic response
        $responseText = $dino['answers'][array_rand($dino['answers'])];
        $botMessage = generateBotMessage($responseText, $dino['buttons']);
        $_SESSION['chatHistory'][] = $botMessage;
        $response['chat_messages'][] = $botMessage;
    }

    return $response;
}

// Check if a message is submitted
if (isset($_POST['message'])) {
    $message = $_POST['message'];

    // Handle the message
    $response = handleMessage($message);

    // Generate a response in JSON format
    echo json_encode($response);
}
?>
