<?php
include_once includes('config.php');

// Retrieve parameters from the AJAX request
$message = $_POST['message'];
$attachmentVision = isset($_POST['attachment_vision']) ? $_POST['attachment_vision'] : '';
$attachment_file = '';

// Check if the attachment file is uploaded
if (isset($_FILES['attachment_file']) && $_FILES['attachment_file']['error'] === UPLOAD_ERR_OK) {
    $attachment_file = uploadDinoVision();
}

$conversationName = substr($message, 0, 24);
$userID = isset($_SESSION['user']['id']) ? $_SESSION['user']['id'] : '';

// Initialize $conversationID
if (isset($_POST['conversationId'])) {
    $conversationID = $_POST['conversationId'];
    if (strlen($conversationID) < 36) {
        $conversationID = generateUniqueID();
        saveConversationIDToDatabase($userID, $conversationName, $conversationID, $conn);
    }
} else {
    $conversationID = generateUniqueID();
    saveConversationIDToDatabase($userID, $conversationName, $conversationID, $conn);
}

// Save the user's message to the database
saveMessageToDatabase($conversationID, 'user', $message, $attachmentVision, $attachment_file, $conn);

// Retrieve the conversation history from the database
$conversationHistory = getConversationHistoryFromDatabase($conversationID, $conn);

// Make a request to the ChatGPT API
$response = getChatGptResponse($conversationHistory, $conversationID, $conn);

// Extract and display the bot's response
$botResponse = $response['response'];

// Return conversation ID and bot response as JSON
$responseArray = [
    'id' => $conversationID,
    'response' => $botResponse,
];

echo json_encode($responseArray);

// Function to upload attachment
function uploadDinoVision() {
    $uploadDirectory = $_SERVER['DOCUMENT_ROOT'] . '/assets/uploads/dino/';
    $originalFilename = $_FILES['attachment_file']['name'];
    $filename = uniqid() . '_' . $originalFilename;
    if (move_uploaded_file($_FILES['attachment_file']['tmp_name'], $uploadDirectory . $filename)) {
        return $filename;
    } else {
        return ''; // Return empty string on failure
    }
}

// Function to generate unique ID
function generateUniqueID() {
    return sprintf('%04x%04x-%04x-%04x-%04x-%04x%04x%04x',
        mt_rand(0, 0xffff), mt_rand(0, 0xffff),
        mt_rand(0, 0xffff),
        mt_rand(0, 0x0fff) | 0x4000,
        mt_rand(0, 0x3fff) | 0x8000,
        mt_rand(0, 0xffff), mt_rand(0, 0xffff), mt_rand(0, 0xffff)
    );
}

// Function to save conversation ID to database
function saveConversationIDToDatabase($userID, $conversationName, $conversationID, $conn) {
    $query = "INSERT INTO dino_conversations (user_id, conversation_name, conversation_id) VALUES (?, ?, ?)";
    $stmt = mysqli_prepare($conn, $query);
    mysqli_stmt_bind_param($stmt, "iss", $userID, $conversationName, $conversationID);
    mysqli_stmt_execute($stmt);
    mysqli_stmt_close($stmt);
}

// Function to save message to database
function saveMessageToDatabase($conversationID, $role, $content, $attachmentVision, $attachment_file, $conn) {
    $query = "INSERT INTO dino_messages (conversation_id, role, content, attachment_vision, attachment_filename) VALUES (?, ?, ?, ?, ?)";
    $stmt = mysqli_prepare($conn, $query);
    mysqli_stmt_bind_param($stmt, "sssss", $conversationID, $role, $content, $attachmentVision, $attachment_file);
    mysqli_stmt_execute($stmt);
    mysqli_stmt_close($stmt);
}

// Function to retrieve conversation history from database
function getConversationHistoryFromDatabase($conversationID, $conn) {
    $query = "SELECT role, content, attachment_vision FROM dino_messages WHERE conversation_id = ? ORDER BY created_at ASC";
    $stmt = mysqli_prepare($conn, $query);
    mysqli_stmt_bind_param($stmt, "s", $conversationID);
    mysqli_stmt_execute($stmt);
    $result = mysqli_stmt_get_result($stmt);
    $conversationHistory = [];
    while ($row = mysqli_fetch_assoc($result)) {
        $conversationHistory[] = ['role' => $row['role'], 'content' => $row['content'], 'attachment_vision' => $row['attachment_vision']];
    }
    mysqli_stmt_close($stmt);
    return $conversationHistory;
}

// Function to get response from ChatGPT API
function getChatGptResponse($conversationHistory, $conversationID, $conn) {
    $apiKey = 'sk-proj-wFF0z0nlP0NvmbWIKwVBT3BlbkFJ4junWXkzaSCwLtMPone4'; // Replace with your API key
    $url = 'https://api.openai.com/v1/chat/completions';
    $headers = [
        'Content-Type: application/json',
        'Authorization: Bearer ' . $apiKey
    ];
    $data = [
        'model' => 'gpt-3.5-turbo',
        'messages' => [
            ['role' => 'system', 'name' => 'Dino', 'content' => 'You are a helpful assistant for online businesses. Your name is Dino. You were created and developed by Datanito. Datanito is a real software and technology company.']
        ]
    ];
    foreach ($conversationHistory as $message) {
        $data['messages'][] = ['role' => $message['role'], 'content' => $message['content'] . $message['attachment_vision']];
    }
    $data['messages'][] = ['role' => 'user', 'content' => '']; // Add the user message content here
    $curl = curl_init($url);
    curl_setopt($curl, CURLOPT_POST, true);
    curl_setopt($curl, CURLOPT_POSTFIELDS, json_encode($data));
    curl_setopt($curl, CURLOPT_HTTPHEADER, $headers);
    curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
    $response = curl_exec($curl);
    $error = curl_error($curl);
    $httpCode = curl_getinfo($curl, CURLINFO_HTTP_CODE);
    curl_close($curl);
    if ($error) {
        return ['response' => 'An error occurred: ' . $error];
    } elseif ($httpCode === 429) {
        return ['response' => 'Rate limit exceeded. Please wait and try again later.'];
    } elseif ($httpCode !== 200) {
        return ['response' => 'Invalid response: HTTP ' . $httpCode];
    } else {
        $responseData = json_decode($response, true);
        $botResponse = $responseData['choices'][0]['message']['content'];
        saveMessageToDatabase($conversationID, 'assistant', $botResponse, NULL, NULL, $conn);
        return ['response' => $botResponse];
    }
}
?>
