<?php
include_once includes('config.php');
header('Content-Type: application/json');

if (!isset($_SESSION['user']['id'])) {
    die(json_encode(['error' => 'Unauthorized']));
}

$user_id = $_SESSION['user']['id'];

// Get notifications from database
$stmt = $conn->prepare("
    SELECT title, message, type, created_at 
    FROM hosting_notifications 
    WHERE user_id = ? OR user_id IS NULL
    ORDER BY created_at DESC 
    LIMIT 5
");
$stmt->bind_param("i", $user_id);
$stmt->execute();
$result = $stmt->get_result();

$notifications = [];
while ($row = $result->fetch_assoc()) {
    $notifications[] = [
        'title' => $row['title'],
        'message' => $row['message'],
        'type' => $row['type'],
        'time' => time_elapsed_string($row['created_at']),
        'icon' => getNotificationIcon($row['type'])
    ];
}

// Add system notifications based on server status
$notifications = array_merge(checkSystemNotifications($user_id), $notifications);

echo json_encode(array_slice($notifications, 0, 5));

function time_elapsed_string($datetime) {
    // Same function as in activity.php
}

function getNotificationIcon($type) {
    $icons = [
        'info' => 'info',
        'warning' => 'warning',
        'error' => 'error',
        'success' => 'check_circle'
    ];

    return $icons[strtolower($type)] ?? 'notifications';
}

function checkSystemNotifications($user_id) {
    global $conn;

    $notifications = [];

    // Check disk space
    $stmt = $conn->prepare("
        SELECT disk_used, disk_limit 
        FROM hosting_stats 
        WHERE user_id = ?
        ORDER BY created_at DESC 
        LIMIT 1
    ");
    $stmt->bind_param("i", $user_id);
    $stmt->execute();
    $result = $stmt->get_result();
    $stats = $result->fetch_assoc();

    if ($stats && $stats['disk_limit'] !== 'unlimited') {
        $disk_used_percent = ($stats['disk_used'] / $stats['disk_limit']) * 100;

        if ($disk_used_percent > 90) {
            $notifications[] = [
                'title' => 'Disk Space Critical',
                'message' => 'Your account is using '.round($disk_used_percent).'% of allocated disk space',
                'type' => 'error',
                'time' => 'just now',
                'icon' => 'warning'
            ];
        } elseif ($disk_used_percent > 80) {
            $notifications[] = [
                'title' => 'Disk Space Warning',
                'message' => 'Your account is using '.round($disk_used_percent).'% of allocated disk space',
                'type' => 'warning',
                'time' => 'just now',
                'icon' => 'warning'
            ];
        }
    }

    return $notifications;
}
?>